# Working with strings

The String class contains methods that let you work with text strings. Strings
are important in working with many objects. The methods described here are
useful for working with strings used in objects such as TextField, StaticText,
XML, ContextMenu, and FileReference objects.

Strings are sequences of characters. ActionScript 3.0 supports ASCII and Unicode
characters.

- [Basics of strings](./basics-of-strings.md)
- [Creating strings](./creating-strings.md)
- [The length property](./the-length-property.md)
- [Working with characters in strings](./working-with-characters-in-strings.md)
- [Comparing strings](./comparing-strings.md)
- [Obtaining string representations of other objects](./obtaining-string-representations-of-other-objects.md)
- [Concatenating strings](./concatenating-strings.md)
- [Finding substrings and patterns in strings](./finding-substrings-and-patterns-in-strings.md)
- [Converting strings between uppercase and lowercase](./converting-strings-between-uppercase-and-lowercase.md)
- [Strings example: ASCII art](./strings-example-ascii-art.md)

More Help topics

![](../../img/flashplatformLinkIndicator.png)
[String class](https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/String.html)

![](../../img/flashplatformLinkIndicator.png)
[RegExp class](https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/RegExp.html)

![](../../img/flashplatformLinkIndicator.png)
[parseFloat() function](https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/package.html#parseFloat%28%29)

![](../../img/flashplatformLinkIndicator.png)
[parseInt() function](https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/package.html#parseInt%28%29)
