# Working with dates and times

Timing might not be everything, but it's usually a key factor in software
applications. ActionScript 3.0 provides powerful ways to manage calendar dates,
times, and time intervals. Two main classes provide most of this timing
functionality: the Date class and the new Timer class in the flash.utils
package.

Dates and times are a common type of information used in ActionScript programs.
For instance, you might need to know the current day of the week or to measure
how much time a user spends on a particular screen, among many other
possibilities. In ActionScript, you can use the Date class to represent a single
moment in time, including date and time information. Within a Date instance are
values for the individual date and time units, including year, month, date, day
of the week, hour, minutes, seconds, milliseconds, and time zone. For more
advanced uses, ActionScript also includes the Timer class, which you can use to
perform actions after a certain delay or at repeated intervals.

- [Managing calendar dates and times](./managing-calendar-dates-and-times.md)
- [Controlling time intervals](./controlling-time-intervals.md)
- [Date and time example: Simple analog clock](./date-and-time-example-simple-analog-clock.md)

More Help topics

![](../../img/flashplatformLinkIndicator.png)
[Date class](https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/Date.html)

![](../../img/flashplatformLinkIndicator.png)
[flash.utils.Timer class](https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/utils/Timer.html)
