# Working with arrays

Arrays allow you to store multiple values in a single data structure. You can
use simple indexed arrays that store values using fixed ordinal integer indexes
or complex associative arrays that store values using arbitrary keys. Arrays can
also be multidimensional, containing elements that are themselves arrays.
Finally, you can use a Vector for an array whose elements are all instances of
the same data type.

- [Basics of arrays](./basics-of-arrays.md)
- [Indexed arrays](./indexed-arrays.md)
- [Associative arrays](./associative-arrays.md)
- [Multidimensional arrays](./multidimensional-arrays.md)
- [Cloning arrays](./cloning-arrays.md)
- [Extending the Array class](./extending-the-array-class.md)
- [Arrays example: PlayList](./arrays-example-playlist.md)

More Help topics

![](../../img/flashplatformLinkIndicator.png)
[Array class](https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/Array.html)

![](../../img/flashplatformLinkIndicator.png)
[Vector class](https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/Vector.html)
