# Using regular expressions

A regular expression describes a pattern that is used to find and manipulate
matching text in strings. Regular expressions resemble strings, but they can
include special codes to describe patterns and repetition. For example, the
following regular expression matches a string that starts with the character A
followed by one or more sequential digits:

    /A\d+/

The following topics describe the basic syntax for constructing regular
expressions. However, regular expressions can have many complexities and
nuances. You can find detailed resources on regular expressions on the web and
in bookstores. Keep in mind that different programming environments implement
regular expressions in different ways. ActionScript 3.0 implements regular
expressions as defined in the ECMAScript edition 3 language specification
(ECMA-262).

- [Basics of regular expressions](./basics-of-regular-expressions.md)
- [Regular expression syntax](./regular-expression-syntax.md)
- [Methods for using regular expressions with strings](./methods-for-using-regular-expressions-with-strings.md)
- [Regular expressions example: A Wiki parser](./regular-expressions-example-a-wiki-parser.md)

More Help topics

![](../../img/flashplatformLinkIndicator.png)
[RegExp class](https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/RegExp.html)
