# Handling events

An event-handling system allows programmers to respond to user input and system
events in a convenient way. The ActionScript 3.0 event model is not only
convenient, but also standards-compliant, and well integrated with the display
list. Based on the Document Object Model (DOM) Level 3 Events Specification, an
industry-standard event-handling architecture, the new event model provides a
powerful yet intuitive event-handling tool for ActionScript programmers.

The ActionScript 3.0 event-handling system interacts closely with the display
list. To gain a basic understanding of the display list, read
[Display programming](../../display/index.md).

- [Basics of handling events](./basics-of-handling-events.md)
- [How ActionScript 3.0 event handling differs from earlier versions](./how-actionscript-3.0-event-handling-differs-from-earlier-versions.md)
- [The event flow](./the-event-flow.md)
- [Event objects](./event-objects.md)
- [Event listeners](./event-listeners.md)
- [Event handling example: Alarm Clock](./event-handling-example-alarm-clock.md)
