# Handling errors

To "handle" an error means that you build logic into your application to respond
to, or fix, an error. Errors are generated either when an application is
compiled or when a compiled application is running. When your application
handles errors, _something_ occurs as a response when the error is encountered,
as opposed to no response (when whatever process created the error fails
silently). Used correctly, error handling helps shield your application and its
users from otherwise unexpected behavior.

However, error handling is a broad category that includes responding to many
kinds of errors that are thrown during compilation or while an application is
running. This discussion focuses on how to handle run-time errors (thrown while
an application is running), the different types of errors that can be generated,
and the advantages of the error-handling system in ActionScript 3.0.

- [Basics of error handling](./basics-of-error-handling.md)
- [Types of errors](./types-of-errors.md)
- [Error handling in ActionScript 3.0](./error-handling-in-actionscript-3.0.md)
- [Working with the debugger versions of Flash runtimes](./working-with-the-debugger-versions-of-flash-runtimes.md)
- [Handling synchronous errors in an application](./handling-synchronous-errors-in-an-application.md)
- [Creating custom error classes](./creating-custom-error-classes.md)
- [Responding to error events and status](./responding-to-error-events-and-status.md)
- [Comparing the Error classes](./comparing-the-error-classes.md)
- [Handling errors example: CustomErrors application](./handling-errors-example-custom-errors-application.md)

More Help topics

![](../../img/flashplatformLinkIndicator.png)
[ActionScript language and syntax](https://web.archive.org/web/20150228102137/https://help.adobe.com/en_US/as3/learn/WS5b3ccc516d4fbf351e63e3d118a9b90204-7ec7.html)

![](../../img/flashplatformLinkIndicator.png)
[Object-oriented programming in ActionScript](https://web.archive.org/web/20151130063859/https://help.adobe.com/en_US/as3/learn/WS5b3ccc516d4fbf351e63e3d118a9b90204-7ec0.html)
