# Creating custom error classes

You can extend one of the standard Error classes to create your own specialized
error classes in ActionScript. There are a number of reasons to create your own
error classes:

- To identify specific errors or groups of errors that are unique to your
  application.

  For example, take different actions for errors thrown by your own code, in
  addition to those errors trapped by a Flash runtime. You can create a subclass
  of the Error class to track the new error data type in `try..catch` blocks.

- To provide unique error display capabilities for errors generated by your
  application.

  For example, you can create a new `toString()` method that formats your error
  messages in a certain way. You can also define a `lookupErrorString()` method
  that takes an error code and retrieves the proper message based on the user's
  language preference.

A specialized error class must extend the core ActionScript Error class. Here is
an example of a specialized AppError class that extends the Error class:

    public class AppError extends Error
    {
        public function AppError(message:String, errorID:int)
        {
            super(message, errorID);
        }
    }

The following shows an example of using AppError in your project:

    try
    {
        throw new AppError("Encountered Custom AppError", 29);
    }
    catch (error:AppError)
    {
        trace(error.errorID + ": " + error.message)
    }

> **Note:** If you want to override the `Error.toString()` method in your
> subclass, give it one `...` (rest) parameter. The ECMAScript language
> specification on which ActionScript 3.0 is based defines the
> `Error.toString()` method that way, and ActionScript 3.0 defines it the same
> way for backward compatibility. Therefore, when you override the
> `Error.toString()` method, match the parameters exactly. You do not want to
> pass any parameters to your `toString()` method at runtime, because those
> parameters are ignored.
