# Printing

Flash runtimes (such as Adobe® Flash® Player and Adobe® AIR™) can communicate
with an operating system's printing interface so that you can pass pages to the
print spooler. Each page sent to the spooler can contain content that is
visible, dynamic, or off screen to the user, including database values and
dynamic text. Additionally, the properties of the
[flash.printing.PrintJob class](https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/printing/PrintJob.html)
contain values based on a user's printer settings, so that you can format pages
appropriately.

The following content provides strategies for using the flash.printing.PrintJob
class methods and properties to create a print job, read a user's print
settings, and adjust a print job based on feedback from a Flash runtime and the
user's operating system.

- [Basics of printing](./basics-of-printing.md)
- [Printing a page](./printing-a-page.md)
- [Flash runtime tasks and system printing](./flash-runtime-tasks-and-system-printing.md)
- [Setting size, scale, and orientation](./setting-size-scale-and-orientation.md)
- [Advanced printing techniques](./advanced-printing-techniques.md)
- [Printing example: Multiple-page printing](./printing-example-multiple-page-printing.md)
- [Printing example: Scaling, cropping, and responding](./printing-example-scaling-cropping-and-responding.md)
- [Printing example: Page setup and print options](./printing-example-page-setup-and-print-options.md)
