# Geolocation

If a device supports geolocation, you can use the geolocation API to obtain the
current geographical location of the device. If the device supports this
feature, you can obtain geolocation information. This information includes the
altitude, accuracy, heading, speed, and timestamp of the latest change in the
location.

The Geolocation class dispatches `update` events in response to the device's
location sensor. The `update` event is a GeolocationEvent object.

- [Detecting geolocation changes](./detecting-geolocation-changes.md)

More Help topics

![](../../img/flashplatformLinkIndicator.png)
[flash.sensors.Geolocation](https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/sensors/Geolocation.html)

![](../../img/flashplatformLinkIndicator.png)
[flash.events.GeolocationEvent](https://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/flash/events/GeolocationEvent.html)

## Adobe recommends

> ### ![](../../img/flex_pasta.png) [Flex 4.5: Using Geolocation(GPS) on a mobile device](https://web.archive.org/web/20111213155444/http://www.flexpasta.com/index.php/2011/05/12/flex-45-using-geolocationgps-on-a-mobile-device)
>
> [Brian Telintelo: Flex Pasta](https://web.archive.org/web/20111210014203/http://www.flexpasta.com/)

> ### ![](../../img/gregWilson.png) [Geolocation tips and quirks](https://web.archive.org/web/20130406073319/http://gregsramblings.com/2011/09/08/geolocation-tips-quirks-bugs-flash-actionscript/)
>
> Greg Wilson
