# My Portal2-related stuff

## Config

I use fast forward (Shift key) in my playthroughs, just to save time. See my [autoexec.cfg](cfg/autoexec.cfg).
To record video I use default Windows 10 Gamebar video capture feature (Win+Alt+R) with the highest quality settings.

## Launchers

* [playbsp.cmd](launchers/playbsp.cmd) - runs Portal 2 maps (.bsp files, e.g. downloaded with [Steam Workshop Downloader](https://greasyfork.org/en/scripts/5729-enhanced-steam-workshop-downloader)).
* [playdem.cmd](launchers/playdem.cmd) - runs Portal 2 demos (.dem files)

## VRad

Portal 2 PTI editor uses vrad.exe to calculate ligthting, if it slows you down, you can use my [vrad.cpp](bin/vrad.cpp).
(Press Shift to skip the lighting stage.)
You also can temporarily replace stock vrad.exe with dummy exe that does nothing and returns errorlevel 0.

## Skins

Many players use custom skins for the portal gun. See skins folder for details. I use [Photoshop VTF Plugin](https://developer.valvesoftware.com/wiki/Photoshop_VTF_Plugin) to edit .vtf files.

You can also use command line tools:

* https://github.com/maxme/png2vtf
* https://github.com/eXeC64/vtf2png

## Portal colors

See [singleplayer portal colors tutorial](https://steamcommunity.com/sharedfiles/filedetails/?id=852095486)
and [changing the crosshair and portalgun effects to match your newly colored portals](https://www.moddb.com/mods/portal-infinitum/tutorials/changing-the-crosshair-and-portalgun-effects-to-match-your-newly-colored-portals).

I used RGB #ab0808 and #1db773 accordingly and "Image-Adjustments-Gradient Map" in Photoshop.

## Custom maps

I use stock Portal 2 PTI editor, [BEEmod](https://github.com/BEEmod/) and (occasionally) Hammer. My released maps added below.

File | Map Name
---|---
[1529333920.p2c](puzzles/76561198071734505/1529333920.p2c) | [Air Tiny](https://steamcommunity.com/sharedfiles/filedetails/?id=1415519901)
[1549696803.p2c](puzzles/76561198071734505/1549696803.p2c) | [Nacreous Classic](https://steamcommunity.com/sharedfiles/filedetails/?id=1649610131)
[1550088227.p2c](puzzles/76561198071734505/1550088227.p2c) | [Hell's Gate Part 2](https://steamcommunity.com/sharedfiles/filedetails/?id=1655015644)
[1578414794.p2c](puzzles/76561198071734505/1578414794.p2c) | [Print Classic](https://steamcommunity.com/sharedfiles/filedetails/?id=1967453744)
