<?php

$version = $version ?? '5.0.0'; // set in the build script by extracting it from the Version class
$majorVersion = $majorVersion ?? substr($version, 0, strpos($version, '.'));
$previousVersion = $previousRelease ?? '4.4.0'; // Last patch release
$previousMajorVersion = substr($previousVersion, 0, strpos($previousVersion, '.'));
$previousMajorMinorVersion = $previousMajorVersion . '.4';
$tagVersion = $tagVersion ?? $version; // Set in the build script by extracting it from git
$githubContent = $githubContent ?? []; // set by build script

$contributors = 'INSERT_HERE';
$pullRequests = 'INSERT_HERE';
$migrationInfo = '[New migration guide](https://manual.joomla.org/migrations/44-50/)';
$documentation = 'New developer [documentation](https://manual.joomla.org)';
$releasePage = 'https://www.joomla.org/announcements/release-news/5900-joomla-5-0-and-joomla-4-4-are-here';
$releaseDownloadPage = 'https://downloads.joomla.org/cms/joomla' . $majorVersion;
$changelog = 'https://github.com/joomla/joomla-cms/compare/' . $previousVersion .'...' . $tagVersion;
$githubDownloadLink = 'https://github.com/joomla/joomla-cms/releases/download/' . $tagVersion . '/';

$table = [];

foreach (['FULL', 'UPGRADE', 'MINOR', 'POINT'] as $type) {
    if (empty($githubContent[$type])) {
        continue;
    }

    $table[$type] = '';
    foreach($githubContent[$type] as $packageName => $hashes) {
        if (str_ends_with($packageName, '.zip')) {
            $table[$type] .= "| [ZIP Archive (.zip)]";
        } else if (str_ends_with($packageName, '.tar.gz')) {
            $table[$type] .= "| [GNU Zip Archive (.tar.gz)]";
        } else if (str_ends_with($packageName, '.tar.bz2')) {
            $table[$type] .= "| [Bzip2 Archive (.tar.zst)]";
        } else if (str_ends_with($packageName, '.tar.zst')) {
            $table[$type] .= "| [Zstandard Archive (.tar.zst)]";
        } else {
            // Unknown file types
            continue;
        }
        $table[$type] .= "({$githubDownloadLink}{$packageName}) | `" . $hashes['sha256'] . "` |\n";
    }
}

$echo = function($item) use ($table) {
    return $table[$item] ?? '';
};


// Release Information
$output = <<<MD

## 👀 Release information
* 💁 **{$contributors}**+ contributors
* 🧰 **{$pullRequests}**+ Pull Requests has been merged
* ⬆️ {$migrationInfo}
* 📖 {$documentation}
* 🌎 [Release page]({$releasePage})
* 👀 [Full Changelog]({$changelog})

MD;

// Download Information
$output .= <<<MD

## 🚀 Download information
> [!NOTE]
> Userfacing information about this Joomla! release can be found on the [release page]({$releasePage})

MD;

// Installation Packages
if (!empty($table['FULL'])):

$output .= <<<MD

### 🔥 Installation Packages

| New Joomla! Installations | SHA-256 Checksums |
|---------------------------|-------------------|
{$echo('FULL')}
> Additional and a second source of checksums can be found at our official [download page]({$releaseDownloadPage}). If you need further information on how to validate a release package please visit our [documentation](https://docs.joomla.org/How_to_determine_a_package_checksum).

MD;

endif;

// Update Packages
if (!empty($table['UPGRADE'])):

$output .= <<<MD

### ✒️ Upgrade Packages

> [!IMPORTANT]
> Don't update directly from a version lower than 4.4 it is important that you first update to 4.4 and then update to 5.x

| Update from a previous version | SHA-256 Checksums |
|--------------------------------|-------------------|
{$echo('UPGRADE')}
> Additional and a second source of checksums can be found at our official [download page]({$releaseDownloadPage}). If you need further information on how to validate a release package please visit our [documentation](https://docs.joomla.org/How_to_determine_a_package_checksum).

MD;
endif;

// Github autogenerated content, icon templates
$output .= <<<MD

## 💆 New Contributors

## 🧹 What has been changed

MD;

echo $output;
