# Joomla Contributor Covenant Code of Conduct

This document outlines the Code of Conduct for all persons volunteering their service to the Joomla Project and/or Open Source Matters. It covers your behaviour as a member of the Joomla community, in any forum, mailing list, Wiki, website, IRC channel, install-fest, public meeting or private correspondence. 

If you cannot agree to any of these principles, then volunteering in the Joomla Project is not for you. Contributing to our community assumes acceptance of these principles:
## Be Considerate

You are working with others as a team so be considerate of how your actions or contribution affects your colleagues and the community as a whole.
## Be Respectful

Treat one another and members of the community with respect. Everyone can make a valuable contribution to Joomla. We may not always agree, but disagreement is no excuse for poor behavior or poor manners.

We might all experience some frustration now and then, but we cannot allow that frustration to turn into a personal attack. It's important to remember that a community where people feel uncomfortable or threatened is not a productive one. We expect the members of Joomla community to be respectful when dealing with other volunteers as well as with people from outside projects and initiatives and with users.

Avoid becoming involved in flame wars, trolling, personal attacks, and repetitive arguments. Take the matters "outside" (off-list, etc) if it helps resolve the situation, and do not use communal methods of communication to be a vehicle for your private "wall of shame."
## Be Collaborative

Joomla is free software and about collaboration and working together. Collaboration reduces redundancy of work done in the free software world, and improves the quality of the software produced regardless of whether you are writing code or performing some other task.

When you disagree, consult others. Disagreements, both political and technical, happen all the time, and Joomla is no exception. Disagreement, debate and constructive criticism is often how progress is made and are a necessary part of doing complex work in a team.

The important goal is not to avoid disagreements or differing views but to resolve them constructively. Above all, avoid making conflicts about the work into personal conflicts. Debate should never include reference to someone's nationality, gender, religion or other personal characteristics.

You should turn to the community and to the community process to seek advice and to resolve disagreements. Team leaders and Department Coordinators are able to help you figure out which direction will be most acceptable.

When you are unsure, ask for help. Nobody knows everything and nobody is expected to be perfect. Asking questions avoids many problems down the road and so questions are encouraged. Those who are asked should be responsive and helpful. However, when asking a question, care must be taken to do so in an appropriate forum. Off-topic questions, such as requests for help on a development mailing list, detract from productive discussion.
## Step Down Considerately

People on every project come and go, and Joomla is no different. When you leave or disengage from the community, in whole or in part, we ask that you do so in a way that minimizes disruption to the Project. This means you should tell people you are leaving and take the proper steps to ensure that others can pick up where you leave off.
## Be Available

Check your e-mails regularly and answer them promptly—even if it's "I'll get back to you."
## Be Honest

Sometimes the hardest thing to say is "no" or admit you've forgotten to do something. Be honest with each other and yourself with regards to what you say and what you can realistically commit to.
## Follow the Rules

Volunteers are expected to uphold Joomla's licensing and trademark requirements including, but not limited to, compliance on their own or affiliate websites and extensions. Make sure you have sought the appropriate approvals for domain name, name and logo usage prior to volunteering and that any extensions you distribute comply with the Joomla license.

All work contributed to the Project, whether code, documentation or other material, must observe the appropriate licenses as set down by the Core Team and Open Source Matters.

Some contributors represent the Joomla Project in specific areas, but you should not speak on behalf of the Project or present yourself as an official representative of the Project unless you are specifically authorized to do so, and you should never state your opinions as the official policies of the Project.
## Exercise Discretion and Confidentiality at Appropriate Times

Depending on your role, you will be privy to various levels of information. As a volunteer you are expected to keep site access details (such as logins, FTP details, etc.) secure at all times.

Information contained within private forums (for example, about serious security matters, legal cases, or personal details), private mailing lists, chats or other mediums is also to be kept confidential even after you have discontinued your service. Breaches in the area of privacy and confidentiality are taken very seriously by the Project.
## Conflict of Interest

When using Project resources or making decisions within the board, your department, team, or subteam or the concerning Project's policy positions, you must do so based only on the best interests of the Project and its user community. If you have a situation or affiliation that might constitute or lead to a conflict of interest or might be perceived by a reasonable person in the community to be a conflict of interest, disclose this to your Team Leaders or the team as a whole. If appropriate, after discussing with your team, you should remove yourself from specific decisions or discussions in which you may have a conflict of interest.
## Conflict Resolution Team

Should you wish to make a CoC violation report or are facing a conflict that has failed to be resolved in the manner set out in this CoC, please [click here](https://docs.google.com/forms/d/e/1FAIpQLSea_VL9NUvUM3iX-gptNuJe5oz5-jp9y5Y4v9ZyKImblfYTcQ/viewform) to access the report form.
## The Fine Print

Members of the board of Open Source Matters are governed by additional guidelines and requirements and, where a conflict exists, these take precedence over this Code of Conduct.
## The Last Bit

This Code of Conduct has changed over time and will continue to develop, but was originally derived, with permission, from the Ubuntu CoC.

Last Updated 8th of June 2017
Online version of this document is available at https://www.joomla.org/about-joomla/the-project/code-of-conduct.html 
