import 'package:cloud_firestore/cloud_firestore.dart';
import 'package:firebase_core/firebase_core.dart';
import 'package:shared_preferences/shared_preferences.dart';

class DatabaseMethods {
  getUserInfo(String email) async {
    return FirebaseFirestore.instance
        .collection("users")
        .where("email", isEqualTo: email)
        .get()
        .catchError((e) {
      print(e.toString());
    });
  }

  getUserByUserEmail(String userEmail) async {
    return await FirebaseFirestore.instance
        .collection("users")
        .where("email", isEqualTo: userEmail)
        .get();
  }

  setUserInfo(userMap) {
    FirebaseFirestore.instance.collection("users").add(userMap).catchError((e) {
      print(e.toString());
    });
  }

  getAllLocations() async {
    return await FirebaseFirestore.instance
        .collection("locations")
        .orderBy("locationName")
        .get()
        .catchError((e) {
      print(e.toString());
    });
  }

  getLocationTripInfo(String locationName) async {
    return await FirebaseFirestore.instance
        .collection("locations")
        .where("locationName", isEqualTo: locationName)
        .get()
        .catchError((e) {
      print(e.toString());
    });
  }

  getLocationReviews(String locationName) async {
    return await FirebaseFirestore.instance
        .collection("reviews")
        .where("reviewLocation", isEqualTo: locationName)
        .get()
        .catchError((e) {
      print(e.toString());
    });
  }

  getLocationGallery(String locationName) async {
    return await FirebaseFirestore.instance
        .collection("galleries")
        .where("galleryLocation", isEqualTo: locationName)
        .get()
        .catchError((e) {
      print(e.toString());
    });
  }

  getGalleryImages(String locationName) async {
    return await FirebaseFirestore.instance
        .collection("galleries")
        .where("galleryLocation", isEqualTo: locationName)
        .get()
        .catchError((e) {
      print(e.toString());
    });
  }

  getUserFavorite(String locationName) async {
    return await FirebaseFirestore.instance
        .collection("favorites")
        .where("galleryLocation", isEqualTo: locationName)
        .get()
        .catchError((e) {
      print(e.toString());
    });
  }
}

class HelperFunctions {
  static String sharedPreferenceUserKey = "ISLOGGEDIN";
  static String sharedPreferenceUserNameKey = "USERNAMEKEY";
  static String sharedPreferenceUserEmailKey = "USEREMAILKEY";

  static Future<void> saveUserLoggedInPreference(bool userLoggedIn) async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    return await prefs.setBool(sharedPreferenceUserKey, userLoggedIn);
  }

  static Future<void> saveUserNamePreference(String userName) async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    return await prefs.setString(sharedPreferenceUserNameKey, userName);
  }

  static Future<void> saveUserEmailPreference(String userEmail) async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    return await prefs.setString(sharedPreferenceUserEmailKey, userEmail);
  }

  static Future<bool> getUserLoggedInPreference() async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    return prefs.getBool(sharedPreferenceUserKey);
  }

  static Future<String> getUserNamePreference() async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    return prefs.getString(sharedPreferenceUserNameKey);
  }

  static Future<void> getUserEmailPreference() async {
    SharedPreferences prefs = await SharedPreferences.getInstance();
    return prefs.getString(sharedPreferenceUserEmailKey);
  }
}
