var common;

module.exports = common = {

  /*
  	Checks to see if o is an object, and it isn't an instance
  	of some class.
   */
  isBareObject: function(o) {
    if ((o != null) && o.constructor === Object) {
      return true;
    }
    return false;
  },

  /*
  	Returns type of an object, including:
  	undefined, null, string, number, array,
  	arguments, element, textnode, whitespace, and object
   */
  typeOf: function(item) {
    var _ref;
    if (item === null) {
      return 'null';
    }
    if (typeof item !== 'object') {
      return typeof item;
    }
    if (Array.isArray(item)) {
      return 'array';
    }
    if (item.nodeName) {
      if (item.nodeType === 1) {
        return 'element';
      }
      if (item.nodeType === 3) {
        return (_ref = /\S/.test(item.nodeValue)) != null ? _ref : {
          'textnode': 'whitespace'
        };
      }
    } else if (typeof item.length === 'number') {
      if (item.callee) {
        return 'arguments';
      }
    }
    return typeof item;
  },
  clone: function(item, includePrototype) {
    if (includePrototype == null) {
      includePrototype = false;
    }
    switch (common.typeOf(item)) {
      case 'array':
        return common._cloneArray(item, includePrototype);
      case 'object':
        return common._cloneObject(item, includePrototype);
      default:
        return item;
    }
  },

  /*
  	Deep clone of an object.
  	From MooTools
   */
  _cloneObject: function(o, includePrototype) {
    var clone, key;
    if (includePrototype == null) {
      includePrototype = false;
    }
    if (common.isBareObject(o)) {
      clone = {};
      for (key in o) {
        clone[key] = common.clone(o[key], includePrototype);
      }
      return clone;
    } else {
      if (!includePrototype) {
        return o;
      }
      if (o instanceof Function) {
        return o;
      }
      clone = Object.create(o.constructor.prototype);
      for (key in o) {
        if (o.hasOwnProperty(key)) {
          clone[key] = common.clone(o[key], includePrototype);
        }
      }
      return clone;
    }
  },

  /*
  	Deep clone of an array.
  	From MooTools
   */
  _cloneArray: function(a, includePrototype) {
    var clone, i;
    if (includePrototype == null) {
      includePrototype = false;
    }
    i = a.length;
    clone = new Array(i);
    while (i--) {
      clone[i] = common.clone(a[i], includePrototype);
    }
    return clone;
  }
};

//# sourceMappingURL=data:application/json;base64,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