<p align="center">
    <img src="https://i.imgur.com/bztOLOO.png" />
</p>

<p align="center">
    <a href="https://runelite.net/plugin-hub/show/hydrate-reminder" alt="Plugin Rank">
        <img src="https://img.shields.io/endpoint?style=for-the-badge&url=https%3A%2F%2Fi.pluginhub.info%2Fshields%2Frank%2Fplugin%2Fhydrate-reminder" />
    </a>
    <a href="https://runelite.net/plugin-hub/show/hydrate-reminder" alt="Total Installs">
        <img src="https://img.shields.io/endpoint?style=for-the-badge&url=https%3A%2F%2Fi.pluginhub.info%2Fshields%2Finstalls%2Fplugin%2Fhydrate-reminder" />
    </a>
    <a href="https://github.com/jmakhack/hydrate-reminder/actions?query=workflow%3A%22Java+CI+with+Gradle%22" alt="Build Status">
        <img src="https://img.shields.io/github/workflow/status/jmakhack/hydrate-reminder/Java%20CI%20with%20Gradle?style=for-the-badge" />
    </a>
    <a href="https://www.codacy.com/gh/jmakhack/hydrate-reminder/dashboard" alt="Code Quality">
        <img alt="Codacy grade" src="https://img.shields.io/codacy/grade/acefd6d303a24a76b1aac55026a51398?style=for-the-badge">
    </a>
    <a href="#" alt="Repo Size">
        <img src="https://img.shields.io/github/repo-size/jmakhack/hydrate-reminder?style=for-the-badge" />
    </a>
    <a href="https://github.com/jmakhack/hydrate-reminder/issues" alt="Open Issues">
        <img src="https://img.shields.io/github/issues/jmakhack/hydrate-reminder?style=for-the-badge" />
    </a>
    <a href="https://github.com/jmakhack/hydrate-reminder/blob/master/LICENSE" alt="License">
        <img src="https://img.shields.io/github/license/jmakhack/hydrate-reminder?style=for-the-badge" />
    </a>
    <a href="https://github.com/jmakhack/hydrate-reminder/releases" alt="Version">
        <img src="https://img.shields.io/github/v/release/jmakhack/hydrate-reminder?style=for-the-badge" />
    </a>
    <a href="https://github.com/jmakhack/hydrate-reminder/releases" alt="Release Date">
        <img src="https://img.shields.io/github/release-date/jmakhack/hydrate-reminder?style=for-the-badge" />
    </a>
    <a href="#contributors-" alt="All Contributors">
        <img src="https://img.shields.io/github/all-contributors/jmakhack/hydrate-reminder?style=for-the-badge" />
    </a>
    <a href="https://github.com/jmakhack/hydrate-reminder/stargazers" alt="Stars">
        <img src="https://img.shields.io/github/stars/jmakhack/hydrate-reminder?color=orange&style=for-the-badge" />
    </a>
    <a href="https://youtu.be/3q5qD5Dv9_o" alt="Made With Love">
        <img src="https://img.shields.io/badge/Made%20With%20Love-(%E2%97%8F%E2%99%A1%E2%88%80%E2%99%A1))%E3%83%BE%E2%98%86*%E3%80%82-blueviolet?style=for-the-badge" />
    </a>
</p>

<br/>

Adventurers, it is always of critical importantance to keep hydrated.  
Never forget to drink water while exploring the world of Old School RuneScape ever again!

![hydrate_water_dance](https://user-images.githubusercontent.com/1442227/125190916-7ff58a00-e1f4-11eb-8566-1a10561c7fee.gif)

Any questions, comments, and/or feedback? Fill out the [feedback form](https://forms.gle/aZrqFvTP8LWZ1toi9).

## Plugin Features (v1.1.1)

Get a friendly reminder every x minutes to take a quick hydration break.

![hydrate_reminders](https://user-images.githubusercontent.com/1442227/125190578-bfbb7200-e1f2-11eb-9691-0d72419e4626.png)

<hr/>

Configure a variety of hydrate reminder settings such as:

-   Welcome message
    -   Enable/Disable
 
-   Hydrate reminder interval length
    -   Between 1 - 90 minutes
 
-   Notification types
    -   Chat message notification
        -   Game message notification
        -   Broadcast message notification
        -   Public chat notification
        -   Clan chat notification

    -   Computer tray notification

![Screen Shot 2021-07-19 at 7 46 18 PM](https://user-images.githubusercontent.com/1442227/126261031-6f1938fd-97bb-47b8-a2d1-3e7bfb64d038.png)

<hr/>
            
Use a variety of optional builtin chat commands to enhance the hydrate reminder experience:
-   `::hr help`
    -   Displays the list of available commands
   
-   `::hr next`
    -   Displays the amount of time until the next hydrate reminder
   
-   `::hr prev`
    -   Displays the amount of time since the previous hydrate reminder
   
-   `::hr reset`
    -   Resets the current hydrate reminder interval
   
-   `::hr hydrate`
    -   Resets the current hydrate reminder interval and increase hydration breaks
    
-   `::hr total`
    -   Displays the number of hydration breaks taken

![Screen Shot 2021-07-19 at 9 20 09 PM](https://user-images.githubusercontent.com/1442227/126261372-20d9954c-62a5-47a8-bf20-75d86e5349f2.png)

## Installation Instructions

This plugin is designed for use within the open source [RuneLite OSRS client](https://runelite.net/) which is free to download.

To install the plugin, start up the RuneLite client and search for the Hydrate Reminder plugin in the Plugin Hub.\
Detailed instructions on how to achieve this can be found on the [RuneLite wiki](https://github.com/runelite/runelite/wiki/Information-about-the-Plugin-Hub).

## Contributing

Anyone is welcome to contribute to this project repository in any capacity.  
Before contributing to this project, please go through the [How to Contribute](CONTRIBUTING.md) guide to understand expectations for this project and for info on how to properly setup and build the project.

Other useful resources include the [RuneLite wiki](https://github.com/runelite/runelite/wiki) and [OSRSBox's Writing RuneLite Plugins](https://www.osrsbox.com/blog/2018/08/10/writing-runelite-plugins-part-1-building/) blog post.  
It is recommended to use the [IntelliJ IDEA](https://www.jetbrains.com/idea/) development environment for this project.

To contribute any ideas, bug reports, and feedback, submit an [issue](https://github.com/jmakhack/hydrate-reminder/issues) or fill out the [feedback form](https://forms.gle/aZrqFvTP8LWZ1toi9).

## Code of Conduct

Hydrate Reminder is governed by the [Contributor Covenant v1.4](CODE_OF_CONDUCT.md).

## License

Hydrate Reminder is licensed under the [BSD-2-Clause License](LICENSE).

## Contributors ✨

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tbody>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/jmakhack"><img src="https://avatars.githubusercontent.com/u/1442227?v=4?s=100" width="100px;" alt="jmakhack"/><br /><sub><b>jmakhack</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=jmakhack" title="Tests">⚠️</a> <a href="#maintenance-jmakhack" title="Maintenance">🚧</a> <a href="https://github.com/jmakhack/hydrate-reminder/commits?author=jmakhack" title="Documentation">📖</a> <a href="https://github.com/jmakhack/hydrate-reminder/commits?author=jmakhack" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/sosnovska"><img src="https://avatars.githubusercontent.com/u/11365065?v=4?s=100" width="100px;" alt="sosnovska"/><br /><sub><b>sosnovska</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=sosnovska" title="Tests">⚠️</a> <a href="https://github.com/jmakhack/hydrate-reminder/commits?author=sosnovska" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/features/security"><img src="https://avatars.githubusercontent.com/u/27347476?v=4?s=100" width="100px;" alt="Dependabot"/><br /><sub><b>Dependabot</b></sub></a><br /><a href="#maintenance-dependabot" title="Maintenance">🚧</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://allcontributors.org"><img src="https://avatars.githubusercontent.com/u/46410174?v=4?s=100" width="100px;" alt="All Contributors"/><br /><sub><b>All Contributors</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=all-contributors" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/EmmanuelOlofintuyi"><img src="https://avatars.githubusercontent.com/u/46730204?v=4?s=100" width="100px;" alt="Emmanuel Olofintuyi"/><br /><sub><b>Emmanuel Olofintuyi</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=EmmanuelOlofintuyi" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/medkhabt"><img src="https://avatars.githubusercontent.com/u/34715586?v=4?s=100" width="100px;" alt="LOUKHNATI Mohamed Khalil"/><br /><sub><b>LOUKHNATI Mohamed Khalil</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=medkhabt" title="Code">💻</a> <a href="https://github.com/jmakhack/hydrate-reminder/commits?author=medkhabt" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/neilrush"><img src="https://avatars.githubusercontent.com/u/31221793?v=4?s=100" width="100px;" alt="Neil Rush"/><br /><sub><b>Neil Rush</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=neilrush" title="Code">💻</a> <a href="https://github.com/jmakhack/hydrate-reminder/commits?author=neilrush" title="Tests">⚠️</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://www.linkedin.com/in/paulritzman/"><img src="https://avatars.githubusercontent.com/u/37886407?v=4?s=100" width="100px;" alt="Paul Ritzman"/><br /><sub><b>Paul Ritzman</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=paulritzman" title="Code">💻</a> <a href="https://github.com/jmakhack/hydrate-reminder/commits?author=paulritzman" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/roymw09"><img src="https://avatars.githubusercontent.com/u/60860251?v=4?s=100" width="100px;" alt="roymw09"/><br /><sub><b>roymw09</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=roymw09" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/dcechano"><img src="https://avatars.githubusercontent.com/u/43017290?v=4?s=100" width="100px;" alt="dcechano"/><br /><sub><b>dcechano</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=dcechano" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://nebocode.github.io"><img src="https://avatars.githubusercontent.com/u/17943735?v=4?s=100" width="100px;" alt="NeboCode"/><br /><sub><b>NeboCode</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=NeboCode" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/hpa16"><img src="https://avatars.githubusercontent.com/u/29160872?v=4?s=100" width="100px;" alt="Harini Pa"/><br /><sub><b>Harini Pa</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=hpa16" title="Code">💻</a> <a href="https://github.com/jmakhack/hydrate-reminder/commits?author=hpa16" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/LiorBitton"><img src="https://avatars.githubusercontent.com/u/54041768?v=4?s=100" width="100px;" alt="Lior Bitton"/><br /><sub><b>Lior Bitton</b></sub></a><br /><a href="#maintenance-LiorBitton" title="Maintenance">🚧</a> <a href="https://github.com/jmakhack/hydrate-reminder/commits?author=LiorBitton" title="Code">💻</a> <a href="https://github.com/jmakhack/hydrate-reminder/commits?author=LiorBitton" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/goncalo-machado"><img src="https://avatars.githubusercontent.com/u/66827806?v=4?s=100" width="100px;" alt="goncalo-machado"/><br /><sub><b>goncalo-machado</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=goncalo-machado" title="Tests">⚠️</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/vlad-nitu"><img src="https://avatars.githubusercontent.com/u/95694456?v=4?s=100" width="100px;" alt="Nitu Vlad"/><br /><sub><b>Nitu Vlad</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=vlad-nitu" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/TrevorJames95"><img src="https://avatars.githubusercontent.com/u/44034050?v=4?s=100" width="100px;" alt="TrevorJames95"/><br /><sub><b>TrevorJames95</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=TrevorJames95" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Kh1ng"><img src="https://avatars.githubusercontent.com/u/89691651?v=4?s=100" width="100px;" alt="Kh1ng"/><br /><sub><b>Kh1ng</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=Kh1ng" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Diemarg"><img src="https://avatars.githubusercontent.com/u/47374512?v=4?s=100" width="100px;" alt="Diemarg"/><br /><sub><b>Diemarg</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=Diemarg" title="Code">💻</a> <a href="https://github.com/jmakhack/hydrate-reminder/commits?author=Diemarg" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/mslowiak"><img src="https://avatars.githubusercontent.com/u/18486535?v=4?s=100" width="100px;" alt="Marcin Słowiak"/><br /><sub><b>Marcin Słowiak</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=mslowiak" title="Code">💻</a> <a href="https://github.com/jmakhack/hydrate-reminder/commits?author=mslowiak" title="Tests">⚠️</a> <a href="#maintenance-mslowiak" title="Maintenance">🚧</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Krishpandya682"><img src="https://avatars.githubusercontent.com/u/76144309?v=4?s=100" width="100px;" alt="Krish Pandya"/><br /><sub><b>Krish Pandya</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=Krishpandya682" title="Code">💻</a> <a href="https://github.com/jmakhack/hydrate-reminder/commits?author=Krishpandya682" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/FinnPixel"><img src="https://avatars.githubusercontent.com/u/16624990?v=4?s=100" width="100px;" alt="Finn Frölich"/><br /><sub><b>Finn Frölich</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=FinnPixel" title="Code">💻</a> <a href="#maintenance-FinnPixel" title="Maintenance">🚧</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/sohamangoes"><img src="https://avatars.githubusercontent.com/u/35619727?v=4?s=100" width="100px;" alt="Soham Basu"/><br /><sub><b>Soham Basu</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=sohamangoes" title="Code">💻</a> <a href="https://github.com/jmakhack/hydrate-reminder/commits?author=sohamangoes" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://alexandrumihalache.com"><img src="https://avatars.githubusercontent.com/u/51009251?v=4?s=100" width="100px;" alt="Alexandru Mihalache"/><br /><sub><b>Alexandru Mihalache</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=AlexMihalache99" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/macslowiak"><img src="https://avatars.githubusercontent.com/u/94566117?v=4?s=100" width="100px;" alt="Maciej Słowiak"/><br /><sub><b>Maciej Słowiak</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=macslowiak" title="Code">💻</a> <a href="https://github.com/jmakhack/hydrate-reminder/commits?author=macslowiak" title="Tests">⚠️</a> <a href="https://github.com/jmakhack/hydrate-reminder/commits?author=macslowiak" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Jacoberson"><img src="https://avatars.githubusercontent.com/u/58759808?v=4?s=100" width="100px;" alt="Jacoberson"/><br /><sub><b>Jacoberson</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=Jacoberson" title="Code">💻</a> <a href="https://github.com/jmakhack/hydrate-reminder/commits?author=Jacoberson" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/aakash232"><img src="https://avatars.githubusercontent.com/u/67885496?v=4?s=100" width="100px;" alt="Aakash Tyagi"/><br /><sub><b>Aakash Tyagi</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=aakash232" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Kaushik-Iyer"><img src="https://avatars.githubusercontent.com/u/84177184?v=4?s=100" width="100px;" alt="Kaushik-Iyer"/><br /><sub><b>Kaushik-Iyer</b></sub></a><br /><a href="#maintenance-Kaushik-Iyer" title="Maintenance">🚧</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Zeesky-code"><img src="https://avatars.githubusercontent.com/u/71593672?v=4?s=100" width="100px;" alt="Zainab Lawal"/><br /><sub><b>Zainab Lawal</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=Zeesky-code" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://harikesh409.github.io/"><img src="https://avatars.githubusercontent.com/u/3501554?v=4?s=100" width="100px;" alt="Harikesh Pallantla"/><br /><sub><b>Harikesh Pallantla</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=harikesh409" title="Code">💻</a> <a href="https://github.com/jmakhack/hydrate-reminder/commits?author=harikesh409" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.youtube.com/lumary"><img src="https://avatars.githubusercontent.com/u/46068592?v=4?s=100" width="100px;" alt="Anja Bender"/><br /><sub><b>Anja Bender</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=Lumary2" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/utsav82"><img src="https://avatars.githubusercontent.com/u/92868052?v=4?s=100" width="100px;" alt="utsav82"/><br /><sub><b>utsav82</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=utsav82" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/akshatjainei"><img src="https://avatars.githubusercontent.com/u/93882347?v=4?s=100" width="100px;" alt="Akshat Jain"/><br /><sub><b>Akshat Jain</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=akshatjainei" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/swatichauhan814"><img src="https://avatars.githubusercontent.com/u/9282752?v=4?s=100" width="100px;" alt="Swati Chauhan"/><br /><sub><b>Swati Chauhan</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=swatichauhan814" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/sanmay321"><img src="https://avatars.githubusercontent.com/u/85834440?v=4?s=100" width="100px;" alt="Sanmay Das"/><br /><sub><b>Sanmay Das</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=sanmay321" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://ginglis.me"><img src="https://avatars.githubusercontent.com/u/43075615?v=4?s=100" width="100px;" alt="Gavin Inglis"/><br /><sub><b>Gavin Inglis</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=ginglis13" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/jivjen"><img src="https://avatars.githubusercontent.com/u/25795490?v=4?s=100" width="100px;" alt="jivjen"/><br /><sub><b>jivjen</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=jivjen" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/XoMute"><img src="https://avatars.githubusercontent.com/u/38501955?v=4?s=100" width="100px;" alt="Dmytro Khomutnyk"/><br /><sub><b>Dmytro Khomutnyk</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=XoMute" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/isurumaldeniya"><img src="https://avatars.githubusercontent.com/u/24438506?v=4?s=100" width="100px;" alt="Isuru Maldeniya"/><br /><sub><b>Isuru Maldeniya</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=isurumaldeniya" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/manish-singh-bisht"><img src="https://avatars.githubusercontent.com/u/114493480?v=4?s=100" width="100px;" alt="Manish Singh Bisht"/><br /><sub><b>Manish Singh Bisht</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=manish-singh-bisht" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Akshu-on-github"><img src="https://avatars.githubusercontent.com/u/61582763?v=4?s=100" width="100px;" alt="Akshaya Kulasekaran"/><br /><sub><b>Akshaya Kulasekaran</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=Akshu-on-github" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/NNRepos"><img src="https://avatars.githubusercontent.com/u/45516943?v=4?s=100" width="100px;" alt="nn"/><br /><sub><b>nn</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=NNRepos" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/kat-kan"><img src="https://avatars.githubusercontent.com/u/17500766?v=4?s=100" width="100px;" alt="Katarzyna"/><br /><sub><b>Katarzyna</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=kat-kan" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/AbbasSalloum"><img src="https://avatars.githubusercontent.com/u/63022908?v=4?s=100" width="100px;" alt="AbbasSalloum"/><br /><sub><b>AbbasSalloum</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=AbbasSalloum" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://pwnb0y.medium.com/"><img src="https://avatars.githubusercontent.com/u/96813659?v=4?s=100" width="100px;" alt="Vicky Aryan"/><br /><sub><b>Vicky Aryan</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=pwnb0y" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/mohitkumaragrawal"><img src="https://avatars.githubusercontent.com/u/44193587?v=4?s=100" width="100px;" alt="mohitkumaragrawal"/><br /><sub><b>mohitkumaragrawal</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=mohitkumaragrawal" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/A-5ingh"><img src="https://avatars.githubusercontent.com/u/32884734?v=4?s=100" width="100px;" alt="A. Singh"/><br /><sub><b>A. Singh</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=A-5ingh" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/90r1ll4"><img src="https://avatars.githubusercontent.com/u/45795129?v=4?s=100" width="100px;" alt="G0R1LL4"/><br /><sub><b>G0R1LL4</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=90r1ll4" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://akshat-rawat.github.io/"><img src="https://avatars.githubusercontent.com/u/78139798?v=4?s=100" width="100px;" alt="Akshat Rawat"/><br /><sub><b>Akshat Rawat</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=akshat-rawat" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/vikash485"><img src="https://avatars.githubusercontent.com/u/114328709?v=4?s=100" width="100px;" alt="Vikash"/><br /><sub><b>Vikash</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=vikash485" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/jhonDoe15"><img src="https://avatars.githubusercontent.com/u/62393042?v=4?s=100" width="100px;" alt="jhonDoe15"/><br /><sub><b>jhonDoe15</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=jhonDoe15" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/manaslohani"><img src="https://avatars.githubusercontent.com/u/51227394?v=4?s=100" width="100px;" alt="spacecowboy"/><br /><sub><b>spacecowboy</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=manaslohani" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/ron-huberfeld"><img src="https://avatars.githubusercontent.com/u/32178925?v=4?s=100" width="100px;" alt="Ron Huberfeld"/><br /><sub><b>Ron Huberfeld</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=ron-huberfeld" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.linkedin.com/in/arsh-ergon/"><img src="https://avatars.githubusercontent.com/u/40994679?v=4?s=100" width="100px;" alt="Mohd Arsh Ali "/><br /><sub><b>Mohd Arsh Ali </b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=ArshErgon" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/sanjeev0210"><img src="https://avatars.githubusercontent.com/u/70718662?v=4?s=100" width="100px;" alt="Sanjeev Bengeri"/><br /><sub><b>Sanjeev Bengeri</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=sanjeev0210" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/SaranshBaniyal"><img src="https://avatars.githubusercontent.com/u/23008139?v=4?s=100" width="100px;" alt="AstroITNinja"/><br /><sub><b>AstroITNinja</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=SaranshBaniyal" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Aravind22"><img src="https://avatars.githubusercontent.com/u/16496982?v=4?s=100" width="100px;" alt="Aravind"/><br /><sub><b>Aravind</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=Aravind22" title="Code">💻</a> <a href="https://github.com/jmakhack/hydrate-reminder/commits?author=Aravind22" title="Tests">⚠️</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://www.linkedin.com/in/davide-donadio-404-not-found/"><img src="https://avatars.githubusercontent.com/u/19550424?v=4?s=100" width="100px;" alt="Davide Donadio"/><br /><sub><b>Davide Donadio</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=ZarakiKanzaki" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.stopstalk.com/user/profile/PrajwalRayal"><img src="https://avatars.githubusercontent.com/u/97100770?v=4?s=100" width="100px;" alt="Prajwal Rayal"/><br /><sub><b>Prajwal Rayal</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=Prajwalrayal" title="Code">💻</a> <a href="https://github.com/jmakhack/hydrate-reminder/commits?author=Prajwalrayal" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/MrinaliniU"><img src="https://avatars.githubusercontent.com/u/9332293?v=4?s=100" width="100px;" alt="Mrinalini Upadhya"/><br /><sub><b>Mrinalini Upadhya</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=MrinaliniU" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/PetraJankurova"><img src="https://avatars.githubusercontent.com/u/97254662?v=4?s=100" width="100px;" alt="PetraJankurova"/><br /><sub><b>PetraJankurova</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=PetraJankurova" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://linkedin.com/in/danishayubkhan/"><img src="https://avatars.githubusercontent.com/u/34853491?v=4?s=100" width="100px;" alt="Danish Ayub Khan"/><br /><sub><b>Danish Ayub Khan</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=ddanishkhan" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/ssiidd"><img src="https://avatars.githubusercontent.com/u/14967816?v=4?s=100" width="100px;" alt="Sid"/><br /><sub><b>Sid</b></sub></a><br /><a href="https://github.com/jmakhack/hydrate-reminder/commits?author=ssiidd" title="Code">💻</a></td>
    </tr>
  </tbody>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!
