# MQB soundaktor

The soundaktor (German for "sound actuator") is a vehicle audio system used to simulate engine noise in the cabin of MQB vehicles.

![Soundaktor](https://github.com/jilleb/mqb-soundaktor/blob/9e37063de8729258620701f0f63c91376dcf7cd0/images/soundaktor.png)

This repository is meant to research the details inside the soundaktor firmware, in specific the FL_xx__x.odx.FD_2DATA.BIN file.

[!["Buy Me A Coffee"](https://www.buymeacoffee.com/assets/img/custom_images/orange_img.png)](https://www.buymeacoffee.com/jille)


## Requirements
- A MQB platform vehicle
- MQB soundaktor
- Hex-editing skills
- [010 editor](https://www.sweetscape.com/010editor/)
- A good pair of brains
- Common sense
- No fear of bricking your hardware or losing your warranty
- An inquisitive mindset
- No bad intentions.

## Usage

### FL_xx__x.odx.FD_2DATA.BIN.bt
This is the main template, which can parse raw binary data from a dataset in 010 editor.


## Wiki
The place where the entire dataset is described and explored. Firmware downloads can be found there as well. Check it out [here](../..//wiki). 

## Contributing

Everyone can contribute to this project in some way. You can make your own dataset changes and test them, and report back. If you have any suggestions or changes to the template or script, feel free to make a pull request. Also, if you have any firmwares that aren't already on this repository, please share them!

## Disclaimer

Most of the knowledge shared on this repository was gathered, analyzed and tested by me and friends. Be careful when you edit "random stuff" inside the firmware files. Most of it is pretty harmless, but if there's a warning somewhere you can definitely count on it that this warning came from experiencing some crazy situation. So don't be a douche, be careful. And don't be a super-douche: don't sell this knowledge as your own property. In short: Be careful, be safe, be nice. Thanks!

Also: this research is strictly for fun and for the educational value. It's never my intention to harm anyone, any car or any company. As far as my limited legal knowledge goes, there's nothing illegal to this research. If you think it might break any law or can be harmful in any way to anyone, please let me know. 

<!-- LICENSE -->
## License
See [LICENSE](https://github.com/jilleb/mqb-soundaktor/blob/main/LICENSE)	 for more information.
