"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __esm = (fn, res) => function __init() {
  return fn && (res = (0, fn[__getOwnPropNames(fn)[0]])(fn = 0)), res;
};
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var __publicField = (obj, key, value) => {
  __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var __accessCheck = (obj, member, msg) => {
  if (!member.has(obj))
    throw TypeError("Cannot " + msg);
};
var __privateGet = (obj, member, getter) => {
  __accessCheck(obj, member, "read from private field");
  return getter ? getter.call(obj) : member.get(obj);
};
var __privateAdd = (obj, member, value) => {
  if (member.has(obj))
    throw TypeError("Cannot add the same private member more than once");
  member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
};
var __privateSet = (obj, member, value, setter) => {
  __accessCheck(obj, member, "write to private field");
  setter ? setter.call(obj, value) : member.set(obj, value);
  return value;
};
var __privateMethod = (obj, member, method) => {
  __accessCheck(obj, member, "access private method");
  return method;
};

// out/util/util.js
var require_util = __commonJS({
  "out/util/util.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.reg = exports2.getVuePrefix = exports2.getWord = exports2.getRelativePath = exports2.getCurrentWord = exports2.getTabSize = exports2.getWorkspaceRoot = exports2.winRootPathHandle = void 0;
    var vscode_1 = require("vscode");
    var os2 = require("os");
    var path3 = require("path");
    function winRootPathHandle(pagePath) {
      if (!pagePath) {
        return "";
      }
      if (os2.platform().includes("win") && pagePath.length > 0 && (pagePath[0] === "\\" || pagePath[0] === "/")) {
        return pagePath.substr(1, pagePath.length);
      } else {
        return pagePath;
      }
    }
    exports2.winRootPathHandle = winRootPathHandle;
    function getWorkspaceRoot(documentUrl) {
      var _a, _b;
      let url = "";
      if (((_a = vscode_1.workspace.workspaceFolders) === null || _a === void 0 ? void 0 : _a.length) === 1) {
        return winRootPathHandle(vscode_1.workspace.workspaceFolders[0].uri.path);
      }
      (_b = vscode_1.workspace.workspaceFolders) === null || _b === void 0 ? void 0 : _b.forEach((workspaceFolder) => {
        if (documentUrl.includes(workspaceFolder.uri.path.replace(/.*:\//gi, "/"))) {
          url = workspaceFolder.uri.path;
        }
      });
      return winRootPathHandle(url);
    }
    exports2.getWorkspaceRoot = getWorkspaceRoot;
    function getTabSize() {
      const tabSize = vscode_1.workspace.getConfiguration("editor").tabSize;
      let space = "";
      for (let i = 0; i < tabSize; i++) {
        space += " ";
      }
      if (space.length === 0) {
        space = "  ";
      }
      return space;
    }
    exports2.getTabSize = getTabSize;
    function getCurrentWord(document2, position) {
      let i = position.character - 1;
      const text = document2.lineAt(position.line).text;
      while (i >= 0 && ' 	\n\r\v":{[,'.indexOf(text.charAt(i)) === -1) {
        i--;
      }
      return text.substring(i + 1, position.character);
    }
    exports2.getCurrentWord = getCurrentWord;
    function getRelativePath(src, dist) {
      let vfPath = path3.relative(winRootPathHandle(src), dist);
      vfPath = vfPath.replace(/\\/gi, "/");
      if (vfPath.startsWith("../")) {
        vfPath = vfPath.substr(1, vfPath.length);
      }
      return vfPath;
    }
    exports2.getRelativePath = getRelativePath;
    function getWord(document2, position, textSplite) {
      const line = document2.lineAt(position.line);
      let posIndex = position.character;
      let textSingle = line.text.substring(posIndex, posIndex + 1);
      let selectText = "";
      while (textSplite.indexOf(textSingle) === -1 && posIndex <= line.text.length) {
        selectText += textSingle;
        ++posIndex;
        textSingle = line.text.substring(posIndex, posIndex + 1);
      }
      posIndex = position.character - 1;
      textSingle = line.text.substring(posIndex, posIndex + 1);
      while (textSplite.indexOf(textSingle) === -1 && posIndex > 0) {
        selectText = textSingle + selectText;
        --posIndex;
        textSingle = line.text.substring(posIndex, posIndex + 1);
      }
      textSingle = line.text.substring(posIndex, posIndex + 1);
      return {
        selectText,
        startText: textSingle
      };
    }
    exports2.getWord = getWord;
    function getVuePrefix(document2, position) {
      const line = document2.lineAt(position.line);
      let posIndex = position.character;
      let textSingle = line.text.substring(posIndex, posIndex + 1);
      let textSplite = [" "];
      while (textSplite.indexOf(textSingle) === -1 && posIndex > 0) {
        --posIndex;
        textSingle = line.text.substring(posIndex, posIndex + 1);
      }
      return line.text.substring(posIndex + 1, posIndex + 2);
    }
    exports2.getVuePrefix = getVuePrefix;
    exports2.reg = {
      variable: (name) => {
        return new RegExp(`.*[const|var|let]\\s*${name}.*`, "gi");
      },
      func: (name) => {
        return new RegExp(`.*function\\s*${name}.*`, "gi");
      },
      varFunc: (name) => {
        return new RegExp(`.*([const|var|let|function]\\s*${name})|(${name}\\s*:).*`, "gi");
      }
    };
  }
});

// out/util/traverse.js
var require_traverse = __commonJS({
  "out/util/traverse.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    var fs = require("fs");
    var path3 = require("path");
    var Traverse = class {
      constructor(explorer, prefix) {
        this.commentKeys = ["description", "type", "default", "enum", "example"];
        this.propKeys = ["type", "default", "required"];
        this.explorer = explorer;
        this.prefix = prefix;
      }
      search(poster, searchName, usePrefix) {
        let files = [];
        let cond;
        let componentPath = "";
        let prefix = usePrefix ? this.prefix : {};
        if (!this.explorer.projectRootPath) {
          return [];
        }
        if (componentPath && Array.isArray(componentPath) && componentPath.length > 0) {
          cond = function(rootPath) {
            return componentPath.indexOf(rootPath) !== -1;
          };
        } else {
          let ignore = ["node_modules", "dist", "build"];
          cond = function(rootPath) {
            return !(rootPath.charAt(0) === "." || ignore.indexOf(rootPath) !== -1);
          };
        }
        let rootPathes = fs.readdirSync(this.explorer.projectRootPath || "");
        for (let i = 0; i < rootPathes.length; i++) {
          const rootPath = rootPathes[i];
          if (cond(rootPath)) {
            let stat = fs.statSync(path3.join(this.explorer.projectRootPath || "", rootPath));
            if (stat.isDirectory()) {
              this.traverseHandle(rootPath, files, prefix, poster, searchName);
            } else {
              this.traverseAdd(rootPath, rootPath, files, prefix, poster, searchName);
            }
          }
        }
        return files;
      }
      traverseAdd(rootPath, dir, files, prefix, poster, search) {
        if (rootPath.endsWith(poster)) {
          let posterReg = new RegExp("-?(.*)" + (poster ? poster : "\\.\\w*") + "$", "gi");
          let name = rootPath;
          name = name.replace(posterReg, "$1");
          if (!search || search && dir.includes(search)) {
            files.push({
              name,
              path: dir.replace(new RegExp(`^${prefix.path}`, "gi"), prefix.alias).replace(/\\/gi, "/")
            });
            if (name === "index") {
              name = dir.replace(/\\/gi, "/").replace(/.*\/(\w*)\/\w*.\w*/gi, "$1");
              files.push({
                name,
                path: dir.replace(new RegExp(`^${prefix.path}`, "gi"), prefix.alias).replace(/\\/gi, "/")
              });
            }
          }
        }
      }
      traverseHandle(postPath, files, prefix, poster, search) {
        let fileDirs = fs.readdirSync(path3.join(this.explorer.projectRootPath || "", postPath));
        for (let i = 0; i < fileDirs.length; i++) {
          const rootPath = fileDirs[i];
          if (!(rootPath.charAt(0) === ".")) {
            let dir = path3.join(postPath, rootPath);
            let stat = fs.statSync(path3.join(this.explorer.projectRootPath || "", dir));
            if (stat.isDirectory()) {
              this.traverseHandle(dir, files, prefix, poster, search);
            } else {
              this.traverseAdd(rootPath, dir, files, prefix, poster, search);
            }
          }
        }
      }
      component(vueVersion) {
        if (vueVersion === "2") {
          return this.componentV2();
        } else {
          return this.componentV3();
        }
      }
      componentV3() {
        let mainPath = path3.join(this.explorer.projectRootPath, "src/main." + (this.explorer.isTs ? "ts" : "js"));
        if (fs.existsSync(mainPath)) {
          return this.findCommon(mainPath, true, "");
        }
        return {
          plugin: [],
          component: []
        };
      }
      componentV2() {
        let mainPath = path3.join(this.explorer.projectRootPath, "src/main." + (this.explorer.isTs ? "ts" : "js"));
        if (fs.existsSync(mainPath)) {
          return this.findCommon(mainPath, true, "");
        }
        return {
          plugin: [],
          component: []
        };
      }
      findCommon(filePath, isMain, refVar) {
        const common = {
          plugin: [],
          component: []
        };
        const main = fs.readFileSync(filePath, "utf-8");
        const mainList = main.split("\n");
        const mainImportKv = {};
        const vars = {};
        let foreachVar = "";
        let isVar = false;
        let isFor = false;
        let varName = "";
        let varText = "";
        let isImport = false;
        let importText = "";
        let appVar = "Vue";
        let appReg = new RegExp(`\\(\\s*${appVar}\\s*\\)`, "gi");
        let createAppReg = new RegExp(`${refVar || "createApp"}\\s*\\(\\s*.*\\s*\\)`, "gi");
        mainList.forEach((mainLine, mainIndex) => {
          if (mainLine.includes("import")) {
            isImport = true;
            if (mainLine.includes("{")) {
              if (mainLine.includes("from")) {
                this.explorer.parseImport(mainLine, mainImportKv, mainLine, mainIndex);
                isImport = false;
              } else {
                importText += mainLine;
              }
            } else {
              this.explorer.parseImport(mainLine, mainImportKv, mainLine, mainIndex);
              isImport = false;
            }
          } else if (isImport) {
            importText += mainLine;
            if (mainLine.includes("from")) {
              importText += mainLine;
              this.explorer.parseImport(importText, mainImportKv, mainLine, mainIndex);
              importText = "";
              isImport = false;
            }
          } else if (createAppReg.test(mainLine)) {
            if (isMain) {
              appVar = mainLine.replace(/\s*(let|const|var)\s/gi, "").replace(/\s*=.*/gi, "").trim();
              appReg = new RegExp(`\\(\\s*${appVar}\\s*\\)`, "gi");
            } else {
              appVar = mainLine.replace(/.*\(/gi, "").replace(/\).*/gi, "").trim().replace(/\s.*/gi, "").replace(/:.*/gi, "").trim();
              appReg = new RegExp(`\\(\\s*${appVar}\\s*\\)`, "gi");
            }
          } else if (appReg.test(mainLine)) {
            let name = mainLine.replace(/\(.*/gi, "").trim();
            const refInfo = mainImportKv[name];
            if (refInfo && refInfo.position === "1") {
              let refPath = "";
              if (refInfo.path.includes(this.explorer.prefix.alias + "/")) {
                refPath = path3.join(this.explorer.projectRootPath, refInfo.path.replace(this.explorer.prefix.alias, this.explorer.prefix.path));
              } else {
                refPath = path3.join(filePath, "..", refInfo.path);
              }
              if (!refPath.includes(".")) {
                if (fs.existsSync(refPath + ".js")) {
                  refPath = refPath + ".js";
                } else if (fs.existsSync(refPath + ".ts")) {
                  refPath = refPath + ".ts";
                } else if (fs.existsSync(refPath + ".vue")) {
                  refPath = refPath + ".vue";
                } else {
                  return;
                }
              }
              if (isMain) {
                if (fs.existsSync(refPath)) {
                  const refCommon = this.findCommon(refPath, false, refInfo.type === "module" ? "export default" : name);
                  refCommon.component.forEach((refComponent) => {
                    common.component.push(refComponent);
                  });
                  refCommon.plugin.forEach((refPlugin) => {
                    common.plugin.push(refPlugin);
                  });
                }
              } else if (refVar) {
                if (fs.existsSync(refPath)) {
                  const refCommon = this.findCommon(refPath, false, "");
                  refCommon.component.forEach((refComponent) => {
                    common.component.push(refComponent);
                  });
                  refCommon.plugin.forEach((refPlugin) => {
                    common.plugin.push(refPlugin);
                  });
                }
              }
            }
          } else if (/(let|const|var)\s/gi.test(mainLine)) {
            varName = mainLine.replace(/\s*(let|const|var)\s/gi, "").replace(/\s*=.*/gi, "");
            isVar = true;
            varText = mainLine;
            if (mainLine.includes("]") || mainLine.includes("}")) {
              vars[varName.trim()] = this.explorer.getVarProperties(varText);
              isVar = false;
            }
          } else if (isVar) {
            varText += mainLine;
            if (mainLine.includes("]") || mainLine.includes("}")) {
              vars[varName.trim()] = this.explorer.getVarProperties(varText);
              isVar = false;
            }
          } else if (mainLine.includes(".use")) {
            if (isFor) {
              const forComponents = vars[foreachVar];
              if (forComponents) {
                forComponents.forEach((componentName) => {
                  const componentInfo = mainImportKv[componentName];
                  if (componentInfo) {
                    common.plugin.push({
                      name: componentName,
                      from: componentInfo.position === "2" ? componentInfo.path.replace(/.*\//gi, "") : "",
                      item: componentInfo,
                      file: filePath
                    });
                  }
                });
              }
            } else {
              const pluginName = mainLine.replace(/.*\((.*)\).*/gi, "$1").replace(/,.*/gi, "").trim();
              const pluginInfo = mainImportKv[pluginName];
              if (pluginInfo) {
                common.plugin.push({
                  name: pluginName,
                  from: pluginInfo.position === "2" ? pluginInfo.path.replace(/.*\//gi, "") : "",
                  item: pluginInfo,
                  file: filePath
                });
                if (pluginInfo.position === "1") {
                  if (isMain || refVar) {
                    let usePath = path3.join(this.explorer.projectRootPath, pluginInfo.path.replace(this.explorer.prefix.alias, this.explorer.prefix.path));
                    if (!usePath.includes(".")) {
                      if (fs.existsSync(usePath + ".js")) {
                        usePath = usePath + ".js";
                      } else if (fs.existsSync(usePath + ".ts")) {
                        usePath = usePath + ".ts";
                      } else if (fs.existsSync(usePath + ".vue")) {
                        usePath = usePath + ".vue";
                      } else {
                        return;
                      }
                    }
                    if (fs.existsSync(usePath)) {
                      const useCommon = this.findCommon(usePath, false, "");
                      useCommon.component.forEach((useComponent) => {
                        common.component.push(useComponent);
                      });
                      useCommon.plugin.forEach((usePlugin) => {
                        common.plugin.push(usePlugin);
                      });
                    }
                  }
                }
              }
            }
          } else if (mainLine.includes(".component")) {
            if (isFor) {
              const forComponents = vars[foreachVar];
              if (forComponents) {
                forComponents.forEach((componentName) => {
                  const componentInfo = mainImportKv[componentName];
                  if (componentInfo) {
                    common.component.push({
                      name: componentName,
                      from: componentInfo.position === "2" ? componentInfo.path.replace(/.*\//gi, "") : "",
                      item: componentInfo,
                      file: filePath
                    });
                  }
                });
              }
            } else {
              const componentArr = mainLine.replace(/.*\((.*)\).*/gi, "$1").split(",");
              if (componentArr.length === 2) {
                let componentInfo = mainImportKv[componentArr[1].trim()];
                if (componentInfo) {
                  let componentName = componentArr[0].trim();
                  if (componentName.includes(".")) {
                    common.component.push({
                      name: componentName.replace(/\.*/gi, ""),
                      from: componentInfo.position === "2" ? componentInfo.path.replace(/.*\//gi, "") : "",
                      item: componentInfo,
                      file: filePath
                    });
                  } else {
                    common.component.push({
                      name: componentName.replace(/('|")/gi, ""),
                      from: componentInfo.position === "2" ? componentInfo.path.replace(/.*\//gi, "") : "",
                      item: componentInfo,
                      file: filePath
                    });
                  }
                }
              }
            }
          } else if (mainLine.includes(".forEach")) {
            foreachVar = mainLine.replace(/\.forEach.*/gi, "").trim();
            isFor = true;
          }
          if (mainLine.includes("}")) {
            isFor = false;
          }
        });
        return common;
      }
      initLocalComponent() {
        if (this.explorer.projectConfig.component && this.explorer.projectConfig.component.scope) {
          const scopeList = this.explorer.projectConfig.component.scope;
          scopeList.forEach((scope) => {
            let componentList = this.searchLocalComponent(scope);
            this.explorer.localVues[scope] = componentList;
            componentList.forEach((comp) => {
              this.explorer.localAttrs[comp.path + comp.name] = comp;
            });
          });
        }
      }
      traverseHandleLocalComponent(postPath, files) {
        let fileDirs = fs.readdirSync(path3.join(this.explorer.projectRootPath || "", postPath));
        for (let i = 0; i < fileDirs.length; i++) {
          const rootPath = fileDirs[i];
          if (!(rootPath.charAt(0) === ".")) {
            let dir = path3.join(postPath, rootPath);
            let stat = fs.statSync(path3.join(this.explorer.projectRootPath || "", dir));
            if (stat.isDirectory()) {
              this.traverseHandleLocalComponent(dir, files);
            } else {
              this.traverseAddLocalComponent(rootPath, dir, files);
            }
          }
        }
      }
      traverseAddLocalComponent(rootPath, dir, files) {
        if (dir.endsWith(".vue")) {
          try {
            let cFile = fs.readFileSync(path3.join(this.explorer.projectRootPath, dir), "utf-8");
            let cName = rootPath.replace(/\..*/gi, "");
            let emits = {};
            let props = {};
            let slots = {};
            let cComment = null;
            let fileName = cName;
            if (cName === "index" || cName === "Index") {
              cName = dir.replace(/\\/gi, "/").replace(/.*\/(\w*)\/\w*.\w*/gi, "$1");
            }
            if (dir.includes(".vue")) {
              const slotList = cFile.match(/<slot\s[^>]*>/gi);
              if (slotList) {
                for (let i = 0; i < slotList.length; i++) {
                  const slotItem = slotList[i];
                  let slotName = "default";
                  if (slotItem.includes("name=")) {
                    if (!slotItem.includes(":name=")) {
                      slotName = slotItem.replace(/.*\sname="/gi, "").replace(/".*/gi, "");
                    }
                  }
                  slots[slotName] = [];
                  const slotFields = slotItem.match(/[\w-]*=/gi);
                  if (slotFields) {
                    slotFields.forEach((slotField) => {
                      const slotFieldName = slotField.replace(/=/gi, "");
                      if (slotFieldName && !(slotFieldName === "name" || slotFieldName === "v-if" || slotFieldName === "v-for")) {
                        slots[slotName].push(slotFieldName);
                      }
                    });
                  }
                }
              }
              cFile = cFile.replace(/.*<script/gi, "").replace(/<\/script.*/gi, "");
              let componentLines = cFile.split("\n");
              let isDefine = false;
              let inProps = false;
              let propType = "";
              let inPropsDefault = false;
              let braceLeftCount = 0;
              let comment = {};
              let commentKey = "description";
              let inComments = false;
              let propName = "";
              let smallBracketCount = 0;
              let emitText = "";
              let commentLine = 0;
              let hasDefineEmits = false;
              for (let i = 0; i < componentLines.length; i++) {
                const text = componentLines[i];
                if (/export\s*default\s*defineComponent/gi.test(text)) {
                  isDefine = true;
                  let braceLeftList2 = text.match(/{/gi);
                  braceLeftCount += braceLeftList2 ? braceLeftList2.length : 0;
                  continue;
                }
                let braceLeftList = text.match(/{/gi);
                let braceRightList = text.match(/}/gi);
                let braceLeft = braceLeftList ? braceLeftList.length : 0;
                let braceRight = braceRightList ? braceRightList.length : 0;
                braceLeftCount += braceLeft - braceRight;
                if (text.includes("*/")) {
                  inComments = false;
                  commentLine = i;
                  if (braceLeftCount === 0 && !cComment) {
                    cComment = comment;
                  }
                  continue;
                }
                if (text.includes("/**")) {
                  commentKey = "description";
                  comment = {};
                  inComments = true;
                  continue;
                }
                if (text.includes("// ")) {
                  commentLine = i;
                  comment.description = text.replace(/.*\/\/\s/gi, "").trim();
                }
                if (text.includes("@description")) {
                  commentKey = "description";
                  if (comment["description"]) {
                    comment["description"] += "\n" + text.replace(/.*@description/gi, "").trim();
                  } else {
                    comment["description"] = text.replace(/.*@description/gi, "").trim();
                  }
                  continue;
                }
                if (text.includes("@type")) {
                  commentKey = "type";
                  comment["type"] = text.replace(/.*@type/gi, "").trim();
                  continue;
                }
                if (text.includes("@default")) {
                  commentKey = "default";
                  comment["default"] = text.replace(/.*@default/gi, "").trim();
                  continue;
                }
                if (text.includes("@requires")) {
                  let requireText = text.replace(/.*@requires/, "").trim();
                  if (requireText) {
                    comment["required"] = requireText;
                  } else {
                    comment["required"] = "true";
                  }
                  continue;
                }
                if (text.includes("@enum")) {
                  commentKey = "enum";
                  comment["enum"] = text.replace(/.*@enum/gi, "").trim();
                  continue;
                }
                if (text.includes("@example")) {
                  commentKey = "example";
                  comment["example"] = text.replace(/.*@example/gi, "").trim();
                  continue;
                }
                if (inComments) {
                  if (commentKey && this.commentKeys.includes(commentKey)) {
                    if (comment[commentKey]) {
                      comment[commentKey] += "\n" + text.replace(/.*\*\s/gi, "").trim();
                    } else {
                      comment[commentKey] = text.replace(/.*\*\s/gi, "").trim();
                    }
                  }
                  continue;
                }
                if (text.includes("emit(") && !hasDefineEmits) {
                  const emitName = text.replace(/.*emit\(('|")/gi, "").replace(/('|").*/gi, "").trim();
                  if (emitName) {
                    if (!(emits[emitName] && emits[emitName].description)) {
                      if (i - commentLine < 5) {
                        emits[emitName] = {
                          description: comment.description || "",
                          example: comment.example || "",
                          required: comment.required && comment.required.includes(emitName + "") ? "true" : "false"
                        };
                      } else {
                        if (!emits[emitName]) {
                          emits[emitName] = {
                            description: ""
                          };
                        }
                      }
                    }
                  }
                }
                if (isDefine) {
                  if (braceLeftCount === 1) {
                    if (/name\s*:/gi.test(text)) {
                      const defineName = this.explorer.getVarConstantValue(text);
                      if (defineName) {
                        cName = defineName;
                      }
                    }
                    if (/emits\s*:/gi.test(text)) {
                      emitText = text;
                      if (text.includes("[") && !text.includes("]")) {
                        while (!emitText.includes("]") && i <= componentLines.length) {
                          i++;
                          emitText += componentLines[i];
                        }
                      }
                      const emitList = this.explorer.getArrValue(emitText);
                      let description = {};
                      if (comment.description) {
                        let descriptions = comment.description.split("\n");
                        descriptions.forEach((desc) => {
                          if (desc) {
                            const descs = desc.split(" ");
                            if (descs.length > 1) {
                              const descName = descs.shift();
                              description[descName] = descs.join(" ");
                            }
                          }
                        });
                      }
                      let example = {};
                      if (comment.example) {
                        let examples = comment.example.split("\n");
                        examples.forEach((desc) => {
                          if (desc) {
                            const descs = desc.split(" ");
                            if (descs.length > 1) {
                              const descName = descs.shift();
                              example[descName] = descs.join(" ");
                            }
                          }
                        });
                      }
                      emitList.forEach((emit) => {
                        emits[emit] = {
                          description: description[emit] || "",
                          example: example[emit] || "",
                          required: comment.required && comment.required.includes(emit + "") ? "true" : "false"
                        };
                      });
                      commentKey = "description";
                      comment = {};
                    }
                    inProps = false;
                  }
                  if (braceLeftCount === 2) {
                    if (/props\s*:/gi.test(text)) {
                      commentKey = "description";
                      comment = {};
                      inProps = true;
                      continue;
                    }
                    if (inProps) {
                      if (text.includes("}")) {
                        commentKey = "description";
                        comment = {};
                      }
                      if (text.includes(":")) {
                        const name = this.explorer.getVarName(text);
                        if (name) {
                          comment["type"] = this.explorer.getVarValue(text);
                          props[name] = comment;
                          commentKey = "description";
                          comment = {};
                        }
                      }
                    }
                  }
                  if (braceLeftCount === 3) {
                    if (inProps) {
                      if (text.includes(":")) {
                        const name = this.explorer.getVarName(text);
                        if (name) {
                          if (text.includes("{")) {
                            propName = name;
                            props[name] = comment;
                          } else {
                            if (propName && this.propKeys.includes(name)) {
                              props[propName][name] = this.explorer.getVarValue(text);
                            }
                          }
                        }
                      }
                    }
                  }
                } else {
                  if (text.includes("defineProps")) {
                    commentKey = "description";
                    comment = {};
                    inProps = true;
                    continue;
                  }
                  if (text.includes("withDefaults")) {
                    inPropsDefault = true;
                    continue;
                  }
                  if (braceLeftCount === 0) {
                    if (text.includes("defineEmits")) {
                      hasDefineEmits = true;
                      emitText = text;
                      if (text.includes("[") && !text.includes("]")) {
                        while (!emitText.includes("]") && i <= componentLines.length) {
                          i++;
                          emitText += componentLines[i];
                        }
                      }
                      const emitList = this.explorer.getArrValue(emitText);
                      let description = {};
                      if (comment.description) {
                        let descriptions = comment.description.split("\n");
                        descriptions.forEach((desc) => {
                          if (desc) {
                            const descs = desc.split(" ");
                            if (descs.length > 1) {
                              const descName = descs.shift();
                              description[descName] = descs.join(" ");
                            }
                          }
                        });
                      }
                      let example = {};
                      if (comment.example) {
                        let examples = comment.example.split("\n");
                        examples.forEach((desc) => {
                          if (desc) {
                            const descs = desc.split(" ");
                            if (descs.length > 1) {
                              const descName = descs.shift();
                              example[descName] = descs.join(" ");
                            }
                          }
                        });
                      }
                      emitList.forEach((emit) => {
                        emits[emit] = {
                          description: description[emit] || "",
                          example: example[emit] || "",
                          required: comment.required && comment.required.includes(emit + "") ? "true" : "false"
                        };
                      });
                      commentKey = "description";
                      comment = {};
                      continue;
                    }
                    if (!inProps) {
                      inPropsDefault = false;
                    }
                    inProps = false;
                  }
                  if (braceLeftCount === 1) {
                    if (/emits\s*:/gi.test(text)) {
                      emitText = text;
                      if (text.includes("[") && !text.includes("]")) {
                        while (!emitText.includes("]") && i <= componentLines.length) {
                          i++;
                          emitText += componentLines[i];
                        }
                      }
                      const emitList = this.explorer.getArrValue(emitText);
                      let description = {};
                      if (comment.description) {
                        let descriptions = comment.description.split("\n");
                        descriptions.forEach((desc) => {
                          if (desc) {
                            const descs = desc.split(" ");
                            if (descs.length > 1) {
                              const descName = descs.shift();
                              description[descName] = descs.join(" ");
                            }
                          }
                        });
                      }
                      let example = {};
                      if (comment.example) {
                        let examples = comment.example.split("\n");
                        examples.forEach((desc) => {
                          if (desc) {
                            const descs = desc.split(" ");
                            if (descs.length > 1) {
                              const descName = descs.shift();
                              example[descName] = descs.join(" ");
                            }
                          }
                        });
                      }
                      emitList.forEach((emit) => {
                        emits[emit] = {
                          description: description[emit] || "",
                          example: example[emit] || "",
                          required: comment.required && comment.required.includes(emit + "") ? "true" : "false"
                        };
                      });
                      commentKey = "description";
                      comment = {};
                    }
                    if (inProps) {
                      if (text.includes("}")) {
                        commentKey = "description";
                        comment = {};
                      }
                      if (text.includes(":")) {
                        const name = this.explorer.getVarName(text);
                        if (name) {
                          if (text.includes("(")) {
                            comment["type"] = "Function";
                          } else {
                            comment["type"] = this.explorer.getVarValue(text);
                          }
                          if (smallBracketCount === 0) {
                            props[name] = comment;
                          }
                          commentKey = "description";
                          comment = {};
                          if (text.includes("(")) {
                            let braceSmallLeftList = text.match(/\(/gi);
                            let braceSmallRightList = text.match(/\)/gi);
                            let braceSmallLeft = braceSmallLeftList ? braceSmallLeftList.length : 0;
                            let braceSmallRight = braceSmallRightList ? braceSmallRightList.length : 0;
                            smallBracketCount += braceSmallLeft - braceSmallRight;
                          }
                        }
                      }
                    } else if (!inProps && inPropsDefault) {
                      if (text.includes(":")) {
                        const name = this.explorer.getVarName(text);
                        if (name && props[name]) {
                          props[name]["default"] = this.explorer.getVarValue(text);
                        }
                      }
                    }
                    if (propType === "props") {
                      inProps = false;
                    }
                  }
                  if (braceLeftCount === 2) {
                    if (/props\s*:/gi.test(text)) {
                      propType = "props";
                      commentKey = "description";
                      comment = {};
                      inProps = true;
                      continue;
                    }
                    if (inProps) {
                      if (propType === "props") {
                        if (text.includes("}")) {
                          commentKey = "description";
                          comment = {};
                        }
                        if (text.includes(":")) {
                          const name = this.explorer.getVarName(text);
                          if (name) {
                            comment["type"] = this.explorer.getVarValue(text);
                            props[name] = comment;
                            commentKey = "description";
                            comment = {};
                          }
                        }
                      } else {
                        if (text.includes(":")) {
                          const name = this.explorer.getVarName(text);
                          if (name) {
                            if (text.includes("{") && !text.includes("(")) {
                              propName = name;
                              props[name] = comment;
                            } else {
                              if (propName && this.propKeys.includes(name)) {
                                props[propName][name] = this.explorer.getVarValue(text);
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                  if (braceLeftCount === 3) {
                    if (inProps) {
                      if (propType === "props") {
                        if (text.includes(":")) {
                          const name = this.explorer.getVarName(text);
                          if (name) {
                            if (text.includes("{") && !text.includes("(")) {
                              propName = name;
                              props[name] = comment;
                            } else {
                              if (propName && this.propKeys.includes(name)) {
                                props[propName][name] = this.explorer.getVarValue(text);
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                  if (braceLeftCount === 4 && propType === "props") {
                    if (inProps) {
                      if (text.includes(":")) {
                        const name = this.explorer.getVarName(text);
                        if (name && props[propName]) {
                          props[propName][name] = this.explorer.getVarValue(text);
                        }
                      }
                    }
                  }
                }
              }
              files.push({
                name: cName,
                fileName,
                comment: cComment,
                path: dir.replace(/\\/gi, "/"),
                emits,
                props,
                slots,
                insertText: cComment && cComment.example ? cComment.example : this.getInsertText(cName, emits, props)
              });
            } else {
            }
          } catch (error) {
            console.log(error);
          }
        }
      }
      getInsertText(name, emits, props) {
        let ret = `${name}`;
        let i = 1;
        for (const key in props) {
          const propItem = props[key];
          if (propItem && propItem.required === "true") {
            if (propItem.type === "string" || propItem.type === "String") {
              ret += ` ${key}="$${i}"`;
            } else {
              ret += ` :${key}="$${i}"`;
            }
            i++;
          }
        }
        for (const key in emits) {
          const emitItem = emits[key];
          if (emitItem && emitItem.required === "true") {
            ret += ` @${key}="$${i}"`;
            i++;
          }
        }
        ret += `>$${i}</${name}>`;
        return ret;
      }
      searchLocalComponent(filePath) {
        let files = [];
        let cond;
        let ignore = ["node_modules", "dist", "build"];
        cond = function(rootPath) {
          return !(rootPath.charAt(0) === "." || ignore.indexOf(rootPath) !== -1);
        };
        if (cond(filePath)) {
          let stat = fs.statSync(path3.join(this.explorer.projectRootPath || "", filePath));
          if (stat.isDirectory()) {
            this.traverseHandleLocalComponent(filePath, files);
          } else {
            this.traverseAddLocalComponent(filePath, filePath, files);
          }
        }
        return files;
      }
      traverseDir(dir) {
        let ret = [];
        const dirList = fs.readdirSync(dir);
        for (let i = 0; i < dirList.length; i++) {
          const childDir = dirList[i];
          if (!(childDir.charAt(0) === ".")) {
            let childPath = path3.join(dir, childDir);
            let stat = fs.statSync(childPath);
            if (stat.isDirectory()) {
              ret.push({
                label: childDir,
                children: this.traverseDir(childPath)
              });
            } else {
              ret.push({
                label: childDir
              });
            }
          }
        }
        return ret;
      }
    };
    exports2.default = Traverse;
  }
});

// out/statusBar.js
var require_statusBar = __commonJS({
  "out/statusBar.js"(exports2) {
    "use strict";
    var __awaiter = exports2 && exports2.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    var vscode_1 = require("vscode");
    var StatusBarController = class {
      constructor(explorer) {
        this.vueHelperStatusBar = vscode_1.window.createStatusBarItem(vscode_1.StatusBarAlignment.Right, -99999);
        this.vueHelperStatusBar.text = "$(extensions-view-icon) helper";
        this.explorer = explorer;
        explorer.context.subscriptions.push(this.vueHelperStatusBar);
      }
      show() {
        return __awaiter(this, void 0, void 0, function* () {
          this.updateTooltip();
          this.vueHelperStatusBar.show();
        });
      }
      updateTooltip() {
        let explorerMd = "\n";
        let { remain, isExpire, vipLevel, token } = this.updateUser();
        if (!isExpire) {
          explorerMd += "\u{1F451}";
          if (vipLevel === 2) {
            explorerMd += "[\u5E74\u5EA6] ";
          } else if (vipLevel === 3) {
            explorerMd += "[\u7EC8\u8EAB] ";
          }
        }
        explorerMd += "vue-helper";
        if (vipLevel === -1 && !token) {
          explorerMd += ` \u2728 <a href="command:vue-helper.login" >\u7533\u8BF7\u8BD5\u7528</a>`;
        } else if (vipLevel === -1 && token && isExpire) {
          explorerMd += ` \u2728 <a href="command:vue-helper.openPay" >\u89E3\u9501Pro</a>`;
        } else if (vipLevel === 0) {
          explorerMd += ` \u2728 <a href="command:vue-helper.openPay" >\u89E3\u9501Pro</a>`;
        } else {
          if (isExpire) {
            explorerMd += ` \u2728 <a href="command:vue-helper.openPay" >\u89E3\u9501Pro</a>`;
          } else {
            explorerMd += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
          }
        }
        explorerMd += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        if (vipLevel === -1) {
          if (isExpire) {
            explorerMd += `&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style="color:#999999;">\u8FC7\u671F</span>`;
          } else {
            explorerMd += `&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;`;
          }
        } else if (vipLevel === 0) {
          if (isExpire) {
            explorerMd += `<span style="color:#999999;">\u8FC7\u671F</span>`;
          } else {
            explorerMd += `<span style="color:#999999;">\u8BD5\u7528${remain}\u5929</span>`;
          }
        } else if (vipLevel === 2 || vipLevel === 3) {
          if (isExpire) {
            explorerMd += `<span style="color:#999999;">\u8FC7\u671F</span>`;
          }
        }
        if (vipLevel === 2 || vipLevel === 3) {
          explorerMd += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        }
        explorerMd += `&nbsp;&nbsp;<a href="command:vue-helper.openDocument">$(book) \u6587\u6863</a>`;
        explorerMd += `&nbsp;&nbsp;<a href="command:vue-helper.feedback">$(feedback) \u53CD\u9988</a>`;
        explorerMd += "\n *** \n";
        if (vipLevel === -1 || isExpire) {
          explorerMd += `<div style="color:#999999;">\u5DE5\u7A0B`;
          explorerMd += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
          explorerMd += `&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$(diff-insert) \u65B0\u5EFA`;
          explorerMd += "</div>";
          explorerMd += `<div style="color:#999999;">\u4ED3\u5E93`;
          explorerMd += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
          explorerMd += `&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$(git-branch) \u8BBF\u95EE`;
          explorerMd += "</div>";
          explorerMd += `<div style="color:#999999;">API`;
          explorerMd += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
          explorerMd += `$(play) \u4E00\u952E\u751F\u6210&nbsp;&nbsp;&nbsp;&nbsp;$(refresh) \u66F4\u65B0&nbsp;&nbsp;&nbsp;&nbsp;$(eye) \u8BBF\u95EE&nbsp;&nbsp;&nbsp;&nbsp;$(gear) \u8BBE\u7F6E`;
          explorerMd += "</div>";
          explorerMd += `<div style="color:#999999;">\u672C\u5730\u7EC4\u4EF6`;
          explorerMd += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
          explorerMd += `$(refresh) \u66F4\u65B0&nbsp;&nbsp;&nbsp;&nbsp;$(book) \u6587\u6863`;
          explorerMd += "</div>";
          explorerMd += `<div style="color:#999999;">\u79C1\u6709\u7EC4\u4EF6`;
          explorerMd += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
          explorerMd += `$(gear) \u914D\u7F6E&nbsp;&nbsp;&nbsp;&nbsp;$(eye) \u67E5\u770B`;
          explorerMd += "</div>";
        } else if (vipLevel === 0 || vipLevel === 2 || vipLevel === 3) {
          explorerMd += `\u5DE5\u7A0B`;
          explorerMd += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
          explorerMd += `&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="command:vue-helper.project.new">$(diff-insert) \u65B0\u5EFA</a>`;
          explorerMd += "\n *** \n";
          explorerMd += `\u4ED3\u5E93`;
          explorerMd += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
          explorerMd += `&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="command:vue-helper.git.visit">$(git-branch) \u8BBF\u95EE</a>`;
          explorerMd += "\n *** \n";
          explorerMd += `API`;
          explorerMd += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
          explorerMd += `<a href="command:vue-helper.api.generateAll">$(play) \u4E00\u952E\u751F\u6210</a>&nbsp;&nbsp;&nbsp;&nbsp;<a href="command:vue-helper.api.update">$(refresh) \u66F4\u65B0</a>&nbsp;&nbsp;&nbsp;&nbsp;<a href="command:vue-helper.api.visit">$(eye) \u8BBF\u95EE</a>&nbsp;&nbsp;&nbsp;&nbsp;<a href="command:vue-helper.api.setting">$(gear) \u8BBE\u7F6E</a>`;
          explorerMd += "\n *** \n";
          explorerMd += `\u672C\u5730\u7EC4\u4EF6`;
          explorerMd += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
          explorerMd += `<a href="command:vue-helper.localComp.update">$(refresh) \u66F4\u65B0</a>&nbsp;&nbsp;&nbsp;&nbsp;<a href="command:vue-helper.localComp.doc">$(book) \u6587\u6863</a>`;
          explorerMd += "\n *** \n";
          explorerMd += `\u79C1\u6709\u7EC4\u4EF6`;
          explorerMd += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
          explorerMd += `<a href="command:vue-helper.private.setting">$(gear) \u914D\u7F6E</a>&nbsp;&nbsp;&nbsp;&nbsp;<a href="command:vue-helper.private.see">$(eye) \u67E5\u770B</a>`;
        }
        const vueHelperStatusBarTooltip = new vscode_1.MarkdownString(explorerMd, true);
        vueHelperStatusBarTooltip.supportHtml = true;
        vueHelperStatusBarTooltip.isTrusted = true;
        this.vueHelperStatusBar.tooltip = vueHelperStatusBarTooltip;
      }
      updateTooltipEn() {
        let explorerMd = "\n";
        let { remain, isExpire, vipLevel, token } = this.updateUser();
        if (!isExpire) {
          explorerMd += "\u{1F451}";
          if (vipLevel === 2) {
            explorerMd += "[Year] ";
          } else if (vipLevel === 3) {
            explorerMd += "[PERMANENT] ";
          }
        }
        explorerMd += "vue-helper";
        if (vipLevel === -1 && !token) {
          explorerMd += ` \u2728 <a href="command:vue-helper.login" >Apply Trail</a>`;
        } else if (vipLevel === -1 && token && isExpire) {
          explorerMd += ` \u2728 <a href="command:vue-helper.openPay" >Unlock Pro</a>`;
        } else if (vipLevel === 0) {
          explorerMd += ` \u2728 <a href="command:vue-helper.openPay" >Unlock Pro</a>`;
        } else {
          if (isExpire) {
            explorerMd += ` \u2728 <a href="command:vue-helper.openPay" >Unlock Pro</a>`;
          } else {
            explorerMd += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
          }
        }
        explorerMd += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        if (vipLevel === -1) {
          explorerMd += `&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;`;
        } else if (vipLevel === 0) {
          if (isExpire) {
            explorerMd += `<span style="color:#999999;">outdated</span>`;
          } else {
            explorerMd += `<span style="color:#999999;">trial ${remain} day</span>`;
          }
        } else if (vipLevel === 2 || vipLevel === 3) {
          if (isExpire) {
            explorerMd += `<span style="color:#999999;">outdated</span>`;
          }
        }
        explorerMd += `&nbsp;&nbsp;<a href="command:vue-helper.openDocument">$(book) Document</a>`;
        explorerMd += `&nbsp;&nbsp;<a href="command:vue-helper.feedback">$(feedback) Feedback</a>`;
        explorerMd += "\n *** \n";
        if (vipLevel === -1 || isExpire) {
          explorerMd += `<div style="color:#999999;">Project`;
          explorerMd += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
          explorerMd += `&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$(diff-insert) New`;
          explorerMd += "</div>";
          explorerMd += `<div style="color:#999999;">Repository`;
          explorerMd += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
          explorerMd += `&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$(git-branch) Visit`;
          explorerMd += "</div>";
          explorerMd += `<div style="color:#999999;">API`;
          explorerMd += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
          explorerMd += `$(play) generation all&nbsp;&nbsp;&nbsp;&nbsp;$(refresh) update&nbsp;&nbsp;&nbsp;&nbsp;$(eye) visit&nbsp;&nbsp;&nbsp;&nbsp;$(gear) setting`;
          explorerMd += "</div>";
          explorerMd += `<div style="color:#999999;">Local Component`;
          explorerMd += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
          explorerMd += `$(refresh) update&nbsp;&nbsp;&nbsp;&nbsp;$(book) Document`;
          explorerMd += "</div>";
          explorerMd += `<div style="color:#999999;">Private Components`;
          explorerMd += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
          explorerMd += `$(gear) Setting&nbsp;&nbsp;&nbsp;&nbsp;$(eye) View`;
          explorerMd += "</div>";
        } else if (vipLevel === 0 || vipLevel === 2 || vipLevel === 3) {
          explorerMd += `Project`;
          explorerMd += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
          explorerMd += `&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="command:vue-helper.project.new">$(diff-insert) New</a>`;
          explorerMd += "\n *** \n";
          explorerMd += `Repository`;
          explorerMd += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
          explorerMd += `&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="command:vue-helper.git.visit">$(git-branch) Visit</a>`;
          explorerMd += "\n *** \n";
          explorerMd += `API`;
          explorerMd += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
          explorerMd += `<a href="command:vue-helper.api.generateAll">$(play) generation all</a>&nbsp;&nbsp;&nbsp;&nbsp;<a href="command:vue-helper.api.update">$(refresh) update</a>&nbsp;&nbsp;&nbsp;&nbsp;<a href="command:vue-helper.api.visit">$(eye) visit</a>&nbsp;&nbsp;&nbsp;&nbsp;<a href="command:vue-helper.api.setting">$(gear) setting</a>`;
          explorerMd += "\n *** \n";
          explorerMd += `Local Component`;
          explorerMd += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
          explorerMd += `<a href="command:vue-helper.localComp.update">$(refresh) Update</a>&nbsp;&nbsp;&nbsp;&nbsp;<a href="command:vue-helper.localComp.doc">$(book) Document</a>`;
          explorerMd += "\n *** \n";
          explorerMd += `Private Component`;
          explorerMd += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
          explorerMd += `<a href="command:vue-helper.private.setting">$(refresh) Setting</a>&nbsp;&nbsp;&nbsp;&nbsp;<a href="command:vue-helper.private.see">$(eye) View</a>`;
        }
        const vueHelperStatusBarTooltip = new vscode_1.MarkdownString(explorerMd, true);
        vueHelperStatusBarTooltip.supportHtml = true;
        vueHelperStatusBarTooltip.isTrusted = true;
        this.vueHelperStatusBar.tooltip = vueHelperStatusBarTooltip;
      }
      showEn() {
        this.updateTooltipEn();
        this.vueHelperStatusBar.show();
      }
      updateUser() {
        let token = this.explorer.token;
        let remain = 0;
        let isExpire = true;
        let vipLevel = -1;
        if (token) {
          let parsedToken = this.explorer.parseToken(token);
          if (parsedToken && parsedToken.auth_value) {
            let info = JSON.parse(parsedToken.auth_value);
            this.explorer.userId = info.u;
            isExpire = info.e < new Date().getTime();
            this.explorer.isExpire = isExpire;
            let remainTime = info.e - new Date().getTime();
            if (remainTime > 0) {
              remain = Math.round(remainTime / 86400 / 1e3);
            }
            if (info.m) {
              vipLevel = info.m;
            }
          } else {
            vscode_1.commands.executeCommand("vue-helper.login", {
              opt: "login"
            });
          }
        }
        if (vipLevel < 2) {
          if (!isExpire) {
            vipLevel = 0;
          }
        }
        this.explorer.vipLevel = vipLevel;
        this.explorer.canUse = vipLevel > -1 && !isExpire;
        this.explorer.setContext("vue-helper.pro", this.explorer.canUse);
        return {
          token,
          remain,
          isExpire,
          vipLevel
        };
      }
    };
    exports2.default = StatusBarController;
  }
});

// out/webview/webviewCotnroller.js
var require_webviewCotnroller = __commonJS({
  "out/webview/webviewCotnroller.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.WebviewController = void 0;
    var vscode_1 = require("vscode");
    var path3 = require("path");
    var WebviewController = class {
      constructor(explorer) {
        this.viewType = "vue-helper.webviewController";
        this._disposables = [];
        this.title = "";
        this.token = "";
        this.framework = "";
        this.explorer = explorer;
      }
      dispose() {
        var _a;
        (_a = this.activeView) === null || _a === void 0 ? void 0 : _a.dispose();
        while (this._disposables.length) {
          const x = this._disposables.pop();
          if (x) {
            x.dispose();
          }
        }
        this.activeView = void 0;
      }
      openView(viewParams) {
        if (this.activeView && viewParams.title !== this.title) {
          this.dispose();
        }
        this.title = viewParams.title;
        this.token = viewParams.token || "";
        this.framework = viewParams.framework || "";
        const viewColumn = vscode_1.window.activeTextEditor ? vscode_1.window.activeTextEditor.viewColumn : void 0;
        if (this.activeView) {
          return this.activeView.reveal(viewColumn);
        }
        this.activeView = vscode_1.window.createWebviewPanel(this.viewType, this.title, viewParams.split ? vscode_1.ViewColumn.Two : viewColumn || vscode_1.ViewColumn.One, {
          enableScripts: true,
          localResourceRoots: [vscode_1.Uri.file(path3.join(this.explorer.context.extensionPath, "media"))]
        });
        this.activeView.onDidDispose(() => {
          viewParams.dispose && viewParams.dispose();
          this.dispose();
        }, null, this._disposables);
        this.activeView.webview.onDidReceiveMessage((message) => {
          viewParams.messageHandler(message);
        }, null, this._disposables);
        this.loadHtml(viewParams.page);
      }
      loadHtml(page) {
        if (this.activeView) {
          this.activeView.title = this.title;
          this.activeView.iconPath = vscode_1.Uri.file(path3.join(this.explorer.context.extensionPath, "/asset/logo.png"));
          this.activeView.webview.html = this.explorer.getHtmlForWebview(this.activeView.webview, this.explorer.context.extensionPath, page, this.title, this.token, this.framework);
        }
      }
      postMessage(params) {
        var _a;
        (_a = this.activeView) === null || _a === void 0 ? void 0 : _a.webview.postMessage(params);
      }
      close() {
        var _a;
        (_a = this.activeView) === null || _a === void 0 ? void 0 : _a.dispose();
      }
    };
    exports2.WebviewController = WebviewController;
  }
});

// node_modules/is-wsl/index.js
var require_is_wsl = __commonJS({
  "node_modules/is-wsl/index.js"(exports2, module2) {
    "use strict";
    var os2 = require("os");
    var fs = require("fs");
    var isWsl = () => {
      if (process.platform !== "linux") {
        return false;
      }
      if (os2.release().includes("Microsoft")) {
        return true;
      }
      try {
        return fs.readFileSync("/proc/version", "utf8").includes("Microsoft");
      } catch (err) {
        return false;
      }
    };
    if (process.env.__IS_WSL_TEST__) {
      module2.exports = isWsl;
    } else {
      module2.exports = isWsl();
    }
  }
});

// node_modules/opn/index.js
var require_opn = __commonJS({
  "node_modules/opn/index.js"(exports2, module2) {
    "use strict";
    var { promisify } = require("util");
    var path3 = require("path");
    var childProcess2 = require("child_process");
    var isWsl = require_is_wsl();
    var pExecFile = promisify(childProcess2.execFile);
    var wslToWindowsPath = async (path4) => {
      const { stdout } = await pExecFile("wslpath", ["-w", path4]);
      return stdout.trim();
    };
    module2.exports = async (target, options) => {
      if (typeof target !== "string") {
        throw new TypeError("Expected a `target`");
      }
      options = {
        wait: false,
        ...options
      };
      let command;
      let appArguments = [];
      const cliArguments = [];
      const childProcessOptions = {};
      if (Array.isArray(options.app)) {
        appArguments = options.app.slice(1);
        options.app = options.app[0];
      }
      if (process.platform === "darwin") {
        command = "open";
        if (options.wait) {
          cliArguments.push("-W");
        }
        if (options.app) {
          cliArguments.push("-a", options.app);
        }
      } else if (process.platform === "win32" || isWsl) {
        command = "cmd" + (isWsl ? ".exe" : "");
        cliArguments.push("/c", "start", '""', "/b");
        target = target.replace(/&/g, "^&");
        if (options.wait) {
          cliArguments.push("/wait");
        }
        if (options.app) {
          if (isWsl && options.app.startsWith("/mnt/")) {
            const windowsPath = await wslToWindowsPath(options.app);
            options.app = windowsPath;
          }
          cliArguments.push(options.app);
        }
        if (appArguments.length > 0) {
          cliArguments.push(...appArguments);
        }
      } else {
        if (options.app) {
          command = options.app;
        } else {
          const useSystemXdgOpen = process.versions.electron || process.platform === "android";
          command = useSystemXdgOpen ? "xdg-open" : path3.join(__dirname, "xdg-open");
        }
        if (appArguments.length > 0) {
          cliArguments.push(...appArguments);
        }
        if (!options.wait) {
          childProcessOptions.stdio = "ignore";
          childProcessOptions.detached = true;
        }
      }
      cliArguments.push(target);
      if (process.platform === "darwin" && appArguments.length > 0) {
        cliArguments.push("--args", ...appArguments);
      }
      const subprocess = childProcess2.spawn(command, cliArguments, childProcessOptions);
      if (options.wait) {
        return new Promise((resolve, reject) => {
          subprocess.once("error", reject);
          subprocess.once("close", (exitCode) => {
            if (exitCode > 0) {
              reject(new Error(`Exited with code ${exitCode}`));
              return;
            }
            resolve(subprocess);
          });
        });
      }
      subprocess.unref();
      return subprocess;
    };
  }
});

// node_modules/axios/lib/helpers/bind.js
var require_bind = __commonJS({
  "node_modules/axios/lib/helpers/bind.js"(exports2, module2) {
    "use strict";
    module2.exports = function bind(fn, thisArg) {
      return function wrap() {
        var args = new Array(arguments.length);
        for (var i = 0; i < args.length; i++) {
          args[i] = arguments[i];
        }
        return fn.apply(thisArg, args);
      };
    };
  }
});

// node_modules/axios/lib/utils.js
var require_utils = __commonJS({
  "node_modules/axios/lib/utils.js"(exports2, module2) {
    "use strict";
    var bind = require_bind();
    var toString = Object.prototype.toString;
    function isArray(val) {
      return toString.call(val) === "[object Array]";
    }
    function isUndefined(val) {
      return typeof val === "undefined";
    }
    function isBuffer(val) {
      return val !== null && !isUndefined(val) && val.constructor !== null && !isUndefined(val.constructor) && typeof val.constructor.isBuffer === "function" && val.constructor.isBuffer(val);
    }
    function isArrayBuffer(val) {
      return toString.call(val) === "[object ArrayBuffer]";
    }
    function isFormData(val) {
      return typeof FormData !== "undefined" && val instanceof FormData;
    }
    function isArrayBufferView(val) {
      var result;
      if (typeof ArrayBuffer !== "undefined" && ArrayBuffer.isView) {
        result = ArrayBuffer.isView(val);
      } else {
        result = val && val.buffer && val.buffer instanceof ArrayBuffer;
      }
      return result;
    }
    function isString(val) {
      return typeof val === "string";
    }
    function isNumber(val) {
      return typeof val === "number";
    }
    function isObject(val) {
      return val !== null && typeof val === "object";
    }
    function isPlainObject(val) {
      if (toString.call(val) !== "[object Object]") {
        return false;
      }
      var prototype = Object.getPrototypeOf(val);
      return prototype === null || prototype === Object.prototype;
    }
    function isDate(val) {
      return toString.call(val) === "[object Date]";
    }
    function isFile(val) {
      return toString.call(val) === "[object File]";
    }
    function isBlob(val) {
      return toString.call(val) === "[object Blob]";
    }
    function isFunction(val) {
      return toString.call(val) === "[object Function]";
    }
    function isStream2(val) {
      return isObject(val) && isFunction(val.pipe);
    }
    function isURLSearchParams(val) {
      return typeof URLSearchParams !== "undefined" && val instanceof URLSearchParams;
    }
    function trim(str) {
      return str.trim ? str.trim() : str.replace(/^\s+|\s+$/g, "");
    }
    function isStandardBrowserEnv() {
      if (typeof navigator !== "undefined" && (navigator.product === "ReactNative" || navigator.product === "NativeScript" || navigator.product === "NS")) {
        return false;
      }
      return typeof window !== "undefined" && typeof document !== "undefined";
    }
    function forEach(obj, fn) {
      if (obj === null || typeof obj === "undefined") {
        return;
      }
      if (typeof obj !== "object") {
        obj = [obj];
      }
      if (isArray(obj)) {
        for (var i = 0, l = obj.length; i < l; i++) {
          fn.call(null, obj[i], i, obj);
        }
      } else {
        for (var key in obj) {
          if (Object.prototype.hasOwnProperty.call(obj, key)) {
            fn.call(null, obj[key], key, obj);
          }
        }
      }
    }
    function merge() {
      var result = {};
      function assignValue(val, key) {
        if (isPlainObject(result[key]) && isPlainObject(val)) {
          result[key] = merge(result[key], val);
        } else if (isPlainObject(val)) {
          result[key] = merge({}, val);
        } else if (isArray(val)) {
          result[key] = val.slice();
        } else {
          result[key] = val;
        }
      }
      for (var i = 0, l = arguments.length; i < l; i++) {
        forEach(arguments[i], assignValue);
      }
      return result;
    }
    function extend(a, b, thisArg) {
      forEach(b, function assignValue(val, key) {
        if (thisArg && typeof val === "function") {
          a[key] = bind(val, thisArg);
        } else {
          a[key] = val;
        }
      });
      return a;
    }
    function stripBOM(content) {
      if (content.charCodeAt(0) === 65279) {
        content = content.slice(1);
      }
      return content;
    }
    module2.exports = {
      isArray,
      isArrayBuffer,
      isBuffer,
      isFormData,
      isArrayBufferView,
      isString,
      isNumber,
      isObject,
      isPlainObject,
      isUndefined,
      isDate,
      isFile,
      isBlob,
      isFunction,
      isStream: isStream2,
      isURLSearchParams,
      isStandardBrowserEnv,
      forEach,
      merge,
      extend,
      trim,
      stripBOM
    };
  }
});

// node_modules/axios/lib/helpers/buildURL.js
var require_buildURL = __commonJS({
  "node_modules/axios/lib/helpers/buildURL.js"(exports2, module2) {
    "use strict";
    var utils = require_utils();
    function encode(val) {
      return encodeURIComponent(val).replace(/%3A/gi, ":").replace(/%24/g, "$").replace(/%2C/gi, ",").replace(/%20/g, "+").replace(/%5B/gi, "[").replace(/%5D/gi, "]");
    }
    module2.exports = function buildURL(url, params, paramsSerializer) {
      if (!params) {
        return url;
      }
      var serializedParams;
      if (paramsSerializer) {
        serializedParams = paramsSerializer(params);
      } else if (utils.isURLSearchParams(params)) {
        serializedParams = params.toString();
      } else {
        var parts = [];
        utils.forEach(params, function serialize(val, key) {
          if (val === null || typeof val === "undefined") {
            return;
          }
          if (utils.isArray(val)) {
            key = key + "[]";
          } else {
            val = [val];
          }
          utils.forEach(val, function parseValue(v) {
            if (utils.isDate(v)) {
              v = v.toISOString();
            } else if (utils.isObject(v)) {
              v = JSON.stringify(v);
            }
            parts.push(encode(key) + "=" + encode(v));
          });
        });
        serializedParams = parts.join("&");
      }
      if (serializedParams) {
        var hashmarkIndex = url.indexOf("#");
        if (hashmarkIndex !== -1) {
          url = url.slice(0, hashmarkIndex);
        }
        url += (url.indexOf("?") === -1 ? "?" : "&") + serializedParams;
      }
      return url;
    };
  }
});

// node_modules/axios/lib/core/InterceptorManager.js
var require_InterceptorManager = __commonJS({
  "node_modules/axios/lib/core/InterceptorManager.js"(exports2, module2) {
    "use strict";
    var utils = require_utils();
    function InterceptorManager() {
      this.handlers = [];
    }
    InterceptorManager.prototype.use = function use(fulfilled, rejected, options) {
      this.handlers.push({
        fulfilled,
        rejected,
        synchronous: options ? options.synchronous : false,
        runWhen: options ? options.runWhen : null
      });
      return this.handlers.length - 1;
    };
    InterceptorManager.prototype.eject = function eject(id) {
      if (this.handlers[id]) {
        this.handlers[id] = null;
      }
    };
    InterceptorManager.prototype.forEach = function forEach(fn) {
      utils.forEach(this.handlers, function forEachHandler(h) {
        if (h !== null) {
          fn(h);
        }
      });
    };
    module2.exports = InterceptorManager;
  }
});

// node_modules/axios/lib/helpers/normalizeHeaderName.js
var require_normalizeHeaderName = __commonJS({
  "node_modules/axios/lib/helpers/normalizeHeaderName.js"(exports2, module2) {
    "use strict";
    var utils = require_utils();
    module2.exports = function normalizeHeaderName(headers, normalizedName) {
      utils.forEach(headers, function processHeader(value, name) {
        if (name !== normalizedName && name.toUpperCase() === normalizedName.toUpperCase()) {
          headers[normalizedName] = value;
          delete headers[name];
        }
      });
    };
  }
});

// node_modules/axios/lib/core/enhanceError.js
var require_enhanceError = __commonJS({
  "node_modules/axios/lib/core/enhanceError.js"(exports2, module2) {
    "use strict";
    module2.exports = function enhanceError(error, config, code, request, response) {
      error.config = config;
      if (code) {
        error.code = code;
      }
      error.request = request;
      error.response = response;
      error.isAxiosError = true;
      error.toJSON = function toJSON() {
        return {
          message: this.message,
          name: this.name,
          description: this.description,
          number: this.number,
          fileName: this.fileName,
          lineNumber: this.lineNumber,
          columnNumber: this.columnNumber,
          stack: this.stack,
          config: this.config,
          code: this.code
        };
      };
      return error;
    };
  }
});

// node_modules/axios/lib/core/createError.js
var require_createError = __commonJS({
  "node_modules/axios/lib/core/createError.js"(exports2, module2) {
    "use strict";
    var enhanceError = require_enhanceError();
    module2.exports = function createError(message, config, code, request, response) {
      var error = new Error(message);
      return enhanceError(error, config, code, request, response);
    };
  }
});

// node_modules/axios/lib/core/settle.js
var require_settle = __commonJS({
  "node_modules/axios/lib/core/settle.js"(exports2, module2) {
    "use strict";
    var createError = require_createError();
    module2.exports = function settle(resolve, reject, response) {
      var validateStatus = response.config.validateStatus;
      if (!response.status || !validateStatus || validateStatus(response.status)) {
        resolve(response);
      } else {
        reject(createError(
          "Request failed with status code " + response.status,
          response.config,
          null,
          response.request,
          response
        ));
      }
    };
  }
});

// node_modules/axios/lib/helpers/cookies.js
var require_cookies = __commonJS({
  "node_modules/axios/lib/helpers/cookies.js"(exports2, module2) {
    "use strict";
    var utils = require_utils();
    module2.exports = utils.isStandardBrowserEnv() ? function standardBrowserEnv() {
      return {
        write: function write(name, value, expires, path3, domain, secure) {
          var cookie = [];
          cookie.push(name + "=" + encodeURIComponent(value));
          if (utils.isNumber(expires)) {
            cookie.push("expires=" + new Date(expires).toGMTString());
          }
          if (utils.isString(path3)) {
            cookie.push("path=" + path3);
          }
          if (utils.isString(domain)) {
            cookie.push("domain=" + domain);
          }
          if (secure === true) {
            cookie.push("secure");
          }
          document.cookie = cookie.join("; ");
        },
        read: function read(name) {
          var match = document.cookie.match(new RegExp("(^|;\\s*)(" + name + ")=([^;]*)"));
          return match ? decodeURIComponent(match[3]) : null;
        },
        remove: function remove(name) {
          this.write(name, "", Date.now() - 864e5);
        }
      };
    }() : function nonStandardBrowserEnv() {
      return {
        write: function write() {
        },
        read: function read() {
          return null;
        },
        remove: function remove() {
        }
      };
    }();
  }
});

// node_modules/axios/lib/helpers/isAbsoluteURL.js
var require_isAbsoluteURL = __commonJS({
  "node_modules/axios/lib/helpers/isAbsoluteURL.js"(exports2, module2) {
    "use strict";
    module2.exports = function isAbsoluteURL(url) {
      return /^([a-z][a-z\d\+\-\.]*:)?\/\//i.test(url);
    };
  }
});

// node_modules/axios/lib/helpers/combineURLs.js
var require_combineURLs = __commonJS({
  "node_modules/axios/lib/helpers/combineURLs.js"(exports2, module2) {
    "use strict";
    module2.exports = function combineURLs(baseURL, relativeURL) {
      return relativeURL ? baseURL.replace(/\/+$/, "") + "/" + relativeURL.replace(/^\/+/, "") : baseURL;
    };
  }
});

// node_modules/axios/lib/core/buildFullPath.js
var require_buildFullPath = __commonJS({
  "node_modules/axios/lib/core/buildFullPath.js"(exports2, module2) {
    "use strict";
    var isAbsoluteURL = require_isAbsoluteURL();
    var combineURLs = require_combineURLs();
    module2.exports = function buildFullPath(baseURL, requestedURL) {
      if (baseURL && !isAbsoluteURL(requestedURL)) {
        return combineURLs(baseURL, requestedURL);
      }
      return requestedURL;
    };
  }
});

// node_modules/axios/lib/helpers/parseHeaders.js
var require_parseHeaders = __commonJS({
  "node_modules/axios/lib/helpers/parseHeaders.js"(exports2, module2) {
    "use strict";
    var utils = require_utils();
    var ignoreDuplicateOf = [
      "age",
      "authorization",
      "content-length",
      "content-type",
      "etag",
      "expires",
      "from",
      "host",
      "if-modified-since",
      "if-unmodified-since",
      "last-modified",
      "location",
      "max-forwards",
      "proxy-authorization",
      "referer",
      "retry-after",
      "user-agent"
    ];
    module2.exports = function parseHeaders(headers) {
      var parsed = {};
      var key;
      var val;
      var i;
      if (!headers) {
        return parsed;
      }
      utils.forEach(headers.split("\n"), function parser(line) {
        i = line.indexOf(":");
        key = utils.trim(line.substr(0, i)).toLowerCase();
        val = utils.trim(line.substr(i + 1));
        if (key) {
          if (parsed[key] && ignoreDuplicateOf.indexOf(key) >= 0) {
            return;
          }
          if (key === "set-cookie") {
            parsed[key] = (parsed[key] ? parsed[key] : []).concat([val]);
          } else {
            parsed[key] = parsed[key] ? parsed[key] + ", " + val : val;
          }
        }
      });
      return parsed;
    };
  }
});

// node_modules/axios/lib/helpers/isURLSameOrigin.js
var require_isURLSameOrigin = __commonJS({
  "node_modules/axios/lib/helpers/isURLSameOrigin.js"(exports2, module2) {
    "use strict";
    var utils = require_utils();
    module2.exports = utils.isStandardBrowserEnv() ? function standardBrowserEnv() {
      var msie = /(msie|trident)/i.test(navigator.userAgent);
      var urlParsingNode = document.createElement("a");
      var originURL;
      function resolveURL(url) {
        var href = url;
        if (msie) {
          urlParsingNode.setAttribute("href", href);
          href = urlParsingNode.href;
        }
        urlParsingNode.setAttribute("href", href);
        return {
          href: urlParsingNode.href,
          protocol: urlParsingNode.protocol ? urlParsingNode.protocol.replace(/:$/, "") : "",
          host: urlParsingNode.host,
          search: urlParsingNode.search ? urlParsingNode.search.replace(/^\?/, "") : "",
          hash: urlParsingNode.hash ? urlParsingNode.hash.replace(/^#/, "") : "",
          hostname: urlParsingNode.hostname,
          port: urlParsingNode.port,
          pathname: urlParsingNode.pathname.charAt(0) === "/" ? urlParsingNode.pathname : "/" + urlParsingNode.pathname
        };
      }
      originURL = resolveURL(window.location.href);
      return function isURLSameOrigin(requestURL) {
        var parsed = utils.isString(requestURL) ? resolveURL(requestURL) : requestURL;
        return parsed.protocol === originURL.protocol && parsed.host === originURL.host;
      };
    }() : function nonStandardBrowserEnv() {
      return function isURLSameOrigin() {
        return true;
      };
    }();
  }
});

// node_modules/axios/lib/adapters/xhr.js
var require_xhr = __commonJS({
  "node_modules/axios/lib/adapters/xhr.js"(exports2, module2) {
    "use strict";
    var utils = require_utils();
    var settle = require_settle();
    var cookies = require_cookies();
    var buildURL = require_buildURL();
    var buildFullPath = require_buildFullPath();
    var parseHeaders = require_parseHeaders();
    var isURLSameOrigin = require_isURLSameOrigin();
    var createError = require_createError();
    module2.exports = function xhrAdapter(config) {
      return new Promise(function dispatchXhrRequest(resolve, reject) {
        var requestData = config.data;
        var requestHeaders = config.headers;
        var responseType = config.responseType;
        if (utils.isFormData(requestData)) {
          delete requestHeaders["Content-Type"];
        }
        var request = new XMLHttpRequest();
        if (config.auth) {
          var username = config.auth.username || "";
          var password = config.auth.password ? unescape(encodeURIComponent(config.auth.password)) : "";
          requestHeaders.Authorization = "Basic " + btoa(username + ":" + password);
        }
        var fullPath = buildFullPath(config.baseURL, config.url);
        request.open(config.method.toUpperCase(), buildURL(fullPath, config.params, config.paramsSerializer), true);
        request.timeout = config.timeout;
        function onloadend() {
          if (!request) {
            return;
          }
          var responseHeaders = "getAllResponseHeaders" in request ? parseHeaders(request.getAllResponseHeaders()) : null;
          var responseData = !responseType || responseType === "text" || responseType === "json" ? request.responseText : request.response;
          var response = {
            data: responseData,
            status: request.status,
            statusText: request.statusText,
            headers: responseHeaders,
            config,
            request
          };
          settle(resolve, reject, response);
          request = null;
        }
        if ("onloadend" in request) {
          request.onloadend = onloadend;
        } else {
          request.onreadystatechange = function handleLoad() {
            if (!request || request.readyState !== 4) {
              return;
            }
            if (request.status === 0 && !(request.responseURL && request.responseURL.indexOf("file:") === 0)) {
              return;
            }
            setTimeout(onloadend);
          };
        }
        request.onabort = function handleAbort() {
          if (!request) {
            return;
          }
          reject(createError("Request aborted", config, "ECONNABORTED", request));
          request = null;
        };
        request.onerror = function handleError() {
          reject(createError("Network Error", config, null, request));
          request = null;
        };
        request.ontimeout = function handleTimeout() {
          var timeoutErrorMessage = "timeout of " + config.timeout + "ms exceeded";
          if (config.timeoutErrorMessage) {
            timeoutErrorMessage = config.timeoutErrorMessage;
          }
          reject(createError(
            timeoutErrorMessage,
            config,
            config.transitional && config.transitional.clarifyTimeoutError ? "ETIMEDOUT" : "ECONNABORTED",
            request
          ));
          request = null;
        };
        if (utils.isStandardBrowserEnv()) {
          var xsrfValue = (config.withCredentials || isURLSameOrigin(fullPath)) && config.xsrfCookieName ? cookies.read(config.xsrfCookieName) : void 0;
          if (xsrfValue) {
            requestHeaders[config.xsrfHeaderName] = xsrfValue;
          }
        }
        if ("setRequestHeader" in request) {
          utils.forEach(requestHeaders, function setRequestHeader(val, key) {
            if (typeof requestData === "undefined" && key.toLowerCase() === "content-type") {
              delete requestHeaders[key];
            } else {
              request.setRequestHeader(key, val);
            }
          });
        }
        if (!utils.isUndefined(config.withCredentials)) {
          request.withCredentials = !!config.withCredentials;
        }
        if (responseType && responseType !== "json") {
          request.responseType = config.responseType;
        }
        if (typeof config.onDownloadProgress === "function") {
          request.addEventListener("progress", config.onDownloadProgress);
        }
        if (typeof config.onUploadProgress === "function" && request.upload) {
          request.upload.addEventListener("progress", config.onUploadProgress);
        }
        if (config.cancelToken) {
          config.cancelToken.promise.then(function onCanceled(cancel) {
            if (!request) {
              return;
            }
            request.abort();
            reject(cancel);
            request = null;
          });
        }
        if (!requestData) {
          requestData = null;
        }
        request.send(requestData);
      });
    };
  }
});

// node_modules/ms/index.js
var require_ms = __commonJS({
  "node_modules/ms/index.js"(exports2, module2) {
    var s = 1e3;
    var m = s * 60;
    var h = m * 60;
    var d = h * 24;
    var w = d * 7;
    var y = d * 365.25;
    module2.exports = function(val, options) {
      options = options || {};
      var type = typeof val;
      if (type === "string" && val.length > 0) {
        return parse(val);
      } else if (type === "number" && isFinite(val)) {
        return options.long ? fmtLong(val) : fmtShort(val);
      }
      throw new Error(
        "val is not a non-empty string or a valid number. val=" + JSON.stringify(val)
      );
    };
    function parse(str) {
      str = String(str);
      if (str.length > 100) {
        return;
      }
      var match = /^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(
        str
      );
      if (!match) {
        return;
      }
      var n = parseFloat(match[1]);
      var type = (match[2] || "ms").toLowerCase();
      switch (type) {
        case "years":
        case "year":
        case "yrs":
        case "yr":
        case "y":
          return n * y;
        case "weeks":
        case "week":
        case "w":
          return n * w;
        case "days":
        case "day":
        case "d":
          return n * d;
        case "hours":
        case "hour":
        case "hrs":
        case "hr":
        case "h":
          return n * h;
        case "minutes":
        case "minute":
        case "mins":
        case "min":
        case "m":
          return n * m;
        case "seconds":
        case "second":
        case "secs":
        case "sec":
        case "s":
          return n * s;
        case "milliseconds":
        case "millisecond":
        case "msecs":
        case "msec":
        case "ms":
          return n;
        default:
          return void 0;
      }
    }
    function fmtShort(ms) {
      var msAbs = Math.abs(ms);
      if (msAbs >= d) {
        return Math.round(ms / d) + "d";
      }
      if (msAbs >= h) {
        return Math.round(ms / h) + "h";
      }
      if (msAbs >= m) {
        return Math.round(ms / m) + "m";
      }
      if (msAbs >= s) {
        return Math.round(ms / s) + "s";
      }
      return ms + "ms";
    }
    function fmtLong(ms) {
      var msAbs = Math.abs(ms);
      if (msAbs >= d) {
        return plural(ms, msAbs, d, "day");
      }
      if (msAbs >= h) {
        return plural(ms, msAbs, h, "hour");
      }
      if (msAbs >= m) {
        return plural(ms, msAbs, m, "minute");
      }
      if (msAbs >= s) {
        return plural(ms, msAbs, s, "second");
      }
      return ms + " ms";
    }
    function plural(ms, msAbs, n, name) {
      var isPlural = msAbs >= n * 1.5;
      return Math.round(ms / n) + " " + name + (isPlural ? "s" : "");
    }
  }
});

// node_modules/debug/src/common.js
var require_common = __commonJS({
  "node_modules/debug/src/common.js"(exports2, module2) {
    function setup(env) {
      createDebug.debug = createDebug;
      createDebug.default = createDebug;
      createDebug.coerce = coerce;
      createDebug.disable = disable;
      createDebug.enable = enable;
      createDebug.enabled = enabled;
      createDebug.humanize = require_ms();
      createDebug.destroy = destroy;
      Object.keys(env).forEach((key) => {
        createDebug[key] = env[key];
      });
      createDebug.names = [];
      createDebug.skips = [];
      createDebug.formatters = {};
      function selectColor(namespace) {
        let hash = 0;
        for (let i = 0; i < namespace.length; i++) {
          hash = (hash << 5) - hash + namespace.charCodeAt(i);
          hash |= 0;
        }
        return createDebug.colors[Math.abs(hash) % createDebug.colors.length];
      }
      createDebug.selectColor = selectColor;
      function createDebug(namespace) {
        let prevTime;
        let enableOverride = null;
        let namespacesCache;
        let enabledCache;
        function debug(...args) {
          if (!debug.enabled) {
            return;
          }
          const self2 = debug;
          const curr = Number(new Date());
          const ms = curr - (prevTime || curr);
          self2.diff = ms;
          self2.prev = prevTime;
          self2.curr = curr;
          prevTime = curr;
          args[0] = createDebug.coerce(args[0]);
          if (typeof args[0] !== "string") {
            args.unshift("%O");
          }
          let index = 0;
          args[0] = args[0].replace(/%([a-zA-Z%])/g, (match, format) => {
            if (match === "%%") {
              return "%";
            }
            index++;
            const formatter = createDebug.formatters[format];
            if (typeof formatter === "function") {
              const val = args[index];
              match = formatter.call(self2, val);
              args.splice(index, 1);
              index--;
            }
            return match;
          });
          createDebug.formatArgs.call(self2, args);
          const logFn = self2.log || createDebug.log;
          logFn.apply(self2, args);
        }
        debug.namespace = namespace;
        debug.useColors = createDebug.useColors();
        debug.color = createDebug.selectColor(namespace);
        debug.extend = extend;
        debug.destroy = createDebug.destroy;
        Object.defineProperty(debug, "enabled", {
          enumerable: true,
          configurable: false,
          get: () => {
            if (enableOverride !== null) {
              return enableOverride;
            }
            if (namespacesCache !== createDebug.namespaces) {
              namespacesCache = createDebug.namespaces;
              enabledCache = createDebug.enabled(namespace);
            }
            return enabledCache;
          },
          set: (v) => {
            enableOverride = v;
          }
        });
        if (typeof createDebug.init === "function") {
          createDebug.init(debug);
        }
        return debug;
      }
      function extend(namespace, delimiter) {
        const newDebug = createDebug(this.namespace + (typeof delimiter === "undefined" ? ":" : delimiter) + namespace);
        newDebug.log = this.log;
        return newDebug;
      }
      function enable(namespaces) {
        createDebug.save(namespaces);
        createDebug.namespaces = namespaces;
        createDebug.names = [];
        createDebug.skips = [];
        let i;
        const split = (typeof namespaces === "string" ? namespaces : "").split(/[\s,]+/);
        const len = split.length;
        for (i = 0; i < len; i++) {
          if (!split[i]) {
            continue;
          }
          namespaces = split[i].replace(/\*/g, ".*?");
          if (namespaces[0] === "-") {
            createDebug.skips.push(new RegExp("^" + namespaces.slice(1) + "$"));
          } else {
            createDebug.names.push(new RegExp("^" + namespaces + "$"));
          }
        }
      }
      function disable() {
        const namespaces = [
          ...createDebug.names.map(toNamespace),
          ...createDebug.skips.map(toNamespace).map((namespace) => "-" + namespace)
        ].join(",");
        createDebug.enable("");
        return namespaces;
      }
      function enabled(name) {
        if (name[name.length - 1] === "*") {
          return true;
        }
        let i;
        let len;
        for (i = 0, len = createDebug.skips.length; i < len; i++) {
          if (createDebug.skips[i].test(name)) {
            return false;
          }
        }
        for (i = 0, len = createDebug.names.length; i < len; i++) {
          if (createDebug.names[i].test(name)) {
            return true;
          }
        }
        return false;
      }
      function toNamespace(regexp) {
        return regexp.toString().substring(2, regexp.toString().length - 2).replace(/\.\*\?$/, "*");
      }
      function coerce(val) {
        if (val instanceof Error) {
          return val.stack || val.message;
        }
        return val;
      }
      function destroy() {
        console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.");
      }
      createDebug.enable(createDebug.load());
      return createDebug;
    }
    module2.exports = setup;
  }
});

// node_modules/debug/src/browser.js
var require_browser = __commonJS({
  "node_modules/debug/src/browser.js"(exports2, module2) {
    exports2.formatArgs = formatArgs;
    exports2.save = save;
    exports2.load = load;
    exports2.useColors = useColors;
    exports2.storage = localstorage();
    exports2.destroy = (() => {
      let warned = false;
      return () => {
        if (!warned) {
          warned = true;
          console.warn("Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.");
        }
      };
    })();
    exports2.colors = [
      "#0000CC",
      "#0000FF",
      "#0033CC",
      "#0033FF",
      "#0066CC",
      "#0066FF",
      "#0099CC",
      "#0099FF",
      "#00CC00",
      "#00CC33",
      "#00CC66",
      "#00CC99",
      "#00CCCC",
      "#00CCFF",
      "#3300CC",
      "#3300FF",
      "#3333CC",
      "#3333FF",
      "#3366CC",
      "#3366FF",
      "#3399CC",
      "#3399FF",
      "#33CC00",
      "#33CC33",
      "#33CC66",
      "#33CC99",
      "#33CCCC",
      "#33CCFF",
      "#6600CC",
      "#6600FF",
      "#6633CC",
      "#6633FF",
      "#66CC00",
      "#66CC33",
      "#9900CC",
      "#9900FF",
      "#9933CC",
      "#9933FF",
      "#99CC00",
      "#99CC33",
      "#CC0000",
      "#CC0033",
      "#CC0066",
      "#CC0099",
      "#CC00CC",
      "#CC00FF",
      "#CC3300",
      "#CC3333",
      "#CC3366",
      "#CC3399",
      "#CC33CC",
      "#CC33FF",
      "#CC6600",
      "#CC6633",
      "#CC9900",
      "#CC9933",
      "#CCCC00",
      "#CCCC33",
      "#FF0000",
      "#FF0033",
      "#FF0066",
      "#FF0099",
      "#FF00CC",
      "#FF00FF",
      "#FF3300",
      "#FF3333",
      "#FF3366",
      "#FF3399",
      "#FF33CC",
      "#FF33FF",
      "#FF6600",
      "#FF6633",
      "#FF9900",
      "#FF9933",
      "#FFCC00",
      "#FFCC33"
    ];
    function useColors() {
      if (typeof window !== "undefined" && window.process && (window.process.type === "renderer" || window.process.__nwjs)) {
        return true;
      }
      if (typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)) {
        return false;
      }
      return typeof document !== "undefined" && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance || typeof window !== "undefined" && window.console && (window.console.firebug || window.console.exception && window.console.table) || typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/) && parseInt(RegExp.$1, 10) >= 31 || typeof navigator !== "undefined" && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/);
    }
    function formatArgs(args) {
      args[0] = (this.useColors ? "%c" : "") + this.namespace + (this.useColors ? " %c" : " ") + args[0] + (this.useColors ? "%c " : " ") + "+" + module2.exports.humanize(this.diff);
      if (!this.useColors) {
        return;
      }
      const c = "color: " + this.color;
      args.splice(1, 0, c, "color: inherit");
      let index = 0;
      let lastC = 0;
      args[0].replace(/%[a-zA-Z%]/g, (match) => {
        if (match === "%%") {
          return;
        }
        index++;
        if (match === "%c") {
          lastC = index;
        }
      });
      args.splice(lastC, 0, c);
    }
    exports2.log = console.debug || console.log || (() => {
    });
    function save(namespaces) {
      try {
        if (namespaces) {
          exports2.storage.setItem("debug", namespaces);
        } else {
          exports2.storage.removeItem("debug");
        }
      } catch (error) {
      }
    }
    function load() {
      let r;
      try {
        r = exports2.storage.getItem("debug");
      } catch (error) {
      }
      if (!r && typeof process !== "undefined" && "env" in process) {
        r = process.env.DEBUG;
      }
      return r;
    }
    function localstorage() {
      try {
        return localStorage;
      } catch (error) {
      }
    }
    module2.exports = require_common()(exports2);
    var { formatters } = module2.exports;
    formatters.j = function(v) {
      try {
        return JSON.stringify(v);
      } catch (error) {
        return "[UnexpectedJSONParseError]: " + error.message;
      }
    };
  }
});

// node_modules/has-flag/index.js
var require_has_flag = __commonJS({
  "node_modules/has-flag/index.js"(exports2, module2) {
    "use strict";
    module2.exports = (flag, argv = process.argv) => {
      const prefix = flag.startsWith("-") ? "" : flag.length === 1 ? "-" : "--";
      const position = argv.indexOf(prefix + flag);
      const terminatorPosition = argv.indexOf("--");
      return position !== -1 && (terminatorPosition === -1 || position < terminatorPosition);
    };
  }
});

// node_modules/supports-color/index.js
var require_supports_color = __commonJS({
  "node_modules/supports-color/index.js"(exports2, module2) {
    "use strict";
    var os2 = require("os");
    var tty = require("tty");
    var hasFlag = require_has_flag();
    var { env } = process;
    var forceColor;
    if (hasFlag("no-color") || hasFlag("no-colors") || hasFlag("color=false") || hasFlag("color=never")) {
      forceColor = 0;
    } else if (hasFlag("color") || hasFlag("colors") || hasFlag("color=true") || hasFlag("color=always")) {
      forceColor = 1;
    }
    if ("FORCE_COLOR" in env) {
      if (env.FORCE_COLOR === "true") {
        forceColor = 1;
      } else if (env.FORCE_COLOR === "false") {
        forceColor = 0;
      } else {
        forceColor = env.FORCE_COLOR.length === 0 ? 1 : Math.min(parseInt(env.FORCE_COLOR, 10), 3);
      }
    }
    function translateLevel(level) {
      if (level === 0) {
        return false;
      }
      return {
        level,
        hasBasic: true,
        has256: level >= 2,
        has16m: level >= 3
      };
    }
    function supportsColor(haveStream, streamIsTTY) {
      if (forceColor === 0) {
        return 0;
      }
      if (hasFlag("color=16m") || hasFlag("color=full") || hasFlag("color=truecolor")) {
        return 3;
      }
      if (hasFlag("color=256")) {
        return 2;
      }
      if (haveStream && !streamIsTTY && forceColor === void 0) {
        return 0;
      }
      const min = forceColor || 0;
      if (env.TERM === "dumb") {
        return min;
      }
      if (process.platform === "win32") {
        const osRelease = os2.release().split(".");
        if (Number(osRelease[0]) >= 10 && Number(osRelease[2]) >= 10586) {
          return Number(osRelease[2]) >= 14931 ? 3 : 2;
        }
        return 1;
      }
      if ("CI" in env) {
        if (["TRAVIS", "CIRCLECI", "APPVEYOR", "GITLAB_CI", "GITHUB_ACTIONS", "BUILDKITE"].some((sign) => sign in env) || env.CI_NAME === "codeship") {
          return 1;
        }
        return min;
      }
      if ("TEAMCITY_VERSION" in env) {
        return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(env.TEAMCITY_VERSION) ? 1 : 0;
      }
      if (env.COLORTERM === "truecolor") {
        return 3;
      }
      if ("TERM_PROGRAM" in env) {
        const version = parseInt((env.TERM_PROGRAM_VERSION || "").split(".")[0], 10);
        switch (env.TERM_PROGRAM) {
          case "iTerm.app":
            return version >= 3 ? 3 : 2;
          case "Apple_Terminal":
            return 2;
        }
      }
      if (/-256(color)?$/i.test(env.TERM)) {
        return 2;
      }
      if (/^screen|^xterm|^vt100|^vt220|^rxvt|color|ansi|cygwin|linux/i.test(env.TERM)) {
        return 1;
      }
      if ("COLORTERM" in env) {
        return 1;
      }
      return min;
    }
    function getSupportLevel(stream) {
      const level = supportsColor(stream, stream && stream.isTTY);
      return translateLevel(level);
    }
    module2.exports = {
      supportsColor: getSupportLevel,
      stdout: translateLevel(supportsColor(true, tty.isatty(1))),
      stderr: translateLevel(supportsColor(true, tty.isatty(2)))
    };
  }
});

// node_modules/debug/src/node.js
var require_node = __commonJS({
  "node_modules/debug/src/node.js"(exports2, module2) {
    var tty = require("tty");
    var util = require("util");
    exports2.init = init2;
    exports2.log = log;
    exports2.formatArgs = formatArgs;
    exports2.save = save;
    exports2.load = load;
    exports2.useColors = useColors;
    exports2.destroy = util.deprecate(
      () => {
      },
      "Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`."
    );
    exports2.colors = [6, 2, 3, 4, 5, 1];
    try {
      const supportsColor = require_supports_color();
      if (supportsColor && (supportsColor.stderr || supportsColor).level >= 2) {
        exports2.colors = [
          20,
          21,
          26,
          27,
          32,
          33,
          38,
          39,
          40,
          41,
          42,
          43,
          44,
          45,
          56,
          57,
          62,
          63,
          68,
          69,
          74,
          75,
          76,
          77,
          78,
          79,
          80,
          81,
          92,
          93,
          98,
          99,
          112,
          113,
          128,
          129,
          134,
          135,
          148,
          149,
          160,
          161,
          162,
          163,
          164,
          165,
          166,
          167,
          168,
          169,
          170,
          171,
          172,
          173,
          178,
          179,
          184,
          185,
          196,
          197,
          198,
          199,
          200,
          201,
          202,
          203,
          204,
          205,
          206,
          207,
          208,
          209,
          214,
          215,
          220,
          221
        ];
      }
    } catch (error) {
    }
    exports2.inspectOpts = Object.keys(process.env).filter((key) => {
      return /^debug_/i.test(key);
    }).reduce((obj, key) => {
      const prop = key.substring(6).toLowerCase().replace(/_([a-z])/g, (_, k) => {
        return k.toUpperCase();
      });
      let val = process.env[key];
      if (/^(yes|on|true|enabled)$/i.test(val)) {
        val = true;
      } else if (/^(no|off|false|disabled)$/i.test(val)) {
        val = false;
      } else if (val === "null") {
        val = null;
      } else {
        val = Number(val);
      }
      obj[prop] = val;
      return obj;
    }, {});
    function useColors() {
      return "colors" in exports2.inspectOpts ? Boolean(exports2.inspectOpts.colors) : tty.isatty(process.stderr.fd);
    }
    function formatArgs(args) {
      const { namespace: name, useColors: useColors2 } = this;
      if (useColors2) {
        const c = this.color;
        const colorCode = "\x1B[3" + (c < 8 ? c : "8;5;" + c);
        const prefix = `  ${colorCode};1m${name} \x1B[0m`;
        args[0] = prefix + args[0].split("\n").join("\n" + prefix);
        args.push(colorCode + "m+" + module2.exports.humanize(this.diff) + "\x1B[0m");
      } else {
        args[0] = getDate() + name + " " + args[0];
      }
    }
    function getDate() {
      if (exports2.inspectOpts.hideDate) {
        return "";
      }
      return new Date().toISOString() + " ";
    }
    function log(...args) {
      return process.stderr.write(util.format(...args) + "\n");
    }
    function save(namespaces) {
      if (namespaces) {
        process.env.DEBUG = namespaces;
      } else {
        delete process.env.DEBUG;
      }
    }
    function load() {
      return process.env.DEBUG;
    }
    function init2(debug) {
      debug.inspectOpts = {};
      const keys = Object.keys(exports2.inspectOpts);
      for (let i = 0; i < keys.length; i++) {
        debug.inspectOpts[keys[i]] = exports2.inspectOpts[keys[i]];
      }
    }
    module2.exports = require_common()(exports2);
    var { formatters } = module2.exports;
    formatters.o = function(v) {
      this.inspectOpts.colors = this.useColors;
      return util.inspect(v, this.inspectOpts).split("\n").map((str) => str.trim()).join(" ");
    };
    formatters.O = function(v) {
      this.inspectOpts.colors = this.useColors;
      return util.inspect(v, this.inspectOpts);
    };
  }
});

// node_modules/debug/src/index.js
var require_src = __commonJS({
  "node_modules/debug/src/index.js"(exports2, module2) {
    if (typeof process === "undefined" || process.type === "renderer" || process.browser === true || process.__nwjs) {
      module2.exports = require_browser();
    } else {
      module2.exports = require_node();
    }
  }
});

// node_modules/follow-redirects/debug.js
var require_debug = __commonJS({
  "node_modules/follow-redirects/debug.js"(exports2, module2) {
    var debug;
    module2.exports = function() {
      if (!debug) {
        try {
          debug = require_src()("follow-redirects");
        } catch (error) {
        }
        if (typeof debug !== "function") {
          debug = function() {
          };
        }
      }
      debug.apply(null, arguments);
    };
  }
});

// node_modules/follow-redirects/index.js
var require_follow_redirects = __commonJS({
  "node_modules/follow-redirects/index.js"(exports2, module2) {
    var url = require("url");
    var URL2 = url.URL;
    var http = require("http");
    var https = require("https");
    var Writable = require("stream").Writable;
    var assert = require("assert");
    var debug = require_debug();
    var useNativeURL = false;
    try {
      assert(new URL2());
    } catch (error) {
      useNativeURL = error.code === "ERR_INVALID_URL";
    }
    var preservedUrlFields = [
      "auth",
      "host",
      "hostname",
      "href",
      "path",
      "pathname",
      "port",
      "protocol",
      "query",
      "search",
      "hash"
    ];
    var events = ["abort", "aborted", "connect", "error", "socket", "timeout"];
    var eventHandlers = /* @__PURE__ */ Object.create(null);
    events.forEach(function(event) {
      eventHandlers[event] = function(arg1, arg2, arg3) {
        this._redirectable.emit(event, arg1, arg2, arg3);
      };
    });
    var InvalidUrlError = createErrorType(
      "ERR_INVALID_URL",
      "Invalid URL",
      TypeError
    );
    var RedirectionError = createErrorType(
      "ERR_FR_REDIRECTION_FAILURE",
      "Redirected request failed"
    );
    var TooManyRedirectsError = createErrorType(
      "ERR_FR_TOO_MANY_REDIRECTS",
      "Maximum number of redirects exceeded",
      RedirectionError
    );
    var MaxBodyLengthExceededError = createErrorType(
      "ERR_FR_MAX_BODY_LENGTH_EXCEEDED",
      "Request body larger than maxBodyLength limit"
    );
    var WriteAfterEndError = createErrorType(
      "ERR_STREAM_WRITE_AFTER_END",
      "write after end"
    );
    var destroy = Writable.prototype.destroy || noop;
    function RedirectableRequest(options, responseCallback) {
      Writable.call(this);
      this._sanitizeOptions(options);
      this._options = options;
      this._ended = false;
      this._ending = false;
      this._redirectCount = 0;
      this._redirects = [];
      this._requestBodyLength = 0;
      this._requestBodyBuffers = [];
      if (responseCallback) {
        this.on("response", responseCallback);
      }
      var self2 = this;
      this._onNativeResponse = function(response) {
        try {
          self2._processResponse(response);
        } catch (cause) {
          self2.emit("error", cause instanceof RedirectionError ? cause : new RedirectionError({ cause }));
        }
      };
      this._performRequest();
    }
    RedirectableRequest.prototype = Object.create(Writable.prototype);
    RedirectableRequest.prototype.abort = function() {
      destroyRequest(this._currentRequest);
      this._currentRequest.abort();
      this.emit("abort");
    };
    RedirectableRequest.prototype.destroy = function(error) {
      destroyRequest(this._currentRequest, error);
      destroy.call(this, error);
      return this;
    };
    RedirectableRequest.prototype.write = function(data, encoding, callback) {
      if (this._ending) {
        throw new WriteAfterEndError();
      }
      if (!isString(data) && !isBuffer(data)) {
        throw new TypeError("data should be a string, Buffer or Uint8Array");
      }
      if (isFunction(encoding)) {
        callback = encoding;
        encoding = null;
      }
      if (data.length === 0) {
        if (callback) {
          callback();
        }
        return;
      }
      if (this._requestBodyLength + data.length <= this._options.maxBodyLength) {
        this._requestBodyLength += data.length;
        this._requestBodyBuffers.push({ data, encoding });
        this._currentRequest.write(data, encoding, callback);
      } else {
        this.emit("error", new MaxBodyLengthExceededError());
        this.abort();
      }
    };
    RedirectableRequest.prototype.end = function(data, encoding, callback) {
      if (isFunction(data)) {
        callback = data;
        data = encoding = null;
      } else if (isFunction(encoding)) {
        callback = encoding;
        encoding = null;
      }
      if (!data) {
        this._ended = this._ending = true;
        this._currentRequest.end(null, null, callback);
      } else {
        var self2 = this;
        var currentRequest = this._currentRequest;
        this.write(data, encoding, function() {
          self2._ended = true;
          currentRequest.end(null, null, callback);
        });
        this._ending = true;
      }
    };
    RedirectableRequest.prototype.setHeader = function(name, value) {
      this._options.headers[name] = value;
      this._currentRequest.setHeader(name, value);
    };
    RedirectableRequest.prototype.removeHeader = function(name) {
      delete this._options.headers[name];
      this._currentRequest.removeHeader(name);
    };
    RedirectableRequest.prototype.setTimeout = function(msecs, callback) {
      var self2 = this;
      function destroyOnTimeout(socket) {
        socket.setTimeout(msecs);
        socket.removeListener("timeout", socket.destroy);
        socket.addListener("timeout", socket.destroy);
      }
      function startTimer(socket) {
        if (self2._timeout) {
          clearTimeout(self2._timeout);
        }
        self2._timeout = setTimeout(function() {
          self2.emit("timeout");
          clearTimer();
        }, msecs);
        destroyOnTimeout(socket);
      }
      function clearTimer() {
        if (self2._timeout) {
          clearTimeout(self2._timeout);
          self2._timeout = null;
        }
        self2.removeListener("abort", clearTimer);
        self2.removeListener("error", clearTimer);
        self2.removeListener("response", clearTimer);
        self2.removeListener("close", clearTimer);
        if (callback) {
          self2.removeListener("timeout", callback);
        }
        if (!self2.socket) {
          self2._currentRequest.removeListener("socket", startTimer);
        }
      }
      if (callback) {
        this.on("timeout", callback);
      }
      if (this.socket) {
        startTimer(this.socket);
      } else {
        this._currentRequest.once("socket", startTimer);
      }
      this.on("socket", destroyOnTimeout);
      this.on("abort", clearTimer);
      this.on("error", clearTimer);
      this.on("response", clearTimer);
      this.on("close", clearTimer);
      return this;
    };
    [
      "flushHeaders",
      "getHeader",
      "setNoDelay",
      "setSocketKeepAlive"
    ].forEach(function(method) {
      RedirectableRequest.prototype[method] = function(a, b) {
        return this._currentRequest[method](a, b);
      };
    });
    ["aborted", "connection", "socket"].forEach(function(property) {
      Object.defineProperty(RedirectableRequest.prototype, property, {
        get: function() {
          return this._currentRequest[property];
        }
      });
    });
    RedirectableRequest.prototype._sanitizeOptions = function(options) {
      if (!options.headers) {
        options.headers = {};
      }
      if (options.host) {
        if (!options.hostname) {
          options.hostname = options.host;
        }
        delete options.host;
      }
      if (!options.pathname && options.path) {
        var searchPos = options.path.indexOf("?");
        if (searchPos < 0) {
          options.pathname = options.path;
        } else {
          options.pathname = options.path.substring(0, searchPos);
          options.search = options.path.substring(searchPos);
        }
      }
    };
    RedirectableRequest.prototype._performRequest = function() {
      var protocol = this._options.protocol;
      var nativeProtocol = this._options.nativeProtocols[protocol];
      if (!nativeProtocol) {
        throw new TypeError("Unsupported protocol " + protocol);
      }
      if (this._options.agents) {
        var scheme = protocol.slice(0, -1);
        this._options.agent = this._options.agents[scheme];
      }
      var request = this._currentRequest = nativeProtocol.request(this._options, this._onNativeResponse);
      request._redirectable = this;
      for (var event of events) {
        request.on(event, eventHandlers[event]);
      }
      this._currentUrl = /^\//.test(this._options.path) ? url.format(this._options) : this._options.path;
      if (this._isRedirect) {
        var i = 0;
        var self2 = this;
        var buffers = this._requestBodyBuffers;
        (function writeNext(error) {
          if (request === self2._currentRequest) {
            if (error) {
              self2.emit("error", error);
            } else if (i < buffers.length) {
              var buffer = buffers[i++];
              if (!request.finished) {
                request.write(buffer.data, buffer.encoding, writeNext);
              }
            } else if (self2._ended) {
              request.end();
            }
          }
        })();
      }
    };
    RedirectableRequest.prototype._processResponse = function(response) {
      var statusCode = response.statusCode;
      if (this._options.trackRedirects) {
        this._redirects.push({
          url: this._currentUrl,
          headers: response.headers,
          statusCode
        });
      }
      var location = response.headers.location;
      if (!location || this._options.followRedirects === false || statusCode < 300 || statusCode >= 400) {
        response.responseUrl = this._currentUrl;
        response.redirects = this._redirects;
        this.emit("response", response);
        this._requestBodyBuffers = [];
        return;
      }
      destroyRequest(this._currentRequest);
      response.destroy();
      if (++this._redirectCount > this._options.maxRedirects) {
        throw new TooManyRedirectsError();
      }
      var requestHeaders;
      var beforeRedirect = this._options.beforeRedirect;
      if (beforeRedirect) {
        requestHeaders = Object.assign({
          Host: response.req.getHeader("host")
        }, this._options.headers);
      }
      var method = this._options.method;
      if ((statusCode === 301 || statusCode === 302) && this._options.method === "POST" || statusCode === 303 && !/^(?:GET|HEAD)$/.test(this._options.method)) {
        this._options.method = "GET";
        this._requestBodyBuffers = [];
        removeMatchingHeaders(/^content-/i, this._options.headers);
      }
      var currentHostHeader = removeMatchingHeaders(/^host$/i, this._options.headers);
      var currentUrlParts = parseUrl(this._currentUrl);
      var currentHost = currentHostHeader || currentUrlParts.host;
      var currentUrl = /^\w+:/.test(location) ? this._currentUrl : url.format(Object.assign(currentUrlParts, { host: currentHost }));
      var redirectUrl = resolveUrl(location, currentUrl);
      debug("redirecting to", redirectUrl.href);
      this._isRedirect = true;
      spreadUrlObject(redirectUrl, this._options);
      if (redirectUrl.protocol !== currentUrlParts.protocol && redirectUrl.protocol !== "https:" || redirectUrl.host !== currentHost && !isSubdomain(redirectUrl.host, currentHost)) {
        removeMatchingHeaders(/^(?:(?:proxy-)?authorization|cookie)$/i, this._options.headers);
      }
      if (isFunction(beforeRedirect)) {
        var responseDetails = {
          headers: response.headers,
          statusCode
        };
        var requestDetails = {
          url: currentUrl,
          method,
          headers: requestHeaders
        };
        beforeRedirect(this._options, responseDetails, requestDetails);
        this._sanitizeOptions(this._options);
      }
      this._performRequest();
    };
    function wrap(protocols) {
      var exports3 = {
        maxRedirects: 21,
        maxBodyLength: 10 * 1024 * 1024
      };
      var nativeProtocols = {};
      Object.keys(protocols).forEach(function(scheme) {
        var protocol = scheme + ":";
        var nativeProtocol = nativeProtocols[protocol] = protocols[scheme];
        var wrappedProtocol = exports3[scheme] = Object.create(nativeProtocol);
        function request(input, options, callback) {
          if (isURL(input)) {
            input = spreadUrlObject(input);
          } else if (isString(input)) {
            input = spreadUrlObject(parseUrl(input));
          } else {
            callback = options;
            options = validateUrl(input);
            input = { protocol };
          }
          if (isFunction(options)) {
            callback = options;
            options = null;
          }
          options = Object.assign({
            maxRedirects: exports3.maxRedirects,
            maxBodyLength: exports3.maxBodyLength
          }, input, options);
          options.nativeProtocols = nativeProtocols;
          if (!isString(options.host) && !isString(options.hostname)) {
            options.hostname = "::1";
          }
          assert.equal(options.protocol, protocol, "protocol mismatch");
          debug("options", options);
          return new RedirectableRequest(options, callback);
        }
        function get(input, options, callback) {
          var wrappedRequest = wrappedProtocol.request(input, options, callback);
          wrappedRequest.end();
          return wrappedRequest;
        }
        Object.defineProperties(wrappedProtocol, {
          request: { value: request, configurable: true, enumerable: true, writable: true },
          get: { value: get, configurable: true, enumerable: true, writable: true }
        });
      });
      return exports3;
    }
    function noop() {
    }
    function parseUrl(input) {
      var parsed;
      if (useNativeURL) {
        parsed = new URL2(input);
      } else {
        parsed = validateUrl(url.parse(input));
        if (!isString(parsed.protocol)) {
          throw new InvalidUrlError({ input });
        }
      }
      return parsed;
    }
    function resolveUrl(relative, base) {
      return useNativeURL ? new URL2(relative, base) : parseUrl(url.resolve(base, relative));
    }
    function validateUrl(input) {
      if (/^\[/.test(input.hostname) && !/^\[[:0-9a-f]+\]$/i.test(input.hostname)) {
        throw new InvalidUrlError({ input: input.href || input });
      }
      if (/^\[/.test(input.host) && !/^\[[:0-9a-f]+\](:\d+)?$/i.test(input.host)) {
        throw new InvalidUrlError({ input: input.href || input });
      }
      return input;
    }
    function spreadUrlObject(urlObject, target) {
      var spread = target || {};
      for (var key of preservedUrlFields) {
        spread[key] = urlObject[key];
      }
      if (spread.hostname.startsWith("[")) {
        spread.hostname = spread.hostname.slice(1, -1);
      }
      if (spread.port !== "") {
        spread.port = Number(spread.port);
      }
      spread.path = spread.search ? spread.pathname + spread.search : spread.pathname;
      return spread;
    }
    function removeMatchingHeaders(regex, headers) {
      var lastValue;
      for (var header in headers) {
        if (regex.test(header)) {
          lastValue = headers[header];
          delete headers[header];
        }
      }
      return lastValue === null || typeof lastValue === "undefined" ? void 0 : String(lastValue).trim();
    }
    function createErrorType(code, message, baseClass) {
      function CustomError(properties) {
        Error.captureStackTrace(this, this.constructor);
        Object.assign(this, properties || {});
        this.code = code;
        this.message = this.cause ? message + ": " + this.cause.message : message;
      }
      CustomError.prototype = new (baseClass || Error)();
      Object.defineProperties(CustomError.prototype, {
        constructor: {
          value: CustomError,
          enumerable: false
        },
        name: {
          value: "Error [" + code + "]",
          enumerable: false
        }
      });
      return CustomError;
    }
    function destroyRequest(request, error) {
      for (var event of events) {
        request.removeListener(event, eventHandlers[event]);
      }
      request.on("error", noop);
      request.destroy(error);
    }
    function isSubdomain(subdomain, domain) {
      assert(isString(subdomain) && isString(domain));
      var dot = subdomain.length - domain.length - 1;
      return dot > 0 && subdomain[dot] === "." && subdomain.endsWith(domain);
    }
    function isString(value) {
      return typeof value === "string" || value instanceof String;
    }
    function isFunction(value) {
      return typeof value === "function";
    }
    function isBuffer(value) {
      return typeof value === "object" && "length" in value;
    }
    function isURL(value) {
      return URL2 && value instanceof URL2;
    }
    module2.exports = wrap({ http, https });
    module2.exports.wrap = wrap;
  }
});

// node_modules/axios/package.json
var require_package = __commonJS({
  "node_modules/axios/package.json"(exports2, module2) {
    module2.exports = {
      name: "axios",
      version: "0.21.4",
      description: "Promise based HTTP client for the browser and node.js",
      main: "index.js",
      scripts: {
        test: "grunt test",
        start: "node ./sandbox/server.js",
        build: "NODE_ENV=production grunt build",
        preversion: "npm test",
        version: "npm run build && grunt version && git add -A dist && git add CHANGELOG.md bower.json package.json",
        postversion: "git push && git push --tags",
        examples: "node ./examples/server.js",
        coveralls: "cat coverage/lcov.info | ./node_modules/coveralls/bin/coveralls.js",
        fix: "eslint --fix lib/**/*.js"
      },
      repository: {
        type: "git",
        url: "https://github.com/axios/axios.git"
      },
      keywords: [
        "xhr",
        "http",
        "ajax",
        "promise",
        "node"
      ],
      author: "Matt Zabriskie",
      license: "MIT",
      bugs: {
        url: "https://github.com/axios/axios/issues"
      },
      homepage: "https://axios-http.com",
      devDependencies: {
        coveralls: "^3.0.0",
        "es6-promise": "^4.2.4",
        grunt: "^1.3.0",
        "grunt-banner": "^0.6.0",
        "grunt-cli": "^1.2.0",
        "grunt-contrib-clean": "^1.1.0",
        "grunt-contrib-watch": "^1.0.0",
        "grunt-eslint": "^23.0.0",
        "grunt-karma": "^4.0.0",
        "grunt-mocha-test": "^0.13.3",
        "grunt-ts": "^6.0.0-beta.19",
        "grunt-webpack": "^4.0.2",
        "istanbul-instrumenter-loader": "^1.0.0",
        "jasmine-core": "^2.4.1",
        karma: "^6.3.2",
        "karma-chrome-launcher": "^3.1.0",
        "karma-firefox-launcher": "^2.1.0",
        "karma-jasmine": "^1.1.1",
        "karma-jasmine-ajax": "^0.1.13",
        "karma-safari-launcher": "^1.0.0",
        "karma-sauce-launcher": "^4.3.6",
        "karma-sinon": "^1.0.5",
        "karma-sourcemap-loader": "^0.3.8",
        "karma-webpack": "^4.0.2",
        "load-grunt-tasks": "^3.5.2",
        minimist: "^1.2.0",
        mocha: "^8.2.1",
        sinon: "^4.5.0",
        "terser-webpack-plugin": "^4.2.3",
        typescript: "^4.0.5",
        "url-search-params": "^0.10.0",
        webpack: "^4.44.2",
        "webpack-dev-server": "^3.11.0"
      },
      browser: {
        "./lib/adapters/http.js": "./lib/adapters/xhr.js"
      },
      jsdelivr: "dist/axios.min.js",
      unpkg: "dist/axios.min.js",
      typings: "./index.d.ts",
      dependencies: {
        "follow-redirects": "^1.14.0"
      },
      bundlesize: [
        {
          path: "./dist/axios.min.js",
          threshold: "5kB"
        }
      ]
    };
  }
});

// node_modules/axios/lib/adapters/http.js
var require_http = __commonJS({
  "node_modules/axios/lib/adapters/http.js"(exports2, module2) {
    "use strict";
    var utils = require_utils();
    var settle = require_settle();
    var buildFullPath = require_buildFullPath();
    var buildURL = require_buildURL();
    var http = require("http");
    var https = require("https");
    var httpFollow = require_follow_redirects().http;
    var httpsFollow = require_follow_redirects().https;
    var url = require("url");
    var zlib = require("zlib");
    var pkg = require_package();
    var createError = require_createError();
    var enhanceError = require_enhanceError();
    var isHttps = /https:?/;
    function setProxy(options, proxy, location) {
      options.hostname = proxy.host;
      options.host = proxy.host;
      options.port = proxy.port;
      options.path = location;
      if (proxy.auth) {
        var base64 = Buffer.from(proxy.auth.username + ":" + proxy.auth.password, "utf8").toString("base64");
        options.headers["Proxy-Authorization"] = "Basic " + base64;
      }
      options.beforeRedirect = function beforeRedirect(redirection) {
        redirection.headers.host = redirection.host;
        setProxy(redirection, proxy, redirection.href);
      };
    }
    module2.exports = function httpAdapter(config) {
      return new Promise(function dispatchHttpRequest(resolvePromise, rejectPromise) {
        var resolve = function resolve2(value) {
          resolvePromise(value);
        };
        var reject = function reject2(value) {
          rejectPromise(value);
        };
        var data = config.data;
        var headers = config.headers;
        if ("User-Agent" in headers || "user-agent" in headers) {
          if (!headers["User-Agent"] && !headers["user-agent"]) {
            delete headers["User-Agent"];
            delete headers["user-agent"];
          }
        } else {
          headers["User-Agent"] = "axios/" + pkg.version;
        }
        if (data && !utils.isStream(data)) {
          if (Buffer.isBuffer(data)) {
          } else if (utils.isArrayBuffer(data)) {
            data = Buffer.from(new Uint8Array(data));
          } else if (utils.isString(data)) {
            data = Buffer.from(data, "utf-8");
          } else {
            return reject(createError(
              "Data after transformation must be a string, an ArrayBuffer, a Buffer, or a Stream",
              config
            ));
          }
          headers["Content-Length"] = data.length;
        }
        var auth = void 0;
        if (config.auth) {
          var username = config.auth.username || "";
          var password = config.auth.password || "";
          auth = username + ":" + password;
        }
        var fullPath = buildFullPath(config.baseURL, config.url);
        var parsed = url.parse(fullPath);
        var protocol = parsed.protocol || "http:";
        if (!auth && parsed.auth) {
          var urlAuth = parsed.auth.split(":");
          var urlUsername = urlAuth[0] || "";
          var urlPassword = urlAuth[1] || "";
          auth = urlUsername + ":" + urlPassword;
        }
        if (auth) {
          delete headers.Authorization;
        }
        var isHttpsRequest = isHttps.test(protocol);
        var agent = isHttpsRequest ? config.httpsAgent : config.httpAgent;
        var options = {
          path: buildURL(parsed.path, config.params, config.paramsSerializer).replace(/^\?/, ""),
          method: config.method.toUpperCase(),
          headers,
          agent,
          agents: { http: config.httpAgent, https: config.httpsAgent },
          auth
        };
        if (config.socketPath) {
          options.socketPath = config.socketPath;
        } else {
          options.hostname = parsed.hostname;
          options.port = parsed.port;
        }
        var proxy = config.proxy;
        if (!proxy && proxy !== false) {
          var proxyEnv = protocol.slice(0, -1) + "_proxy";
          var proxyUrl = process.env[proxyEnv] || process.env[proxyEnv.toUpperCase()];
          if (proxyUrl) {
            var parsedProxyUrl = url.parse(proxyUrl);
            var noProxyEnv = process.env.no_proxy || process.env.NO_PROXY;
            var shouldProxy = true;
            if (noProxyEnv) {
              var noProxy = noProxyEnv.split(",").map(function trim(s) {
                return s.trim();
              });
              shouldProxy = !noProxy.some(function proxyMatch(proxyElement) {
                if (!proxyElement) {
                  return false;
                }
                if (proxyElement === "*") {
                  return true;
                }
                if (proxyElement[0] === "." && parsed.hostname.substr(parsed.hostname.length - proxyElement.length) === proxyElement) {
                  return true;
                }
                return parsed.hostname === proxyElement;
              });
            }
            if (shouldProxy) {
              proxy = {
                host: parsedProxyUrl.hostname,
                port: parsedProxyUrl.port,
                protocol: parsedProxyUrl.protocol
              };
              if (parsedProxyUrl.auth) {
                var proxyUrlAuth = parsedProxyUrl.auth.split(":");
                proxy.auth = {
                  username: proxyUrlAuth[0],
                  password: proxyUrlAuth[1]
                };
              }
            }
          }
        }
        if (proxy) {
          options.headers.host = parsed.hostname + (parsed.port ? ":" + parsed.port : "");
          setProxy(options, proxy, protocol + "//" + parsed.hostname + (parsed.port ? ":" + parsed.port : "") + options.path);
        }
        var transport;
        var isHttpsProxy = isHttpsRequest && (proxy ? isHttps.test(proxy.protocol) : true);
        if (config.transport) {
          transport = config.transport;
        } else if (config.maxRedirects === 0) {
          transport = isHttpsProxy ? https : http;
        } else {
          if (config.maxRedirects) {
            options.maxRedirects = config.maxRedirects;
          }
          transport = isHttpsProxy ? httpsFollow : httpFollow;
        }
        if (config.maxBodyLength > -1) {
          options.maxBodyLength = config.maxBodyLength;
        }
        var req = transport.request(options, function handleResponse(res) {
          if (req.aborted)
            return;
          var stream = res;
          var lastRequest = res.req || req;
          if (res.statusCode !== 204 && lastRequest.method !== "HEAD" && config.decompress !== false) {
            switch (res.headers["content-encoding"]) {
              case "gzip":
              case "compress":
              case "deflate":
                stream = stream.pipe(zlib.createUnzip());
                delete res.headers["content-encoding"];
                break;
            }
          }
          var response = {
            status: res.statusCode,
            statusText: res.statusMessage,
            headers: res.headers,
            config,
            request: lastRequest
          };
          if (config.responseType === "stream") {
            response.data = stream;
            settle(resolve, reject, response);
          } else {
            var responseBuffer = [];
            var totalResponseBytes = 0;
            stream.on("data", function handleStreamData(chunk) {
              responseBuffer.push(chunk);
              totalResponseBytes += chunk.length;
              if (config.maxContentLength > -1 && totalResponseBytes > config.maxContentLength) {
                stream.destroy();
                reject(createError(
                  "maxContentLength size of " + config.maxContentLength + " exceeded",
                  config,
                  null,
                  lastRequest
                ));
              }
            });
            stream.on("error", function handleStreamError(err) {
              if (req.aborted)
                return;
              reject(enhanceError(err, config, null, lastRequest));
            });
            stream.on("end", function handleStreamEnd() {
              var responseData = Buffer.concat(responseBuffer);
              if (config.responseType !== "arraybuffer") {
                responseData = responseData.toString(config.responseEncoding);
                if (!config.responseEncoding || config.responseEncoding === "utf8") {
                  responseData = utils.stripBOM(responseData);
                }
              }
              response.data = responseData;
              settle(resolve, reject, response);
            });
          }
        });
        req.on("error", function handleRequestError(err) {
          if (req.aborted && err.code !== "ERR_FR_TOO_MANY_REDIRECTS")
            return;
          reject(enhanceError(err, config, null, req));
        });
        if (config.timeout) {
          var timeout = parseInt(config.timeout, 10);
          if (isNaN(timeout)) {
            reject(createError(
              "error trying to parse `config.timeout` to int",
              config,
              "ERR_PARSE_TIMEOUT",
              req
            ));
            return;
          }
          req.setTimeout(timeout, function handleRequestTimeout() {
            req.abort();
            reject(createError(
              "timeout of " + timeout + "ms exceeded",
              config,
              config.transitional && config.transitional.clarifyTimeoutError ? "ETIMEDOUT" : "ECONNABORTED",
              req
            ));
          });
        }
        if (config.cancelToken) {
          config.cancelToken.promise.then(function onCanceled(cancel) {
            if (req.aborted)
              return;
            req.abort();
            reject(cancel);
          });
        }
        if (utils.isStream(data)) {
          data.on("error", function handleStreamError(err) {
            reject(enhanceError(err, config, null, req));
          }).pipe(req);
        } else {
          req.end(data);
        }
      });
    };
  }
});

// node_modules/axios/lib/defaults.js
var require_defaults = __commonJS({
  "node_modules/axios/lib/defaults.js"(exports2, module2) {
    "use strict";
    var utils = require_utils();
    var normalizeHeaderName = require_normalizeHeaderName();
    var enhanceError = require_enhanceError();
    var DEFAULT_CONTENT_TYPE = {
      "Content-Type": "application/x-www-form-urlencoded"
    };
    function setContentTypeIfUnset(headers, value) {
      if (!utils.isUndefined(headers) && utils.isUndefined(headers["Content-Type"])) {
        headers["Content-Type"] = value;
      }
    }
    function getDefaultAdapter() {
      var adapter;
      if (typeof XMLHttpRequest !== "undefined") {
        adapter = require_xhr();
      } else if (typeof process !== "undefined" && Object.prototype.toString.call(process) === "[object process]") {
        adapter = require_http();
      }
      return adapter;
    }
    function stringifySafely(rawValue, parser, encoder) {
      if (utils.isString(rawValue)) {
        try {
          (parser || JSON.parse)(rawValue);
          return utils.trim(rawValue);
        } catch (e) {
          if (e.name !== "SyntaxError") {
            throw e;
          }
        }
      }
      return (encoder || JSON.stringify)(rawValue);
    }
    var defaults = {
      transitional: {
        silentJSONParsing: true,
        forcedJSONParsing: true,
        clarifyTimeoutError: false
      },
      adapter: getDefaultAdapter(),
      transformRequest: [function transformRequest(data, headers) {
        normalizeHeaderName(headers, "Accept");
        normalizeHeaderName(headers, "Content-Type");
        if (utils.isFormData(data) || utils.isArrayBuffer(data) || utils.isBuffer(data) || utils.isStream(data) || utils.isFile(data) || utils.isBlob(data)) {
          return data;
        }
        if (utils.isArrayBufferView(data)) {
          return data.buffer;
        }
        if (utils.isURLSearchParams(data)) {
          setContentTypeIfUnset(headers, "application/x-www-form-urlencoded;charset=utf-8");
          return data.toString();
        }
        if (utils.isObject(data) || headers && headers["Content-Type"] === "application/json") {
          setContentTypeIfUnset(headers, "application/json");
          return stringifySafely(data);
        }
        return data;
      }],
      transformResponse: [function transformResponse(data) {
        var transitional = this.transitional;
        var silentJSONParsing = transitional && transitional.silentJSONParsing;
        var forcedJSONParsing = transitional && transitional.forcedJSONParsing;
        var strictJSONParsing = !silentJSONParsing && this.responseType === "json";
        if (strictJSONParsing || forcedJSONParsing && utils.isString(data) && data.length) {
          try {
            return JSON.parse(data);
          } catch (e) {
            if (strictJSONParsing) {
              if (e.name === "SyntaxError") {
                throw enhanceError(e, this, "E_JSON_PARSE");
              }
              throw e;
            }
          }
        }
        return data;
      }],
      timeout: 0,
      xsrfCookieName: "XSRF-TOKEN",
      xsrfHeaderName: "X-XSRF-TOKEN",
      maxContentLength: -1,
      maxBodyLength: -1,
      validateStatus: function validateStatus(status) {
        return status >= 200 && status < 300;
      }
    };
    defaults.headers = {
      common: {
        "Accept": "application/json, text/plain, */*"
      }
    };
    utils.forEach(["delete", "get", "head"], function forEachMethodNoData(method) {
      defaults.headers[method] = {};
    });
    utils.forEach(["post", "put", "patch"], function forEachMethodWithData(method) {
      defaults.headers[method] = utils.merge(DEFAULT_CONTENT_TYPE);
    });
    module2.exports = defaults;
  }
});

// node_modules/axios/lib/core/transformData.js
var require_transformData = __commonJS({
  "node_modules/axios/lib/core/transformData.js"(exports2, module2) {
    "use strict";
    var utils = require_utils();
    var defaults = require_defaults();
    module2.exports = function transformData(data, headers, fns) {
      var context = this || defaults;
      utils.forEach(fns, function transform(fn) {
        data = fn.call(context, data, headers);
      });
      return data;
    };
  }
});

// node_modules/axios/lib/cancel/isCancel.js
var require_isCancel = __commonJS({
  "node_modules/axios/lib/cancel/isCancel.js"(exports2, module2) {
    "use strict";
    module2.exports = function isCancel(value) {
      return !!(value && value.__CANCEL__);
    };
  }
});

// node_modules/axios/lib/core/dispatchRequest.js
var require_dispatchRequest = __commonJS({
  "node_modules/axios/lib/core/dispatchRequest.js"(exports2, module2) {
    "use strict";
    var utils = require_utils();
    var transformData = require_transformData();
    var isCancel = require_isCancel();
    var defaults = require_defaults();
    function throwIfCancellationRequested(config) {
      if (config.cancelToken) {
        config.cancelToken.throwIfRequested();
      }
    }
    module2.exports = function dispatchRequest(config) {
      throwIfCancellationRequested(config);
      config.headers = config.headers || {};
      config.data = transformData.call(
        config,
        config.data,
        config.headers,
        config.transformRequest
      );
      config.headers = utils.merge(
        config.headers.common || {},
        config.headers[config.method] || {},
        config.headers
      );
      utils.forEach(
        ["delete", "get", "head", "post", "put", "patch", "common"],
        function cleanHeaderConfig(method) {
          delete config.headers[method];
        }
      );
      var adapter = config.adapter || defaults.adapter;
      return adapter(config).then(function onAdapterResolution(response) {
        throwIfCancellationRequested(config);
        response.data = transformData.call(
          config,
          response.data,
          response.headers,
          config.transformResponse
        );
        return response;
      }, function onAdapterRejection(reason) {
        if (!isCancel(reason)) {
          throwIfCancellationRequested(config);
          if (reason && reason.response) {
            reason.response.data = transformData.call(
              config,
              reason.response.data,
              reason.response.headers,
              config.transformResponse
            );
          }
        }
        return Promise.reject(reason);
      });
    };
  }
});

// node_modules/axios/lib/core/mergeConfig.js
var require_mergeConfig = __commonJS({
  "node_modules/axios/lib/core/mergeConfig.js"(exports2, module2) {
    "use strict";
    var utils = require_utils();
    module2.exports = function mergeConfig(config1, config2) {
      config2 = config2 || {};
      var config = {};
      var valueFromConfig2Keys = ["url", "method", "data"];
      var mergeDeepPropertiesKeys = ["headers", "auth", "proxy", "params"];
      var defaultToConfig2Keys = [
        "baseURL",
        "transformRequest",
        "transformResponse",
        "paramsSerializer",
        "timeout",
        "timeoutMessage",
        "withCredentials",
        "adapter",
        "responseType",
        "xsrfCookieName",
        "xsrfHeaderName",
        "onUploadProgress",
        "onDownloadProgress",
        "decompress",
        "maxContentLength",
        "maxBodyLength",
        "maxRedirects",
        "transport",
        "httpAgent",
        "httpsAgent",
        "cancelToken",
        "socketPath",
        "responseEncoding"
      ];
      var directMergeKeys = ["validateStatus"];
      function getMergedValue(target, source) {
        if (utils.isPlainObject(target) && utils.isPlainObject(source)) {
          return utils.merge(target, source);
        } else if (utils.isPlainObject(source)) {
          return utils.merge({}, source);
        } else if (utils.isArray(source)) {
          return source.slice();
        }
        return source;
      }
      function mergeDeepProperties(prop) {
        if (!utils.isUndefined(config2[prop])) {
          config[prop] = getMergedValue(config1[prop], config2[prop]);
        } else if (!utils.isUndefined(config1[prop])) {
          config[prop] = getMergedValue(void 0, config1[prop]);
        }
      }
      utils.forEach(valueFromConfig2Keys, function valueFromConfig2(prop) {
        if (!utils.isUndefined(config2[prop])) {
          config[prop] = getMergedValue(void 0, config2[prop]);
        }
      });
      utils.forEach(mergeDeepPropertiesKeys, mergeDeepProperties);
      utils.forEach(defaultToConfig2Keys, function defaultToConfig2(prop) {
        if (!utils.isUndefined(config2[prop])) {
          config[prop] = getMergedValue(void 0, config2[prop]);
        } else if (!utils.isUndefined(config1[prop])) {
          config[prop] = getMergedValue(void 0, config1[prop]);
        }
      });
      utils.forEach(directMergeKeys, function merge(prop) {
        if (prop in config2) {
          config[prop] = getMergedValue(config1[prop], config2[prop]);
        } else if (prop in config1) {
          config[prop] = getMergedValue(void 0, config1[prop]);
        }
      });
      var axiosKeys = valueFromConfig2Keys.concat(mergeDeepPropertiesKeys).concat(defaultToConfig2Keys).concat(directMergeKeys);
      var otherKeys = Object.keys(config1).concat(Object.keys(config2)).filter(function filterAxiosKeys(key) {
        return axiosKeys.indexOf(key) === -1;
      });
      utils.forEach(otherKeys, mergeDeepProperties);
      return config;
    };
  }
});

// node_modules/axios/lib/helpers/validator.js
var require_validator = __commonJS({
  "node_modules/axios/lib/helpers/validator.js"(exports2, module2) {
    "use strict";
    var pkg = require_package();
    var validators = {};
    ["object", "boolean", "number", "function", "string", "symbol"].forEach(function(type, i) {
      validators[type] = function validator(thing) {
        return typeof thing === type || "a" + (i < 1 ? "n " : " ") + type;
      };
    });
    var deprecatedWarnings = {};
    var currentVerArr = pkg.version.split(".");
    function isOlderVersion(version, thanVersion) {
      var pkgVersionArr = thanVersion ? thanVersion.split(".") : currentVerArr;
      var destVer = version.split(".");
      for (var i = 0; i < 3; i++) {
        if (pkgVersionArr[i] > destVer[i]) {
          return true;
        } else if (pkgVersionArr[i] < destVer[i]) {
          return false;
        }
      }
      return false;
    }
    validators.transitional = function transitional(validator, version, message) {
      var isDeprecated = version && isOlderVersion(version);
      function formatMessage(opt, desc) {
        return "[Axios v" + pkg.version + "] Transitional option '" + opt + "'" + desc + (message ? ". " + message : "");
      }
      return function(value, opt, opts) {
        if (validator === false) {
          throw new Error(formatMessage(opt, " has been removed in " + version));
        }
        if (isDeprecated && !deprecatedWarnings[opt]) {
          deprecatedWarnings[opt] = true;
          console.warn(
            formatMessage(
              opt,
              " has been deprecated since v" + version + " and will be removed in the near future"
            )
          );
        }
        return validator ? validator(value, opt, opts) : true;
      };
    };
    function assertOptions(options, schema, allowUnknown) {
      if (typeof options !== "object") {
        throw new TypeError("options must be an object");
      }
      var keys = Object.keys(options);
      var i = keys.length;
      while (i-- > 0) {
        var opt = keys[i];
        var validator = schema[opt];
        if (validator) {
          var value = options[opt];
          var result = value === void 0 || validator(value, opt, options);
          if (result !== true) {
            throw new TypeError("option " + opt + " must be " + result);
          }
          continue;
        }
        if (allowUnknown !== true) {
          throw Error("Unknown option " + opt);
        }
      }
    }
    module2.exports = {
      isOlderVersion,
      assertOptions,
      validators
    };
  }
});

// node_modules/axios/lib/core/Axios.js
var require_Axios = __commonJS({
  "node_modules/axios/lib/core/Axios.js"(exports2, module2) {
    "use strict";
    var utils = require_utils();
    var buildURL = require_buildURL();
    var InterceptorManager = require_InterceptorManager();
    var dispatchRequest = require_dispatchRequest();
    var mergeConfig = require_mergeConfig();
    var validator = require_validator();
    var validators = validator.validators;
    function Axios(instanceConfig) {
      this.defaults = instanceConfig;
      this.interceptors = {
        request: new InterceptorManager(),
        response: new InterceptorManager()
      };
    }
    Axios.prototype.request = function request(config) {
      if (typeof config === "string") {
        config = arguments[1] || {};
        config.url = arguments[0];
      } else {
        config = config || {};
      }
      config = mergeConfig(this.defaults, config);
      if (config.method) {
        config.method = config.method.toLowerCase();
      } else if (this.defaults.method) {
        config.method = this.defaults.method.toLowerCase();
      } else {
        config.method = "get";
      }
      var transitional = config.transitional;
      if (transitional !== void 0) {
        validator.assertOptions(transitional, {
          silentJSONParsing: validators.transitional(validators.boolean, "1.0.0"),
          forcedJSONParsing: validators.transitional(validators.boolean, "1.0.0"),
          clarifyTimeoutError: validators.transitional(validators.boolean, "1.0.0")
        }, false);
      }
      var requestInterceptorChain = [];
      var synchronousRequestInterceptors = true;
      this.interceptors.request.forEach(function unshiftRequestInterceptors(interceptor) {
        if (typeof interceptor.runWhen === "function" && interceptor.runWhen(config) === false) {
          return;
        }
        synchronousRequestInterceptors = synchronousRequestInterceptors && interceptor.synchronous;
        requestInterceptorChain.unshift(interceptor.fulfilled, interceptor.rejected);
      });
      var responseInterceptorChain = [];
      this.interceptors.response.forEach(function pushResponseInterceptors(interceptor) {
        responseInterceptorChain.push(interceptor.fulfilled, interceptor.rejected);
      });
      var promise;
      if (!synchronousRequestInterceptors) {
        var chain = [dispatchRequest, void 0];
        Array.prototype.unshift.apply(chain, requestInterceptorChain);
        chain = chain.concat(responseInterceptorChain);
        promise = Promise.resolve(config);
        while (chain.length) {
          promise = promise.then(chain.shift(), chain.shift());
        }
        return promise;
      }
      var newConfig = config;
      while (requestInterceptorChain.length) {
        var onFulfilled = requestInterceptorChain.shift();
        var onRejected = requestInterceptorChain.shift();
        try {
          newConfig = onFulfilled(newConfig);
        } catch (error) {
          onRejected(error);
          break;
        }
      }
      try {
        promise = dispatchRequest(newConfig);
      } catch (error) {
        return Promise.reject(error);
      }
      while (responseInterceptorChain.length) {
        promise = promise.then(responseInterceptorChain.shift(), responseInterceptorChain.shift());
      }
      return promise;
    };
    Axios.prototype.getUri = function getUri(config) {
      config = mergeConfig(this.defaults, config);
      return buildURL(config.url, config.params, config.paramsSerializer).replace(/^\?/, "");
    };
    utils.forEach(["delete", "get", "head", "options"], function forEachMethodNoData(method) {
      Axios.prototype[method] = function(url, config) {
        return this.request(mergeConfig(config || {}, {
          method,
          url,
          data: (config || {}).data
        }));
      };
    });
    utils.forEach(["post", "put", "patch"], function forEachMethodWithData(method) {
      Axios.prototype[method] = function(url, data, config) {
        return this.request(mergeConfig(config || {}, {
          method,
          url,
          data
        }));
      };
    });
    module2.exports = Axios;
  }
});

// node_modules/axios/lib/cancel/Cancel.js
var require_Cancel = __commonJS({
  "node_modules/axios/lib/cancel/Cancel.js"(exports2, module2) {
    "use strict";
    function Cancel(message) {
      this.message = message;
    }
    Cancel.prototype.toString = function toString() {
      return "Cancel" + (this.message ? ": " + this.message : "");
    };
    Cancel.prototype.__CANCEL__ = true;
    module2.exports = Cancel;
  }
});

// node_modules/axios/lib/cancel/CancelToken.js
var require_CancelToken = __commonJS({
  "node_modules/axios/lib/cancel/CancelToken.js"(exports2, module2) {
    "use strict";
    var Cancel = require_Cancel();
    function CancelToken(executor) {
      if (typeof executor !== "function") {
        throw new TypeError("executor must be a function.");
      }
      var resolvePromise;
      this.promise = new Promise(function promiseExecutor(resolve) {
        resolvePromise = resolve;
      });
      var token = this;
      executor(function cancel(message) {
        if (token.reason) {
          return;
        }
        token.reason = new Cancel(message);
        resolvePromise(token.reason);
      });
    }
    CancelToken.prototype.throwIfRequested = function throwIfRequested() {
      if (this.reason) {
        throw this.reason;
      }
    };
    CancelToken.source = function source() {
      var cancel;
      var token = new CancelToken(function executor(c) {
        cancel = c;
      });
      return {
        token,
        cancel
      };
    };
    module2.exports = CancelToken;
  }
});

// node_modules/axios/lib/helpers/spread.js
var require_spread = __commonJS({
  "node_modules/axios/lib/helpers/spread.js"(exports2, module2) {
    "use strict";
    module2.exports = function spread(callback) {
      return function wrap(arr) {
        return callback.apply(null, arr);
      };
    };
  }
});

// node_modules/axios/lib/helpers/isAxiosError.js
var require_isAxiosError = __commonJS({
  "node_modules/axios/lib/helpers/isAxiosError.js"(exports2, module2) {
    "use strict";
    module2.exports = function isAxiosError(payload) {
      return typeof payload === "object" && payload.isAxiosError === true;
    };
  }
});

// node_modules/axios/lib/axios.js
var require_axios = __commonJS({
  "node_modules/axios/lib/axios.js"(exports2, module2) {
    "use strict";
    var utils = require_utils();
    var bind = require_bind();
    var Axios = require_Axios();
    var mergeConfig = require_mergeConfig();
    var defaults = require_defaults();
    function createInstance(defaultConfig) {
      var context = new Axios(defaultConfig);
      var instance = bind(Axios.prototype.request, context);
      utils.extend(instance, Axios.prototype, context);
      utils.extend(instance, context);
      return instance;
    }
    var axios = createInstance(defaults);
    axios.Axios = Axios;
    axios.create = function create(instanceConfig) {
      return createInstance(mergeConfig(axios.defaults, instanceConfig));
    };
    axios.Cancel = require_Cancel();
    axios.CancelToken = require_CancelToken();
    axios.isCancel = require_isCancel();
    axios.all = function all(promises) {
      return Promise.all(promises);
    };
    axios.spread = require_spread();
    axios.isAxiosError = require_isAxiosError();
    module2.exports = axios;
    module2.exports.default = axios;
  }
});

// node_modules/axios/index.js
var require_axios2 = __commonJS({
  "node_modules/axios/index.js"(exports2, module2) {
    module2.exports = require_axios();
  }
});

// node_modules/safe-buffer/index.js
var require_safe_buffer = __commonJS({
  "node_modules/safe-buffer/index.js"(exports2, module2) {
    var buffer = require("buffer");
    var Buffer3 = buffer.Buffer;
    function copyProps(src, dst) {
      for (var key in src) {
        dst[key] = src[key];
      }
    }
    if (Buffer3.from && Buffer3.alloc && Buffer3.allocUnsafe && Buffer3.allocUnsafeSlow) {
      module2.exports = buffer;
    } else {
      copyProps(buffer, exports2);
      exports2.Buffer = SafeBuffer;
    }
    function SafeBuffer(arg, encodingOrOffset, length) {
      return Buffer3(arg, encodingOrOffset, length);
    }
    SafeBuffer.prototype = Object.create(Buffer3.prototype);
    copyProps(Buffer3, SafeBuffer);
    SafeBuffer.from = function(arg, encodingOrOffset, length) {
      if (typeof arg === "number") {
        throw new TypeError("Argument must not be a number");
      }
      return Buffer3(arg, encodingOrOffset, length);
    };
    SafeBuffer.alloc = function(size, fill, encoding) {
      if (typeof size !== "number") {
        throw new TypeError("Argument must be a number");
      }
      var buf = Buffer3(size);
      if (fill !== void 0) {
        if (typeof encoding === "string") {
          buf.fill(fill, encoding);
        } else {
          buf.fill(fill);
        }
      } else {
        buf.fill(0);
      }
      return buf;
    };
    SafeBuffer.allocUnsafe = function(size) {
      if (typeof size !== "number") {
        throw new TypeError("Argument must be a number");
      }
      return Buffer3(size);
    };
    SafeBuffer.allocUnsafeSlow = function(size) {
      if (typeof size !== "number") {
        throw new TypeError("Argument must be a number");
      }
      return buffer.SlowBuffer(size);
    };
  }
});

// node_modules/jws/lib/data-stream.js
var require_data_stream = __commonJS({
  "node_modules/jws/lib/data-stream.js"(exports2, module2) {
    var Buffer3 = require_safe_buffer().Buffer;
    var Stream = require("stream");
    var util = require("util");
    function DataStream(data) {
      this.buffer = null;
      this.writable = true;
      this.readable = true;
      if (!data) {
        this.buffer = Buffer3.alloc(0);
        return this;
      }
      if (typeof data.pipe === "function") {
        this.buffer = Buffer3.alloc(0);
        data.pipe(this);
        return this;
      }
      if (data.length || typeof data === "object") {
        this.buffer = data;
        this.writable = false;
        process.nextTick(function() {
          this.emit("end", data);
          this.readable = false;
          this.emit("close");
        }.bind(this));
        return this;
      }
      throw new TypeError("Unexpected data type (" + typeof data + ")");
    }
    util.inherits(DataStream, Stream);
    DataStream.prototype.write = function write(data) {
      this.buffer = Buffer3.concat([this.buffer, Buffer3.from(data)]);
      this.emit("data", data);
    };
    DataStream.prototype.end = function end(data) {
      if (data)
        this.write(data);
      this.emit("end", data);
      this.emit("close");
      this.writable = false;
      this.readable = false;
    };
    module2.exports = DataStream;
  }
});

// node_modules/buffer-equal-constant-time/index.js
var require_buffer_equal_constant_time = __commonJS({
  "node_modules/buffer-equal-constant-time/index.js"(exports2, module2) {
    "use strict";
    var Buffer3 = require("buffer").Buffer;
    var SlowBuffer = require("buffer").SlowBuffer;
    module2.exports = bufferEq;
    function bufferEq(a, b) {
      if (!Buffer3.isBuffer(a) || !Buffer3.isBuffer(b)) {
        return false;
      }
      if (a.length !== b.length) {
        return false;
      }
      var c = 0;
      for (var i = 0; i < a.length; i++) {
        c |= a[i] ^ b[i];
      }
      return c === 0;
    }
    bufferEq.install = function() {
      Buffer3.prototype.equal = SlowBuffer.prototype.equal = function equal(that) {
        return bufferEq(this, that);
      };
    };
    var origBufEqual = Buffer3.prototype.equal;
    var origSlowBufEqual = SlowBuffer.prototype.equal;
    bufferEq.restore = function() {
      Buffer3.prototype.equal = origBufEqual;
      SlowBuffer.prototype.equal = origSlowBufEqual;
    };
  }
});

// node_modules/ecdsa-sig-formatter/src/param-bytes-for-alg.js
var require_param_bytes_for_alg = __commonJS({
  "node_modules/ecdsa-sig-formatter/src/param-bytes-for-alg.js"(exports2, module2) {
    "use strict";
    function getParamSize(keySize) {
      var result = (keySize / 8 | 0) + (keySize % 8 === 0 ? 0 : 1);
      return result;
    }
    var paramBytesForAlg = {
      ES256: getParamSize(256),
      ES384: getParamSize(384),
      ES512: getParamSize(521)
    };
    function getParamBytesForAlg(alg) {
      var paramBytes = paramBytesForAlg[alg];
      if (paramBytes) {
        return paramBytes;
      }
      throw new Error('Unknown algorithm "' + alg + '"');
    }
    module2.exports = getParamBytesForAlg;
  }
});

// node_modules/ecdsa-sig-formatter/src/ecdsa-sig-formatter.js
var require_ecdsa_sig_formatter = __commonJS({
  "node_modules/ecdsa-sig-formatter/src/ecdsa-sig-formatter.js"(exports2, module2) {
    "use strict";
    var Buffer3 = require_safe_buffer().Buffer;
    var getParamBytesForAlg = require_param_bytes_for_alg();
    var MAX_OCTET = 128;
    var CLASS_UNIVERSAL = 0;
    var PRIMITIVE_BIT = 32;
    var TAG_SEQ = 16;
    var TAG_INT = 2;
    var ENCODED_TAG_SEQ = TAG_SEQ | PRIMITIVE_BIT | CLASS_UNIVERSAL << 6;
    var ENCODED_TAG_INT = TAG_INT | CLASS_UNIVERSAL << 6;
    function base64Url(base64) {
      return base64.replace(/=/g, "").replace(/\+/g, "-").replace(/\//g, "_");
    }
    function signatureAsBuffer(signature) {
      if (Buffer3.isBuffer(signature)) {
        return signature;
      } else if ("string" === typeof signature) {
        return Buffer3.from(signature, "base64");
      }
      throw new TypeError("ECDSA signature must be a Base64 string or a Buffer");
    }
    function derToJose(signature, alg) {
      signature = signatureAsBuffer(signature);
      var paramBytes = getParamBytesForAlg(alg);
      var maxEncodedParamLength = paramBytes + 1;
      var inputLength = signature.length;
      var offset = 0;
      if (signature[offset++] !== ENCODED_TAG_SEQ) {
        throw new Error('Could not find expected "seq"');
      }
      var seqLength = signature[offset++];
      if (seqLength === (MAX_OCTET | 1)) {
        seqLength = signature[offset++];
      }
      if (inputLength - offset < seqLength) {
        throw new Error('"seq" specified length of "' + seqLength + '", only "' + (inputLength - offset) + '" remaining');
      }
      if (signature[offset++] !== ENCODED_TAG_INT) {
        throw new Error('Could not find expected "int" for "r"');
      }
      var rLength = signature[offset++];
      if (inputLength - offset - 2 < rLength) {
        throw new Error('"r" specified length of "' + rLength + '", only "' + (inputLength - offset - 2) + '" available');
      }
      if (maxEncodedParamLength < rLength) {
        throw new Error('"r" specified length of "' + rLength + '", max of "' + maxEncodedParamLength + '" is acceptable');
      }
      var rOffset = offset;
      offset += rLength;
      if (signature[offset++] !== ENCODED_TAG_INT) {
        throw new Error('Could not find expected "int" for "s"');
      }
      var sLength = signature[offset++];
      if (inputLength - offset !== sLength) {
        throw new Error('"s" specified length of "' + sLength + '", expected "' + (inputLength - offset) + '"');
      }
      if (maxEncodedParamLength < sLength) {
        throw new Error('"s" specified length of "' + sLength + '", max of "' + maxEncodedParamLength + '" is acceptable');
      }
      var sOffset = offset;
      offset += sLength;
      if (offset !== inputLength) {
        throw new Error('Expected to consume entire buffer, but "' + (inputLength - offset) + '" bytes remain');
      }
      var rPadding = paramBytes - rLength, sPadding = paramBytes - sLength;
      var dst = Buffer3.allocUnsafe(rPadding + rLength + sPadding + sLength);
      for (offset = 0; offset < rPadding; ++offset) {
        dst[offset] = 0;
      }
      signature.copy(dst, offset, rOffset + Math.max(-rPadding, 0), rOffset + rLength);
      offset = paramBytes;
      for (var o = offset; offset < o + sPadding; ++offset) {
        dst[offset] = 0;
      }
      signature.copy(dst, offset, sOffset + Math.max(-sPadding, 0), sOffset + sLength);
      dst = dst.toString("base64");
      dst = base64Url(dst);
      return dst;
    }
    function countPadding(buf, start, stop) {
      var padding = 0;
      while (start + padding < stop && buf[start + padding] === 0) {
        ++padding;
      }
      var needsSign = buf[start + padding] >= MAX_OCTET;
      if (needsSign) {
        --padding;
      }
      return padding;
    }
    function joseToDer(signature, alg) {
      signature = signatureAsBuffer(signature);
      var paramBytes = getParamBytesForAlg(alg);
      var signatureBytes = signature.length;
      if (signatureBytes !== paramBytes * 2) {
        throw new TypeError('"' + alg + '" signatures must be "' + paramBytes * 2 + '" bytes, saw "' + signatureBytes + '"');
      }
      var rPadding = countPadding(signature, 0, paramBytes);
      var sPadding = countPadding(signature, paramBytes, signature.length);
      var rLength = paramBytes - rPadding;
      var sLength = paramBytes - sPadding;
      var rsBytes = 1 + 1 + rLength + 1 + 1 + sLength;
      var shortLength = rsBytes < MAX_OCTET;
      var dst = Buffer3.allocUnsafe((shortLength ? 2 : 3) + rsBytes);
      var offset = 0;
      dst[offset++] = ENCODED_TAG_SEQ;
      if (shortLength) {
        dst[offset++] = rsBytes;
      } else {
        dst[offset++] = MAX_OCTET | 1;
        dst[offset++] = rsBytes & 255;
      }
      dst[offset++] = ENCODED_TAG_INT;
      dst[offset++] = rLength;
      if (rPadding < 0) {
        dst[offset++] = 0;
        offset += signature.copy(dst, offset, 0, paramBytes);
      } else {
        offset += signature.copy(dst, offset, rPadding, paramBytes);
      }
      dst[offset++] = ENCODED_TAG_INT;
      dst[offset++] = sLength;
      if (sPadding < 0) {
        dst[offset++] = 0;
        signature.copy(dst, offset, paramBytes);
      } else {
        signature.copy(dst, offset, paramBytes + sPadding);
      }
      return dst;
    }
    module2.exports = {
      derToJose,
      joseToDer
    };
  }
});

// node_modules/jwa/index.js
var require_jwa = __commonJS({
  "node_modules/jwa/index.js"(exports2, module2) {
    var bufferEqual = require_buffer_equal_constant_time();
    var Buffer3 = require_safe_buffer().Buffer;
    var crypto = require("crypto");
    var formatEcdsa = require_ecdsa_sig_formatter();
    var util = require("util");
    var MSG_INVALID_ALGORITHM = '"%s" is not a valid algorithm.\n  Supported algorithms are:\n  "HS256", "HS384", "HS512", "RS256", "RS384", "RS512", "PS256", "PS384", "PS512", "ES256", "ES384", "ES512" and "none".';
    var MSG_INVALID_SECRET = "secret must be a string or buffer";
    var MSG_INVALID_VERIFIER_KEY = "key must be a string or a buffer";
    var MSG_INVALID_SIGNER_KEY = "key must be a string, a buffer or an object";
    var supportsKeyObjects = typeof crypto.createPublicKey === "function";
    if (supportsKeyObjects) {
      MSG_INVALID_VERIFIER_KEY += " or a KeyObject";
      MSG_INVALID_SECRET += "or a KeyObject";
    }
    function checkIsPublicKey(key) {
      if (Buffer3.isBuffer(key)) {
        return;
      }
      if (typeof key === "string") {
        return;
      }
      if (!supportsKeyObjects) {
        throw typeError(MSG_INVALID_VERIFIER_KEY);
      }
      if (typeof key !== "object") {
        throw typeError(MSG_INVALID_VERIFIER_KEY);
      }
      if (typeof key.type !== "string") {
        throw typeError(MSG_INVALID_VERIFIER_KEY);
      }
      if (typeof key.asymmetricKeyType !== "string") {
        throw typeError(MSG_INVALID_VERIFIER_KEY);
      }
      if (typeof key.export !== "function") {
        throw typeError(MSG_INVALID_VERIFIER_KEY);
      }
    }
    function checkIsPrivateKey(key) {
      if (Buffer3.isBuffer(key)) {
        return;
      }
      if (typeof key === "string") {
        return;
      }
      if (typeof key === "object") {
        return;
      }
      throw typeError(MSG_INVALID_SIGNER_KEY);
    }
    function checkIsSecretKey(key) {
      if (Buffer3.isBuffer(key)) {
        return;
      }
      if (typeof key === "string") {
        return key;
      }
      if (!supportsKeyObjects) {
        throw typeError(MSG_INVALID_SECRET);
      }
      if (typeof key !== "object") {
        throw typeError(MSG_INVALID_SECRET);
      }
      if (key.type !== "secret") {
        throw typeError(MSG_INVALID_SECRET);
      }
      if (typeof key.export !== "function") {
        throw typeError(MSG_INVALID_SECRET);
      }
    }
    function fromBase64(base64) {
      return base64.replace(/=/g, "").replace(/\+/g, "-").replace(/\//g, "_");
    }
    function toBase64(base64url) {
      base64url = base64url.toString();
      var padding = 4 - base64url.length % 4;
      if (padding !== 4) {
        for (var i = 0; i < padding; ++i) {
          base64url += "=";
        }
      }
      return base64url.replace(/\-/g, "+").replace(/_/g, "/");
    }
    function typeError(template) {
      var args = [].slice.call(arguments, 1);
      var errMsg = util.format.bind(util, template).apply(null, args);
      return new TypeError(errMsg);
    }
    function bufferOrString(obj) {
      return Buffer3.isBuffer(obj) || typeof obj === "string";
    }
    function normalizeInput(thing) {
      if (!bufferOrString(thing))
        thing = JSON.stringify(thing);
      return thing;
    }
    function createHmacSigner(bits) {
      return function sign(thing, secret) {
        checkIsSecretKey(secret);
        thing = normalizeInput(thing);
        var hmac = crypto.createHmac("sha" + bits, secret);
        var sig = (hmac.update(thing), hmac.digest("base64"));
        return fromBase64(sig);
      };
    }
    function createHmacVerifier(bits) {
      return function verify(thing, signature, secret) {
        var computedSig = createHmacSigner(bits)(thing, secret);
        return bufferEqual(Buffer3.from(signature), Buffer3.from(computedSig));
      };
    }
    function createKeySigner(bits) {
      return function sign(thing, privateKey) {
        checkIsPrivateKey(privateKey);
        thing = normalizeInput(thing);
        var signer = crypto.createSign("RSA-SHA" + bits);
        var sig = (signer.update(thing), signer.sign(privateKey, "base64"));
        return fromBase64(sig);
      };
    }
    function createKeyVerifier(bits) {
      return function verify(thing, signature, publicKey) {
        checkIsPublicKey(publicKey);
        thing = normalizeInput(thing);
        signature = toBase64(signature);
        var verifier = crypto.createVerify("RSA-SHA" + bits);
        verifier.update(thing);
        return verifier.verify(publicKey, signature, "base64");
      };
    }
    function createPSSKeySigner(bits) {
      return function sign(thing, privateKey) {
        checkIsPrivateKey(privateKey);
        thing = normalizeInput(thing);
        var signer = crypto.createSign("RSA-SHA" + bits);
        var sig = (signer.update(thing), signer.sign({
          key: privateKey,
          padding: crypto.constants.RSA_PKCS1_PSS_PADDING,
          saltLength: crypto.constants.RSA_PSS_SALTLEN_DIGEST
        }, "base64"));
        return fromBase64(sig);
      };
    }
    function createPSSKeyVerifier(bits) {
      return function verify(thing, signature, publicKey) {
        checkIsPublicKey(publicKey);
        thing = normalizeInput(thing);
        signature = toBase64(signature);
        var verifier = crypto.createVerify("RSA-SHA" + bits);
        verifier.update(thing);
        return verifier.verify({
          key: publicKey,
          padding: crypto.constants.RSA_PKCS1_PSS_PADDING,
          saltLength: crypto.constants.RSA_PSS_SALTLEN_DIGEST
        }, signature, "base64");
      };
    }
    function createECDSASigner(bits) {
      var inner = createKeySigner(bits);
      return function sign() {
        var signature = inner.apply(null, arguments);
        signature = formatEcdsa.derToJose(signature, "ES" + bits);
        return signature;
      };
    }
    function createECDSAVerifer(bits) {
      var inner = createKeyVerifier(bits);
      return function verify(thing, signature, publicKey) {
        signature = formatEcdsa.joseToDer(signature, "ES" + bits).toString("base64");
        var result = inner(thing, signature, publicKey);
        return result;
      };
    }
    function createNoneSigner() {
      return function sign() {
        return "";
      };
    }
    function createNoneVerifier() {
      return function verify(thing, signature) {
        return signature === "";
      };
    }
    module2.exports = function jwa(algorithm) {
      var signerFactories = {
        hs: createHmacSigner,
        rs: createKeySigner,
        ps: createPSSKeySigner,
        es: createECDSASigner,
        none: createNoneSigner
      };
      var verifierFactories = {
        hs: createHmacVerifier,
        rs: createKeyVerifier,
        ps: createPSSKeyVerifier,
        es: createECDSAVerifer,
        none: createNoneVerifier
      };
      var match = algorithm.match(/^(RS|PS|ES|HS)(256|384|512)$|^(none)$/i);
      if (!match)
        throw typeError(MSG_INVALID_ALGORITHM, algorithm);
      var algo = (match[1] || match[3]).toLowerCase();
      var bits = match[2];
      return {
        sign: signerFactories[algo](bits),
        verify: verifierFactories[algo](bits)
      };
    };
  }
});

// node_modules/jws/lib/tostring.js
var require_tostring = __commonJS({
  "node_modules/jws/lib/tostring.js"(exports2, module2) {
    var Buffer3 = require("buffer").Buffer;
    module2.exports = function toString(obj) {
      if (typeof obj === "string")
        return obj;
      if (typeof obj === "number" || Buffer3.isBuffer(obj))
        return obj.toString();
      return JSON.stringify(obj);
    };
  }
});

// node_modules/jws/lib/sign-stream.js
var require_sign_stream = __commonJS({
  "node_modules/jws/lib/sign-stream.js"(exports2, module2) {
    var Buffer3 = require_safe_buffer().Buffer;
    var DataStream = require_data_stream();
    var jwa = require_jwa();
    var Stream = require("stream");
    var toString = require_tostring();
    var util = require("util");
    function base64url(string, encoding) {
      return Buffer3.from(string, encoding).toString("base64").replace(/=/g, "").replace(/\+/g, "-").replace(/\//g, "_");
    }
    function jwsSecuredInput(header, payload, encoding) {
      encoding = encoding || "utf8";
      var encodedHeader = base64url(toString(header), "binary");
      var encodedPayload = base64url(toString(payload), encoding);
      return util.format("%s.%s", encodedHeader, encodedPayload);
    }
    function jwsSign(opts) {
      var header = opts.header;
      var payload = opts.payload;
      var secretOrKey = opts.secret || opts.privateKey;
      var encoding = opts.encoding;
      var algo = jwa(header.alg);
      var securedInput = jwsSecuredInput(header, payload, encoding);
      var signature = algo.sign(securedInput, secretOrKey);
      return util.format("%s.%s", securedInput, signature);
    }
    function SignStream(opts) {
      var secret = opts.secret || opts.privateKey || opts.key;
      var secretStream = new DataStream(secret);
      this.readable = true;
      this.header = opts.header;
      this.encoding = opts.encoding;
      this.secret = this.privateKey = this.key = secretStream;
      this.payload = new DataStream(opts.payload);
      this.secret.once("close", function() {
        if (!this.payload.writable && this.readable)
          this.sign();
      }.bind(this));
      this.payload.once("close", function() {
        if (!this.secret.writable && this.readable)
          this.sign();
      }.bind(this));
    }
    util.inherits(SignStream, Stream);
    SignStream.prototype.sign = function sign() {
      try {
        var signature = jwsSign({
          header: this.header,
          payload: this.payload.buffer,
          secret: this.secret.buffer,
          encoding: this.encoding
        });
        this.emit("done", signature);
        this.emit("data", signature);
        this.emit("end");
        this.readable = false;
        return signature;
      } catch (e) {
        this.readable = false;
        this.emit("error", e);
        this.emit("close");
      }
    };
    SignStream.sign = jwsSign;
    module2.exports = SignStream;
  }
});

// node_modules/jws/lib/verify-stream.js
var require_verify_stream = __commonJS({
  "node_modules/jws/lib/verify-stream.js"(exports2, module2) {
    var Buffer3 = require_safe_buffer().Buffer;
    var DataStream = require_data_stream();
    var jwa = require_jwa();
    var Stream = require("stream");
    var toString = require_tostring();
    var util = require("util");
    var JWS_REGEX = /^[a-zA-Z0-9\-_]+?\.[a-zA-Z0-9\-_]+?\.([a-zA-Z0-9\-_]+)?$/;
    function isObject(thing) {
      return Object.prototype.toString.call(thing) === "[object Object]";
    }
    function safeJsonParse(thing) {
      if (isObject(thing))
        return thing;
      try {
        return JSON.parse(thing);
      } catch (e) {
        return void 0;
      }
    }
    function headerFromJWS(jwsSig) {
      var encodedHeader = jwsSig.split(".", 1)[0];
      return safeJsonParse(Buffer3.from(encodedHeader, "base64").toString("binary"));
    }
    function securedInputFromJWS(jwsSig) {
      return jwsSig.split(".", 2).join(".");
    }
    function signatureFromJWS(jwsSig) {
      return jwsSig.split(".")[2];
    }
    function payloadFromJWS(jwsSig, encoding) {
      encoding = encoding || "utf8";
      var payload = jwsSig.split(".")[1];
      return Buffer3.from(payload, "base64").toString(encoding);
    }
    function isValidJws(string) {
      return JWS_REGEX.test(string) && !!headerFromJWS(string);
    }
    function jwsVerify(jwsSig, algorithm, secretOrKey) {
      if (!algorithm) {
        var err = new Error("Missing algorithm parameter for jws.verify");
        err.code = "MISSING_ALGORITHM";
        throw err;
      }
      jwsSig = toString(jwsSig);
      var signature = signatureFromJWS(jwsSig);
      var securedInput = securedInputFromJWS(jwsSig);
      var algo = jwa(algorithm);
      return algo.verify(securedInput, signature, secretOrKey);
    }
    function jwsDecode(jwsSig, opts) {
      opts = opts || {};
      jwsSig = toString(jwsSig);
      if (!isValidJws(jwsSig))
        return null;
      var header = headerFromJWS(jwsSig);
      if (!header)
        return null;
      var payload = payloadFromJWS(jwsSig);
      if (header.typ === "JWT" || opts.json)
        payload = JSON.parse(payload, opts.encoding);
      return {
        header,
        payload,
        signature: signatureFromJWS(jwsSig)
      };
    }
    function VerifyStream(opts) {
      opts = opts || {};
      var secretOrKey = opts.secret || opts.publicKey || opts.key;
      var secretStream = new DataStream(secretOrKey);
      this.readable = true;
      this.algorithm = opts.algorithm;
      this.encoding = opts.encoding;
      this.secret = this.publicKey = this.key = secretStream;
      this.signature = new DataStream(opts.signature);
      this.secret.once("close", function() {
        if (!this.signature.writable && this.readable)
          this.verify();
      }.bind(this));
      this.signature.once("close", function() {
        if (!this.secret.writable && this.readable)
          this.verify();
      }.bind(this));
    }
    util.inherits(VerifyStream, Stream);
    VerifyStream.prototype.verify = function verify() {
      try {
        var valid = jwsVerify(this.signature.buffer, this.algorithm, this.key.buffer);
        var obj = jwsDecode(this.signature.buffer, this.encoding);
        this.emit("done", valid, obj);
        this.emit("data", valid);
        this.emit("end");
        this.readable = false;
        return valid;
      } catch (e) {
        this.readable = false;
        this.emit("error", e);
        this.emit("close");
      }
    };
    VerifyStream.decode = jwsDecode;
    VerifyStream.isValid = isValidJws;
    VerifyStream.verify = jwsVerify;
    module2.exports = VerifyStream;
  }
});

// node_modules/jws/index.js
var require_jws = __commonJS({
  "node_modules/jws/index.js"(exports2) {
    var SignStream = require_sign_stream();
    var VerifyStream = require_verify_stream();
    var ALGORITHMS = [
      "HS256",
      "HS384",
      "HS512",
      "RS256",
      "RS384",
      "RS512",
      "PS256",
      "PS384",
      "PS512",
      "ES256",
      "ES384",
      "ES512"
    ];
    exports2.ALGORITHMS = ALGORITHMS;
    exports2.sign = SignStream.sign;
    exports2.verify = VerifyStream.verify;
    exports2.decode = VerifyStream.decode;
    exports2.isValid = VerifyStream.isValid;
    exports2.createSign = function createSign(opts) {
      return new SignStream(opts);
    };
    exports2.createVerify = function createVerify(opts) {
      return new VerifyStream(opts);
    };
  }
});

// node_modules/jsonwebtoken/decode.js
var require_decode = __commonJS({
  "node_modules/jsonwebtoken/decode.js"(exports2, module2) {
    var jws = require_jws();
    module2.exports = function(jwt, options) {
      options = options || {};
      var decoded = jws.decode(jwt, options);
      if (!decoded) {
        return null;
      }
      var payload = decoded.payload;
      if (typeof payload === "string") {
        try {
          var obj = JSON.parse(payload);
          if (obj !== null && typeof obj === "object") {
            payload = obj;
          }
        } catch (e) {
        }
      }
      if (options.complete === true) {
        return {
          header: decoded.header,
          payload,
          signature: decoded.signature
        };
      }
      return payload;
    };
  }
});

// node_modules/jsonwebtoken/lib/JsonWebTokenError.js
var require_JsonWebTokenError = __commonJS({
  "node_modules/jsonwebtoken/lib/JsonWebTokenError.js"(exports2, module2) {
    var JsonWebTokenError = function(message, error) {
      Error.call(this, message);
      if (Error.captureStackTrace) {
        Error.captureStackTrace(this, this.constructor);
      }
      this.name = "JsonWebTokenError";
      this.message = message;
      if (error)
        this.inner = error;
    };
    JsonWebTokenError.prototype = Object.create(Error.prototype);
    JsonWebTokenError.prototype.constructor = JsonWebTokenError;
    module2.exports = JsonWebTokenError;
  }
});

// node_modules/jsonwebtoken/lib/NotBeforeError.js
var require_NotBeforeError = __commonJS({
  "node_modules/jsonwebtoken/lib/NotBeforeError.js"(exports2, module2) {
    var JsonWebTokenError = require_JsonWebTokenError();
    var NotBeforeError = function(message, date) {
      JsonWebTokenError.call(this, message);
      this.name = "NotBeforeError";
      this.date = date;
    };
    NotBeforeError.prototype = Object.create(JsonWebTokenError.prototype);
    NotBeforeError.prototype.constructor = NotBeforeError;
    module2.exports = NotBeforeError;
  }
});

// node_modules/jsonwebtoken/lib/TokenExpiredError.js
var require_TokenExpiredError = __commonJS({
  "node_modules/jsonwebtoken/lib/TokenExpiredError.js"(exports2, module2) {
    var JsonWebTokenError = require_JsonWebTokenError();
    var TokenExpiredError = function(message, expiredAt) {
      JsonWebTokenError.call(this, message);
      this.name = "TokenExpiredError";
      this.expiredAt = expiredAt;
    };
    TokenExpiredError.prototype = Object.create(JsonWebTokenError.prototype);
    TokenExpiredError.prototype.constructor = TokenExpiredError;
    module2.exports = TokenExpiredError;
  }
});

// node_modules/jsonwebtoken/lib/timespan.js
var require_timespan = __commonJS({
  "node_modules/jsonwebtoken/lib/timespan.js"(exports2, module2) {
    var ms = require_ms();
    module2.exports = function(time, iat) {
      var timestamp = iat || Math.floor(Date.now() / 1e3);
      if (typeof time === "string") {
        var milliseconds = ms(time);
        if (typeof milliseconds === "undefined") {
          return;
        }
        return Math.floor(timestamp + milliseconds / 1e3);
      } else if (typeof time === "number") {
        return timestamp + time;
      } else {
        return;
      }
    };
  }
});

// node_modules/semver/internal/constants.js
var require_constants = __commonJS({
  "node_modules/semver/internal/constants.js"(exports2, module2) {
    var SEMVER_SPEC_VERSION = "2.0.0";
    var MAX_LENGTH = 256;
    var MAX_SAFE_INTEGER = Number.MAX_SAFE_INTEGER || 9007199254740991;
    var MAX_SAFE_COMPONENT_LENGTH = 16;
    var MAX_SAFE_BUILD_LENGTH = MAX_LENGTH - 6;
    var RELEASE_TYPES = [
      "major",
      "premajor",
      "minor",
      "preminor",
      "patch",
      "prepatch",
      "prerelease"
    ];
    module2.exports = {
      MAX_LENGTH,
      MAX_SAFE_COMPONENT_LENGTH,
      MAX_SAFE_BUILD_LENGTH,
      MAX_SAFE_INTEGER,
      RELEASE_TYPES,
      SEMVER_SPEC_VERSION,
      FLAG_INCLUDE_PRERELEASE: 1,
      FLAG_LOOSE: 2
    };
  }
});

// node_modules/semver/internal/debug.js
var require_debug2 = __commonJS({
  "node_modules/semver/internal/debug.js"(exports2, module2) {
    var debug = typeof process === "object" && process.env && process.env.NODE_DEBUG && /\bsemver\b/i.test(process.env.NODE_DEBUG) ? (...args) => console.error("SEMVER", ...args) : () => {
    };
    module2.exports = debug;
  }
});

// node_modules/semver/internal/re.js
var require_re = __commonJS({
  "node_modules/semver/internal/re.js"(exports2, module2) {
    var {
      MAX_SAFE_COMPONENT_LENGTH,
      MAX_SAFE_BUILD_LENGTH,
      MAX_LENGTH
    } = require_constants();
    var debug = require_debug2();
    exports2 = module2.exports = {};
    var re = exports2.re = [];
    var safeRe = exports2.safeRe = [];
    var src = exports2.src = [];
    var t = exports2.t = {};
    var R = 0;
    var LETTERDASHNUMBER = "[a-zA-Z0-9-]";
    var safeRegexReplacements = [
      ["\\s", 1],
      ["\\d", MAX_LENGTH],
      [LETTERDASHNUMBER, MAX_SAFE_BUILD_LENGTH]
    ];
    var makeSafeRegex = (value) => {
      for (const [token, max] of safeRegexReplacements) {
        value = value.split(`${token}*`).join(`${token}{0,${max}}`).split(`${token}+`).join(`${token}{1,${max}}`);
      }
      return value;
    };
    var createToken = (name, value, isGlobal) => {
      const safe = makeSafeRegex(value);
      const index = R++;
      debug(name, index, value);
      t[name] = index;
      src[index] = value;
      re[index] = new RegExp(value, isGlobal ? "g" : void 0);
      safeRe[index] = new RegExp(safe, isGlobal ? "g" : void 0);
    };
    createToken("NUMERICIDENTIFIER", "0|[1-9]\\d*");
    createToken("NUMERICIDENTIFIERLOOSE", "\\d+");
    createToken("NONNUMERICIDENTIFIER", `\\d*[a-zA-Z-]${LETTERDASHNUMBER}*`);
    createToken("MAINVERSION", `(${src[t.NUMERICIDENTIFIER]})\\.(${src[t.NUMERICIDENTIFIER]})\\.(${src[t.NUMERICIDENTIFIER]})`);
    createToken("MAINVERSIONLOOSE", `(${src[t.NUMERICIDENTIFIERLOOSE]})\\.(${src[t.NUMERICIDENTIFIERLOOSE]})\\.(${src[t.NUMERICIDENTIFIERLOOSE]})`);
    createToken("PRERELEASEIDENTIFIER", `(?:${src[t.NUMERICIDENTIFIER]}|${src[t.NONNUMERICIDENTIFIER]})`);
    createToken("PRERELEASEIDENTIFIERLOOSE", `(?:${src[t.NUMERICIDENTIFIERLOOSE]}|${src[t.NONNUMERICIDENTIFIER]})`);
    createToken("PRERELEASE", `(?:-(${src[t.PRERELEASEIDENTIFIER]}(?:\\.${src[t.PRERELEASEIDENTIFIER]})*))`);
    createToken("PRERELEASELOOSE", `(?:-?(${src[t.PRERELEASEIDENTIFIERLOOSE]}(?:\\.${src[t.PRERELEASEIDENTIFIERLOOSE]})*))`);
    createToken("BUILDIDENTIFIER", `${LETTERDASHNUMBER}+`);
    createToken("BUILD", `(?:\\+(${src[t.BUILDIDENTIFIER]}(?:\\.${src[t.BUILDIDENTIFIER]})*))`);
    createToken("FULLPLAIN", `v?${src[t.MAINVERSION]}${src[t.PRERELEASE]}?${src[t.BUILD]}?`);
    createToken("FULL", `^${src[t.FULLPLAIN]}$`);
    createToken("LOOSEPLAIN", `[v=\\s]*${src[t.MAINVERSIONLOOSE]}${src[t.PRERELEASELOOSE]}?${src[t.BUILD]}?`);
    createToken("LOOSE", `^${src[t.LOOSEPLAIN]}$`);
    createToken("GTLT", "((?:<|>)?=?)");
    createToken("XRANGEIDENTIFIERLOOSE", `${src[t.NUMERICIDENTIFIERLOOSE]}|x|X|\\*`);
    createToken("XRANGEIDENTIFIER", `${src[t.NUMERICIDENTIFIER]}|x|X|\\*`);
    createToken("XRANGEPLAIN", `[v=\\s]*(${src[t.XRANGEIDENTIFIER]})(?:\\.(${src[t.XRANGEIDENTIFIER]})(?:\\.(${src[t.XRANGEIDENTIFIER]})(?:${src[t.PRERELEASE]})?${src[t.BUILD]}?)?)?`);
    createToken("XRANGEPLAINLOOSE", `[v=\\s]*(${src[t.XRANGEIDENTIFIERLOOSE]})(?:\\.(${src[t.XRANGEIDENTIFIERLOOSE]})(?:\\.(${src[t.XRANGEIDENTIFIERLOOSE]})(?:${src[t.PRERELEASELOOSE]})?${src[t.BUILD]}?)?)?`);
    createToken("XRANGE", `^${src[t.GTLT]}\\s*${src[t.XRANGEPLAIN]}$`);
    createToken("XRANGELOOSE", `^${src[t.GTLT]}\\s*${src[t.XRANGEPLAINLOOSE]}$`);
    createToken("COERCEPLAIN", `${"(^|[^\\d])(\\d{1,"}${MAX_SAFE_COMPONENT_LENGTH}})(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?`);
    createToken("COERCE", `${src[t.COERCEPLAIN]}(?:$|[^\\d])`);
    createToken("COERCEFULL", src[t.COERCEPLAIN] + `(?:${src[t.PRERELEASE]})?(?:${src[t.BUILD]})?(?:$|[^\\d])`);
    createToken("COERCERTL", src[t.COERCE], true);
    createToken("COERCERTLFULL", src[t.COERCEFULL], true);
    createToken("LONETILDE", "(?:~>?)");
    createToken("TILDETRIM", `(\\s*)${src[t.LONETILDE]}\\s+`, true);
    exports2.tildeTrimReplace = "$1~";
    createToken("TILDE", `^${src[t.LONETILDE]}${src[t.XRANGEPLAIN]}$`);
    createToken("TILDELOOSE", `^${src[t.LONETILDE]}${src[t.XRANGEPLAINLOOSE]}$`);
    createToken("LONECARET", "(?:\\^)");
    createToken("CARETTRIM", `(\\s*)${src[t.LONECARET]}\\s+`, true);
    exports2.caretTrimReplace = "$1^";
    createToken("CARET", `^${src[t.LONECARET]}${src[t.XRANGEPLAIN]}$`);
    createToken("CARETLOOSE", `^${src[t.LONECARET]}${src[t.XRANGEPLAINLOOSE]}$`);
    createToken("COMPARATORLOOSE", `^${src[t.GTLT]}\\s*(${src[t.LOOSEPLAIN]})$|^$`);
    createToken("COMPARATOR", `^${src[t.GTLT]}\\s*(${src[t.FULLPLAIN]})$|^$`);
    createToken("COMPARATORTRIM", `(\\s*)${src[t.GTLT]}\\s*(${src[t.LOOSEPLAIN]}|${src[t.XRANGEPLAIN]})`, true);
    exports2.comparatorTrimReplace = "$1$2$3";
    createToken("HYPHENRANGE", `^\\s*(${src[t.XRANGEPLAIN]})\\s+-\\s+(${src[t.XRANGEPLAIN]})\\s*$`);
    createToken("HYPHENRANGELOOSE", `^\\s*(${src[t.XRANGEPLAINLOOSE]})\\s+-\\s+(${src[t.XRANGEPLAINLOOSE]})\\s*$`);
    createToken("STAR", "(<|>)?=?\\s*\\*");
    createToken("GTE0", "^\\s*>=\\s*0\\.0\\.0\\s*$");
    createToken("GTE0PRE", "^\\s*>=\\s*0\\.0\\.0-0\\s*$");
  }
});

// node_modules/semver/internal/parse-options.js
var require_parse_options = __commonJS({
  "node_modules/semver/internal/parse-options.js"(exports2, module2) {
    var looseOption = Object.freeze({ loose: true });
    var emptyOpts = Object.freeze({});
    var parseOptions = (options) => {
      if (!options) {
        return emptyOpts;
      }
      if (typeof options !== "object") {
        return looseOption;
      }
      return options;
    };
    module2.exports = parseOptions;
  }
});

// node_modules/semver/internal/identifiers.js
var require_identifiers = __commonJS({
  "node_modules/semver/internal/identifiers.js"(exports2, module2) {
    var numeric = /^[0-9]+$/;
    var compareIdentifiers = (a, b) => {
      const anum = numeric.test(a);
      const bnum = numeric.test(b);
      if (anum && bnum) {
        a = +a;
        b = +b;
      }
      return a === b ? 0 : anum && !bnum ? -1 : bnum && !anum ? 1 : a < b ? -1 : 1;
    };
    var rcompareIdentifiers = (a, b) => compareIdentifiers(b, a);
    module2.exports = {
      compareIdentifiers,
      rcompareIdentifiers
    };
  }
});

// node_modules/semver/classes/semver.js
var require_semver = __commonJS({
  "node_modules/semver/classes/semver.js"(exports2, module2) {
    var debug = require_debug2();
    var { MAX_LENGTH, MAX_SAFE_INTEGER } = require_constants();
    var { safeRe: re, t } = require_re();
    var parseOptions = require_parse_options();
    var { compareIdentifiers } = require_identifiers();
    var SemVer = class {
      constructor(version, options) {
        options = parseOptions(options);
        if (version instanceof SemVer) {
          if (version.loose === !!options.loose && version.includePrerelease === !!options.includePrerelease) {
            return version;
          } else {
            version = version.version;
          }
        } else if (typeof version !== "string") {
          throw new TypeError(`Invalid version. Must be a string. Got type "${typeof version}".`);
        }
        if (version.length > MAX_LENGTH) {
          throw new TypeError(
            `version is longer than ${MAX_LENGTH} characters`
          );
        }
        debug("SemVer", version, options);
        this.options = options;
        this.loose = !!options.loose;
        this.includePrerelease = !!options.includePrerelease;
        const m = version.trim().match(options.loose ? re[t.LOOSE] : re[t.FULL]);
        if (!m) {
          throw new TypeError(`Invalid Version: ${version}`);
        }
        this.raw = version;
        this.major = +m[1];
        this.minor = +m[2];
        this.patch = +m[3];
        if (this.major > MAX_SAFE_INTEGER || this.major < 0) {
          throw new TypeError("Invalid major version");
        }
        if (this.minor > MAX_SAFE_INTEGER || this.minor < 0) {
          throw new TypeError("Invalid minor version");
        }
        if (this.patch > MAX_SAFE_INTEGER || this.patch < 0) {
          throw new TypeError("Invalid patch version");
        }
        if (!m[4]) {
          this.prerelease = [];
        } else {
          this.prerelease = m[4].split(".").map((id) => {
            if (/^[0-9]+$/.test(id)) {
              const num = +id;
              if (num >= 0 && num < MAX_SAFE_INTEGER) {
                return num;
              }
            }
            return id;
          });
        }
        this.build = m[5] ? m[5].split(".") : [];
        this.format();
      }
      format() {
        this.version = `${this.major}.${this.minor}.${this.patch}`;
        if (this.prerelease.length) {
          this.version += `-${this.prerelease.join(".")}`;
        }
        return this.version;
      }
      toString() {
        return this.version;
      }
      compare(other) {
        debug("SemVer.compare", this.version, this.options, other);
        if (!(other instanceof SemVer)) {
          if (typeof other === "string" && other === this.version) {
            return 0;
          }
          other = new SemVer(other, this.options);
        }
        if (other.version === this.version) {
          return 0;
        }
        return this.compareMain(other) || this.comparePre(other);
      }
      compareMain(other) {
        if (!(other instanceof SemVer)) {
          other = new SemVer(other, this.options);
        }
        return compareIdentifiers(this.major, other.major) || compareIdentifiers(this.minor, other.minor) || compareIdentifiers(this.patch, other.patch);
      }
      comparePre(other) {
        if (!(other instanceof SemVer)) {
          other = new SemVer(other, this.options);
        }
        if (this.prerelease.length && !other.prerelease.length) {
          return -1;
        } else if (!this.prerelease.length && other.prerelease.length) {
          return 1;
        } else if (!this.prerelease.length && !other.prerelease.length) {
          return 0;
        }
        let i = 0;
        do {
          const a = this.prerelease[i];
          const b = other.prerelease[i];
          debug("prerelease compare", i, a, b);
          if (a === void 0 && b === void 0) {
            return 0;
          } else if (b === void 0) {
            return 1;
          } else if (a === void 0) {
            return -1;
          } else if (a === b) {
            continue;
          } else {
            return compareIdentifiers(a, b);
          }
        } while (++i);
      }
      compareBuild(other) {
        if (!(other instanceof SemVer)) {
          other = new SemVer(other, this.options);
        }
        let i = 0;
        do {
          const a = this.build[i];
          const b = other.build[i];
          debug("prerelease compare", i, a, b);
          if (a === void 0 && b === void 0) {
            return 0;
          } else if (b === void 0) {
            return 1;
          } else if (a === void 0) {
            return -1;
          } else if (a === b) {
            continue;
          } else {
            return compareIdentifiers(a, b);
          }
        } while (++i);
      }
      inc(release, identifier, identifierBase) {
        switch (release) {
          case "premajor":
            this.prerelease.length = 0;
            this.patch = 0;
            this.minor = 0;
            this.major++;
            this.inc("pre", identifier, identifierBase);
            break;
          case "preminor":
            this.prerelease.length = 0;
            this.patch = 0;
            this.minor++;
            this.inc("pre", identifier, identifierBase);
            break;
          case "prepatch":
            this.prerelease.length = 0;
            this.inc("patch", identifier, identifierBase);
            this.inc("pre", identifier, identifierBase);
            break;
          case "prerelease":
            if (this.prerelease.length === 0) {
              this.inc("patch", identifier, identifierBase);
            }
            this.inc("pre", identifier, identifierBase);
            break;
          case "major":
            if (this.minor !== 0 || this.patch !== 0 || this.prerelease.length === 0) {
              this.major++;
            }
            this.minor = 0;
            this.patch = 0;
            this.prerelease = [];
            break;
          case "minor":
            if (this.patch !== 0 || this.prerelease.length === 0) {
              this.minor++;
            }
            this.patch = 0;
            this.prerelease = [];
            break;
          case "patch":
            if (this.prerelease.length === 0) {
              this.patch++;
            }
            this.prerelease = [];
            break;
          case "pre": {
            const base = Number(identifierBase) ? 1 : 0;
            if (!identifier && identifierBase === false) {
              throw new Error("invalid increment argument: identifier is empty");
            }
            if (this.prerelease.length === 0) {
              this.prerelease = [base];
            } else {
              let i = this.prerelease.length;
              while (--i >= 0) {
                if (typeof this.prerelease[i] === "number") {
                  this.prerelease[i]++;
                  i = -2;
                }
              }
              if (i === -1) {
                if (identifier === this.prerelease.join(".") && identifierBase === false) {
                  throw new Error("invalid increment argument: identifier already exists");
                }
                this.prerelease.push(base);
              }
            }
            if (identifier) {
              let prerelease = [identifier, base];
              if (identifierBase === false) {
                prerelease = [identifier];
              }
              if (compareIdentifiers(this.prerelease[0], identifier) === 0) {
                if (isNaN(this.prerelease[1])) {
                  this.prerelease = prerelease;
                }
              } else {
                this.prerelease = prerelease;
              }
            }
            break;
          }
          default:
            throw new Error(`invalid increment argument: ${release}`);
        }
        this.raw = this.format();
        if (this.build.length) {
          this.raw += `+${this.build.join(".")}`;
        }
        return this;
      }
    };
    module2.exports = SemVer;
  }
});

// node_modules/semver/functions/parse.js
var require_parse = __commonJS({
  "node_modules/semver/functions/parse.js"(exports2, module2) {
    var SemVer = require_semver();
    var parse = (version, options, throwErrors = false) => {
      if (version instanceof SemVer) {
        return version;
      }
      try {
        return new SemVer(version, options);
      } catch (er) {
        if (!throwErrors) {
          return null;
        }
        throw er;
      }
    };
    module2.exports = parse;
  }
});

// node_modules/semver/functions/valid.js
var require_valid = __commonJS({
  "node_modules/semver/functions/valid.js"(exports2, module2) {
    var parse = require_parse();
    var valid = (version, options) => {
      const v = parse(version, options);
      return v ? v.version : null;
    };
    module2.exports = valid;
  }
});

// node_modules/semver/functions/clean.js
var require_clean = __commonJS({
  "node_modules/semver/functions/clean.js"(exports2, module2) {
    var parse = require_parse();
    var clean = (version, options) => {
      const s = parse(version.trim().replace(/^[=v]+/, ""), options);
      return s ? s.version : null;
    };
    module2.exports = clean;
  }
});

// node_modules/semver/functions/inc.js
var require_inc = __commonJS({
  "node_modules/semver/functions/inc.js"(exports2, module2) {
    var SemVer = require_semver();
    var inc = (version, release, options, identifier, identifierBase) => {
      if (typeof options === "string") {
        identifierBase = identifier;
        identifier = options;
        options = void 0;
      }
      try {
        return new SemVer(
          version instanceof SemVer ? version.version : version,
          options
        ).inc(release, identifier, identifierBase).version;
      } catch (er) {
        return null;
      }
    };
    module2.exports = inc;
  }
});

// node_modules/semver/functions/diff.js
var require_diff = __commonJS({
  "node_modules/semver/functions/diff.js"(exports2, module2) {
    var parse = require_parse();
    var diff = (version1, version2) => {
      const v1 = parse(version1, null, true);
      const v2 = parse(version2, null, true);
      const comparison = v1.compare(v2);
      if (comparison === 0) {
        return null;
      }
      const v1Higher = comparison > 0;
      const highVersion = v1Higher ? v1 : v2;
      const lowVersion = v1Higher ? v2 : v1;
      const highHasPre = !!highVersion.prerelease.length;
      const lowHasPre = !!lowVersion.prerelease.length;
      if (lowHasPre && !highHasPre) {
        if (!lowVersion.patch && !lowVersion.minor) {
          return "major";
        }
        if (highVersion.patch) {
          return "patch";
        }
        if (highVersion.minor) {
          return "minor";
        }
        return "major";
      }
      const prefix = highHasPre ? "pre" : "";
      if (v1.major !== v2.major) {
        return prefix + "major";
      }
      if (v1.minor !== v2.minor) {
        return prefix + "minor";
      }
      if (v1.patch !== v2.patch) {
        return prefix + "patch";
      }
      return "prerelease";
    };
    module2.exports = diff;
  }
});

// node_modules/semver/functions/major.js
var require_major = __commonJS({
  "node_modules/semver/functions/major.js"(exports2, module2) {
    var SemVer = require_semver();
    var major = (a, loose) => new SemVer(a, loose).major;
    module2.exports = major;
  }
});

// node_modules/semver/functions/minor.js
var require_minor = __commonJS({
  "node_modules/semver/functions/minor.js"(exports2, module2) {
    var SemVer = require_semver();
    var minor = (a, loose) => new SemVer(a, loose).minor;
    module2.exports = minor;
  }
});

// node_modules/semver/functions/patch.js
var require_patch = __commonJS({
  "node_modules/semver/functions/patch.js"(exports2, module2) {
    var SemVer = require_semver();
    var patch = (a, loose) => new SemVer(a, loose).patch;
    module2.exports = patch;
  }
});

// node_modules/semver/functions/prerelease.js
var require_prerelease = __commonJS({
  "node_modules/semver/functions/prerelease.js"(exports2, module2) {
    var parse = require_parse();
    var prerelease = (version, options) => {
      const parsed = parse(version, options);
      return parsed && parsed.prerelease.length ? parsed.prerelease : null;
    };
    module2.exports = prerelease;
  }
});

// node_modules/semver/functions/compare.js
var require_compare = __commonJS({
  "node_modules/semver/functions/compare.js"(exports2, module2) {
    var SemVer = require_semver();
    var compare = (a, b, loose) => new SemVer(a, loose).compare(new SemVer(b, loose));
    module2.exports = compare;
  }
});

// node_modules/semver/functions/rcompare.js
var require_rcompare = __commonJS({
  "node_modules/semver/functions/rcompare.js"(exports2, module2) {
    var compare = require_compare();
    var rcompare = (a, b, loose) => compare(b, a, loose);
    module2.exports = rcompare;
  }
});

// node_modules/semver/functions/compare-loose.js
var require_compare_loose = __commonJS({
  "node_modules/semver/functions/compare-loose.js"(exports2, module2) {
    var compare = require_compare();
    var compareLoose = (a, b) => compare(a, b, true);
    module2.exports = compareLoose;
  }
});

// node_modules/semver/functions/compare-build.js
var require_compare_build = __commonJS({
  "node_modules/semver/functions/compare-build.js"(exports2, module2) {
    var SemVer = require_semver();
    var compareBuild = (a, b, loose) => {
      const versionA = new SemVer(a, loose);
      const versionB = new SemVer(b, loose);
      return versionA.compare(versionB) || versionA.compareBuild(versionB);
    };
    module2.exports = compareBuild;
  }
});

// node_modules/semver/functions/sort.js
var require_sort = __commonJS({
  "node_modules/semver/functions/sort.js"(exports2, module2) {
    var compareBuild = require_compare_build();
    var sort = (list, loose) => list.sort((a, b) => compareBuild(a, b, loose));
    module2.exports = sort;
  }
});

// node_modules/semver/functions/rsort.js
var require_rsort = __commonJS({
  "node_modules/semver/functions/rsort.js"(exports2, module2) {
    var compareBuild = require_compare_build();
    var rsort = (list, loose) => list.sort((a, b) => compareBuild(b, a, loose));
    module2.exports = rsort;
  }
});

// node_modules/semver/functions/gt.js
var require_gt = __commonJS({
  "node_modules/semver/functions/gt.js"(exports2, module2) {
    var compare = require_compare();
    var gt = (a, b, loose) => compare(a, b, loose) > 0;
    module2.exports = gt;
  }
});

// node_modules/semver/functions/lt.js
var require_lt = __commonJS({
  "node_modules/semver/functions/lt.js"(exports2, module2) {
    var compare = require_compare();
    var lt = (a, b, loose) => compare(a, b, loose) < 0;
    module2.exports = lt;
  }
});

// node_modules/semver/functions/eq.js
var require_eq = __commonJS({
  "node_modules/semver/functions/eq.js"(exports2, module2) {
    var compare = require_compare();
    var eq = (a, b, loose) => compare(a, b, loose) === 0;
    module2.exports = eq;
  }
});

// node_modules/semver/functions/neq.js
var require_neq = __commonJS({
  "node_modules/semver/functions/neq.js"(exports2, module2) {
    var compare = require_compare();
    var neq = (a, b, loose) => compare(a, b, loose) !== 0;
    module2.exports = neq;
  }
});

// node_modules/semver/functions/gte.js
var require_gte = __commonJS({
  "node_modules/semver/functions/gte.js"(exports2, module2) {
    var compare = require_compare();
    var gte = (a, b, loose) => compare(a, b, loose) >= 0;
    module2.exports = gte;
  }
});

// node_modules/semver/functions/lte.js
var require_lte = __commonJS({
  "node_modules/semver/functions/lte.js"(exports2, module2) {
    var compare = require_compare();
    var lte = (a, b, loose) => compare(a, b, loose) <= 0;
    module2.exports = lte;
  }
});

// node_modules/semver/functions/cmp.js
var require_cmp = __commonJS({
  "node_modules/semver/functions/cmp.js"(exports2, module2) {
    var eq = require_eq();
    var neq = require_neq();
    var gt = require_gt();
    var gte = require_gte();
    var lt = require_lt();
    var lte = require_lte();
    var cmp = (a, op, b, loose) => {
      switch (op) {
        case "===":
          if (typeof a === "object") {
            a = a.version;
          }
          if (typeof b === "object") {
            b = b.version;
          }
          return a === b;
        case "!==":
          if (typeof a === "object") {
            a = a.version;
          }
          if (typeof b === "object") {
            b = b.version;
          }
          return a !== b;
        case "":
        case "=":
        case "==":
          return eq(a, b, loose);
        case "!=":
          return neq(a, b, loose);
        case ">":
          return gt(a, b, loose);
        case ">=":
          return gte(a, b, loose);
        case "<":
          return lt(a, b, loose);
        case "<=":
          return lte(a, b, loose);
        default:
          throw new TypeError(`Invalid operator: ${op}`);
      }
    };
    module2.exports = cmp;
  }
});

// node_modules/semver/functions/coerce.js
var require_coerce = __commonJS({
  "node_modules/semver/functions/coerce.js"(exports2, module2) {
    var SemVer = require_semver();
    var parse = require_parse();
    var { safeRe: re, t } = require_re();
    var coerce = (version, options) => {
      if (version instanceof SemVer) {
        return version;
      }
      if (typeof version === "number") {
        version = String(version);
      }
      if (typeof version !== "string") {
        return null;
      }
      options = options || {};
      let match = null;
      if (!options.rtl) {
        match = version.match(options.includePrerelease ? re[t.COERCEFULL] : re[t.COERCE]);
      } else {
        const coerceRtlRegex = options.includePrerelease ? re[t.COERCERTLFULL] : re[t.COERCERTL];
        let next;
        while ((next = coerceRtlRegex.exec(version)) && (!match || match.index + match[0].length !== version.length)) {
          if (!match || next.index + next[0].length !== match.index + match[0].length) {
            match = next;
          }
          coerceRtlRegex.lastIndex = next.index + next[1].length + next[2].length;
        }
        coerceRtlRegex.lastIndex = -1;
      }
      if (match === null) {
        return null;
      }
      const major = match[2];
      const minor = match[3] || "0";
      const patch = match[4] || "0";
      const prerelease = options.includePrerelease && match[5] ? `-${match[5]}` : "";
      const build = options.includePrerelease && match[6] ? `+${match[6]}` : "";
      return parse(`${major}.${minor}.${patch}${prerelease}${build}`, options);
    };
    module2.exports = coerce;
  }
});

// node_modules/yallist/iterator.js
var require_iterator = __commonJS({
  "node_modules/yallist/iterator.js"(exports2, module2) {
    "use strict";
    module2.exports = function(Yallist) {
      Yallist.prototype[Symbol.iterator] = function* () {
        for (let walker = this.head; walker; walker = walker.next) {
          yield walker.value;
        }
      };
    };
  }
});

// node_modules/yallist/yallist.js
var require_yallist = __commonJS({
  "node_modules/yallist/yallist.js"(exports2, module2) {
    "use strict";
    module2.exports = Yallist;
    Yallist.Node = Node;
    Yallist.create = Yallist;
    function Yallist(list) {
      var self2 = this;
      if (!(self2 instanceof Yallist)) {
        self2 = new Yallist();
      }
      self2.tail = null;
      self2.head = null;
      self2.length = 0;
      if (list && typeof list.forEach === "function") {
        list.forEach(function(item) {
          self2.push(item);
        });
      } else if (arguments.length > 0) {
        for (var i = 0, l = arguments.length; i < l; i++) {
          self2.push(arguments[i]);
        }
      }
      return self2;
    }
    Yallist.prototype.removeNode = function(node) {
      if (node.list !== this) {
        throw new Error("removing node which does not belong to this list");
      }
      var next = node.next;
      var prev = node.prev;
      if (next) {
        next.prev = prev;
      }
      if (prev) {
        prev.next = next;
      }
      if (node === this.head) {
        this.head = next;
      }
      if (node === this.tail) {
        this.tail = prev;
      }
      node.list.length--;
      node.next = null;
      node.prev = null;
      node.list = null;
      return next;
    };
    Yallist.prototype.unshiftNode = function(node) {
      if (node === this.head) {
        return;
      }
      if (node.list) {
        node.list.removeNode(node);
      }
      var head = this.head;
      node.list = this;
      node.next = head;
      if (head) {
        head.prev = node;
      }
      this.head = node;
      if (!this.tail) {
        this.tail = node;
      }
      this.length++;
    };
    Yallist.prototype.pushNode = function(node) {
      if (node === this.tail) {
        return;
      }
      if (node.list) {
        node.list.removeNode(node);
      }
      var tail = this.tail;
      node.list = this;
      node.prev = tail;
      if (tail) {
        tail.next = node;
      }
      this.tail = node;
      if (!this.head) {
        this.head = node;
      }
      this.length++;
    };
    Yallist.prototype.push = function() {
      for (var i = 0, l = arguments.length; i < l; i++) {
        push(this, arguments[i]);
      }
      return this.length;
    };
    Yallist.prototype.unshift = function() {
      for (var i = 0, l = arguments.length; i < l; i++) {
        unshift(this, arguments[i]);
      }
      return this.length;
    };
    Yallist.prototype.pop = function() {
      if (!this.tail) {
        return void 0;
      }
      var res = this.tail.value;
      this.tail = this.tail.prev;
      if (this.tail) {
        this.tail.next = null;
      } else {
        this.head = null;
      }
      this.length--;
      return res;
    };
    Yallist.prototype.shift = function() {
      if (!this.head) {
        return void 0;
      }
      var res = this.head.value;
      this.head = this.head.next;
      if (this.head) {
        this.head.prev = null;
      } else {
        this.tail = null;
      }
      this.length--;
      return res;
    };
    Yallist.prototype.forEach = function(fn, thisp) {
      thisp = thisp || this;
      for (var walker = this.head, i = 0; walker !== null; i++) {
        fn.call(thisp, walker.value, i, this);
        walker = walker.next;
      }
    };
    Yallist.prototype.forEachReverse = function(fn, thisp) {
      thisp = thisp || this;
      for (var walker = this.tail, i = this.length - 1; walker !== null; i--) {
        fn.call(thisp, walker.value, i, this);
        walker = walker.prev;
      }
    };
    Yallist.prototype.get = function(n) {
      for (var i = 0, walker = this.head; walker !== null && i < n; i++) {
        walker = walker.next;
      }
      if (i === n && walker !== null) {
        return walker.value;
      }
    };
    Yallist.prototype.getReverse = function(n) {
      for (var i = 0, walker = this.tail; walker !== null && i < n; i++) {
        walker = walker.prev;
      }
      if (i === n && walker !== null) {
        return walker.value;
      }
    };
    Yallist.prototype.map = function(fn, thisp) {
      thisp = thisp || this;
      var res = new Yallist();
      for (var walker = this.head; walker !== null; ) {
        res.push(fn.call(thisp, walker.value, this));
        walker = walker.next;
      }
      return res;
    };
    Yallist.prototype.mapReverse = function(fn, thisp) {
      thisp = thisp || this;
      var res = new Yallist();
      for (var walker = this.tail; walker !== null; ) {
        res.push(fn.call(thisp, walker.value, this));
        walker = walker.prev;
      }
      return res;
    };
    Yallist.prototype.reduce = function(fn, initial) {
      var acc;
      var walker = this.head;
      if (arguments.length > 1) {
        acc = initial;
      } else if (this.head) {
        walker = this.head.next;
        acc = this.head.value;
      } else {
        throw new TypeError("Reduce of empty list with no initial value");
      }
      for (var i = 0; walker !== null; i++) {
        acc = fn(acc, walker.value, i);
        walker = walker.next;
      }
      return acc;
    };
    Yallist.prototype.reduceReverse = function(fn, initial) {
      var acc;
      var walker = this.tail;
      if (arguments.length > 1) {
        acc = initial;
      } else if (this.tail) {
        walker = this.tail.prev;
        acc = this.tail.value;
      } else {
        throw new TypeError("Reduce of empty list with no initial value");
      }
      for (var i = this.length - 1; walker !== null; i--) {
        acc = fn(acc, walker.value, i);
        walker = walker.prev;
      }
      return acc;
    };
    Yallist.prototype.toArray = function() {
      var arr = new Array(this.length);
      for (var i = 0, walker = this.head; walker !== null; i++) {
        arr[i] = walker.value;
        walker = walker.next;
      }
      return arr;
    };
    Yallist.prototype.toArrayReverse = function() {
      var arr = new Array(this.length);
      for (var i = 0, walker = this.tail; walker !== null; i++) {
        arr[i] = walker.value;
        walker = walker.prev;
      }
      return arr;
    };
    Yallist.prototype.slice = function(from, to) {
      to = to || this.length;
      if (to < 0) {
        to += this.length;
      }
      from = from || 0;
      if (from < 0) {
        from += this.length;
      }
      var ret = new Yallist();
      if (to < from || to < 0) {
        return ret;
      }
      if (from < 0) {
        from = 0;
      }
      if (to > this.length) {
        to = this.length;
      }
      for (var i = 0, walker = this.head; walker !== null && i < from; i++) {
        walker = walker.next;
      }
      for (; walker !== null && i < to; i++, walker = walker.next) {
        ret.push(walker.value);
      }
      return ret;
    };
    Yallist.prototype.sliceReverse = function(from, to) {
      to = to || this.length;
      if (to < 0) {
        to += this.length;
      }
      from = from || 0;
      if (from < 0) {
        from += this.length;
      }
      var ret = new Yallist();
      if (to < from || to < 0) {
        return ret;
      }
      if (from < 0) {
        from = 0;
      }
      if (to > this.length) {
        to = this.length;
      }
      for (var i = this.length, walker = this.tail; walker !== null && i > to; i--) {
        walker = walker.prev;
      }
      for (; walker !== null && i > from; i--, walker = walker.prev) {
        ret.push(walker.value);
      }
      return ret;
    };
    Yallist.prototype.splice = function(start, deleteCount, ...nodes) {
      if (start > this.length) {
        start = this.length - 1;
      }
      if (start < 0) {
        start = this.length + start;
      }
      for (var i = 0, walker = this.head; walker !== null && i < start; i++) {
        walker = walker.next;
      }
      var ret = [];
      for (var i = 0; walker && i < deleteCount; i++) {
        ret.push(walker.value);
        walker = this.removeNode(walker);
      }
      if (walker === null) {
        walker = this.tail;
      }
      if (walker !== this.head && walker !== this.tail) {
        walker = walker.prev;
      }
      for (var i = 0; i < nodes.length; i++) {
        walker = insert(this, walker, nodes[i]);
      }
      return ret;
    };
    Yallist.prototype.reverse = function() {
      var head = this.head;
      var tail = this.tail;
      for (var walker = head; walker !== null; walker = walker.prev) {
        var p = walker.prev;
        walker.prev = walker.next;
        walker.next = p;
      }
      this.head = tail;
      this.tail = head;
      return this;
    };
    function insert(self2, node, value) {
      var inserted = node === self2.head ? new Node(value, null, node, self2) : new Node(value, node, node.next, self2);
      if (inserted.next === null) {
        self2.tail = inserted;
      }
      if (inserted.prev === null) {
        self2.head = inserted;
      }
      self2.length++;
      return inserted;
    }
    function push(self2, item) {
      self2.tail = new Node(item, self2.tail, null, self2);
      if (!self2.head) {
        self2.head = self2.tail;
      }
      self2.length++;
    }
    function unshift(self2, item) {
      self2.head = new Node(item, null, self2.head, self2);
      if (!self2.tail) {
        self2.tail = self2.head;
      }
      self2.length++;
    }
    function Node(value, prev, next, list) {
      if (!(this instanceof Node)) {
        return new Node(value, prev, next, list);
      }
      this.list = list;
      this.value = value;
      if (prev) {
        prev.next = this;
        this.prev = prev;
      } else {
        this.prev = null;
      }
      if (next) {
        next.prev = this;
        this.next = next;
      } else {
        this.next = null;
      }
    }
    try {
      require_iterator()(Yallist);
    } catch (er) {
    }
  }
});

// node_modules/semver/node_modules/lru-cache/index.js
var require_lru_cache = __commonJS({
  "node_modules/semver/node_modules/lru-cache/index.js"(exports2, module2) {
    "use strict";
    var Yallist = require_yallist();
    var MAX = Symbol("max");
    var LENGTH = Symbol("length");
    var LENGTH_CALCULATOR = Symbol("lengthCalculator");
    var ALLOW_STALE = Symbol("allowStale");
    var MAX_AGE = Symbol("maxAge");
    var DISPOSE = Symbol("dispose");
    var NO_DISPOSE_ON_SET = Symbol("noDisposeOnSet");
    var LRU_LIST = Symbol("lruList");
    var CACHE = Symbol("cache");
    var UPDATE_AGE_ON_GET = Symbol("updateAgeOnGet");
    var naiveLength = () => 1;
    var LRUCache = class {
      constructor(options) {
        if (typeof options === "number")
          options = { max: options };
        if (!options)
          options = {};
        if (options.max && (typeof options.max !== "number" || options.max < 0))
          throw new TypeError("max must be a non-negative number");
        const max = this[MAX] = options.max || Infinity;
        const lc = options.length || naiveLength;
        this[LENGTH_CALCULATOR] = typeof lc !== "function" ? naiveLength : lc;
        this[ALLOW_STALE] = options.stale || false;
        if (options.maxAge && typeof options.maxAge !== "number")
          throw new TypeError("maxAge must be a number");
        this[MAX_AGE] = options.maxAge || 0;
        this[DISPOSE] = options.dispose;
        this[NO_DISPOSE_ON_SET] = options.noDisposeOnSet || false;
        this[UPDATE_AGE_ON_GET] = options.updateAgeOnGet || false;
        this.reset();
      }
      set max(mL) {
        if (typeof mL !== "number" || mL < 0)
          throw new TypeError("max must be a non-negative number");
        this[MAX] = mL || Infinity;
        trim(this);
      }
      get max() {
        return this[MAX];
      }
      set allowStale(allowStale) {
        this[ALLOW_STALE] = !!allowStale;
      }
      get allowStale() {
        return this[ALLOW_STALE];
      }
      set maxAge(mA) {
        if (typeof mA !== "number")
          throw new TypeError("maxAge must be a non-negative number");
        this[MAX_AGE] = mA;
        trim(this);
      }
      get maxAge() {
        return this[MAX_AGE];
      }
      set lengthCalculator(lC) {
        if (typeof lC !== "function")
          lC = naiveLength;
        if (lC !== this[LENGTH_CALCULATOR]) {
          this[LENGTH_CALCULATOR] = lC;
          this[LENGTH] = 0;
          this[LRU_LIST].forEach((hit) => {
            hit.length = this[LENGTH_CALCULATOR](hit.value, hit.key);
            this[LENGTH] += hit.length;
          });
        }
        trim(this);
      }
      get lengthCalculator() {
        return this[LENGTH_CALCULATOR];
      }
      get length() {
        return this[LENGTH];
      }
      get itemCount() {
        return this[LRU_LIST].length;
      }
      rforEach(fn, thisp) {
        thisp = thisp || this;
        for (let walker = this[LRU_LIST].tail; walker !== null; ) {
          const prev = walker.prev;
          forEachStep(this, fn, walker, thisp);
          walker = prev;
        }
      }
      forEach(fn, thisp) {
        thisp = thisp || this;
        for (let walker = this[LRU_LIST].head; walker !== null; ) {
          const next = walker.next;
          forEachStep(this, fn, walker, thisp);
          walker = next;
        }
      }
      keys() {
        return this[LRU_LIST].toArray().map((k) => k.key);
      }
      values() {
        return this[LRU_LIST].toArray().map((k) => k.value);
      }
      reset() {
        if (this[DISPOSE] && this[LRU_LIST] && this[LRU_LIST].length) {
          this[LRU_LIST].forEach((hit) => this[DISPOSE](hit.key, hit.value));
        }
        this[CACHE] = /* @__PURE__ */ new Map();
        this[LRU_LIST] = new Yallist();
        this[LENGTH] = 0;
      }
      dump() {
        return this[LRU_LIST].map((hit) => isStale(this, hit) ? false : {
          k: hit.key,
          v: hit.value,
          e: hit.now + (hit.maxAge || 0)
        }).toArray().filter((h) => h);
      }
      dumpLru() {
        return this[LRU_LIST];
      }
      set(key, value, maxAge) {
        maxAge = maxAge || this[MAX_AGE];
        if (maxAge && typeof maxAge !== "number")
          throw new TypeError("maxAge must be a number");
        const now = maxAge ? Date.now() : 0;
        const len = this[LENGTH_CALCULATOR](value, key);
        if (this[CACHE].has(key)) {
          if (len > this[MAX]) {
            del(this, this[CACHE].get(key));
            return false;
          }
          const node = this[CACHE].get(key);
          const item = node.value;
          if (this[DISPOSE]) {
            if (!this[NO_DISPOSE_ON_SET])
              this[DISPOSE](key, item.value);
          }
          item.now = now;
          item.maxAge = maxAge;
          item.value = value;
          this[LENGTH] += len - item.length;
          item.length = len;
          this.get(key);
          trim(this);
          return true;
        }
        const hit = new Entry(key, value, len, now, maxAge);
        if (hit.length > this[MAX]) {
          if (this[DISPOSE])
            this[DISPOSE](key, value);
          return false;
        }
        this[LENGTH] += hit.length;
        this[LRU_LIST].unshift(hit);
        this[CACHE].set(key, this[LRU_LIST].head);
        trim(this);
        return true;
      }
      has(key) {
        if (!this[CACHE].has(key))
          return false;
        const hit = this[CACHE].get(key).value;
        return !isStale(this, hit);
      }
      get(key) {
        return get(this, key, true);
      }
      peek(key) {
        return get(this, key, false);
      }
      pop() {
        const node = this[LRU_LIST].tail;
        if (!node)
          return null;
        del(this, node);
        return node.value;
      }
      del(key) {
        del(this, this[CACHE].get(key));
      }
      load(arr) {
        this.reset();
        const now = Date.now();
        for (let l = arr.length - 1; l >= 0; l--) {
          const hit = arr[l];
          const expiresAt = hit.e || 0;
          if (expiresAt === 0)
            this.set(hit.k, hit.v);
          else {
            const maxAge = expiresAt - now;
            if (maxAge > 0) {
              this.set(hit.k, hit.v, maxAge);
            }
          }
        }
      }
      prune() {
        this[CACHE].forEach((value, key) => get(this, key, false));
      }
    };
    var get = (self2, key, doUse) => {
      const node = self2[CACHE].get(key);
      if (node) {
        const hit = node.value;
        if (isStale(self2, hit)) {
          del(self2, node);
          if (!self2[ALLOW_STALE])
            return void 0;
        } else {
          if (doUse) {
            if (self2[UPDATE_AGE_ON_GET])
              node.value.now = Date.now();
            self2[LRU_LIST].unshiftNode(node);
          }
        }
        return hit.value;
      }
    };
    var isStale = (self2, hit) => {
      if (!hit || !hit.maxAge && !self2[MAX_AGE])
        return false;
      const diff = Date.now() - hit.now;
      return hit.maxAge ? diff > hit.maxAge : self2[MAX_AGE] && diff > self2[MAX_AGE];
    };
    var trim = (self2) => {
      if (self2[LENGTH] > self2[MAX]) {
        for (let walker = self2[LRU_LIST].tail; self2[LENGTH] > self2[MAX] && walker !== null; ) {
          const prev = walker.prev;
          del(self2, walker);
          walker = prev;
        }
      }
    };
    var del = (self2, node) => {
      if (node) {
        const hit = node.value;
        if (self2[DISPOSE])
          self2[DISPOSE](hit.key, hit.value);
        self2[LENGTH] -= hit.length;
        self2[CACHE].delete(hit.key);
        self2[LRU_LIST].removeNode(node);
      }
    };
    var Entry = class {
      constructor(key, value, length, now, maxAge) {
        this.key = key;
        this.value = value;
        this.length = length;
        this.now = now;
        this.maxAge = maxAge || 0;
      }
    };
    var forEachStep = (self2, fn, node, thisp) => {
      let hit = node.value;
      if (isStale(self2, hit)) {
        del(self2, node);
        if (!self2[ALLOW_STALE])
          hit = void 0;
      }
      if (hit)
        fn.call(thisp, hit.value, hit.key, self2);
    };
    module2.exports = LRUCache;
  }
});

// node_modules/semver/classes/range.js
var require_range = __commonJS({
  "node_modules/semver/classes/range.js"(exports2, module2) {
    var Range = class {
      constructor(range, options) {
        options = parseOptions(options);
        if (range instanceof Range) {
          if (range.loose === !!options.loose && range.includePrerelease === !!options.includePrerelease) {
            return range;
          } else {
            return new Range(range.raw, options);
          }
        }
        if (range instanceof Comparator) {
          this.raw = range.value;
          this.set = [[range]];
          this.format();
          return this;
        }
        this.options = options;
        this.loose = !!options.loose;
        this.includePrerelease = !!options.includePrerelease;
        this.raw = range.trim().split(/\s+/).join(" ");
        this.set = this.raw.split("||").map((r) => this.parseRange(r.trim())).filter((c) => c.length);
        if (!this.set.length) {
          throw new TypeError(`Invalid SemVer Range: ${this.raw}`);
        }
        if (this.set.length > 1) {
          const first = this.set[0];
          this.set = this.set.filter((c) => !isNullSet(c[0]));
          if (this.set.length === 0) {
            this.set = [first];
          } else if (this.set.length > 1) {
            for (const c of this.set) {
              if (c.length === 1 && isAny(c[0])) {
                this.set = [c];
                break;
              }
            }
          }
        }
        this.format();
      }
      format() {
        this.range = this.set.map((comps) => comps.join(" ").trim()).join("||").trim();
        return this.range;
      }
      toString() {
        return this.range;
      }
      parseRange(range) {
        const memoOpts = (this.options.includePrerelease && FLAG_INCLUDE_PRERELEASE) | (this.options.loose && FLAG_LOOSE);
        const memoKey = memoOpts + ":" + range;
        const cached = cache.get(memoKey);
        if (cached) {
          return cached;
        }
        const loose = this.options.loose;
        const hr = loose ? re[t.HYPHENRANGELOOSE] : re[t.HYPHENRANGE];
        range = range.replace(hr, hyphenReplace(this.options.includePrerelease));
        debug("hyphen replace", range);
        range = range.replace(re[t.COMPARATORTRIM], comparatorTrimReplace);
        debug("comparator trim", range);
        range = range.replace(re[t.TILDETRIM], tildeTrimReplace);
        debug("tilde trim", range);
        range = range.replace(re[t.CARETTRIM], caretTrimReplace);
        debug("caret trim", range);
        let rangeList = range.split(" ").map((comp) => parseComparator(comp, this.options)).join(" ").split(/\s+/).map((comp) => replaceGTE0(comp, this.options));
        if (loose) {
          rangeList = rangeList.filter((comp) => {
            debug("loose invalid filter", comp, this.options);
            return !!comp.match(re[t.COMPARATORLOOSE]);
          });
        }
        debug("range list", rangeList);
        const rangeMap = /* @__PURE__ */ new Map();
        const comparators = rangeList.map((comp) => new Comparator(comp, this.options));
        for (const comp of comparators) {
          if (isNullSet(comp)) {
            return [comp];
          }
          rangeMap.set(comp.value, comp);
        }
        if (rangeMap.size > 1 && rangeMap.has("")) {
          rangeMap.delete("");
        }
        const result = [...rangeMap.values()];
        cache.set(memoKey, result);
        return result;
      }
      intersects(range, options) {
        if (!(range instanceof Range)) {
          throw new TypeError("a Range is required");
        }
        return this.set.some((thisComparators) => {
          return isSatisfiable(thisComparators, options) && range.set.some((rangeComparators) => {
            return isSatisfiable(rangeComparators, options) && thisComparators.every((thisComparator) => {
              return rangeComparators.every((rangeComparator) => {
                return thisComparator.intersects(rangeComparator, options);
              });
            });
          });
        });
      }
      test(version) {
        if (!version) {
          return false;
        }
        if (typeof version === "string") {
          try {
            version = new SemVer(version, this.options);
          } catch (er) {
            return false;
          }
        }
        for (let i = 0; i < this.set.length; i++) {
          if (testSet(this.set[i], version, this.options)) {
            return true;
          }
        }
        return false;
      }
    };
    module2.exports = Range;
    var LRU = require_lru_cache();
    var cache = new LRU({ max: 1e3 });
    var parseOptions = require_parse_options();
    var Comparator = require_comparator();
    var debug = require_debug2();
    var SemVer = require_semver();
    var {
      safeRe: re,
      t,
      comparatorTrimReplace,
      tildeTrimReplace,
      caretTrimReplace
    } = require_re();
    var { FLAG_INCLUDE_PRERELEASE, FLAG_LOOSE } = require_constants();
    var isNullSet = (c) => c.value === "<0.0.0-0";
    var isAny = (c) => c.value === "";
    var isSatisfiable = (comparators, options) => {
      let result = true;
      const remainingComparators = comparators.slice();
      let testComparator = remainingComparators.pop();
      while (result && remainingComparators.length) {
        result = remainingComparators.every((otherComparator) => {
          return testComparator.intersects(otherComparator, options);
        });
        testComparator = remainingComparators.pop();
      }
      return result;
    };
    var parseComparator = (comp, options) => {
      debug("comp", comp, options);
      comp = replaceCarets(comp, options);
      debug("caret", comp);
      comp = replaceTildes(comp, options);
      debug("tildes", comp);
      comp = replaceXRanges(comp, options);
      debug("xrange", comp);
      comp = replaceStars(comp, options);
      debug("stars", comp);
      return comp;
    };
    var isX = (id) => !id || id.toLowerCase() === "x" || id === "*";
    var replaceTildes = (comp, options) => {
      return comp.trim().split(/\s+/).map((c) => replaceTilde(c, options)).join(" ");
    };
    var replaceTilde = (comp, options) => {
      const r = options.loose ? re[t.TILDELOOSE] : re[t.TILDE];
      return comp.replace(r, (_, M, m, p, pr) => {
        debug("tilde", comp, _, M, m, p, pr);
        let ret;
        if (isX(M)) {
          ret = "";
        } else if (isX(m)) {
          ret = `>=${M}.0.0 <${+M + 1}.0.0-0`;
        } else if (isX(p)) {
          ret = `>=${M}.${m}.0 <${M}.${+m + 1}.0-0`;
        } else if (pr) {
          debug("replaceTilde pr", pr);
          ret = `>=${M}.${m}.${p}-${pr} <${M}.${+m + 1}.0-0`;
        } else {
          ret = `>=${M}.${m}.${p} <${M}.${+m + 1}.0-0`;
        }
        debug("tilde return", ret);
        return ret;
      });
    };
    var replaceCarets = (comp, options) => {
      return comp.trim().split(/\s+/).map((c) => replaceCaret(c, options)).join(" ");
    };
    var replaceCaret = (comp, options) => {
      debug("caret", comp, options);
      const r = options.loose ? re[t.CARETLOOSE] : re[t.CARET];
      const z = options.includePrerelease ? "-0" : "";
      return comp.replace(r, (_, M, m, p, pr) => {
        debug("caret", comp, _, M, m, p, pr);
        let ret;
        if (isX(M)) {
          ret = "";
        } else if (isX(m)) {
          ret = `>=${M}.0.0${z} <${+M + 1}.0.0-0`;
        } else if (isX(p)) {
          if (M === "0") {
            ret = `>=${M}.${m}.0${z} <${M}.${+m + 1}.0-0`;
          } else {
            ret = `>=${M}.${m}.0${z} <${+M + 1}.0.0-0`;
          }
        } else if (pr) {
          debug("replaceCaret pr", pr);
          if (M === "0") {
            if (m === "0") {
              ret = `>=${M}.${m}.${p}-${pr} <${M}.${m}.${+p + 1}-0`;
            } else {
              ret = `>=${M}.${m}.${p}-${pr} <${M}.${+m + 1}.0-0`;
            }
          } else {
            ret = `>=${M}.${m}.${p}-${pr} <${+M + 1}.0.0-0`;
          }
        } else {
          debug("no pr");
          if (M === "0") {
            if (m === "0") {
              ret = `>=${M}.${m}.${p}${z} <${M}.${m}.${+p + 1}-0`;
            } else {
              ret = `>=${M}.${m}.${p}${z} <${M}.${+m + 1}.0-0`;
            }
          } else {
            ret = `>=${M}.${m}.${p} <${+M + 1}.0.0-0`;
          }
        }
        debug("caret return", ret);
        return ret;
      });
    };
    var replaceXRanges = (comp, options) => {
      debug("replaceXRanges", comp, options);
      return comp.split(/\s+/).map((c) => replaceXRange(c, options)).join(" ");
    };
    var replaceXRange = (comp, options) => {
      comp = comp.trim();
      const r = options.loose ? re[t.XRANGELOOSE] : re[t.XRANGE];
      return comp.replace(r, (ret, gtlt, M, m, p, pr) => {
        debug("xRange", comp, ret, gtlt, M, m, p, pr);
        const xM = isX(M);
        const xm = xM || isX(m);
        const xp = xm || isX(p);
        const anyX = xp;
        if (gtlt === "=" && anyX) {
          gtlt = "";
        }
        pr = options.includePrerelease ? "-0" : "";
        if (xM) {
          if (gtlt === ">" || gtlt === "<") {
            ret = "<0.0.0-0";
          } else {
            ret = "*";
          }
        } else if (gtlt && anyX) {
          if (xm) {
            m = 0;
          }
          p = 0;
          if (gtlt === ">") {
            gtlt = ">=";
            if (xm) {
              M = +M + 1;
              m = 0;
              p = 0;
            } else {
              m = +m + 1;
              p = 0;
            }
          } else if (gtlt === "<=") {
            gtlt = "<";
            if (xm) {
              M = +M + 1;
            } else {
              m = +m + 1;
            }
          }
          if (gtlt === "<") {
            pr = "-0";
          }
          ret = `${gtlt + M}.${m}.${p}${pr}`;
        } else if (xm) {
          ret = `>=${M}.0.0${pr} <${+M + 1}.0.0-0`;
        } else if (xp) {
          ret = `>=${M}.${m}.0${pr} <${M}.${+m + 1}.0-0`;
        }
        debug("xRange return", ret);
        return ret;
      });
    };
    var replaceStars = (comp, options) => {
      debug("replaceStars", comp, options);
      return comp.trim().replace(re[t.STAR], "");
    };
    var replaceGTE0 = (comp, options) => {
      debug("replaceGTE0", comp, options);
      return comp.trim().replace(re[options.includePrerelease ? t.GTE0PRE : t.GTE0], "");
    };
    var hyphenReplace = (incPr) => ($0, from, fM, fm, fp, fpr, fb, to, tM, tm, tp, tpr, tb) => {
      if (isX(fM)) {
        from = "";
      } else if (isX(fm)) {
        from = `>=${fM}.0.0${incPr ? "-0" : ""}`;
      } else if (isX(fp)) {
        from = `>=${fM}.${fm}.0${incPr ? "-0" : ""}`;
      } else if (fpr) {
        from = `>=${from}`;
      } else {
        from = `>=${from}${incPr ? "-0" : ""}`;
      }
      if (isX(tM)) {
        to = "";
      } else if (isX(tm)) {
        to = `<${+tM + 1}.0.0-0`;
      } else if (isX(tp)) {
        to = `<${tM}.${+tm + 1}.0-0`;
      } else if (tpr) {
        to = `<=${tM}.${tm}.${tp}-${tpr}`;
      } else if (incPr) {
        to = `<${tM}.${tm}.${+tp + 1}-0`;
      } else {
        to = `<=${to}`;
      }
      return `${from} ${to}`.trim();
    };
    var testSet = (set, version, options) => {
      for (let i = 0; i < set.length; i++) {
        if (!set[i].test(version)) {
          return false;
        }
      }
      if (version.prerelease.length && !options.includePrerelease) {
        for (let i = 0; i < set.length; i++) {
          debug(set[i].semver);
          if (set[i].semver === Comparator.ANY) {
            continue;
          }
          if (set[i].semver.prerelease.length > 0) {
            const allowed = set[i].semver;
            if (allowed.major === version.major && allowed.minor === version.minor && allowed.patch === version.patch) {
              return true;
            }
          }
        }
        return false;
      }
      return true;
    };
  }
});

// node_modules/semver/classes/comparator.js
var require_comparator = __commonJS({
  "node_modules/semver/classes/comparator.js"(exports2, module2) {
    var ANY = Symbol("SemVer ANY");
    var Comparator = class {
      static get ANY() {
        return ANY;
      }
      constructor(comp, options) {
        options = parseOptions(options);
        if (comp instanceof Comparator) {
          if (comp.loose === !!options.loose) {
            return comp;
          } else {
            comp = comp.value;
          }
        }
        comp = comp.trim().split(/\s+/).join(" ");
        debug("comparator", comp, options);
        this.options = options;
        this.loose = !!options.loose;
        this.parse(comp);
        if (this.semver === ANY) {
          this.value = "";
        } else {
          this.value = this.operator + this.semver.version;
        }
        debug("comp", this);
      }
      parse(comp) {
        const r = this.options.loose ? re[t.COMPARATORLOOSE] : re[t.COMPARATOR];
        const m = comp.match(r);
        if (!m) {
          throw new TypeError(`Invalid comparator: ${comp}`);
        }
        this.operator = m[1] !== void 0 ? m[1] : "";
        if (this.operator === "=") {
          this.operator = "";
        }
        if (!m[2]) {
          this.semver = ANY;
        } else {
          this.semver = new SemVer(m[2], this.options.loose);
        }
      }
      toString() {
        return this.value;
      }
      test(version) {
        debug("Comparator.test", version, this.options.loose);
        if (this.semver === ANY || version === ANY) {
          return true;
        }
        if (typeof version === "string") {
          try {
            version = new SemVer(version, this.options);
          } catch (er) {
            return false;
          }
        }
        return cmp(version, this.operator, this.semver, this.options);
      }
      intersects(comp, options) {
        if (!(comp instanceof Comparator)) {
          throw new TypeError("a Comparator is required");
        }
        if (this.operator === "") {
          if (this.value === "") {
            return true;
          }
          return new Range(comp.value, options).test(this.value);
        } else if (comp.operator === "") {
          if (comp.value === "") {
            return true;
          }
          return new Range(this.value, options).test(comp.semver);
        }
        options = parseOptions(options);
        if (options.includePrerelease && (this.value === "<0.0.0-0" || comp.value === "<0.0.0-0")) {
          return false;
        }
        if (!options.includePrerelease && (this.value.startsWith("<0.0.0") || comp.value.startsWith("<0.0.0"))) {
          return false;
        }
        if (this.operator.startsWith(">") && comp.operator.startsWith(">")) {
          return true;
        }
        if (this.operator.startsWith("<") && comp.operator.startsWith("<")) {
          return true;
        }
        if (this.semver.version === comp.semver.version && this.operator.includes("=") && comp.operator.includes("=")) {
          return true;
        }
        if (cmp(this.semver, "<", comp.semver, options) && this.operator.startsWith(">") && comp.operator.startsWith("<")) {
          return true;
        }
        if (cmp(this.semver, ">", comp.semver, options) && this.operator.startsWith("<") && comp.operator.startsWith(">")) {
          return true;
        }
        return false;
      }
    };
    module2.exports = Comparator;
    var parseOptions = require_parse_options();
    var { safeRe: re, t } = require_re();
    var cmp = require_cmp();
    var debug = require_debug2();
    var SemVer = require_semver();
    var Range = require_range();
  }
});

// node_modules/semver/functions/satisfies.js
var require_satisfies = __commonJS({
  "node_modules/semver/functions/satisfies.js"(exports2, module2) {
    var Range = require_range();
    var satisfies = (version, range, options) => {
      try {
        range = new Range(range, options);
      } catch (er) {
        return false;
      }
      return range.test(version);
    };
    module2.exports = satisfies;
  }
});

// node_modules/semver/ranges/to-comparators.js
var require_to_comparators = __commonJS({
  "node_modules/semver/ranges/to-comparators.js"(exports2, module2) {
    var Range = require_range();
    var toComparators = (range, options) => new Range(range, options).set.map((comp) => comp.map((c) => c.value).join(" ").trim().split(" "));
    module2.exports = toComparators;
  }
});

// node_modules/semver/ranges/max-satisfying.js
var require_max_satisfying = __commonJS({
  "node_modules/semver/ranges/max-satisfying.js"(exports2, module2) {
    var SemVer = require_semver();
    var Range = require_range();
    var maxSatisfying = (versions, range, options) => {
      let max = null;
      let maxSV = null;
      let rangeObj = null;
      try {
        rangeObj = new Range(range, options);
      } catch (er) {
        return null;
      }
      versions.forEach((v) => {
        if (rangeObj.test(v)) {
          if (!max || maxSV.compare(v) === -1) {
            max = v;
            maxSV = new SemVer(max, options);
          }
        }
      });
      return max;
    };
    module2.exports = maxSatisfying;
  }
});

// node_modules/semver/ranges/min-satisfying.js
var require_min_satisfying = __commonJS({
  "node_modules/semver/ranges/min-satisfying.js"(exports2, module2) {
    var SemVer = require_semver();
    var Range = require_range();
    var minSatisfying = (versions, range, options) => {
      let min = null;
      let minSV = null;
      let rangeObj = null;
      try {
        rangeObj = new Range(range, options);
      } catch (er) {
        return null;
      }
      versions.forEach((v) => {
        if (rangeObj.test(v)) {
          if (!min || minSV.compare(v) === 1) {
            min = v;
            minSV = new SemVer(min, options);
          }
        }
      });
      return min;
    };
    module2.exports = minSatisfying;
  }
});

// node_modules/semver/ranges/min-version.js
var require_min_version = __commonJS({
  "node_modules/semver/ranges/min-version.js"(exports2, module2) {
    var SemVer = require_semver();
    var Range = require_range();
    var gt = require_gt();
    var minVersion = (range, loose) => {
      range = new Range(range, loose);
      let minver = new SemVer("0.0.0");
      if (range.test(minver)) {
        return minver;
      }
      minver = new SemVer("0.0.0-0");
      if (range.test(minver)) {
        return minver;
      }
      minver = null;
      for (let i = 0; i < range.set.length; ++i) {
        const comparators = range.set[i];
        let setMin = null;
        comparators.forEach((comparator) => {
          const compver = new SemVer(comparator.semver.version);
          switch (comparator.operator) {
            case ">":
              if (compver.prerelease.length === 0) {
                compver.patch++;
              } else {
                compver.prerelease.push(0);
              }
              compver.raw = compver.format();
            case "":
            case ">=":
              if (!setMin || gt(compver, setMin)) {
                setMin = compver;
              }
              break;
            case "<":
            case "<=":
              break;
            default:
              throw new Error(`Unexpected operation: ${comparator.operator}`);
          }
        });
        if (setMin && (!minver || gt(minver, setMin))) {
          minver = setMin;
        }
      }
      if (minver && range.test(minver)) {
        return minver;
      }
      return null;
    };
    module2.exports = minVersion;
  }
});

// node_modules/semver/ranges/valid.js
var require_valid2 = __commonJS({
  "node_modules/semver/ranges/valid.js"(exports2, module2) {
    var Range = require_range();
    var validRange = (range, options) => {
      try {
        return new Range(range, options).range || "*";
      } catch (er) {
        return null;
      }
    };
    module2.exports = validRange;
  }
});

// node_modules/semver/ranges/outside.js
var require_outside = __commonJS({
  "node_modules/semver/ranges/outside.js"(exports2, module2) {
    var SemVer = require_semver();
    var Comparator = require_comparator();
    var { ANY } = Comparator;
    var Range = require_range();
    var satisfies = require_satisfies();
    var gt = require_gt();
    var lt = require_lt();
    var lte = require_lte();
    var gte = require_gte();
    var outside = (version, range, hilo, options) => {
      version = new SemVer(version, options);
      range = new Range(range, options);
      let gtfn, ltefn, ltfn, comp, ecomp;
      switch (hilo) {
        case ">":
          gtfn = gt;
          ltefn = lte;
          ltfn = lt;
          comp = ">";
          ecomp = ">=";
          break;
        case "<":
          gtfn = lt;
          ltefn = gte;
          ltfn = gt;
          comp = "<";
          ecomp = "<=";
          break;
        default:
          throw new TypeError('Must provide a hilo val of "<" or ">"');
      }
      if (satisfies(version, range, options)) {
        return false;
      }
      for (let i = 0; i < range.set.length; ++i) {
        const comparators = range.set[i];
        let high = null;
        let low = null;
        comparators.forEach((comparator) => {
          if (comparator.semver === ANY) {
            comparator = new Comparator(">=0.0.0");
          }
          high = high || comparator;
          low = low || comparator;
          if (gtfn(comparator.semver, high.semver, options)) {
            high = comparator;
          } else if (ltfn(comparator.semver, low.semver, options)) {
            low = comparator;
          }
        });
        if (high.operator === comp || high.operator === ecomp) {
          return false;
        }
        if ((!low.operator || low.operator === comp) && ltefn(version, low.semver)) {
          return false;
        } else if (low.operator === ecomp && ltfn(version, low.semver)) {
          return false;
        }
      }
      return true;
    };
    module2.exports = outside;
  }
});

// node_modules/semver/ranges/gtr.js
var require_gtr = __commonJS({
  "node_modules/semver/ranges/gtr.js"(exports2, module2) {
    var outside = require_outside();
    var gtr = (version, range, options) => outside(version, range, ">", options);
    module2.exports = gtr;
  }
});

// node_modules/semver/ranges/ltr.js
var require_ltr = __commonJS({
  "node_modules/semver/ranges/ltr.js"(exports2, module2) {
    var outside = require_outside();
    var ltr = (version, range, options) => outside(version, range, "<", options);
    module2.exports = ltr;
  }
});

// node_modules/semver/ranges/intersects.js
var require_intersects = __commonJS({
  "node_modules/semver/ranges/intersects.js"(exports2, module2) {
    var Range = require_range();
    var intersects = (r1, r2, options) => {
      r1 = new Range(r1, options);
      r2 = new Range(r2, options);
      return r1.intersects(r2, options);
    };
    module2.exports = intersects;
  }
});

// node_modules/semver/ranges/simplify.js
var require_simplify = __commonJS({
  "node_modules/semver/ranges/simplify.js"(exports2, module2) {
    var satisfies = require_satisfies();
    var compare = require_compare();
    module2.exports = (versions, range, options) => {
      const set = [];
      let first = null;
      let prev = null;
      const v = versions.sort((a, b) => compare(a, b, options));
      for (const version of v) {
        const included = satisfies(version, range, options);
        if (included) {
          prev = version;
          if (!first) {
            first = version;
          }
        } else {
          if (prev) {
            set.push([first, prev]);
          }
          prev = null;
          first = null;
        }
      }
      if (first) {
        set.push([first, null]);
      }
      const ranges = [];
      for (const [min, max] of set) {
        if (min === max) {
          ranges.push(min);
        } else if (!max && min === v[0]) {
          ranges.push("*");
        } else if (!max) {
          ranges.push(`>=${min}`);
        } else if (min === v[0]) {
          ranges.push(`<=${max}`);
        } else {
          ranges.push(`${min} - ${max}`);
        }
      }
      const simplified = ranges.join(" || ");
      const original = typeof range.raw === "string" ? range.raw : String(range);
      return simplified.length < original.length ? simplified : range;
    };
  }
});

// node_modules/semver/ranges/subset.js
var require_subset = __commonJS({
  "node_modules/semver/ranges/subset.js"(exports2, module2) {
    var Range = require_range();
    var Comparator = require_comparator();
    var { ANY } = Comparator;
    var satisfies = require_satisfies();
    var compare = require_compare();
    var subset = (sub, dom, options = {}) => {
      if (sub === dom) {
        return true;
      }
      sub = new Range(sub, options);
      dom = new Range(dom, options);
      let sawNonNull = false;
      OUTER:
        for (const simpleSub of sub.set) {
          for (const simpleDom of dom.set) {
            const isSub = simpleSubset(simpleSub, simpleDom, options);
            sawNonNull = sawNonNull || isSub !== null;
            if (isSub) {
              continue OUTER;
            }
          }
          if (sawNonNull) {
            return false;
          }
        }
      return true;
    };
    var minimumVersionWithPreRelease = [new Comparator(">=0.0.0-0")];
    var minimumVersion = [new Comparator(">=0.0.0")];
    var simpleSubset = (sub, dom, options) => {
      if (sub === dom) {
        return true;
      }
      if (sub.length === 1 && sub[0].semver === ANY) {
        if (dom.length === 1 && dom[0].semver === ANY) {
          return true;
        } else if (options.includePrerelease) {
          sub = minimumVersionWithPreRelease;
        } else {
          sub = minimumVersion;
        }
      }
      if (dom.length === 1 && dom[0].semver === ANY) {
        if (options.includePrerelease) {
          return true;
        } else {
          dom = minimumVersion;
        }
      }
      const eqSet = /* @__PURE__ */ new Set();
      let gt, lt;
      for (const c of sub) {
        if (c.operator === ">" || c.operator === ">=") {
          gt = higherGT(gt, c, options);
        } else if (c.operator === "<" || c.operator === "<=") {
          lt = lowerLT(lt, c, options);
        } else {
          eqSet.add(c.semver);
        }
      }
      if (eqSet.size > 1) {
        return null;
      }
      let gtltComp;
      if (gt && lt) {
        gtltComp = compare(gt.semver, lt.semver, options);
        if (gtltComp > 0) {
          return null;
        } else if (gtltComp === 0 && (gt.operator !== ">=" || lt.operator !== "<=")) {
          return null;
        }
      }
      for (const eq of eqSet) {
        if (gt && !satisfies(eq, String(gt), options)) {
          return null;
        }
        if (lt && !satisfies(eq, String(lt), options)) {
          return null;
        }
        for (const c of dom) {
          if (!satisfies(eq, String(c), options)) {
            return false;
          }
        }
        return true;
      }
      let higher, lower;
      let hasDomLT, hasDomGT;
      let needDomLTPre = lt && !options.includePrerelease && lt.semver.prerelease.length ? lt.semver : false;
      let needDomGTPre = gt && !options.includePrerelease && gt.semver.prerelease.length ? gt.semver : false;
      if (needDomLTPre && needDomLTPre.prerelease.length === 1 && lt.operator === "<" && needDomLTPre.prerelease[0] === 0) {
        needDomLTPre = false;
      }
      for (const c of dom) {
        hasDomGT = hasDomGT || c.operator === ">" || c.operator === ">=";
        hasDomLT = hasDomLT || c.operator === "<" || c.operator === "<=";
        if (gt) {
          if (needDomGTPre) {
            if (c.semver.prerelease && c.semver.prerelease.length && c.semver.major === needDomGTPre.major && c.semver.minor === needDomGTPre.minor && c.semver.patch === needDomGTPre.patch) {
              needDomGTPre = false;
            }
          }
          if (c.operator === ">" || c.operator === ">=") {
            higher = higherGT(gt, c, options);
            if (higher === c && higher !== gt) {
              return false;
            }
          } else if (gt.operator === ">=" && !satisfies(gt.semver, String(c), options)) {
            return false;
          }
        }
        if (lt) {
          if (needDomLTPre) {
            if (c.semver.prerelease && c.semver.prerelease.length && c.semver.major === needDomLTPre.major && c.semver.minor === needDomLTPre.minor && c.semver.patch === needDomLTPre.patch) {
              needDomLTPre = false;
            }
          }
          if (c.operator === "<" || c.operator === "<=") {
            lower = lowerLT(lt, c, options);
            if (lower === c && lower !== lt) {
              return false;
            }
          } else if (lt.operator === "<=" && !satisfies(lt.semver, String(c), options)) {
            return false;
          }
        }
        if (!c.operator && (lt || gt) && gtltComp !== 0) {
          return false;
        }
      }
      if (gt && hasDomLT && !lt && gtltComp !== 0) {
        return false;
      }
      if (lt && hasDomGT && !gt && gtltComp !== 0) {
        return false;
      }
      if (needDomGTPre || needDomLTPre) {
        return false;
      }
      return true;
    };
    var higherGT = (a, b, options) => {
      if (!a) {
        return b;
      }
      const comp = compare(a.semver, b.semver, options);
      return comp > 0 ? a : comp < 0 ? b : b.operator === ">" && a.operator === ">=" ? b : a;
    };
    var lowerLT = (a, b, options) => {
      if (!a) {
        return b;
      }
      const comp = compare(a.semver, b.semver, options);
      return comp < 0 ? a : comp > 0 ? b : b.operator === "<" && a.operator === "<=" ? b : a;
    };
    module2.exports = subset;
  }
});

// node_modules/semver/index.js
var require_semver2 = __commonJS({
  "node_modules/semver/index.js"(exports2, module2) {
    var internalRe = require_re();
    var constants3 = require_constants();
    var SemVer = require_semver();
    var identifiers = require_identifiers();
    var parse = require_parse();
    var valid = require_valid();
    var clean = require_clean();
    var inc = require_inc();
    var diff = require_diff();
    var major = require_major();
    var minor = require_minor();
    var patch = require_patch();
    var prerelease = require_prerelease();
    var compare = require_compare();
    var rcompare = require_rcompare();
    var compareLoose = require_compare_loose();
    var compareBuild = require_compare_build();
    var sort = require_sort();
    var rsort = require_rsort();
    var gt = require_gt();
    var lt = require_lt();
    var eq = require_eq();
    var neq = require_neq();
    var gte = require_gte();
    var lte = require_lte();
    var cmp = require_cmp();
    var coerce = require_coerce();
    var Comparator = require_comparator();
    var Range = require_range();
    var satisfies = require_satisfies();
    var toComparators = require_to_comparators();
    var maxSatisfying = require_max_satisfying();
    var minSatisfying = require_min_satisfying();
    var minVersion = require_min_version();
    var validRange = require_valid2();
    var outside = require_outside();
    var gtr = require_gtr();
    var ltr = require_ltr();
    var intersects = require_intersects();
    var simplifyRange = require_simplify();
    var subset = require_subset();
    module2.exports = {
      parse,
      valid,
      clean,
      inc,
      diff,
      major,
      minor,
      patch,
      prerelease,
      compare,
      rcompare,
      compareLoose,
      compareBuild,
      sort,
      rsort,
      gt,
      lt,
      eq,
      neq,
      gte,
      lte,
      cmp,
      coerce,
      Comparator,
      Range,
      satisfies,
      toComparators,
      maxSatisfying,
      minSatisfying,
      minVersion,
      validRange,
      outside,
      gtr,
      ltr,
      intersects,
      simplifyRange,
      subset,
      SemVer,
      re: internalRe.re,
      src: internalRe.src,
      tokens: internalRe.t,
      SEMVER_SPEC_VERSION: constants3.SEMVER_SPEC_VERSION,
      RELEASE_TYPES: constants3.RELEASE_TYPES,
      compareIdentifiers: identifiers.compareIdentifiers,
      rcompareIdentifiers: identifiers.rcompareIdentifiers
    };
  }
});

// node_modules/jsonwebtoken/lib/asymmetricKeyDetailsSupported.js
var require_asymmetricKeyDetailsSupported = __commonJS({
  "node_modules/jsonwebtoken/lib/asymmetricKeyDetailsSupported.js"(exports2, module2) {
    var semver = require_semver2();
    module2.exports = semver.satisfies(process.version, ">=15.7.0");
  }
});

// node_modules/jsonwebtoken/lib/rsaPssKeyDetailsSupported.js
var require_rsaPssKeyDetailsSupported = __commonJS({
  "node_modules/jsonwebtoken/lib/rsaPssKeyDetailsSupported.js"(exports2, module2) {
    var semver = require_semver2();
    module2.exports = semver.satisfies(process.version, ">=16.9.0");
  }
});

// node_modules/jsonwebtoken/lib/validateAsymmetricKey.js
var require_validateAsymmetricKey = __commonJS({
  "node_modules/jsonwebtoken/lib/validateAsymmetricKey.js"(exports2, module2) {
    var ASYMMETRIC_KEY_DETAILS_SUPPORTED = require_asymmetricKeyDetailsSupported();
    var RSA_PSS_KEY_DETAILS_SUPPORTED = require_rsaPssKeyDetailsSupported();
    var allowedAlgorithmsForKeys = {
      "ec": ["ES256", "ES384", "ES512"],
      "rsa": ["RS256", "PS256", "RS384", "PS384", "RS512", "PS512"],
      "rsa-pss": ["PS256", "PS384", "PS512"]
    };
    var allowedCurves = {
      ES256: "prime256v1",
      ES384: "secp384r1",
      ES512: "secp521r1"
    };
    module2.exports = function(algorithm, key) {
      if (!algorithm || !key)
        return;
      const keyType = key.asymmetricKeyType;
      if (!keyType)
        return;
      const allowedAlgorithms = allowedAlgorithmsForKeys[keyType];
      if (!allowedAlgorithms) {
        throw new Error(`Unknown key type "${keyType}".`);
      }
      if (!allowedAlgorithms.includes(algorithm)) {
        throw new Error(`"alg" parameter for "${keyType}" key type must be one of: ${allowedAlgorithms.join(", ")}.`);
      }
      if (ASYMMETRIC_KEY_DETAILS_SUPPORTED) {
        switch (keyType) {
          case "ec":
            const keyCurve = key.asymmetricKeyDetails.namedCurve;
            const allowedCurve = allowedCurves[algorithm];
            if (keyCurve !== allowedCurve) {
              throw new Error(`"alg" parameter "${algorithm}" requires curve "${allowedCurve}".`);
            }
            break;
          case "rsa-pss":
            if (RSA_PSS_KEY_DETAILS_SUPPORTED) {
              const length = parseInt(algorithm.slice(-3), 10);
              const { hashAlgorithm, mgf1HashAlgorithm, saltLength } = key.asymmetricKeyDetails;
              if (hashAlgorithm !== `sha${length}` || mgf1HashAlgorithm !== hashAlgorithm) {
                throw new Error(`Invalid key for this operation, its RSA-PSS parameters do not meet the requirements of "alg" ${algorithm}.`);
              }
              if (saltLength !== void 0 && saltLength > length >> 3) {
                throw new Error(`Invalid key for this operation, its RSA-PSS parameter saltLength does not meet the requirements of "alg" ${algorithm}.`);
              }
            }
            break;
        }
      }
    };
  }
});

// node_modules/jsonwebtoken/lib/psSupported.js
var require_psSupported = __commonJS({
  "node_modules/jsonwebtoken/lib/psSupported.js"(exports2, module2) {
    var semver = require_semver2();
    module2.exports = semver.satisfies(process.version, "^6.12.0 || >=8.0.0");
  }
});

// node_modules/jsonwebtoken/verify.js
var require_verify = __commonJS({
  "node_modules/jsonwebtoken/verify.js"(exports2, module2) {
    var JsonWebTokenError = require_JsonWebTokenError();
    var NotBeforeError = require_NotBeforeError();
    var TokenExpiredError = require_TokenExpiredError();
    var decode = require_decode();
    var timespan = require_timespan();
    var validateAsymmetricKey = require_validateAsymmetricKey();
    var PS_SUPPORTED = require_psSupported();
    var jws = require_jws();
    var { KeyObject, createSecretKey, createPublicKey } = require("crypto");
    var PUB_KEY_ALGS = ["RS256", "RS384", "RS512"];
    var EC_KEY_ALGS = ["ES256", "ES384", "ES512"];
    var RSA_KEY_ALGS = ["RS256", "RS384", "RS512"];
    var HS_ALGS = ["HS256", "HS384", "HS512"];
    if (PS_SUPPORTED) {
      PUB_KEY_ALGS.splice(PUB_KEY_ALGS.length, 0, "PS256", "PS384", "PS512");
      RSA_KEY_ALGS.splice(RSA_KEY_ALGS.length, 0, "PS256", "PS384", "PS512");
    }
    module2.exports = function(jwtString, secretOrPublicKey, options, callback) {
      if (typeof options === "function" && !callback) {
        callback = options;
        options = {};
      }
      if (!options) {
        options = {};
      }
      options = Object.assign({}, options);
      let done;
      if (callback) {
        done = callback;
      } else {
        done = function(err, data) {
          if (err)
            throw err;
          return data;
        };
      }
      if (options.clockTimestamp && typeof options.clockTimestamp !== "number") {
        return done(new JsonWebTokenError("clockTimestamp must be a number"));
      }
      if (options.nonce !== void 0 && (typeof options.nonce !== "string" || options.nonce.trim() === "")) {
        return done(new JsonWebTokenError("nonce must be a non-empty string"));
      }
      if (options.allowInvalidAsymmetricKeyTypes !== void 0 && typeof options.allowInvalidAsymmetricKeyTypes !== "boolean") {
        return done(new JsonWebTokenError("allowInvalidAsymmetricKeyTypes must be a boolean"));
      }
      const clockTimestamp = options.clockTimestamp || Math.floor(Date.now() / 1e3);
      if (!jwtString) {
        return done(new JsonWebTokenError("jwt must be provided"));
      }
      if (typeof jwtString !== "string") {
        return done(new JsonWebTokenError("jwt must be a string"));
      }
      const parts = jwtString.split(".");
      if (parts.length !== 3) {
        return done(new JsonWebTokenError("jwt malformed"));
      }
      let decodedToken;
      try {
        decodedToken = decode(jwtString, { complete: true });
      } catch (err) {
        return done(err);
      }
      if (!decodedToken) {
        return done(new JsonWebTokenError("invalid token"));
      }
      const header = decodedToken.header;
      let getSecret;
      if (typeof secretOrPublicKey === "function") {
        if (!callback) {
          return done(new JsonWebTokenError("verify must be called asynchronous if secret or public key is provided as a callback"));
        }
        getSecret = secretOrPublicKey;
      } else {
        getSecret = function(header2, secretCallback) {
          return secretCallback(null, secretOrPublicKey);
        };
      }
      return getSecret(header, function(err, secretOrPublicKey2) {
        if (err) {
          return done(new JsonWebTokenError("error in secret or public key callback: " + err.message));
        }
        const hasSignature = parts[2].trim() !== "";
        if (!hasSignature && secretOrPublicKey2) {
          return done(new JsonWebTokenError("jwt signature is required"));
        }
        if (hasSignature && !secretOrPublicKey2) {
          return done(new JsonWebTokenError("secret or public key must be provided"));
        }
        if (!hasSignature && !options.algorithms) {
          return done(new JsonWebTokenError('please specify "none" in "algorithms" to verify unsigned tokens'));
        }
        if (secretOrPublicKey2 != null && !(secretOrPublicKey2 instanceof KeyObject)) {
          try {
            secretOrPublicKey2 = createPublicKey(secretOrPublicKey2);
          } catch (_) {
            try {
              secretOrPublicKey2 = createSecretKey(typeof secretOrPublicKey2 === "string" ? Buffer.from(secretOrPublicKey2) : secretOrPublicKey2);
            } catch (_2) {
              return done(new JsonWebTokenError("secretOrPublicKey is not valid key material"));
            }
          }
        }
        if (!options.algorithms) {
          if (secretOrPublicKey2.type === "secret") {
            options.algorithms = HS_ALGS;
          } else if (["rsa", "rsa-pss"].includes(secretOrPublicKey2.asymmetricKeyType)) {
            options.algorithms = RSA_KEY_ALGS;
          } else if (secretOrPublicKey2.asymmetricKeyType === "ec") {
            options.algorithms = EC_KEY_ALGS;
          } else {
            options.algorithms = PUB_KEY_ALGS;
          }
        }
        if (options.algorithms.indexOf(decodedToken.header.alg) === -1) {
          return done(new JsonWebTokenError("invalid algorithm"));
        }
        if (header.alg.startsWith("HS") && secretOrPublicKey2.type !== "secret") {
          return done(new JsonWebTokenError(`secretOrPublicKey must be a symmetric key when using ${header.alg}`));
        } else if (/^(?:RS|PS|ES)/.test(header.alg) && secretOrPublicKey2.type !== "public") {
          return done(new JsonWebTokenError(`secretOrPublicKey must be an asymmetric key when using ${header.alg}`));
        }
        if (!options.allowInvalidAsymmetricKeyTypes) {
          try {
            validateAsymmetricKey(header.alg, secretOrPublicKey2);
          } catch (e) {
            return done(e);
          }
        }
        let valid;
        try {
          valid = jws.verify(jwtString, decodedToken.header.alg, secretOrPublicKey2);
        } catch (e) {
          return done(e);
        }
        if (!valid) {
          return done(new JsonWebTokenError("invalid signature"));
        }
        const payload = decodedToken.payload;
        if (typeof payload.nbf !== "undefined" && !options.ignoreNotBefore) {
          if (typeof payload.nbf !== "number") {
            return done(new JsonWebTokenError("invalid nbf value"));
          }
          if (payload.nbf > clockTimestamp + (options.clockTolerance || 0)) {
            return done(new NotBeforeError("jwt not active", new Date(payload.nbf * 1e3)));
          }
        }
        if (typeof payload.exp !== "undefined" && !options.ignoreExpiration) {
          if (typeof payload.exp !== "number") {
            return done(new JsonWebTokenError("invalid exp value"));
          }
          if (clockTimestamp >= payload.exp + (options.clockTolerance || 0)) {
            return done(new TokenExpiredError("jwt expired", new Date(payload.exp * 1e3)));
          }
        }
        if (options.audience) {
          const audiences = Array.isArray(options.audience) ? options.audience : [options.audience];
          const target = Array.isArray(payload.aud) ? payload.aud : [payload.aud];
          const match = target.some(function(targetAudience) {
            return audiences.some(function(audience) {
              return audience instanceof RegExp ? audience.test(targetAudience) : audience === targetAudience;
            });
          });
          if (!match) {
            return done(new JsonWebTokenError("jwt audience invalid. expected: " + audiences.join(" or ")));
          }
        }
        if (options.issuer) {
          const invalid_issuer = typeof options.issuer === "string" && payload.iss !== options.issuer || Array.isArray(options.issuer) && options.issuer.indexOf(payload.iss) === -1;
          if (invalid_issuer) {
            return done(new JsonWebTokenError("jwt issuer invalid. expected: " + options.issuer));
          }
        }
        if (options.subject) {
          if (payload.sub !== options.subject) {
            return done(new JsonWebTokenError("jwt subject invalid. expected: " + options.subject));
          }
        }
        if (options.jwtid) {
          if (payload.jti !== options.jwtid) {
            return done(new JsonWebTokenError("jwt jwtid invalid. expected: " + options.jwtid));
          }
        }
        if (options.nonce) {
          if (payload.nonce !== options.nonce) {
            return done(new JsonWebTokenError("jwt nonce invalid. expected: " + options.nonce));
          }
        }
        if (options.maxAge) {
          if (typeof payload.iat !== "number") {
            return done(new JsonWebTokenError("iat required when maxAge is specified"));
          }
          const maxAgeTimestamp = timespan(options.maxAge, payload.iat);
          if (typeof maxAgeTimestamp === "undefined") {
            return done(new JsonWebTokenError('"maxAge" should be a number of seconds or string representing a timespan eg: "1d", "20h", 60'));
          }
          if (clockTimestamp >= maxAgeTimestamp + (options.clockTolerance || 0)) {
            return done(new TokenExpiredError("maxAge exceeded", new Date(maxAgeTimestamp * 1e3)));
          }
        }
        if (options.complete === true) {
          const signature = decodedToken.signature;
          return done(null, {
            header,
            payload,
            signature
          });
        }
        return done(null, payload);
      });
    };
  }
});

// node_modules/lodash.includes/index.js
var require_lodash = __commonJS({
  "node_modules/lodash.includes/index.js"(exports2, module2) {
    var INFINITY = 1 / 0;
    var MAX_SAFE_INTEGER = 9007199254740991;
    var MAX_INTEGER = 17976931348623157e292;
    var NAN = 0 / 0;
    var argsTag = "[object Arguments]";
    var funcTag = "[object Function]";
    var genTag = "[object GeneratorFunction]";
    var stringTag = "[object String]";
    var symbolTag = "[object Symbol]";
    var reTrim = /^\s+|\s+$/g;
    var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
    var reIsBinary = /^0b[01]+$/i;
    var reIsOctal = /^0o[0-7]+$/i;
    var reIsUint = /^(?:0|[1-9]\d*)$/;
    var freeParseInt = parseInt;
    function arrayMap(array, iteratee) {
      var index = -1, length = array ? array.length : 0, result = Array(length);
      while (++index < length) {
        result[index] = iteratee(array[index], index, array);
      }
      return result;
    }
    function baseFindIndex(array, predicate, fromIndex, fromRight) {
      var length = array.length, index = fromIndex + (fromRight ? 1 : -1);
      while (fromRight ? index-- : ++index < length) {
        if (predicate(array[index], index, array)) {
          return index;
        }
      }
      return -1;
    }
    function baseIndexOf(array, value, fromIndex) {
      if (value !== value) {
        return baseFindIndex(array, baseIsNaN, fromIndex);
      }
      var index = fromIndex - 1, length = array.length;
      while (++index < length) {
        if (array[index] === value) {
          return index;
        }
      }
      return -1;
    }
    function baseIsNaN(value) {
      return value !== value;
    }
    function baseTimes(n, iteratee) {
      var index = -1, result = Array(n);
      while (++index < n) {
        result[index] = iteratee(index);
      }
      return result;
    }
    function baseValues(object, props) {
      return arrayMap(props, function(key) {
        return object[key];
      });
    }
    function overArg(func, transform) {
      return function(arg) {
        return func(transform(arg));
      };
    }
    var objectProto = Object.prototype;
    var hasOwnProperty = objectProto.hasOwnProperty;
    var objectToString = objectProto.toString;
    var propertyIsEnumerable = objectProto.propertyIsEnumerable;
    var nativeKeys = overArg(Object.keys, Object);
    var nativeMax = Math.max;
    function arrayLikeKeys(value, inherited) {
      var result = isArray(value) || isArguments(value) ? baseTimes(value.length, String) : [];
      var length = result.length, skipIndexes = !!length;
      for (var key in value) {
        if ((inherited || hasOwnProperty.call(value, key)) && !(skipIndexes && (key == "length" || isIndex(key, length)))) {
          result.push(key);
        }
      }
      return result;
    }
    function baseKeys(object) {
      if (!isPrototype(object)) {
        return nativeKeys(object);
      }
      var result = [];
      for (var key in Object(object)) {
        if (hasOwnProperty.call(object, key) && key != "constructor") {
          result.push(key);
        }
      }
      return result;
    }
    function isIndex(value, length) {
      length = length == null ? MAX_SAFE_INTEGER : length;
      return !!length && (typeof value == "number" || reIsUint.test(value)) && (value > -1 && value % 1 == 0 && value < length);
    }
    function isPrototype(value) {
      var Ctor = value && value.constructor, proto = typeof Ctor == "function" && Ctor.prototype || objectProto;
      return value === proto;
    }
    function includes(collection, value, fromIndex, guard) {
      collection = isArrayLike(collection) ? collection : values(collection);
      fromIndex = fromIndex && !guard ? toInteger(fromIndex) : 0;
      var length = collection.length;
      if (fromIndex < 0) {
        fromIndex = nativeMax(length + fromIndex, 0);
      }
      return isString(collection) ? fromIndex <= length && collection.indexOf(value, fromIndex) > -1 : !!length && baseIndexOf(collection, value, fromIndex) > -1;
    }
    function isArguments(value) {
      return isArrayLikeObject(value) && hasOwnProperty.call(value, "callee") && (!propertyIsEnumerable.call(value, "callee") || objectToString.call(value) == argsTag);
    }
    var isArray = Array.isArray;
    function isArrayLike(value) {
      return value != null && isLength(value.length) && !isFunction(value);
    }
    function isArrayLikeObject(value) {
      return isObjectLike(value) && isArrayLike(value);
    }
    function isFunction(value) {
      var tag = isObject(value) ? objectToString.call(value) : "";
      return tag == funcTag || tag == genTag;
    }
    function isLength(value) {
      return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
    }
    function isObject(value) {
      var type = typeof value;
      return !!value && (type == "object" || type == "function");
    }
    function isObjectLike(value) {
      return !!value && typeof value == "object";
    }
    function isString(value) {
      return typeof value == "string" || !isArray(value) && isObjectLike(value) && objectToString.call(value) == stringTag;
    }
    function isSymbol(value) {
      return typeof value == "symbol" || isObjectLike(value) && objectToString.call(value) == symbolTag;
    }
    function toFinite(value) {
      if (!value) {
        return value === 0 ? value : 0;
      }
      value = toNumber(value);
      if (value === INFINITY || value === -INFINITY) {
        var sign = value < 0 ? -1 : 1;
        return sign * MAX_INTEGER;
      }
      return value === value ? value : 0;
    }
    function toInteger(value) {
      var result = toFinite(value), remainder = result % 1;
      return result === result ? remainder ? result - remainder : result : 0;
    }
    function toNumber(value) {
      if (typeof value == "number") {
        return value;
      }
      if (isSymbol(value)) {
        return NAN;
      }
      if (isObject(value)) {
        var other = typeof value.valueOf == "function" ? value.valueOf() : value;
        value = isObject(other) ? other + "" : other;
      }
      if (typeof value != "string") {
        return value === 0 ? value : +value;
      }
      value = value.replace(reTrim, "");
      var isBinary = reIsBinary.test(value);
      return isBinary || reIsOctal.test(value) ? freeParseInt(value.slice(2), isBinary ? 2 : 8) : reIsBadHex.test(value) ? NAN : +value;
    }
    function keys(object) {
      return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);
    }
    function values(object) {
      return object ? baseValues(object, keys(object)) : [];
    }
    module2.exports = includes;
  }
});

// node_modules/lodash.isboolean/index.js
var require_lodash2 = __commonJS({
  "node_modules/lodash.isboolean/index.js"(exports2, module2) {
    var boolTag = "[object Boolean]";
    var objectProto = Object.prototype;
    var objectToString = objectProto.toString;
    function isBoolean(value) {
      return value === true || value === false || isObjectLike(value) && objectToString.call(value) == boolTag;
    }
    function isObjectLike(value) {
      return !!value && typeof value == "object";
    }
    module2.exports = isBoolean;
  }
});

// node_modules/lodash.isinteger/index.js
var require_lodash3 = __commonJS({
  "node_modules/lodash.isinteger/index.js"(exports2, module2) {
    var INFINITY = 1 / 0;
    var MAX_INTEGER = 17976931348623157e292;
    var NAN = 0 / 0;
    var symbolTag = "[object Symbol]";
    var reTrim = /^\s+|\s+$/g;
    var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
    var reIsBinary = /^0b[01]+$/i;
    var reIsOctal = /^0o[0-7]+$/i;
    var freeParseInt = parseInt;
    var objectProto = Object.prototype;
    var objectToString = objectProto.toString;
    function isInteger(value) {
      return typeof value == "number" && value == toInteger(value);
    }
    function isObject(value) {
      var type = typeof value;
      return !!value && (type == "object" || type == "function");
    }
    function isObjectLike(value) {
      return !!value && typeof value == "object";
    }
    function isSymbol(value) {
      return typeof value == "symbol" || isObjectLike(value) && objectToString.call(value) == symbolTag;
    }
    function toFinite(value) {
      if (!value) {
        return value === 0 ? value : 0;
      }
      value = toNumber(value);
      if (value === INFINITY || value === -INFINITY) {
        var sign = value < 0 ? -1 : 1;
        return sign * MAX_INTEGER;
      }
      return value === value ? value : 0;
    }
    function toInteger(value) {
      var result = toFinite(value), remainder = result % 1;
      return result === result ? remainder ? result - remainder : result : 0;
    }
    function toNumber(value) {
      if (typeof value == "number") {
        return value;
      }
      if (isSymbol(value)) {
        return NAN;
      }
      if (isObject(value)) {
        var other = typeof value.valueOf == "function" ? value.valueOf() : value;
        value = isObject(other) ? other + "" : other;
      }
      if (typeof value != "string") {
        return value === 0 ? value : +value;
      }
      value = value.replace(reTrim, "");
      var isBinary = reIsBinary.test(value);
      return isBinary || reIsOctal.test(value) ? freeParseInt(value.slice(2), isBinary ? 2 : 8) : reIsBadHex.test(value) ? NAN : +value;
    }
    module2.exports = isInteger;
  }
});

// node_modules/lodash.isnumber/index.js
var require_lodash4 = __commonJS({
  "node_modules/lodash.isnumber/index.js"(exports2, module2) {
    var numberTag = "[object Number]";
    var objectProto = Object.prototype;
    var objectToString = objectProto.toString;
    function isObjectLike(value) {
      return !!value && typeof value == "object";
    }
    function isNumber(value) {
      return typeof value == "number" || isObjectLike(value) && objectToString.call(value) == numberTag;
    }
    module2.exports = isNumber;
  }
});

// node_modules/lodash.isplainobject/index.js
var require_lodash5 = __commonJS({
  "node_modules/lodash.isplainobject/index.js"(exports2, module2) {
    var objectTag = "[object Object]";
    function isHostObject(value) {
      var result = false;
      if (value != null && typeof value.toString != "function") {
        try {
          result = !!(value + "");
        } catch (e) {
        }
      }
      return result;
    }
    function overArg(func, transform) {
      return function(arg) {
        return func(transform(arg));
      };
    }
    var funcProto = Function.prototype;
    var objectProto = Object.prototype;
    var funcToString = funcProto.toString;
    var hasOwnProperty = objectProto.hasOwnProperty;
    var objectCtorString = funcToString.call(Object);
    var objectToString = objectProto.toString;
    var getPrototype = overArg(Object.getPrototypeOf, Object);
    function isObjectLike(value) {
      return !!value && typeof value == "object";
    }
    function isPlainObject(value) {
      if (!isObjectLike(value) || objectToString.call(value) != objectTag || isHostObject(value)) {
        return false;
      }
      var proto = getPrototype(value);
      if (proto === null) {
        return true;
      }
      var Ctor = hasOwnProperty.call(proto, "constructor") && proto.constructor;
      return typeof Ctor == "function" && Ctor instanceof Ctor && funcToString.call(Ctor) == objectCtorString;
    }
    module2.exports = isPlainObject;
  }
});

// node_modules/lodash.isstring/index.js
var require_lodash6 = __commonJS({
  "node_modules/lodash.isstring/index.js"(exports2, module2) {
    var stringTag = "[object String]";
    var objectProto = Object.prototype;
    var objectToString = objectProto.toString;
    var isArray = Array.isArray;
    function isObjectLike(value) {
      return !!value && typeof value == "object";
    }
    function isString(value) {
      return typeof value == "string" || !isArray(value) && isObjectLike(value) && objectToString.call(value) == stringTag;
    }
    module2.exports = isString;
  }
});

// node_modules/lodash.once/index.js
var require_lodash7 = __commonJS({
  "node_modules/lodash.once/index.js"(exports2, module2) {
    var FUNC_ERROR_TEXT = "Expected a function";
    var INFINITY = 1 / 0;
    var MAX_INTEGER = 17976931348623157e292;
    var NAN = 0 / 0;
    var symbolTag = "[object Symbol]";
    var reTrim = /^\s+|\s+$/g;
    var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
    var reIsBinary = /^0b[01]+$/i;
    var reIsOctal = /^0o[0-7]+$/i;
    var freeParseInt = parseInt;
    var objectProto = Object.prototype;
    var objectToString = objectProto.toString;
    function before(n, func) {
      var result;
      if (typeof func != "function") {
        throw new TypeError(FUNC_ERROR_TEXT);
      }
      n = toInteger(n);
      return function() {
        if (--n > 0) {
          result = func.apply(this, arguments);
        }
        if (n <= 1) {
          func = void 0;
        }
        return result;
      };
    }
    function once(func) {
      return before(2, func);
    }
    function isObject(value) {
      var type = typeof value;
      return !!value && (type == "object" || type == "function");
    }
    function isObjectLike(value) {
      return !!value && typeof value == "object";
    }
    function isSymbol(value) {
      return typeof value == "symbol" || isObjectLike(value) && objectToString.call(value) == symbolTag;
    }
    function toFinite(value) {
      if (!value) {
        return value === 0 ? value : 0;
      }
      value = toNumber(value);
      if (value === INFINITY || value === -INFINITY) {
        var sign = value < 0 ? -1 : 1;
        return sign * MAX_INTEGER;
      }
      return value === value ? value : 0;
    }
    function toInteger(value) {
      var result = toFinite(value), remainder = result % 1;
      return result === result ? remainder ? result - remainder : result : 0;
    }
    function toNumber(value) {
      if (typeof value == "number") {
        return value;
      }
      if (isSymbol(value)) {
        return NAN;
      }
      if (isObject(value)) {
        var other = typeof value.valueOf == "function" ? value.valueOf() : value;
        value = isObject(other) ? other + "" : other;
      }
      if (typeof value != "string") {
        return value === 0 ? value : +value;
      }
      value = value.replace(reTrim, "");
      var isBinary = reIsBinary.test(value);
      return isBinary || reIsOctal.test(value) ? freeParseInt(value.slice(2), isBinary ? 2 : 8) : reIsBadHex.test(value) ? NAN : +value;
    }
    module2.exports = once;
  }
});

// node_modules/jsonwebtoken/sign.js
var require_sign = __commonJS({
  "node_modules/jsonwebtoken/sign.js"(exports2, module2) {
    var timespan = require_timespan();
    var PS_SUPPORTED = require_psSupported();
    var validateAsymmetricKey = require_validateAsymmetricKey();
    var jws = require_jws();
    var includes = require_lodash();
    var isBoolean = require_lodash2();
    var isInteger = require_lodash3();
    var isNumber = require_lodash4();
    var isPlainObject = require_lodash5();
    var isString = require_lodash6();
    var once = require_lodash7();
    var { KeyObject, createSecretKey, createPrivateKey } = require("crypto");
    var SUPPORTED_ALGS = ["RS256", "RS384", "RS512", "ES256", "ES384", "ES512", "HS256", "HS384", "HS512", "none"];
    if (PS_SUPPORTED) {
      SUPPORTED_ALGS.splice(3, 0, "PS256", "PS384", "PS512");
    }
    var sign_options_schema = {
      expiresIn: { isValid: function(value) {
        return isInteger(value) || isString(value) && value;
      }, message: '"expiresIn" should be a number of seconds or string representing a timespan' },
      notBefore: { isValid: function(value) {
        return isInteger(value) || isString(value) && value;
      }, message: '"notBefore" should be a number of seconds or string representing a timespan' },
      audience: { isValid: function(value) {
        return isString(value) || Array.isArray(value);
      }, message: '"audience" must be a string or array' },
      algorithm: { isValid: includes.bind(null, SUPPORTED_ALGS), message: '"algorithm" must be a valid string enum value' },
      header: { isValid: isPlainObject, message: '"header" must be an object' },
      encoding: { isValid: isString, message: '"encoding" must be a string' },
      issuer: { isValid: isString, message: '"issuer" must be a string' },
      subject: { isValid: isString, message: '"subject" must be a string' },
      jwtid: { isValid: isString, message: '"jwtid" must be a string' },
      noTimestamp: { isValid: isBoolean, message: '"noTimestamp" must be a boolean' },
      keyid: { isValid: isString, message: '"keyid" must be a string' },
      mutatePayload: { isValid: isBoolean, message: '"mutatePayload" must be a boolean' },
      allowInsecureKeySizes: { isValid: isBoolean, message: '"allowInsecureKeySizes" must be a boolean' },
      allowInvalidAsymmetricKeyTypes: { isValid: isBoolean, message: '"allowInvalidAsymmetricKeyTypes" must be a boolean' }
    };
    var registered_claims_schema = {
      iat: { isValid: isNumber, message: '"iat" should be a number of seconds' },
      exp: { isValid: isNumber, message: '"exp" should be a number of seconds' },
      nbf: { isValid: isNumber, message: '"nbf" should be a number of seconds' }
    };
    function validate(schema, allowUnknown, object, parameterName) {
      if (!isPlainObject(object)) {
        throw new Error('Expected "' + parameterName + '" to be a plain object.');
      }
      Object.keys(object).forEach(function(key) {
        const validator = schema[key];
        if (!validator) {
          if (!allowUnknown) {
            throw new Error('"' + key + '" is not allowed in "' + parameterName + '"');
          }
          return;
        }
        if (!validator.isValid(object[key])) {
          throw new Error(validator.message);
        }
      });
    }
    function validateOptions(options) {
      return validate(sign_options_schema, false, options, "options");
    }
    function validatePayload(payload) {
      return validate(registered_claims_schema, true, payload, "payload");
    }
    var options_to_payload = {
      "audience": "aud",
      "issuer": "iss",
      "subject": "sub",
      "jwtid": "jti"
    };
    var options_for_objects = [
      "expiresIn",
      "notBefore",
      "noTimestamp",
      "audience",
      "issuer",
      "subject",
      "jwtid"
    ];
    module2.exports = function(payload, secretOrPrivateKey, options, callback) {
      if (typeof options === "function") {
        callback = options;
        options = {};
      } else {
        options = options || {};
      }
      const isObjectPayload = typeof payload === "object" && !Buffer.isBuffer(payload);
      const header = Object.assign({
        alg: options.algorithm || "HS256",
        typ: isObjectPayload ? "JWT" : void 0,
        kid: options.keyid
      }, options.header);
      function failure(err) {
        if (callback) {
          return callback(err);
        }
        throw err;
      }
      if (!secretOrPrivateKey && options.algorithm !== "none") {
        return failure(new Error("secretOrPrivateKey must have a value"));
      }
      if (secretOrPrivateKey != null && !(secretOrPrivateKey instanceof KeyObject)) {
        try {
          secretOrPrivateKey = createPrivateKey(secretOrPrivateKey);
        } catch (_) {
          try {
            secretOrPrivateKey = createSecretKey(typeof secretOrPrivateKey === "string" ? Buffer.from(secretOrPrivateKey) : secretOrPrivateKey);
          } catch (_2) {
            return failure(new Error("secretOrPrivateKey is not valid key material"));
          }
        }
      }
      if (header.alg.startsWith("HS") && secretOrPrivateKey.type !== "secret") {
        return failure(new Error(`secretOrPrivateKey must be a symmetric key when using ${header.alg}`));
      } else if (/^(?:RS|PS|ES)/.test(header.alg)) {
        if (secretOrPrivateKey.type !== "private") {
          return failure(new Error(`secretOrPrivateKey must be an asymmetric key when using ${header.alg}`));
        }
        if (!options.allowInsecureKeySizes && !header.alg.startsWith("ES") && secretOrPrivateKey.asymmetricKeyDetails !== void 0 && secretOrPrivateKey.asymmetricKeyDetails.modulusLength < 2048) {
          return failure(new Error(`secretOrPrivateKey has a minimum key size of 2048 bits for ${header.alg}`));
        }
      }
      if (typeof payload === "undefined") {
        return failure(new Error("payload is required"));
      } else if (isObjectPayload) {
        try {
          validatePayload(payload);
        } catch (error) {
          return failure(error);
        }
        if (!options.mutatePayload) {
          payload = Object.assign({}, payload);
        }
      } else {
        const invalid_options = options_for_objects.filter(function(opt) {
          return typeof options[opt] !== "undefined";
        });
        if (invalid_options.length > 0) {
          return failure(new Error("invalid " + invalid_options.join(",") + " option for " + typeof payload + " payload"));
        }
      }
      if (typeof payload.exp !== "undefined" && typeof options.expiresIn !== "undefined") {
        return failure(new Error('Bad "options.expiresIn" option the payload already has an "exp" property.'));
      }
      if (typeof payload.nbf !== "undefined" && typeof options.notBefore !== "undefined") {
        return failure(new Error('Bad "options.notBefore" option the payload already has an "nbf" property.'));
      }
      try {
        validateOptions(options);
      } catch (error) {
        return failure(error);
      }
      if (!options.allowInvalidAsymmetricKeyTypes) {
        try {
          validateAsymmetricKey(header.alg, secretOrPrivateKey);
        } catch (error) {
          return failure(error);
        }
      }
      const timestamp = payload.iat || Math.floor(Date.now() / 1e3);
      if (options.noTimestamp) {
        delete payload.iat;
      } else if (isObjectPayload) {
        payload.iat = timestamp;
      }
      if (typeof options.notBefore !== "undefined") {
        try {
          payload.nbf = timespan(options.notBefore, timestamp);
        } catch (err) {
          return failure(err);
        }
        if (typeof payload.nbf === "undefined") {
          return failure(new Error('"notBefore" should be a number of seconds or string representing a timespan eg: "1d", "20h", 60'));
        }
      }
      if (typeof options.expiresIn !== "undefined" && typeof payload === "object") {
        try {
          payload.exp = timespan(options.expiresIn, timestamp);
        } catch (err) {
          return failure(err);
        }
        if (typeof payload.exp === "undefined") {
          return failure(new Error('"expiresIn" should be a number of seconds or string representing a timespan eg: "1d", "20h", 60'));
        }
      }
      Object.keys(options_to_payload).forEach(function(key) {
        const claim = options_to_payload[key];
        if (typeof options[key] !== "undefined") {
          if (typeof payload[claim] !== "undefined") {
            return failure(new Error('Bad "options.' + key + '" option. The payload already has an "' + claim + '" property.'));
          }
          payload[claim] = options[key];
        }
      });
      const encoding = options.encoding || "utf8";
      if (typeof callback === "function") {
        callback = callback && once(callback);
        jws.createSign({
          header,
          privateKey: secretOrPrivateKey,
          payload,
          encoding
        }).once("error", callback).once("done", function(signature) {
          if (!options.allowInsecureKeySizes && /^(?:RS|PS)/.test(header.alg) && signature.length < 256) {
            return callback(new Error(`secretOrPrivateKey has a minimum key size of 2048 bits for ${header.alg}`));
          }
          callback(null, signature);
        });
      } else {
        let signature = jws.sign({ header, payload, secret: secretOrPrivateKey, encoding });
        if (!options.allowInsecureKeySizes && /^(?:RS|PS)/.test(header.alg) && signature.length < 256) {
          throw new Error(`secretOrPrivateKey has a minimum key size of 2048 bits for ${header.alg}`);
        }
        return signature;
      }
    };
  }
});

// node_modules/jsonwebtoken/index.js
var require_jsonwebtoken = __commonJS({
  "node_modules/jsonwebtoken/index.js"(exports2, module2) {
    module2.exports = {
      decode: require_decode(),
      verify: require_verify(),
      sign: require_sign(),
      JsonWebTokenError: require_JsonWebTokenError(),
      NotBeforeError: require_NotBeforeError(),
      TokenExpiredError: require_TokenExpiredError()
    };
  }
});

// out/util/projectConfigDefault.js
var require_projectConfigDefault = __commonJS({
  "out/util/projectConfigDefault.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.projectConfigDefault = void 0;
    exports2.projectConfigDefault = {
      path: {
        root: "@=src",
        api: "src/api",
        request: "../utils/request"
      },
      api: [],
      component: {
        scope: ["src/components", "src/views"]
      }
    };
  }
});

// node_modules/js-beautify/js/src/core/output.js
var require_output = __commonJS({
  "node_modules/js-beautify/js/src/core/output.js"(exports2, module2) {
    "use strict";
    function OutputLine(parent) {
      this.__parent = parent;
      this.__character_count = 0;
      this.__indent_count = -1;
      this.__alignment_count = 0;
      this.__wrap_point_index = 0;
      this.__wrap_point_character_count = 0;
      this.__wrap_point_indent_count = -1;
      this.__wrap_point_alignment_count = 0;
      this.__items = [];
    }
    OutputLine.prototype.clone_empty = function() {
      var line = new OutputLine(this.__parent);
      line.set_indent(this.__indent_count, this.__alignment_count);
      return line;
    };
    OutputLine.prototype.item = function(index) {
      if (index < 0) {
        return this.__items[this.__items.length + index];
      } else {
        return this.__items[index];
      }
    };
    OutputLine.prototype.has_match = function(pattern) {
      for (var lastCheckedOutput = this.__items.length - 1; lastCheckedOutput >= 0; lastCheckedOutput--) {
        if (this.__items[lastCheckedOutput].match(pattern)) {
          return true;
        }
      }
      return false;
    };
    OutputLine.prototype.set_indent = function(indent, alignment) {
      if (this.is_empty()) {
        this.__indent_count = indent || 0;
        this.__alignment_count = alignment || 0;
        this.__character_count = this.__parent.get_indent_size(this.__indent_count, this.__alignment_count);
      }
    };
    OutputLine.prototype._set_wrap_point = function() {
      if (this.__parent.wrap_line_length) {
        this.__wrap_point_index = this.__items.length;
        this.__wrap_point_character_count = this.__character_count;
        this.__wrap_point_indent_count = this.__parent.next_line.__indent_count;
        this.__wrap_point_alignment_count = this.__parent.next_line.__alignment_count;
      }
    };
    OutputLine.prototype._should_wrap = function() {
      return this.__wrap_point_index && this.__character_count > this.__parent.wrap_line_length && this.__wrap_point_character_count > this.__parent.next_line.__character_count;
    };
    OutputLine.prototype._allow_wrap = function() {
      if (this._should_wrap()) {
        this.__parent.add_new_line();
        var next = this.__parent.current_line;
        next.set_indent(this.__wrap_point_indent_count, this.__wrap_point_alignment_count);
        next.__items = this.__items.slice(this.__wrap_point_index);
        this.__items = this.__items.slice(0, this.__wrap_point_index);
        next.__character_count += this.__character_count - this.__wrap_point_character_count;
        this.__character_count = this.__wrap_point_character_count;
        if (next.__items[0] === " ") {
          next.__items.splice(0, 1);
          next.__character_count -= 1;
        }
        return true;
      }
      return false;
    };
    OutputLine.prototype.is_empty = function() {
      return this.__items.length === 0;
    };
    OutputLine.prototype.last = function() {
      if (!this.is_empty()) {
        return this.__items[this.__items.length - 1];
      } else {
        return null;
      }
    };
    OutputLine.prototype.push = function(item) {
      this.__items.push(item);
      var last_newline_index = item.lastIndexOf("\n");
      if (last_newline_index !== -1) {
        this.__character_count = item.length - last_newline_index;
      } else {
        this.__character_count += item.length;
      }
    };
    OutputLine.prototype.pop = function() {
      var item = null;
      if (!this.is_empty()) {
        item = this.__items.pop();
        this.__character_count -= item.length;
      }
      return item;
    };
    OutputLine.prototype._remove_indent = function() {
      if (this.__indent_count > 0) {
        this.__indent_count -= 1;
        this.__character_count -= this.__parent.indent_size;
      }
    };
    OutputLine.prototype._remove_wrap_indent = function() {
      if (this.__wrap_point_indent_count > 0) {
        this.__wrap_point_indent_count -= 1;
      }
    };
    OutputLine.prototype.trim = function() {
      while (this.last() === " ") {
        this.__items.pop();
        this.__character_count -= 1;
      }
    };
    OutputLine.prototype.toString = function() {
      var result = "";
      if (this.is_empty()) {
        if (this.__parent.indent_empty_lines) {
          result = this.__parent.get_indent_string(this.__indent_count);
        }
      } else {
        result = this.__parent.get_indent_string(this.__indent_count, this.__alignment_count);
        result += this.__items.join("");
      }
      return result;
    };
    function IndentStringCache(options, baseIndentString) {
      this.__cache = [""];
      this.__indent_size = options.indent_size;
      this.__indent_string = options.indent_char;
      if (!options.indent_with_tabs) {
        this.__indent_string = new Array(options.indent_size + 1).join(options.indent_char);
      }
      baseIndentString = baseIndentString || "";
      if (options.indent_level > 0) {
        baseIndentString = new Array(options.indent_level + 1).join(this.__indent_string);
      }
      this.__base_string = baseIndentString;
      this.__base_string_length = baseIndentString.length;
    }
    IndentStringCache.prototype.get_indent_size = function(indent, column) {
      var result = this.__base_string_length;
      column = column || 0;
      if (indent < 0) {
        result = 0;
      }
      result += indent * this.__indent_size;
      result += column;
      return result;
    };
    IndentStringCache.prototype.get_indent_string = function(indent_level, column) {
      var result = this.__base_string;
      column = column || 0;
      if (indent_level < 0) {
        indent_level = 0;
        result = "";
      }
      column += indent_level * this.__indent_size;
      this.__ensure_cache(column);
      result += this.__cache[column];
      return result;
    };
    IndentStringCache.prototype.__ensure_cache = function(column) {
      while (column >= this.__cache.length) {
        this.__add_column();
      }
    };
    IndentStringCache.prototype.__add_column = function() {
      var column = this.__cache.length;
      var indent = 0;
      var result = "";
      if (this.__indent_size && column >= this.__indent_size) {
        indent = Math.floor(column / this.__indent_size);
        column -= indent * this.__indent_size;
        result = new Array(indent + 1).join(this.__indent_string);
      }
      if (column) {
        result += new Array(column + 1).join(" ");
      }
      this.__cache.push(result);
    };
    function Output(options, baseIndentString) {
      this.__indent_cache = new IndentStringCache(options, baseIndentString);
      this.raw = false;
      this._end_with_newline = options.end_with_newline;
      this.indent_size = options.indent_size;
      this.wrap_line_length = options.wrap_line_length;
      this.indent_empty_lines = options.indent_empty_lines;
      this.__lines = [];
      this.previous_line = null;
      this.current_line = null;
      this.next_line = new OutputLine(this);
      this.space_before_token = false;
      this.non_breaking_space = false;
      this.previous_token_wrapped = false;
      this.__add_outputline();
    }
    Output.prototype.__add_outputline = function() {
      this.previous_line = this.current_line;
      this.current_line = this.next_line.clone_empty();
      this.__lines.push(this.current_line);
    };
    Output.prototype.get_line_number = function() {
      return this.__lines.length;
    };
    Output.prototype.get_indent_string = function(indent, column) {
      return this.__indent_cache.get_indent_string(indent, column);
    };
    Output.prototype.get_indent_size = function(indent, column) {
      return this.__indent_cache.get_indent_size(indent, column);
    };
    Output.prototype.is_empty = function() {
      return !this.previous_line && this.current_line.is_empty();
    };
    Output.prototype.add_new_line = function(force_newline) {
      if (this.is_empty() || !force_newline && this.just_added_newline()) {
        return false;
      }
      if (!this.raw) {
        this.__add_outputline();
      }
      return true;
    };
    Output.prototype.get_code = function(eol) {
      this.trim(true);
      var last_item = this.current_line.pop();
      if (last_item) {
        if (last_item[last_item.length - 1] === "\n") {
          last_item = last_item.replace(/\n+$/g, "");
        }
        this.current_line.push(last_item);
      }
      if (this._end_with_newline) {
        this.__add_outputline();
      }
      var sweet_code = this.__lines.join("\n");
      if (eol !== "\n") {
        sweet_code = sweet_code.replace(/[\n]/g, eol);
      }
      return sweet_code;
    };
    Output.prototype.set_wrap_point = function() {
      this.current_line._set_wrap_point();
    };
    Output.prototype.set_indent = function(indent, alignment) {
      indent = indent || 0;
      alignment = alignment || 0;
      this.next_line.set_indent(indent, alignment);
      if (this.__lines.length > 1) {
        this.current_line.set_indent(indent, alignment);
        return true;
      }
      this.current_line.set_indent();
      return false;
    };
    Output.prototype.add_raw_token = function(token) {
      for (var x = 0; x < token.newlines; x++) {
        this.__add_outputline();
      }
      this.current_line.set_indent(-1);
      this.current_line.push(token.whitespace_before);
      this.current_line.push(token.text);
      this.space_before_token = false;
      this.non_breaking_space = false;
      this.previous_token_wrapped = false;
    };
    Output.prototype.add_token = function(printable_token) {
      this.__add_space_before_token();
      this.current_line.push(printable_token);
      this.space_before_token = false;
      this.non_breaking_space = false;
      this.previous_token_wrapped = this.current_line._allow_wrap();
    };
    Output.prototype.__add_space_before_token = function() {
      if (this.space_before_token && !this.just_added_newline()) {
        if (!this.non_breaking_space) {
          this.set_wrap_point();
        }
        this.current_line.push(" ");
      }
    };
    Output.prototype.remove_indent = function(index) {
      var output_length = this.__lines.length;
      while (index < output_length) {
        this.__lines[index]._remove_indent();
        index++;
      }
      this.current_line._remove_wrap_indent();
    };
    Output.prototype.trim = function(eat_newlines) {
      eat_newlines = eat_newlines === void 0 ? false : eat_newlines;
      this.current_line.trim();
      while (eat_newlines && this.__lines.length > 1 && this.current_line.is_empty()) {
        this.__lines.pop();
        this.current_line = this.__lines[this.__lines.length - 1];
        this.current_line.trim();
      }
      this.previous_line = this.__lines.length > 1 ? this.__lines[this.__lines.length - 2] : null;
    };
    Output.prototype.just_added_newline = function() {
      return this.current_line.is_empty();
    };
    Output.prototype.just_added_blankline = function() {
      return this.is_empty() || this.current_line.is_empty() && this.previous_line.is_empty();
    };
    Output.prototype.ensure_empty_line_above = function(starts_with, ends_with) {
      var index = this.__lines.length - 2;
      while (index >= 0) {
        var potentialEmptyLine = this.__lines[index];
        if (potentialEmptyLine.is_empty()) {
          break;
        } else if (potentialEmptyLine.item(0).indexOf(starts_with) !== 0 && potentialEmptyLine.item(-1) !== ends_with) {
          this.__lines.splice(index + 1, 0, new OutputLine(this));
          this.previous_line = this.__lines[this.__lines.length - 2];
          break;
        }
        index--;
      }
    };
    module2.exports.Output = Output;
  }
});

// node_modules/js-beautify/js/src/core/token.js
var require_token = __commonJS({
  "node_modules/js-beautify/js/src/core/token.js"(exports2, module2) {
    "use strict";
    function Token(type, text, newlines, whitespace_before) {
      this.type = type;
      this.text = text;
      this.comments_before = null;
      this.newlines = newlines || 0;
      this.whitespace_before = whitespace_before || "";
      this.parent = null;
      this.next = null;
      this.previous = null;
      this.opened = null;
      this.closed = null;
      this.directives = null;
    }
    module2.exports.Token = Token;
  }
});

// node_modules/js-beautify/js/src/javascript/acorn.js
var require_acorn = __commonJS({
  "node_modules/js-beautify/js/src/javascript/acorn.js"(exports2) {
    "use strict";
    var baseASCIIidentifierStartChars = "\\x23\\x24\\x40\\x41-\\x5a\\x5f\\x61-\\x7a";
    var baseASCIIidentifierChars = "\\x24\\x30-\\x39\\x41-\\x5a\\x5f\\x61-\\x7a";
    var nonASCIIidentifierStartChars = "\\xaa\\xb5\\xba\\xc0-\\xd6\\xd8-\\xf6\\xf8-\\u02c1\\u02c6-\\u02d1\\u02e0-\\u02e4\\u02ec\\u02ee\\u0370-\\u0374\\u0376\\u0377\\u037a-\\u037d\\u0386\\u0388-\\u038a\\u038c\\u038e-\\u03a1\\u03a3-\\u03f5\\u03f7-\\u0481\\u048a-\\u0527\\u0531-\\u0556\\u0559\\u0561-\\u0587\\u05d0-\\u05ea\\u05f0-\\u05f2\\u0620-\\u064a\\u066e\\u066f\\u0671-\\u06d3\\u06d5\\u06e5\\u06e6\\u06ee\\u06ef\\u06fa-\\u06fc\\u06ff\\u0710\\u0712-\\u072f\\u074d-\\u07a5\\u07b1\\u07ca-\\u07ea\\u07f4\\u07f5\\u07fa\\u0800-\\u0815\\u081a\\u0824\\u0828\\u0840-\\u0858\\u08a0\\u08a2-\\u08ac\\u0904-\\u0939\\u093d\\u0950\\u0958-\\u0961\\u0971-\\u0977\\u0979-\\u097f\\u0985-\\u098c\\u098f\\u0990\\u0993-\\u09a8\\u09aa-\\u09b0\\u09b2\\u09b6-\\u09b9\\u09bd\\u09ce\\u09dc\\u09dd\\u09df-\\u09e1\\u09f0\\u09f1\\u0a05-\\u0a0a\\u0a0f\\u0a10\\u0a13-\\u0a28\\u0a2a-\\u0a30\\u0a32\\u0a33\\u0a35\\u0a36\\u0a38\\u0a39\\u0a59-\\u0a5c\\u0a5e\\u0a72-\\u0a74\\u0a85-\\u0a8d\\u0a8f-\\u0a91\\u0a93-\\u0aa8\\u0aaa-\\u0ab0\\u0ab2\\u0ab3\\u0ab5-\\u0ab9\\u0abd\\u0ad0\\u0ae0\\u0ae1\\u0b05-\\u0b0c\\u0b0f\\u0b10\\u0b13-\\u0b28\\u0b2a-\\u0b30\\u0b32\\u0b33\\u0b35-\\u0b39\\u0b3d\\u0b5c\\u0b5d\\u0b5f-\\u0b61\\u0b71\\u0b83\\u0b85-\\u0b8a\\u0b8e-\\u0b90\\u0b92-\\u0b95\\u0b99\\u0b9a\\u0b9c\\u0b9e\\u0b9f\\u0ba3\\u0ba4\\u0ba8-\\u0baa\\u0bae-\\u0bb9\\u0bd0\\u0c05-\\u0c0c\\u0c0e-\\u0c10\\u0c12-\\u0c28\\u0c2a-\\u0c33\\u0c35-\\u0c39\\u0c3d\\u0c58\\u0c59\\u0c60\\u0c61\\u0c85-\\u0c8c\\u0c8e-\\u0c90\\u0c92-\\u0ca8\\u0caa-\\u0cb3\\u0cb5-\\u0cb9\\u0cbd\\u0cde\\u0ce0\\u0ce1\\u0cf1\\u0cf2\\u0d05-\\u0d0c\\u0d0e-\\u0d10\\u0d12-\\u0d3a\\u0d3d\\u0d4e\\u0d60\\u0d61\\u0d7a-\\u0d7f\\u0d85-\\u0d96\\u0d9a-\\u0db1\\u0db3-\\u0dbb\\u0dbd\\u0dc0-\\u0dc6\\u0e01-\\u0e30\\u0e32\\u0e33\\u0e40-\\u0e46\\u0e81\\u0e82\\u0e84\\u0e87\\u0e88\\u0e8a\\u0e8d\\u0e94-\\u0e97\\u0e99-\\u0e9f\\u0ea1-\\u0ea3\\u0ea5\\u0ea7\\u0eaa\\u0eab\\u0ead-\\u0eb0\\u0eb2\\u0eb3\\u0ebd\\u0ec0-\\u0ec4\\u0ec6\\u0edc-\\u0edf\\u0f00\\u0f40-\\u0f47\\u0f49-\\u0f6c\\u0f88-\\u0f8c\\u1000-\\u102a\\u103f\\u1050-\\u1055\\u105a-\\u105d\\u1061\\u1065\\u1066\\u106e-\\u1070\\u1075-\\u1081\\u108e\\u10a0-\\u10c5\\u10c7\\u10cd\\u10d0-\\u10fa\\u10fc-\\u1248\\u124a-\\u124d\\u1250-\\u1256\\u1258\\u125a-\\u125d\\u1260-\\u1288\\u128a-\\u128d\\u1290-\\u12b0\\u12b2-\\u12b5\\u12b8-\\u12be\\u12c0\\u12c2-\\u12c5\\u12c8-\\u12d6\\u12d8-\\u1310\\u1312-\\u1315\\u1318-\\u135a\\u1380-\\u138f\\u13a0-\\u13f4\\u1401-\\u166c\\u166f-\\u167f\\u1681-\\u169a\\u16a0-\\u16ea\\u16ee-\\u16f0\\u1700-\\u170c\\u170e-\\u1711\\u1720-\\u1731\\u1740-\\u1751\\u1760-\\u176c\\u176e-\\u1770\\u1780-\\u17b3\\u17d7\\u17dc\\u1820-\\u1877\\u1880-\\u18a8\\u18aa\\u18b0-\\u18f5\\u1900-\\u191c\\u1950-\\u196d\\u1970-\\u1974\\u1980-\\u19ab\\u19c1-\\u19c7\\u1a00-\\u1a16\\u1a20-\\u1a54\\u1aa7\\u1b05-\\u1b33\\u1b45-\\u1b4b\\u1b83-\\u1ba0\\u1bae\\u1baf\\u1bba-\\u1be5\\u1c00-\\u1c23\\u1c4d-\\u1c4f\\u1c5a-\\u1c7d\\u1ce9-\\u1cec\\u1cee-\\u1cf1\\u1cf5\\u1cf6\\u1d00-\\u1dbf\\u1e00-\\u1f15\\u1f18-\\u1f1d\\u1f20-\\u1f45\\u1f48-\\u1f4d\\u1f50-\\u1f57\\u1f59\\u1f5b\\u1f5d\\u1f5f-\\u1f7d\\u1f80-\\u1fb4\\u1fb6-\\u1fbc\\u1fbe\\u1fc2-\\u1fc4\\u1fc6-\\u1fcc\\u1fd0-\\u1fd3\\u1fd6-\\u1fdb\\u1fe0-\\u1fec\\u1ff2-\\u1ff4\\u1ff6-\\u1ffc\\u2071\\u207f\\u2090-\\u209c\\u2102\\u2107\\u210a-\\u2113\\u2115\\u2119-\\u211d\\u2124\\u2126\\u2128\\u212a-\\u212d\\u212f-\\u2139\\u213c-\\u213f\\u2145-\\u2149\\u214e\\u2160-\\u2188\\u2c00-\\u2c2e\\u2c30-\\u2c5e\\u2c60-\\u2ce4\\u2ceb-\\u2cee\\u2cf2\\u2cf3\\u2d00-\\u2d25\\u2d27\\u2d2d\\u2d30-\\u2d67\\u2d6f\\u2d80-\\u2d96\\u2da0-\\u2da6\\u2da8-\\u2dae\\u2db0-\\u2db6\\u2db8-\\u2dbe\\u2dc0-\\u2dc6\\u2dc8-\\u2dce\\u2dd0-\\u2dd6\\u2dd8-\\u2dde\\u2e2f\\u3005-\\u3007\\u3021-\\u3029\\u3031-\\u3035\\u3038-\\u303c\\u3041-\\u3096\\u309d-\\u309f\\u30a1-\\u30fa\\u30fc-\\u30ff\\u3105-\\u312d\\u3131-\\u318e\\u31a0-\\u31ba\\u31f0-\\u31ff\\u3400-\\u4db5\\u4e00-\\u9fcc\\ua000-\\ua48c\\ua4d0-\\ua4fd\\ua500-\\ua60c\\ua610-\\ua61f\\ua62a\\ua62b\\ua640-\\ua66e\\ua67f-\\ua697\\ua6a0-\\ua6ef\\ua717-\\ua71f\\ua722-\\ua788\\ua78b-\\ua78e\\ua790-\\ua793\\ua7a0-\\ua7aa\\ua7f8-\\ua801\\ua803-\\ua805\\ua807-\\ua80a\\ua80c-\\ua822\\ua840-\\ua873\\ua882-\\ua8b3\\ua8f2-\\ua8f7\\ua8fb\\ua90a-\\ua925\\ua930-\\ua946\\ua960-\\ua97c\\ua984-\\ua9b2\\ua9cf\\uaa00-\\uaa28\\uaa40-\\uaa42\\uaa44-\\uaa4b\\uaa60-\\uaa76\\uaa7a\\uaa80-\\uaaaf\\uaab1\\uaab5\\uaab6\\uaab9-\\uaabd\\uaac0\\uaac2\\uaadb-\\uaadd\\uaae0-\\uaaea\\uaaf2-\\uaaf4\\uab01-\\uab06\\uab09-\\uab0e\\uab11-\\uab16\\uab20-\\uab26\\uab28-\\uab2e\\uabc0-\\uabe2\\uac00-\\ud7a3\\ud7b0-\\ud7c6\\ud7cb-\\ud7fb\\uf900-\\ufa6d\\ufa70-\\ufad9\\ufb00-\\ufb06\\ufb13-\\ufb17\\ufb1d\\ufb1f-\\ufb28\\ufb2a-\\ufb36\\ufb38-\\ufb3c\\ufb3e\\ufb40\\ufb41\\ufb43\\ufb44\\ufb46-\\ufbb1\\ufbd3-\\ufd3d\\ufd50-\\ufd8f\\ufd92-\\ufdc7\\ufdf0-\\ufdfb\\ufe70-\\ufe74\\ufe76-\\ufefc\\uff21-\\uff3a\\uff41-\\uff5a\\uff66-\\uffbe\\uffc2-\\uffc7\\uffca-\\uffcf\\uffd2-\\uffd7\\uffda-\\uffdc";
    var nonASCIIidentifierChars = "\\u0300-\\u036f\\u0483-\\u0487\\u0591-\\u05bd\\u05bf\\u05c1\\u05c2\\u05c4\\u05c5\\u05c7\\u0610-\\u061a\\u0620-\\u0649\\u0672-\\u06d3\\u06e7-\\u06e8\\u06fb-\\u06fc\\u0730-\\u074a\\u0800-\\u0814\\u081b-\\u0823\\u0825-\\u0827\\u0829-\\u082d\\u0840-\\u0857\\u08e4-\\u08fe\\u0900-\\u0903\\u093a-\\u093c\\u093e-\\u094f\\u0951-\\u0957\\u0962-\\u0963\\u0966-\\u096f\\u0981-\\u0983\\u09bc\\u09be-\\u09c4\\u09c7\\u09c8\\u09d7\\u09df-\\u09e0\\u0a01-\\u0a03\\u0a3c\\u0a3e-\\u0a42\\u0a47\\u0a48\\u0a4b-\\u0a4d\\u0a51\\u0a66-\\u0a71\\u0a75\\u0a81-\\u0a83\\u0abc\\u0abe-\\u0ac5\\u0ac7-\\u0ac9\\u0acb-\\u0acd\\u0ae2-\\u0ae3\\u0ae6-\\u0aef\\u0b01-\\u0b03\\u0b3c\\u0b3e-\\u0b44\\u0b47\\u0b48\\u0b4b-\\u0b4d\\u0b56\\u0b57\\u0b5f-\\u0b60\\u0b66-\\u0b6f\\u0b82\\u0bbe-\\u0bc2\\u0bc6-\\u0bc8\\u0bca-\\u0bcd\\u0bd7\\u0be6-\\u0bef\\u0c01-\\u0c03\\u0c46-\\u0c48\\u0c4a-\\u0c4d\\u0c55\\u0c56\\u0c62-\\u0c63\\u0c66-\\u0c6f\\u0c82\\u0c83\\u0cbc\\u0cbe-\\u0cc4\\u0cc6-\\u0cc8\\u0cca-\\u0ccd\\u0cd5\\u0cd6\\u0ce2-\\u0ce3\\u0ce6-\\u0cef\\u0d02\\u0d03\\u0d46-\\u0d48\\u0d57\\u0d62-\\u0d63\\u0d66-\\u0d6f\\u0d82\\u0d83\\u0dca\\u0dcf-\\u0dd4\\u0dd6\\u0dd8-\\u0ddf\\u0df2\\u0df3\\u0e34-\\u0e3a\\u0e40-\\u0e45\\u0e50-\\u0e59\\u0eb4-\\u0eb9\\u0ec8-\\u0ecd\\u0ed0-\\u0ed9\\u0f18\\u0f19\\u0f20-\\u0f29\\u0f35\\u0f37\\u0f39\\u0f41-\\u0f47\\u0f71-\\u0f84\\u0f86-\\u0f87\\u0f8d-\\u0f97\\u0f99-\\u0fbc\\u0fc6\\u1000-\\u1029\\u1040-\\u1049\\u1067-\\u106d\\u1071-\\u1074\\u1082-\\u108d\\u108f-\\u109d\\u135d-\\u135f\\u170e-\\u1710\\u1720-\\u1730\\u1740-\\u1750\\u1772\\u1773\\u1780-\\u17b2\\u17dd\\u17e0-\\u17e9\\u180b-\\u180d\\u1810-\\u1819\\u1920-\\u192b\\u1930-\\u193b\\u1951-\\u196d\\u19b0-\\u19c0\\u19c8-\\u19c9\\u19d0-\\u19d9\\u1a00-\\u1a15\\u1a20-\\u1a53\\u1a60-\\u1a7c\\u1a7f-\\u1a89\\u1a90-\\u1a99\\u1b46-\\u1b4b\\u1b50-\\u1b59\\u1b6b-\\u1b73\\u1bb0-\\u1bb9\\u1be6-\\u1bf3\\u1c00-\\u1c22\\u1c40-\\u1c49\\u1c5b-\\u1c7d\\u1cd0-\\u1cd2\\u1d00-\\u1dbe\\u1e01-\\u1f15\\u200c\\u200d\\u203f\\u2040\\u2054\\u20d0-\\u20dc\\u20e1\\u20e5-\\u20f0\\u2d81-\\u2d96\\u2de0-\\u2dff\\u3021-\\u3028\\u3099\\u309a\\ua640-\\ua66d\\ua674-\\ua67d\\ua69f\\ua6f0-\\ua6f1\\ua7f8-\\ua800\\ua806\\ua80b\\ua823-\\ua827\\ua880-\\ua881\\ua8b4-\\ua8c4\\ua8d0-\\ua8d9\\ua8f3-\\ua8f7\\ua900-\\ua909\\ua926-\\ua92d\\ua930-\\ua945\\ua980-\\ua983\\ua9b3-\\ua9c0\\uaa00-\\uaa27\\uaa40-\\uaa41\\uaa4c-\\uaa4d\\uaa50-\\uaa59\\uaa7b\\uaae0-\\uaae9\\uaaf2-\\uaaf3\\uabc0-\\uabe1\\uabec\\uabed\\uabf0-\\uabf9\\ufb20-\\ufb28\\ufe00-\\ufe0f\\ufe20-\\ufe26\\ufe33\\ufe34\\ufe4d-\\ufe4f\\uff10-\\uff19\\uff3f";
    var unicodeEscapeOrCodePoint = "\\\\u[0-9a-fA-F]{4}|\\\\u\\{[0-9a-fA-F]+\\}";
    var identifierStart = "(?:" + unicodeEscapeOrCodePoint + "|[" + baseASCIIidentifierStartChars + nonASCIIidentifierStartChars + "])";
    var identifierChars = "(?:" + unicodeEscapeOrCodePoint + "|[" + baseASCIIidentifierChars + nonASCIIidentifierStartChars + nonASCIIidentifierChars + "])*";
    exports2.identifier = new RegExp(identifierStart + identifierChars, "g");
    exports2.identifierStart = new RegExp(identifierStart);
    exports2.identifierMatch = new RegExp("(?:" + unicodeEscapeOrCodePoint + "|[" + baseASCIIidentifierChars + nonASCIIidentifierStartChars + nonASCIIidentifierChars + "])+");
    exports2.newline = /[\n\r\u2028\u2029]/;
    exports2.lineBreak = new RegExp("\r\n|" + exports2.newline.source);
    exports2.allLineBreaks = new RegExp(exports2.lineBreak.source, "g");
  }
});

// node_modules/js-beautify/js/src/core/options.js
var require_options = __commonJS({
  "node_modules/js-beautify/js/src/core/options.js"(exports2, module2) {
    "use strict";
    function Options(options, merge_child_field) {
      this.raw_options = _mergeOpts(options, merge_child_field);
      this.disabled = this._get_boolean("disabled");
      this.eol = this._get_characters("eol", "auto");
      this.end_with_newline = this._get_boolean("end_with_newline");
      this.indent_size = this._get_number("indent_size", 4);
      this.indent_char = this._get_characters("indent_char", " ");
      this.indent_level = this._get_number("indent_level");
      this.preserve_newlines = this._get_boolean("preserve_newlines", true);
      this.max_preserve_newlines = this._get_number("max_preserve_newlines", 32786);
      if (!this.preserve_newlines) {
        this.max_preserve_newlines = 0;
      }
      this.indent_with_tabs = this._get_boolean("indent_with_tabs", this.indent_char === "	");
      if (this.indent_with_tabs) {
        this.indent_char = "	";
        if (this.indent_size === 1) {
          this.indent_size = 4;
        }
      }
      this.wrap_line_length = this._get_number("wrap_line_length", this._get_number("max_char"));
      this.indent_empty_lines = this._get_boolean("indent_empty_lines");
      this.templating = this._get_selection_list("templating", ["auto", "none", "angular", "django", "erb", "handlebars", "php", "smarty"], ["auto"]);
    }
    Options.prototype._get_array = function(name, default_value) {
      var option_value = this.raw_options[name];
      var result = default_value || [];
      if (typeof option_value === "object") {
        if (option_value !== null && typeof option_value.concat === "function") {
          result = option_value.concat();
        }
      } else if (typeof option_value === "string") {
        result = option_value.split(/[^a-zA-Z0-9_\/\-]+/);
      }
      return result;
    };
    Options.prototype._get_boolean = function(name, default_value) {
      var option_value = this.raw_options[name];
      var result = option_value === void 0 ? !!default_value : !!option_value;
      return result;
    };
    Options.prototype._get_characters = function(name, default_value) {
      var option_value = this.raw_options[name];
      var result = default_value || "";
      if (typeof option_value === "string") {
        result = option_value.replace(/\\r/, "\r").replace(/\\n/, "\n").replace(/\\t/, "	");
      }
      return result;
    };
    Options.prototype._get_number = function(name, default_value) {
      var option_value = this.raw_options[name];
      default_value = parseInt(default_value, 10);
      if (isNaN(default_value)) {
        default_value = 0;
      }
      var result = parseInt(option_value, 10);
      if (isNaN(result)) {
        result = default_value;
      }
      return result;
    };
    Options.prototype._get_selection = function(name, selection_list, default_value) {
      var result = this._get_selection_list(name, selection_list, default_value);
      if (result.length !== 1) {
        throw new Error(
          "Invalid Option Value: The option '" + name + "' can only be one of the following values:\n" + selection_list + "\nYou passed in: '" + this.raw_options[name] + "'"
        );
      }
      return result[0];
    };
    Options.prototype._get_selection_list = function(name, selection_list, default_value) {
      if (!selection_list || selection_list.length === 0) {
        throw new Error("Selection list cannot be empty.");
      }
      default_value = default_value || [selection_list[0]];
      if (!this._is_valid_selection(default_value, selection_list)) {
        throw new Error("Invalid Default Value!");
      }
      var result = this._get_array(name, default_value);
      if (!this._is_valid_selection(result, selection_list)) {
        throw new Error(
          "Invalid Option Value: The option '" + name + "' can contain only the following values:\n" + selection_list + "\nYou passed in: '" + this.raw_options[name] + "'"
        );
      }
      return result;
    };
    Options.prototype._is_valid_selection = function(result, selection_list) {
      return result.length && selection_list.length && !result.some(function(item) {
        return selection_list.indexOf(item) === -1;
      });
    };
    function _mergeOpts(allOptions, childFieldName) {
      var finalOpts = {};
      allOptions = _normalizeOpts(allOptions);
      var name;
      for (name in allOptions) {
        if (name !== childFieldName) {
          finalOpts[name] = allOptions[name];
        }
      }
      if (childFieldName && allOptions[childFieldName]) {
        for (name in allOptions[childFieldName]) {
          finalOpts[name] = allOptions[childFieldName][name];
        }
      }
      return finalOpts;
    }
    function _normalizeOpts(options) {
      var convertedOpts = {};
      var key;
      for (key in options) {
        var newKey = key.replace(/-/g, "_");
        convertedOpts[newKey] = options[key];
      }
      return convertedOpts;
    }
    module2.exports.Options = Options;
    module2.exports.normalizeOpts = _normalizeOpts;
    module2.exports.mergeOpts = _mergeOpts;
  }
});

// node_modules/js-beautify/js/src/javascript/options.js
var require_options2 = __commonJS({
  "node_modules/js-beautify/js/src/javascript/options.js"(exports2, module2) {
    "use strict";
    var BaseOptions = require_options().Options;
    var validPositionValues = ["before-newline", "after-newline", "preserve-newline"];
    function Options(options) {
      BaseOptions.call(this, options, "js");
      var raw_brace_style = this.raw_options.brace_style || null;
      if (raw_brace_style === "expand-strict") {
        this.raw_options.brace_style = "expand";
      } else if (raw_brace_style === "collapse-preserve-inline") {
        this.raw_options.brace_style = "collapse,preserve-inline";
      } else if (this.raw_options.braces_on_own_line !== void 0) {
        this.raw_options.brace_style = this.raw_options.braces_on_own_line ? "expand" : "collapse";
      }
      var brace_style_split = this._get_selection_list("brace_style", ["collapse", "expand", "end-expand", "none", "preserve-inline"]);
      this.brace_preserve_inline = false;
      this.brace_style = "collapse";
      for (var bs = 0; bs < brace_style_split.length; bs++) {
        if (brace_style_split[bs] === "preserve-inline") {
          this.brace_preserve_inline = true;
        } else {
          this.brace_style = brace_style_split[bs];
        }
      }
      this.unindent_chained_methods = this._get_boolean("unindent_chained_methods");
      this.break_chained_methods = this._get_boolean("break_chained_methods");
      this.space_in_paren = this._get_boolean("space_in_paren");
      this.space_in_empty_paren = this._get_boolean("space_in_empty_paren");
      this.jslint_happy = this._get_boolean("jslint_happy");
      this.space_after_anon_function = this._get_boolean("space_after_anon_function");
      this.space_after_named_function = this._get_boolean("space_after_named_function");
      this.keep_array_indentation = this._get_boolean("keep_array_indentation");
      this.space_before_conditional = this._get_boolean("space_before_conditional", true);
      this.unescape_strings = this._get_boolean("unescape_strings");
      this.e4x = this._get_boolean("e4x");
      this.comma_first = this._get_boolean("comma_first");
      this.operator_position = this._get_selection("operator_position", validPositionValues);
      this.test_output_raw = this._get_boolean("test_output_raw");
      if (this.jslint_happy) {
        this.space_after_anon_function = true;
      }
    }
    Options.prototype = new BaseOptions();
    module2.exports.Options = Options;
  }
});

// node_modules/js-beautify/js/src/core/inputscanner.js
var require_inputscanner = __commonJS({
  "node_modules/js-beautify/js/src/core/inputscanner.js"(exports2, module2) {
    "use strict";
    var regexp_has_sticky = RegExp.prototype.hasOwnProperty("sticky");
    function InputScanner(input_string) {
      this.__input = input_string || "";
      this.__input_length = this.__input.length;
      this.__position = 0;
    }
    InputScanner.prototype.restart = function() {
      this.__position = 0;
    };
    InputScanner.prototype.back = function() {
      if (this.__position > 0) {
        this.__position -= 1;
      }
    };
    InputScanner.prototype.hasNext = function() {
      return this.__position < this.__input_length;
    };
    InputScanner.prototype.next = function() {
      var val = null;
      if (this.hasNext()) {
        val = this.__input.charAt(this.__position);
        this.__position += 1;
      }
      return val;
    };
    InputScanner.prototype.peek = function(index) {
      var val = null;
      index = index || 0;
      index += this.__position;
      if (index >= 0 && index < this.__input_length) {
        val = this.__input.charAt(index);
      }
      return val;
    };
    InputScanner.prototype.__match = function(pattern, index) {
      pattern.lastIndex = index;
      var pattern_match = pattern.exec(this.__input);
      if (pattern_match && !(regexp_has_sticky && pattern.sticky)) {
        if (pattern_match.index !== index) {
          pattern_match = null;
        }
      }
      return pattern_match;
    };
    InputScanner.prototype.test = function(pattern, index) {
      index = index || 0;
      index += this.__position;
      if (index >= 0 && index < this.__input_length) {
        return !!this.__match(pattern, index);
      } else {
        return false;
      }
    };
    InputScanner.prototype.testChar = function(pattern, index) {
      var val = this.peek(index);
      pattern.lastIndex = 0;
      return val !== null && pattern.test(val);
    };
    InputScanner.prototype.match = function(pattern) {
      var pattern_match = this.__match(pattern, this.__position);
      if (pattern_match) {
        this.__position += pattern_match[0].length;
      } else {
        pattern_match = null;
      }
      return pattern_match;
    };
    InputScanner.prototype.read = function(starting_pattern, until_pattern, until_after) {
      var val = "";
      var match;
      if (starting_pattern) {
        match = this.match(starting_pattern);
        if (match) {
          val += match[0];
        }
      }
      if (until_pattern && (match || !starting_pattern)) {
        val += this.readUntil(until_pattern, until_after);
      }
      return val;
    };
    InputScanner.prototype.readUntil = function(pattern, until_after) {
      var val = "";
      var match_index = this.__position;
      pattern.lastIndex = this.__position;
      var pattern_match = pattern.exec(this.__input);
      if (pattern_match) {
        match_index = pattern_match.index;
        if (until_after) {
          match_index += pattern_match[0].length;
        }
      } else {
        match_index = this.__input_length;
      }
      val = this.__input.substring(this.__position, match_index);
      this.__position = match_index;
      return val;
    };
    InputScanner.prototype.readUntilAfter = function(pattern) {
      return this.readUntil(pattern, true);
    };
    InputScanner.prototype.get_regexp = function(pattern, match_from) {
      var result = null;
      var flags = "g";
      if (match_from && regexp_has_sticky) {
        flags = "y";
      }
      if (typeof pattern === "string" && pattern !== "") {
        result = new RegExp(pattern, flags);
      } else if (pattern) {
        result = new RegExp(pattern.source, flags);
      }
      return result;
    };
    InputScanner.prototype.get_literal_regexp = function(literal_string) {
      return RegExp(literal_string.replace(/[-\/\\^$*+?.()|[\]{}]/g, "\\$&"));
    };
    InputScanner.prototype.peekUntilAfter = function(pattern) {
      var start = this.__position;
      var val = this.readUntilAfter(pattern);
      this.__position = start;
      return val;
    };
    InputScanner.prototype.lookBack = function(testVal) {
      var start = this.__position - 1;
      return start >= testVal.length && this.__input.substring(start - testVal.length, start).toLowerCase() === testVal;
    };
    module2.exports.InputScanner = InputScanner;
  }
});

// node_modules/js-beautify/js/src/core/tokenstream.js
var require_tokenstream = __commonJS({
  "node_modules/js-beautify/js/src/core/tokenstream.js"(exports2, module2) {
    "use strict";
    function TokenStream(parent_token) {
      this.__tokens = [];
      this.__tokens_length = this.__tokens.length;
      this.__position = 0;
      this.__parent_token = parent_token;
    }
    TokenStream.prototype.restart = function() {
      this.__position = 0;
    };
    TokenStream.prototype.isEmpty = function() {
      return this.__tokens_length === 0;
    };
    TokenStream.prototype.hasNext = function() {
      return this.__position < this.__tokens_length;
    };
    TokenStream.prototype.next = function() {
      var val = null;
      if (this.hasNext()) {
        val = this.__tokens[this.__position];
        this.__position += 1;
      }
      return val;
    };
    TokenStream.prototype.peek = function(index) {
      var val = null;
      index = index || 0;
      index += this.__position;
      if (index >= 0 && index < this.__tokens_length) {
        val = this.__tokens[index];
      }
      return val;
    };
    TokenStream.prototype.add = function(token) {
      if (this.__parent_token) {
        token.parent = this.__parent_token;
      }
      this.__tokens.push(token);
      this.__tokens_length += 1;
    };
    module2.exports.TokenStream = TokenStream;
  }
});

// node_modules/js-beautify/js/src/core/pattern.js
var require_pattern = __commonJS({
  "node_modules/js-beautify/js/src/core/pattern.js"(exports2, module2) {
    "use strict";
    function Pattern(input_scanner, parent) {
      this._input = input_scanner;
      this._starting_pattern = null;
      this._match_pattern = null;
      this._until_pattern = null;
      this._until_after = false;
      if (parent) {
        this._starting_pattern = this._input.get_regexp(parent._starting_pattern, true);
        this._match_pattern = this._input.get_regexp(parent._match_pattern, true);
        this._until_pattern = this._input.get_regexp(parent._until_pattern);
        this._until_after = parent._until_after;
      }
    }
    Pattern.prototype.read = function() {
      var result = this._input.read(this._starting_pattern);
      if (!this._starting_pattern || result) {
        result += this._input.read(this._match_pattern, this._until_pattern, this._until_after);
      }
      return result;
    };
    Pattern.prototype.read_match = function() {
      return this._input.match(this._match_pattern);
    };
    Pattern.prototype.until_after = function(pattern) {
      var result = this._create();
      result._until_after = true;
      result._until_pattern = this._input.get_regexp(pattern);
      result._update();
      return result;
    };
    Pattern.prototype.until = function(pattern) {
      var result = this._create();
      result._until_after = false;
      result._until_pattern = this._input.get_regexp(pattern);
      result._update();
      return result;
    };
    Pattern.prototype.starting_with = function(pattern) {
      var result = this._create();
      result._starting_pattern = this._input.get_regexp(pattern, true);
      result._update();
      return result;
    };
    Pattern.prototype.matching = function(pattern) {
      var result = this._create();
      result._match_pattern = this._input.get_regexp(pattern, true);
      result._update();
      return result;
    };
    Pattern.prototype._create = function() {
      return new Pattern(this._input, this);
    };
    Pattern.prototype._update = function() {
    };
    module2.exports.Pattern = Pattern;
  }
});

// node_modules/js-beautify/js/src/core/whitespacepattern.js
var require_whitespacepattern = __commonJS({
  "node_modules/js-beautify/js/src/core/whitespacepattern.js"(exports2, module2) {
    "use strict";
    var Pattern = require_pattern().Pattern;
    function WhitespacePattern(input_scanner, parent) {
      Pattern.call(this, input_scanner, parent);
      if (parent) {
        this._line_regexp = this._input.get_regexp(parent._line_regexp);
      } else {
        this.__set_whitespace_patterns("", "");
      }
      this.newline_count = 0;
      this.whitespace_before_token = "";
    }
    WhitespacePattern.prototype = new Pattern();
    WhitespacePattern.prototype.__set_whitespace_patterns = function(whitespace_chars, newline_chars) {
      whitespace_chars += "\\t ";
      newline_chars += "\\n\\r";
      this._match_pattern = this._input.get_regexp(
        "[" + whitespace_chars + newline_chars + "]+",
        true
      );
      this._newline_regexp = this._input.get_regexp(
        "\\r\\n|[" + newline_chars + "]"
      );
    };
    WhitespacePattern.prototype.read = function() {
      this.newline_count = 0;
      this.whitespace_before_token = "";
      var resulting_string = this._input.read(this._match_pattern);
      if (resulting_string === " ") {
        this.whitespace_before_token = " ";
      } else if (resulting_string) {
        var matches = this.__split(this._newline_regexp, resulting_string);
        this.newline_count = matches.length - 1;
        this.whitespace_before_token = matches[this.newline_count];
      }
      return resulting_string;
    };
    WhitespacePattern.prototype.matching = function(whitespace_chars, newline_chars) {
      var result = this._create();
      result.__set_whitespace_patterns(whitespace_chars, newline_chars);
      result._update();
      return result;
    };
    WhitespacePattern.prototype._create = function() {
      return new WhitespacePattern(this._input, this);
    };
    WhitespacePattern.prototype.__split = function(regexp, input_string) {
      regexp.lastIndex = 0;
      var start_index = 0;
      var result = [];
      var next_match = regexp.exec(input_string);
      while (next_match) {
        result.push(input_string.substring(start_index, next_match.index));
        start_index = next_match.index + next_match[0].length;
        next_match = regexp.exec(input_string);
      }
      if (start_index < input_string.length) {
        result.push(input_string.substring(start_index, input_string.length));
      } else {
        result.push("");
      }
      return result;
    };
    module2.exports.WhitespacePattern = WhitespacePattern;
  }
});

// node_modules/js-beautify/js/src/core/tokenizer.js
var require_tokenizer = __commonJS({
  "node_modules/js-beautify/js/src/core/tokenizer.js"(exports2, module2) {
    "use strict";
    var InputScanner = require_inputscanner().InputScanner;
    var Token = require_token().Token;
    var TokenStream = require_tokenstream().TokenStream;
    var WhitespacePattern = require_whitespacepattern().WhitespacePattern;
    var TOKEN = {
      START: "TK_START",
      RAW: "TK_RAW",
      EOF: "TK_EOF"
    };
    var Tokenizer = function(input_string, options) {
      this._input = new InputScanner(input_string);
      this._options = options || {};
      this.__tokens = null;
      this._patterns = {};
      this._patterns.whitespace = new WhitespacePattern(this._input);
    };
    Tokenizer.prototype.tokenize = function() {
      this._input.restart();
      this.__tokens = new TokenStream();
      this._reset();
      var current;
      var previous = new Token(TOKEN.START, "");
      var open_token = null;
      var open_stack = [];
      var comments = new TokenStream();
      while (previous.type !== TOKEN.EOF) {
        current = this._get_next_token(previous, open_token);
        while (this._is_comment(current)) {
          comments.add(current);
          current = this._get_next_token(previous, open_token);
        }
        if (!comments.isEmpty()) {
          current.comments_before = comments;
          comments = new TokenStream();
        }
        current.parent = open_token;
        if (this._is_opening(current)) {
          open_stack.push(open_token);
          open_token = current;
        } else if (open_token && this._is_closing(current, open_token)) {
          current.opened = open_token;
          open_token.closed = current;
          open_token = open_stack.pop();
          current.parent = open_token;
        }
        current.previous = previous;
        previous.next = current;
        this.__tokens.add(current);
        previous = current;
      }
      return this.__tokens;
    };
    Tokenizer.prototype._is_first_token = function() {
      return this.__tokens.isEmpty();
    };
    Tokenizer.prototype._reset = function() {
    };
    Tokenizer.prototype._get_next_token = function(previous_token, open_token) {
      this._readWhitespace();
      var resulting_string = this._input.read(/.+/g);
      if (resulting_string) {
        return this._create_token(TOKEN.RAW, resulting_string);
      } else {
        return this._create_token(TOKEN.EOF, "");
      }
    };
    Tokenizer.prototype._is_comment = function(current_token) {
      return false;
    };
    Tokenizer.prototype._is_opening = function(current_token) {
      return false;
    };
    Tokenizer.prototype._is_closing = function(current_token, open_token) {
      return false;
    };
    Tokenizer.prototype._create_token = function(type, text) {
      var token = new Token(
        type,
        text,
        this._patterns.whitespace.newline_count,
        this._patterns.whitespace.whitespace_before_token
      );
      return token;
    };
    Tokenizer.prototype._readWhitespace = function() {
      return this._patterns.whitespace.read();
    };
    module2.exports.Tokenizer = Tokenizer;
    module2.exports.TOKEN = TOKEN;
  }
});

// node_modules/js-beautify/js/src/core/directives.js
var require_directives = __commonJS({
  "node_modules/js-beautify/js/src/core/directives.js"(exports2, module2) {
    "use strict";
    function Directives(start_block_pattern, end_block_pattern) {
      start_block_pattern = typeof start_block_pattern === "string" ? start_block_pattern : start_block_pattern.source;
      end_block_pattern = typeof end_block_pattern === "string" ? end_block_pattern : end_block_pattern.source;
      this.__directives_block_pattern = new RegExp(start_block_pattern + / beautify( \w+[:]\w+)+ /.source + end_block_pattern, "g");
      this.__directive_pattern = / (\w+)[:](\w+)/g;
      this.__directives_end_ignore_pattern = new RegExp(start_block_pattern + /\sbeautify\signore:end\s/.source + end_block_pattern, "g");
    }
    Directives.prototype.get_directives = function(text) {
      if (!text.match(this.__directives_block_pattern)) {
        return null;
      }
      var directives = {};
      this.__directive_pattern.lastIndex = 0;
      var directive_match = this.__directive_pattern.exec(text);
      while (directive_match) {
        directives[directive_match[1]] = directive_match[2];
        directive_match = this.__directive_pattern.exec(text);
      }
      return directives;
    };
    Directives.prototype.readIgnored = function(input) {
      return input.readUntilAfter(this.__directives_end_ignore_pattern);
    };
    module2.exports.Directives = Directives;
  }
});

// node_modules/js-beautify/js/src/core/templatablepattern.js
var require_templatablepattern = __commonJS({
  "node_modules/js-beautify/js/src/core/templatablepattern.js"(exports2, module2) {
    "use strict";
    var Pattern = require_pattern().Pattern;
    var template_names = {
      django: false,
      erb: false,
      handlebars: false,
      php: false,
      smarty: false,
      angular: false
    };
    function TemplatablePattern(input_scanner, parent) {
      Pattern.call(this, input_scanner, parent);
      this.__template_pattern = null;
      this._disabled = Object.assign({}, template_names);
      this._excluded = Object.assign({}, template_names);
      if (parent) {
        this.__template_pattern = this._input.get_regexp(parent.__template_pattern);
        this._excluded = Object.assign(this._excluded, parent._excluded);
        this._disabled = Object.assign(this._disabled, parent._disabled);
      }
      var pattern = new Pattern(input_scanner);
      this.__patterns = {
        handlebars_comment: pattern.starting_with(/{{!--/).until_after(/--}}/),
        handlebars_unescaped: pattern.starting_with(/{{{/).until_after(/}}}/),
        handlebars: pattern.starting_with(/{{/).until_after(/}}/),
        php: pattern.starting_with(/<\?(?:[= ]|php)/).until_after(/\?>/),
        erb: pattern.starting_with(/<%[^%]/).until_after(/[^%]%>/),
        django: pattern.starting_with(/{%/).until_after(/%}/),
        django_value: pattern.starting_with(/{{/).until_after(/}}/),
        django_comment: pattern.starting_with(/{#/).until_after(/#}/),
        smarty: pattern.starting_with(/{(?=[^}{\s\n])/).until_after(/[^\s\n]}/),
        smarty_comment: pattern.starting_with(/{\*/).until_after(/\*}/),
        smarty_literal: pattern.starting_with(/{literal}/).until_after(/{\/literal}/)
      };
    }
    TemplatablePattern.prototype = new Pattern();
    TemplatablePattern.prototype._create = function() {
      return new TemplatablePattern(this._input, this);
    };
    TemplatablePattern.prototype._update = function() {
      this.__set_templated_pattern();
    };
    TemplatablePattern.prototype.disable = function(language) {
      var result = this._create();
      result._disabled[language] = true;
      result._update();
      return result;
    };
    TemplatablePattern.prototype.read_options = function(options) {
      var result = this._create();
      for (var language in template_names) {
        result._disabled[language] = options.templating.indexOf(language) === -1;
      }
      result._update();
      return result;
    };
    TemplatablePattern.prototype.exclude = function(language) {
      var result = this._create();
      result._excluded[language] = true;
      result._update();
      return result;
    };
    TemplatablePattern.prototype.read = function() {
      var result = "";
      if (this._match_pattern) {
        result = this._input.read(this._starting_pattern);
      } else {
        result = this._input.read(this._starting_pattern, this.__template_pattern);
      }
      var next = this._read_template();
      while (next) {
        if (this._match_pattern) {
          next += this._input.read(this._match_pattern);
        } else {
          next += this._input.readUntil(this.__template_pattern);
        }
        result += next;
        next = this._read_template();
      }
      if (this._until_after) {
        result += this._input.readUntilAfter(this._until_pattern);
      }
      return result;
    };
    TemplatablePattern.prototype.__set_templated_pattern = function() {
      var items = [];
      if (!this._disabled.php) {
        items.push(this.__patterns.php._starting_pattern.source);
      }
      if (!this._disabled.handlebars) {
        items.push(this.__patterns.handlebars._starting_pattern.source);
      }
      if (!this._disabled.erb) {
        items.push(this.__patterns.erb._starting_pattern.source);
      }
      if (!this._disabled.django) {
        items.push(this.__patterns.django._starting_pattern.source);
        items.push(this.__patterns.django_value._starting_pattern.source);
        items.push(this.__patterns.django_comment._starting_pattern.source);
      }
      if (!this._disabled.smarty) {
        items.push(this.__patterns.smarty._starting_pattern.source);
      }
      if (this._until_pattern) {
        items.push(this._until_pattern.source);
      }
      this.__template_pattern = this._input.get_regexp("(?:" + items.join("|") + ")");
    };
    TemplatablePattern.prototype._read_template = function() {
      var resulting_string = "";
      var c = this._input.peek();
      if (c === "<") {
        var peek1 = this._input.peek(1);
        if (!this._disabled.php && !this._excluded.php && peek1 === "?") {
          resulting_string = resulting_string || this.__patterns.php.read();
        }
        if (!this._disabled.erb && !this._excluded.erb && peek1 === "%") {
          resulting_string = resulting_string || this.__patterns.erb.read();
        }
      } else if (c === "{") {
        if (!this._disabled.handlebars && !this._excluded.handlebars) {
          resulting_string = resulting_string || this.__patterns.handlebars_comment.read();
          resulting_string = resulting_string || this.__patterns.handlebars_unescaped.read();
          resulting_string = resulting_string || this.__patterns.handlebars.read();
        }
        if (!this._disabled.django) {
          if (!this._excluded.django && !this._excluded.handlebars) {
            resulting_string = resulting_string || this.__patterns.django_value.read();
          }
          if (!this._excluded.django) {
            resulting_string = resulting_string || this.__patterns.django_comment.read();
            resulting_string = resulting_string || this.__patterns.django.read();
          }
        }
        if (!this._disabled.smarty) {
          if (this._disabled.django && this._disabled.handlebars) {
            resulting_string = resulting_string || this.__patterns.smarty_comment.read();
            resulting_string = resulting_string || this.__patterns.smarty_literal.read();
            resulting_string = resulting_string || this.__patterns.smarty.read();
          }
        }
      }
      return resulting_string;
    };
    module2.exports.TemplatablePattern = TemplatablePattern;
  }
});

// node_modules/js-beautify/js/src/javascript/tokenizer.js
var require_tokenizer2 = __commonJS({
  "node_modules/js-beautify/js/src/javascript/tokenizer.js"(exports2, module2) {
    "use strict";
    var InputScanner = require_inputscanner().InputScanner;
    var BaseTokenizer = require_tokenizer().Tokenizer;
    var BASETOKEN = require_tokenizer().TOKEN;
    var Directives = require_directives().Directives;
    var acorn = require_acorn();
    var Pattern = require_pattern().Pattern;
    var TemplatablePattern = require_templatablepattern().TemplatablePattern;
    function in_array(what, arr) {
      return arr.indexOf(what) !== -1;
    }
    var TOKEN = {
      START_EXPR: "TK_START_EXPR",
      END_EXPR: "TK_END_EXPR",
      START_BLOCK: "TK_START_BLOCK",
      END_BLOCK: "TK_END_BLOCK",
      WORD: "TK_WORD",
      RESERVED: "TK_RESERVED",
      SEMICOLON: "TK_SEMICOLON",
      STRING: "TK_STRING",
      EQUALS: "TK_EQUALS",
      OPERATOR: "TK_OPERATOR",
      COMMA: "TK_COMMA",
      BLOCK_COMMENT: "TK_BLOCK_COMMENT",
      COMMENT: "TK_COMMENT",
      DOT: "TK_DOT",
      UNKNOWN: "TK_UNKNOWN",
      START: BASETOKEN.START,
      RAW: BASETOKEN.RAW,
      EOF: BASETOKEN.EOF
    };
    var directives_core = new Directives(/\/\*/, /\*\//);
    var number_pattern = /0[xX][0123456789abcdefABCDEF_]*n?|0[oO][01234567_]*n?|0[bB][01_]*n?|\d[\d_]*n|(?:\.\d[\d_]*|\d[\d_]*\.?[\d_]*)(?:[eE][+-]?[\d_]+)?/;
    var digit = /[0-9]/;
    var dot_pattern = /[^\d\.]/;
    var positionable_operators = ">>> === !== &&= ??= ||= << && >= ** != == <= >> || ?? |> < / - + > : & % ? ^ | *".split(" ");
    var punct = ">>>= ... >>= <<= === >>> !== **= &&= ??= ||= => ^= :: /= << <= == && -= >= >> != -- += ** || ?? ++ %= &= *= |= |> = ! ? > < : / ^ - + * & % ~ |";
    punct = punct.replace(/[-[\]{}()*+?.,\\^$|#]/g, "\\$&");
    punct = "\\?\\.(?!\\d) " + punct;
    punct = punct.replace(/ /g, "|");
    var punct_pattern = new RegExp(punct);
    var line_starters = "continue,try,throw,return,var,let,const,if,switch,case,default,for,while,break,function,import,export".split(",");
    var reserved_words = line_starters.concat(["do", "in", "of", "else", "get", "set", "new", "catch", "finally", "typeof", "yield", "async", "await", "from", "as", "class", "extends"]);
    var reserved_word_pattern = new RegExp("^(?:" + reserved_words.join("|") + ")$");
    var in_html_comment;
    var Tokenizer = function(input_string, options) {
      BaseTokenizer.call(this, input_string, options);
      this._patterns.whitespace = this._patterns.whitespace.matching(
        /\u00A0\u1680\u180e\u2000-\u200a\u202f\u205f\u3000\ufeff/.source,
        /\u2028\u2029/.source
      );
      var pattern_reader = new Pattern(this._input);
      var templatable = new TemplatablePattern(this._input).read_options(this._options);
      this.__patterns = {
        template: templatable,
        identifier: templatable.starting_with(acorn.identifier).matching(acorn.identifierMatch),
        number: pattern_reader.matching(number_pattern),
        punct: pattern_reader.matching(punct_pattern),
        comment: pattern_reader.starting_with(/\/\//).until(/[\n\r\u2028\u2029]/),
        block_comment: pattern_reader.starting_with(/\/\*/).until_after(/\*\//),
        html_comment_start: pattern_reader.matching(/<!--/),
        html_comment_end: pattern_reader.matching(/-->/),
        include: pattern_reader.starting_with(/#include/).until_after(acorn.lineBreak),
        shebang: pattern_reader.starting_with(/#!/).until_after(acorn.lineBreak),
        xml: pattern_reader.matching(/[\s\S]*?<(\/?)([-a-zA-Z:0-9_.]+|{[^}]+?}|!\[CDATA\[[^\]]*?\]\]|)(\s*{[^}]+?}|\s+[-a-zA-Z:0-9_.]+|\s+[-a-zA-Z:0-9_.]+\s*=\s*('[^']*'|"[^"]*"|{([^{}]|{[^}]+?})+?}))*\s*(\/?)\s*>/),
        single_quote: templatable.until(/['\\\n\r\u2028\u2029]/),
        double_quote: templatable.until(/["\\\n\r\u2028\u2029]/),
        template_text: templatable.until(/[`\\$]/),
        template_expression: templatable.until(/[`}\\]/)
      };
    };
    Tokenizer.prototype = new BaseTokenizer();
    Tokenizer.prototype._is_comment = function(current_token) {
      return current_token.type === TOKEN.COMMENT || current_token.type === TOKEN.BLOCK_COMMENT || current_token.type === TOKEN.UNKNOWN;
    };
    Tokenizer.prototype._is_opening = function(current_token) {
      return current_token.type === TOKEN.START_BLOCK || current_token.type === TOKEN.START_EXPR;
    };
    Tokenizer.prototype._is_closing = function(current_token, open_token) {
      return (current_token.type === TOKEN.END_BLOCK || current_token.type === TOKEN.END_EXPR) && (open_token && (current_token.text === "]" && open_token.text === "[" || current_token.text === ")" && open_token.text === "(" || current_token.text === "}" && open_token.text === "{"));
    };
    Tokenizer.prototype._reset = function() {
      in_html_comment = false;
    };
    Tokenizer.prototype._get_next_token = function(previous_token, open_token) {
      var token = null;
      this._readWhitespace();
      var c = this._input.peek();
      if (c === null) {
        return this._create_token(TOKEN.EOF, "");
      }
      token = token || this._read_non_javascript(c);
      token = token || this._read_string(c);
      token = token || this._read_pair(c, this._input.peek(1));
      token = token || this._read_word(previous_token);
      token = token || this._read_singles(c);
      token = token || this._read_comment(c);
      token = token || this._read_regexp(c, previous_token);
      token = token || this._read_xml(c, previous_token);
      token = token || this._read_punctuation();
      token = token || this._create_token(TOKEN.UNKNOWN, this._input.next());
      return token;
    };
    Tokenizer.prototype._read_word = function(previous_token) {
      var resulting_string;
      resulting_string = this.__patterns.identifier.read();
      if (resulting_string !== "") {
        resulting_string = resulting_string.replace(acorn.allLineBreaks, "\n");
        if (!(previous_token.type === TOKEN.DOT || previous_token.type === TOKEN.RESERVED && (previous_token.text === "set" || previous_token.text === "get")) && reserved_word_pattern.test(resulting_string)) {
          if ((resulting_string === "in" || resulting_string === "of") && (previous_token.type === TOKEN.WORD || previous_token.type === TOKEN.STRING)) {
            return this._create_token(TOKEN.OPERATOR, resulting_string);
          }
          return this._create_token(TOKEN.RESERVED, resulting_string);
        }
        return this._create_token(TOKEN.WORD, resulting_string);
      }
      resulting_string = this.__patterns.number.read();
      if (resulting_string !== "") {
        return this._create_token(TOKEN.WORD, resulting_string);
      }
    };
    Tokenizer.prototype._read_singles = function(c) {
      var token = null;
      if (c === "(" || c === "[") {
        token = this._create_token(TOKEN.START_EXPR, c);
      } else if (c === ")" || c === "]") {
        token = this._create_token(TOKEN.END_EXPR, c);
      } else if (c === "{") {
        token = this._create_token(TOKEN.START_BLOCK, c);
      } else if (c === "}") {
        token = this._create_token(TOKEN.END_BLOCK, c);
      } else if (c === ";") {
        token = this._create_token(TOKEN.SEMICOLON, c);
      } else if (c === "." && dot_pattern.test(this._input.peek(1))) {
        token = this._create_token(TOKEN.DOT, c);
      } else if (c === ",") {
        token = this._create_token(TOKEN.COMMA, c);
      }
      if (token) {
        this._input.next();
      }
      return token;
    };
    Tokenizer.prototype._read_pair = function(c, d) {
      var token = null;
      if (c === "#" && d === "{") {
        token = this._create_token(TOKEN.START_BLOCK, c + d);
      }
      if (token) {
        this._input.next();
        this._input.next();
      }
      return token;
    };
    Tokenizer.prototype._read_punctuation = function() {
      var resulting_string = this.__patterns.punct.read();
      if (resulting_string !== "") {
        if (resulting_string === "=") {
          return this._create_token(TOKEN.EQUALS, resulting_string);
        } else if (resulting_string === "?.") {
          return this._create_token(TOKEN.DOT, resulting_string);
        } else {
          return this._create_token(TOKEN.OPERATOR, resulting_string);
        }
      }
    };
    Tokenizer.prototype._read_non_javascript = function(c) {
      var resulting_string = "";
      if (c === "#") {
        if (this._is_first_token()) {
          resulting_string = this.__patterns.shebang.read();
          if (resulting_string) {
            return this._create_token(TOKEN.UNKNOWN, resulting_string.trim() + "\n");
          }
        }
        resulting_string = this.__patterns.include.read();
        if (resulting_string) {
          return this._create_token(TOKEN.UNKNOWN, resulting_string.trim() + "\n");
        }
        c = this._input.next();
        var sharp = "#";
        if (this._input.hasNext() && this._input.testChar(digit)) {
          do {
            c = this._input.next();
            sharp += c;
          } while (this._input.hasNext() && c !== "#" && c !== "=");
          if (c === "#") {
          } else if (this._input.peek() === "[" && this._input.peek(1) === "]") {
            sharp += "[]";
            this._input.next();
            this._input.next();
          } else if (this._input.peek() === "{" && this._input.peek(1) === "}") {
            sharp += "{}";
            this._input.next();
            this._input.next();
          }
          return this._create_token(TOKEN.WORD, sharp);
        }
        this._input.back();
      } else if (c === "<" && this._is_first_token()) {
        resulting_string = this.__patterns.html_comment_start.read();
        if (resulting_string) {
          while (this._input.hasNext() && !this._input.testChar(acorn.newline)) {
            resulting_string += this._input.next();
          }
          in_html_comment = true;
          return this._create_token(TOKEN.COMMENT, resulting_string);
        }
      } else if (in_html_comment && c === "-") {
        resulting_string = this.__patterns.html_comment_end.read();
        if (resulting_string) {
          in_html_comment = false;
          return this._create_token(TOKEN.COMMENT, resulting_string);
        }
      }
      return null;
    };
    Tokenizer.prototype._read_comment = function(c) {
      var token = null;
      if (c === "/") {
        var comment = "";
        if (this._input.peek(1) === "*") {
          comment = this.__patterns.block_comment.read();
          var directives = directives_core.get_directives(comment);
          if (directives && directives.ignore === "start") {
            comment += directives_core.readIgnored(this._input);
          }
          comment = comment.replace(acorn.allLineBreaks, "\n");
          token = this._create_token(TOKEN.BLOCK_COMMENT, comment);
          token.directives = directives;
        } else if (this._input.peek(1) === "/") {
          comment = this.__patterns.comment.read();
          token = this._create_token(TOKEN.COMMENT, comment);
        }
      }
      return token;
    };
    Tokenizer.prototype._read_string = function(c) {
      if (c === "`" || c === "'" || c === '"') {
        var resulting_string = this._input.next();
        this.has_char_escapes = false;
        if (c === "`") {
          resulting_string += this._read_string_recursive("`", true, "${");
        } else {
          resulting_string += this._read_string_recursive(c);
        }
        if (this.has_char_escapes && this._options.unescape_strings) {
          resulting_string = unescape_string(resulting_string);
        }
        if (this._input.peek() === c) {
          resulting_string += this._input.next();
        }
        resulting_string = resulting_string.replace(acorn.allLineBreaks, "\n");
        return this._create_token(TOKEN.STRING, resulting_string);
      }
      return null;
    };
    Tokenizer.prototype._allow_regexp_or_xml = function(previous_token) {
      return previous_token.type === TOKEN.RESERVED && in_array(previous_token.text, ["return", "case", "throw", "else", "do", "typeof", "yield"]) || previous_token.type === TOKEN.END_EXPR && previous_token.text === ")" && previous_token.opened.previous.type === TOKEN.RESERVED && in_array(previous_token.opened.previous.text, ["if", "while", "for"]) || in_array(previous_token.type, [
        TOKEN.COMMENT,
        TOKEN.START_EXPR,
        TOKEN.START_BLOCK,
        TOKEN.START,
        TOKEN.END_BLOCK,
        TOKEN.OPERATOR,
        TOKEN.EQUALS,
        TOKEN.EOF,
        TOKEN.SEMICOLON,
        TOKEN.COMMA
      ]);
    };
    Tokenizer.prototype._read_regexp = function(c, previous_token) {
      if (c === "/" && this._allow_regexp_or_xml(previous_token)) {
        var resulting_string = this._input.next();
        var esc = false;
        var in_char_class = false;
        while (this._input.hasNext() && ((esc || in_char_class || this._input.peek() !== c) && !this._input.testChar(acorn.newline))) {
          resulting_string += this._input.peek();
          if (!esc) {
            esc = this._input.peek() === "\\";
            if (this._input.peek() === "[") {
              in_char_class = true;
            } else if (this._input.peek() === "]") {
              in_char_class = false;
            }
          } else {
            esc = false;
          }
          this._input.next();
        }
        if (this._input.peek() === c) {
          resulting_string += this._input.next();
          resulting_string += this._input.read(acorn.identifier);
        }
        return this._create_token(TOKEN.STRING, resulting_string);
      }
      return null;
    };
    Tokenizer.prototype._read_xml = function(c, previous_token) {
      if (this._options.e4x && c === "<" && this._allow_regexp_or_xml(previous_token)) {
        var xmlStr = "";
        var match = this.__patterns.xml.read_match();
        if (match) {
          var rootTag = match[2].replace(/^{\s+/, "{").replace(/\s+}$/, "}");
          var isCurlyRoot = rootTag.indexOf("{") === 0;
          var depth = 0;
          while (match) {
            var isEndTag = !!match[1];
            var tagName = match[2];
            var isSingletonTag = !!match[match.length - 1] || tagName.slice(0, 8) === "![CDATA[";
            if (!isSingletonTag && (tagName === rootTag || isCurlyRoot && tagName.replace(/^{\s+/, "{").replace(/\s+}$/, "}"))) {
              if (isEndTag) {
                --depth;
              } else {
                ++depth;
              }
            }
            xmlStr += match[0];
            if (depth <= 0) {
              break;
            }
            match = this.__patterns.xml.read_match();
          }
          if (!match) {
            xmlStr += this._input.match(/[\s\S]*/g)[0];
          }
          xmlStr = xmlStr.replace(acorn.allLineBreaks, "\n");
          return this._create_token(TOKEN.STRING, xmlStr);
        }
      }
      return null;
    };
    function unescape_string(s) {
      var out = "", escaped = 0;
      var input_scan = new InputScanner(s);
      var matched = null;
      while (input_scan.hasNext()) {
        matched = input_scan.match(/([\s]|[^\\]|\\\\)+/g);
        if (matched) {
          out += matched[0];
        }
        if (input_scan.peek() === "\\") {
          input_scan.next();
          if (input_scan.peek() === "x") {
            matched = input_scan.match(/x([0-9A-Fa-f]{2})/g);
          } else if (input_scan.peek() === "u") {
            matched = input_scan.match(/u([0-9A-Fa-f]{4})/g);
            if (!matched) {
              matched = input_scan.match(/u\{([0-9A-Fa-f]+)\}/g);
            }
          } else {
            out += "\\";
            if (input_scan.hasNext()) {
              out += input_scan.next();
            }
            continue;
          }
          if (!matched) {
            return s;
          }
          escaped = parseInt(matched[1], 16);
          if (escaped > 126 && escaped <= 255 && matched[0].indexOf("x") === 0) {
            return s;
          } else if (escaped >= 0 && escaped < 32) {
            out += "\\" + matched[0];
          } else if (escaped > 1114111) {
            out += "\\" + matched[0];
          } else if (escaped === 34 || escaped === 39 || escaped === 92) {
            out += "\\" + String.fromCharCode(escaped);
          } else {
            out += String.fromCharCode(escaped);
          }
        }
      }
      return out;
    }
    Tokenizer.prototype._read_string_recursive = function(delimiter, allow_unescaped_newlines, start_sub) {
      var current_char;
      var pattern;
      if (delimiter === "'") {
        pattern = this.__patterns.single_quote;
      } else if (delimiter === '"') {
        pattern = this.__patterns.double_quote;
      } else if (delimiter === "`") {
        pattern = this.__patterns.template_text;
      } else if (delimiter === "}") {
        pattern = this.__patterns.template_expression;
      }
      var resulting_string = pattern.read();
      var next = "";
      while (this._input.hasNext()) {
        next = this._input.next();
        if (next === delimiter || !allow_unescaped_newlines && acorn.newline.test(next)) {
          this._input.back();
          break;
        } else if (next === "\\" && this._input.hasNext()) {
          current_char = this._input.peek();
          if (current_char === "x" || current_char === "u") {
            this.has_char_escapes = true;
          } else if (current_char === "\r" && this._input.peek(1) === "\n") {
            this._input.next();
          }
          next += this._input.next();
        } else if (start_sub) {
          if (start_sub === "${" && next === "$" && this._input.peek() === "{") {
            next += this._input.next();
          }
          if (start_sub === next) {
            if (delimiter === "`") {
              next += this._read_string_recursive("}", allow_unescaped_newlines, "`");
            } else {
              next += this._read_string_recursive("`", allow_unescaped_newlines, "${");
            }
            if (this._input.hasNext()) {
              next += this._input.next();
            }
          }
        }
        next += pattern.read();
        resulting_string += next;
      }
      return resulting_string;
    };
    module2.exports.Tokenizer = Tokenizer;
    module2.exports.TOKEN = TOKEN;
    module2.exports.positionable_operators = positionable_operators.slice();
    module2.exports.line_starters = line_starters.slice();
  }
});

// node_modules/js-beautify/js/src/javascript/beautifier.js
var require_beautifier = __commonJS({
  "node_modules/js-beautify/js/src/javascript/beautifier.js"(exports2, module2) {
    "use strict";
    var Output = require_output().Output;
    var Token = require_token().Token;
    var acorn = require_acorn();
    var Options = require_options2().Options;
    var Tokenizer = require_tokenizer2().Tokenizer;
    var line_starters = require_tokenizer2().line_starters;
    var positionable_operators = require_tokenizer2().positionable_operators;
    var TOKEN = require_tokenizer2().TOKEN;
    function in_array(what, arr) {
      return arr.indexOf(what) !== -1;
    }
    function ltrim(s) {
      return s.replace(/^\s+/g, "");
    }
    function generateMapFromStrings(list) {
      var result = {};
      for (var x = 0; x < list.length; x++) {
        result[list[x].replace(/-/g, "_")] = list[x];
      }
      return result;
    }
    function reserved_word(token, word) {
      return token && token.type === TOKEN.RESERVED && token.text === word;
    }
    function reserved_array(token, words) {
      return token && token.type === TOKEN.RESERVED && in_array(token.text, words);
    }
    var special_words = ["case", "return", "do", "if", "throw", "else", "await", "break", "continue", "async"];
    var validPositionValues = ["before-newline", "after-newline", "preserve-newline"];
    var OPERATOR_POSITION = generateMapFromStrings(validPositionValues);
    var OPERATOR_POSITION_BEFORE_OR_PRESERVE = [OPERATOR_POSITION.before_newline, OPERATOR_POSITION.preserve_newline];
    var MODE = {
      BlockStatement: "BlockStatement",
      Statement: "Statement",
      ObjectLiteral: "ObjectLiteral",
      ArrayLiteral: "ArrayLiteral",
      ForInitializer: "ForInitializer",
      Conditional: "Conditional",
      Expression: "Expression"
    };
    function remove_redundant_indentation(output, frame) {
      if (frame.multiline_frame || frame.mode === MODE.ForInitializer || frame.mode === MODE.Conditional) {
        return;
      }
      output.remove_indent(frame.start_line_index);
    }
    function split_linebreaks(s) {
      s = s.replace(acorn.allLineBreaks, "\n");
      var out = [], idx = s.indexOf("\n");
      while (idx !== -1) {
        out.push(s.substring(0, idx));
        s = s.substring(idx + 1);
        idx = s.indexOf("\n");
      }
      if (s.length) {
        out.push(s);
      }
      return out;
    }
    function is_array(mode) {
      return mode === MODE.ArrayLiteral;
    }
    function is_expression(mode) {
      return in_array(mode, [MODE.Expression, MODE.ForInitializer, MODE.Conditional]);
    }
    function all_lines_start_with(lines, c) {
      for (var i = 0; i < lines.length; i++) {
        var line = lines[i].trim();
        if (line.charAt(0) !== c) {
          return false;
        }
      }
      return true;
    }
    function each_line_matches_indent(lines, indent) {
      var i = 0, len = lines.length, line;
      for (; i < len; i++) {
        line = lines[i];
        if (line && line.indexOf(indent) !== 0) {
          return false;
        }
      }
      return true;
    }
    function Beautifier(source_text, options) {
      options = options || {};
      this._source_text = source_text || "";
      this._output = null;
      this._tokens = null;
      this._last_last_text = null;
      this._flags = null;
      this._previous_flags = null;
      this._flag_store = null;
      this._options = new Options(options);
    }
    Beautifier.prototype.create_flags = function(flags_base, mode) {
      var next_indent_level = 0;
      if (flags_base) {
        next_indent_level = flags_base.indentation_level;
        if (!this._output.just_added_newline() && flags_base.line_indent_level > next_indent_level) {
          next_indent_level = flags_base.line_indent_level;
        }
      }
      var next_flags = {
        mode,
        parent: flags_base,
        last_token: flags_base ? flags_base.last_token : new Token(TOKEN.START_BLOCK, ""),
        last_word: flags_base ? flags_base.last_word : "",
        declaration_statement: false,
        declaration_assignment: false,
        multiline_frame: false,
        inline_frame: false,
        if_block: false,
        else_block: false,
        class_start_block: false,
        do_block: false,
        do_while: false,
        import_block: false,
        in_case_statement: false,
        in_case: false,
        case_body: false,
        case_block: false,
        indentation_level: next_indent_level,
        alignment: 0,
        line_indent_level: flags_base ? flags_base.line_indent_level : next_indent_level,
        start_line_index: this._output.get_line_number(),
        ternary_depth: 0
      };
      return next_flags;
    };
    Beautifier.prototype._reset = function(source_text) {
      var baseIndentString = source_text.match(/^[\t ]*/)[0];
      this._last_last_text = "";
      this._output = new Output(this._options, baseIndentString);
      this._output.raw = this._options.test_output_raw;
      this._flag_store = [];
      this.set_mode(MODE.BlockStatement);
      var tokenizer = new Tokenizer(source_text, this._options);
      this._tokens = tokenizer.tokenize();
      return source_text;
    };
    Beautifier.prototype.beautify = function() {
      if (this._options.disabled) {
        return this._source_text;
      }
      var sweet_code;
      var source_text = this._reset(this._source_text);
      var eol = this._options.eol;
      if (this._options.eol === "auto") {
        eol = "\n";
        if (source_text && acorn.lineBreak.test(source_text || "")) {
          eol = source_text.match(acorn.lineBreak)[0];
        }
      }
      var current_token = this._tokens.next();
      while (current_token) {
        this.handle_token(current_token);
        this._last_last_text = this._flags.last_token.text;
        this._flags.last_token = current_token;
        current_token = this._tokens.next();
      }
      sweet_code = this._output.get_code(eol);
      return sweet_code;
    };
    Beautifier.prototype.handle_token = function(current_token, preserve_statement_flags) {
      if (current_token.type === TOKEN.START_EXPR) {
        this.handle_start_expr(current_token);
      } else if (current_token.type === TOKEN.END_EXPR) {
        this.handle_end_expr(current_token);
      } else if (current_token.type === TOKEN.START_BLOCK) {
        this.handle_start_block(current_token);
      } else if (current_token.type === TOKEN.END_BLOCK) {
        this.handle_end_block(current_token);
      } else if (current_token.type === TOKEN.WORD) {
        this.handle_word(current_token);
      } else if (current_token.type === TOKEN.RESERVED) {
        this.handle_word(current_token);
      } else if (current_token.type === TOKEN.SEMICOLON) {
        this.handle_semicolon(current_token);
      } else if (current_token.type === TOKEN.STRING) {
        this.handle_string(current_token);
      } else if (current_token.type === TOKEN.EQUALS) {
        this.handle_equals(current_token);
      } else if (current_token.type === TOKEN.OPERATOR) {
        this.handle_operator(current_token);
      } else if (current_token.type === TOKEN.COMMA) {
        this.handle_comma(current_token);
      } else if (current_token.type === TOKEN.BLOCK_COMMENT) {
        this.handle_block_comment(current_token, preserve_statement_flags);
      } else if (current_token.type === TOKEN.COMMENT) {
        this.handle_comment(current_token, preserve_statement_flags);
      } else if (current_token.type === TOKEN.DOT) {
        this.handle_dot(current_token);
      } else if (current_token.type === TOKEN.EOF) {
        this.handle_eof(current_token);
      } else if (current_token.type === TOKEN.UNKNOWN) {
        this.handle_unknown(current_token, preserve_statement_flags);
      } else {
        this.handle_unknown(current_token, preserve_statement_flags);
      }
    };
    Beautifier.prototype.handle_whitespace_and_comments = function(current_token, preserve_statement_flags) {
      var newlines = current_token.newlines;
      var keep_whitespace = this._options.keep_array_indentation && is_array(this._flags.mode);
      if (current_token.comments_before) {
        var comment_token = current_token.comments_before.next();
        while (comment_token) {
          this.handle_whitespace_and_comments(comment_token, preserve_statement_flags);
          this.handle_token(comment_token, preserve_statement_flags);
          comment_token = current_token.comments_before.next();
        }
      }
      if (keep_whitespace) {
        for (var i = 0; i < newlines; i += 1) {
          this.print_newline(i > 0, preserve_statement_flags);
        }
      } else {
        if (this._options.max_preserve_newlines && newlines > this._options.max_preserve_newlines) {
          newlines = this._options.max_preserve_newlines;
        }
        if (this._options.preserve_newlines) {
          if (newlines > 1) {
            this.print_newline(false, preserve_statement_flags);
            for (var j = 1; j < newlines; j += 1) {
              this.print_newline(true, preserve_statement_flags);
            }
          }
        }
      }
    };
    var newline_restricted_tokens = ["async", "break", "continue", "return", "throw", "yield"];
    Beautifier.prototype.allow_wrap_or_preserved_newline = function(current_token, force_linewrap) {
      force_linewrap = force_linewrap === void 0 ? false : force_linewrap;
      if (this._output.just_added_newline()) {
        return;
      }
      var shouldPreserveOrForce = this._options.preserve_newlines && current_token.newlines || force_linewrap;
      var operatorLogicApplies = in_array(this._flags.last_token.text, positionable_operators) || in_array(current_token.text, positionable_operators);
      if (operatorLogicApplies) {
        var shouldPrintOperatorNewline = in_array(this._flags.last_token.text, positionable_operators) && in_array(this._options.operator_position, OPERATOR_POSITION_BEFORE_OR_PRESERVE) || in_array(current_token.text, positionable_operators);
        shouldPreserveOrForce = shouldPreserveOrForce && shouldPrintOperatorNewline;
      }
      if (shouldPreserveOrForce) {
        this.print_newline(false, true);
      } else if (this._options.wrap_line_length) {
        if (reserved_array(this._flags.last_token, newline_restricted_tokens)) {
          return;
        }
        this._output.set_wrap_point();
      }
    };
    Beautifier.prototype.print_newline = function(force_newline, preserve_statement_flags) {
      if (!preserve_statement_flags) {
        if (this._flags.last_token.text !== ";" && this._flags.last_token.text !== "," && this._flags.last_token.text !== "=" && (this._flags.last_token.type !== TOKEN.OPERATOR || this._flags.last_token.text === "--" || this._flags.last_token.text === "++")) {
          var next_token = this._tokens.peek();
          while (this._flags.mode === MODE.Statement && !(this._flags.if_block && reserved_word(next_token, "else")) && !this._flags.do_block) {
            this.restore_mode();
          }
        }
      }
      if (this._output.add_new_line(force_newline)) {
        this._flags.multiline_frame = true;
      }
    };
    Beautifier.prototype.print_token_line_indentation = function(current_token) {
      if (this._output.just_added_newline()) {
        if (this._options.keep_array_indentation && current_token.newlines && (current_token.text === "[" || is_array(this._flags.mode))) {
          this._output.current_line.set_indent(-1);
          this._output.current_line.push(current_token.whitespace_before);
          this._output.space_before_token = false;
        } else if (this._output.set_indent(this._flags.indentation_level, this._flags.alignment)) {
          this._flags.line_indent_level = this._flags.indentation_level;
        }
      }
    };
    Beautifier.prototype.print_token = function(current_token) {
      if (this._output.raw) {
        this._output.add_raw_token(current_token);
        return;
      }
      if (this._options.comma_first && current_token.previous && current_token.previous.type === TOKEN.COMMA && this._output.just_added_newline()) {
        if (this._output.previous_line.last() === ",") {
          var popped = this._output.previous_line.pop();
          if (this._output.previous_line.is_empty()) {
            this._output.previous_line.push(popped);
            this._output.trim(true);
            this._output.current_line.pop();
            this._output.trim();
          }
          this.print_token_line_indentation(current_token);
          this._output.add_token(",");
          this._output.space_before_token = true;
        }
      }
      this.print_token_line_indentation(current_token);
      this._output.non_breaking_space = true;
      this._output.add_token(current_token.text);
      if (this._output.previous_token_wrapped) {
        this._flags.multiline_frame = true;
      }
    };
    Beautifier.prototype.indent = function() {
      this._flags.indentation_level += 1;
      this._output.set_indent(this._flags.indentation_level, this._flags.alignment);
    };
    Beautifier.prototype.deindent = function() {
      if (this._flags.indentation_level > 0 && (!this._flags.parent || this._flags.indentation_level > this._flags.parent.indentation_level)) {
        this._flags.indentation_level -= 1;
        this._output.set_indent(this._flags.indentation_level, this._flags.alignment);
      }
    };
    Beautifier.prototype.set_mode = function(mode) {
      if (this._flags) {
        this._flag_store.push(this._flags);
        this._previous_flags = this._flags;
      } else {
        this._previous_flags = this.create_flags(null, mode);
      }
      this._flags = this.create_flags(this._previous_flags, mode);
      this._output.set_indent(this._flags.indentation_level, this._flags.alignment);
    };
    Beautifier.prototype.restore_mode = function() {
      if (this._flag_store.length > 0) {
        this._previous_flags = this._flags;
        this._flags = this._flag_store.pop();
        if (this._previous_flags.mode === MODE.Statement) {
          remove_redundant_indentation(this._output, this._previous_flags);
        }
        this._output.set_indent(this._flags.indentation_level, this._flags.alignment);
      }
    };
    Beautifier.prototype.start_of_object_property = function() {
      return this._flags.parent.mode === MODE.ObjectLiteral && this._flags.mode === MODE.Statement && (this._flags.last_token.text === ":" && this._flags.ternary_depth === 0 || reserved_array(this._flags.last_token, ["get", "set"]));
    };
    Beautifier.prototype.start_of_statement = function(current_token) {
      var start = false;
      start = start || reserved_array(this._flags.last_token, ["var", "let", "const"]) && current_token.type === TOKEN.WORD;
      start = start || reserved_word(this._flags.last_token, "do");
      start = start || !(this._flags.parent.mode === MODE.ObjectLiteral && this._flags.mode === MODE.Statement) && reserved_array(this._flags.last_token, newline_restricted_tokens) && !current_token.newlines;
      start = start || reserved_word(this._flags.last_token, "else") && !(reserved_word(current_token, "if") && !current_token.comments_before);
      start = start || this._flags.last_token.type === TOKEN.END_EXPR && (this._previous_flags.mode === MODE.ForInitializer || this._previous_flags.mode === MODE.Conditional);
      start = start || this._flags.last_token.type === TOKEN.WORD && this._flags.mode === MODE.BlockStatement && !this._flags.in_case && !(current_token.text === "--" || current_token.text === "++") && this._last_last_text !== "function" && current_token.type !== TOKEN.WORD && current_token.type !== TOKEN.RESERVED;
      start = start || this._flags.mode === MODE.ObjectLiteral && (this._flags.last_token.text === ":" && this._flags.ternary_depth === 0 || reserved_array(this._flags.last_token, ["get", "set"]));
      if (start) {
        this.set_mode(MODE.Statement);
        this.indent();
        this.handle_whitespace_and_comments(current_token, true);
        if (!this.start_of_object_property()) {
          this.allow_wrap_or_preserved_newline(
            current_token,
            reserved_array(current_token, ["do", "for", "if", "while"])
          );
        }
        return true;
      }
      return false;
    };
    Beautifier.prototype.handle_start_expr = function(current_token) {
      if (!this.start_of_statement(current_token)) {
        this.handle_whitespace_and_comments(current_token);
      }
      var next_mode = MODE.Expression;
      if (current_token.text === "[") {
        if (this._flags.last_token.type === TOKEN.WORD || this._flags.last_token.text === ")") {
          if (reserved_array(this._flags.last_token, line_starters)) {
            this._output.space_before_token = true;
          }
          this.print_token(current_token);
          this.set_mode(next_mode);
          this.indent();
          if (this._options.space_in_paren) {
            this._output.space_before_token = true;
          }
          return;
        }
        next_mode = MODE.ArrayLiteral;
        if (is_array(this._flags.mode)) {
          if (this._flags.last_token.text === "[" || this._flags.last_token.text === "," && (this._last_last_text === "]" || this._last_last_text === "}")) {
            if (!this._options.keep_array_indentation) {
              this.print_newline();
            }
          }
        }
        if (!in_array(this._flags.last_token.type, [TOKEN.START_EXPR, TOKEN.END_EXPR, TOKEN.WORD, TOKEN.OPERATOR, TOKEN.DOT])) {
          this._output.space_before_token = true;
        }
      } else {
        if (this._flags.last_token.type === TOKEN.RESERVED) {
          if (this._flags.last_token.text === "for") {
            this._output.space_before_token = this._options.space_before_conditional;
            next_mode = MODE.ForInitializer;
          } else if (in_array(this._flags.last_token.text, ["if", "while", "switch"])) {
            this._output.space_before_token = this._options.space_before_conditional;
            next_mode = MODE.Conditional;
          } else if (in_array(this._flags.last_word, ["await", "async"])) {
            this._output.space_before_token = true;
          } else if (this._flags.last_token.text === "import" && current_token.whitespace_before === "") {
            this._output.space_before_token = false;
          } else if (in_array(this._flags.last_token.text, line_starters) || this._flags.last_token.text === "catch") {
            this._output.space_before_token = true;
          }
        } else if (this._flags.last_token.type === TOKEN.EQUALS || this._flags.last_token.type === TOKEN.OPERATOR) {
          if (!this.start_of_object_property()) {
            this.allow_wrap_or_preserved_newline(current_token);
          }
        } else if (this._flags.last_token.type === TOKEN.WORD) {
          this._output.space_before_token = false;
          var peek_back_two = this._tokens.peek(-3);
          if (this._options.space_after_named_function && peek_back_two) {
            var peek_back_three = this._tokens.peek(-4);
            if (reserved_array(peek_back_two, ["async", "function"]) || peek_back_two.text === "*" && reserved_array(peek_back_three, ["async", "function"])) {
              this._output.space_before_token = true;
            } else if (this._flags.mode === MODE.ObjectLiteral) {
              if (peek_back_two.text === "{" || peek_back_two.text === "," || peek_back_two.text === "*" && (peek_back_three.text === "{" || peek_back_three.text === ",")) {
                this._output.space_before_token = true;
              }
            } else if (this._flags.parent && this._flags.parent.class_start_block) {
              this._output.space_before_token = true;
            }
          }
        } else {
          this.allow_wrap_or_preserved_newline(current_token);
        }
        if (this._flags.last_token.type === TOKEN.RESERVED && (this._flags.last_word === "function" || this._flags.last_word === "typeof") || this._flags.last_token.text === "*" && (in_array(this._last_last_text, ["function", "yield"]) || this._flags.mode === MODE.ObjectLiteral && in_array(this._last_last_text, ["{", ","]))) {
          this._output.space_before_token = this._options.space_after_anon_function;
        }
      }
      if (this._flags.last_token.text === ";" || this._flags.last_token.type === TOKEN.START_BLOCK) {
        this.print_newline();
      } else if (this._flags.last_token.type === TOKEN.END_EXPR || this._flags.last_token.type === TOKEN.START_EXPR || this._flags.last_token.type === TOKEN.END_BLOCK || this._flags.last_token.text === "." || this._flags.last_token.type === TOKEN.COMMA) {
        this.allow_wrap_or_preserved_newline(current_token, current_token.newlines);
      }
      this.print_token(current_token);
      this.set_mode(next_mode);
      if (this._options.space_in_paren) {
        this._output.space_before_token = true;
      }
      this.indent();
    };
    Beautifier.prototype.handle_end_expr = function(current_token) {
      while (this._flags.mode === MODE.Statement) {
        this.restore_mode();
      }
      this.handle_whitespace_and_comments(current_token);
      if (this._flags.multiline_frame) {
        this.allow_wrap_or_preserved_newline(
          current_token,
          current_token.text === "]" && is_array(this._flags.mode) && !this._options.keep_array_indentation
        );
      }
      if (this._options.space_in_paren) {
        if (this._flags.last_token.type === TOKEN.START_EXPR && !this._options.space_in_empty_paren) {
          this._output.trim();
          this._output.space_before_token = false;
        } else {
          this._output.space_before_token = true;
        }
      }
      this.deindent();
      this.print_token(current_token);
      this.restore_mode();
      remove_redundant_indentation(this._output, this._previous_flags);
      if (this._flags.do_while && this._previous_flags.mode === MODE.Conditional) {
        this._previous_flags.mode = MODE.Expression;
        this._flags.do_block = false;
        this._flags.do_while = false;
      }
    };
    Beautifier.prototype.handle_start_block = function(current_token) {
      this.handle_whitespace_and_comments(current_token);
      var next_token = this._tokens.peek();
      var second_token = this._tokens.peek(1);
      if (this._flags.last_word === "switch" && this._flags.last_token.type === TOKEN.END_EXPR) {
        this.set_mode(MODE.BlockStatement);
        this._flags.in_case_statement = true;
      } else if (this._flags.case_body) {
        this.set_mode(MODE.BlockStatement);
      } else if (second_token && (in_array(second_token.text, [":", ","]) && in_array(next_token.type, [TOKEN.STRING, TOKEN.WORD, TOKEN.RESERVED]) || in_array(next_token.text, ["get", "set", "..."]) && in_array(second_token.type, [TOKEN.WORD, TOKEN.RESERVED]))) {
        if (in_array(this._last_last_text, ["class", "interface"]) && !in_array(second_token.text, [":", ","])) {
          this.set_mode(MODE.BlockStatement);
        } else {
          this.set_mode(MODE.ObjectLiteral);
        }
      } else if (this._flags.last_token.type === TOKEN.OPERATOR && this._flags.last_token.text === "=>") {
        this.set_mode(MODE.BlockStatement);
      } else if (in_array(this._flags.last_token.type, [TOKEN.EQUALS, TOKEN.START_EXPR, TOKEN.COMMA, TOKEN.OPERATOR]) || reserved_array(this._flags.last_token, ["return", "throw", "import", "default"])) {
        this.set_mode(MODE.ObjectLiteral);
      } else {
        this.set_mode(MODE.BlockStatement);
      }
      if (this._flags.last_token) {
        if (reserved_array(this._flags.last_token.previous, ["class", "extends"])) {
          this._flags.class_start_block = true;
        }
      }
      var empty_braces = !next_token.comments_before && next_token.text === "}";
      var empty_anonymous_function = empty_braces && this._flags.last_word === "function" && this._flags.last_token.type === TOKEN.END_EXPR;
      if (this._options.brace_preserve_inline) {
        var index = 0;
        var check_token = null;
        this._flags.inline_frame = true;
        do {
          index += 1;
          check_token = this._tokens.peek(index - 1);
          if (check_token.newlines) {
            this._flags.inline_frame = false;
            break;
          }
        } while (check_token.type !== TOKEN.EOF && !(check_token.type === TOKEN.END_BLOCK && check_token.opened === current_token));
      }
      if ((this._options.brace_style === "expand" || this._options.brace_style === "none" && current_token.newlines) && !this._flags.inline_frame) {
        if (this._flags.last_token.type !== TOKEN.OPERATOR && (empty_anonymous_function || this._flags.last_token.type === TOKEN.EQUALS || reserved_array(this._flags.last_token, special_words) && this._flags.last_token.text !== "else")) {
          this._output.space_before_token = true;
        } else {
          this.print_newline(false, true);
        }
      } else {
        if (is_array(this._previous_flags.mode) && (this._flags.last_token.type === TOKEN.START_EXPR || this._flags.last_token.type === TOKEN.COMMA)) {
          if (this._flags.last_token.type === TOKEN.COMMA || this._options.space_in_paren) {
            this._output.space_before_token = true;
          }
          if (this._flags.last_token.type === TOKEN.COMMA || this._flags.last_token.type === TOKEN.START_EXPR && this._flags.inline_frame) {
            this.allow_wrap_or_preserved_newline(current_token);
            this._previous_flags.multiline_frame = this._previous_flags.multiline_frame || this._flags.multiline_frame;
            this._flags.multiline_frame = false;
          }
        }
        if (this._flags.last_token.type !== TOKEN.OPERATOR && this._flags.last_token.type !== TOKEN.START_EXPR) {
          if (in_array(this._flags.last_token.type, [TOKEN.START_BLOCK, TOKEN.SEMICOLON]) && !this._flags.inline_frame) {
            this.print_newline();
          } else {
            this._output.space_before_token = true;
          }
        }
      }
      this.print_token(current_token);
      this.indent();
      if (!empty_braces && !(this._options.brace_preserve_inline && this._flags.inline_frame)) {
        this.print_newline();
      }
    };
    Beautifier.prototype.handle_end_block = function(current_token) {
      this.handle_whitespace_and_comments(current_token);
      while (this._flags.mode === MODE.Statement) {
        this.restore_mode();
      }
      var empty_braces = this._flags.last_token.type === TOKEN.START_BLOCK;
      if (this._flags.inline_frame && !empty_braces) {
        this._output.space_before_token = true;
      } else if (this._options.brace_style === "expand") {
        if (!empty_braces) {
          this.print_newline();
        }
      } else {
        if (!empty_braces) {
          if (is_array(this._flags.mode) && this._options.keep_array_indentation) {
            this._options.keep_array_indentation = false;
            this.print_newline();
            this._options.keep_array_indentation = true;
          } else {
            this.print_newline();
          }
        }
      }
      this.restore_mode();
      this.print_token(current_token);
    };
    Beautifier.prototype.handle_word = function(current_token) {
      if (current_token.type === TOKEN.RESERVED) {
        if (in_array(current_token.text, ["set", "get"]) && this._flags.mode !== MODE.ObjectLiteral) {
          current_token.type = TOKEN.WORD;
        } else if (current_token.text === "import" && in_array(this._tokens.peek().text, ["(", "."])) {
          current_token.type = TOKEN.WORD;
        } else if (in_array(current_token.text, ["as", "from"]) && !this._flags.import_block) {
          current_token.type = TOKEN.WORD;
        } else if (this._flags.mode === MODE.ObjectLiteral) {
          var next_token = this._tokens.peek();
          if (next_token.text === ":") {
            current_token.type = TOKEN.WORD;
          }
        }
      }
      if (this.start_of_statement(current_token)) {
        if (reserved_array(this._flags.last_token, ["var", "let", "const"]) && current_token.type === TOKEN.WORD) {
          this._flags.declaration_statement = true;
        }
      } else if (current_token.newlines && !is_expression(this._flags.mode) && (this._flags.last_token.type !== TOKEN.OPERATOR || (this._flags.last_token.text === "--" || this._flags.last_token.text === "++")) && this._flags.last_token.type !== TOKEN.EQUALS && (this._options.preserve_newlines || !reserved_array(this._flags.last_token, ["var", "let", "const", "set", "get"]))) {
        this.handle_whitespace_and_comments(current_token);
        this.print_newline();
      } else {
        this.handle_whitespace_and_comments(current_token);
      }
      if (this._flags.do_block && !this._flags.do_while) {
        if (reserved_word(current_token, "while")) {
          this._output.space_before_token = true;
          this.print_token(current_token);
          this._output.space_before_token = true;
          this._flags.do_while = true;
          return;
        } else {
          this.print_newline();
          this._flags.do_block = false;
        }
      }
      if (this._flags.if_block) {
        if (!this._flags.else_block && reserved_word(current_token, "else")) {
          this._flags.else_block = true;
        } else {
          while (this._flags.mode === MODE.Statement) {
            this.restore_mode();
          }
          this._flags.if_block = false;
          this._flags.else_block = false;
        }
      }
      if (this._flags.in_case_statement && reserved_array(current_token, ["case", "default"])) {
        this.print_newline();
        if (!this._flags.case_block && (this._flags.case_body || this._options.jslint_happy)) {
          this.deindent();
        }
        this._flags.case_body = false;
        this.print_token(current_token);
        this._flags.in_case = true;
        return;
      }
      if (this._flags.last_token.type === TOKEN.COMMA || this._flags.last_token.type === TOKEN.START_EXPR || this._flags.last_token.type === TOKEN.EQUALS || this._flags.last_token.type === TOKEN.OPERATOR) {
        if (!this.start_of_object_property() && !(in_array(this._flags.last_token.text, ["+", "-"]) && this._last_last_text === ":" && this._flags.parent.mode === MODE.ObjectLiteral)) {
          this.allow_wrap_or_preserved_newline(current_token);
        }
      }
      if (reserved_word(current_token, "function")) {
        if (in_array(this._flags.last_token.text, ["}", ";"]) || this._output.just_added_newline() && !(in_array(this._flags.last_token.text, ["(", "[", "{", ":", "=", ","]) || this._flags.last_token.type === TOKEN.OPERATOR)) {
          if (!this._output.just_added_blankline() && !current_token.comments_before) {
            this.print_newline();
            this.print_newline(true);
          }
        }
        if (this._flags.last_token.type === TOKEN.RESERVED || this._flags.last_token.type === TOKEN.WORD) {
          if (reserved_array(this._flags.last_token, ["get", "set", "new", "export"]) || reserved_array(this._flags.last_token, newline_restricted_tokens)) {
            this._output.space_before_token = true;
          } else if (reserved_word(this._flags.last_token, "default") && this._last_last_text === "export") {
            this._output.space_before_token = true;
          } else if (this._flags.last_token.text === "declare") {
            this._output.space_before_token = true;
          } else {
            this.print_newline();
          }
        } else if (this._flags.last_token.type === TOKEN.OPERATOR || this._flags.last_token.text === "=") {
          this._output.space_before_token = true;
        } else if (!this._flags.multiline_frame && (is_expression(this._flags.mode) || is_array(this._flags.mode))) {
        } else {
          this.print_newline();
        }
        this.print_token(current_token);
        this._flags.last_word = current_token.text;
        return;
      }
      var prefix = "NONE";
      if (this._flags.last_token.type === TOKEN.END_BLOCK) {
        if (this._previous_flags.inline_frame) {
          prefix = "SPACE";
        } else if (!reserved_array(current_token, ["else", "catch", "finally", "from"])) {
          prefix = "NEWLINE";
        } else {
          if (this._options.brace_style === "expand" || this._options.brace_style === "end-expand" || this._options.brace_style === "none" && current_token.newlines) {
            prefix = "NEWLINE";
          } else {
            prefix = "SPACE";
            this._output.space_before_token = true;
          }
        }
      } else if (this._flags.last_token.type === TOKEN.SEMICOLON && this._flags.mode === MODE.BlockStatement) {
        prefix = "NEWLINE";
      } else if (this._flags.last_token.type === TOKEN.SEMICOLON && is_expression(this._flags.mode)) {
        prefix = "SPACE";
      } else if (this._flags.last_token.type === TOKEN.STRING) {
        prefix = "NEWLINE";
      } else if (this._flags.last_token.type === TOKEN.RESERVED || this._flags.last_token.type === TOKEN.WORD || this._flags.last_token.text === "*" && (in_array(this._last_last_text, ["function", "yield"]) || this._flags.mode === MODE.ObjectLiteral && in_array(this._last_last_text, ["{", ","]))) {
        prefix = "SPACE";
      } else if (this._flags.last_token.type === TOKEN.START_BLOCK) {
        if (this._flags.inline_frame) {
          prefix = "SPACE";
        } else {
          prefix = "NEWLINE";
        }
      } else if (this._flags.last_token.type === TOKEN.END_EXPR) {
        this._output.space_before_token = true;
        prefix = "NEWLINE";
      }
      if (reserved_array(current_token, line_starters) && this._flags.last_token.text !== ")") {
        if (this._flags.inline_frame || this._flags.last_token.text === "else" || this._flags.last_token.text === "export") {
          prefix = "SPACE";
        } else {
          prefix = "NEWLINE";
        }
      }
      if (reserved_array(current_token, ["else", "catch", "finally"])) {
        if ((!(this._flags.last_token.type === TOKEN.END_BLOCK && this._previous_flags.mode === MODE.BlockStatement) || this._options.brace_style === "expand" || this._options.brace_style === "end-expand" || this._options.brace_style === "none" && current_token.newlines) && !this._flags.inline_frame) {
          this.print_newline();
        } else {
          this._output.trim(true);
          var line = this._output.current_line;
          if (line.last() !== "}") {
            this.print_newline();
          }
          this._output.space_before_token = true;
        }
      } else if (prefix === "NEWLINE") {
        if (reserved_array(this._flags.last_token, special_words)) {
          this._output.space_before_token = true;
        } else if (this._flags.last_token.text === "declare" && reserved_array(current_token, ["var", "let", "const"])) {
          this._output.space_before_token = true;
        } else if (this._flags.last_token.type !== TOKEN.END_EXPR) {
          if ((this._flags.last_token.type !== TOKEN.START_EXPR || !reserved_array(current_token, ["var", "let", "const"])) && this._flags.last_token.text !== ":") {
            if (reserved_word(current_token, "if") && reserved_word(current_token.previous, "else")) {
              this._output.space_before_token = true;
            } else {
              this.print_newline();
            }
          }
        } else if (reserved_array(current_token, line_starters) && this._flags.last_token.text !== ")") {
          this.print_newline();
        }
      } else if (this._flags.multiline_frame && is_array(this._flags.mode) && this._flags.last_token.text === "," && this._last_last_text === "}") {
        this.print_newline();
      } else if (prefix === "SPACE") {
        this._output.space_before_token = true;
      }
      if (current_token.previous && (current_token.previous.type === TOKEN.WORD || current_token.previous.type === TOKEN.RESERVED)) {
        this._output.space_before_token = true;
      }
      this.print_token(current_token);
      this._flags.last_word = current_token.text;
      if (current_token.type === TOKEN.RESERVED) {
        if (current_token.text === "do") {
          this._flags.do_block = true;
        } else if (current_token.text === "if") {
          this._flags.if_block = true;
        } else if (current_token.text === "import") {
          this._flags.import_block = true;
        } else if (this._flags.import_block && reserved_word(current_token, "from")) {
          this._flags.import_block = false;
        }
      }
    };
    Beautifier.prototype.handle_semicolon = function(current_token) {
      if (this.start_of_statement(current_token)) {
        this._output.space_before_token = false;
      } else {
        this.handle_whitespace_and_comments(current_token);
      }
      var next_token = this._tokens.peek();
      while (this._flags.mode === MODE.Statement && !(this._flags.if_block && reserved_word(next_token, "else")) && !this._flags.do_block) {
        this.restore_mode();
      }
      if (this._flags.import_block) {
        this._flags.import_block = false;
      }
      this.print_token(current_token);
    };
    Beautifier.prototype.handle_string = function(current_token) {
      if (current_token.text.startsWith("`") && current_token.newlines === 0 && current_token.whitespace_before === "" && (current_token.previous.text === ")" || this._flags.last_token.type === TOKEN.WORD)) {
      } else if (this.start_of_statement(current_token)) {
        this._output.space_before_token = true;
      } else {
        this.handle_whitespace_and_comments(current_token);
        if (this._flags.last_token.type === TOKEN.RESERVED || this._flags.last_token.type === TOKEN.WORD || this._flags.inline_frame) {
          this._output.space_before_token = true;
        } else if (this._flags.last_token.type === TOKEN.COMMA || this._flags.last_token.type === TOKEN.START_EXPR || this._flags.last_token.type === TOKEN.EQUALS || this._flags.last_token.type === TOKEN.OPERATOR) {
          if (!this.start_of_object_property()) {
            this.allow_wrap_or_preserved_newline(current_token);
          }
        } else if (current_token.text.startsWith("`") && this._flags.last_token.type === TOKEN.END_EXPR && (current_token.previous.text === "]" || current_token.previous.text === ")") && current_token.newlines === 0) {
          this._output.space_before_token = true;
        } else {
          this.print_newline();
        }
      }
      this.print_token(current_token);
    };
    Beautifier.prototype.handle_equals = function(current_token) {
      if (this.start_of_statement(current_token)) {
      } else {
        this.handle_whitespace_and_comments(current_token);
      }
      if (this._flags.declaration_statement) {
        this._flags.declaration_assignment = true;
      }
      this._output.space_before_token = true;
      this.print_token(current_token);
      this._output.space_before_token = true;
    };
    Beautifier.prototype.handle_comma = function(current_token) {
      this.handle_whitespace_and_comments(current_token, true);
      this.print_token(current_token);
      this._output.space_before_token = true;
      if (this._flags.declaration_statement) {
        if (is_expression(this._flags.parent.mode)) {
          this._flags.declaration_assignment = false;
        }
        if (this._flags.declaration_assignment) {
          this._flags.declaration_assignment = false;
          this.print_newline(false, true);
        } else if (this._options.comma_first) {
          this.allow_wrap_or_preserved_newline(current_token);
        }
      } else if (this._flags.mode === MODE.ObjectLiteral || this._flags.mode === MODE.Statement && this._flags.parent.mode === MODE.ObjectLiteral) {
        if (this._flags.mode === MODE.Statement) {
          this.restore_mode();
        }
        if (!this._flags.inline_frame) {
          this.print_newline();
        }
      } else if (this._options.comma_first) {
        this.allow_wrap_or_preserved_newline(current_token);
      }
    };
    Beautifier.prototype.handle_operator = function(current_token) {
      var isGeneratorAsterisk = current_token.text === "*" && (reserved_array(this._flags.last_token, ["function", "yield"]) || in_array(this._flags.last_token.type, [TOKEN.START_BLOCK, TOKEN.COMMA, TOKEN.END_BLOCK, TOKEN.SEMICOLON]));
      var isUnary = in_array(current_token.text, ["-", "+"]) && (in_array(this._flags.last_token.type, [TOKEN.START_BLOCK, TOKEN.START_EXPR, TOKEN.EQUALS, TOKEN.OPERATOR]) || in_array(this._flags.last_token.text, line_starters) || this._flags.last_token.text === ",");
      if (this.start_of_statement(current_token)) {
      } else {
        var preserve_statement_flags = !isGeneratorAsterisk;
        this.handle_whitespace_and_comments(current_token, preserve_statement_flags);
      }
      if (current_token.text === "*" && this._flags.last_token.type === TOKEN.DOT) {
        this.print_token(current_token);
        return;
      }
      if (current_token.text === "::") {
        this.print_token(current_token);
        return;
      }
      if (in_array(current_token.text, ["-", "+"]) && this.start_of_object_property()) {
        this.print_token(current_token);
        return;
      }
      if (this._flags.last_token.type === TOKEN.OPERATOR && in_array(this._options.operator_position, OPERATOR_POSITION_BEFORE_OR_PRESERVE)) {
        this.allow_wrap_or_preserved_newline(current_token);
      }
      if (current_token.text === ":" && this._flags.in_case) {
        this.print_token(current_token);
        this._flags.in_case = false;
        this._flags.case_body = true;
        if (this._tokens.peek().type !== TOKEN.START_BLOCK) {
          this.indent();
          this.print_newline();
          this._flags.case_block = false;
        } else {
          this._flags.case_block = true;
          this._output.space_before_token = true;
        }
        return;
      }
      var space_before = true;
      var space_after = true;
      var in_ternary = false;
      if (current_token.text === ":") {
        if (this._flags.ternary_depth === 0) {
          space_before = false;
        } else {
          this._flags.ternary_depth -= 1;
          in_ternary = true;
        }
      } else if (current_token.text === "?") {
        this._flags.ternary_depth += 1;
      }
      if (!isUnary && !isGeneratorAsterisk && this._options.preserve_newlines && in_array(current_token.text, positionable_operators)) {
        var isColon = current_token.text === ":";
        var isTernaryColon = isColon && in_ternary;
        var isOtherColon = isColon && !in_ternary;
        switch (this._options.operator_position) {
          case OPERATOR_POSITION.before_newline:
            this._output.space_before_token = !isOtherColon;
            this.print_token(current_token);
            if (!isColon || isTernaryColon) {
              this.allow_wrap_or_preserved_newline(current_token);
            }
            this._output.space_before_token = true;
            return;
          case OPERATOR_POSITION.after_newline:
            this._output.space_before_token = true;
            if (!isColon || isTernaryColon) {
              if (this._tokens.peek().newlines) {
                this.print_newline(false, true);
              } else {
                this.allow_wrap_or_preserved_newline(current_token);
              }
            } else {
              this._output.space_before_token = false;
            }
            this.print_token(current_token);
            this._output.space_before_token = true;
            return;
          case OPERATOR_POSITION.preserve_newline:
            if (!isOtherColon) {
              this.allow_wrap_or_preserved_newline(current_token);
            }
            space_before = !(this._output.just_added_newline() || isOtherColon);
            this._output.space_before_token = space_before;
            this.print_token(current_token);
            this._output.space_before_token = true;
            return;
        }
      }
      if (isGeneratorAsterisk) {
        this.allow_wrap_or_preserved_newline(current_token);
        space_before = false;
        var next_token = this._tokens.peek();
        space_after = next_token && in_array(next_token.type, [TOKEN.WORD, TOKEN.RESERVED]);
      } else if (current_token.text === "...") {
        this.allow_wrap_or_preserved_newline(current_token);
        space_before = this._flags.last_token.type === TOKEN.START_BLOCK;
        space_after = false;
      } else if (in_array(current_token.text, ["--", "++", "!", "~"]) || isUnary) {
        if (this._flags.last_token.type === TOKEN.COMMA || this._flags.last_token.type === TOKEN.START_EXPR) {
          this.allow_wrap_or_preserved_newline(current_token);
        }
        space_before = false;
        space_after = false;
        if (current_token.newlines && (current_token.text === "--" || current_token.text === "++" || current_token.text === "~")) {
          var new_line_needed = reserved_array(this._flags.last_token, special_words) && current_token.newlines;
          if (new_line_needed && (this._previous_flags.if_block || this._previous_flags.else_block)) {
            this.restore_mode();
          }
          this.print_newline(new_line_needed, true);
        }
        if (this._flags.last_token.text === ";" && is_expression(this._flags.mode)) {
          space_before = true;
        }
        if (this._flags.last_token.type === TOKEN.RESERVED) {
          space_before = true;
        } else if (this._flags.last_token.type === TOKEN.END_EXPR) {
          space_before = !(this._flags.last_token.text === "]" && (current_token.text === "--" || current_token.text === "++"));
        } else if (this._flags.last_token.type === TOKEN.OPERATOR) {
          space_before = in_array(current_token.text, ["--", "-", "++", "+"]) && in_array(this._flags.last_token.text, ["--", "-", "++", "+"]);
          if (in_array(current_token.text, ["+", "-"]) && in_array(this._flags.last_token.text, ["--", "++"])) {
            space_after = true;
          }
        }
        if ((this._flags.mode === MODE.BlockStatement && !this._flags.inline_frame || this._flags.mode === MODE.Statement) && (this._flags.last_token.text === "{" || this._flags.last_token.text === ";")) {
          this.print_newline();
        }
      }
      this._output.space_before_token = this._output.space_before_token || space_before;
      this.print_token(current_token);
      this._output.space_before_token = space_after;
    };
    Beautifier.prototype.handle_block_comment = function(current_token, preserve_statement_flags) {
      if (this._output.raw) {
        this._output.add_raw_token(current_token);
        if (current_token.directives && current_token.directives.preserve === "end") {
          this._output.raw = this._options.test_output_raw;
        }
        return;
      }
      if (current_token.directives) {
        this.print_newline(false, preserve_statement_flags);
        this.print_token(current_token);
        if (current_token.directives.preserve === "start") {
          this._output.raw = true;
        }
        this.print_newline(false, true);
        return;
      }
      if (!acorn.newline.test(current_token.text) && !current_token.newlines) {
        this._output.space_before_token = true;
        this.print_token(current_token);
        this._output.space_before_token = true;
        return;
      } else {
        this.print_block_commment(current_token, preserve_statement_flags);
      }
    };
    Beautifier.prototype.print_block_commment = function(current_token, preserve_statement_flags) {
      var lines = split_linebreaks(current_token.text);
      var j;
      var javadoc = false;
      var starless = false;
      var lastIndent = current_token.whitespace_before;
      var lastIndentLength = lastIndent.length;
      this.print_newline(false, preserve_statement_flags);
      this.print_token_line_indentation(current_token);
      this._output.add_token(lines[0]);
      this.print_newline(false, preserve_statement_flags);
      if (lines.length > 1) {
        lines = lines.slice(1);
        javadoc = all_lines_start_with(lines, "*");
        starless = each_line_matches_indent(lines, lastIndent);
        if (javadoc) {
          this._flags.alignment = 1;
        }
        for (j = 0; j < lines.length; j++) {
          if (javadoc) {
            this.print_token_line_indentation(current_token);
            this._output.add_token(ltrim(lines[j]));
          } else if (starless && lines[j]) {
            this.print_token_line_indentation(current_token);
            this._output.add_token(lines[j].substring(lastIndentLength));
          } else {
            this._output.current_line.set_indent(-1);
            this._output.add_token(lines[j]);
          }
          this.print_newline(false, preserve_statement_flags);
        }
        this._flags.alignment = 0;
      }
    };
    Beautifier.prototype.handle_comment = function(current_token, preserve_statement_flags) {
      if (current_token.newlines) {
        this.print_newline(false, preserve_statement_flags);
      } else {
        this._output.trim(true);
      }
      this._output.space_before_token = true;
      this.print_token(current_token);
      this.print_newline(false, preserve_statement_flags);
    };
    Beautifier.prototype.handle_dot = function(current_token) {
      if (this.start_of_statement(current_token)) {
      } else {
        this.handle_whitespace_and_comments(current_token, true);
      }
      if (this._flags.last_token.text.match("^[0-9]+$")) {
        this._output.space_before_token = true;
      }
      if (reserved_array(this._flags.last_token, special_words)) {
        this._output.space_before_token = false;
      } else {
        this.allow_wrap_or_preserved_newline(
          current_token,
          this._flags.last_token.text === ")" && this._options.break_chained_methods
        );
      }
      if (this._options.unindent_chained_methods && this._output.just_added_newline()) {
        this.deindent();
      }
      this.print_token(current_token);
    };
    Beautifier.prototype.handle_unknown = function(current_token, preserve_statement_flags) {
      this.print_token(current_token);
      if (current_token.text[current_token.text.length - 1] === "\n") {
        this.print_newline(false, preserve_statement_flags);
      }
    };
    Beautifier.prototype.handle_eof = function(current_token) {
      while (this._flags.mode === MODE.Statement) {
        this.restore_mode();
      }
      this.handle_whitespace_and_comments(current_token);
    };
    module2.exports.Beautifier = Beautifier;
  }
});

// node_modules/js-beautify/js/src/javascript/index.js
var require_javascript = __commonJS({
  "node_modules/js-beautify/js/src/javascript/index.js"(exports2, module2) {
    "use strict";
    var Beautifier = require_beautifier().Beautifier;
    var Options = require_options2().Options;
    function js_beautify(js_source_text, options) {
      var beautifier = new Beautifier(js_source_text, options);
      return beautifier.beautify();
    }
    module2.exports = js_beautify;
    module2.exports.defaultOptions = function() {
      return new Options();
    };
  }
});

// node_modules/js-beautify/js/src/css/options.js
var require_options3 = __commonJS({
  "node_modules/js-beautify/js/src/css/options.js"(exports2, module2) {
    "use strict";
    var BaseOptions = require_options().Options;
    function Options(options) {
      BaseOptions.call(this, options, "css");
      this.selector_separator_newline = this._get_boolean("selector_separator_newline", true);
      this.newline_between_rules = this._get_boolean("newline_between_rules", true);
      var space_around_selector_separator = this._get_boolean("space_around_selector_separator");
      this.space_around_combinator = this._get_boolean("space_around_combinator") || space_around_selector_separator;
      var brace_style_split = this._get_selection_list("brace_style", ["collapse", "expand", "end-expand", "none", "preserve-inline"]);
      this.brace_style = "collapse";
      for (var bs = 0; bs < brace_style_split.length; bs++) {
        if (brace_style_split[bs] !== "expand") {
          this.brace_style = "collapse";
        } else {
          this.brace_style = brace_style_split[bs];
        }
      }
    }
    Options.prototype = new BaseOptions();
    module2.exports.Options = Options;
  }
});

// node_modules/js-beautify/js/src/css/beautifier.js
var require_beautifier2 = __commonJS({
  "node_modules/js-beautify/js/src/css/beautifier.js"(exports2, module2) {
    "use strict";
    var Options = require_options3().Options;
    var Output = require_output().Output;
    var InputScanner = require_inputscanner().InputScanner;
    var Directives = require_directives().Directives;
    var directives_core = new Directives(/\/\*/, /\*\//);
    var lineBreak = /\r\n|[\r\n]/;
    var allLineBreaks = /\r\n|[\r\n]/g;
    var whitespaceChar = /\s/;
    var whitespacePattern = /(?:\s|\n)+/g;
    var block_comment_pattern = /\/\*(?:[\s\S]*?)((?:\*\/)|$)/g;
    var comment_pattern = /\/\/(?:[^\n\r\u2028\u2029]*)/g;
    function Beautifier(source_text, options) {
      this._source_text = source_text || "";
      this._options = new Options(options);
      this._ch = null;
      this._input = null;
      this.NESTED_AT_RULE = {
        "page": true,
        "font-face": true,
        "keyframes": true,
        "media": true,
        "supports": true,
        "document": true
      };
      this.CONDITIONAL_GROUP_RULE = {
        "media": true,
        "supports": true,
        "document": true
      };
      this.NON_SEMICOLON_NEWLINE_PROPERTY = [
        "grid-template-areas",
        "grid-template"
      ];
    }
    Beautifier.prototype.eatString = function(endChars) {
      var result = "";
      this._ch = this._input.next();
      while (this._ch) {
        result += this._ch;
        if (this._ch === "\\") {
          result += this._input.next();
        } else if (endChars.indexOf(this._ch) !== -1 || this._ch === "\n") {
          break;
        }
        this._ch = this._input.next();
      }
      return result;
    };
    Beautifier.prototype.eatWhitespace = function(allowAtLeastOneNewLine) {
      var result = whitespaceChar.test(this._input.peek());
      var newline_count = 0;
      while (whitespaceChar.test(this._input.peek())) {
        this._ch = this._input.next();
        if (allowAtLeastOneNewLine && this._ch === "\n") {
          if (newline_count === 0 || newline_count < this._options.max_preserve_newlines) {
            newline_count++;
            this._output.add_new_line(true);
          }
        }
      }
      return result;
    };
    Beautifier.prototype.foundNestedPseudoClass = function() {
      var openParen = 0;
      var i = 1;
      var ch = this._input.peek(i);
      while (ch) {
        if (ch === "{") {
          return true;
        } else if (ch === "(") {
          openParen += 1;
        } else if (ch === ")") {
          if (openParen === 0) {
            return false;
          }
          openParen -= 1;
        } else if (ch === ";" || ch === "}") {
          return false;
        }
        i++;
        ch = this._input.peek(i);
      }
      return false;
    };
    Beautifier.prototype.print_string = function(output_string) {
      this._output.set_indent(this._indentLevel);
      this._output.non_breaking_space = true;
      this._output.add_token(output_string);
    };
    Beautifier.prototype.preserveSingleSpace = function(isAfterSpace) {
      if (isAfterSpace) {
        this._output.space_before_token = true;
      }
    };
    Beautifier.prototype.indent = function() {
      this._indentLevel++;
    };
    Beautifier.prototype.outdent = function() {
      if (this._indentLevel > 0) {
        this._indentLevel--;
      }
    };
    Beautifier.prototype.beautify = function() {
      if (this._options.disabled) {
        return this._source_text;
      }
      var source_text = this._source_text;
      var eol = this._options.eol;
      if (eol === "auto") {
        eol = "\n";
        if (source_text && lineBreak.test(source_text || "")) {
          eol = source_text.match(lineBreak)[0];
        }
      }
      source_text = source_text.replace(allLineBreaks, "\n");
      var baseIndentString = source_text.match(/^[\t ]*/)[0];
      this._output = new Output(this._options, baseIndentString);
      this._input = new InputScanner(source_text);
      this._indentLevel = 0;
      this._nestedLevel = 0;
      this._ch = null;
      var parenLevel = 0;
      var insideRule = false;
      var insidePropertyValue = false;
      var enteringConditionalGroup = false;
      var insideNonNestedAtRule = false;
      var insideScssMap = false;
      var topCharacter = this._ch;
      var insideNonSemiColonValues = false;
      var whitespace;
      var isAfterSpace;
      var previous_ch;
      while (true) {
        whitespace = this._input.read(whitespacePattern);
        isAfterSpace = whitespace !== "";
        previous_ch = topCharacter;
        this._ch = this._input.next();
        if (this._ch === "\\" && this._input.hasNext()) {
          this._ch += this._input.next();
        }
        topCharacter = this._ch;
        if (!this._ch) {
          break;
        } else if (this._ch === "/" && this._input.peek() === "*") {
          this._output.add_new_line();
          this._input.back();
          var comment = this._input.read(block_comment_pattern);
          var directives = directives_core.get_directives(comment);
          if (directives && directives.ignore === "start") {
            comment += directives_core.readIgnored(this._input);
          }
          this.print_string(comment);
          this.eatWhitespace(true);
          this._output.add_new_line();
        } else if (this._ch === "/" && this._input.peek() === "/") {
          this._output.space_before_token = true;
          this._input.back();
          this.print_string(this._input.read(comment_pattern));
          this.eatWhitespace(true);
        } else if (this._ch === "$") {
          this.preserveSingleSpace(isAfterSpace);
          this.print_string(this._ch);
          var variable = this._input.peekUntilAfter(/[: ,;{}()[\]\/='"]/g);
          if (variable.match(/[ :]$/)) {
            variable = this.eatString(": ").replace(/\s+$/, "");
            this.print_string(variable);
            this._output.space_before_token = true;
          }
          if (parenLevel === 0 && variable.indexOf(":") !== -1) {
            insidePropertyValue = true;
            this.indent();
          }
        } else if (this._ch === "@") {
          this.preserveSingleSpace(isAfterSpace);
          if (this._input.peek() === "{") {
            this.print_string(this._ch + this.eatString("}"));
          } else {
            this.print_string(this._ch);
            var variableOrRule = this._input.peekUntilAfter(/[: ,;{}()[\]\/='"]/g);
            if (variableOrRule.match(/[ :]$/)) {
              variableOrRule = this.eatString(": ").replace(/\s+$/, "");
              this.print_string(variableOrRule);
              this._output.space_before_token = true;
            }
            if (parenLevel === 0 && variableOrRule.indexOf(":") !== -1) {
              insidePropertyValue = true;
              this.indent();
            } else if (variableOrRule in this.NESTED_AT_RULE) {
              this._nestedLevel += 1;
              if (variableOrRule in this.CONDITIONAL_GROUP_RULE) {
                enteringConditionalGroup = true;
              }
            } else if (parenLevel === 0 && !insidePropertyValue) {
              insideNonNestedAtRule = true;
            }
          }
        } else if (this._ch === "#" && this._input.peek() === "{") {
          this.preserveSingleSpace(isAfterSpace);
          this.print_string(this._ch + this.eatString("}"));
        } else if (this._ch === "{") {
          if (insidePropertyValue) {
            insidePropertyValue = false;
            this.outdent();
          }
          insideNonNestedAtRule = false;
          if (enteringConditionalGroup) {
            enteringConditionalGroup = false;
            insideRule = this._indentLevel >= this._nestedLevel;
          } else {
            insideRule = this._indentLevel >= this._nestedLevel - 1;
          }
          if (this._options.newline_between_rules && insideRule) {
            if (this._output.previous_line && this._output.previous_line.item(-1) !== "{") {
              this._output.ensure_empty_line_above("/", ",");
            }
          }
          this._output.space_before_token = true;
          if (this._options.brace_style === "expand") {
            this._output.add_new_line();
            this.print_string(this._ch);
            this.indent();
            this._output.set_indent(this._indentLevel);
          } else {
            if (previous_ch === "(") {
              this._output.space_before_token = false;
            } else if (previous_ch !== ",") {
              this.indent();
            }
            this.print_string(this._ch);
          }
          this.eatWhitespace(true);
          this._output.add_new_line();
        } else if (this._ch === "}") {
          this.outdent();
          this._output.add_new_line();
          if (previous_ch === "{") {
            this._output.trim(true);
          }
          if (insidePropertyValue) {
            this.outdent();
            insidePropertyValue = false;
          }
          this.print_string(this._ch);
          insideRule = false;
          if (this._nestedLevel) {
            this._nestedLevel--;
          }
          this.eatWhitespace(true);
          this._output.add_new_line();
          if (this._options.newline_between_rules && !this._output.just_added_blankline()) {
            if (this._input.peek() !== "}") {
              this._output.add_new_line(true);
            }
          }
          if (this._input.peek() === ")") {
            this._output.trim(true);
            if (this._options.brace_style === "expand") {
              this._output.add_new_line(true);
            }
          }
        } else if (this._ch === ":") {
          for (var i = 0; i < this.NON_SEMICOLON_NEWLINE_PROPERTY.length; i++) {
            if (this._input.lookBack(this.NON_SEMICOLON_NEWLINE_PROPERTY[i])) {
              insideNonSemiColonValues = true;
              break;
            }
          }
          if ((insideRule || enteringConditionalGroup) && !(this._input.lookBack("&") || this.foundNestedPseudoClass()) && !this._input.lookBack("(") && !insideNonNestedAtRule && parenLevel === 0) {
            this.print_string(":");
            if (!insidePropertyValue) {
              insidePropertyValue = true;
              this._output.space_before_token = true;
              this.eatWhitespace(true);
              this.indent();
            }
          } else {
            if (this._input.lookBack(" ")) {
              this._output.space_before_token = true;
            }
            if (this._input.peek() === ":") {
              this._ch = this._input.next();
              this.print_string("::");
            } else {
              this.print_string(":");
            }
          }
        } else if (this._ch === '"' || this._ch === "'") {
          var preserveQuoteSpace = previous_ch === '"' || previous_ch === "'";
          this.preserveSingleSpace(preserveQuoteSpace || isAfterSpace);
          this.print_string(this._ch + this.eatString(this._ch));
          this.eatWhitespace(true);
        } else if (this._ch === ";") {
          insideNonSemiColonValues = false;
          if (parenLevel === 0) {
            if (insidePropertyValue) {
              this.outdent();
              insidePropertyValue = false;
            }
            insideNonNestedAtRule = false;
            this.print_string(this._ch);
            this.eatWhitespace(true);
            if (this._input.peek() !== "/") {
              this._output.add_new_line();
            }
          } else {
            this.print_string(this._ch);
            this.eatWhitespace(true);
            this._output.space_before_token = true;
          }
        } else if (this._ch === "(") {
          if (this._input.lookBack("url")) {
            this.print_string(this._ch);
            this.eatWhitespace();
            parenLevel++;
            this.indent();
            this._ch = this._input.next();
            if (this._ch === ")" || this._ch === '"' || this._ch === "'") {
              this._input.back();
            } else if (this._ch) {
              this.print_string(this._ch + this.eatString(")"));
              if (parenLevel) {
                parenLevel--;
                this.outdent();
              }
            }
          } else {
            var space_needed = false;
            if (this._input.lookBack("with")) {
              space_needed = true;
            }
            this.preserveSingleSpace(isAfterSpace || space_needed);
            this.print_string(this._ch);
            if (insidePropertyValue && previous_ch === "$" && this._options.selector_separator_newline) {
              this._output.add_new_line();
              insideScssMap = true;
            } else {
              this.eatWhitespace();
              parenLevel++;
              this.indent();
            }
          }
        } else if (this._ch === ")") {
          if (parenLevel) {
            parenLevel--;
            this.outdent();
          }
          if (insideScssMap && this._input.peek() === ";" && this._options.selector_separator_newline) {
            insideScssMap = false;
            this.outdent();
            this._output.add_new_line();
          }
          this.print_string(this._ch);
        } else if (this._ch === ",") {
          this.print_string(this._ch);
          this.eatWhitespace(true);
          if (this._options.selector_separator_newline && (!insidePropertyValue || insideScssMap) && parenLevel === 0 && !insideNonNestedAtRule) {
            this._output.add_new_line();
          } else {
            this._output.space_before_token = true;
          }
        } else if ((this._ch === ">" || this._ch === "+" || this._ch === "~") && !insidePropertyValue && parenLevel === 0) {
          if (this._options.space_around_combinator) {
            this._output.space_before_token = true;
            this.print_string(this._ch);
            this._output.space_before_token = true;
          } else {
            this.print_string(this._ch);
            this.eatWhitespace();
            if (this._ch && whitespaceChar.test(this._ch)) {
              this._ch = "";
            }
          }
        } else if (this._ch === "]") {
          this.print_string(this._ch);
        } else if (this._ch === "[") {
          this.preserveSingleSpace(isAfterSpace);
          this.print_string(this._ch);
        } else if (this._ch === "=") {
          this.eatWhitespace();
          this.print_string("=");
          if (whitespaceChar.test(this._ch)) {
            this._ch = "";
          }
        } else if (this._ch === "!" && !this._input.lookBack("\\")) {
          this._output.space_before_token = true;
          this.print_string(this._ch);
        } else {
          var preserveAfterSpace = previous_ch === '"' || previous_ch === "'";
          this.preserveSingleSpace(preserveAfterSpace || isAfterSpace);
          this.print_string(this._ch);
          if (!this._output.just_added_newline() && this._input.peek() === "\n" && insideNonSemiColonValues) {
            this._output.add_new_line();
          }
        }
      }
      var sweetCode = this._output.get_code(eol);
      return sweetCode;
    };
    module2.exports.Beautifier = Beautifier;
  }
});

// node_modules/js-beautify/js/src/css/index.js
var require_css = __commonJS({
  "node_modules/js-beautify/js/src/css/index.js"(exports2, module2) {
    "use strict";
    var Beautifier = require_beautifier2().Beautifier;
    var Options = require_options3().Options;
    function css_beautify(source_text, options) {
      var beautifier = new Beautifier(source_text, options);
      return beautifier.beautify();
    }
    module2.exports = css_beautify;
    module2.exports.defaultOptions = function() {
      return new Options();
    };
  }
});

// node_modules/js-beautify/js/src/html/options.js
var require_options4 = __commonJS({
  "node_modules/js-beautify/js/src/html/options.js"(exports2, module2) {
    "use strict";
    var BaseOptions = require_options().Options;
    function Options(options) {
      BaseOptions.call(this, options, "html");
      if (this.templating.length === 1 && this.templating[0] === "auto") {
        this.templating = ["django", "erb", "handlebars", "php"];
      }
      this.indent_inner_html = this._get_boolean("indent_inner_html");
      this.indent_body_inner_html = this._get_boolean("indent_body_inner_html", true);
      this.indent_head_inner_html = this._get_boolean("indent_head_inner_html", true);
      this.indent_handlebars = this._get_boolean("indent_handlebars", true);
      this.wrap_attributes = this._get_selection(
        "wrap_attributes",
        ["auto", "force", "force-aligned", "force-expand-multiline", "aligned-multiple", "preserve", "preserve-aligned"]
      );
      this.wrap_attributes_min_attrs = this._get_number("wrap_attributes_min_attrs", 2);
      this.wrap_attributes_indent_size = this._get_number("wrap_attributes_indent_size", this.indent_size);
      this.extra_liners = this._get_array("extra_liners", ["head", "body", "/html"]);
      this.inline = this._get_array("inline", [
        "a",
        "abbr",
        "area",
        "audio",
        "b",
        "bdi",
        "bdo",
        "br",
        "button",
        "canvas",
        "cite",
        "code",
        "data",
        "datalist",
        "del",
        "dfn",
        "em",
        "embed",
        "i",
        "iframe",
        "img",
        "input",
        "ins",
        "kbd",
        "keygen",
        "label",
        "map",
        "mark",
        "math",
        "meter",
        "noscript",
        "object",
        "output",
        "progress",
        "q",
        "ruby",
        "s",
        "samp",
        "select",
        "small",
        "span",
        "strong",
        "sub",
        "sup",
        "svg",
        "template",
        "textarea",
        "time",
        "u",
        "var",
        "video",
        "wbr",
        "text",
        "acronym",
        "big",
        "strike",
        "tt"
      ]);
      this.inline_custom_elements = this._get_boolean("inline_custom_elements", true);
      this.void_elements = this._get_array("void_elements", [
        "area",
        "base",
        "br",
        "col",
        "embed",
        "hr",
        "img",
        "input",
        "keygen",
        "link",
        "menuitem",
        "meta",
        "param",
        "source",
        "track",
        "wbr",
        "!doctype",
        "?xml",
        "basefont",
        "isindex"
      ]);
      this.unformatted = this._get_array("unformatted", []);
      this.content_unformatted = this._get_array("content_unformatted", [
        "pre",
        "textarea"
      ]);
      this.unformatted_content_delimiter = this._get_characters("unformatted_content_delimiter");
      this.indent_scripts = this._get_selection("indent_scripts", ["normal", "keep", "separate"]);
    }
    Options.prototype = new BaseOptions();
    module2.exports.Options = Options;
  }
});

// node_modules/js-beautify/js/src/html/tokenizer.js
var require_tokenizer3 = __commonJS({
  "node_modules/js-beautify/js/src/html/tokenizer.js"(exports2, module2) {
    "use strict";
    var BaseTokenizer = require_tokenizer().Tokenizer;
    var BASETOKEN = require_tokenizer().TOKEN;
    var Directives = require_directives().Directives;
    var TemplatablePattern = require_templatablepattern().TemplatablePattern;
    var Pattern = require_pattern().Pattern;
    var TOKEN = {
      TAG_OPEN: "TK_TAG_OPEN",
      TAG_CLOSE: "TK_TAG_CLOSE",
      CONTROL_FLOW_OPEN: "TK_CONTROL_FLOW_OPEN",
      CONTROL_FLOW_CLOSE: "TK_CONTROL_FLOW_CLOSE",
      ATTRIBUTE: "TK_ATTRIBUTE",
      EQUALS: "TK_EQUALS",
      VALUE: "TK_VALUE",
      COMMENT: "TK_COMMENT",
      TEXT: "TK_TEXT",
      UNKNOWN: "TK_UNKNOWN",
      START: BASETOKEN.START,
      RAW: BASETOKEN.RAW,
      EOF: BASETOKEN.EOF
    };
    var directives_core = new Directives(/<\!--/, /-->/);
    var Tokenizer = function(input_string, options) {
      BaseTokenizer.call(this, input_string, options);
      this._current_tag_name = "";
      var templatable_reader = new TemplatablePattern(this._input).read_options(this._options);
      var pattern_reader = new Pattern(this._input);
      this.__patterns = {
        word: templatable_reader.until(/[\n\r\t <]/),
        word_control_flow_close_excluded: templatable_reader.until(/[\n\r\t <}]/),
        single_quote: templatable_reader.until_after(/'/),
        double_quote: templatable_reader.until_after(/"/),
        attribute: templatable_reader.until(/[\n\r\t =>]|\/>/),
        element_name: templatable_reader.until(/[\n\r\t >\/]/),
        angular_control_flow_start: pattern_reader.matching(/\@[a-zA-Z]+[^({]*[({]/),
        handlebars_comment: pattern_reader.starting_with(/{{!--/).until_after(/--}}/),
        handlebars: pattern_reader.starting_with(/{{/).until_after(/}}/),
        handlebars_open: pattern_reader.until(/[\n\r\t }]/),
        handlebars_raw_close: pattern_reader.until(/}}/),
        comment: pattern_reader.starting_with(/<!--/).until_after(/-->/),
        cdata: pattern_reader.starting_with(/<!\[CDATA\[/).until_after(/]]>/),
        conditional_comment: pattern_reader.starting_with(/<!\[/).until_after(/]>/),
        processing: pattern_reader.starting_with(/<\?/).until_after(/\?>/)
      };
      if (this._options.indent_handlebars) {
        this.__patterns.word = this.__patterns.word.exclude("handlebars");
        this.__patterns.word_control_flow_close_excluded = this.__patterns.word_control_flow_close_excluded.exclude("handlebars");
      }
      this._unformatted_content_delimiter = null;
      if (this._options.unformatted_content_delimiter) {
        var literal_regexp = this._input.get_literal_regexp(this._options.unformatted_content_delimiter);
        this.__patterns.unformatted_content_delimiter = pattern_reader.matching(literal_regexp).until_after(literal_regexp);
      }
    };
    Tokenizer.prototype = new BaseTokenizer();
    Tokenizer.prototype._is_comment = function(current_token) {
      return false;
    };
    Tokenizer.prototype._is_opening = function(current_token) {
      return current_token.type === TOKEN.TAG_OPEN || current_token.type === TOKEN.CONTROL_FLOW_OPEN;
    };
    Tokenizer.prototype._is_closing = function(current_token, open_token) {
      return current_token.type === TOKEN.TAG_CLOSE && (open_token && ((current_token.text === ">" || current_token.text === "/>") && open_token.text[0] === "<" || current_token.text === "}}" && open_token.text[0] === "{" && open_token.text[1] === "{")) || current_token.type === TOKEN.CONTROL_FLOW_CLOSE && (current_token.text === "}" && open_token.text.endsWith("{"));
    };
    Tokenizer.prototype._reset = function() {
      this._current_tag_name = "";
    };
    Tokenizer.prototype._get_next_token = function(previous_token, open_token) {
      var token = null;
      this._readWhitespace();
      var c = this._input.peek();
      if (c === null) {
        return this._create_token(TOKEN.EOF, "");
      }
      token = token || this._read_open_handlebars(c, open_token);
      token = token || this._read_attribute(c, previous_token, open_token);
      token = token || this._read_close(c, open_token);
      token = token || this._read_control_flows(c, open_token);
      token = token || this._read_raw_content(c, previous_token, open_token);
      token = token || this._read_content_word(c, open_token);
      token = token || this._read_comment_or_cdata(c);
      token = token || this._read_processing(c);
      token = token || this._read_open(c, open_token);
      token = token || this._create_token(TOKEN.UNKNOWN, this._input.next());
      return token;
    };
    Tokenizer.prototype._read_comment_or_cdata = function(c) {
      var token = null;
      var resulting_string = null;
      var directives = null;
      if (c === "<") {
        var peek1 = this._input.peek(1);
        if (peek1 === "!") {
          resulting_string = this.__patterns.comment.read();
          if (resulting_string) {
            directives = directives_core.get_directives(resulting_string);
            if (directives && directives.ignore === "start") {
              resulting_string += directives_core.readIgnored(this._input);
            }
          } else {
            resulting_string = this.__patterns.cdata.read();
          }
        }
        if (resulting_string) {
          token = this._create_token(TOKEN.COMMENT, resulting_string);
          token.directives = directives;
        }
      }
      return token;
    };
    Tokenizer.prototype._read_processing = function(c) {
      var token = null;
      var resulting_string = null;
      var directives = null;
      if (c === "<") {
        var peek1 = this._input.peek(1);
        if (peek1 === "!" || peek1 === "?") {
          resulting_string = this.__patterns.conditional_comment.read();
          resulting_string = resulting_string || this.__patterns.processing.read();
        }
        if (resulting_string) {
          token = this._create_token(TOKEN.COMMENT, resulting_string);
          token.directives = directives;
        }
      }
      return token;
    };
    Tokenizer.prototype._read_open = function(c, open_token) {
      var resulting_string = null;
      var token = null;
      if (!open_token || open_token.type === TOKEN.CONTROL_FLOW_OPEN) {
        if (c === "<") {
          resulting_string = this._input.next();
          if (this._input.peek() === "/") {
            resulting_string += this._input.next();
          }
          resulting_string += this.__patterns.element_name.read();
          token = this._create_token(TOKEN.TAG_OPEN, resulting_string);
        }
      }
      return token;
    };
    Tokenizer.prototype._read_open_handlebars = function(c, open_token) {
      var resulting_string = null;
      var token = null;
      if (!open_token || open_token.type === TOKEN.CONTROL_FLOW_OPEN) {
        if (this._options.indent_handlebars && c === "{" && this._input.peek(1) === "{") {
          if (this._input.peek(2) === "!") {
            resulting_string = this.__patterns.handlebars_comment.read();
            resulting_string = resulting_string || this.__patterns.handlebars.read();
            token = this._create_token(TOKEN.COMMENT, resulting_string);
          } else {
            resulting_string = this.__patterns.handlebars_open.read();
            token = this._create_token(TOKEN.TAG_OPEN, resulting_string);
          }
        }
      }
      return token;
    };
    Tokenizer.prototype._read_control_flows = function(c, open_token) {
      var resulting_string = "";
      var token = null;
      if (!this._options.templating.includes("angular") || !this._options.indent_handlebars) {
        return token;
      }
      if (c === "@") {
        resulting_string = this.__patterns.angular_control_flow_start.read();
        if (resulting_string === "") {
          return token;
        }
        var opening_parentheses_count = resulting_string.endsWith("(") ? 1 : 0;
        var closing_parentheses_count = 0;
        while (!(resulting_string.endsWith("{") && opening_parentheses_count === closing_parentheses_count)) {
          var next_char = this._input.next();
          if (next_char === null) {
            break;
          } else if (next_char === "(") {
            opening_parentheses_count++;
          } else if (next_char === ")") {
            closing_parentheses_count++;
          }
          resulting_string += next_char;
        }
        token = this._create_token(TOKEN.CONTROL_FLOW_OPEN, resulting_string);
      } else if (c === "}" && open_token && open_token.type === TOKEN.CONTROL_FLOW_OPEN) {
        resulting_string = this._input.next();
        token = this._create_token(TOKEN.CONTROL_FLOW_CLOSE, resulting_string);
      }
      return token;
    };
    Tokenizer.prototype._read_close = function(c, open_token) {
      var resulting_string = null;
      var token = null;
      if (open_token && open_token.type === TOKEN.TAG_OPEN) {
        if (open_token.text[0] === "<" && (c === ">" || c === "/" && this._input.peek(1) === ">")) {
          resulting_string = this._input.next();
          if (c === "/") {
            resulting_string += this._input.next();
          }
          token = this._create_token(TOKEN.TAG_CLOSE, resulting_string);
        } else if (open_token.text[0] === "{" && c === "}" && this._input.peek(1) === "}") {
          this._input.next();
          this._input.next();
          token = this._create_token(TOKEN.TAG_CLOSE, "}}");
        }
      }
      return token;
    };
    Tokenizer.prototype._read_attribute = function(c, previous_token, open_token) {
      var token = null;
      var resulting_string = "";
      if (open_token && open_token.text[0] === "<") {
        if (c === "=") {
          token = this._create_token(TOKEN.EQUALS, this._input.next());
        } else if (c === '"' || c === "'") {
          var content = this._input.next();
          if (c === '"') {
            content += this.__patterns.double_quote.read();
          } else {
            content += this.__patterns.single_quote.read();
          }
          token = this._create_token(TOKEN.VALUE, content);
        } else {
          resulting_string = this.__patterns.attribute.read();
          if (resulting_string) {
            if (previous_token.type === TOKEN.EQUALS) {
              token = this._create_token(TOKEN.VALUE, resulting_string);
            } else {
              token = this._create_token(TOKEN.ATTRIBUTE, resulting_string);
            }
          }
        }
      }
      return token;
    };
    Tokenizer.prototype._is_content_unformatted = function(tag_name) {
      return this._options.void_elements.indexOf(tag_name) === -1 && (this._options.content_unformatted.indexOf(tag_name) !== -1 || this._options.unformatted.indexOf(tag_name) !== -1);
    };
    Tokenizer.prototype._read_raw_content = function(c, previous_token, open_token) {
      var resulting_string = "";
      if (open_token && open_token.text[0] === "{") {
        resulting_string = this.__patterns.handlebars_raw_close.read();
      } else if (previous_token.type === TOKEN.TAG_CLOSE && previous_token.opened.text[0] === "<" && previous_token.text[0] !== "/") {
        var tag_name = previous_token.opened.text.substr(1).toLowerCase();
        if (tag_name === "script" || tag_name === "style") {
          var token = this._read_comment_or_cdata(c);
          if (token) {
            token.type = TOKEN.TEXT;
            return token;
          }
          resulting_string = this._input.readUntil(new RegExp("</" + tag_name + "[\\n\\r\\t ]*?>", "ig"));
        } else if (this._is_content_unformatted(tag_name)) {
          resulting_string = this._input.readUntil(new RegExp("</" + tag_name + "[\\n\\r\\t ]*?>", "ig"));
        }
      }
      if (resulting_string) {
        return this._create_token(TOKEN.TEXT, resulting_string);
      }
      return null;
    };
    Tokenizer.prototype._read_content_word = function(c, open_token) {
      var resulting_string = "";
      if (this._options.unformatted_content_delimiter) {
        if (c === this._options.unformatted_content_delimiter[0]) {
          resulting_string = this.__patterns.unformatted_content_delimiter.read();
        }
      }
      if (!resulting_string) {
        resulting_string = open_token && open_token.type === TOKEN.CONTROL_FLOW_OPEN ? this.__patterns.word_control_flow_close_excluded.read() : this.__patterns.word.read();
      }
      if (resulting_string) {
        return this._create_token(TOKEN.TEXT, resulting_string);
      }
    };
    module2.exports.Tokenizer = Tokenizer;
    module2.exports.TOKEN = TOKEN;
  }
});

// node_modules/js-beautify/js/src/html/beautifier.js
var require_beautifier3 = __commonJS({
  "node_modules/js-beautify/js/src/html/beautifier.js"(exports2, module2) {
    "use strict";
    var Options = require_options4().Options;
    var Output = require_output().Output;
    var Tokenizer = require_tokenizer3().Tokenizer;
    var TOKEN = require_tokenizer3().TOKEN;
    var lineBreak = /\r\n|[\r\n]/;
    var allLineBreaks = /\r\n|[\r\n]/g;
    var Printer = function(options, base_indent_string) {
      this.indent_level = 0;
      this.alignment_size = 0;
      this.max_preserve_newlines = options.max_preserve_newlines;
      this.preserve_newlines = options.preserve_newlines;
      this._output = new Output(options, base_indent_string);
    };
    Printer.prototype.current_line_has_match = function(pattern) {
      return this._output.current_line.has_match(pattern);
    };
    Printer.prototype.set_space_before_token = function(value, non_breaking) {
      this._output.space_before_token = value;
      this._output.non_breaking_space = non_breaking;
    };
    Printer.prototype.set_wrap_point = function() {
      this._output.set_indent(this.indent_level, this.alignment_size);
      this._output.set_wrap_point();
    };
    Printer.prototype.add_raw_token = function(token) {
      this._output.add_raw_token(token);
    };
    Printer.prototype.print_preserved_newlines = function(raw_token) {
      var newlines = 0;
      if (raw_token.type !== TOKEN.TEXT && raw_token.previous.type !== TOKEN.TEXT) {
        newlines = raw_token.newlines ? 1 : 0;
      }
      if (this.preserve_newlines) {
        newlines = raw_token.newlines < this.max_preserve_newlines + 1 ? raw_token.newlines : this.max_preserve_newlines + 1;
      }
      for (var n = 0; n < newlines; n++) {
        this.print_newline(n > 0);
      }
      return newlines !== 0;
    };
    Printer.prototype.traverse_whitespace = function(raw_token) {
      if (raw_token.whitespace_before || raw_token.newlines) {
        if (!this.print_preserved_newlines(raw_token)) {
          this._output.space_before_token = true;
        }
        return true;
      }
      return false;
    };
    Printer.prototype.previous_token_wrapped = function() {
      return this._output.previous_token_wrapped;
    };
    Printer.prototype.print_newline = function(force) {
      this._output.add_new_line(force);
    };
    Printer.prototype.print_token = function(token) {
      if (token.text) {
        this._output.set_indent(this.indent_level, this.alignment_size);
        this._output.add_token(token.text);
      }
    };
    Printer.prototype.indent = function() {
      this.indent_level++;
    };
    Printer.prototype.deindent = function() {
      if (this.indent_level > 0) {
        this.indent_level--;
        this._output.set_indent(this.indent_level, this.alignment_size);
      }
    };
    Printer.prototype.get_full_indent = function(level) {
      level = this.indent_level + (level || 0);
      if (level < 1) {
        return "";
      }
      return this._output.get_indent_string(level);
    };
    var get_type_attribute = function(start_token) {
      var result = null;
      var raw_token = start_token.next;
      while (raw_token.type !== TOKEN.EOF && start_token.closed !== raw_token) {
        if (raw_token.type === TOKEN.ATTRIBUTE && raw_token.text === "type") {
          if (raw_token.next && raw_token.next.type === TOKEN.EQUALS && raw_token.next.next && raw_token.next.next.type === TOKEN.VALUE) {
            result = raw_token.next.next.text;
          }
          break;
        }
        raw_token = raw_token.next;
      }
      return result;
    };
    var get_custom_beautifier_name = function(tag_check, raw_token) {
      var typeAttribute = null;
      var result = null;
      if (!raw_token.closed) {
        return null;
      }
      if (tag_check === "script") {
        typeAttribute = "text/javascript";
      } else if (tag_check === "style") {
        typeAttribute = "text/css";
      }
      typeAttribute = get_type_attribute(raw_token) || typeAttribute;
      if (typeAttribute.search("text/css") > -1) {
        result = "css";
      } else if (typeAttribute.search(/module|((text|application|dojo)\/(x-)?(javascript|ecmascript|jscript|livescript|(ld\+)?json|method|aspect))/) > -1) {
        result = "javascript";
      } else if (typeAttribute.search(/(text|application|dojo)\/(x-)?(html)/) > -1) {
        result = "html";
      } else if (typeAttribute.search(/test\/null/) > -1) {
        result = "null";
      }
      return result;
    };
    function in_array(what, arr) {
      return arr.indexOf(what) !== -1;
    }
    function TagFrame(parent, parser_token, indent_level) {
      this.parent = parent || null;
      this.tag = parser_token ? parser_token.tag_name : "";
      this.indent_level = indent_level || 0;
      this.parser_token = parser_token || null;
    }
    function TagStack(printer) {
      this._printer = printer;
      this._current_frame = null;
    }
    TagStack.prototype.get_parser_token = function() {
      return this._current_frame ? this._current_frame.parser_token : null;
    };
    TagStack.prototype.record_tag = function(parser_token) {
      var new_frame = new TagFrame(this._current_frame, parser_token, this._printer.indent_level);
      this._current_frame = new_frame;
    };
    TagStack.prototype._try_pop_frame = function(frame) {
      var parser_token = null;
      if (frame) {
        parser_token = frame.parser_token;
        this._printer.indent_level = frame.indent_level;
        this._current_frame = frame.parent;
      }
      return parser_token;
    };
    TagStack.prototype._get_frame = function(tag_list, stop_list) {
      var frame = this._current_frame;
      while (frame) {
        if (tag_list.indexOf(frame.tag) !== -1) {
          break;
        } else if (stop_list && stop_list.indexOf(frame.tag) !== -1) {
          frame = null;
          break;
        }
        frame = frame.parent;
      }
      return frame;
    };
    TagStack.prototype.try_pop = function(tag, stop_list) {
      var frame = this._get_frame([tag], stop_list);
      return this._try_pop_frame(frame);
    };
    TagStack.prototype.indent_to_tag = function(tag_list) {
      var frame = this._get_frame(tag_list);
      if (frame) {
        this._printer.indent_level = frame.indent_level;
      }
    };
    function Beautifier(source_text, options, js_beautify, css_beautify) {
      this._source_text = source_text || "";
      options = options || {};
      this._js_beautify = js_beautify;
      this._css_beautify = css_beautify;
      this._tag_stack = null;
      var optionHtml = new Options(options, "html");
      this._options = optionHtml;
      this._is_wrap_attributes_force = this._options.wrap_attributes.substr(0, "force".length) === "force";
      this._is_wrap_attributes_force_expand_multiline = this._options.wrap_attributes === "force-expand-multiline";
      this._is_wrap_attributes_force_aligned = this._options.wrap_attributes === "force-aligned";
      this._is_wrap_attributes_aligned_multiple = this._options.wrap_attributes === "aligned-multiple";
      this._is_wrap_attributes_preserve = this._options.wrap_attributes.substr(0, "preserve".length) === "preserve";
      this._is_wrap_attributes_preserve_aligned = this._options.wrap_attributes === "preserve-aligned";
    }
    Beautifier.prototype.beautify = function() {
      if (this._options.disabled) {
        return this._source_text;
      }
      var source_text = this._source_text;
      var eol = this._options.eol;
      if (this._options.eol === "auto") {
        eol = "\n";
        if (source_text && lineBreak.test(source_text)) {
          eol = source_text.match(lineBreak)[0];
        }
      }
      source_text = source_text.replace(allLineBreaks, "\n");
      var baseIndentString = source_text.match(/^[\t ]*/)[0];
      var last_token = {
        text: "",
        type: ""
      };
      var last_tag_token = new TagOpenParserToken();
      var printer = new Printer(this._options, baseIndentString);
      var tokens = new Tokenizer(source_text, this._options).tokenize();
      this._tag_stack = new TagStack(printer);
      var parser_token = null;
      var raw_token = tokens.next();
      while (raw_token.type !== TOKEN.EOF) {
        if (raw_token.type === TOKEN.TAG_OPEN || raw_token.type === TOKEN.COMMENT) {
          parser_token = this._handle_tag_open(printer, raw_token, last_tag_token, last_token, tokens);
          last_tag_token = parser_token;
        } else if (raw_token.type === TOKEN.ATTRIBUTE || raw_token.type === TOKEN.EQUALS || raw_token.type === TOKEN.VALUE || raw_token.type === TOKEN.TEXT && !last_tag_token.tag_complete) {
          parser_token = this._handle_inside_tag(printer, raw_token, last_tag_token, last_token);
        } else if (raw_token.type === TOKEN.TAG_CLOSE) {
          parser_token = this._handle_tag_close(printer, raw_token, last_tag_token);
        } else if (raw_token.type === TOKEN.TEXT) {
          parser_token = this._handle_text(printer, raw_token, last_tag_token);
        } else if (raw_token.type === TOKEN.CONTROL_FLOW_OPEN) {
          parser_token = this._handle_control_flow_open(printer, raw_token);
        } else if (raw_token.type === TOKEN.CONTROL_FLOW_CLOSE) {
          parser_token = this._handle_control_flow_close(printer, raw_token);
        } else {
          printer.add_raw_token(raw_token);
        }
        last_token = parser_token;
        raw_token = tokens.next();
      }
      var sweet_code = printer._output.get_code(eol);
      return sweet_code;
    };
    Beautifier.prototype._handle_control_flow_open = function(printer, raw_token) {
      var parser_token = {
        text: raw_token.text,
        type: raw_token.type
      };
      printer.set_space_before_token(raw_token.newlines || raw_token.whitespace_before !== "", true);
      if (raw_token.newlines) {
        printer.print_preserved_newlines(raw_token);
      } else {
        printer.set_space_before_token(raw_token.newlines || raw_token.whitespace_before !== "", true);
      }
      printer.print_token(raw_token);
      printer.indent();
      return parser_token;
    };
    Beautifier.prototype._handle_control_flow_close = function(printer, raw_token) {
      var parser_token = {
        text: raw_token.text,
        type: raw_token.type
      };
      printer.deindent();
      if (raw_token.newlines) {
        printer.print_preserved_newlines(raw_token);
      } else {
        printer.set_space_before_token(raw_token.newlines || raw_token.whitespace_before !== "", true);
      }
      printer.print_token(raw_token);
      return parser_token;
    };
    Beautifier.prototype._handle_tag_close = function(printer, raw_token, last_tag_token) {
      var parser_token = {
        text: raw_token.text,
        type: raw_token.type
      };
      printer.alignment_size = 0;
      last_tag_token.tag_complete = true;
      printer.set_space_before_token(raw_token.newlines || raw_token.whitespace_before !== "", true);
      if (last_tag_token.is_unformatted) {
        printer.add_raw_token(raw_token);
      } else {
        if (last_tag_token.tag_start_char === "<") {
          printer.set_space_before_token(raw_token.text[0] === "/", true);
          if (this._is_wrap_attributes_force_expand_multiline && last_tag_token.has_wrapped_attrs) {
            printer.print_newline(false);
          }
        }
        printer.print_token(raw_token);
      }
      if (last_tag_token.indent_content && !(last_tag_token.is_unformatted || last_tag_token.is_content_unformatted)) {
        printer.indent();
        last_tag_token.indent_content = false;
      }
      if (!last_tag_token.is_inline_element && !(last_tag_token.is_unformatted || last_tag_token.is_content_unformatted)) {
        printer.set_wrap_point();
      }
      return parser_token;
    };
    Beautifier.prototype._handle_inside_tag = function(printer, raw_token, last_tag_token, last_token) {
      var wrapped = last_tag_token.has_wrapped_attrs;
      var parser_token = {
        text: raw_token.text,
        type: raw_token.type
      };
      printer.set_space_before_token(raw_token.newlines || raw_token.whitespace_before !== "", true);
      if (last_tag_token.is_unformatted) {
        printer.add_raw_token(raw_token);
      } else if (last_tag_token.tag_start_char === "{" && raw_token.type === TOKEN.TEXT) {
        if (printer.print_preserved_newlines(raw_token)) {
          raw_token.newlines = 0;
          printer.add_raw_token(raw_token);
        } else {
          printer.print_token(raw_token);
        }
      } else {
        if (raw_token.type === TOKEN.ATTRIBUTE) {
          printer.set_space_before_token(true);
        } else if (raw_token.type === TOKEN.EQUALS) {
          printer.set_space_before_token(false);
        } else if (raw_token.type === TOKEN.VALUE && raw_token.previous.type === TOKEN.EQUALS) {
          printer.set_space_before_token(false);
        }
        if (raw_token.type === TOKEN.ATTRIBUTE && last_tag_token.tag_start_char === "<") {
          if (this._is_wrap_attributes_preserve || this._is_wrap_attributes_preserve_aligned) {
            printer.traverse_whitespace(raw_token);
            wrapped = wrapped || raw_token.newlines !== 0;
          }
          if (this._is_wrap_attributes_force && last_tag_token.attr_count >= this._options.wrap_attributes_min_attrs && (last_token.type !== TOKEN.TAG_OPEN || this._is_wrap_attributes_force_expand_multiline)) {
            printer.print_newline(false);
            wrapped = true;
          }
        }
        printer.print_token(raw_token);
        wrapped = wrapped || printer.previous_token_wrapped();
        last_tag_token.has_wrapped_attrs = wrapped;
      }
      return parser_token;
    };
    Beautifier.prototype._handle_text = function(printer, raw_token, last_tag_token) {
      var parser_token = {
        text: raw_token.text,
        type: "TK_CONTENT"
      };
      if (last_tag_token.custom_beautifier_name) {
        this._print_custom_beatifier_text(printer, raw_token, last_tag_token);
      } else if (last_tag_token.is_unformatted || last_tag_token.is_content_unformatted) {
        printer.add_raw_token(raw_token);
      } else {
        printer.traverse_whitespace(raw_token);
        printer.print_token(raw_token);
      }
      return parser_token;
    };
    Beautifier.prototype._print_custom_beatifier_text = function(printer, raw_token, last_tag_token) {
      var local = this;
      if (raw_token.text !== "") {
        var text = raw_token.text, _beautifier, script_indent_level = 1, pre = "", post = "";
        if (last_tag_token.custom_beautifier_name === "javascript" && typeof this._js_beautify === "function") {
          _beautifier = this._js_beautify;
        } else if (last_tag_token.custom_beautifier_name === "css" && typeof this._css_beautify === "function") {
          _beautifier = this._css_beautify;
        } else if (last_tag_token.custom_beautifier_name === "html") {
          _beautifier = function(html_source, options) {
            var beautifier = new Beautifier(html_source, options, local._js_beautify, local._css_beautify);
            return beautifier.beautify();
          };
        }
        if (this._options.indent_scripts === "keep") {
          script_indent_level = 0;
        } else if (this._options.indent_scripts === "separate") {
          script_indent_level = -printer.indent_level;
        }
        var indentation = printer.get_full_indent(script_indent_level);
        text = text.replace(/\n[ \t]*$/, "");
        if (last_tag_token.custom_beautifier_name !== "html" && text[0] === "<" && text.match(/^(<!--|<!\[CDATA\[)/)) {
          var matched = /^(<!--[^\n]*|<!\[CDATA\[)(\n?)([ \t\n]*)([\s\S]*)(-->|]]>)$/.exec(text);
          if (!matched) {
            printer.add_raw_token(raw_token);
            return;
          }
          pre = indentation + matched[1] + "\n";
          text = matched[4];
          if (matched[5]) {
            post = indentation + matched[5];
          }
          text = text.replace(/\n[ \t]*$/, "");
          if (matched[2] || matched[3].indexOf("\n") !== -1) {
            matched = matched[3].match(/[ \t]+$/);
            if (matched) {
              raw_token.whitespace_before = matched[0];
            }
          }
        }
        if (text) {
          if (_beautifier) {
            var Child_options = function() {
              this.eol = "\n";
            };
            Child_options.prototype = this._options.raw_options;
            var child_options = new Child_options();
            text = _beautifier(indentation + text, child_options);
          } else {
            var white = raw_token.whitespace_before;
            if (white) {
              text = text.replace(new RegExp("\n(" + white + ")?", "g"), "\n");
            }
            text = indentation + text.replace(/\n/g, "\n" + indentation);
          }
        }
        if (pre) {
          if (!text) {
            text = pre + post;
          } else {
            text = pre + text + "\n" + post;
          }
        }
        printer.print_newline(false);
        if (text) {
          raw_token.text = text;
          raw_token.whitespace_before = "";
          raw_token.newlines = 0;
          printer.add_raw_token(raw_token);
          printer.print_newline(true);
        }
      }
    };
    Beautifier.prototype._handle_tag_open = function(printer, raw_token, last_tag_token, last_token, tokens) {
      var parser_token = this._get_tag_open_token(raw_token);
      if ((last_tag_token.is_unformatted || last_tag_token.is_content_unformatted) && !last_tag_token.is_empty_element && raw_token.type === TOKEN.TAG_OPEN && !parser_token.is_start_tag) {
        printer.add_raw_token(raw_token);
        parser_token.start_tag_token = this._tag_stack.try_pop(parser_token.tag_name);
      } else {
        printer.traverse_whitespace(raw_token);
        this._set_tag_position(printer, raw_token, parser_token, last_tag_token, last_token);
        if (!parser_token.is_inline_element) {
          printer.set_wrap_point();
        }
        printer.print_token(raw_token);
      }
      if (parser_token.is_start_tag && this._is_wrap_attributes_force) {
        var peek_index = 0;
        var peek_token;
        do {
          peek_token = tokens.peek(peek_index);
          if (peek_token.type === TOKEN.ATTRIBUTE) {
            parser_token.attr_count += 1;
          }
          peek_index += 1;
        } while (peek_token.type !== TOKEN.EOF && peek_token.type !== TOKEN.TAG_CLOSE);
      }
      if (this._is_wrap_attributes_force_aligned || this._is_wrap_attributes_aligned_multiple || this._is_wrap_attributes_preserve_aligned) {
        parser_token.alignment_size = raw_token.text.length + 1;
      }
      if (!parser_token.tag_complete && !parser_token.is_unformatted) {
        printer.alignment_size = parser_token.alignment_size;
      }
      return parser_token;
    };
    var TagOpenParserToken = function(parent, raw_token) {
      this.parent = parent || null;
      this.text = "";
      this.type = "TK_TAG_OPEN";
      this.tag_name = "";
      this.is_inline_element = false;
      this.is_unformatted = false;
      this.is_content_unformatted = false;
      this.is_empty_element = false;
      this.is_start_tag = false;
      this.is_end_tag = false;
      this.indent_content = false;
      this.multiline_content = false;
      this.custom_beautifier_name = null;
      this.start_tag_token = null;
      this.attr_count = 0;
      this.has_wrapped_attrs = false;
      this.alignment_size = 0;
      this.tag_complete = false;
      this.tag_start_char = "";
      this.tag_check = "";
      if (!raw_token) {
        this.tag_complete = true;
      } else {
        var tag_check_match;
        this.tag_start_char = raw_token.text[0];
        this.text = raw_token.text;
        if (this.tag_start_char === "<") {
          tag_check_match = raw_token.text.match(/^<([^\s>]*)/);
          this.tag_check = tag_check_match ? tag_check_match[1] : "";
        } else {
          tag_check_match = raw_token.text.match(/^{{~?(?:[\^]|#\*?)?([^\s}]+)/);
          this.tag_check = tag_check_match ? tag_check_match[1] : "";
          if ((raw_token.text.startsWith("{{#>") || raw_token.text.startsWith("{{~#>")) && this.tag_check[0] === ">") {
            if (this.tag_check === ">" && raw_token.next !== null) {
              this.tag_check = raw_token.next.text.split(" ")[0];
            } else {
              this.tag_check = raw_token.text.split(">")[1];
            }
          }
        }
        this.tag_check = this.tag_check.toLowerCase();
        if (raw_token.type === TOKEN.COMMENT) {
          this.tag_complete = true;
        }
        this.is_start_tag = this.tag_check.charAt(0) !== "/";
        this.tag_name = !this.is_start_tag ? this.tag_check.substr(1) : this.tag_check;
        this.is_end_tag = !this.is_start_tag || raw_token.closed && raw_token.closed.text === "/>";
        var handlebar_starts = 2;
        if (this.tag_start_char === "{" && this.text.length >= 3) {
          if (this.text.charAt(2) === "~") {
            handlebar_starts = 3;
          }
        }
        this.is_end_tag = this.is_end_tag || this.tag_start_char === "{" && (this.text.length < 3 || /[^#\^]/.test(this.text.charAt(handlebar_starts)));
      }
    };
    Beautifier.prototype._get_tag_open_token = function(raw_token) {
      var parser_token = new TagOpenParserToken(this._tag_stack.get_parser_token(), raw_token);
      parser_token.alignment_size = this._options.wrap_attributes_indent_size;
      parser_token.is_end_tag = parser_token.is_end_tag || in_array(parser_token.tag_check, this._options.void_elements);
      parser_token.is_empty_element = parser_token.tag_complete || parser_token.is_start_tag && parser_token.is_end_tag;
      parser_token.is_unformatted = !parser_token.tag_complete && in_array(parser_token.tag_check, this._options.unformatted);
      parser_token.is_content_unformatted = !parser_token.is_empty_element && in_array(parser_token.tag_check, this._options.content_unformatted);
      parser_token.is_inline_element = in_array(parser_token.tag_name, this._options.inline) || this._options.inline_custom_elements && parser_token.tag_name.includes("-") || parser_token.tag_start_char === "{";
      return parser_token;
    };
    Beautifier.prototype._set_tag_position = function(printer, raw_token, parser_token, last_tag_token, last_token) {
      if (!parser_token.is_empty_element) {
        if (parser_token.is_end_tag) {
          parser_token.start_tag_token = this._tag_stack.try_pop(parser_token.tag_name);
        } else {
          if (this._do_optional_end_element(parser_token)) {
            if (!parser_token.is_inline_element) {
              printer.print_newline(false);
            }
          }
          this._tag_stack.record_tag(parser_token);
          if ((parser_token.tag_name === "script" || parser_token.tag_name === "style") && !(parser_token.is_unformatted || parser_token.is_content_unformatted)) {
            parser_token.custom_beautifier_name = get_custom_beautifier_name(parser_token.tag_check, raw_token);
          }
        }
      }
      if (in_array(parser_token.tag_check, this._options.extra_liners)) {
        printer.print_newline(false);
        if (!printer._output.just_added_blankline()) {
          printer.print_newline(true);
        }
      }
      if (parser_token.is_empty_element) {
        if (parser_token.tag_start_char === "{" && parser_token.tag_check === "else") {
          this._tag_stack.indent_to_tag(["if", "unless", "each"]);
          parser_token.indent_content = true;
          var foundIfOnCurrentLine = printer.current_line_has_match(/{{#if/);
          if (!foundIfOnCurrentLine) {
            printer.print_newline(false);
          }
        }
        if (parser_token.tag_name === "!--" && last_token.type === TOKEN.TAG_CLOSE && last_tag_token.is_end_tag && parser_token.text.indexOf("\n") === -1) {
        } else {
          if (!(parser_token.is_inline_element || parser_token.is_unformatted)) {
            printer.print_newline(false);
          }
          this._calcluate_parent_multiline(printer, parser_token);
        }
      } else if (parser_token.is_end_tag) {
        var do_end_expand = false;
        do_end_expand = parser_token.start_tag_token && parser_token.start_tag_token.multiline_content;
        do_end_expand = do_end_expand || !parser_token.is_inline_element && !(last_tag_token.is_inline_element || last_tag_token.is_unformatted) && !(last_token.type === TOKEN.TAG_CLOSE && parser_token.start_tag_token === last_tag_token) && last_token.type !== "TK_CONTENT";
        if (parser_token.is_content_unformatted || parser_token.is_unformatted) {
          do_end_expand = false;
        }
        if (do_end_expand) {
          printer.print_newline(false);
        }
      } else {
        parser_token.indent_content = !parser_token.custom_beautifier_name;
        if (parser_token.tag_start_char === "<") {
          if (parser_token.tag_name === "html") {
            parser_token.indent_content = this._options.indent_inner_html;
          } else if (parser_token.tag_name === "head") {
            parser_token.indent_content = this._options.indent_head_inner_html;
          } else if (parser_token.tag_name === "body") {
            parser_token.indent_content = this._options.indent_body_inner_html;
          }
        }
        if (!(parser_token.is_inline_element || parser_token.is_unformatted) && (last_token.type !== "TK_CONTENT" || parser_token.is_content_unformatted)) {
          printer.print_newline(false);
        }
        this._calcluate_parent_multiline(printer, parser_token);
      }
    };
    Beautifier.prototype._calcluate_parent_multiline = function(printer, parser_token) {
      if (parser_token.parent && printer._output.just_added_newline() && !((parser_token.is_inline_element || parser_token.is_unformatted) && parser_token.parent.is_inline_element)) {
        parser_token.parent.multiline_content = true;
      }
    };
    var p_closers = ["address", "article", "aside", "blockquote", "details", "div", "dl", "fieldset", "figcaption", "figure", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "header", "hr", "main", "menu", "nav", "ol", "p", "pre", "section", "table", "ul"];
    var p_parent_excludes = ["a", "audio", "del", "ins", "map", "noscript", "video"];
    Beautifier.prototype._do_optional_end_element = function(parser_token) {
      var result = null;
      if (parser_token.is_empty_element || !parser_token.is_start_tag || !parser_token.parent) {
        return;
      }
      if (parser_token.tag_name === "body") {
        result = result || this._tag_stack.try_pop("head");
      } else if (parser_token.tag_name === "li") {
        result = result || this._tag_stack.try_pop("li", ["ol", "ul", "menu"]);
      } else if (parser_token.tag_name === "dd" || parser_token.tag_name === "dt") {
        result = result || this._tag_stack.try_pop("dt", ["dl"]);
        result = result || this._tag_stack.try_pop("dd", ["dl"]);
      } else if (parser_token.parent.tag_name === "p" && p_closers.indexOf(parser_token.tag_name) !== -1) {
        var p_parent = parser_token.parent.parent;
        if (!p_parent || p_parent_excludes.indexOf(p_parent.tag_name) === -1) {
          result = result || this._tag_stack.try_pop("p");
        }
      } else if (parser_token.tag_name === "rp" || parser_token.tag_name === "rt") {
        result = result || this._tag_stack.try_pop("rt", ["ruby", "rtc"]);
        result = result || this._tag_stack.try_pop("rp", ["ruby", "rtc"]);
      } else if (parser_token.tag_name === "optgroup") {
        result = result || this._tag_stack.try_pop("optgroup", ["select"]);
      } else if (parser_token.tag_name === "option") {
        result = result || this._tag_stack.try_pop("option", ["select", "datalist", "optgroup"]);
      } else if (parser_token.tag_name === "colgroup") {
        result = result || this._tag_stack.try_pop("caption", ["table"]);
      } else if (parser_token.tag_name === "thead") {
        result = result || this._tag_stack.try_pop("caption", ["table"]);
        result = result || this._tag_stack.try_pop("colgroup", ["table"]);
      } else if (parser_token.tag_name === "tbody" || parser_token.tag_name === "tfoot") {
        result = result || this._tag_stack.try_pop("caption", ["table"]);
        result = result || this._tag_stack.try_pop("colgroup", ["table"]);
        result = result || this._tag_stack.try_pop("thead", ["table"]);
        result = result || this._tag_stack.try_pop("tbody", ["table"]);
      } else if (parser_token.tag_name === "tr") {
        result = result || this._tag_stack.try_pop("caption", ["table"]);
        result = result || this._tag_stack.try_pop("colgroup", ["table"]);
        result = result || this._tag_stack.try_pop("tr", ["table", "thead", "tbody", "tfoot"]);
      } else if (parser_token.tag_name === "th" || parser_token.tag_name === "td") {
        result = result || this._tag_stack.try_pop("td", ["table", "thead", "tbody", "tfoot", "tr"]);
        result = result || this._tag_stack.try_pop("th", ["table", "thead", "tbody", "tfoot", "tr"]);
      }
      parser_token.parent = this._tag_stack.get_parser_token();
      return result;
    };
    module2.exports.Beautifier = Beautifier;
  }
});

// node_modules/js-beautify/js/src/html/index.js
var require_html = __commonJS({
  "node_modules/js-beautify/js/src/html/index.js"(exports2, module2) {
    "use strict";
    var Beautifier = require_beautifier3().Beautifier;
    var Options = require_options4().Options;
    function style_html(html_source, options, js_beautify, css_beautify) {
      var beautifier = new Beautifier(html_source, options, js_beautify, css_beautify);
      return beautifier.beautify();
    }
    module2.exports = style_html;
    module2.exports.defaultOptions = function() {
      return new Options();
    };
  }
});

// node_modules/js-beautify/js/src/index.js
var require_src2 = __commonJS({
  "node_modules/js-beautify/js/src/index.js"(exports2, module2) {
    "use strict";
    var js_beautify = require_javascript();
    var css_beautify = require_css();
    var html_beautify = require_html();
    function style_html(html_source, options, js, css) {
      js = js || js_beautify;
      css = css || css_beautify;
      return html_beautify(html_source, options, js, css);
    }
    style_html.defaultOptions = html_beautify.defaultOptions;
    module2.exports.js = js_beautify;
    module2.exports.css = css_beautify;
    module2.exports.html = style_html;
  }
});

// node_modules/js-beautify/js/index.js
var require_js = __commonJS({
  "node_modules/js-beautify/js/index.js"(exports2, module2) {
    "use strict";
    function get_beautify(js_beautify, css_beautify, html_beautify) {
      var beautify = function(src, config) {
        return js_beautify.js_beautify(src, config);
      };
      beautify.js = js_beautify.js_beautify;
      beautify.css = css_beautify.css_beautify;
      beautify.html = html_beautify.html_beautify;
      beautify.js_beautify = js_beautify.js_beautify;
      beautify.css_beautify = css_beautify.css_beautify;
      beautify.html_beautify = html_beautify.html_beautify;
      return beautify;
    }
    if (typeof define === "function" && define.amd) {
      define([
        "./lib/beautify",
        "./lib/beautify-css",
        "./lib/beautify-html"
      ], function(js_beautify, css_beautify, html_beautify) {
        return get_beautify(js_beautify, css_beautify, html_beautify);
      });
    } else {
      (function(mod) {
        var beautifier = require_src2();
        beautifier.js_beautify = beautifier.js;
        beautifier.css_beautify = beautifier.css;
        beautifier.html_beautify = beautifier.html;
        mod.exports = get_beautify(beautifier, beautifier, beautifier);
      })(module2);
    }
  }
});

// node_modules/isexe/windows.js
var require_windows = __commonJS({
  "node_modules/isexe/windows.js"(exports2, module2) {
    module2.exports = isexe;
    isexe.sync = sync;
    var fs = require("fs");
    function checkPathExt(path3, options) {
      var pathext = options.pathExt !== void 0 ? options.pathExt : process.env.PATHEXT;
      if (!pathext) {
        return true;
      }
      pathext = pathext.split(";");
      if (pathext.indexOf("") !== -1) {
        return true;
      }
      for (var i = 0; i < pathext.length; i++) {
        var p = pathext[i].toLowerCase();
        if (p && path3.substr(-p.length).toLowerCase() === p) {
          return true;
        }
      }
      return false;
    }
    function checkStat(stat, path3, options) {
      if (!stat.isSymbolicLink() && !stat.isFile()) {
        return false;
      }
      return checkPathExt(path3, options);
    }
    function isexe(path3, options, cb) {
      fs.stat(path3, function(er, stat) {
        cb(er, er ? false : checkStat(stat, path3, options));
      });
    }
    function sync(path3, options) {
      return checkStat(fs.statSync(path3), path3, options);
    }
  }
});

// node_modules/isexe/mode.js
var require_mode = __commonJS({
  "node_modules/isexe/mode.js"(exports2, module2) {
    module2.exports = isexe;
    isexe.sync = sync;
    var fs = require("fs");
    function isexe(path3, options, cb) {
      fs.stat(path3, function(er, stat) {
        cb(er, er ? false : checkStat(stat, options));
      });
    }
    function sync(path3, options) {
      return checkStat(fs.statSync(path3), options);
    }
    function checkStat(stat, options) {
      return stat.isFile() && checkMode(stat, options);
    }
    function checkMode(stat, options) {
      var mod = stat.mode;
      var uid = stat.uid;
      var gid = stat.gid;
      var myUid = options.uid !== void 0 ? options.uid : process.getuid && process.getuid();
      var myGid = options.gid !== void 0 ? options.gid : process.getgid && process.getgid();
      var u = parseInt("100", 8);
      var g = parseInt("010", 8);
      var o = parseInt("001", 8);
      var ug = u | g;
      var ret = mod & o || mod & g && gid === myGid || mod & u && uid === myUid || mod & ug && myUid === 0;
      return ret;
    }
  }
});

// node_modules/isexe/index.js
var require_isexe = __commonJS({
  "node_modules/isexe/index.js"(exports2, module2) {
    var fs = require("fs");
    var core;
    if (process.platform === "win32" || global.TESTING_WINDOWS) {
      core = require_windows();
    } else {
      core = require_mode();
    }
    module2.exports = isexe;
    isexe.sync = sync;
    function isexe(path3, options, cb) {
      if (typeof options === "function") {
        cb = options;
        options = {};
      }
      if (!cb) {
        if (typeof Promise !== "function") {
          throw new TypeError("callback not provided");
        }
        return new Promise(function(resolve, reject) {
          isexe(path3, options || {}, function(er, is) {
            if (er) {
              reject(er);
            } else {
              resolve(is);
            }
          });
        });
      }
      core(path3, options || {}, function(er, is) {
        if (er) {
          if (er.code === "EACCES" || options && options.ignoreErrors) {
            er = null;
            is = false;
          }
        }
        cb(er, is);
      });
    }
    function sync(path3, options) {
      try {
        return core.sync(path3, options || {});
      } catch (er) {
        if (options && options.ignoreErrors || er.code === "EACCES") {
          return false;
        } else {
          throw er;
        }
      }
    }
  }
});

// node_modules/which/which.js
var require_which = __commonJS({
  "node_modules/which/which.js"(exports2, module2) {
    var isWindows = process.platform === "win32" || process.env.OSTYPE === "cygwin" || process.env.OSTYPE === "msys";
    var path3 = require("path");
    var COLON = isWindows ? ";" : ":";
    var isexe = require_isexe();
    var getNotFoundError = (cmd) => Object.assign(new Error(`not found: ${cmd}`), { code: "ENOENT" });
    var getPathInfo = (cmd, opt) => {
      const colon = opt.colon || COLON;
      const pathEnv = cmd.match(/\//) || isWindows && cmd.match(/\\/) ? [""] : [
        ...isWindows ? [process.cwd()] : [],
        ...(opt.path || process.env.PATH || "").split(colon)
      ];
      const pathExtExe = isWindows ? opt.pathExt || process.env.PATHEXT || ".EXE;.CMD;.BAT;.COM" : "";
      const pathExt = isWindows ? pathExtExe.split(colon) : [""];
      if (isWindows) {
        if (cmd.indexOf(".") !== -1 && pathExt[0] !== "")
          pathExt.unshift("");
      }
      return {
        pathEnv,
        pathExt,
        pathExtExe
      };
    };
    var which = (cmd, opt, cb) => {
      if (typeof opt === "function") {
        cb = opt;
        opt = {};
      }
      if (!opt)
        opt = {};
      const { pathEnv, pathExt, pathExtExe } = getPathInfo(cmd, opt);
      const found = [];
      const step = (i) => new Promise((resolve, reject) => {
        if (i === pathEnv.length)
          return opt.all && found.length ? resolve(found) : reject(getNotFoundError(cmd));
        const ppRaw = pathEnv[i];
        const pathPart = /^".*"$/.test(ppRaw) ? ppRaw.slice(1, -1) : ppRaw;
        const pCmd = path3.join(pathPart, cmd);
        const p = !pathPart && /^\.[\\\/]/.test(cmd) ? cmd.slice(0, 2) + pCmd : pCmd;
        resolve(subStep(p, i, 0));
      });
      const subStep = (p, i, ii) => new Promise((resolve, reject) => {
        if (ii === pathExt.length)
          return resolve(step(i + 1));
        const ext = pathExt[ii];
        isexe(p + ext, { pathExt: pathExtExe }, (er, is) => {
          if (!er && is) {
            if (opt.all)
              found.push(p + ext);
            else
              return resolve(p + ext);
          }
          return resolve(subStep(p, i, ii + 1));
        });
      });
      return cb ? step(0).then((res) => cb(null, res), cb) : step(0);
    };
    var whichSync = (cmd, opt) => {
      opt = opt || {};
      const { pathEnv, pathExt, pathExtExe } = getPathInfo(cmd, opt);
      const found = [];
      for (let i = 0; i < pathEnv.length; i++) {
        const ppRaw = pathEnv[i];
        const pathPart = /^".*"$/.test(ppRaw) ? ppRaw.slice(1, -1) : ppRaw;
        const pCmd = path3.join(pathPart, cmd);
        const p = !pathPart && /^\.[\\\/]/.test(cmd) ? cmd.slice(0, 2) + pCmd : pCmd;
        for (let j = 0; j < pathExt.length; j++) {
          const cur = p + pathExt[j];
          try {
            const is = isexe.sync(cur, { pathExt: pathExtExe });
            if (is) {
              if (opt.all)
                found.push(cur);
              else
                return cur;
            }
          } catch (ex) {
          }
        }
      }
      if (opt.all && found.length)
        return found;
      if (opt.nothrow)
        return null;
      throw getNotFoundError(cmd);
    };
    module2.exports = which;
    which.sync = whichSync;
  }
});

// node_modules/path-key/index.js
var require_path_key = __commonJS({
  "node_modules/path-key/index.js"(exports2, module2) {
    "use strict";
    var pathKey2 = (options = {}) => {
      const environment = options.env || process.env;
      const platform = options.platform || process.platform;
      if (platform !== "win32") {
        return "PATH";
      }
      return Object.keys(environment).reverse().find((key) => key.toUpperCase() === "PATH") || "Path";
    };
    module2.exports = pathKey2;
    module2.exports.default = pathKey2;
  }
});

// node_modules/cross-spawn/lib/util/resolveCommand.js
var require_resolveCommand = __commonJS({
  "node_modules/cross-spawn/lib/util/resolveCommand.js"(exports2, module2) {
    "use strict";
    var path3 = require("path");
    var which = require_which();
    var getPathKey = require_path_key();
    function resolveCommandAttempt(parsed, withoutPathExt) {
      const env = parsed.options.env || process.env;
      const cwd = process.cwd();
      const hasCustomCwd = parsed.options.cwd != null;
      const shouldSwitchCwd = hasCustomCwd && process.chdir !== void 0 && !process.chdir.disabled;
      if (shouldSwitchCwd) {
        try {
          process.chdir(parsed.options.cwd);
        } catch (err) {
        }
      }
      let resolved;
      try {
        resolved = which.sync(parsed.command, {
          path: env[getPathKey({ env })],
          pathExt: withoutPathExt ? path3.delimiter : void 0
        });
      } catch (e) {
      } finally {
        if (shouldSwitchCwd) {
          process.chdir(cwd);
        }
      }
      if (resolved) {
        resolved = path3.resolve(hasCustomCwd ? parsed.options.cwd : "", resolved);
      }
      return resolved;
    }
    function resolveCommand(parsed) {
      return resolveCommandAttempt(parsed) || resolveCommandAttempt(parsed, true);
    }
    module2.exports = resolveCommand;
  }
});

// node_modules/cross-spawn/lib/util/escape.js
var require_escape = __commonJS({
  "node_modules/cross-spawn/lib/util/escape.js"(exports2, module2) {
    "use strict";
    var metaCharsRegExp = /([()\][%!^"`<>&|;, *?])/g;
    function escapeCommand(arg) {
      arg = arg.replace(metaCharsRegExp, "^$1");
      return arg;
    }
    function escapeArgument(arg, doubleEscapeMetaChars) {
      arg = `${arg}`;
      arg = arg.replace(/(\\*)"/g, '$1$1\\"');
      arg = arg.replace(/(\\*)$/, "$1$1");
      arg = `"${arg}"`;
      arg = arg.replace(metaCharsRegExp, "^$1");
      if (doubleEscapeMetaChars) {
        arg = arg.replace(metaCharsRegExp, "^$1");
      }
      return arg;
    }
    module2.exports.command = escapeCommand;
    module2.exports.argument = escapeArgument;
  }
});

// node_modules/shebang-regex/index.js
var require_shebang_regex = __commonJS({
  "node_modules/shebang-regex/index.js"(exports2, module2) {
    "use strict";
    module2.exports = /^#!(.*)/;
  }
});

// node_modules/shebang-command/index.js
var require_shebang_command = __commonJS({
  "node_modules/shebang-command/index.js"(exports2, module2) {
    "use strict";
    var shebangRegex = require_shebang_regex();
    module2.exports = (string = "") => {
      const match = string.match(shebangRegex);
      if (!match) {
        return null;
      }
      const [path3, argument] = match[0].replace(/#! ?/, "").split(" ");
      const binary = path3.split("/").pop();
      if (binary === "env") {
        return argument;
      }
      return argument ? `${binary} ${argument}` : binary;
    };
  }
});

// node_modules/cross-spawn/lib/util/readShebang.js
var require_readShebang = __commonJS({
  "node_modules/cross-spawn/lib/util/readShebang.js"(exports2, module2) {
    "use strict";
    var fs = require("fs");
    var shebangCommand = require_shebang_command();
    function readShebang(command) {
      const size = 150;
      const buffer = Buffer.alloc(size);
      let fd;
      try {
        fd = fs.openSync(command, "r");
        fs.readSync(fd, buffer, 0, size, 0);
        fs.closeSync(fd);
      } catch (e) {
      }
      return shebangCommand(buffer.toString());
    }
    module2.exports = readShebang;
  }
});

// node_modules/cross-spawn/lib/parse.js
var require_parse2 = __commonJS({
  "node_modules/cross-spawn/lib/parse.js"(exports2, module2) {
    "use strict";
    var path3 = require("path");
    var resolveCommand = require_resolveCommand();
    var escape = require_escape();
    var readShebang = require_readShebang();
    var isWin = process.platform === "win32";
    var isExecutableRegExp = /\.(?:com|exe)$/i;
    var isCmdShimRegExp = /node_modules[\\/].bin[\\/][^\\/]+\.cmd$/i;
    function detectShebang(parsed) {
      parsed.file = resolveCommand(parsed);
      const shebang = parsed.file && readShebang(parsed.file);
      if (shebang) {
        parsed.args.unshift(parsed.file);
        parsed.command = shebang;
        return resolveCommand(parsed);
      }
      return parsed.file;
    }
    function parseNonShell(parsed) {
      if (!isWin) {
        return parsed;
      }
      const commandFile = detectShebang(parsed);
      const needsShell = !isExecutableRegExp.test(commandFile);
      if (parsed.options.forceShell || needsShell) {
        const needsDoubleEscapeMetaChars = isCmdShimRegExp.test(commandFile);
        parsed.command = path3.normalize(parsed.command);
        parsed.command = escape.command(parsed.command);
        parsed.args = parsed.args.map((arg) => escape.argument(arg, needsDoubleEscapeMetaChars));
        const shellCommand = [parsed.command].concat(parsed.args).join(" ");
        parsed.args = ["/d", "/s", "/c", `"${shellCommand}"`];
        parsed.command = process.env.comspec || "cmd.exe";
        parsed.options.windowsVerbatimArguments = true;
      }
      return parsed;
    }
    function parse(command, args, options) {
      if (args && !Array.isArray(args)) {
        options = args;
        args = null;
      }
      args = args ? args.slice(0) : [];
      options = Object.assign({}, options);
      const parsed = {
        command,
        args,
        options,
        file: void 0,
        original: {
          command,
          args
        }
      };
      return options.shell ? parsed : parseNonShell(parsed);
    }
    module2.exports = parse;
  }
});

// node_modules/cross-spawn/lib/enoent.js
var require_enoent = __commonJS({
  "node_modules/cross-spawn/lib/enoent.js"(exports2, module2) {
    "use strict";
    var isWin = process.platform === "win32";
    function notFoundError(original, syscall) {
      return Object.assign(new Error(`${syscall} ${original.command} ENOENT`), {
        code: "ENOENT",
        errno: "ENOENT",
        syscall: `${syscall} ${original.command}`,
        path: original.command,
        spawnargs: original.args
      });
    }
    function hookChildProcess(cp, parsed) {
      if (!isWin) {
        return;
      }
      const originalEmit = cp.emit;
      cp.emit = function(name, arg1) {
        if (name === "exit") {
          const err = verifyENOENT(arg1, parsed, "spawn");
          if (err) {
            return originalEmit.call(cp, "error", err);
          }
        }
        return originalEmit.apply(cp, arguments);
      };
    }
    function verifyENOENT(status, parsed) {
      if (isWin && status === 1 && !parsed.file) {
        return notFoundError(parsed.original, "spawn");
      }
      return null;
    }
    function verifyENOENTSync(status, parsed) {
      if (isWin && status === 1 && !parsed.file) {
        return notFoundError(parsed.original, "spawnSync");
      }
      return null;
    }
    module2.exports = {
      hookChildProcess,
      verifyENOENT,
      verifyENOENTSync,
      notFoundError
    };
  }
});

// node_modules/cross-spawn/index.js
var require_cross_spawn = __commonJS({
  "node_modules/cross-spawn/index.js"(exports2, module2) {
    "use strict";
    var cp = require("child_process");
    var parse = require_parse2();
    var enoent = require_enoent();
    function spawn(command, args, options) {
      const parsed = parse(command, args, options);
      const spawned = cp.spawn(parsed.command, parsed.args, parsed.options);
      enoent.hookChildProcess(spawned, parsed);
      return spawned;
    }
    function spawnSync(command, args, options) {
      const parsed = parse(command, args, options);
      const result = cp.spawnSync(parsed.command, parsed.args, parsed.options);
      result.error = result.error || enoent.verifyENOENTSync(result.status, parsed);
      return result;
    }
    module2.exports = spawn;
    module2.exports.spawn = spawn;
    module2.exports.sync = spawnSync;
    module2.exports._parse = parse;
    module2.exports._enoent = enoent;
  }
});

// node_modules/strip-final-newline/index.js
function stripFinalNewline(input) {
  const LF = typeof input === "string" ? "\n" : "\n".charCodeAt();
  const CR = typeof input === "string" ? "\r" : "\r".charCodeAt();
  if (input[input.length - 1] === LF) {
    input = input.slice(0, -1);
  }
  if (input[input.length - 1] === CR) {
    input = input.slice(0, -1);
  }
  return input;
}
var init_strip_final_newline = __esm({
  "node_modules/strip-final-newline/index.js"() {
  }
});

// node_modules/npm-run-path/node_modules/path-key/index.js
function pathKey(options = {}) {
  const {
    env = process.env,
    platform = process.platform
  } = options;
  if (platform !== "win32") {
    return "PATH";
  }
  return Object.keys(env).reverse().find((key) => key.toUpperCase() === "PATH") || "Path";
}
var init_path_key = __esm({
  "node_modules/npm-run-path/node_modules/path-key/index.js"() {
  }
});

// node_modules/npm-run-path/index.js
var import_node_process, import_node_path, import_node_url, npmRunPath, applyPreferLocal, applyExecPath, npmRunPathEnv;
var init_npm_run_path = __esm({
  "node_modules/npm-run-path/index.js"() {
    import_node_process = __toESM(require("node:process"), 1);
    import_node_path = __toESM(require("node:path"), 1);
    import_node_url = require("node:url");
    init_path_key();
    npmRunPath = ({
      cwd = import_node_process.default.cwd(),
      path: pathOption = import_node_process.default.env[pathKey()],
      preferLocal = true,
      execPath = import_node_process.default.execPath,
      addExecPath = true
    } = {}) => {
      const cwdString = cwd instanceof URL ? (0, import_node_url.fileURLToPath)(cwd) : cwd;
      const cwdPath = import_node_path.default.resolve(cwdString);
      const result = [];
      if (preferLocal) {
        applyPreferLocal(result, cwdPath);
      }
      if (addExecPath) {
        applyExecPath(result, execPath, cwdPath);
      }
      return [...result, pathOption].join(import_node_path.default.delimiter);
    };
    applyPreferLocal = (result, cwdPath) => {
      let previous;
      while (previous !== cwdPath) {
        result.push(import_node_path.default.join(cwdPath, "node_modules/.bin"));
        previous = cwdPath;
        cwdPath = import_node_path.default.resolve(cwdPath, "..");
      }
    };
    applyExecPath = (result, execPath, cwdPath) => {
      const execPathString = execPath instanceof URL ? (0, import_node_url.fileURLToPath)(execPath) : execPath;
      result.push(import_node_path.default.resolve(cwdPath, execPathString, ".."));
    };
    npmRunPathEnv = ({ env = import_node_process.default.env, ...options } = {}) => {
      env = { ...env };
      const pathName = pathKey({ env });
      options.path = env[pathName];
      env[pathName] = npmRunPath(options);
      return env;
    };
  }
});

// node_modules/mimic-fn/index.js
function mimicFunction(to, from, { ignoreNonConfigurable = false } = {}) {
  const { name } = to;
  for (const property of Reflect.ownKeys(from)) {
    copyProperty(to, from, property, ignoreNonConfigurable);
  }
  changePrototype(to, from);
  changeToString(to, from, name);
  return to;
}
var copyProperty, canCopyProperty, changePrototype, wrappedToString, toStringDescriptor, toStringName, changeToString;
var init_mimic_fn = __esm({
  "node_modules/mimic-fn/index.js"() {
    copyProperty = (to, from, property, ignoreNonConfigurable) => {
      if (property === "length" || property === "prototype") {
        return;
      }
      if (property === "arguments" || property === "caller") {
        return;
      }
      const toDescriptor = Object.getOwnPropertyDescriptor(to, property);
      const fromDescriptor = Object.getOwnPropertyDescriptor(from, property);
      if (!canCopyProperty(toDescriptor, fromDescriptor) && ignoreNonConfigurable) {
        return;
      }
      Object.defineProperty(to, property, fromDescriptor);
    };
    canCopyProperty = function(toDescriptor, fromDescriptor) {
      return toDescriptor === void 0 || toDescriptor.configurable || toDescriptor.writable === fromDescriptor.writable && toDescriptor.enumerable === fromDescriptor.enumerable && toDescriptor.configurable === fromDescriptor.configurable && (toDescriptor.writable || toDescriptor.value === fromDescriptor.value);
    };
    changePrototype = (to, from) => {
      const fromPrototype = Object.getPrototypeOf(from);
      if (fromPrototype === Object.getPrototypeOf(to)) {
        return;
      }
      Object.setPrototypeOf(to, fromPrototype);
    };
    wrappedToString = (withName, fromBody) => `/* Wrapped ${withName}*/
${fromBody}`;
    toStringDescriptor = Object.getOwnPropertyDescriptor(Function.prototype, "toString");
    toStringName = Object.getOwnPropertyDescriptor(Function.prototype.toString, "name");
    changeToString = (to, from, name) => {
      const withName = name === "" ? "" : `with ${name.trim()}() `;
      const newToString = wrappedToString.bind(null, withName, from.toString());
      Object.defineProperty(newToString, "name", toStringName);
      Object.defineProperty(to, "toString", { ...toStringDescriptor, value: newToString });
    };
  }
});

// node_modules/onetime/index.js
var calledFunctions, onetime, onetime_default;
var init_onetime = __esm({
  "node_modules/onetime/index.js"() {
    init_mimic_fn();
    calledFunctions = /* @__PURE__ */ new WeakMap();
    onetime = (function_, options = {}) => {
      if (typeof function_ !== "function") {
        throw new TypeError("Expected a function");
      }
      let returnValue;
      let callCount = 0;
      const functionName = function_.displayName || function_.name || "<anonymous>";
      const onetime2 = function(...arguments_) {
        calledFunctions.set(onetime2, ++callCount);
        if (callCount === 1) {
          returnValue = function_.apply(this, arguments_);
          function_ = null;
        } else if (options.throw === true) {
          throw new Error(`Function \`${functionName}\` can only be called once`);
        }
        return returnValue;
      };
      mimicFunction(onetime2, function_);
      calledFunctions.set(onetime2, callCount);
      return onetime2;
    };
    onetime.callCount = (function_) => {
      if (!calledFunctions.has(function_)) {
        throw new Error(`The given function \`${function_.name}\` is not wrapped by the \`onetime\` package`);
      }
      return calledFunctions.get(function_);
    };
    onetime_default = onetime;
  }
});

// node_modules/human-signals/build/src/realtime.js
var getRealtimeSignals, getRealtimeSignal, SIGRTMIN, SIGRTMAX;
var init_realtime = __esm({
  "node_modules/human-signals/build/src/realtime.js"() {
    getRealtimeSignals = function() {
      const length = SIGRTMAX - SIGRTMIN + 1;
      return Array.from({ length }, getRealtimeSignal);
    };
    getRealtimeSignal = function(value, index) {
      return {
        name: `SIGRT${index + 1}`,
        number: SIGRTMIN + index,
        action: "terminate",
        description: "Application-specific signal (realtime)",
        standard: "posix"
      };
    };
    SIGRTMIN = 34;
    SIGRTMAX = 64;
  }
});

// node_modules/human-signals/build/src/core.js
var SIGNALS;
var init_core = __esm({
  "node_modules/human-signals/build/src/core.js"() {
    SIGNALS = [
      {
        name: "SIGHUP",
        number: 1,
        action: "terminate",
        description: "Terminal closed",
        standard: "posix"
      },
      {
        name: "SIGINT",
        number: 2,
        action: "terminate",
        description: "User interruption with CTRL-C",
        standard: "ansi"
      },
      {
        name: "SIGQUIT",
        number: 3,
        action: "core",
        description: "User interruption with CTRL-\\",
        standard: "posix"
      },
      {
        name: "SIGILL",
        number: 4,
        action: "core",
        description: "Invalid machine instruction",
        standard: "ansi"
      },
      {
        name: "SIGTRAP",
        number: 5,
        action: "core",
        description: "Debugger breakpoint",
        standard: "posix"
      },
      {
        name: "SIGABRT",
        number: 6,
        action: "core",
        description: "Aborted",
        standard: "ansi"
      },
      {
        name: "SIGIOT",
        number: 6,
        action: "core",
        description: "Aborted",
        standard: "bsd"
      },
      {
        name: "SIGBUS",
        number: 7,
        action: "core",
        description: "Bus error due to misaligned, non-existing address or paging error",
        standard: "bsd"
      },
      {
        name: "SIGEMT",
        number: 7,
        action: "terminate",
        description: "Command should be emulated but is not implemented",
        standard: "other"
      },
      {
        name: "SIGFPE",
        number: 8,
        action: "core",
        description: "Floating point arithmetic error",
        standard: "ansi"
      },
      {
        name: "SIGKILL",
        number: 9,
        action: "terminate",
        description: "Forced termination",
        standard: "posix",
        forced: true
      },
      {
        name: "SIGUSR1",
        number: 10,
        action: "terminate",
        description: "Application-specific signal",
        standard: "posix"
      },
      {
        name: "SIGSEGV",
        number: 11,
        action: "core",
        description: "Segmentation fault",
        standard: "ansi"
      },
      {
        name: "SIGUSR2",
        number: 12,
        action: "terminate",
        description: "Application-specific signal",
        standard: "posix"
      },
      {
        name: "SIGPIPE",
        number: 13,
        action: "terminate",
        description: "Broken pipe or socket",
        standard: "posix"
      },
      {
        name: "SIGALRM",
        number: 14,
        action: "terminate",
        description: "Timeout or timer",
        standard: "posix"
      },
      {
        name: "SIGTERM",
        number: 15,
        action: "terminate",
        description: "Termination",
        standard: "ansi"
      },
      {
        name: "SIGSTKFLT",
        number: 16,
        action: "terminate",
        description: "Stack is empty or overflowed",
        standard: "other"
      },
      {
        name: "SIGCHLD",
        number: 17,
        action: "ignore",
        description: "Child process terminated, paused or unpaused",
        standard: "posix"
      },
      {
        name: "SIGCLD",
        number: 17,
        action: "ignore",
        description: "Child process terminated, paused or unpaused",
        standard: "other"
      },
      {
        name: "SIGCONT",
        number: 18,
        action: "unpause",
        description: "Unpaused",
        standard: "posix",
        forced: true
      },
      {
        name: "SIGSTOP",
        number: 19,
        action: "pause",
        description: "Paused",
        standard: "posix",
        forced: true
      },
      {
        name: "SIGTSTP",
        number: 20,
        action: "pause",
        description: 'Paused using CTRL-Z or "suspend"',
        standard: "posix"
      },
      {
        name: "SIGTTIN",
        number: 21,
        action: "pause",
        description: "Background process cannot read terminal input",
        standard: "posix"
      },
      {
        name: "SIGBREAK",
        number: 21,
        action: "terminate",
        description: "User interruption with CTRL-BREAK",
        standard: "other"
      },
      {
        name: "SIGTTOU",
        number: 22,
        action: "pause",
        description: "Background process cannot write to terminal output",
        standard: "posix"
      },
      {
        name: "SIGURG",
        number: 23,
        action: "ignore",
        description: "Socket received out-of-band data",
        standard: "bsd"
      },
      {
        name: "SIGXCPU",
        number: 24,
        action: "core",
        description: "Process timed out",
        standard: "bsd"
      },
      {
        name: "SIGXFSZ",
        number: 25,
        action: "core",
        description: "File too big",
        standard: "bsd"
      },
      {
        name: "SIGVTALRM",
        number: 26,
        action: "terminate",
        description: "Timeout or timer",
        standard: "bsd"
      },
      {
        name: "SIGPROF",
        number: 27,
        action: "terminate",
        description: "Timeout or timer",
        standard: "bsd"
      },
      {
        name: "SIGWINCH",
        number: 28,
        action: "ignore",
        description: "Terminal window size changed",
        standard: "bsd"
      },
      {
        name: "SIGIO",
        number: 29,
        action: "terminate",
        description: "I/O is available",
        standard: "other"
      },
      {
        name: "SIGPOLL",
        number: 29,
        action: "terminate",
        description: "Watched event",
        standard: "other"
      },
      {
        name: "SIGINFO",
        number: 29,
        action: "ignore",
        description: "Request for process information",
        standard: "other"
      },
      {
        name: "SIGPWR",
        number: 30,
        action: "terminate",
        description: "Device running out of power",
        standard: "systemv"
      },
      {
        name: "SIGSYS",
        number: 31,
        action: "core",
        description: "Invalid system call",
        standard: "other"
      },
      {
        name: "SIGUNUSED",
        number: 31,
        action: "terminate",
        description: "Invalid system call",
        standard: "other"
      }
    ];
  }
});

// node_modules/human-signals/build/src/signals.js
var import_os, getSignals, normalizeSignal;
var init_signals = __esm({
  "node_modules/human-signals/build/src/signals.js"() {
    import_os = require("os");
    init_core();
    init_realtime();
    getSignals = function() {
      const realtimeSignals = getRealtimeSignals();
      const signals = [...SIGNALS, ...realtimeSignals].map(normalizeSignal);
      return signals;
    };
    normalizeSignal = function({
      name,
      number: defaultNumber,
      description,
      action,
      forced = false,
      standard
    }) {
      const {
        signals: { [name]: constantSignal }
      } = import_os.constants;
      const supported = constantSignal !== void 0;
      const number = supported ? constantSignal : defaultNumber;
      return { name, number, description, supported, action, forced, standard };
    };
  }
});

// node_modules/human-signals/build/src/main.js
var import_os2, getSignalsByName, getSignalByName, signalsByName, getSignalsByNumber, getSignalByNumber, findSignalByNumber, signalsByNumber;
var init_main = __esm({
  "node_modules/human-signals/build/src/main.js"() {
    import_os2 = require("os");
    init_realtime();
    init_signals();
    getSignalsByName = function() {
      const signals = getSignals();
      return signals.reduce(getSignalByName, {});
    };
    getSignalByName = function(signalByNameMemo, { name, number, description, supported, action, forced, standard }) {
      return {
        ...signalByNameMemo,
        [name]: { name, number, description, supported, action, forced, standard }
      };
    };
    signalsByName = getSignalsByName();
    getSignalsByNumber = function() {
      const signals = getSignals();
      const length = SIGRTMAX + 1;
      const signalsA = Array.from({ length }, (value, number) => getSignalByNumber(number, signals));
      return Object.assign({}, ...signalsA);
    };
    getSignalByNumber = function(number, signals) {
      const signal = findSignalByNumber(number, signals);
      if (signal === void 0) {
        return {};
      }
      const { name, description, supported, action, forced, standard } = signal;
      return {
        [number]: {
          name,
          number,
          description,
          supported,
          action,
          forced,
          standard
        }
      };
    };
    findSignalByNumber = function(number, signals) {
      const signal = signals.find(({ name }) => import_os2.constants.signals[name] === number);
      if (signal !== void 0) {
        return signal;
      }
      return signals.find((signalA) => signalA.number === number);
    };
    signalsByNumber = getSignalsByNumber();
  }
});

// node_modules/execa/lib/error.js
var getErrorPrefix, makeError;
var init_error = __esm({
  "node_modules/execa/lib/error.js"() {
    init_main();
    getErrorPrefix = ({ timedOut, timeout, errorCode, signal, signalDescription, exitCode, isCanceled }) => {
      if (timedOut) {
        return `timed out after ${timeout} milliseconds`;
      }
      if (isCanceled) {
        return "was canceled";
      }
      if (errorCode !== void 0) {
        return `failed with ${errorCode}`;
      }
      if (signal !== void 0) {
        return `was killed with ${signal} (${signalDescription})`;
      }
      if (exitCode !== void 0) {
        return `failed with exit code ${exitCode}`;
      }
      return "failed";
    };
    makeError = ({
      stdout,
      stderr,
      all,
      error,
      signal,
      exitCode,
      command,
      escapedCommand,
      timedOut,
      isCanceled,
      killed,
      parsed: { options: { timeout } }
    }) => {
      exitCode = exitCode === null ? void 0 : exitCode;
      signal = signal === null ? void 0 : signal;
      const signalDescription = signal === void 0 ? void 0 : signalsByName[signal].description;
      const errorCode = error && error.code;
      const prefix = getErrorPrefix({ timedOut, timeout, errorCode, signal, signalDescription, exitCode, isCanceled });
      const execaMessage = `Command ${prefix}: ${command}`;
      const isError = Object.prototype.toString.call(error) === "[object Error]";
      const shortMessage = isError ? `${execaMessage}
${error.message}` : execaMessage;
      const message = [shortMessage, stderr, stdout].filter(Boolean).join("\n");
      if (isError) {
        error.originalMessage = error.message;
        error.message = message;
      } else {
        error = new Error(message);
      }
      error.shortMessage = shortMessage;
      error.command = command;
      error.escapedCommand = escapedCommand;
      error.exitCode = exitCode;
      error.signal = signal;
      error.signalDescription = signalDescription;
      error.stdout = stdout;
      error.stderr = stderr;
      if (all !== void 0) {
        error.all = all;
      }
      if ("bufferedData" in error) {
        delete error.bufferedData;
      }
      error.failed = true;
      error.timedOut = Boolean(timedOut);
      error.isCanceled = isCanceled;
      error.killed = killed && !timedOut;
      return error;
    };
  }
});

// node_modules/execa/lib/stdio.js
var aliases, hasAlias, normalizeStdio, normalizeStdioNode;
var init_stdio = __esm({
  "node_modules/execa/lib/stdio.js"() {
    aliases = ["stdin", "stdout", "stderr"];
    hasAlias = (options) => aliases.some((alias) => options[alias] !== void 0);
    normalizeStdio = (options) => {
      if (!options) {
        return;
      }
      const { stdio } = options;
      if (stdio === void 0) {
        return aliases.map((alias) => options[alias]);
      }
      if (hasAlias(options)) {
        throw new Error(`It's not possible to provide \`stdio\` in combination with one of ${aliases.map((alias) => `\`${alias}\``).join(", ")}`);
      }
      if (typeof stdio === "string") {
        return stdio;
      }
      if (!Array.isArray(stdio)) {
        throw new TypeError(`Expected \`stdio\` to be of type \`string\` or \`Array\`, got \`${typeof stdio}\``);
      }
      const length = Math.max(stdio.length, aliases.length);
      return Array.from({ length }, (value, index) => stdio[index]);
    };
    normalizeStdioNode = (options) => {
      const stdio = normalizeStdio(options);
      if (stdio === "ipc") {
        return "ipc";
      }
      if (stdio === void 0 || typeof stdio === "string") {
        return [stdio, stdio, stdio, "ipc"];
      }
      if (stdio.includes("ipc")) {
        return stdio;
      }
      return [...stdio, "ipc"];
    };
  }
});

// node_modules/signal-exit/signals.js
var require_signals = __commonJS({
  "node_modules/signal-exit/signals.js"(exports2, module2) {
    module2.exports = [
      "SIGABRT",
      "SIGALRM",
      "SIGHUP",
      "SIGINT",
      "SIGTERM"
    ];
    if (process.platform !== "win32") {
      module2.exports.push(
        "SIGVTALRM",
        "SIGXCPU",
        "SIGXFSZ",
        "SIGUSR2",
        "SIGTRAP",
        "SIGSYS",
        "SIGQUIT",
        "SIGIOT"
      );
    }
    if (process.platform === "linux") {
      module2.exports.push(
        "SIGIO",
        "SIGPOLL",
        "SIGPWR",
        "SIGSTKFLT",
        "SIGUNUSED"
      );
    }
  }
});

// node_modules/signal-exit/index.js
var require_signal_exit = __commonJS({
  "node_modules/signal-exit/index.js"(exports2, module2) {
    var process4 = global.process;
    var processOk = function(process5) {
      return process5 && typeof process5 === "object" && typeof process5.removeListener === "function" && typeof process5.emit === "function" && typeof process5.reallyExit === "function" && typeof process5.listeners === "function" && typeof process5.kill === "function" && typeof process5.pid === "number" && typeof process5.on === "function";
    };
    if (!processOk(process4)) {
      module2.exports = function() {
        return function() {
        };
      };
    } else {
      assert = require("assert");
      signals = require_signals();
      isWin = /^win/i.test(process4.platform);
      EE = require("events");
      if (typeof EE !== "function") {
        EE = EE.EventEmitter;
      }
      if (process4.__signal_exit_emitter__) {
        emitter = process4.__signal_exit_emitter__;
      } else {
        emitter = process4.__signal_exit_emitter__ = new EE();
        emitter.count = 0;
        emitter.emitted = {};
      }
      if (!emitter.infinite) {
        emitter.setMaxListeners(Infinity);
        emitter.infinite = true;
      }
      module2.exports = function(cb, opts) {
        if (!processOk(global.process)) {
          return function() {
          };
        }
        assert.equal(typeof cb, "function", "a callback must be provided for exit handler");
        if (loaded === false) {
          load();
        }
        var ev = "exit";
        if (opts && opts.alwaysLast) {
          ev = "afterexit";
        }
        var remove = function() {
          emitter.removeListener(ev, cb);
          if (emitter.listeners("exit").length === 0 && emitter.listeners("afterexit").length === 0) {
            unload();
          }
        };
        emitter.on(ev, cb);
        return remove;
      };
      unload = function unload2() {
        if (!loaded || !processOk(global.process)) {
          return;
        }
        loaded = false;
        signals.forEach(function(sig) {
          try {
            process4.removeListener(sig, sigListeners[sig]);
          } catch (er) {
          }
        });
        process4.emit = originalProcessEmit;
        process4.reallyExit = originalProcessReallyExit;
        emitter.count -= 1;
      };
      module2.exports.unload = unload;
      emit = function emit2(event, code, signal) {
        if (emitter.emitted[event]) {
          return;
        }
        emitter.emitted[event] = true;
        emitter.emit(event, code, signal);
      };
      sigListeners = {};
      signals.forEach(function(sig) {
        sigListeners[sig] = function listener() {
          if (!processOk(global.process)) {
            return;
          }
          var listeners = process4.listeners(sig);
          if (listeners.length === emitter.count) {
            unload();
            emit("exit", null, sig);
            emit("afterexit", null, sig);
            if (isWin && sig === "SIGHUP") {
              sig = "SIGINT";
            }
            process4.kill(process4.pid, sig);
          }
        };
      });
      module2.exports.signals = function() {
        return signals;
      };
      loaded = false;
      load = function load2() {
        if (loaded || !processOk(global.process)) {
          return;
        }
        loaded = true;
        emitter.count += 1;
        signals = signals.filter(function(sig) {
          try {
            process4.on(sig, sigListeners[sig]);
            return true;
          } catch (er) {
            return false;
          }
        });
        process4.emit = processEmit;
        process4.reallyExit = processReallyExit;
      };
      module2.exports.load = load;
      originalProcessReallyExit = process4.reallyExit;
      processReallyExit = function processReallyExit2(code) {
        if (!processOk(global.process)) {
          return;
        }
        process4.exitCode = code || 0;
        emit("exit", process4.exitCode, null);
        emit("afterexit", process4.exitCode, null);
        originalProcessReallyExit.call(process4, process4.exitCode);
      };
      originalProcessEmit = process4.emit;
      processEmit = function processEmit2(ev, arg) {
        if (ev === "exit" && processOk(global.process)) {
          if (arg !== void 0) {
            process4.exitCode = arg;
          }
          var ret = originalProcessEmit.apply(this, arguments);
          emit("exit", process4.exitCode, null);
          emit("afterexit", process4.exitCode, null);
          return ret;
        } else {
          return originalProcessEmit.apply(this, arguments);
        }
      };
    }
    var assert;
    var signals;
    var isWin;
    var EE;
    var emitter;
    var unload;
    var emit;
    var sigListeners;
    var loaded;
    var load;
    var originalProcessReallyExit;
    var processReallyExit;
    var originalProcessEmit;
    var processEmit;
  }
});

// node_modules/execa/lib/kill.js
var import_node_os, import_signal_exit, DEFAULT_FORCE_KILL_TIMEOUT, spawnedKill, setKillTimeout, shouldForceKill, isSigterm, getForceKillAfterTimeout, spawnedCancel, timeoutKill, setupTimeout, validateTimeout, setExitHandler;
var init_kill = __esm({
  "node_modules/execa/lib/kill.js"() {
    import_node_os = __toESM(require("node:os"), 1);
    import_signal_exit = __toESM(require_signal_exit(), 1);
    DEFAULT_FORCE_KILL_TIMEOUT = 1e3 * 5;
    spawnedKill = (kill, signal = "SIGTERM", options = {}) => {
      const killResult = kill(signal);
      setKillTimeout(kill, signal, options, killResult);
      return killResult;
    };
    setKillTimeout = (kill, signal, options, killResult) => {
      if (!shouldForceKill(signal, options, killResult)) {
        return;
      }
      const timeout = getForceKillAfterTimeout(options);
      const t = setTimeout(() => {
        kill("SIGKILL");
      }, timeout);
      if (t.unref) {
        t.unref();
      }
    };
    shouldForceKill = (signal, { forceKillAfterTimeout }, killResult) => isSigterm(signal) && forceKillAfterTimeout !== false && killResult;
    isSigterm = (signal) => signal === import_node_os.default.constants.signals.SIGTERM || typeof signal === "string" && signal.toUpperCase() === "SIGTERM";
    getForceKillAfterTimeout = ({ forceKillAfterTimeout = true }) => {
      if (forceKillAfterTimeout === true) {
        return DEFAULT_FORCE_KILL_TIMEOUT;
      }
      if (!Number.isFinite(forceKillAfterTimeout) || forceKillAfterTimeout < 0) {
        throw new TypeError(`Expected the \`forceKillAfterTimeout\` option to be a non-negative integer, got \`${forceKillAfterTimeout}\` (${typeof forceKillAfterTimeout})`);
      }
      return forceKillAfterTimeout;
    };
    spawnedCancel = (spawned, context) => {
      const killResult = spawned.kill();
      if (killResult) {
        context.isCanceled = true;
      }
    };
    timeoutKill = (spawned, signal, reject) => {
      spawned.kill(signal);
      reject(Object.assign(new Error("Timed out"), { timedOut: true, signal }));
    };
    setupTimeout = (spawned, { timeout, killSignal = "SIGTERM" }, spawnedPromise) => {
      if (timeout === 0 || timeout === void 0) {
        return spawnedPromise;
      }
      let timeoutId;
      const timeoutPromise = new Promise((resolve, reject) => {
        timeoutId = setTimeout(() => {
          timeoutKill(spawned, killSignal, reject);
        }, timeout);
      });
      const safeSpawnedPromise = spawnedPromise.finally(() => {
        clearTimeout(timeoutId);
      });
      return Promise.race([timeoutPromise, safeSpawnedPromise]);
    };
    validateTimeout = ({ timeout }) => {
      if (timeout !== void 0 && (!Number.isFinite(timeout) || timeout < 0)) {
        throw new TypeError(`Expected the \`timeout\` option to be a non-negative integer, got \`${timeout}\` (${typeof timeout})`);
      }
    };
    setExitHandler = async (spawned, { cleanup, detached }, timedPromise) => {
      if (!cleanup || detached) {
        return timedPromise;
      }
      const removeExitHandler = (0, import_signal_exit.default)(() => {
        spawned.kill();
      });
      return timedPromise.finally(() => {
        removeExitHandler();
      });
    };
  }
});

// node_modules/is-stream/index.js
function isStream(stream) {
  return stream !== null && typeof stream === "object" && typeof stream.pipe === "function";
}
var init_is_stream = __esm({
  "node_modules/is-stream/index.js"() {
  }
});

// node_modules/get-stream/buffer-stream.js
var require_buffer_stream = __commonJS({
  "node_modules/get-stream/buffer-stream.js"(exports2, module2) {
    "use strict";
    var { PassThrough: PassThroughStream } = require("stream");
    module2.exports = (options) => {
      options = { ...options };
      const { array } = options;
      let { encoding } = options;
      const isBuffer = encoding === "buffer";
      let objectMode = false;
      if (array) {
        objectMode = !(encoding || isBuffer);
      } else {
        encoding = encoding || "utf8";
      }
      if (isBuffer) {
        encoding = null;
      }
      const stream = new PassThroughStream({ objectMode });
      if (encoding) {
        stream.setEncoding(encoding);
      }
      let length = 0;
      const chunks = [];
      stream.on("data", (chunk) => {
        chunks.push(chunk);
        if (objectMode) {
          length = chunks.length;
        } else {
          length += chunk.length;
        }
      });
      stream.getBufferedValue = () => {
        if (array) {
          return chunks;
        }
        return isBuffer ? Buffer.concat(chunks, length) : chunks.join("");
      };
      stream.getBufferedLength = () => length;
      return stream;
    };
  }
});

// node_modules/get-stream/index.js
var require_get_stream = __commonJS({
  "node_modules/get-stream/index.js"(exports2, module2) {
    "use strict";
    var { constants: BufferConstants } = require("buffer");
    var stream = require("stream");
    var { promisify } = require("util");
    var bufferStream = require_buffer_stream();
    var streamPipelinePromisified = promisify(stream.pipeline);
    var MaxBufferError = class extends Error {
      constructor() {
        super("maxBuffer exceeded");
        this.name = "MaxBufferError";
      }
    };
    async function getStream2(inputStream, options) {
      if (!inputStream) {
        throw new Error("Expected a stream");
      }
      options = {
        maxBuffer: Infinity,
        ...options
      };
      const { maxBuffer } = options;
      const stream2 = bufferStream(options);
      await new Promise((resolve, reject) => {
        const rejectPromise = (error) => {
          if (error && stream2.getBufferedLength() <= BufferConstants.MAX_LENGTH) {
            error.bufferedData = stream2.getBufferedValue();
          }
          reject(error);
        };
        (async () => {
          try {
            await streamPipelinePromisified(inputStream, stream2);
            resolve();
          } catch (error) {
            rejectPromise(error);
          }
        })();
        stream2.on("data", () => {
          if (stream2.getBufferedLength() > maxBuffer) {
            rejectPromise(new MaxBufferError());
          }
        });
      });
      return stream2.getBufferedValue();
    }
    module2.exports = getStream2;
    module2.exports.buffer = (stream2, options) => getStream2(stream2, { ...options, encoding: "buffer" });
    module2.exports.array = (stream2, options) => getStream2(stream2, { ...options, array: true });
    module2.exports.MaxBufferError = MaxBufferError;
  }
});

// node_modules/merge-stream/index.js
var require_merge_stream = __commonJS({
  "node_modules/merge-stream/index.js"(exports2, module2) {
    "use strict";
    var { PassThrough } = require("stream");
    module2.exports = function() {
      var sources = [];
      var output = new PassThrough({ objectMode: true });
      output.setMaxListeners(0);
      output.add = add;
      output.isEmpty = isEmpty;
      output.on("unpipe", remove);
      Array.prototype.slice.call(arguments).forEach(add);
      return output;
      function add(source) {
        if (Array.isArray(source)) {
          source.forEach(add);
          return this;
        }
        sources.push(source);
        source.once("end", remove.bind(null, source));
        source.once("error", output.emit.bind(output, "error"));
        source.pipe(output, { end: false });
        return this;
      }
      function isEmpty() {
        return sources.length == 0;
      }
      function remove(source) {
        sources = sources.filter(function(it) {
          return it !== source;
        });
        if (!sources.length && output.readable) {
          output.end();
        }
      }
    };
  }
});

// node_modules/execa/lib/stream.js
var import_get_stream, import_merge_stream, handleInput, makeAllStream, getBufferedData, getStreamPromise, getSpawnedResult, validateInputSync;
var init_stream = __esm({
  "node_modules/execa/lib/stream.js"() {
    init_is_stream();
    import_get_stream = __toESM(require_get_stream(), 1);
    import_merge_stream = __toESM(require_merge_stream(), 1);
    handleInput = (spawned, input) => {
      if (input === void 0 || spawned.stdin === void 0) {
        return;
      }
      if (isStream(input)) {
        input.pipe(spawned.stdin);
      } else {
        spawned.stdin.end(input);
      }
    };
    makeAllStream = (spawned, { all }) => {
      if (!all || !spawned.stdout && !spawned.stderr) {
        return;
      }
      const mixed = (0, import_merge_stream.default)();
      if (spawned.stdout) {
        mixed.add(spawned.stdout);
      }
      if (spawned.stderr) {
        mixed.add(spawned.stderr);
      }
      return mixed;
    };
    getBufferedData = async (stream, streamPromise) => {
      if (!stream) {
        return;
      }
      stream.destroy();
      try {
        return await streamPromise;
      } catch (error) {
        return error.bufferedData;
      }
    };
    getStreamPromise = (stream, { encoding, buffer, maxBuffer }) => {
      if (!stream || !buffer) {
        return;
      }
      if (encoding) {
        return (0, import_get_stream.default)(stream, { encoding, maxBuffer });
      }
      return import_get_stream.default.buffer(stream, { maxBuffer });
    };
    getSpawnedResult = async ({ stdout, stderr, all }, { encoding, buffer, maxBuffer }, processDone) => {
      const stdoutPromise = getStreamPromise(stdout, { encoding, buffer, maxBuffer });
      const stderrPromise = getStreamPromise(stderr, { encoding, buffer, maxBuffer });
      const allPromise = getStreamPromise(all, { encoding, buffer, maxBuffer: maxBuffer * 2 });
      try {
        return await Promise.all([processDone, stdoutPromise, stderrPromise, allPromise]);
      } catch (error) {
        return Promise.all([
          { error, signal: error.signal, timedOut: error.timedOut },
          getBufferedData(stdout, stdoutPromise),
          getBufferedData(stderr, stderrPromise),
          getBufferedData(all, allPromise)
        ]);
      }
    };
    validateInputSync = ({ input }) => {
      if (isStream(input)) {
        throw new TypeError("The `input` option cannot be a stream in sync mode");
      }
    };
  }
});

// node_modules/execa/lib/promise.js
var nativePromisePrototype, descriptors, mergePromise, getSpawnedPromise;
var init_promise = __esm({
  "node_modules/execa/lib/promise.js"() {
    nativePromisePrototype = (async () => {
    })().constructor.prototype;
    descriptors = ["then", "catch", "finally"].map((property) => [
      property,
      Reflect.getOwnPropertyDescriptor(nativePromisePrototype, property)
    ]);
    mergePromise = (spawned, promise) => {
      for (const [property, descriptor] of descriptors) {
        const value = typeof promise === "function" ? (...args) => Reflect.apply(descriptor.value, promise(), args) : descriptor.value.bind(promise);
        Reflect.defineProperty(spawned, property, { ...descriptor, value });
      }
      return spawned;
    };
    getSpawnedPromise = (spawned) => new Promise((resolve, reject) => {
      spawned.on("exit", (exitCode, signal) => {
        resolve({ exitCode, signal });
      });
      spawned.on("error", (error) => {
        reject(error);
      });
      if (spawned.stdin) {
        spawned.stdin.on("error", (error) => {
          reject(error);
        });
      }
    });
  }
});

// node_modules/execa/lib/command.js
var normalizeArgs, NO_ESCAPE_REGEXP, DOUBLE_QUOTES_REGEXP, escapeArg, joinCommand, getEscapedCommand, SPACES_REGEXP, parseCommand;
var init_command = __esm({
  "node_modules/execa/lib/command.js"() {
    normalizeArgs = (file, args = []) => {
      if (!Array.isArray(args)) {
        return [file];
      }
      return [file, ...args];
    };
    NO_ESCAPE_REGEXP = /^[\w.-]+$/;
    DOUBLE_QUOTES_REGEXP = /"/g;
    escapeArg = (arg) => {
      if (typeof arg !== "string" || NO_ESCAPE_REGEXP.test(arg)) {
        return arg;
      }
      return `"${arg.replace(DOUBLE_QUOTES_REGEXP, '\\"')}"`;
    };
    joinCommand = (file, args) => normalizeArgs(file, args).join(" ");
    getEscapedCommand = (file, args) => normalizeArgs(file, args).map((arg) => escapeArg(arg)).join(" ");
    SPACES_REGEXP = / +/g;
    parseCommand = (command) => {
      const tokens = [];
      for (const token of command.trim().split(SPACES_REGEXP)) {
        const previousToken = tokens[tokens.length - 1];
        if (previousToken && previousToken.endsWith("\\")) {
          tokens[tokens.length - 1] = `${previousToken.slice(0, -1)} ${token}`;
        } else {
          tokens.push(token);
        }
      }
      return tokens;
    };
  }
});

// node_modules/execa/index.js
var execa_exports = {};
__export(execa_exports, {
  execa: () => execa,
  execaCommand: () => execaCommand,
  execaCommandSync: () => execaCommandSync,
  execaNode: () => execaNode,
  execaSync: () => execaSync
});
function execa(file, args, options) {
  const parsed = handleArguments(file, args, options);
  const command = joinCommand(file, args);
  const escapedCommand = getEscapedCommand(file, args);
  validateTimeout(parsed.options);
  let spawned;
  try {
    spawned = import_node_child_process.default.spawn(parsed.file, parsed.args, parsed.options);
  } catch (error) {
    const dummySpawned = new import_node_child_process.default.ChildProcess();
    const errorPromise = Promise.reject(makeError({
      error,
      stdout: "",
      stderr: "",
      all: "",
      command,
      escapedCommand,
      parsed,
      timedOut: false,
      isCanceled: false,
      killed: false
    }));
    return mergePromise(dummySpawned, errorPromise);
  }
  const spawnedPromise = getSpawnedPromise(spawned);
  const timedPromise = setupTimeout(spawned, parsed.options, spawnedPromise);
  const processDone = setExitHandler(spawned, parsed.options, timedPromise);
  const context = { isCanceled: false };
  spawned.kill = spawnedKill.bind(null, spawned.kill.bind(spawned));
  spawned.cancel = spawnedCancel.bind(null, spawned, context);
  const handlePromise = async () => {
    const [{ error, exitCode, signal, timedOut }, stdoutResult, stderrResult, allResult] = await getSpawnedResult(spawned, parsed.options, processDone);
    const stdout = handleOutput(parsed.options, stdoutResult);
    const stderr = handleOutput(parsed.options, stderrResult);
    const all = handleOutput(parsed.options, allResult);
    if (error || exitCode !== 0 || signal !== null) {
      const returnedError = makeError({
        error,
        exitCode,
        signal,
        stdout,
        stderr,
        all,
        command,
        escapedCommand,
        parsed,
        timedOut,
        isCanceled: context.isCanceled || (parsed.options.signal ? parsed.options.signal.aborted : false),
        killed: spawned.killed
      });
      if (!parsed.options.reject) {
        return returnedError;
      }
      throw returnedError;
    }
    return {
      command,
      escapedCommand,
      exitCode: 0,
      stdout,
      stderr,
      all,
      failed: false,
      timedOut: false,
      isCanceled: false,
      killed: false
    };
  };
  const handlePromiseOnce = onetime_default(handlePromise);
  handleInput(spawned, parsed.options.input);
  spawned.all = makeAllStream(spawned, parsed.options);
  return mergePromise(spawned, handlePromiseOnce);
}
function execaSync(file, args, options) {
  const parsed = handleArguments(file, args, options);
  const command = joinCommand(file, args);
  const escapedCommand = getEscapedCommand(file, args);
  validateInputSync(parsed.options);
  let result;
  try {
    result = import_node_child_process.default.spawnSync(parsed.file, parsed.args, parsed.options);
  } catch (error) {
    throw makeError({
      error,
      stdout: "",
      stderr: "",
      all: "",
      command,
      escapedCommand,
      parsed,
      timedOut: false,
      isCanceled: false,
      killed: false
    });
  }
  const stdout = handleOutput(parsed.options, result.stdout, result.error);
  const stderr = handleOutput(parsed.options, result.stderr, result.error);
  if (result.error || result.status !== 0 || result.signal !== null) {
    const error = makeError({
      stdout,
      stderr,
      error: result.error,
      signal: result.signal,
      exitCode: result.status,
      command,
      escapedCommand,
      parsed,
      timedOut: result.error && result.error.code === "ETIMEDOUT",
      isCanceled: false,
      killed: result.signal !== null
    });
    if (!parsed.options.reject) {
      return error;
    }
    throw error;
  }
  return {
    command,
    escapedCommand,
    exitCode: 0,
    stdout,
    stderr,
    failed: false,
    timedOut: false,
    isCanceled: false,
    killed: false
  };
}
function execaCommand(command, options) {
  const [file, ...args] = parseCommand(command);
  return execa(file, args, options);
}
function execaCommandSync(command, options) {
  const [file, ...args] = parseCommand(command);
  return execaSync(file, args, options);
}
function execaNode(scriptPath, args, options = {}) {
  if (args && !Array.isArray(args) && typeof args === "object") {
    options = args;
    args = [];
  }
  const stdio = normalizeStdioNode(options);
  const defaultExecArgv = import_node_process2.default.execArgv.filter((arg) => !arg.startsWith("--inspect"));
  const {
    nodePath = import_node_process2.default.execPath,
    nodeOptions = defaultExecArgv
  } = options;
  return execa(
    nodePath,
    [
      ...nodeOptions,
      scriptPath,
      ...Array.isArray(args) ? args : []
    ],
    {
      ...options,
      stdin: void 0,
      stdout: void 0,
      stderr: void 0,
      stdio,
      shell: false
    }
  );
}
var import_node_buffer, import_node_path2, import_node_child_process, import_node_process2, import_cross_spawn, DEFAULT_MAX_BUFFER, getEnv, handleArguments, handleOutput;
var init_execa = __esm({
  "node_modules/execa/index.js"() {
    import_node_buffer = require("node:buffer");
    import_node_path2 = __toESM(require("node:path"), 1);
    import_node_child_process = __toESM(require("node:child_process"), 1);
    import_node_process2 = __toESM(require("node:process"), 1);
    import_cross_spawn = __toESM(require_cross_spawn(), 1);
    init_strip_final_newline();
    init_npm_run_path();
    init_onetime();
    init_error();
    init_stdio();
    init_kill();
    init_stream();
    init_promise();
    init_command();
    DEFAULT_MAX_BUFFER = 1e3 * 1e3 * 100;
    getEnv = ({ env: envOption, extendEnv, preferLocal, localDir, execPath }) => {
      const env = extendEnv ? { ...import_node_process2.default.env, ...envOption } : envOption;
      if (preferLocal) {
        return npmRunPathEnv({ env, cwd: localDir, execPath });
      }
      return env;
    };
    handleArguments = (file, args, options = {}) => {
      const parsed = import_cross_spawn.default._parse(file, args, options);
      file = parsed.command;
      args = parsed.args;
      options = parsed.options;
      options = {
        maxBuffer: DEFAULT_MAX_BUFFER,
        buffer: true,
        stripFinalNewline: true,
        extendEnv: true,
        preferLocal: false,
        localDir: options.cwd || import_node_process2.default.cwd(),
        execPath: import_node_process2.default.execPath,
        encoding: "utf8",
        reject: true,
        cleanup: true,
        all: false,
        windowsHide: true,
        ...options
      };
      options.env = getEnv(options);
      options.stdio = normalizeStdio(options);
      if (import_node_process2.default.platform === "win32" && import_node_path2.default.basename(file, ".exe") === "cmd") {
        args.unshift("/q");
      }
      return { file, args, options, parsed };
    };
    handleOutput = (options, value, error) => {
      if (typeof value !== "string" && !import_node_buffer.Buffer.isBuffer(value)) {
        return error === void 0 ? void 0 : "";
      }
      if (options.stripFinalNewline) {
        return stripFinalNewline(value);
      }
      return value;
    };
  }
});

// out/explorer.js
var require_explorer = __commonJS({
  "out/explorer.js"(exports2) {
    "use strict";
    var __awaiter = exports2 && exports2.__awaiter || function(thisArg, _arguments, P, generator) {
      function adopt(value) {
        return value instanceof P ? value : new P(function(resolve) {
          resolve(value);
        });
      }
      return new (P || (P = Promise))(function(resolve, reject) {
        function fulfilled(value) {
          try {
            step(generator.next(value));
          } catch (e) {
            reject(e);
          }
        }
        function rejected(value) {
          try {
            step(generator["throw"](value));
          } catch (e) {
            reject(e);
          }
        }
        function step(result) {
          result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
        }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
      });
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    var vscode_1 = require("vscode");
    var util_1 = require_util();
    var traverse_1 = require_traverse();
    var path3 = require("path");
    var fs = require("fs");
    var statusBar_1 = require_statusBar();
    var webviewCotnroller_1 = require_webviewCotnroller();
    var opn = require_opn();
    var axios_1 = require_axios2();
    var jwt = require_jsonwebtoken();
    var projectConfigDefault_1 = require_projectConfigDefault();
    var beautify = require_js();
    var execa_1 = (init_execa(), __toCommonJS(execa_exports));
    var ExplorerProvider = class {
      setContext(name, value) {
        vscode_1.commands.executeCommand("setContext", name, value);
      }
      getActiveEditorDir(activePath) {
        return activePath.replace(this.projectRootPathReg, "").replace(/[\/|\\]\w*\.\w*$/gi, "");
      }
      getActiveEditorPath(activePath) {
        return activePath.replace(this.projectRootPathReg, "");
      }
      getVueRelativePath(activeEditorPath, vuePath) {
        let vfPath = path3.relative(activeEditorPath, vuePath);
        vfPath = "./" + vfPath;
        return vfPath.replace(/\\/gi, "/");
      }
      constructor(context, userToken) {
        this.name = "vue-helper";
        this.projectRootPath = "";
        this.tabSize = "";
        this.isTs = false;
        this.hasAliasConfig = false;
        this.prefix = {
          alias: "@",
          path: "src"
        };
        this.vueFiles = [];
        this.config = {
          set: (key, value) => __awaiter(this, void 0, void 0, function* () {
            yield vscode_1.workspace.getConfiguration(this.name).update(key, value, vscode_1.ConfigurationTarget.Global);
          }),
          get: (key) => {
            return vscode_1.workspace.getConfiguration(this.name).get(key);
          }
        };
        this.project = "";
        this.projectConfig = projectConfigDefault_1.projectConfigDefault;
        this.projectConfigFile = "helper.json";
        this.modules = [];
        this.vipLevel = -1;
        this.userId = "";
        this.isExpire = true;
        this.canUse = false;
        this.token = "";
        this.opn = opn;
        this.url = "https://www.miaixyt.com";
        this.apiUrl = "https://int.miaixyt.com";
        this.docUrl = "http://vue-helper.80fight.cn";
        this.isZh = false;
        this.vueVersion = "3";
        this.frameworks = [];
        this.frameworkIntalled = [];
        this.frameworkInherit = [{ name: "element-ui", version: "2", trigger: "e" }, { name: "element-plus", version: "2", trigger: "e" }, { name: "ant-design-vue", version: "4", trigger: "a" }];
        this.formSupportFramework = ["element-plus", "element-ui", "ant-design-vue"];
        this.formFramework = "element-plus";
        this.importReg = new RegExp(`import([ 
	]*(?:[^ 
	{}]+[ 
	]*,?)?(?:[ 
	]*{(?:[ 
	]*[^ 
	"'{}]+[ 
	]*,?)+})?[ 
	]*)from[ 
	]*(['"])([^'"
]+)(?:['"])`);
        this.commonData = {
          plugin: [],
          component: []
        };
        this.localVues = {};
        this.localAttrs = {};
        this.context = context;
        this.token = userToken;
        this.projectRootPath = (0, util_1.getWorkspaceRoot)("");
        this.projectRootPathReg = new RegExp(`.*${this.projectRootPath}/`, "gi");
        this.traverse = new traverse_1.default(this, this.prefix);
        this.webviewController = new webviewCotnroller_1.WebviewController(this);
        this.tabSize = (0, util_1.getTabSize)();
        const tsconfigPath = (0, util_1.winRootPathHandle)(path3.join(this.projectRootPath, "tsconfig.json"));
        this.isTs = fs.existsSync(tsconfigPath);
        this.axios = axios_1.default;
        this.axios.defaults.baseURL = this.apiUrl;
        this.axios.defaults.withCredentials = false;
        this.isZh = vscode_1.env.language === "zh-cn";
        this.frameworkInit();
        this.configAlias();
        this.setProjectConfig();
        this.statusBar = new statusBar_1.default(this);
        if (this.isZh) {
          this.statusBar.show();
        } else {
          this.statusBar.showEn();
        }
        this.context.subscriptions.push(vscode_1.commands.registerCommand("vue-helper.login", (res) => {
          this.webviewController.openView({
            title: res && res.opt === "login" ? this.isZh ? "\u767B\u5F55" : "login" : this.isZh ? "\u6CE8\u518C" : "register",
            page: "register",
            framework: res && res.opt === "login" ? "login" : vscode_1.env.machineId,
            messageHandler: (message) => {
              switch (message.command) {
                case "close":
                  this.webviewController.close();
                  break;
                case "register":
                  this.context.secrets.store("vue-helper.token", message.data.token);
                  this.token = message.data.token;
                  if (this.isZh) {
                    this.statusBar.updateTooltip();
                  } else {
                    this.statusBar.updateTooltipEn();
                  }
                  this.updateProjectConfig();
                  this.refresh();
                  break;
                case "openWebsite":
                  this.opn(message.url);
                  break;
                case "active":
                  this.offlineActive(message.license);
                  break;
                default:
                  break;
              }
            }
          });
        }));
        this.context.subscriptions.push(vscode_1.commands.registerCommand("vue-helper.openPay", () => {
          this.webviewController.openView({
            title: "VIP",
            page: "pay",
            token: this.token,
            framework: vscode_1.env.machineId,
            messageHandler: (message) => {
              switch (message.command) {
                case "close":
                  this.webviewController.close();
                  break;
                case "member":
                  this.context.secrets.store("vue-helper.token", message.params.token);
                  this.token = message.params.token;
                  if (this.isZh) {
                    this.statusBar.updateTooltip();
                  } else {
                    this.statusBar.updateTooltipEn();
                  }
                  this.canUse = true;
                  this.updateProjectConfig();
                  this.refresh();
                  break;
                case "openWebsite":
                  this.opn(message.url);
                  break;
                case "active":
                  this.offlineActive(message.license);
                default:
                  break;
              }
            }
          });
        }));
        this.context.subscriptions.push(vscode_1.commands.registerCommand("vue-helper.openDocument", () => {
          opn(this.docUrl + (this.isZh ? "" : "/en") + "/document/");
        }));
        this.context.subscriptions.push(vscode_1.commands.registerCommand("vue-helper.token.clear", () => {
          this.context.secrets.delete("vue-helper.version");
          this.context.secrets.delete("vue-helper.token");
          this.token = "";
          this.updateUser();
          if (this.isZh) {
            this.statusBar.updateTooltip();
          } else {
            this.statusBar.updateTooltipEn();
          }
        }));
        this.context.subscriptions.push(vscode_1.commands.registerCommand("vue-helper.feedback", () => {
          opn(this.docUrl + (this.isZh ? "" : "/en") + "/feedback/");
        }));
        this.context.subscriptions.push(vscode_1.commands.registerCommand("vue-helper.generateConfig", () => {
          this.generateProjectConfig(true);
        }));
        this.context.subscriptions.push(vscode_1.commands.registerCommand("vue-helper.git.visit", () => __awaiter(this, void 0, void 0, function* () {
          const remoteCmd = yield (0, execa_1.execa)("git", ["remote", "-v"], { cwd: this.projectRootPath });
          if (remoteCmd.stdout) {
            const remoteMatchs = remoteCmd.stdout.match(/http.* /);
            if (remoteMatchs && (remoteMatchs === null || remoteMatchs === void 0 ? void 0 : remoteMatchs.length) > 0) {
              opn(remoteMatchs[0].trim());
            } else {
              const gitMatchs = remoteCmd.stdout.match(/git@.* /);
              if (gitMatchs && (gitMatchs === null || gitMatchs === void 0 ? void 0 : gitMatchs.length) > 0) {
                opn(gitMatchs[0].trim().replace(/:/gi, "/").replace(/git@/gi, "http://"));
              }
            }
          }
        })));
        this.context.subscriptions.push(vscode_1.commands.registerCommand("vue-helper.common.position", (res) => {
          this.openDocument(res.item.file, {
            selection: {
              x: res.item.item.start.x,
              x1: res.item.item.end.x,
              y: res.item.item.start.y,
              y1: res.item.item.end.y
            },
            range: {
              x: 0,
              x1: 0,
              y: res.item.item.start.y,
              y1: res.item.item.end.y
            }
          });
        }));
        this.context.subscriptions.push(vscode_1.commands.registerCommand("vue-helper.common.link", (res) => {
          if (res.item.item.position === "2") {
            this.opn("https://www.npmjs.com/package/" + res.item.item.path);
          } else {
            let basePath = "";
            if (res.item.item.path.includes(this.prefix.alias + "/")) {
              basePath = path3.join(this.projectRootPath, res.item.item.path.replace(this.prefix.alias, this.prefix.path));
            } else {
              basePath = path3.join(res.item.file, "../", res.item.item.path);
            }
            if (fs.existsSync(basePath + ".js")) {
              basePath = basePath + ".js";
            } else if (fs.existsSync(basePath + ".ts")) {
              basePath = basePath + ".ts";
            } else if (fs.existsSync(basePath + ".vue")) {
              basePath = basePath + ".vue";
            }
            this.openDocument(basePath, {
              selection: {
                x: 0,
                x1: 0,
                y: 0,
                y1: 0
              }
            });
          }
        }));
        this.context.subscriptions.push(vscode_1.commands.registerCommand("vue-helper.common.refresh", () => {
          this.getCommonComponents();
        }));
        this.context.subscriptions.push(vscode_1.commands.registerCommand("vue-helper.visitLocal", (res) => {
          this.openDocument(path3.join(this.projectRootPath, res.resourceUri), {
            selection: {
              x: 0,
              x1: 0,
              y: 0,
              y1: 0
            }
          });
        }));
        this.context.subscriptions.push(vscode_1.commands.registerCommand("vue-helper.localComp.update", () => {
          this.traverse.initLocalComponent();
          vscode_1.window.showInformationMessage(vscode_1.l10n.t("update success"));
        }));
        this.context.subscriptions.push(vscode_1.commands.registerCommand("vue-helper.localComp.doc", () => {
          this.webviewController.openView({
            title: "\u672C\u5730\u7EC4\u4EF6",
            page: "localDoc",
            messageHandler: (message) => {
              switch (message.command) {
                case "init":
                  let params = {};
                  for (const key in this.localVues) {
                    const localVue = this.localVues[key];
                    localVue.sort((a, b) => {
                      return a.name < b.name ? -1 : 1;
                    });
                    params[key] = localVue;
                  }
                  this.webviewController.postMessage({
                    command: "init",
                    params
                  });
                  break;
              }
            }
          });
        }));
        this.context.subscriptions.push(vscode_1.commands.registerCommand("vue-helper.upload.block", () => {
          this.openPrivateComponent(null, true);
        }));
        this.context.subscriptions.push(vscode_1.commands.registerCommand("vue-helper.upload.component", (uri) => {
          let dirPath = (0, util_1.winRootPathHandle)(uri.path);
          let params = {};
          try {
            let stat = fs.statSync(dirPath);
            if (stat.isDirectory()) {
              params.module = [{
                label: uri.path.replace(/.*\//gi, ""),
                children: this.traverse.traverseDir(dirPath)
              }];
              params.url = dirPath;
            } else {
              params.fileList = [{
                name: uri.path.replace(/.*\//gi, ""),
                url: dirPath
              }];
            }
          } catch (error) {
          }
          this.openPrivateComponent(params);
        }));
        this.context.subscriptions.push(vscode_1.commands.registerCommand("vue-helper.add.component", (uri) => {
          this.showPickComponent(uri);
        }));
        this.context.subscriptions.push(vscode_1.commands.registerCommand("vue-helper.add.file", (uri) => {
          this.webviewController.postMessage({
            command: "addFile",
            params: [{
              name: uri.path.replace(/.*\//gi, ""),
              url: uri.path
            }]
          });
        }));
        this.context.subscriptions.push(vscode_1.commands.registerCommand("vue-helper.private.setting", () => __awaiter(this, void 0, void 0, function* () {
          this.setComponentDir(true);
        })));
        this.context.subscriptions.push(vscode_1.commands.registerCommand("vue-helper.private.see", () => __awaiter(this, void 0, void 0, function* () {
          this.openPrivateComponent();
        })));
        vscode_1.workspace.onDidOpenTextDocument((e) => {
          if (e.uri.scheme === "file") {
            let docPath = e.uri.path.replace(/.*:\//gi, "/");
            if (!this.projectRootPath || !docPath.includes(this.projectRootPath.replace(/.*:\//gi, "/"))) {
              this.projectRootPath = (0, util_1.getWorkspaceRoot)(e.uri.path);
              this.frameworkInit();
              this.refresh();
            }
          }
        });
      }
      offlineActive(license) {
        if (vscode_1.env.machineId.substring(0, 6) === license.substring(license.length - 6, license.length)) {
          let token = license.substring(0, license.length - 6);
          this.context.secrets.store("vue-helper.token", token);
          this.token = token;
          if (this.isZh) {
            this.statusBar.updateTooltip();
          } else {
            this.statusBar.updateTooltipEn();
          }
          this.updateProjectConfig();
          this.refresh();
          this.webviewController.postMessage({
            command: "notice",
            type: "success",
            message: "\u6FC0\u6D3B\u6210\u529F"
          });
        } else {
          this.webviewController.postMessage({
            command: "notice",
            type: "error",
            message: "\u6FC0\u6D3B\u5931\u8D25"
          });
        }
      }
      configAlias() {
        let alias = {};
        try {
          if (this.isTs) {
            let tsConfigPath = path3.join(this.projectRootPath, "tsconfig.tson");
            if (fs.existsSync(tsConfigPath)) {
              let tsConfig = fs.readFileSync(tsConfigPath, "utf-8");
              tsConfig = JSON.parse(tsConfig);
              if (tsConfig.compilerOptions && tsConfig.compilerOptions.paths) {
                for (const key in tsConfig.compilerOptions.paths) {
                  this.hasAliasConfig = true;
                  let aliasPath = tsConfig.compilerOptions.paths[key];
                  if (Array.isArray(aliasPath)) {
                    aliasPath = aliasPath[0];
                  }
                  alias[key.replace(/\/\*/gi, "")] = aliasPath.replace(/\/\*/gi, "");
                }
              }
            }
          } else {
            let jsConfigPath = path3.join(this.projectRootPath, "jsconfig.json");
            if (fs.existsSync(jsConfigPath)) {
              let jsConfig = fs.readFileSync(jsConfigPath, "utf-8");
              jsConfig = JSON.parse(jsConfig);
              if (jsConfig.compilerOptions && jsConfig.compilerOptions.paths) {
                for (const key in jsConfig.compilerOptions.paths) {
                  this.hasAliasConfig = true;
                  let aliasPath = jsConfig.compilerOptions.paths[key];
                  if (Array.isArray(aliasPath)) {
                    aliasPath = aliasPath[0];
                  }
                  alias[key.replace(/\/\*/gi, "")] = aliasPath.replace(/\/\*/gi, "");
                }
              }
            }
          }
        } catch (error) {
        }
      }
      setProjectConfig() {
        const paths = this.projectRootPath.split("/");
        let project = "";
        if (paths.length > 0) {
          project = paths[paths.length - 1];
        }
        this.project = project.toLowerCase();
        let projectConfigFilePath = path3.join(this.projectRootPath, this.projectConfigFile);
        if (fs.existsSync(projectConfigFilePath)) {
          let localProjectConfig = fs.readFileSync(projectConfigFilePath, "utf-8");
          localProjectConfig = JSON.parse(localProjectConfig);
          this.projectConfig = localProjectConfig;
          this.setPrefix();
        }
      }
      setPrefix() {
        this.prefix.alias = this.projectConfig.path.root.split("=")[0];
        this.prefix.path = this.projectConfig.path.root.split("=")[1];
      }
      refresh() {
        this.generateProjectConfig(false);
        this.getCommonComponents();
        this.modules.forEach((module3) => {
          module3.refresh && module3.refresh();
        });
      }
      projectConfigUpdateNotice() {
        this.modules.forEach((module3) => {
          module3.projectConfigUpdate && module3.projectConfigUpdate();
        });
      }
      addModule(obj) {
        this.modules.push(obj);
      }
      getCommonComponents() {
        this.commonData = this.traverse.component(this.vueVersion);
        if (!this.commonView) {
          const commonTreeDataProvider = new CommonTreeDataProvider(this);
          this.commonView = vscode_1.window.createTreeView("vue-helper.common", {
            treeDataProvider: commonTreeDataProvider,
            showCollapseAll: false
          });
          this.context.subscriptions.push(this.commonView);
        }
      }
      _toUri(webview, extensionPath, basePath, fileName) {
        return webview.asWebviewUri(vscode_1.Uri.file(path3.join(extensionPath, basePath, fileName)));
      }
      getNonce() {
        let text = "";
        const possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        for (let i = 0; i < 32; i++) {
          text += possible.charAt(Math.floor(Math.random() * possible.length));
        }
        return text;
      }
      getHtmlForWebview(webview, extensionPath, path4, title, token, framework) {
        const nonce = this.getNonce();
        const cssUri = this._toUri(webview, extensionPath, "media", "assets/index.css");
        const app = this._toUri(webview, extensionPath, "media", "assets/index.js");
        const baseUrl = this._toUri(webview, extensionPath, "media", "assets");
        return `<!DOCTYPE html>
    <html lang=en>
    
    <head>
      <meta charset="UTF-8">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <title>${title}</title>
      <link nonce="${nonce}" href="${cssUri}" rel=stylesheet>
      <script nonce="${nonce}">
        window.rootPath = '${path4}'
        window.lang = '${vscode_1.env.language}'
        window.token = '${token}'
        window.framework = '${framework}'
        window.baseUrl = '${baseUrl}'
        window.vscode = acquireVsCodeApi()
      <\/script>
    </head>
    
    <body><noscript><strong>We're sorry but ${title} doesn't work properly without JavaScript enabled. Please enable it to
          continue.</strong></noscript>
      <div id=app></div>
      <script type="module" crossorigin nonce="${nonce}" src="${app}"><\/script>
    </body>
    
    </html>`;
      }
      parseToken(token) {
        this.token = token;
        let ret = {
          auth_value: ""
        };
        jwt.verify(token, "vue-helper-20240512-project", (_err, decoded) => {
          ret = decoded;
        });
        return ret;
      }
      openConfigByReg(regStr) {
        return __awaiter(this, void 0, void 0, function* () {
          let reg = new RegExp(regStr, "gi");
          let projectConfigFile = path3.join(this.projectRootPath, this.projectConfigFile);
          const config = fs.readFileSync(projectConfigFile, "utf-8");
          let configLines = config.split("\n");
          let x = 0, y = 0;
          for (let i = 0; i < configLines.length; i++) {
            const line = configLines[i];
            if (reg.test(line)) {
              x = i;
              y = line.length - 2;
              break;
            }
          }
          let uri = vscode_1.Uri.file(projectConfigFile);
          const document2 = yield vscode_1.workspace.openTextDocument(uri);
          yield vscode_1.window.showTextDocument(document2, { preserveFocus: true, selection: new vscode_1.Selection(new vscode_1.Position(x, y), new vscode_1.Position(x, y)) });
          if (vscode_1.window.activeTextEditor) {
            vscode_1.window.activeTextEditor.revealRange(new vscode_1.Range(new vscode_1.Position(x, y), new vscode_1.Position(x, y)), vscode_1.TextEditorRevealType.Default);
          }
        });
      }
      getSwaggerKey(url) {
        return url.replace(/.*\/\//gi, "").replace(/\..*/gi, "").replace(/-/gi, "_");
      }
      generateProjectConfig(handle) {
        let projectConfigFile = path3.join(this.projectRootPath, this.projectConfigFile);
        let gitignorePath = path3.join(this.projectRootPath, ".gitignore");
        const configAutoGenerate = this.config.get("config-auto-generate");
        if (configAutoGenerate && !fs.existsSync(projectConfigFile) || handle) {
          if ((fs.existsSync(path3.join(this.projectRootPath, "package.json")) || fs.existsSync(path3.join(this.projectRootPath, "pages.json"))) && this.canUse) {
            fs.writeFileSync(projectConfigFile, beautify.js(JSON.stringify(projectConfigDefault_1.projectConfigDefault), { index_size: 2 }));
            if (fs.existsSync(gitignorePath)) {
              const gitignore = fs.readFileSync(gitignorePath);
              if (!gitignore.includes(this.projectConfigFile)) {
                fs.appendFileSync(gitignorePath, "\n" + this.projectConfigFile);
              }
            }
          }
        }
        if (vscode_1.workspace.workspaceFolders) {
          const watcher = vscode_1.workspace.createFileSystemWatcher("**/" + this.projectConfigFile);
          watcher.onDidChange(() => {
            this.updateProjectConfig();
          });
          watcher.onDidCreate(() => {
            this.updateProjectConfig();
          });
          watcher.onDidDelete(() => {
            this.updateProjectConfig();
          });
        }
        this.setProjectConfig();
      }
      updateProjectConfig() {
        try {
          let projectConfig = fs.readFileSync(path3.join(this.projectRootPath, this.projectConfigFile), "utf-8");
          if (projectConfig) {
            this.projectConfig = JSON.parse(projectConfig);
            this.projectConfigUpdateNotice();
            this.setPrefix();
          }
        } catch (error) {
        }
      }
      updateUser() {
        this.statusBar.updateUser();
        this.setContext("vue-helper.pro", this.canUse);
      }
      getImportInsert(text, line, modules) {
        let textModule = text.replace(/}.*/gi, "");
        const textModuleList = textModule.split("\n");
        let insertLineText = textModuleList[textModuleList.length - 1];
        let insertLineTextTrim = insertLineText.trim();
        textModule = textModule.replace(/.*{/gi, "");
        let textModules = textModule.split(",");
        let moduleList = [];
        textModules.forEach((module3) => {
          moduleList.push(module3.replace("\n", "").trim());
        });
        let insertModules = [];
        modules.forEach((module3) => {
          if (!moduleList.includes(module3)) {
            insertModules.push(module3);
          }
        });
        return {
          line: line + textModuleList.length - 1,
          character: insertLineText.indexOf(insertLineTextTrim) + insertLineTextTrim.length,
          template: insertModules.join(", ")
        };
      }
      getLineCharacter(text, lineStart) {
        let textTrim = text.trim();
        if (lineStart) {
          return text.indexOf(textTrim);
        } else {
          return text.indexOf(textTrim) + textTrim.length;
        }
      }
      isMethodExist(word, text) {
        return new RegExp(`^\\s*(function)?\\s*${word}\\s*\\(.*\\)\\s*{\\s*$`, "gi").test(text);
      }
      jumpToLocation(editor, position) {
        editor.selection = new vscode_1.Selection(position, position);
        let halfRange = 16;
        let lineStart = position.line - halfRange;
        let lineEnd = position.line + halfRange;
        if (lineStart < 0) {
          lineStart = 0;
        }
        if (lineEnd > editor.document.lineCount) {
          lineEnd = editor.document.lineCount;
        }
        editor.revealRange(new vscode_1.Range(new vscode_1.Position(lineStart, position.character), new vscode_1.Position(lineEnd, position.character)), vscode_1.TextEditorRevealType.Default);
      }
      parseImport(text, obj, lineText, line) {
        const matchs = text.match(this.importReg);
        if (matchs && matchs.length > 3) {
          let importPath = matchs[3];
          let character = lineText.indexOf(importPath);
          if (character === -1) {
            character = 0;
          }
          let importInfo = {
            path: importPath,
            type: "module",
            position: "2",
            start: {
              x: character,
              y: line
            },
            end: {
              x: character + importPath.length,
              y: line
            }
          };
          const localReg = new RegExp(`^(\\.|\\.\\.|${this.prefix.alias})/`, "gi");
          if (localReg.test(importInfo.path)) {
            importInfo.position = "1";
          }
          if (matchs[1].includes("{")) {
            importInfo.type = "var";
            let elList = matchs[1].replace(/.*{/gi, "").replace(/}.*/gi, "").split(",");
            elList.forEach((el) => {
              obj[el.trim()] = importInfo;
            });
          } else {
            obj[matchs[1].trim()] = importInfo;
          }
        }
      }
      getVarProperties(text) {
        let properties = text.replace(/.*({|\[)/gi, "").replace(/(}|]).*/gi, "").split(",");
        let ret = [];
        if (properties.length > 0) {
          properties.forEach((prop) => {
            ret.push(prop.trim());
          });
        }
        return ret;
      }
      openDocument(docPath, documentInfo) {
        return __awaiter(this, void 0, void 0, function* () {
          let uri = vscode_1.Uri.file(docPath);
          const document2 = yield vscode_1.workspace.openTextDocument(uri);
          yield vscode_1.window.showTextDocument(document2, { preserveFocus: true, selection: new vscode_1.Selection(new vscode_1.Position(documentInfo.selection.y, documentInfo.selection.x), new vscode_1.Position(documentInfo.selection.y1, documentInfo.selection.x1)) });
          if (documentInfo.range) {
            setTimeout(() => {
              var _a;
              if (vscode_1.window.activeTextEditor && documentInfo.range) {
                vscode_1.window.activeTextEditor.revealRange(new vscode_1.Range(new vscode_1.Position(documentInfo.range.y, (_a = documentInfo.range) === null || _a === void 0 ? void 0 : _a.x), new vscode_1.Position(documentInfo.range.y1, documentInfo.range.x1)), vscode_1.TextEditorRevealType.Default);
              }
            }, 300);
          }
        });
      }
      getVarConstantValue(text) {
        return text.replace(/.*:\s*('|")/gi, "").replace(/('|").*/gi, "");
      }
      getVarValue(text) {
        let ret = text.replace(/.*:\s*/gi, "").replace(/,/gi, "").replace(/as\s.*/gi, "");
        if (ret.includes("(")) {
          return "Function";
        } else if (ret.includes("[")) {
          return "Array";
        } else if (ret.includes("{")) {
          return "Object";
        } else {
          return ret.trim();
        }
      }
      getArrValue(text) {
        text = text.replace(/.*\[/gi, "").replace(/].*/gi, "");
        const textArr = text.split(",");
        const ret = [];
        textArr.forEach((txt) => {
          if (txt.trim()) {
            ret.push(txt.replace(/.*('|")(.*)('|")/gi, "$2").trim());
          }
        });
        return ret;
      }
      getVarName(text) {
        if (/^\s*\/\//gi.test(text)) {
          return "";
        }
        return text.replace(/:.*/gi, "").replace(/\?/gi, "").trim();
      }
      setComponentDir(showMsg) {
        return __awaiter(this, void 0, void 0, function* () {
          const componentDir = this.config.get("component-dir");
          let dir = yield vscode_1.window.showInputBox({
            placeHolder: "\u8BBE\u7F6E\u7EC4\u4EF6/\u914D\u7F6E\u653E\u7F6E\u76EE\u5F55, \u5982\uFF1AD:\\helper",
            value: componentDir
          });
          if (dir) {
            if (fs.existsSync(dir)) {
              this.config.set("component-dir", dir);
              try {
                if (!fs.existsSync(path3.join(dir, "framework"))) {
                  fs.mkdirSync(path3.join(dir, "framework"));
                }
                if (!fs.existsSync(path3.join(dir, "component"))) {
                  fs.mkdirSync(path3.join(dir, "component"));
                }
                if (!fs.existsSync(path3.join(dir, "codeBlock"))) {
                  fs.mkdirSync(path3.join(dir, "codeBlock"));
                }
                if (!fs.existsSync(path3.join(dir, "page"))) {
                  fs.mkdirSync(path3.join(dir, "page"));
                }
                if (!fs.existsSync(path3.join(dir, "codeBlock.json"))) {
                  fs.writeFileSync(path3.join(dir, "codeBlock.json"), "{}");
                }
                if (!fs.existsSync(path3.join(dir, "component.json"))) {
                  fs.writeFileSync(path3.join(dir, "component.json"), "{}");
                }
                if (!fs.existsSync(path3.join(dir, "framework.json"))) {
                  fs.writeFileSync(path3.join(dir, "framework.json"), "{}");
                }
                if (!fs.existsSync(path3.join(dir, "languages.json"))) {
                  fs.writeFileSync(path3.join(dir, "languages.json"), '{"vue3":["element-plus","ant-design-vue"],"vue2":["element-ui"],"common":[]}');
                }
              } catch (error) {
                console.log(error);
              }
              if (showMsg) {
                vscode_1.window.showInformationMessage("\u8BBE\u7F6E\u7EC4\u4EF6\u76EE\u5F55\u6210\u529F");
              }
            } else {
              if (showMsg) {
                vscode_1.window.showWarningMessage("\u8BBE\u7F6E\u76EE\u5F55\u4E0D\u5B58\u5728, \u8BF7\u91CD\u65B0 [\u8BBE\u7F6E](command:vue-helper.private.setting)");
              }
            }
          }
          return dir;
        });
      }
      getTime() {
        return Math.floor(new Date().getTime() / 1e3);
      }
      openPrivateComponent(params, isAdd) {
        this.setContext("vue-helper.self", true);
        this.webviewController.openView({
          title: "\u79C1\u6709\u7EC4\u4EF6\u5E93",
          page: "module",
          split: true,
          dispose: () => {
            this.setContext("vue-helper.self", false);
          },
          messageHandler: (message) => {
            switch (message.command) {
              case "init":
                break;
              case "config":
                if (params) {
                  this.uploadComponentConfig(params);
                } else {
                  this.uploadBlockConfig(isAdd || false);
                }
                break;
              case "addBlock":
                this.addBlock(message.data);
                break;
              case "remove":
                if (message.params.type === "1") {
                  this.removeBlock(message.params.id);
                } else {
                  this.removeComponent(message.params.id);
                }
                break;
              case "addModule":
                this.addComponent(message.data);
                break;
              case "switch":
                let componentDir = this.config.get("component-dir");
                let componentJson = "";
                if (message.params === "1") {
                  componentJson = fs.readFileSync(path3.join(componentDir, "codeBlock.json"), "utf-8");
                } else {
                  componentJson = fs.readFileSync(path3.join(componentDir, "component.json"), "utf-8");
                }
                this.webviewController.postMessage({
                  command: "config",
                  data: JSON.parse(componentJson)
                });
                break;
              case "openWebsite":
                this.opn(message.url);
                break;
              case "downloadFramework":
                this.downloadFramework(message.data);
                break;
            }
          }
        });
      }
      traverseTreeGenerate(tree, sourcePath, destPath) {
        try {
          tree.forEach((item) => {
            const destDirPath = (0, util_1.winRootPathHandle)(path3.join(destPath, item.label));
            if (item.children) {
              fs.mkdirSync(destDirPath);
              this.traverseTreeGenerate(item.children, path3.join(sourcePath, item.label), path3.join(destPath, item.label));
            } else {
              fs.writeFileSync(destDirPath, fs.readFileSync((0, util_1.winRootPathHandle)(path3.join(sourcePath, item.label))));
            }
          });
        } catch (error) {
        }
      }
      addComponent(comp) {
        const componentDir = this.config.get("component-dir");
        let componentName = "";
        let componentJson = fs.readFileSync(path3.join(componentDir, "component.json"), "utf-8");
        let languagesJson = fs.readFileSync(path3.join(componentDir, "languages.json"), "utf-8");
        componentJson = JSON.parse(componentJson);
        languagesJson = JSON.parse(languagesJson);
        try {
          const componentRootDir = path3.join(componentDir, "component");
          let editId = "";
          if (comp.id) {
            editId = comp.id;
          }
          comp.id = this.getTime() + "";
          componentName = comp.id + comp.name;
          let componentBaseDir = path3.join(componentRootDir, componentName);
          if (!fs.existsSync(componentBaseDir)) {
            fs.mkdirSync(componentBaseDir);
          }
          componentJson[comp.id] = {
            id: comp.id,
            name: comp.name,
            language: comp.language,
            framework: comp.framework,
            remark: comp.remark
          };
          let fileList = [];
          if (comp.fileList.length > 0) {
            comp.fileList.forEach((fileItem) => {
              let componentFilePath = path3.join(componentBaseDir, fileItem.name);
              fs.writeFileSync(componentFilePath, fs.readFileSync((0, util_1.winRootPathHandle)(fileItem.url)));
              fileList.push({
                name: fileItem.name,
                url: componentFilePath
              });
            });
          }
          componentJson[comp.id].fileList = fileList;
          if (comp.tree) {
            this.traverseTreeGenerate(comp.tree, path3.join(comp.url, ".."), componentBaseDir);
            componentJson[comp.id].tree = comp.tree;
          }
          let blockExist = null;
          if (componentJson[editId]) {
            blockExist = componentJson[editId];
            delete componentJson[editId];
          }
          fs.writeFileSync(path3.join(componentDir, "component.json"), JSON.stringify(componentJson), "utf-8");
          if (!editId) {
            this.webviewController.postMessage({
              command: "add",
              data: componentJson
            });
          }
          if (editId && blockExist) {
            let componentBaseDirModify = path3.join(componentRootDir, editId + blockExist.name);
            if (fs.existsSync(componentBaseDirModify)) {
              this.removeDir(componentBaseDirModify);
            }
            this.webviewController.postMessage({
              command: "edit",
              data: componentJson
            });
          }
        } catch (error) {
          console.log(error);
        }
      }
      uploadComponentConfig(params) {
        return __awaiter(this, void 0, void 0, function* () {
          let componentDir = this.config.get("component-dir");
          if (!componentDir) {
            componentDir = yield this.setComponentDir();
          }
          let componentJson = fs.readFileSync(path3.join(componentDir, "component.json"), "utf-8");
          let languagesJson = fs.readFileSync(path3.join(componentDir, "languages.json"), "utf-8");
          this.webviewController.postMessage(Object.assign({ command: "config", data: JSON.parse(componentJson), languages: JSON.parse(languagesJson), language: this.vueVersion == "3" ? "vue3" : "vue2", framework: this.formFramework }, params));
        });
      }
      uploadBlockConfig(isAdd) {
        return __awaiter(this, void 0, void 0, function* () {
          let componentDir = this.config.get("component-dir");
          if (!componentDir) {
            componentDir = yield this.setComponentDir();
          }
          let componentJson = fs.readFileSync(path3.join(componentDir, "codeBlock.json"), "utf-8");
          let languagesJson = fs.readFileSync(path3.join(componentDir, "languages.json"), "utf-8");
          this.webviewController.postMessage({
            command: "config",
            data: JSON.parse(componentJson),
            languages: JSON.parse(languagesJson),
            language: this.vueVersion == "3" ? "vue3" : "vue2",
            framework: this.formFramework,
            add: isAdd
          });
        });
      }
      emptyDir(dir) {
        const files = fs.readdirSync(dir);
        files.forEach((file) => {
          const filePath = path3.join(dir, file);
          const stats = fs.statSync(filePath);
          if (stats.isDirectory()) {
            this.emptyDir(filePath);
          } else {
            fs.unlinkSync(filePath);
          }
        });
      }
      showPickComponent(uri) {
        const pickItems = [];
        let componentDir = this.config.get("component-dir");
        let componentJson = fs.readFileSync(path3.join(componentDir, "component.json"), "utf-8");
        componentJson = JSON.parse(componentJson);
        let vueLanguages = ["common"];
        this.vueVersion === "3" ? vueLanguages.push("vue3") : vueLanguages.push("vue2");
        let frameworkList = this.frameworks.map((framework) => {
          return framework.name;
        });
        for (const key in componentJson) {
          const item = componentJson[key];
          if (vueLanguages.includes(item.language)) {
            if (!item.framework || frameworkList.includes(item.framework)) {
              pickItems.push({
                label: item.name,
                description: item.remark,
                id: key
              });
            }
          }
        }
        const pagePick = vscode_1.window.createQuickPick();
        pagePick.title = "\u6DFB\u52A0\u7EC4\u4EF6";
        pagePick.placeholder = "\u9009\u62E9\u7EC4\u4EF6";
        pagePick.items = pickItems;
        pagePick.onDidChangeSelection((selection) => {
          pagePick.hide();
          if (vscode_1.workspace.workspaceFolders && selection[0] && selection[0].label) {
            this.insertComponent(componentJson[selection[0].id], componentDir, uri.path);
          } else {
            if (!vscode_1.workspace.workspaceFolders) {
              vscode_1.window.showInformationMessage("\u8BF7\u5148\u6253\u5F00\u5DE5\u7A0B");
            }
          }
        });
        pagePick.onDidHide(() => pagePick.dispose());
        pagePick.show();
      }
      insertComponent(component, source, dest) {
        if (component.tree) {
          this.traverseTreeGenerate(component.tree, path3.join(source, "component/" + component.id + component.name), dest);
        }
        if (component.fileList) {
          component.fileList.forEach((fileItem) => {
            let componentFilePath = path3.join(dest, fileItem.name);
            fs.writeFileSync((0, util_1.winRootPathHandle)(componentFilePath), fs.readFileSync((0, util_1.winRootPathHandle)(fileItem.url)));
          });
        }
      }
      rmEmptyDir(dir, level = 0) {
        const files = fs.readdirSync(dir);
        if (files.length > 0) {
          let tempFile = 0;
          files.forEach((file) => {
            tempFile++;
            this.rmEmptyDir(path3.join(dir, file), 1);
          });
          if (tempFile === files.length && level !== 0) {
            fs.rmdirSync(dir);
          }
        } else {
          level !== 0 && fs.rmdirSync(dir);
        }
      }
      removeDir(dir) {
        this.emptyDir(dir);
        this.rmEmptyDir(dir);
        fs.rmdirSync(dir);
      }
      addBlock(block) {
        return __awaiter(this, void 0, void 0, function* () {
          const componentDir = this.config.get("component-dir");
          let componentName = "";
          let componentJson = fs.readFileSync(path3.join(componentDir, "codeBlock.json"), "utf-8");
          let languagesJson = fs.readFileSync(path3.join(componentDir, "languages.json"), "utf-8");
          componentJson = JSON.parse(componentJson);
          languagesJson = JSON.parse(languagesJson);
          try {
            const componentRootDir = path3.join(componentDir, "codeBlock");
            let editId = "";
            if (block.id) {
              editId = block.id;
            }
            block.id = this.getTime() + "";
            componentName = block.id + block.name;
            let componentBaseDir = path3.join(componentRootDir, componentName);
            if (!fs.existsSync(componentBaseDir)) {
              fs.mkdirSync(componentBaseDir);
            }
            componentJson[block.id] = {
              id: block.id,
              name: block.name,
              language: block.language,
              framework: block.framework,
              remark: block.remark,
              script: block.script,
              style: block.style,
              template: block.template
            };
            let fileList = [];
            if (block.fileList.length > 0) {
              block.fileList.forEach((fileItem) => {
                let componentFilePath = path3.join(componentBaseDir, fileItem.name);
                fs.writeFileSync(componentFilePath, fs.readFileSync((0, util_1.winRootPathHandle)(fileItem.url)));
                fileList.push({
                  name: fileItem.name,
                  url: componentFilePath
                });
              });
            }
            componentJson[block.id].fileList = fileList;
            let blockExist = null;
            if (componentJson[editId]) {
              blockExist = componentJson[editId];
              delete componentJson[editId];
            }
            fs.writeFileSync(path3.join(componentDir, "codeBlock.json"), JSON.stringify(componentJson), "utf-8");
            if (!editId) {
              this.webviewController.postMessage({
                command: "add",
                data: componentJson
              });
              this.modules.forEach((module3) => {
                if (module3.name === "FrameworkCompletionItemProvider") {
                  module3.refreshPrivateComponent(componentJson);
                }
              });
            }
            if (editId && blockExist) {
              let componentBaseDirModify = path3.join(componentRootDir, editId + blockExist.name);
              if (fs.existsSync(componentBaseDirModify)) {
                this.removeDir(componentBaseDirModify);
              }
              this.webviewController.postMessage({
                command: "edit",
                data: componentJson
              });
              this.modules.forEach((module3) => {
                if (module3.name === "FrameworkCompletionItemProvider") {
                  module3.refreshPrivateComponent(componentJson);
                }
              });
            }
          } catch (error) {
            console.log(error);
          }
        });
      }
      removeBlock(id) {
        const componentDir = this.config.get("component-dir");
        let componentJson = fs.readFileSync(path3.join(componentDir, "codeBlock.json"), "utf-8");
        componentJson = JSON.parse(componentJson);
        try {
          let blockExist = null;
          if (componentJson[id]) {
            blockExist = componentJson[id];
            delete componentJson[id];
          }
          fs.writeFileSync(path3.join(componentDir, "codeBlock.json"), JSON.stringify(componentJson), "utf-8");
          if (blockExist) {
            const componentRootDir = path3.join(componentDir, "codeBlock");
            let componentBaseDirModify = path3.join(componentRootDir, id + blockExist.name);
            if (fs.existsSync(componentBaseDirModify)) {
              this.removeDir(componentBaseDirModify);
            }
          }
          this.webviewController.postMessage({
            command: "remove",
            data: componentJson
          });
          this.modules.forEach((module3) => {
            if (module3.name === "FrameworkCompletionItemProvider") {
              module3.refreshPrivateComponent(componentJson);
            }
          });
        } catch (error) {
          console.log(error);
        }
      }
      removeComponent(id) {
        const componentDir = this.config.get("component-dir");
        let componentJson = fs.readFileSync(path3.join(componentDir, "component.json"), "utf-8");
        componentJson = JSON.parse(componentJson);
        try {
          let blockExist = null;
          if (componentJson[id]) {
            blockExist = componentJson[id];
            delete componentJson[id];
          }
          fs.writeFileSync(path3.join(componentDir, "component.json"), JSON.stringify(componentJson), "utf-8");
          if (blockExist) {
            const componentRootDir = path3.join(componentDir, "component");
            let componentBaseDirModify = path3.join(componentRootDir, id + blockExist.name);
            if (fs.existsSync(componentBaseDirModify)) {
              this.removeDir(componentBaseDirModify);
            }
          }
          this.webviewController.postMessage({
            command: "remove",
            data: componentJson
          });
        } catch (error) {
        }
      }
      frameworkInit() {
        try {
          let configFramework = this.config.get("framework");
          if (configFramework) {
            let configFrameworkList = configFramework.split(",");
            for (let i = 0; i < configFrameworkList.length; i++) {
              const item = configFrameworkList[i];
              this.frameworks.push({
                name: item,
                trigger: item[0],
                version: "100"
              });
            }
          } else {
            this.frameworks = [];
          }
          const frameworkNpms = ["element-plus", "ant-design-vue", "element-ui"];
          const componentDir = this.config.get("component-dir");
          if (componentDir) {
            const frameworkPath = path3.join(componentDir, "framework.json");
            if (fs.existsSync(frameworkPath)) {
              let frameworkIntalledJson = fs.readFileSync(frameworkPath, "utf-8");
              if (frameworkIntalledJson) {
                frameworkIntalledJson = JSON.parse(frameworkIntalledJson);
                for (const key in frameworkIntalledJson) {
                  const framework = Object.assign(Object.assign({}, frameworkIntalledJson[key]), { key });
                  this.frameworkIntalled.push(framework);
                  if (!frameworkNpms.includes(framework.name)) {
                    frameworkNpms.push(framework.name);
                  }
                }
              }
            }
          }
          if (this.projectRootPath) {
            const frameworkNames = [];
            if (this.frameworks.length > 0) {
              this.frameworks.forEach((frameworkItem) => {
                frameworkNames.push(frameworkItem.name);
              });
            }
            const pkg = fs.readFileSync((0, util_1.winRootPathHandle)(path3.join(this.projectRootPath, "package.json")), "utf-8");
            const combineFramework = this.frameworkInherit.concat(this.frameworkIntalled);
            combineFramework.forEach((installFramework) => {
              if (pkg.includes(`"${installFramework.name}"`)) {
                let frameworkVersion = "";
                let npmReg = new RegExp(`"${installFramework.name}"\\s*:\\s*"([^"]*)`, "gi");
                const frameworkNpm = pkg.match(npmReg);
                if (frameworkNpm && frameworkNpm.length > 0) {
                  frameworkVersion = frameworkNpm[0].replace(/.*"/gi, "");
                  if (frameworkVersion) {
                    if (["~", "^"].includes(frameworkVersion[0])) {
                      frameworkVersion = frameworkVersion[0];
                    } else {
                      frameworkVersion = frameworkVersion[0];
                    }
                    if (isNaN(parseInt(frameworkVersion))) {
                      frameworkVersion = "100";
                    }
                  }
                }
                if (!frameworkNames.includes(installFramework.name)) {
                  this.frameworks.push({
                    name: installFramework.name,
                    version: frameworkVersion,
                    trigger: installFramework.trigger
                  });
                  frameworkNames.push(installFramework.name);
                }
                if (this.formSupportFramework.includes(installFramework.name)) {
                  this.formFramework = installFramework.name;
                }
              }
            });
            if (/"vue":\s*"2/gi.test(pkg)) {
              this.vueVersion = "2";
            }
          }
        } catch (error) {
          console.log(error);
        }
      }
      downloadFramework(data) {
        return __awaiter(this, void 0, void 0, function* () {
          if (this.vipLevel > 0) {
            const componentDir = this.config.get("component-dir");
            try {
              this.axios.get(data.url, {
                responseType: "json"
              }).then((res) => {
                fs.writeFileSync(path3.join(componentDir, "framework/" + data.name + data.version + ".json"), beautify.js(JSON.stringify(res.data), { index_size: 2 }));
                let frameworkPath = path3.join(componentDir, "framework.json");
                let framework = fs.readFileSync(frameworkPath, "utf-8");
                if (framework) {
                  framework = JSON.parse(framework);
                  framework[data.name + data.version] = {
                    name: data.name,
                    trigger: data.trigger,
                    version: data.version
                  };
                  fs.writeFileSync(frameworkPath, beautify.js(JSON.stringify(framework), { index_size: 2 }), "utf-8");
                }
                this.webviewController.postMessage({
                  command: "download"
                });
              });
            } catch (error) {
              console.log(error);
            }
          } else {
            this.webviewController.postMessage({
              command: "noPermit"
            });
          }
        });
      }
    };
    exports2.default = ExplorerProvider;
    var CommonTreeDataProvider = class {
      constructor(explorer) {
        this.explorer = explorer;
      }
      getTreeItem(element) {
        return element;
      }
      getChildren(element) {
        let children = [];
        if (element) {
          if (element.id) {
            let common = this.explorer.commonData[element.id];
            if (common) {
              common.forEach((item) => {
                children.push({
                  label: item.from || item.name,
                  contextValue: "vue-helper.common",
                  iconPath: item.item.position === "1" ? new vscode_1.ThemeIcon("sign-in") : new vscode_1.ThemeIcon("sign-out"),
                  collapsibleState: vscode_1.TreeItemCollapsibleState.None,
                  item
                });
              });
            }
          }
          return children;
        } else {
          children = [{
            id: "plugin",
            label: `${vscode_1.l10n.t("Plugin")} [${this.explorer.commonData.plugin.length}]`,
            tooltip: "use",
            collapsibleState: vscode_1.TreeItemCollapsibleState.Collapsed
          }, {
            id: "component",
            label: `${vscode_1.l10n.t("Component")} [${this.explorer.commonData.component.length}]`,
            tooltip: "component",
            collapsibleState: vscode_1.TreeItemCollapsibleState.Collapsed
          }];
        }
        return children;
      }
      getParent(_element) {
        return null;
      }
    };
  }
});

// out/vue/snippets-html.js
var require_snippets_html = __commonJS({
  "out/vue/snippets-html.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.default = (tabSize) => {
      return {
        "vcomponent": `<component :is="\${1:componentId}"></component>$0`,
        "vka": `<keep-alive$1>
${tabSize}$2
</keep-alive>$0`,
        "vtransition": `<transition$1>
${tabSize}$2
</transition>$0`,
        "vtg": `<transition-group$1>
${tabSize}$2
</transition-group>`,
        "vrl": `<router-link $1>$2</router-link>$0`,
        "vrlt": `<router-link to="$1">$2</router-link>$0`,
        "vrv": `<router-view>$1</router-view>$0`
      };
    };
  }
});

// out/vue/snippets-js.js
var require_snippets_js = __commonJS({
  "out/vue/snippets-js.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.default = (tabSize) => {
      return {
        "vnew": `new Vue({
${tabSize}$1
})`,
        "vgsilent": `Vue.config.silent = \${1:true}`,
        "vgeh": `Vue.config.errorHandler = function (err, vm, info) {
${tabSize}\${1:// handle error}
}`,
        "vgwh": `Vue.config.warnHandler = function (msg, vm, trace) {
${tabSize}\${1:// handle warn}
}`,
        "vgextend": `Vue.extend({
${tabSize}template:\${1:template}
})`,
        "vgnt": `Vue.nextTick({
${tabSize}$1
})`,
        "vgset": `Vue.set(\${2:target}, \${3:key}, \${4:value})`,
        "vgdelete": `Vue.delete(\${2:target}, \${3:key})`,
        "vgdirective": `Vue.directive(\${2:id}\${3:, [definition]})`,
        "vgfilter": `Vue.filter(\${1:id}\${2:, [definition]})`,
        "vgcomponent": `Vue.component(\${1:id}\${2:, [definition]})$0`,
        "vguse": `Vue.use(\${1:plugin})$0`,
        "vgmixin": `Vue.mixin({\${1:mixin}})`,
        "vgcompile": `Vue.compile(\${1:template})`,
        "vdata": `data() {
${tabSize}return {
${tabSize}${tabSize}$1
${tabSize}}
},$0`,
        "vmounted": `mounted () {
${tabSize}$1
}`,
        "vbm": `beforeMount () {
${tabSize}$1
}`,
        "vcreated": `created () {
${tabSize}$1
}`,
        "vbc": `beforeCreate () {
${tabSize}$1
}`,
        "vupdated": `updated () {
${tabSize}$1
}`,
        "vbu": `beforeUpdate () {
${tabSize}$1
}`,
        "vactivated": `activated () {
${tabSize}$1
}`,
        "vdeactivated": `deactivated () {
${tabSize}$1
}`,
        "vbd": `beforeDestroy () {
${tabSize}$1
}`,
        "vdestroyed": `destroyed () {
${tabSize}$1
}`,
        "vprops": `props: {
${tabSize}$1
}`,
        "vpd": `propsData: {
${tabSize}$1
}`,
        "vcomputed": `computed: {
${tabSize}$1
}`,
        "vmethods": `methods: {
${tabSize}$1
}`,
        "vwatch": `watch: {
${tabSize}$1
}`,
        "vwo": `\${1:key}: {
${tabSize}deep: \${2:true},
${tabSize}immediate: \${3:true},
${tabSize}handler: function (\${4:val}, \${5:oldVal}) {
${tabSize}${tabSize}$6
${tabSize}}
},$0`,
        "vdirectives": `directives: {
${tabSize}$1
}`,
        "vfilters": `filters: {
${tabSize}$1
}`,
        "vcomponents": `components: {
${tabSize}$1
}`,
        "vmixins": `mixins:[$1],`,
        "vprovide": `provide: {
${tabSize}$1
}`,
        "vinject": `inject: [$1],`,
        "vmodel": `model: {
${tabSize}prop: $1,
${tabSize}event: $2
}`,
        "vrender": `render(h) {
${tabSize}$1
},`,
        "vel": `\${1|this,vm|}.$el$2`,
        "voptions": `\${1|this,vm|}.$options$2`,
        "vparent": `\${1|this,vm|}.$parent$2`,
        "vroot": `\${1|this,vm|}.$root$2`,
        "vchildren": `\${1|this,vm|}.$children$2`,
        "vslots": `\${1|this,vm|}.$slots$2`,
        "vss": `\${1|this,vm|}.$scopedSlots.default({
${tabSize}$2
})`,
        "vrefs": `\${1|this,vm|}.$refs$2`,
        "vis": `\${1|this,vm|}.$isServer$2`,
        "vattrs": `\${1|this,vm|}.$attrs$2`,
        "vlisteners": `\${1|this,vm|}.$listeners$2`,
        "vset": `\${1|this,vm|}.$set(\${2:target}, \${3:key}, \${4:value})`,
        "vdelete": `\${1|this,vm|}.$delete(\${2:target}, \${3:key})`,
        "von": `\${1|this,vm|}.$on('\${2:event}', \${3:callback})$4`,
        "vonce": `\${1|this,vm|}.$once('\${2:event}', \${3:callback})$4`,
        "voff": `\${1|this,vm|}.$off('\${2:event}', \${3:callback})$4`,
        "vemit": `\${1|this,vm|}.$emit('\${2:event}'\${3:, args})$4`,
        "vmount": `\${1|this,vm|}.$mount('$2')`,
        "vfu": `\${1|this,vm|}.$forceUpdate()`,
        "vdestroy": `\${1|this,vm|}.$destroy()$2`,
        "vnt": `\${1|this,vm|}.$nextTick(() => {
${tabSize}$2
})`
      };
    };
  }
});

// node_modules/balanced-match/index.js
var require_balanced_match = __commonJS({
  "node_modules/balanced-match/index.js"(exports2, module2) {
    "use strict";
    module2.exports = balanced;
    function balanced(a, b, str) {
      if (a instanceof RegExp)
        a = maybeMatch(a, str);
      if (b instanceof RegExp)
        b = maybeMatch(b, str);
      var r = range(a, b, str);
      return r && {
        start: r[0],
        end: r[1],
        pre: str.slice(0, r[0]),
        body: str.slice(r[0] + a.length, r[1]),
        post: str.slice(r[1] + b.length)
      };
    }
    function maybeMatch(reg, str) {
      var m = str.match(reg);
      return m ? m[0] : null;
    }
    balanced.range = range;
    function range(a, b, str) {
      var begs, beg, left, right, result;
      var ai = str.indexOf(a);
      var bi = str.indexOf(b, ai + 1);
      var i = ai;
      if (ai >= 0 && bi > 0) {
        if (a === b) {
          return [ai, bi];
        }
        begs = [];
        left = str.length;
        while (i >= 0 && !result) {
          if (i == ai) {
            begs.push(i);
            ai = str.indexOf(a, i + 1);
          } else if (begs.length == 1) {
            result = [begs.pop(), bi];
          } else {
            beg = begs.pop();
            if (beg < left) {
              left = beg;
              right = bi;
            }
            bi = str.indexOf(b, i + 1);
          }
          i = ai < bi && ai >= 0 ? ai : bi;
        }
        if (begs.length) {
          result = [left, right];
        }
      }
      return result;
    }
  }
});

// node_modules/brace-expansion/index.js
var require_brace_expansion = __commonJS({
  "node_modules/brace-expansion/index.js"(exports2, module2) {
    var balanced = require_balanced_match();
    module2.exports = expandTop;
    var escSlash = "\0SLASH" + Math.random() + "\0";
    var escOpen = "\0OPEN" + Math.random() + "\0";
    var escClose = "\0CLOSE" + Math.random() + "\0";
    var escComma = "\0COMMA" + Math.random() + "\0";
    var escPeriod = "\0PERIOD" + Math.random() + "\0";
    function numeric(str) {
      return parseInt(str, 10) == str ? parseInt(str, 10) : str.charCodeAt(0);
    }
    function escapeBraces(str) {
      return str.split("\\\\").join(escSlash).split("\\{").join(escOpen).split("\\}").join(escClose).split("\\,").join(escComma).split("\\.").join(escPeriod);
    }
    function unescapeBraces(str) {
      return str.split(escSlash).join("\\").split(escOpen).join("{").split(escClose).join("}").split(escComma).join(",").split(escPeriod).join(".");
    }
    function parseCommaParts(str) {
      if (!str)
        return [""];
      var parts = [];
      var m = balanced("{", "}", str);
      if (!m)
        return str.split(",");
      var pre = m.pre;
      var body = m.body;
      var post = m.post;
      var p = pre.split(",");
      p[p.length - 1] += "{" + body + "}";
      var postParts = parseCommaParts(post);
      if (post.length) {
        p[p.length - 1] += postParts.shift();
        p.push.apply(p, postParts);
      }
      parts.push.apply(parts, p);
      return parts;
    }
    function expandTop(str) {
      if (!str)
        return [];
      if (str.substr(0, 2) === "{}") {
        str = "\\{\\}" + str.substr(2);
      }
      return expand(escapeBraces(str), true).map(unescapeBraces);
    }
    function embrace(str) {
      return "{" + str + "}";
    }
    function isPadded(el) {
      return /^-?0\d/.test(el);
    }
    function lte(i, y) {
      return i <= y;
    }
    function gte(i, y) {
      return i >= y;
    }
    function expand(str, isTop) {
      var expansions = [];
      var m = balanced("{", "}", str);
      if (!m)
        return [str];
      var pre = m.pre;
      var post = m.post.length ? expand(m.post, false) : [""];
      if (/\$$/.test(m.pre)) {
        for (var k = 0; k < post.length; k++) {
          var expansion = pre + "{" + m.body + "}" + post[k];
          expansions.push(expansion);
        }
      } else {
        var isNumericSequence = /^-?\d+\.\.-?\d+(?:\.\.-?\d+)?$/.test(m.body);
        var isAlphaSequence = /^[a-zA-Z]\.\.[a-zA-Z](?:\.\.-?\d+)?$/.test(m.body);
        var isSequence = isNumericSequence || isAlphaSequence;
        var isOptions = m.body.indexOf(",") >= 0;
        if (!isSequence && !isOptions) {
          if (m.post.match(/,.*\}/)) {
            str = m.pre + "{" + m.body + escClose + m.post;
            return expand(str);
          }
          return [str];
        }
        var n;
        if (isSequence) {
          n = m.body.split(/\.\./);
        } else {
          n = parseCommaParts(m.body);
          if (n.length === 1) {
            n = expand(n[0], false).map(embrace);
            if (n.length === 1) {
              return post.map(function(p) {
                return m.pre + n[0] + p;
              });
            }
          }
        }
        var N;
        if (isSequence) {
          var x = numeric(n[0]);
          var y = numeric(n[1]);
          var width = Math.max(n[0].length, n[1].length);
          var incr = n.length == 3 ? Math.abs(numeric(n[2])) : 1;
          var test = lte;
          var reverse = y < x;
          if (reverse) {
            incr *= -1;
            test = gte;
          }
          var pad = n.some(isPadded);
          N = [];
          for (var i = x; test(i, y); i += incr) {
            var c;
            if (isAlphaSequence) {
              c = String.fromCharCode(i);
              if (c === "\\")
                c = "";
            } else {
              c = String(i);
              if (pad) {
                var need = width - c.length;
                if (need > 0) {
                  var z = new Array(need + 1).join("0");
                  if (i < 0)
                    c = "-" + z + c.slice(1);
                  else
                    c = z + c;
                }
              }
            }
            N.push(c);
          }
        } else {
          N = [];
          for (var j = 0; j < n.length; j++) {
            N.push.apply(N, expand(n[j], false));
          }
        }
        for (var j = 0; j < N.length; j++) {
          for (var k = 0; k < post.length; k++) {
            var expansion = pre + N[j] + post[k];
            if (!isTop || isSequence || expansion)
              expansions.push(expansion);
          }
        }
      }
      return expansions;
    }
  }
});

// node_modules/minimatch/dist/commonjs/assert-valid-pattern.js
var require_assert_valid_pattern = __commonJS({
  "node_modules/minimatch/dist/commonjs/assert-valid-pattern.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.assertValidPattern = void 0;
    var MAX_PATTERN_LENGTH = 1024 * 64;
    var assertValidPattern = (pattern) => {
      if (typeof pattern !== "string") {
        throw new TypeError("invalid pattern");
      }
      if (pattern.length > MAX_PATTERN_LENGTH) {
        throw new TypeError("pattern is too long");
      }
    };
    exports2.assertValidPattern = assertValidPattern;
  }
});

// node_modules/minimatch/dist/commonjs/brace-expressions.js
var require_brace_expressions = __commonJS({
  "node_modules/minimatch/dist/commonjs/brace-expressions.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.parseClass = void 0;
    var posixClasses = {
      "[:alnum:]": ["\\p{L}\\p{Nl}\\p{Nd}", true],
      "[:alpha:]": ["\\p{L}\\p{Nl}", true],
      "[:ascii:]": ["\\x00-\\x7f", false],
      "[:blank:]": ["\\p{Zs}\\t", true],
      "[:cntrl:]": ["\\p{Cc}", true],
      "[:digit:]": ["\\p{Nd}", true],
      "[:graph:]": ["\\p{Z}\\p{C}", true, true],
      "[:lower:]": ["\\p{Ll}", true],
      "[:print:]": ["\\p{C}", true],
      "[:punct:]": ["\\p{P}", true],
      "[:space:]": ["\\p{Z}\\t\\r\\n\\v\\f", true],
      "[:upper:]": ["\\p{Lu}", true],
      "[:word:]": ["\\p{L}\\p{Nl}\\p{Nd}\\p{Pc}", true],
      "[:xdigit:]": ["A-Fa-f0-9", false]
    };
    var braceEscape = (s) => s.replace(/[[\]\\-]/g, "\\$&");
    var regexpEscape = (s) => s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
    var rangesToString = (ranges) => ranges.join("");
    var parseClass = (glob, position) => {
      const pos = position;
      if (glob.charAt(pos) !== "[") {
        throw new Error("not in a brace expression");
      }
      const ranges = [];
      const negs = [];
      let i = pos + 1;
      let sawStart = false;
      let uflag = false;
      let escaping = false;
      let negate = false;
      let endPos = pos;
      let rangeStart = "";
      WHILE:
        while (i < glob.length) {
          const c = glob.charAt(i);
          if ((c === "!" || c === "^") && i === pos + 1) {
            negate = true;
            i++;
            continue;
          }
          if (c === "]" && sawStart && !escaping) {
            endPos = i + 1;
            break;
          }
          sawStart = true;
          if (c === "\\") {
            if (!escaping) {
              escaping = true;
              i++;
              continue;
            }
          }
          if (c === "[" && !escaping) {
            for (const [cls, [unip, u, neg]] of Object.entries(posixClasses)) {
              if (glob.startsWith(cls, i)) {
                if (rangeStart) {
                  return ["$.", false, glob.length - pos, true];
                }
                i += cls.length;
                if (neg)
                  negs.push(unip);
                else
                  ranges.push(unip);
                uflag = uflag || u;
                continue WHILE;
              }
            }
          }
          escaping = false;
          if (rangeStart) {
            if (c > rangeStart) {
              ranges.push(braceEscape(rangeStart) + "-" + braceEscape(c));
            } else if (c === rangeStart) {
              ranges.push(braceEscape(c));
            }
            rangeStart = "";
            i++;
            continue;
          }
          if (glob.startsWith("-]", i + 1)) {
            ranges.push(braceEscape(c + "-"));
            i += 2;
            continue;
          }
          if (glob.startsWith("-", i + 1)) {
            rangeStart = c;
            i += 2;
            continue;
          }
          ranges.push(braceEscape(c));
          i++;
        }
      if (endPos < i) {
        return ["", false, 0, false];
      }
      if (!ranges.length && !negs.length) {
        return ["$.", false, glob.length - pos, true];
      }
      if (negs.length === 0 && ranges.length === 1 && /^\\?.$/.test(ranges[0]) && !negate) {
        const r = ranges[0].length === 2 ? ranges[0].slice(-1) : ranges[0];
        return [regexpEscape(r), false, endPos - pos, false];
      }
      const sranges = "[" + (negate ? "^" : "") + rangesToString(ranges) + "]";
      const snegs = "[" + (negate ? "" : "^") + rangesToString(negs) + "]";
      const comb = ranges.length && negs.length ? "(" + sranges + "|" + snegs + ")" : ranges.length ? sranges : snegs;
      return [comb, uflag, endPos - pos, true];
    };
    exports2.parseClass = parseClass;
  }
});

// node_modules/minimatch/dist/commonjs/unescape.js
var require_unescape = __commonJS({
  "node_modules/minimatch/dist/commonjs/unescape.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.unescape = void 0;
    var unescape2 = (s, { windowsPathsNoEscape = false } = {}) => {
      return windowsPathsNoEscape ? s.replace(/\[([^\/\\])\]/g, "$1") : s.replace(/((?!\\).|^)\[([^\/\\])\]/g, "$1$2").replace(/\\([^\/])/g, "$1");
    };
    exports2.unescape = unescape2;
  }
});

// node_modules/minimatch/dist/commonjs/ast.js
var require_ast = __commonJS({
  "node_modules/minimatch/dist/commonjs/ast.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.AST = void 0;
    var brace_expressions_js_1 = require_brace_expressions();
    var unescape_js_1 = require_unescape();
    var types = /* @__PURE__ */ new Set(["!", "?", "+", "*", "@"]);
    var isExtglobType = (c) => types.has(c);
    var startNoTraversal = "(?!(?:^|/)\\.\\.?(?:$|/))";
    var startNoDot = "(?!\\.)";
    var addPatternStart = /* @__PURE__ */ new Set(["[", "."]);
    var justDots = /* @__PURE__ */ new Set(["..", "."]);
    var reSpecials = new Set("().*{}+?[]^$\\!");
    var regExpEscape = (s) => s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
    var qmark = "[^/]";
    var star = qmark + "*?";
    var starNoEmpty = qmark + "+?";
    var _root, _hasMagic, _uflag, _parts, _parent, _parentIndex, _negs, _filledNegs, _options, _toString, _emptyExt, _fillNegs, fillNegs_fn, _parseAST, parseAST_fn, _partsToRegExp, partsToRegExp_fn, _parseGlob, parseGlob_fn;
    var _AST = class {
      constructor(type, parent, options = {}) {
        __privateAdd(this, _fillNegs);
        __privateAdd(this, _partsToRegExp);
        __publicField(this, "type");
        __privateAdd(this, _root, void 0);
        __privateAdd(this, _hasMagic, void 0);
        __privateAdd(this, _uflag, false);
        __privateAdd(this, _parts, []);
        __privateAdd(this, _parent, void 0);
        __privateAdd(this, _parentIndex, void 0);
        __privateAdd(this, _negs, void 0);
        __privateAdd(this, _filledNegs, false);
        __privateAdd(this, _options, void 0);
        __privateAdd(this, _toString, void 0);
        __privateAdd(this, _emptyExt, false);
        this.type = type;
        if (type)
          __privateSet(this, _hasMagic, true);
        __privateSet(this, _parent, parent);
        __privateSet(this, _root, __privateGet(this, _parent) ? __privateGet(__privateGet(this, _parent), _root) : this);
        __privateSet(this, _options, __privateGet(this, _root) === this ? options : __privateGet(__privateGet(this, _root), _options));
        __privateSet(this, _negs, __privateGet(this, _root) === this ? [] : __privateGet(__privateGet(this, _root), _negs));
        if (type === "!" && !__privateGet(__privateGet(this, _root), _filledNegs))
          __privateGet(this, _negs).push(this);
        __privateSet(this, _parentIndex, __privateGet(this, _parent) ? __privateGet(__privateGet(this, _parent), _parts).length : 0);
      }
      get hasMagic() {
        if (__privateGet(this, _hasMagic) !== void 0)
          return __privateGet(this, _hasMagic);
        for (const p of __privateGet(this, _parts)) {
          if (typeof p === "string")
            continue;
          if (p.type || p.hasMagic)
            return __privateSet(this, _hasMagic, true);
        }
        return __privateGet(this, _hasMagic);
      }
      toString() {
        if (__privateGet(this, _toString) !== void 0)
          return __privateGet(this, _toString);
        if (!this.type) {
          return __privateSet(this, _toString, __privateGet(this, _parts).map((p) => String(p)).join(""));
        } else {
          return __privateSet(this, _toString, this.type + "(" + __privateGet(this, _parts).map((p) => String(p)).join("|") + ")");
        }
      }
      push(...parts) {
        for (const p of parts) {
          if (p === "")
            continue;
          if (typeof p !== "string" && !(p instanceof _AST && __privateGet(p, _parent) === this)) {
            throw new Error("invalid part: " + p);
          }
          __privateGet(this, _parts).push(p);
        }
      }
      toJSON() {
        const ret = this.type === null ? __privateGet(this, _parts).slice().map((p) => typeof p === "string" ? p : p.toJSON()) : [this.type, ...__privateGet(this, _parts).map((p) => p.toJSON())];
        if (this.isStart() && !this.type)
          ret.unshift([]);
        if (this.isEnd() && (this === __privateGet(this, _root) || __privateGet(__privateGet(this, _root), _filledNegs) && __privateGet(this, _parent)?.type === "!")) {
          ret.push({});
        }
        return ret;
      }
      isStart() {
        if (__privateGet(this, _root) === this)
          return true;
        if (!__privateGet(this, _parent)?.isStart())
          return false;
        if (__privateGet(this, _parentIndex) === 0)
          return true;
        const p = __privateGet(this, _parent);
        for (let i = 0; i < __privateGet(this, _parentIndex); i++) {
          const pp = __privateGet(p, _parts)[i];
          if (!(pp instanceof _AST && pp.type === "!")) {
            return false;
          }
        }
        return true;
      }
      isEnd() {
        if (__privateGet(this, _root) === this)
          return true;
        if (__privateGet(this, _parent)?.type === "!")
          return true;
        if (!__privateGet(this, _parent)?.isEnd())
          return false;
        if (!this.type)
          return __privateGet(this, _parent)?.isEnd();
        const pl = __privateGet(this, _parent) ? __privateGet(__privateGet(this, _parent), _parts).length : 0;
        return __privateGet(this, _parentIndex) === pl - 1;
      }
      copyIn(part) {
        if (typeof part === "string")
          this.push(part);
        else
          this.push(part.clone(this));
      }
      clone(parent) {
        const c = new _AST(this.type, parent);
        for (const p of __privateGet(this, _parts)) {
          c.copyIn(p);
        }
        return c;
      }
      static fromGlob(pattern, options = {}) {
        var _a;
        const ast = new _AST(null, void 0, options);
        __privateMethod(_a = _AST, _parseAST, parseAST_fn).call(_a, pattern, ast, 0, options);
        return ast;
      }
      toMMPattern() {
        if (this !== __privateGet(this, _root))
          return __privateGet(this, _root).toMMPattern();
        const glob = this.toString();
        const [re, body, hasMagic, uflag] = this.toRegExpSource();
        const anyMagic = hasMagic || __privateGet(this, _hasMagic) || __privateGet(this, _options).nocase && !__privateGet(this, _options).nocaseMagicOnly && glob.toUpperCase() !== glob.toLowerCase();
        if (!anyMagic) {
          return body;
        }
        const flags = (__privateGet(this, _options).nocase ? "i" : "") + (uflag ? "u" : "");
        return Object.assign(new RegExp(`^${re}$`, flags), {
          _src: re,
          _glob: glob
        });
      }
      get options() {
        return __privateGet(this, _options);
      }
      toRegExpSource(allowDot) {
        const dot = allowDot ?? !!__privateGet(this, _options).dot;
        if (__privateGet(this, _root) === this)
          __privateMethod(this, _fillNegs, fillNegs_fn).call(this);
        if (!this.type) {
          const noEmpty = this.isStart() && this.isEnd();
          const src = __privateGet(this, _parts).map((p) => {
            var _a;
            const [re, _, hasMagic, uflag] = typeof p === "string" ? __privateMethod(_a = _AST, _parseGlob, parseGlob_fn).call(_a, p, __privateGet(this, _hasMagic), noEmpty) : p.toRegExpSource(allowDot);
            __privateSet(this, _hasMagic, __privateGet(this, _hasMagic) || hasMagic);
            __privateSet(this, _uflag, __privateGet(this, _uflag) || uflag);
            return re;
          }).join("");
          let start2 = "";
          if (this.isStart()) {
            if (typeof __privateGet(this, _parts)[0] === "string") {
              const dotTravAllowed = __privateGet(this, _parts).length === 1 && justDots.has(__privateGet(this, _parts)[0]);
              if (!dotTravAllowed) {
                const aps = addPatternStart;
                const needNoTrav = dot && aps.has(src.charAt(0)) || src.startsWith("\\.") && aps.has(src.charAt(2)) || src.startsWith("\\.\\.") && aps.has(src.charAt(4));
                const needNoDot = !dot && !allowDot && aps.has(src.charAt(0));
                start2 = needNoTrav ? startNoTraversal : needNoDot ? startNoDot : "";
              }
            }
          }
          let end = "";
          if (this.isEnd() && __privateGet(__privateGet(this, _root), _filledNegs) && __privateGet(this, _parent)?.type === "!") {
            end = "(?:$|\\/)";
          }
          const final2 = start2 + src + end;
          return [
            final2,
            (0, unescape_js_1.unescape)(src),
            __privateSet(this, _hasMagic, !!__privateGet(this, _hasMagic)),
            __privateGet(this, _uflag)
          ];
        }
        const repeated = this.type === "*" || this.type === "+";
        const start = this.type === "!" ? "(?:(?!(?:" : "(?:";
        let body = __privateMethod(this, _partsToRegExp, partsToRegExp_fn).call(this, dot);
        if (this.isStart() && this.isEnd() && !body && this.type !== "!") {
          const s = this.toString();
          __privateSet(this, _parts, [s]);
          this.type = null;
          __privateSet(this, _hasMagic, void 0);
          return [s, (0, unescape_js_1.unescape)(this.toString()), false, false];
        }
        let bodyDotAllowed = !repeated || allowDot || dot || !startNoDot ? "" : __privateMethod(this, _partsToRegExp, partsToRegExp_fn).call(this, true);
        if (bodyDotAllowed === body) {
          bodyDotAllowed = "";
        }
        if (bodyDotAllowed) {
          body = `(?:${body})(?:${bodyDotAllowed})*?`;
        }
        let final = "";
        if (this.type === "!" && __privateGet(this, _emptyExt)) {
          final = (this.isStart() && !dot ? startNoDot : "") + starNoEmpty;
        } else {
          const close = this.type === "!" ? "))" + (this.isStart() && !dot && !allowDot ? startNoDot : "") + star + ")" : this.type === "@" ? ")" : this.type === "?" ? ")?" : this.type === "+" && bodyDotAllowed ? ")" : this.type === "*" && bodyDotAllowed ? `)?` : `)${this.type}`;
          final = start + body + close;
        }
        return [
          final,
          (0, unescape_js_1.unescape)(body),
          __privateSet(this, _hasMagic, !!__privateGet(this, _hasMagic)),
          __privateGet(this, _uflag)
        ];
      }
    };
    var AST = _AST;
    _root = new WeakMap();
    _hasMagic = new WeakMap();
    _uflag = new WeakMap();
    _parts = new WeakMap();
    _parent = new WeakMap();
    _parentIndex = new WeakMap();
    _negs = new WeakMap();
    _filledNegs = new WeakMap();
    _options = new WeakMap();
    _toString = new WeakMap();
    _emptyExt = new WeakMap();
    _fillNegs = new WeakSet();
    fillNegs_fn = function() {
      if (this !== __privateGet(this, _root))
        throw new Error("should only call on root");
      if (__privateGet(this, _filledNegs))
        return this;
      this.toString();
      __privateSet(this, _filledNegs, true);
      let n;
      while (n = __privateGet(this, _negs).pop()) {
        if (n.type !== "!")
          continue;
        let p = n;
        let pp = __privateGet(p, _parent);
        while (pp) {
          for (let i = __privateGet(p, _parentIndex) + 1; !pp.type && i < __privateGet(pp, _parts).length; i++) {
            for (const part of __privateGet(n, _parts)) {
              if (typeof part === "string") {
                throw new Error("string part in extglob AST??");
              }
              part.copyIn(__privateGet(pp, _parts)[i]);
            }
          }
          p = pp;
          pp = __privateGet(p, _parent);
        }
      }
      return this;
    };
    _parseAST = new WeakSet();
    parseAST_fn = function(str, ast, pos, opt) {
      var _a, _b;
      let escaping = false;
      let inBrace = false;
      let braceStart = -1;
      let braceNeg = false;
      if (ast.type === null) {
        let i2 = pos;
        let acc2 = "";
        while (i2 < str.length) {
          const c = str.charAt(i2++);
          if (escaping || c === "\\") {
            escaping = !escaping;
            acc2 += c;
            continue;
          }
          if (inBrace) {
            if (i2 === braceStart + 1) {
              if (c === "^" || c === "!") {
                braceNeg = true;
              }
            } else if (c === "]" && !(i2 === braceStart + 2 && braceNeg)) {
              inBrace = false;
            }
            acc2 += c;
            continue;
          } else if (c === "[") {
            inBrace = true;
            braceStart = i2;
            braceNeg = false;
            acc2 += c;
            continue;
          }
          if (!opt.noext && isExtglobType(c) && str.charAt(i2) === "(") {
            ast.push(acc2);
            acc2 = "";
            const ext = new _AST(c, ast);
            i2 = __privateMethod(_a = _AST, _parseAST, parseAST_fn).call(_a, str, ext, i2, opt);
            ast.push(ext);
            continue;
          }
          acc2 += c;
        }
        ast.push(acc2);
        return i2;
      }
      let i = pos + 1;
      let part = new _AST(null, ast);
      const parts = [];
      let acc = "";
      while (i < str.length) {
        const c = str.charAt(i++);
        if (escaping || c === "\\") {
          escaping = !escaping;
          acc += c;
          continue;
        }
        if (inBrace) {
          if (i === braceStart + 1) {
            if (c === "^" || c === "!") {
              braceNeg = true;
            }
          } else if (c === "]" && !(i === braceStart + 2 && braceNeg)) {
            inBrace = false;
          }
          acc += c;
          continue;
        } else if (c === "[") {
          inBrace = true;
          braceStart = i;
          braceNeg = false;
          acc += c;
          continue;
        }
        if (isExtglobType(c) && str.charAt(i) === "(") {
          part.push(acc);
          acc = "";
          const ext = new _AST(c, part);
          part.push(ext);
          i = __privateMethod(_b = _AST, _parseAST, parseAST_fn).call(_b, str, ext, i, opt);
          continue;
        }
        if (c === "|") {
          part.push(acc);
          acc = "";
          parts.push(part);
          part = new _AST(null, ast);
          continue;
        }
        if (c === ")") {
          if (acc === "" && __privateGet(ast, _parts).length === 0) {
            __privateSet(ast, _emptyExt, true);
          }
          part.push(acc);
          acc = "";
          ast.push(...parts, part);
          return i;
        }
        acc += c;
      }
      ast.type = null;
      __privateSet(ast, _hasMagic, void 0);
      __privateSet(ast, _parts, [str.substring(pos - 1)]);
      return i;
    };
    _partsToRegExp = new WeakSet();
    partsToRegExp_fn = function(dot) {
      return __privateGet(this, _parts).map((p) => {
        if (typeof p === "string") {
          throw new Error("string type in extglob ast??");
        }
        const [re, _, _hasMagic2, uflag] = p.toRegExpSource(dot);
        __privateSet(this, _uflag, __privateGet(this, _uflag) || uflag);
        return re;
      }).filter((p) => !(this.isStart() && this.isEnd()) || !!p).join("|");
    };
    _parseGlob = new WeakSet();
    parseGlob_fn = function(glob, hasMagic, noEmpty = false) {
      let escaping = false;
      let re = "";
      let uflag = false;
      for (let i = 0; i < glob.length; i++) {
        const c = glob.charAt(i);
        if (escaping) {
          escaping = false;
          re += (reSpecials.has(c) ? "\\" : "") + c;
          continue;
        }
        if (c === "\\") {
          if (i === glob.length - 1) {
            re += "\\\\";
          } else {
            escaping = true;
          }
          continue;
        }
        if (c === "[") {
          const [src, needUflag, consumed, magic] = (0, brace_expressions_js_1.parseClass)(glob, i);
          if (consumed) {
            re += src;
            uflag = uflag || needUflag;
            i += consumed - 1;
            hasMagic = hasMagic || magic;
            continue;
          }
        }
        if (c === "*") {
          if (noEmpty && glob === "*")
            re += starNoEmpty;
          else
            re += star;
          hasMagic = true;
          continue;
        }
        if (c === "?") {
          re += qmark;
          hasMagic = true;
          continue;
        }
        re += regExpEscape(c);
      }
      return [re, (0, unescape_js_1.unescape)(glob), !!hasMagic, uflag];
    };
    __privateAdd(AST, _parseAST);
    __privateAdd(AST, _parseGlob);
    exports2.AST = AST;
  }
});

// node_modules/minimatch/dist/commonjs/escape.js
var require_escape2 = __commonJS({
  "node_modules/minimatch/dist/commonjs/escape.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.escape = void 0;
    var escape = (s, { windowsPathsNoEscape = false } = {}) => {
      return windowsPathsNoEscape ? s.replace(/[?*()[\]]/g, "[$&]") : s.replace(/[?*()[\]\\]/g, "\\$&");
    };
    exports2.escape = escape;
  }
});

// node_modules/minimatch/dist/commonjs/index.js
var require_commonjs = __commonJS({
  "node_modules/minimatch/dist/commonjs/index.js"(exports2) {
    "use strict";
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.unescape = exports2.escape = exports2.AST = exports2.Minimatch = exports2.match = exports2.makeRe = exports2.braceExpand = exports2.defaults = exports2.filter = exports2.GLOBSTAR = exports2.sep = exports2.minimatch = void 0;
    var brace_expansion_1 = __importDefault(require_brace_expansion());
    var assert_valid_pattern_js_1 = require_assert_valid_pattern();
    var ast_js_1 = require_ast();
    var escape_js_1 = require_escape2();
    var unescape_js_1 = require_unescape();
    var minimatch = (p, pattern, options = {}) => {
      (0, assert_valid_pattern_js_1.assertValidPattern)(pattern);
      if (!options.nocomment && pattern.charAt(0) === "#") {
        return false;
      }
      return new Minimatch(pattern, options).match(p);
    };
    exports2.minimatch = minimatch;
    var starDotExtRE = /^\*+([^+@!?\*\[\(]*)$/;
    var starDotExtTest = (ext2) => (f) => !f.startsWith(".") && f.endsWith(ext2);
    var starDotExtTestDot = (ext2) => (f) => f.endsWith(ext2);
    var starDotExtTestNocase = (ext2) => {
      ext2 = ext2.toLowerCase();
      return (f) => !f.startsWith(".") && f.toLowerCase().endsWith(ext2);
    };
    var starDotExtTestNocaseDot = (ext2) => {
      ext2 = ext2.toLowerCase();
      return (f) => f.toLowerCase().endsWith(ext2);
    };
    var starDotStarRE = /^\*+\.\*+$/;
    var starDotStarTest = (f) => !f.startsWith(".") && f.includes(".");
    var starDotStarTestDot = (f) => f !== "." && f !== ".." && f.includes(".");
    var dotStarRE = /^\.\*+$/;
    var dotStarTest = (f) => f !== "." && f !== ".." && f.startsWith(".");
    var starRE = /^\*+$/;
    var starTest = (f) => f.length !== 0 && !f.startsWith(".");
    var starTestDot = (f) => f.length !== 0 && f !== "." && f !== "..";
    var qmarksRE = /^\?+([^+@!?\*\[\(]*)?$/;
    var qmarksTestNocase = ([$0, ext2 = ""]) => {
      const noext = qmarksTestNoExt([$0]);
      if (!ext2)
        return noext;
      ext2 = ext2.toLowerCase();
      return (f) => noext(f) && f.toLowerCase().endsWith(ext2);
    };
    var qmarksTestNocaseDot = ([$0, ext2 = ""]) => {
      const noext = qmarksTestNoExtDot([$0]);
      if (!ext2)
        return noext;
      ext2 = ext2.toLowerCase();
      return (f) => noext(f) && f.toLowerCase().endsWith(ext2);
    };
    var qmarksTestDot = ([$0, ext2 = ""]) => {
      const noext = qmarksTestNoExtDot([$0]);
      return !ext2 ? noext : (f) => noext(f) && f.endsWith(ext2);
    };
    var qmarksTest = ([$0, ext2 = ""]) => {
      const noext = qmarksTestNoExt([$0]);
      return !ext2 ? noext : (f) => noext(f) && f.endsWith(ext2);
    };
    var qmarksTestNoExt = ([$0]) => {
      const len = $0.length;
      return (f) => f.length === len && !f.startsWith(".");
    };
    var qmarksTestNoExtDot = ([$0]) => {
      const len = $0.length;
      return (f) => f.length === len && f !== "." && f !== "..";
    };
    var defaultPlatform = typeof process === "object" && process ? typeof process.env === "object" && process.env && process.env.__MINIMATCH_TESTING_PLATFORM__ || process.platform : "posix";
    var path3 = {
      win32: { sep: "\\" },
      posix: { sep: "/" }
    };
    exports2.sep = defaultPlatform === "win32" ? path3.win32.sep : path3.posix.sep;
    exports2.minimatch.sep = exports2.sep;
    exports2.GLOBSTAR = Symbol("globstar **");
    exports2.minimatch.GLOBSTAR = exports2.GLOBSTAR;
    var qmark = "[^/]";
    var star = qmark + "*?";
    var twoStarDot = "(?:(?!(?:\\/|^)(?:\\.{1,2})($|\\/)).)*?";
    var twoStarNoDot = "(?:(?!(?:\\/|^)\\.).)*?";
    var filter = (pattern, options = {}) => (p) => (0, exports2.minimatch)(p, pattern, options);
    exports2.filter = filter;
    exports2.minimatch.filter = exports2.filter;
    var ext = (a, b = {}) => Object.assign({}, a, b);
    var defaults = (def) => {
      if (!def || typeof def !== "object" || !Object.keys(def).length) {
        return exports2.minimatch;
      }
      const orig = exports2.minimatch;
      const m = (p, pattern, options = {}) => orig(p, pattern, ext(def, options));
      return Object.assign(m, {
        Minimatch: class Minimatch extends orig.Minimatch {
          constructor(pattern, options = {}) {
            super(pattern, ext(def, options));
          }
          static defaults(options) {
            return orig.defaults(ext(def, options)).Minimatch;
          }
        },
        AST: class AST extends orig.AST {
          constructor(type, parent, options = {}) {
            super(type, parent, ext(def, options));
          }
          static fromGlob(pattern, options = {}) {
            return orig.AST.fromGlob(pattern, ext(def, options));
          }
        },
        unescape: (s, options = {}) => orig.unescape(s, ext(def, options)),
        escape: (s, options = {}) => orig.escape(s, ext(def, options)),
        filter: (pattern, options = {}) => orig.filter(pattern, ext(def, options)),
        defaults: (options) => orig.defaults(ext(def, options)),
        makeRe: (pattern, options = {}) => orig.makeRe(pattern, ext(def, options)),
        braceExpand: (pattern, options = {}) => orig.braceExpand(pattern, ext(def, options)),
        match: (list, pattern, options = {}) => orig.match(list, pattern, ext(def, options)),
        sep: orig.sep,
        GLOBSTAR: exports2.GLOBSTAR
      });
    };
    exports2.defaults = defaults;
    exports2.minimatch.defaults = exports2.defaults;
    var braceExpand = (pattern, options = {}) => {
      (0, assert_valid_pattern_js_1.assertValidPattern)(pattern);
      if (options.nobrace || !/\{(?:(?!\{).)*\}/.test(pattern)) {
        return [pattern];
      }
      return (0, brace_expansion_1.default)(pattern);
    };
    exports2.braceExpand = braceExpand;
    exports2.minimatch.braceExpand = exports2.braceExpand;
    var makeRe = (pattern, options = {}) => new Minimatch(pattern, options).makeRe();
    exports2.makeRe = makeRe;
    exports2.minimatch.makeRe = exports2.makeRe;
    var match = (list, pattern, options = {}) => {
      const mm = new Minimatch(pattern, options);
      list = list.filter((f) => mm.match(f));
      if (mm.options.nonull && !list.length) {
        list.push(pattern);
      }
      return list;
    };
    exports2.match = match;
    exports2.minimatch.match = exports2.match;
    var globMagic = /[?*]|[+@!]\(.*?\)|\[|\]/;
    var regExpEscape = (s) => s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
    var Minimatch = class {
      options;
      set;
      pattern;
      windowsPathsNoEscape;
      nonegate;
      negate;
      comment;
      empty;
      preserveMultipleSlashes;
      partial;
      globSet;
      globParts;
      nocase;
      isWindows;
      platform;
      windowsNoMagicRoot;
      regexp;
      constructor(pattern, options = {}) {
        (0, assert_valid_pattern_js_1.assertValidPattern)(pattern);
        options = options || {};
        this.options = options;
        this.pattern = pattern;
        this.platform = options.platform || defaultPlatform;
        this.isWindows = this.platform === "win32";
        this.windowsPathsNoEscape = !!options.windowsPathsNoEscape || options.allowWindowsEscape === false;
        if (this.windowsPathsNoEscape) {
          this.pattern = this.pattern.replace(/\\/g, "/");
        }
        this.preserveMultipleSlashes = !!options.preserveMultipleSlashes;
        this.regexp = null;
        this.negate = false;
        this.nonegate = !!options.nonegate;
        this.comment = false;
        this.empty = false;
        this.partial = !!options.partial;
        this.nocase = !!this.options.nocase;
        this.windowsNoMagicRoot = options.windowsNoMagicRoot !== void 0 ? options.windowsNoMagicRoot : !!(this.isWindows && this.nocase);
        this.globSet = [];
        this.globParts = [];
        this.set = [];
        this.make();
      }
      hasMagic() {
        if (this.options.magicalBraces && this.set.length > 1) {
          return true;
        }
        for (const pattern of this.set) {
          for (const part of pattern) {
            if (typeof part !== "string")
              return true;
          }
        }
        return false;
      }
      debug(..._) {
      }
      make() {
        const pattern = this.pattern;
        const options = this.options;
        if (!options.nocomment && pattern.charAt(0) === "#") {
          this.comment = true;
          return;
        }
        if (!pattern) {
          this.empty = true;
          return;
        }
        this.parseNegate();
        this.globSet = [...new Set(this.braceExpand())];
        if (options.debug) {
          this.debug = (...args) => console.error(...args);
        }
        this.debug(this.pattern, this.globSet);
        const rawGlobParts = this.globSet.map((s) => this.slashSplit(s));
        this.globParts = this.preprocess(rawGlobParts);
        this.debug(this.pattern, this.globParts);
        let set = this.globParts.map((s, _, __) => {
          if (this.isWindows && this.windowsNoMagicRoot) {
            const isUNC = s[0] === "" && s[1] === "" && (s[2] === "?" || !globMagic.test(s[2])) && !globMagic.test(s[3]);
            const isDrive = /^[a-z]:/i.test(s[0]);
            if (isUNC) {
              return [...s.slice(0, 4), ...s.slice(4).map((ss) => this.parse(ss))];
            } else if (isDrive) {
              return [s[0], ...s.slice(1).map((ss) => this.parse(ss))];
            }
          }
          return s.map((ss) => this.parse(ss));
        });
        this.debug(this.pattern, set);
        this.set = set.filter((s) => s.indexOf(false) === -1);
        if (this.isWindows) {
          for (let i = 0; i < this.set.length; i++) {
            const p = this.set[i];
            if (p[0] === "" && p[1] === "" && this.globParts[i][2] === "?" && typeof p[3] === "string" && /^[a-z]:$/i.test(p[3])) {
              p[2] = "?";
            }
          }
        }
        this.debug(this.pattern, this.set);
      }
      preprocess(globParts) {
        if (this.options.noglobstar) {
          for (let i = 0; i < globParts.length; i++) {
            for (let j = 0; j < globParts[i].length; j++) {
              if (globParts[i][j] === "**") {
                globParts[i][j] = "*";
              }
            }
          }
        }
        const { optimizationLevel = 1 } = this.options;
        if (optimizationLevel >= 2) {
          globParts = this.firstPhasePreProcess(globParts);
          globParts = this.secondPhasePreProcess(globParts);
        } else if (optimizationLevel >= 1) {
          globParts = this.levelOneOptimize(globParts);
        } else {
          globParts = this.adjascentGlobstarOptimize(globParts);
        }
        return globParts;
      }
      adjascentGlobstarOptimize(globParts) {
        return globParts.map((parts) => {
          let gs = -1;
          while (-1 !== (gs = parts.indexOf("**", gs + 1))) {
            let i = gs;
            while (parts[i + 1] === "**") {
              i++;
            }
            if (i !== gs) {
              parts.splice(gs, i - gs);
            }
          }
          return parts;
        });
      }
      levelOneOptimize(globParts) {
        return globParts.map((parts) => {
          parts = parts.reduce((set, part) => {
            const prev = set[set.length - 1];
            if (part === "**" && prev === "**") {
              return set;
            }
            if (part === "..") {
              if (prev && prev !== ".." && prev !== "." && prev !== "**") {
                set.pop();
                return set;
              }
            }
            set.push(part);
            return set;
          }, []);
          return parts.length === 0 ? [""] : parts;
        });
      }
      levelTwoFileOptimize(parts) {
        if (!Array.isArray(parts)) {
          parts = this.slashSplit(parts);
        }
        let didSomething = false;
        do {
          didSomething = false;
          if (!this.preserveMultipleSlashes) {
            for (let i = 1; i < parts.length - 1; i++) {
              const p = parts[i];
              if (i === 1 && p === "" && parts[0] === "")
                continue;
              if (p === "." || p === "") {
                didSomething = true;
                parts.splice(i, 1);
                i--;
              }
            }
            if (parts[0] === "." && parts.length === 2 && (parts[1] === "." || parts[1] === "")) {
              didSomething = true;
              parts.pop();
            }
          }
          let dd = 0;
          while (-1 !== (dd = parts.indexOf("..", dd + 1))) {
            const p = parts[dd - 1];
            if (p && p !== "." && p !== ".." && p !== "**") {
              didSomething = true;
              parts.splice(dd - 1, 2);
              dd -= 2;
            }
          }
        } while (didSomething);
        return parts.length === 0 ? [""] : parts;
      }
      firstPhasePreProcess(globParts) {
        let didSomething = false;
        do {
          didSomething = false;
          for (let parts of globParts) {
            let gs = -1;
            while (-1 !== (gs = parts.indexOf("**", gs + 1))) {
              let gss = gs;
              while (parts[gss + 1] === "**") {
                gss++;
              }
              if (gss > gs) {
                parts.splice(gs + 1, gss - gs);
              }
              let next = parts[gs + 1];
              const p = parts[gs + 2];
              const p2 = parts[gs + 3];
              if (next !== "..")
                continue;
              if (!p || p === "." || p === ".." || !p2 || p2 === "." || p2 === "..") {
                continue;
              }
              didSomething = true;
              parts.splice(gs, 1);
              const other = parts.slice(0);
              other[gs] = "**";
              globParts.push(other);
              gs--;
            }
            if (!this.preserveMultipleSlashes) {
              for (let i = 1; i < parts.length - 1; i++) {
                const p = parts[i];
                if (i === 1 && p === "" && parts[0] === "")
                  continue;
                if (p === "." || p === "") {
                  didSomething = true;
                  parts.splice(i, 1);
                  i--;
                }
              }
              if (parts[0] === "." && parts.length === 2 && (parts[1] === "." || parts[1] === "")) {
                didSomething = true;
                parts.pop();
              }
            }
            let dd = 0;
            while (-1 !== (dd = parts.indexOf("..", dd + 1))) {
              const p = parts[dd - 1];
              if (p && p !== "." && p !== ".." && p !== "**") {
                didSomething = true;
                const needDot = dd === 1 && parts[dd + 1] === "**";
                const splin = needDot ? ["."] : [];
                parts.splice(dd - 1, 2, ...splin);
                if (parts.length === 0)
                  parts.push("");
                dd -= 2;
              }
            }
          }
        } while (didSomething);
        return globParts;
      }
      secondPhasePreProcess(globParts) {
        for (let i = 0; i < globParts.length - 1; i++) {
          for (let j = i + 1; j < globParts.length; j++) {
            const matched = this.partsMatch(globParts[i], globParts[j], !this.preserveMultipleSlashes);
            if (!matched)
              continue;
            globParts[i] = matched;
            globParts[j] = [];
          }
        }
        return globParts.filter((gs) => gs.length);
      }
      partsMatch(a, b, emptyGSMatch = false) {
        let ai = 0;
        let bi = 0;
        let result = [];
        let which = "";
        while (ai < a.length && bi < b.length) {
          if (a[ai] === b[bi]) {
            result.push(which === "b" ? b[bi] : a[ai]);
            ai++;
            bi++;
          } else if (emptyGSMatch && a[ai] === "**" && b[bi] === a[ai + 1]) {
            result.push(a[ai]);
            ai++;
          } else if (emptyGSMatch && b[bi] === "**" && a[ai] === b[bi + 1]) {
            result.push(b[bi]);
            bi++;
          } else if (a[ai] === "*" && b[bi] && (this.options.dot || !b[bi].startsWith(".")) && b[bi] !== "**") {
            if (which === "b")
              return false;
            which = "a";
            result.push(a[ai]);
            ai++;
            bi++;
          } else if (b[bi] === "*" && a[ai] && (this.options.dot || !a[ai].startsWith(".")) && a[ai] !== "**") {
            if (which === "a")
              return false;
            which = "b";
            result.push(b[bi]);
            ai++;
            bi++;
          } else {
            return false;
          }
        }
        return a.length === b.length && result;
      }
      parseNegate() {
        if (this.nonegate)
          return;
        const pattern = this.pattern;
        let negate = false;
        let negateOffset = 0;
        for (let i = 0; i < pattern.length && pattern.charAt(i) === "!"; i++) {
          negate = !negate;
          negateOffset++;
        }
        if (negateOffset)
          this.pattern = pattern.slice(negateOffset);
        this.negate = negate;
      }
      matchOne(file, pattern, partial = false) {
        const options = this.options;
        if (this.isWindows) {
          const fileDrive = typeof file[0] === "string" && /^[a-z]:$/i.test(file[0]);
          const fileUNC = !fileDrive && file[0] === "" && file[1] === "" && file[2] === "?" && /^[a-z]:$/i.test(file[3]);
          const patternDrive = typeof pattern[0] === "string" && /^[a-z]:$/i.test(pattern[0]);
          const patternUNC = !patternDrive && pattern[0] === "" && pattern[1] === "" && pattern[2] === "?" && typeof pattern[3] === "string" && /^[a-z]:$/i.test(pattern[3]);
          const fdi = fileUNC ? 3 : fileDrive ? 0 : void 0;
          const pdi = patternUNC ? 3 : patternDrive ? 0 : void 0;
          if (typeof fdi === "number" && typeof pdi === "number") {
            const [fd, pd] = [file[fdi], pattern[pdi]];
            if (fd.toLowerCase() === pd.toLowerCase()) {
              pattern[pdi] = fd;
              if (pdi > fdi) {
                pattern = pattern.slice(pdi);
              } else if (fdi > pdi) {
                file = file.slice(fdi);
              }
            }
          }
        }
        const { optimizationLevel = 1 } = this.options;
        if (optimizationLevel >= 2) {
          file = this.levelTwoFileOptimize(file);
        }
        this.debug("matchOne", this, { file, pattern });
        this.debug("matchOne", file.length, pattern.length);
        for (var fi = 0, pi = 0, fl = file.length, pl = pattern.length; fi < fl && pi < pl; fi++, pi++) {
          this.debug("matchOne loop");
          var p = pattern[pi];
          var f = file[fi];
          this.debug(pattern, p, f);
          if (p === false) {
            return false;
          }
          if (p === exports2.GLOBSTAR) {
            this.debug("GLOBSTAR", [pattern, p, f]);
            var fr = fi;
            var pr = pi + 1;
            if (pr === pl) {
              this.debug("** at the end");
              for (; fi < fl; fi++) {
                if (file[fi] === "." || file[fi] === ".." || !options.dot && file[fi].charAt(0) === ".")
                  return false;
              }
              return true;
            }
            while (fr < fl) {
              var swallowee = file[fr];
              this.debug("\nglobstar while", file, fr, pattern, pr, swallowee);
              if (this.matchOne(file.slice(fr), pattern.slice(pr), partial)) {
                this.debug("globstar found match!", fr, fl, swallowee);
                return true;
              } else {
                if (swallowee === "." || swallowee === ".." || !options.dot && swallowee.charAt(0) === ".") {
                  this.debug("dot detected!", file, fr, pattern, pr);
                  break;
                }
                this.debug("globstar swallow a segment, and continue");
                fr++;
              }
            }
            if (partial) {
              this.debug("\n>>> no match, partial?", file, fr, pattern, pr);
              if (fr === fl) {
                return true;
              }
            }
            return false;
          }
          let hit;
          if (typeof p === "string") {
            hit = f === p;
            this.debug("string match", p, f, hit);
          } else {
            hit = p.test(f);
            this.debug("pattern match", p, f, hit);
          }
          if (!hit)
            return false;
        }
        if (fi === fl && pi === pl) {
          return true;
        } else if (fi === fl) {
          return partial;
        } else if (pi === pl) {
          return fi === fl - 1 && file[fi] === "";
        } else {
          throw new Error("wtf?");
        }
      }
      braceExpand() {
        return (0, exports2.braceExpand)(this.pattern, this.options);
      }
      parse(pattern) {
        (0, assert_valid_pattern_js_1.assertValidPattern)(pattern);
        const options = this.options;
        if (pattern === "**")
          return exports2.GLOBSTAR;
        if (pattern === "")
          return "";
        let m;
        let fastTest = null;
        if (m = pattern.match(starRE)) {
          fastTest = options.dot ? starTestDot : starTest;
        } else if (m = pattern.match(starDotExtRE)) {
          fastTest = (options.nocase ? options.dot ? starDotExtTestNocaseDot : starDotExtTestNocase : options.dot ? starDotExtTestDot : starDotExtTest)(m[1]);
        } else if (m = pattern.match(qmarksRE)) {
          fastTest = (options.nocase ? options.dot ? qmarksTestNocaseDot : qmarksTestNocase : options.dot ? qmarksTestDot : qmarksTest)(m);
        } else if (m = pattern.match(starDotStarRE)) {
          fastTest = options.dot ? starDotStarTestDot : starDotStarTest;
        } else if (m = pattern.match(dotStarRE)) {
          fastTest = dotStarTest;
        }
        const re = ast_js_1.AST.fromGlob(pattern, this.options).toMMPattern();
        if (fastTest && typeof re === "object") {
          Reflect.defineProperty(re, "test", { value: fastTest });
        }
        return re;
      }
      makeRe() {
        if (this.regexp || this.regexp === false)
          return this.regexp;
        const set = this.set;
        if (!set.length) {
          this.regexp = false;
          return this.regexp;
        }
        const options = this.options;
        const twoStar = options.noglobstar ? star : options.dot ? twoStarDot : twoStarNoDot;
        const flags = new Set(options.nocase ? ["i"] : []);
        let re = set.map((pattern) => {
          const pp = pattern.map((p) => {
            if (p instanceof RegExp) {
              for (const f of p.flags.split(""))
                flags.add(f);
            }
            return typeof p === "string" ? regExpEscape(p) : p === exports2.GLOBSTAR ? exports2.GLOBSTAR : p._src;
          });
          pp.forEach((p, i) => {
            const next = pp[i + 1];
            const prev = pp[i - 1];
            if (p !== exports2.GLOBSTAR || prev === exports2.GLOBSTAR) {
              return;
            }
            if (prev === void 0) {
              if (next !== void 0 && next !== exports2.GLOBSTAR) {
                pp[i + 1] = "(?:\\/|" + twoStar + "\\/)?" + next;
              } else {
                pp[i] = twoStar;
              }
            } else if (next === void 0) {
              pp[i - 1] = prev + "(?:\\/|" + twoStar + ")?";
            } else if (next !== exports2.GLOBSTAR) {
              pp[i - 1] = prev + "(?:\\/|\\/" + twoStar + "\\/)" + next;
              pp[i + 1] = exports2.GLOBSTAR;
            }
          });
          return pp.filter((p) => p !== exports2.GLOBSTAR).join("/");
        }).join("|");
        const [open, close] = set.length > 1 ? ["(?:", ")"] : ["", ""];
        re = "^" + open + re + close + "$";
        if (this.negate)
          re = "^(?!" + re + ").+$";
        try {
          this.regexp = new RegExp(re, [...flags].join(""));
        } catch (ex) {
          this.regexp = false;
        }
        return this.regexp;
      }
      slashSplit(p) {
        if (this.preserveMultipleSlashes) {
          return p.split("/");
        } else if (this.isWindows && /^\/\/[^\/]+/.test(p)) {
          return ["", ...p.split(/\/+/)];
        } else {
          return p.split(/\/+/);
        }
      }
      match(f, partial = this.partial) {
        this.debug("match", f, this.pattern);
        if (this.comment) {
          return false;
        }
        if (this.empty) {
          return f === "";
        }
        if (f === "/" && partial) {
          return true;
        }
        const options = this.options;
        if (this.isWindows) {
          f = f.split("\\").join("/");
        }
        const ff = this.slashSplit(f);
        this.debug(this.pattern, "split", ff);
        const set = this.set;
        this.debug(this.pattern, "set", set);
        let filename = ff[ff.length - 1];
        if (!filename) {
          for (let i = ff.length - 2; !filename && i >= 0; i--) {
            filename = ff[i];
          }
        }
        for (let i = 0; i < set.length; i++) {
          const pattern = set[i];
          let file = ff;
          if (options.matchBase && pattern.length === 1) {
            file = [filename];
          }
          const hit = this.matchOne(file, pattern, partial);
          if (hit) {
            if (options.flipNegate) {
              return true;
            }
            return !this.negate;
          }
        }
        if (options.flipNegate) {
          return false;
        }
        return this.negate;
      }
      static defaults(def) {
        return exports2.minimatch.defaults(def).Minimatch;
      }
    };
    exports2.Minimatch = Minimatch;
    var ast_js_2 = require_ast();
    Object.defineProperty(exports2, "AST", { enumerable: true, get: function() {
      return ast_js_2.AST;
    } });
    var escape_js_2 = require_escape2();
    Object.defineProperty(exports2, "escape", { enumerable: true, get: function() {
      return escape_js_2.escape;
    } });
    var unescape_js_2 = require_unescape();
    Object.defineProperty(exports2, "unescape", { enumerable: true, get: function() {
      return unescape_js_2.unescape;
    } });
    exports2.minimatch.AST = ast_js_1.AST;
    exports2.minimatch.Minimatch = Minimatch;
    exports2.minimatch.escape = escape_js_1.escape;
    exports2.minimatch.unescape = unescape_js_1.unescape;
  }
});

// node_modules/path-scurry/node_modules/lru-cache/dist/commonjs/index.js
var require_commonjs2 = __commonJS({
  "node_modules/path-scurry/node_modules/lru-cache/dist/commonjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.LRUCache = void 0;
    var perf = typeof performance === "object" && performance && typeof performance.now === "function" ? performance : Date;
    var warned = /* @__PURE__ */ new Set();
    var PROCESS = typeof process === "object" && !!process ? process : {};
    var emitWarning = (msg, type, code, fn) => {
      typeof PROCESS.emitWarning === "function" ? PROCESS.emitWarning(msg, type, code, fn) : console.error(`[${code}] ${type}: ${msg}`);
    };
    var AC = globalThis.AbortController;
    var AS = globalThis.AbortSignal;
    if (typeof AC === "undefined") {
      AS = class AbortSignal {
        onabort;
        _onabort = [];
        reason;
        aborted = false;
        addEventListener(_, fn) {
          this._onabort.push(fn);
        }
      };
      AC = class AbortController {
        constructor() {
          warnACPolyfill();
        }
        signal = new AS();
        abort(reason) {
          if (this.signal.aborted)
            return;
          this.signal.reason = reason;
          this.signal.aborted = true;
          for (const fn of this.signal._onabort) {
            fn(reason);
          }
          this.signal.onabort?.(reason);
        }
      };
      let printACPolyfillWarning = PROCESS.env?.LRU_CACHE_IGNORE_AC_WARNING !== "1";
      const warnACPolyfill = () => {
        if (!printACPolyfillWarning)
          return;
        printACPolyfillWarning = false;
        emitWarning("AbortController is not defined. If using lru-cache in node 14, load an AbortController polyfill from the `node-abort-controller` package. A minimal polyfill is provided for use by LRUCache.fetch(), but it should not be relied upon in other contexts (eg, passing it to other APIs that use AbortController/AbortSignal might have undesirable effects). You may disable this with LRU_CACHE_IGNORE_AC_WARNING=1 in the env.", "NO_ABORT_CONTROLLER", "ENOTSUP", warnACPolyfill);
      };
    }
    var shouldWarn = (code) => !warned.has(code);
    var TYPE = Symbol("type");
    var isPosInt = (n) => n && n === Math.floor(n) && n > 0 && isFinite(n);
    var getUintArray = (max) => !isPosInt(max) ? null : max <= Math.pow(2, 8) ? Uint8Array : max <= Math.pow(2, 16) ? Uint16Array : max <= Math.pow(2, 32) ? Uint32Array : max <= Number.MAX_SAFE_INTEGER ? ZeroArray : null;
    var ZeroArray = class extends Array {
      constructor(size) {
        super(size);
        this.fill(0);
      }
    };
    var _constructing;
    var _Stack = class {
      heap;
      length;
      static create(max) {
        const HeapCls = getUintArray(max);
        if (!HeapCls)
          return [];
        __privateSet(_Stack, _constructing, true);
        const s = new _Stack(max, HeapCls);
        __privateSet(_Stack, _constructing, false);
        return s;
      }
      constructor(max, HeapCls) {
        if (!__privateGet(_Stack, _constructing)) {
          throw new TypeError("instantiate Stack using Stack.create(n)");
        }
        this.heap = new HeapCls(max);
        this.length = 0;
      }
      push(n) {
        this.heap[this.length++] = n;
      }
      pop() {
        return this.heap[--this.length];
      }
    };
    var Stack = _Stack;
    _constructing = new WeakMap();
    __privateAdd(Stack, _constructing, false);
    var LRUCache = class {
      #max;
      #maxSize;
      #dispose;
      #disposeAfter;
      #fetchMethod;
      ttl;
      ttlResolution;
      ttlAutopurge;
      updateAgeOnGet;
      updateAgeOnHas;
      allowStale;
      noDisposeOnSet;
      noUpdateTTL;
      maxEntrySize;
      sizeCalculation;
      noDeleteOnFetchRejection;
      noDeleteOnStaleGet;
      allowStaleOnFetchAbort;
      allowStaleOnFetchRejection;
      ignoreFetchAbort;
      #size;
      #calculatedSize;
      #keyMap;
      #keyList;
      #valList;
      #next;
      #prev;
      #head;
      #tail;
      #free;
      #disposed;
      #sizes;
      #starts;
      #ttls;
      #hasDispose;
      #hasFetchMethod;
      #hasDisposeAfter;
      static unsafeExposeInternals(c) {
        return {
          starts: c.#starts,
          ttls: c.#ttls,
          sizes: c.#sizes,
          keyMap: c.#keyMap,
          keyList: c.#keyList,
          valList: c.#valList,
          next: c.#next,
          prev: c.#prev,
          get head() {
            return c.#head;
          },
          get tail() {
            return c.#tail;
          },
          free: c.#free,
          isBackgroundFetch: (p) => c.#isBackgroundFetch(p),
          backgroundFetch: (k, index, options, context) => c.#backgroundFetch(k, index, options, context),
          moveToTail: (index) => c.#moveToTail(index),
          indexes: (options) => c.#indexes(options),
          rindexes: (options) => c.#rindexes(options),
          isStale: (index) => c.#isStale(index)
        };
      }
      get max() {
        return this.#max;
      }
      get maxSize() {
        return this.#maxSize;
      }
      get calculatedSize() {
        return this.#calculatedSize;
      }
      get size() {
        return this.#size;
      }
      get fetchMethod() {
        return this.#fetchMethod;
      }
      get dispose() {
        return this.#dispose;
      }
      get disposeAfter() {
        return this.#disposeAfter;
      }
      constructor(options) {
        const { max = 0, ttl, ttlResolution = 1, ttlAutopurge, updateAgeOnGet, updateAgeOnHas, allowStale, dispose, disposeAfter, noDisposeOnSet, noUpdateTTL, maxSize = 0, maxEntrySize = 0, sizeCalculation, fetchMethod, noDeleteOnFetchRejection, noDeleteOnStaleGet, allowStaleOnFetchRejection, allowStaleOnFetchAbort, ignoreFetchAbort } = options;
        if (max !== 0 && !isPosInt(max)) {
          throw new TypeError("max option must be a nonnegative integer");
        }
        const UintArray = max ? getUintArray(max) : Array;
        if (!UintArray) {
          throw new Error("invalid max value: " + max);
        }
        this.#max = max;
        this.#maxSize = maxSize;
        this.maxEntrySize = maxEntrySize || this.#maxSize;
        this.sizeCalculation = sizeCalculation;
        if (this.sizeCalculation) {
          if (!this.#maxSize && !this.maxEntrySize) {
            throw new TypeError("cannot set sizeCalculation without setting maxSize or maxEntrySize");
          }
          if (typeof this.sizeCalculation !== "function") {
            throw new TypeError("sizeCalculation set to non-function");
          }
        }
        if (fetchMethod !== void 0 && typeof fetchMethod !== "function") {
          throw new TypeError("fetchMethod must be a function if specified");
        }
        this.#fetchMethod = fetchMethod;
        this.#hasFetchMethod = !!fetchMethod;
        this.#keyMap = /* @__PURE__ */ new Map();
        this.#keyList = new Array(max).fill(void 0);
        this.#valList = new Array(max).fill(void 0);
        this.#next = new UintArray(max);
        this.#prev = new UintArray(max);
        this.#head = 0;
        this.#tail = 0;
        this.#free = Stack.create(max);
        this.#size = 0;
        this.#calculatedSize = 0;
        if (typeof dispose === "function") {
          this.#dispose = dispose;
        }
        if (typeof disposeAfter === "function") {
          this.#disposeAfter = disposeAfter;
          this.#disposed = [];
        } else {
          this.#disposeAfter = void 0;
          this.#disposed = void 0;
        }
        this.#hasDispose = !!this.#dispose;
        this.#hasDisposeAfter = !!this.#disposeAfter;
        this.noDisposeOnSet = !!noDisposeOnSet;
        this.noUpdateTTL = !!noUpdateTTL;
        this.noDeleteOnFetchRejection = !!noDeleteOnFetchRejection;
        this.allowStaleOnFetchRejection = !!allowStaleOnFetchRejection;
        this.allowStaleOnFetchAbort = !!allowStaleOnFetchAbort;
        this.ignoreFetchAbort = !!ignoreFetchAbort;
        if (this.maxEntrySize !== 0) {
          if (this.#maxSize !== 0) {
            if (!isPosInt(this.#maxSize)) {
              throw new TypeError("maxSize must be a positive integer if specified");
            }
          }
          if (!isPosInt(this.maxEntrySize)) {
            throw new TypeError("maxEntrySize must be a positive integer if specified");
          }
          this.#initializeSizeTracking();
        }
        this.allowStale = !!allowStale;
        this.noDeleteOnStaleGet = !!noDeleteOnStaleGet;
        this.updateAgeOnGet = !!updateAgeOnGet;
        this.updateAgeOnHas = !!updateAgeOnHas;
        this.ttlResolution = isPosInt(ttlResolution) || ttlResolution === 0 ? ttlResolution : 1;
        this.ttlAutopurge = !!ttlAutopurge;
        this.ttl = ttl || 0;
        if (this.ttl) {
          if (!isPosInt(this.ttl)) {
            throw new TypeError("ttl must be a positive integer if specified");
          }
          this.#initializeTTLTracking();
        }
        if (this.#max === 0 && this.ttl === 0 && this.#maxSize === 0) {
          throw new TypeError("At least one of max, maxSize, or ttl is required");
        }
        if (!this.ttlAutopurge && !this.#max && !this.#maxSize) {
          const code = "LRU_CACHE_UNBOUNDED";
          if (shouldWarn(code)) {
            warned.add(code);
            const msg = "TTL caching without ttlAutopurge, max, or maxSize can result in unbounded memory consumption.";
            emitWarning(msg, "UnboundedCacheWarning", code, LRUCache);
          }
        }
      }
      getRemainingTTL(key) {
        return this.#keyMap.has(key) ? Infinity : 0;
      }
      #initializeTTLTracking() {
        const ttls = new ZeroArray(this.#max);
        const starts = new ZeroArray(this.#max);
        this.#ttls = ttls;
        this.#starts = starts;
        this.#setItemTTL = (index, ttl, start = perf.now()) => {
          starts[index] = ttl !== 0 ? start : 0;
          ttls[index] = ttl;
          if (ttl !== 0 && this.ttlAutopurge) {
            const t = setTimeout(() => {
              if (this.#isStale(index)) {
                this.delete(this.#keyList[index]);
              }
            }, ttl + 1);
            if (t.unref) {
              t.unref();
            }
          }
        };
        this.#updateItemAge = (index) => {
          starts[index] = ttls[index] !== 0 ? perf.now() : 0;
        };
        this.#statusTTL = (status, index) => {
          if (ttls[index]) {
            const ttl = ttls[index];
            const start = starts[index];
            if (!ttl || !start)
              return;
            status.ttl = ttl;
            status.start = start;
            status.now = cachedNow || getNow();
            const age = status.now - start;
            status.remainingTTL = ttl - age;
          }
        };
        let cachedNow = 0;
        const getNow = () => {
          const n = perf.now();
          if (this.ttlResolution > 0) {
            cachedNow = n;
            const t = setTimeout(() => cachedNow = 0, this.ttlResolution);
            if (t.unref) {
              t.unref();
            }
          }
          return n;
        };
        this.getRemainingTTL = (key) => {
          const index = this.#keyMap.get(key);
          if (index === void 0) {
            return 0;
          }
          const ttl = ttls[index];
          const start = starts[index];
          if (!ttl || !start) {
            return Infinity;
          }
          const age = (cachedNow || getNow()) - start;
          return ttl - age;
        };
        this.#isStale = (index) => {
          const s = starts[index];
          const t = ttls[index];
          return !!t && !!s && (cachedNow || getNow()) - s > t;
        };
      }
      #updateItemAge = () => {
      };
      #statusTTL = () => {
      };
      #setItemTTL = () => {
      };
      #isStale = () => false;
      #initializeSizeTracking() {
        const sizes = new ZeroArray(this.#max);
        this.#calculatedSize = 0;
        this.#sizes = sizes;
        this.#removeItemSize = (index) => {
          this.#calculatedSize -= sizes[index];
          sizes[index] = 0;
        };
        this.#requireSize = (k, v, size, sizeCalculation) => {
          if (this.#isBackgroundFetch(v)) {
            return 0;
          }
          if (!isPosInt(size)) {
            if (sizeCalculation) {
              if (typeof sizeCalculation !== "function") {
                throw new TypeError("sizeCalculation must be a function");
              }
              size = sizeCalculation(v, k);
              if (!isPosInt(size)) {
                throw new TypeError("sizeCalculation return invalid (expect positive integer)");
              }
            } else {
              throw new TypeError("invalid size value (must be positive integer). When maxSize or maxEntrySize is used, sizeCalculation or size must be set.");
            }
          }
          return size;
        };
        this.#addItemSize = (index, size, status) => {
          sizes[index] = size;
          if (this.#maxSize) {
            const maxSize = this.#maxSize - sizes[index];
            while (this.#calculatedSize > maxSize) {
              this.#evict(true);
            }
          }
          this.#calculatedSize += sizes[index];
          if (status) {
            status.entrySize = size;
            status.totalCalculatedSize = this.#calculatedSize;
          }
        };
      }
      #removeItemSize = (_i) => {
      };
      #addItemSize = (_i, _s, _st) => {
      };
      #requireSize = (_k, _v, size, sizeCalculation) => {
        if (size || sizeCalculation) {
          throw new TypeError("cannot set size without setting maxSize or maxEntrySize on cache");
        }
        return 0;
      };
      *#indexes({ allowStale = this.allowStale } = {}) {
        if (this.#size) {
          for (let i = this.#tail; true; ) {
            if (!this.#isValidIndex(i)) {
              break;
            }
            if (allowStale || !this.#isStale(i)) {
              yield i;
            }
            if (i === this.#head) {
              break;
            } else {
              i = this.#prev[i];
            }
          }
        }
      }
      *#rindexes({ allowStale = this.allowStale } = {}) {
        if (this.#size) {
          for (let i = this.#head; true; ) {
            if (!this.#isValidIndex(i)) {
              break;
            }
            if (allowStale || !this.#isStale(i)) {
              yield i;
            }
            if (i === this.#tail) {
              break;
            } else {
              i = this.#next[i];
            }
          }
        }
      }
      #isValidIndex(index) {
        return index !== void 0 && this.#keyMap.get(this.#keyList[index]) === index;
      }
      *entries() {
        for (const i of this.#indexes()) {
          if (this.#valList[i] !== void 0 && this.#keyList[i] !== void 0 && !this.#isBackgroundFetch(this.#valList[i])) {
            yield [this.#keyList[i], this.#valList[i]];
          }
        }
      }
      *rentries() {
        for (const i of this.#rindexes()) {
          if (this.#valList[i] !== void 0 && this.#keyList[i] !== void 0 && !this.#isBackgroundFetch(this.#valList[i])) {
            yield [this.#keyList[i], this.#valList[i]];
          }
        }
      }
      *keys() {
        for (const i of this.#indexes()) {
          const k = this.#keyList[i];
          if (k !== void 0 && !this.#isBackgroundFetch(this.#valList[i])) {
            yield k;
          }
        }
      }
      *rkeys() {
        for (const i of this.#rindexes()) {
          const k = this.#keyList[i];
          if (k !== void 0 && !this.#isBackgroundFetch(this.#valList[i])) {
            yield k;
          }
        }
      }
      *values() {
        for (const i of this.#indexes()) {
          const v = this.#valList[i];
          if (v !== void 0 && !this.#isBackgroundFetch(this.#valList[i])) {
            yield this.#valList[i];
          }
        }
      }
      *rvalues() {
        for (const i of this.#rindexes()) {
          const v = this.#valList[i];
          if (v !== void 0 && !this.#isBackgroundFetch(this.#valList[i])) {
            yield this.#valList[i];
          }
        }
      }
      [Symbol.iterator]() {
        return this.entries();
      }
      [Symbol.toStringTag] = "LRUCache";
      find(fn, getOptions = {}) {
        for (const i of this.#indexes()) {
          const v = this.#valList[i];
          const value = this.#isBackgroundFetch(v) ? v.__staleWhileFetching : v;
          if (value === void 0)
            continue;
          if (fn(value, this.#keyList[i], this)) {
            return this.get(this.#keyList[i], getOptions);
          }
        }
      }
      forEach(fn, thisp = this) {
        for (const i of this.#indexes()) {
          const v = this.#valList[i];
          const value = this.#isBackgroundFetch(v) ? v.__staleWhileFetching : v;
          if (value === void 0)
            continue;
          fn.call(thisp, value, this.#keyList[i], this);
        }
      }
      rforEach(fn, thisp = this) {
        for (const i of this.#rindexes()) {
          const v = this.#valList[i];
          const value = this.#isBackgroundFetch(v) ? v.__staleWhileFetching : v;
          if (value === void 0)
            continue;
          fn.call(thisp, value, this.#keyList[i], this);
        }
      }
      purgeStale() {
        let deleted = false;
        for (const i of this.#rindexes({ allowStale: true })) {
          if (this.#isStale(i)) {
            this.delete(this.#keyList[i]);
            deleted = true;
          }
        }
        return deleted;
      }
      info(key) {
        const i = this.#keyMap.get(key);
        if (i === void 0)
          return void 0;
        const v = this.#valList[i];
        const value = this.#isBackgroundFetch(v) ? v.__staleWhileFetching : v;
        if (value === void 0)
          return void 0;
        const entry = { value };
        if (this.#ttls && this.#starts) {
          const ttl = this.#ttls[i];
          const start = this.#starts[i];
          if (ttl && start) {
            const remain = ttl - (perf.now() - start);
            entry.ttl = remain;
            entry.start = Date.now();
          }
        }
        if (this.#sizes) {
          entry.size = this.#sizes[i];
        }
        return entry;
      }
      dump() {
        const arr = [];
        for (const i of this.#indexes({ allowStale: true })) {
          const key = this.#keyList[i];
          const v = this.#valList[i];
          const value = this.#isBackgroundFetch(v) ? v.__staleWhileFetching : v;
          if (value === void 0 || key === void 0)
            continue;
          const entry = { value };
          if (this.#ttls && this.#starts) {
            entry.ttl = this.#ttls[i];
            const age = perf.now() - this.#starts[i];
            entry.start = Math.floor(Date.now() - age);
          }
          if (this.#sizes) {
            entry.size = this.#sizes[i];
          }
          arr.unshift([key, entry]);
        }
        return arr;
      }
      load(arr) {
        this.clear();
        for (const [key, entry] of arr) {
          if (entry.start) {
            const age = Date.now() - entry.start;
            entry.start = perf.now() - age;
          }
          this.set(key, entry.value, entry);
        }
      }
      set(k, v, setOptions = {}) {
        if (v === void 0) {
          this.delete(k);
          return this;
        }
        const { ttl = this.ttl, start, noDisposeOnSet = this.noDisposeOnSet, sizeCalculation = this.sizeCalculation, status } = setOptions;
        let { noUpdateTTL = this.noUpdateTTL } = setOptions;
        const size = this.#requireSize(k, v, setOptions.size || 0, sizeCalculation);
        if (this.maxEntrySize && size > this.maxEntrySize) {
          if (status) {
            status.set = "miss";
            status.maxEntrySizeExceeded = true;
          }
          this.delete(k);
          return this;
        }
        let index = this.#size === 0 ? void 0 : this.#keyMap.get(k);
        if (index === void 0) {
          index = this.#size === 0 ? this.#tail : this.#free.length !== 0 ? this.#free.pop() : this.#size === this.#max ? this.#evict(false) : this.#size;
          this.#keyList[index] = k;
          this.#valList[index] = v;
          this.#keyMap.set(k, index);
          this.#next[this.#tail] = index;
          this.#prev[index] = this.#tail;
          this.#tail = index;
          this.#size++;
          this.#addItemSize(index, size, status);
          if (status)
            status.set = "add";
          noUpdateTTL = false;
        } else {
          this.#moveToTail(index);
          const oldVal = this.#valList[index];
          if (v !== oldVal) {
            if (this.#hasFetchMethod && this.#isBackgroundFetch(oldVal)) {
              oldVal.__abortController.abort(new Error("replaced"));
              const { __staleWhileFetching: s } = oldVal;
              if (s !== void 0 && !noDisposeOnSet) {
                if (this.#hasDispose) {
                  this.#dispose?.(s, k, "set");
                }
                if (this.#hasDisposeAfter) {
                  this.#disposed?.push([s, k, "set"]);
                }
              }
            } else if (!noDisposeOnSet) {
              if (this.#hasDispose) {
                this.#dispose?.(oldVal, k, "set");
              }
              if (this.#hasDisposeAfter) {
                this.#disposed?.push([oldVal, k, "set"]);
              }
            }
            this.#removeItemSize(index);
            this.#addItemSize(index, size, status);
            this.#valList[index] = v;
            if (status) {
              status.set = "replace";
              const oldValue = oldVal && this.#isBackgroundFetch(oldVal) ? oldVal.__staleWhileFetching : oldVal;
              if (oldValue !== void 0)
                status.oldValue = oldValue;
            }
          } else if (status) {
            status.set = "update";
          }
        }
        if (ttl !== 0 && !this.#ttls) {
          this.#initializeTTLTracking();
        }
        if (this.#ttls) {
          if (!noUpdateTTL) {
            this.#setItemTTL(index, ttl, start);
          }
          if (status)
            this.#statusTTL(status, index);
        }
        if (!noDisposeOnSet && this.#hasDisposeAfter && this.#disposed) {
          const dt = this.#disposed;
          let task;
          while (task = dt?.shift()) {
            this.#disposeAfter?.(...task);
          }
        }
        return this;
      }
      pop() {
        try {
          while (this.#size) {
            const val = this.#valList[this.#head];
            this.#evict(true);
            if (this.#isBackgroundFetch(val)) {
              if (val.__staleWhileFetching) {
                return val.__staleWhileFetching;
              }
            } else if (val !== void 0) {
              return val;
            }
          }
        } finally {
          if (this.#hasDisposeAfter && this.#disposed) {
            const dt = this.#disposed;
            let task;
            while (task = dt?.shift()) {
              this.#disposeAfter?.(...task);
            }
          }
        }
      }
      #evict(free) {
        const head = this.#head;
        const k = this.#keyList[head];
        const v = this.#valList[head];
        if (this.#hasFetchMethod && this.#isBackgroundFetch(v)) {
          v.__abortController.abort(new Error("evicted"));
        } else if (this.#hasDispose || this.#hasDisposeAfter) {
          if (this.#hasDispose) {
            this.#dispose?.(v, k, "evict");
          }
          if (this.#hasDisposeAfter) {
            this.#disposed?.push([v, k, "evict"]);
          }
        }
        this.#removeItemSize(head);
        if (free) {
          this.#keyList[head] = void 0;
          this.#valList[head] = void 0;
          this.#free.push(head);
        }
        if (this.#size === 1) {
          this.#head = this.#tail = 0;
          this.#free.length = 0;
        } else {
          this.#head = this.#next[head];
        }
        this.#keyMap.delete(k);
        this.#size--;
        return head;
      }
      has(k, hasOptions = {}) {
        const { updateAgeOnHas = this.updateAgeOnHas, status } = hasOptions;
        const index = this.#keyMap.get(k);
        if (index !== void 0) {
          const v = this.#valList[index];
          if (this.#isBackgroundFetch(v) && v.__staleWhileFetching === void 0) {
            return false;
          }
          if (!this.#isStale(index)) {
            if (updateAgeOnHas) {
              this.#updateItemAge(index);
            }
            if (status) {
              status.has = "hit";
              this.#statusTTL(status, index);
            }
            return true;
          } else if (status) {
            status.has = "stale";
            this.#statusTTL(status, index);
          }
        } else if (status) {
          status.has = "miss";
        }
        return false;
      }
      peek(k, peekOptions = {}) {
        const { allowStale = this.allowStale } = peekOptions;
        const index = this.#keyMap.get(k);
        if (index === void 0 || !allowStale && this.#isStale(index)) {
          return;
        }
        const v = this.#valList[index];
        return this.#isBackgroundFetch(v) ? v.__staleWhileFetching : v;
      }
      #backgroundFetch(k, index, options, context) {
        const v = index === void 0 ? void 0 : this.#valList[index];
        if (this.#isBackgroundFetch(v)) {
          return v;
        }
        const ac = new AC();
        const { signal } = options;
        signal?.addEventListener("abort", () => ac.abort(signal.reason), {
          signal: ac.signal
        });
        const fetchOpts = {
          signal: ac.signal,
          options,
          context
        };
        const cb = (v2, updateCache = false) => {
          const { aborted } = ac.signal;
          const ignoreAbort = options.ignoreFetchAbort && v2 !== void 0;
          if (options.status) {
            if (aborted && !updateCache) {
              options.status.fetchAborted = true;
              options.status.fetchError = ac.signal.reason;
              if (ignoreAbort)
                options.status.fetchAbortIgnored = true;
            } else {
              options.status.fetchResolved = true;
            }
          }
          if (aborted && !ignoreAbort && !updateCache) {
            return fetchFail(ac.signal.reason);
          }
          const bf2 = p;
          if (this.#valList[index] === p) {
            if (v2 === void 0) {
              if (bf2.__staleWhileFetching) {
                this.#valList[index] = bf2.__staleWhileFetching;
              } else {
                this.delete(k);
              }
            } else {
              if (options.status)
                options.status.fetchUpdated = true;
              this.set(k, v2, fetchOpts.options);
            }
          }
          return v2;
        };
        const eb = (er) => {
          if (options.status) {
            options.status.fetchRejected = true;
            options.status.fetchError = er;
          }
          return fetchFail(er);
        };
        const fetchFail = (er) => {
          const { aborted } = ac.signal;
          const allowStaleAborted = aborted && options.allowStaleOnFetchAbort;
          const allowStale = allowStaleAborted || options.allowStaleOnFetchRejection;
          const noDelete = allowStale || options.noDeleteOnFetchRejection;
          const bf2 = p;
          if (this.#valList[index] === p) {
            const del = !noDelete || bf2.__staleWhileFetching === void 0;
            if (del) {
              this.delete(k);
            } else if (!allowStaleAborted) {
              this.#valList[index] = bf2.__staleWhileFetching;
            }
          }
          if (allowStale) {
            if (options.status && bf2.__staleWhileFetching !== void 0) {
              options.status.returnedStale = true;
            }
            return bf2.__staleWhileFetching;
          } else if (bf2.__returned === bf2) {
            throw er;
          }
        };
        const pcall = (res, rej) => {
          const fmp = this.#fetchMethod?.(k, v, fetchOpts);
          if (fmp && fmp instanceof Promise) {
            fmp.then((v2) => res(v2 === void 0 ? void 0 : v2), rej);
          }
          ac.signal.addEventListener("abort", () => {
            if (!options.ignoreFetchAbort || options.allowStaleOnFetchAbort) {
              res(void 0);
              if (options.allowStaleOnFetchAbort) {
                res = (v2) => cb(v2, true);
              }
            }
          });
        };
        if (options.status)
          options.status.fetchDispatched = true;
        const p = new Promise(pcall).then(cb, eb);
        const bf = Object.assign(p, {
          __abortController: ac,
          __staleWhileFetching: v,
          __returned: void 0
        });
        if (index === void 0) {
          this.set(k, bf, { ...fetchOpts.options, status: void 0 });
          index = this.#keyMap.get(k);
        } else {
          this.#valList[index] = bf;
        }
        return bf;
      }
      #isBackgroundFetch(p) {
        if (!this.#hasFetchMethod)
          return false;
        const b = p;
        return !!b && b instanceof Promise && b.hasOwnProperty("__staleWhileFetching") && b.__abortController instanceof AC;
      }
      async fetch(k, fetchOptions = {}) {
        const {
          allowStale = this.allowStale,
          updateAgeOnGet = this.updateAgeOnGet,
          noDeleteOnStaleGet = this.noDeleteOnStaleGet,
          ttl = this.ttl,
          noDisposeOnSet = this.noDisposeOnSet,
          size = 0,
          sizeCalculation = this.sizeCalculation,
          noUpdateTTL = this.noUpdateTTL,
          noDeleteOnFetchRejection = this.noDeleteOnFetchRejection,
          allowStaleOnFetchRejection = this.allowStaleOnFetchRejection,
          ignoreFetchAbort = this.ignoreFetchAbort,
          allowStaleOnFetchAbort = this.allowStaleOnFetchAbort,
          context,
          forceRefresh = false,
          status,
          signal
        } = fetchOptions;
        if (!this.#hasFetchMethod) {
          if (status)
            status.fetch = "get";
          return this.get(k, {
            allowStale,
            updateAgeOnGet,
            noDeleteOnStaleGet,
            status
          });
        }
        const options = {
          allowStale,
          updateAgeOnGet,
          noDeleteOnStaleGet,
          ttl,
          noDisposeOnSet,
          size,
          sizeCalculation,
          noUpdateTTL,
          noDeleteOnFetchRejection,
          allowStaleOnFetchRejection,
          allowStaleOnFetchAbort,
          ignoreFetchAbort,
          status,
          signal
        };
        let index = this.#keyMap.get(k);
        if (index === void 0) {
          if (status)
            status.fetch = "miss";
          const p = this.#backgroundFetch(k, index, options, context);
          return p.__returned = p;
        } else {
          const v = this.#valList[index];
          if (this.#isBackgroundFetch(v)) {
            const stale = allowStale && v.__staleWhileFetching !== void 0;
            if (status) {
              status.fetch = "inflight";
              if (stale)
                status.returnedStale = true;
            }
            return stale ? v.__staleWhileFetching : v.__returned = v;
          }
          const isStale = this.#isStale(index);
          if (!forceRefresh && !isStale) {
            if (status)
              status.fetch = "hit";
            this.#moveToTail(index);
            if (updateAgeOnGet) {
              this.#updateItemAge(index);
            }
            if (status)
              this.#statusTTL(status, index);
            return v;
          }
          const p = this.#backgroundFetch(k, index, options, context);
          const hasStale = p.__staleWhileFetching !== void 0;
          const staleVal = hasStale && allowStale;
          if (status) {
            status.fetch = isStale ? "stale" : "refresh";
            if (staleVal && isStale)
              status.returnedStale = true;
          }
          return staleVal ? p.__staleWhileFetching : p.__returned = p;
        }
      }
      get(k, getOptions = {}) {
        const { allowStale = this.allowStale, updateAgeOnGet = this.updateAgeOnGet, noDeleteOnStaleGet = this.noDeleteOnStaleGet, status } = getOptions;
        const index = this.#keyMap.get(k);
        if (index !== void 0) {
          const value = this.#valList[index];
          const fetching = this.#isBackgroundFetch(value);
          if (status)
            this.#statusTTL(status, index);
          if (this.#isStale(index)) {
            if (status)
              status.get = "stale";
            if (!fetching) {
              if (!noDeleteOnStaleGet) {
                this.delete(k);
              }
              if (status && allowStale)
                status.returnedStale = true;
              return allowStale ? value : void 0;
            } else {
              if (status && allowStale && value.__staleWhileFetching !== void 0) {
                status.returnedStale = true;
              }
              return allowStale ? value.__staleWhileFetching : void 0;
            }
          } else {
            if (status)
              status.get = "hit";
            if (fetching) {
              return value.__staleWhileFetching;
            }
            this.#moveToTail(index);
            if (updateAgeOnGet) {
              this.#updateItemAge(index);
            }
            return value;
          }
        } else if (status) {
          status.get = "miss";
        }
      }
      #connect(p, n) {
        this.#prev[n] = p;
        this.#next[p] = n;
      }
      #moveToTail(index) {
        if (index !== this.#tail) {
          if (index === this.#head) {
            this.#head = this.#next[index];
          } else {
            this.#connect(this.#prev[index], this.#next[index]);
          }
          this.#connect(this.#tail, index);
          this.#tail = index;
        }
      }
      delete(k) {
        let deleted = false;
        if (this.#size !== 0) {
          const index = this.#keyMap.get(k);
          if (index !== void 0) {
            deleted = true;
            if (this.#size === 1) {
              this.clear();
            } else {
              this.#removeItemSize(index);
              const v = this.#valList[index];
              if (this.#isBackgroundFetch(v)) {
                v.__abortController.abort(new Error("deleted"));
              } else if (this.#hasDispose || this.#hasDisposeAfter) {
                if (this.#hasDispose) {
                  this.#dispose?.(v, k, "delete");
                }
                if (this.#hasDisposeAfter) {
                  this.#disposed?.push([v, k, "delete"]);
                }
              }
              this.#keyMap.delete(k);
              this.#keyList[index] = void 0;
              this.#valList[index] = void 0;
              if (index === this.#tail) {
                this.#tail = this.#prev[index];
              } else if (index === this.#head) {
                this.#head = this.#next[index];
              } else {
                const pi = this.#prev[index];
                this.#next[pi] = this.#next[index];
                const ni = this.#next[index];
                this.#prev[ni] = this.#prev[index];
              }
              this.#size--;
              this.#free.push(index);
            }
          }
        }
        if (this.#hasDisposeAfter && this.#disposed?.length) {
          const dt = this.#disposed;
          let task;
          while (task = dt?.shift()) {
            this.#disposeAfter?.(...task);
          }
        }
        return deleted;
      }
      clear() {
        for (const index of this.#rindexes({ allowStale: true })) {
          const v = this.#valList[index];
          if (this.#isBackgroundFetch(v)) {
            v.__abortController.abort(new Error("deleted"));
          } else {
            const k = this.#keyList[index];
            if (this.#hasDispose) {
              this.#dispose?.(v, k, "delete");
            }
            if (this.#hasDisposeAfter) {
              this.#disposed?.push([v, k, "delete"]);
            }
          }
        }
        this.#keyMap.clear();
        this.#valList.fill(void 0);
        this.#keyList.fill(void 0);
        if (this.#ttls && this.#starts) {
          this.#ttls.fill(0);
          this.#starts.fill(0);
        }
        if (this.#sizes) {
          this.#sizes.fill(0);
        }
        this.#head = 0;
        this.#tail = 0;
        this.#free.length = 0;
        this.#calculatedSize = 0;
        this.#size = 0;
        if (this.#hasDisposeAfter && this.#disposed) {
          const dt = this.#disposed;
          let task;
          while (task = dt?.shift()) {
            this.#disposeAfter?.(...task);
          }
        }
      }
    };
    exports2.LRUCache = LRUCache;
  }
});

// node_modules/minipass/dist/commonjs/index.js
var require_commonjs3 = __commonJS({
  "node_modules/minipass/dist/commonjs/index.js"(exports2) {
    "use strict";
    var __importDefault = exports2 && exports2.__importDefault || function(mod) {
      return mod && mod.__esModule ? mod : { "default": mod };
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Minipass = exports2.isWritable = exports2.isReadable = exports2.isStream = void 0;
    var proc = typeof process === "object" && process ? process : {
      stdout: null,
      stderr: null
    };
    var events_1 = require("events");
    var stream_1 = __importDefault(require("stream"));
    var string_decoder_1 = require("string_decoder");
    var isStream2 = (s) => !!s && typeof s === "object" && (s instanceof Minipass || s instanceof stream_1.default || (0, exports2.isReadable)(s) || (0, exports2.isWritable)(s));
    exports2.isStream = isStream2;
    var isReadable = (s) => !!s && typeof s === "object" && s instanceof events_1.EventEmitter && typeof s.pipe === "function" && s.pipe !== stream_1.default.Writable.prototype.pipe;
    exports2.isReadable = isReadable;
    var isWritable = (s) => !!s && typeof s === "object" && s instanceof events_1.EventEmitter && typeof s.write === "function" && typeof s.end === "function";
    exports2.isWritable = isWritable;
    var EOF = Symbol("EOF");
    var MAYBE_EMIT_END = Symbol("maybeEmitEnd");
    var EMITTED_END = Symbol("emittedEnd");
    var EMITTING_END = Symbol("emittingEnd");
    var EMITTED_ERROR = Symbol("emittedError");
    var CLOSED = Symbol("closed");
    var READ = Symbol("read");
    var FLUSH = Symbol("flush");
    var FLUSHCHUNK = Symbol("flushChunk");
    var ENCODING = Symbol("encoding");
    var DECODER = Symbol("decoder");
    var FLOWING = Symbol("flowing");
    var PAUSED = Symbol("paused");
    var RESUME = Symbol("resume");
    var BUFFER = Symbol("buffer");
    var PIPES = Symbol("pipes");
    var BUFFERLENGTH = Symbol("bufferLength");
    var BUFFERPUSH = Symbol("bufferPush");
    var BUFFERSHIFT = Symbol("bufferShift");
    var OBJECTMODE = Symbol("objectMode");
    var DESTROYED = Symbol("destroyed");
    var ERROR = Symbol("error");
    var EMITDATA = Symbol("emitData");
    var EMITEND = Symbol("emitEnd");
    var EMITEND2 = Symbol("emitEnd2");
    var ASYNC = Symbol("async");
    var ABORT = Symbol("abort");
    var ABORTED = Symbol("aborted");
    var SIGNAL = Symbol("signal");
    var DATALISTENERS = Symbol("dataListeners");
    var DISCARDED = Symbol("discarded");
    var defer = (fn) => Promise.resolve().then(fn);
    var nodefer = (fn) => fn();
    var isEndish = (ev) => ev === "end" || ev === "finish" || ev === "prefinish";
    var isArrayBufferLike = (b) => b instanceof ArrayBuffer || !!b && typeof b === "object" && b.constructor && b.constructor.name === "ArrayBuffer" && b.byteLength >= 0;
    var isArrayBufferView = (b) => !Buffer.isBuffer(b) && ArrayBuffer.isView(b);
    var Pipe = class {
      src;
      dest;
      opts;
      ondrain;
      constructor(src, dest, opts) {
        this.src = src;
        this.dest = dest;
        this.opts = opts;
        this.ondrain = () => src[RESUME]();
        this.dest.on("drain", this.ondrain);
      }
      unpipe() {
        this.dest.removeListener("drain", this.ondrain);
      }
      proxyErrors(_er) {
      }
      end() {
        this.unpipe();
        if (this.opts.end)
          this.dest.end();
      }
    };
    var PipeProxyErrors = class extends Pipe {
      unpipe() {
        this.src.removeListener("error", this.proxyErrors);
        super.unpipe();
      }
      constructor(src, dest, opts) {
        super(src, dest, opts);
        this.proxyErrors = (er) => dest.emit("error", er);
        src.on("error", this.proxyErrors);
      }
    };
    var isObjectModeOptions = (o) => !!o.objectMode;
    var isEncodingOptions = (o) => !o.objectMode && !!o.encoding && o.encoding !== "buffer";
    var Minipass = class extends events_1.EventEmitter {
      [FLOWING] = false;
      [PAUSED] = false;
      [PIPES] = [];
      [BUFFER] = [];
      [OBJECTMODE];
      [ENCODING];
      [ASYNC];
      [DECODER];
      [EOF] = false;
      [EMITTED_END] = false;
      [EMITTING_END] = false;
      [CLOSED] = false;
      [EMITTED_ERROR] = null;
      [BUFFERLENGTH] = 0;
      [DESTROYED] = false;
      [SIGNAL];
      [ABORTED] = false;
      [DATALISTENERS] = 0;
      [DISCARDED] = false;
      writable = true;
      readable = true;
      constructor(...args) {
        const options = args[0] || {};
        super();
        if (options.objectMode && typeof options.encoding === "string") {
          throw new TypeError("Encoding and objectMode may not be used together");
        }
        if (isObjectModeOptions(options)) {
          this[OBJECTMODE] = true;
          this[ENCODING] = null;
        } else if (isEncodingOptions(options)) {
          this[ENCODING] = options.encoding;
          this[OBJECTMODE] = false;
        } else {
          this[OBJECTMODE] = false;
          this[ENCODING] = null;
        }
        this[ASYNC] = !!options.async;
        this[DECODER] = this[ENCODING] ? new string_decoder_1.StringDecoder(this[ENCODING]) : null;
        if (options && options.debugExposeBuffer === true) {
          Object.defineProperty(this, "buffer", { get: () => this[BUFFER] });
        }
        if (options && options.debugExposePipes === true) {
          Object.defineProperty(this, "pipes", { get: () => this[PIPES] });
        }
        const { signal } = options;
        if (signal) {
          this[SIGNAL] = signal;
          if (signal.aborted) {
            this[ABORT]();
          } else {
            signal.addEventListener("abort", () => this[ABORT]());
          }
        }
      }
      get bufferLength() {
        return this[BUFFERLENGTH];
      }
      get encoding() {
        return this[ENCODING];
      }
      set encoding(_enc) {
        throw new Error("Encoding must be set at instantiation time");
      }
      setEncoding(_enc) {
        throw new Error("Encoding must be set at instantiation time");
      }
      get objectMode() {
        return this[OBJECTMODE];
      }
      set objectMode(_om) {
        throw new Error("objectMode must be set at instantiation time");
      }
      get ["async"]() {
        return this[ASYNC];
      }
      set ["async"](a) {
        this[ASYNC] = this[ASYNC] || !!a;
      }
      [ABORT]() {
        this[ABORTED] = true;
        this.emit("abort", this[SIGNAL]?.reason);
        this.destroy(this[SIGNAL]?.reason);
      }
      get aborted() {
        return this[ABORTED];
      }
      set aborted(_) {
      }
      write(chunk, encoding, cb) {
        if (this[ABORTED])
          return false;
        if (this[EOF])
          throw new Error("write after end");
        if (this[DESTROYED]) {
          this.emit("error", Object.assign(new Error("Cannot call write after a stream was destroyed"), { code: "ERR_STREAM_DESTROYED" }));
          return true;
        }
        if (typeof encoding === "function") {
          cb = encoding;
          encoding = "utf8";
        }
        if (!encoding)
          encoding = "utf8";
        const fn = this[ASYNC] ? defer : nodefer;
        if (!this[OBJECTMODE] && !Buffer.isBuffer(chunk)) {
          if (isArrayBufferView(chunk)) {
            chunk = Buffer.from(chunk.buffer, chunk.byteOffset, chunk.byteLength);
          } else if (isArrayBufferLike(chunk)) {
            chunk = Buffer.from(chunk);
          } else if (typeof chunk !== "string") {
            throw new Error("Non-contiguous data written to non-objectMode stream");
          }
        }
        if (this[OBJECTMODE]) {
          if (this[FLOWING] && this[BUFFERLENGTH] !== 0)
            this[FLUSH](true);
          if (this[FLOWING])
            this.emit("data", chunk);
          else
            this[BUFFERPUSH](chunk);
          if (this[BUFFERLENGTH] !== 0)
            this.emit("readable");
          if (cb)
            fn(cb);
          return this[FLOWING];
        }
        if (!chunk.length) {
          if (this[BUFFERLENGTH] !== 0)
            this.emit("readable");
          if (cb)
            fn(cb);
          return this[FLOWING];
        }
        if (typeof chunk === "string" && !(encoding === this[ENCODING] && !this[DECODER]?.lastNeed)) {
          chunk = Buffer.from(chunk, encoding);
        }
        if (Buffer.isBuffer(chunk) && this[ENCODING]) {
          chunk = this[DECODER].write(chunk);
        }
        if (this[FLOWING] && this[BUFFERLENGTH] !== 0)
          this[FLUSH](true);
        if (this[FLOWING])
          this.emit("data", chunk);
        else
          this[BUFFERPUSH](chunk);
        if (this[BUFFERLENGTH] !== 0)
          this.emit("readable");
        if (cb)
          fn(cb);
        return this[FLOWING];
      }
      read(n) {
        if (this[DESTROYED])
          return null;
        this[DISCARDED] = false;
        if (this[BUFFERLENGTH] === 0 || n === 0 || n && n > this[BUFFERLENGTH]) {
          this[MAYBE_EMIT_END]();
          return null;
        }
        if (this[OBJECTMODE])
          n = null;
        if (this[BUFFER].length > 1 && !this[OBJECTMODE]) {
          this[BUFFER] = [
            this[ENCODING] ? this[BUFFER].join("") : Buffer.concat(this[BUFFER], this[BUFFERLENGTH])
          ];
        }
        const ret = this[READ](n || null, this[BUFFER][0]);
        this[MAYBE_EMIT_END]();
        return ret;
      }
      [READ](n, chunk) {
        if (this[OBJECTMODE])
          this[BUFFERSHIFT]();
        else {
          const c = chunk;
          if (n === c.length || n === null)
            this[BUFFERSHIFT]();
          else if (typeof c === "string") {
            this[BUFFER][0] = c.slice(n);
            chunk = c.slice(0, n);
            this[BUFFERLENGTH] -= n;
          } else {
            this[BUFFER][0] = c.subarray(n);
            chunk = c.subarray(0, n);
            this[BUFFERLENGTH] -= n;
          }
        }
        this.emit("data", chunk);
        if (!this[BUFFER].length && !this[EOF])
          this.emit("drain");
        return chunk;
      }
      end(chunk, encoding, cb) {
        if (typeof chunk === "function") {
          cb = chunk;
          chunk = void 0;
        }
        if (typeof encoding === "function") {
          cb = encoding;
          encoding = "utf8";
        }
        if (chunk !== void 0)
          this.write(chunk, encoding);
        if (cb)
          this.once("end", cb);
        this[EOF] = true;
        this.writable = false;
        if (this[FLOWING] || !this[PAUSED])
          this[MAYBE_EMIT_END]();
        return this;
      }
      [RESUME]() {
        if (this[DESTROYED])
          return;
        if (!this[DATALISTENERS] && !this[PIPES].length) {
          this[DISCARDED] = true;
        }
        this[PAUSED] = false;
        this[FLOWING] = true;
        this.emit("resume");
        if (this[BUFFER].length)
          this[FLUSH]();
        else if (this[EOF])
          this[MAYBE_EMIT_END]();
        else
          this.emit("drain");
      }
      resume() {
        return this[RESUME]();
      }
      pause() {
        this[FLOWING] = false;
        this[PAUSED] = true;
        this[DISCARDED] = false;
      }
      get destroyed() {
        return this[DESTROYED];
      }
      get flowing() {
        return this[FLOWING];
      }
      get paused() {
        return this[PAUSED];
      }
      [BUFFERPUSH](chunk) {
        if (this[OBJECTMODE])
          this[BUFFERLENGTH] += 1;
        else
          this[BUFFERLENGTH] += chunk.length;
        this[BUFFER].push(chunk);
      }
      [BUFFERSHIFT]() {
        if (this[OBJECTMODE])
          this[BUFFERLENGTH] -= 1;
        else
          this[BUFFERLENGTH] -= this[BUFFER][0].length;
        return this[BUFFER].shift();
      }
      [FLUSH](noDrain = false) {
        do {
        } while (this[FLUSHCHUNK](this[BUFFERSHIFT]()) && this[BUFFER].length);
        if (!noDrain && !this[BUFFER].length && !this[EOF])
          this.emit("drain");
      }
      [FLUSHCHUNK](chunk) {
        this.emit("data", chunk);
        return this[FLOWING];
      }
      pipe(dest, opts) {
        if (this[DESTROYED])
          return dest;
        this[DISCARDED] = false;
        const ended = this[EMITTED_END];
        opts = opts || {};
        if (dest === proc.stdout || dest === proc.stderr)
          opts.end = false;
        else
          opts.end = opts.end !== false;
        opts.proxyErrors = !!opts.proxyErrors;
        if (ended) {
          if (opts.end)
            dest.end();
        } else {
          this[PIPES].push(!opts.proxyErrors ? new Pipe(this, dest, opts) : new PipeProxyErrors(this, dest, opts));
          if (this[ASYNC])
            defer(() => this[RESUME]());
          else
            this[RESUME]();
        }
        return dest;
      }
      unpipe(dest) {
        const p = this[PIPES].find((p2) => p2.dest === dest);
        if (p) {
          if (this[PIPES].length === 1) {
            if (this[FLOWING] && this[DATALISTENERS] === 0) {
              this[FLOWING] = false;
            }
            this[PIPES] = [];
          } else
            this[PIPES].splice(this[PIPES].indexOf(p), 1);
          p.unpipe();
        }
      }
      addListener(ev, handler) {
        return this.on(ev, handler);
      }
      on(ev, handler) {
        const ret = super.on(ev, handler);
        if (ev === "data") {
          this[DISCARDED] = false;
          this[DATALISTENERS]++;
          if (!this[PIPES].length && !this[FLOWING]) {
            this[RESUME]();
          }
        } else if (ev === "readable" && this[BUFFERLENGTH] !== 0) {
          super.emit("readable");
        } else if (isEndish(ev) && this[EMITTED_END]) {
          super.emit(ev);
          this.removeAllListeners(ev);
        } else if (ev === "error" && this[EMITTED_ERROR]) {
          const h = handler;
          if (this[ASYNC])
            defer(() => h.call(this, this[EMITTED_ERROR]));
          else
            h.call(this, this[EMITTED_ERROR]);
        }
        return ret;
      }
      removeListener(ev, handler) {
        return this.off(ev, handler);
      }
      off(ev, handler) {
        const ret = super.off(ev, handler);
        if (ev === "data") {
          this[DATALISTENERS] = this.listeners("data").length;
          if (this[DATALISTENERS] === 0 && !this[DISCARDED] && !this[PIPES].length) {
            this[FLOWING] = false;
          }
        }
        return ret;
      }
      removeAllListeners(ev) {
        const ret = super.removeAllListeners(ev);
        if (ev === "data" || ev === void 0) {
          this[DATALISTENERS] = 0;
          if (!this[DISCARDED] && !this[PIPES].length) {
            this[FLOWING] = false;
          }
        }
        return ret;
      }
      get emittedEnd() {
        return this[EMITTED_END];
      }
      [MAYBE_EMIT_END]() {
        if (!this[EMITTING_END] && !this[EMITTED_END] && !this[DESTROYED] && this[BUFFER].length === 0 && this[EOF]) {
          this[EMITTING_END] = true;
          this.emit("end");
          this.emit("prefinish");
          this.emit("finish");
          if (this[CLOSED])
            this.emit("close");
          this[EMITTING_END] = false;
        }
      }
      emit(ev, ...args) {
        const data = args[0];
        if (ev !== "error" && ev !== "close" && ev !== DESTROYED && this[DESTROYED]) {
          return false;
        } else if (ev === "data") {
          return !this[OBJECTMODE] && !data ? false : this[ASYNC] ? (defer(() => this[EMITDATA](data)), true) : this[EMITDATA](data);
        } else if (ev === "end") {
          return this[EMITEND]();
        } else if (ev === "close") {
          this[CLOSED] = true;
          if (!this[EMITTED_END] && !this[DESTROYED])
            return false;
          const ret2 = super.emit("close");
          this.removeAllListeners("close");
          return ret2;
        } else if (ev === "error") {
          this[EMITTED_ERROR] = data;
          super.emit(ERROR, data);
          const ret2 = !this[SIGNAL] || this.listeners("error").length ? super.emit("error", data) : false;
          this[MAYBE_EMIT_END]();
          return ret2;
        } else if (ev === "resume") {
          const ret2 = super.emit("resume");
          this[MAYBE_EMIT_END]();
          return ret2;
        } else if (ev === "finish" || ev === "prefinish") {
          const ret2 = super.emit(ev);
          this.removeAllListeners(ev);
          return ret2;
        }
        const ret = super.emit(ev, ...args);
        this[MAYBE_EMIT_END]();
        return ret;
      }
      [EMITDATA](data) {
        for (const p of this[PIPES]) {
          if (p.dest.write(data) === false)
            this.pause();
        }
        const ret = this[DISCARDED] ? false : super.emit("data", data);
        this[MAYBE_EMIT_END]();
        return ret;
      }
      [EMITEND]() {
        if (this[EMITTED_END])
          return false;
        this[EMITTED_END] = true;
        this.readable = false;
        return this[ASYNC] ? (defer(() => this[EMITEND2]()), true) : this[EMITEND2]();
      }
      [EMITEND2]() {
        if (this[DECODER]) {
          const data = this[DECODER].end();
          if (data) {
            for (const p of this[PIPES]) {
              p.dest.write(data);
            }
            if (!this[DISCARDED])
              super.emit("data", data);
          }
        }
        for (const p of this[PIPES]) {
          p.end();
        }
        const ret = super.emit("end");
        this.removeAllListeners("end");
        return ret;
      }
      async collect() {
        const buf = Object.assign([], {
          dataLength: 0
        });
        if (!this[OBJECTMODE])
          buf.dataLength = 0;
        const p = this.promise();
        this.on("data", (c) => {
          buf.push(c);
          if (!this[OBJECTMODE])
            buf.dataLength += c.length;
        });
        await p;
        return buf;
      }
      async concat() {
        if (this[OBJECTMODE]) {
          throw new Error("cannot concat in objectMode");
        }
        const buf = await this.collect();
        return this[ENCODING] ? buf.join("") : Buffer.concat(buf, buf.dataLength);
      }
      async promise() {
        return new Promise((resolve, reject) => {
          this.on(DESTROYED, () => reject(new Error("stream destroyed")));
          this.on("error", (er) => reject(er));
          this.on("end", () => resolve());
        });
      }
      [Symbol.asyncIterator]() {
        this[DISCARDED] = false;
        let stopped = false;
        const stop = async () => {
          this.pause();
          stopped = true;
          return { value: void 0, done: true };
        };
        const next = () => {
          if (stopped)
            return stop();
          const res = this.read();
          if (res !== null)
            return Promise.resolve({ done: false, value: res });
          if (this[EOF])
            return stop();
          let resolve;
          let reject;
          const onerr = (er) => {
            this.off("data", ondata);
            this.off("end", onend);
            this.off(DESTROYED, ondestroy);
            stop();
            reject(er);
          };
          const ondata = (value) => {
            this.off("error", onerr);
            this.off("end", onend);
            this.off(DESTROYED, ondestroy);
            this.pause();
            resolve({ value, done: !!this[EOF] });
          };
          const onend = () => {
            this.off("error", onerr);
            this.off("data", ondata);
            this.off(DESTROYED, ondestroy);
            stop();
            resolve({ done: true, value: void 0 });
          };
          const ondestroy = () => onerr(new Error("stream destroyed"));
          return new Promise((res2, rej) => {
            reject = rej;
            resolve = res2;
            this.once(DESTROYED, ondestroy);
            this.once("error", onerr);
            this.once("end", onend);
            this.once("data", ondata);
          });
        };
        return {
          next,
          throw: stop,
          return: stop,
          [Symbol.asyncIterator]() {
            return this;
          }
        };
      }
      [Symbol.iterator]() {
        this[DISCARDED] = false;
        let stopped = false;
        const stop = () => {
          this.pause();
          this.off(ERROR, stop);
          this.off(DESTROYED, stop);
          this.off("end", stop);
          stopped = true;
          return { done: true, value: void 0 };
        };
        const next = () => {
          if (stopped)
            return stop();
          const value = this.read();
          return value === null ? stop() : { done: false, value };
        };
        this.once("end", stop);
        this.once(ERROR, stop);
        this.once(DESTROYED, stop);
        return {
          next,
          throw: stop,
          return: stop,
          [Symbol.iterator]() {
            return this;
          }
        };
      }
      destroy(er) {
        if (this[DESTROYED]) {
          if (er)
            this.emit("error", er);
          else
            this.emit(DESTROYED);
          return this;
        }
        this[DESTROYED] = true;
        this[DISCARDED] = true;
        this[BUFFER].length = 0;
        this[BUFFERLENGTH] = 0;
        const wc = this;
        if (typeof wc.close === "function" && !this[CLOSED])
          wc.close();
        if (er)
          this.emit("error", er);
        else
          this.emit(DESTROYED);
        return this;
      }
      static get isStream() {
        return exports2.isStream;
      }
    };
    exports2.Minipass = Minipass;
  }
});

// node_modules/path-scurry/dist/commonjs/index.js
var require_commonjs4 = __commonJS({
  "node_modules/path-scurry/dist/commonjs/index.js"(exports2) {
    "use strict";
    var __createBinding = exports2 && exports2.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      var desc = Object.getOwnPropertyDescriptor(m, k);
      if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() {
          return m[k];
        } };
      }
      Object.defineProperty(o, k2, desc);
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __setModuleDefault = exports2 && exports2.__setModuleDefault || (Object.create ? function(o, v) {
      Object.defineProperty(o, "default", { enumerable: true, value: v });
    } : function(o, v) {
      o["default"] = v;
    });
    var __importStar = exports2 && exports2.__importStar || function(mod) {
      if (mod && mod.__esModule)
        return mod;
      var result = {};
      if (mod != null) {
        for (var k in mod)
          if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
            __createBinding(result, mod, k);
      }
      __setModuleDefault(result, mod);
      return result;
    };
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.PathScurry = exports2.Path = exports2.PathScurryDarwin = exports2.PathScurryPosix = exports2.PathScurryWin32 = exports2.PathScurryBase = exports2.PathPosix = exports2.PathWin32 = exports2.PathBase = exports2.ChildrenCache = exports2.ResolveCache = void 0;
    var lru_cache_1 = require_commonjs2();
    var path_1 = require("path");
    var url_1 = require("url");
    var actualFS = __importStar(require("fs"));
    var fs_1 = require("fs");
    var realpathSync = fs_1.realpathSync.native;
    var promises_1 = require("fs/promises");
    var minipass_1 = require_commonjs3();
    var defaultFS = {
      lstatSync: fs_1.lstatSync,
      readdir: fs_1.readdir,
      readdirSync: fs_1.readdirSync,
      readlinkSync: fs_1.readlinkSync,
      realpathSync,
      promises: {
        lstat: promises_1.lstat,
        readdir: promises_1.readdir,
        readlink: promises_1.readlink,
        realpath: promises_1.realpath
      }
    };
    var fsFromOption = (fsOption) => !fsOption || fsOption === defaultFS || fsOption === actualFS ? defaultFS : {
      ...defaultFS,
      ...fsOption,
      promises: {
        ...defaultFS.promises,
        ...fsOption.promises || {}
      }
    };
    var uncDriveRegexp = /^\\\\\?\\([a-z]:)\\?$/i;
    var uncToDrive = (rootPath) => rootPath.replace(/\//g, "\\").replace(uncDriveRegexp, "$1\\");
    var eitherSep = /[\\\/]/;
    var UNKNOWN = 0;
    var IFIFO = 1;
    var IFCHR = 2;
    var IFDIR = 4;
    var IFBLK = 6;
    var IFREG = 8;
    var IFLNK = 10;
    var IFSOCK = 12;
    var IFMT = 15;
    var IFMT_UNKNOWN = ~IFMT;
    var READDIR_CALLED = 16;
    var LSTAT_CALLED = 32;
    var ENOTDIR = 64;
    var ENOENT = 128;
    var ENOREADLINK = 256;
    var ENOREALPATH = 512;
    var ENOCHILD = ENOTDIR | ENOENT | ENOREALPATH;
    var TYPEMASK = 1023;
    var entToType = (s) => s.isFile() ? IFREG : s.isDirectory() ? IFDIR : s.isSymbolicLink() ? IFLNK : s.isCharacterDevice() ? IFCHR : s.isBlockDevice() ? IFBLK : s.isSocket() ? IFSOCK : s.isFIFO() ? IFIFO : UNKNOWN;
    var normalizeCache = /* @__PURE__ */ new Map();
    var normalize = (s) => {
      const c = normalizeCache.get(s);
      if (c)
        return c;
      const n = s.normalize("NFKD");
      normalizeCache.set(s, n);
      return n;
    };
    var normalizeNocaseCache = /* @__PURE__ */ new Map();
    var normalizeNocase = (s) => {
      const c = normalizeNocaseCache.get(s);
      if (c)
        return c;
      const n = normalize(s.toLowerCase());
      normalizeNocaseCache.set(s, n);
      return n;
    };
    var ResolveCache = class extends lru_cache_1.LRUCache {
      constructor() {
        super({ max: 256 });
      }
    };
    exports2.ResolveCache = ResolveCache;
    var ChildrenCache = class extends lru_cache_1.LRUCache {
      constructor(maxSize = 16 * 1024) {
        super({
          maxSize,
          sizeCalculation: (a) => a.length + 1
        });
      }
    };
    exports2.ChildrenCache = ChildrenCache;
    var setAsCwd = Symbol("PathScurry setAsCwd");
    var PathBase = class {
      name;
      root;
      roots;
      parent;
      nocase;
      #fs;
      #dev;
      get dev() {
        return this.#dev;
      }
      #mode;
      get mode() {
        return this.#mode;
      }
      #nlink;
      get nlink() {
        return this.#nlink;
      }
      #uid;
      get uid() {
        return this.#uid;
      }
      #gid;
      get gid() {
        return this.#gid;
      }
      #rdev;
      get rdev() {
        return this.#rdev;
      }
      #blksize;
      get blksize() {
        return this.#blksize;
      }
      #ino;
      get ino() {
        return this.#ino;
      }
      #size;
      get size() {
        return this.#size;
      }
      #blocks;
      get blocks() {
        return this.#blocks;
      }
      #atimeMs;
      get atimeMs() {
        return this.#atimeMs;
      }
      #mtimeMs;
      get mtimeMs() {
        return this.#mtimeMs;
      }
      #ctimeMs;
      get ctimeMs() {
        return this.#ctimeMs;
      }
      #birthtimeMs;
      get birthtimeMs() {
        return this.#birthtimeMs;
      }
      #atime;
      get atime() {
        return this.#atime;
      }
      #mtime;
      get mtime() {
        return this.#mtime;
      }
      #ctime;
      get ctime() {
        return this.#ctime;
      }
      #birthtime;
      get birthtime() {
        return this.#birthtime;
      }
      #matchName;
      #depth;
      #fullpath;
      #fullpathPosix;
      #relative;
      #relativePosix;
      #type;
      #children;
      #linkTarget;
      #realpath;
      get path() {
        return (this.parent || this).fullpath();
      }
      constructor(name, type = UNKNOWN, root, roots, nocase, children, opts) {
        this.name = name;
        this.#matchName = nocase ? normalizeNocase(name) : normalize(name);
        this.#type = type & TYPEMASK;
        this.nocase = nocase;
        this.roots = roots;
        this.root = root || this;
        this.#children = children;
        this.#fullpath = opts.fullpath;
        this.#relative = opts.relative;
        this.#relativePosix = opts.relativePosix;
        this.parent = opts.parent;
        if (this.parent) {
          this.#fs = this.parent.#fs;
        } else {
          this.#fs = fsFromOption(opts.fs);
        }
      }
      depth() {
        if (this.#depth !== void 0)
          return this.#depth;
        if (!this.parent)
          return this.#depth = 0;
        return this.#depth = this.parent.depth() + 1;
      }
      childrenCache() {
        return this.#children;
      }
      resolve(path3) {
        if (!path3) {
          return this;
        }
        const rootPath = this.getRootString(path3);
        const dir = path3.substring(rootPath.length);
        const dirParts = dir.split(this.splitSep);
        const result = rootPath ? this.getRoot(rootPath).#resolveParts(dirParts) : this.#resolveParts(dirParts);
        return result;
      }
      #resolveParts(dirParts) {
        let p = this;
        for (const part of dirParts) {
          p = p.child(part);
        }
        return p;
      }
      children() {
        const cached = this.#children.get(this);
        if (cached) {
          return cached;
        }
        const children = Object.assign([], { provisional: 0 });
        this.#children.set(this, children);
        this.#type &= ~READDIR_CALLED;
        return children;
      }
      child(pathPart, opts) {
        if (pathPart === "" || pathPart === ".") {
          return this;
        }
        if (pathPart === "..") {
          return this.parent || this;
        }
        const children = this.children();
        const name = this.nocase ? normalizeNocase(pathPart) : normalize(pathPart);
        for (const p of children) {
          if (p.#matchName === name) {
            return p;
          }
        }
        const s = this.parent ? this.sep : "";
        const fullpath = this.#fullpath ? this.#fullpath + s + pathPart : void 0;
        const pchild = this.newChild(pathPart, UNKNOWN, {
          ...opts,
          parent: this,
          fullpath
        });
        if (!this.canReaddir()) {
          pchild.#type |= ENOENT;
        }
        children.push(pchild);
        return pchild;
      }
      relative() {
        if (this.#relative !== void 0) {
          return this.#relative;
        }
        const name = this.name;
        const p = this.parent;
        if (!p) {
          return this.#relative = this.name;
        }
        const pv = p.relative();
        return pv + (!pv || !p.parent ? "" : this.sep) + name;
      }
      relativePosix() {
        if (this.sep === "/")
          return this.relative();
        if (this.#relativePosix !== void 0)
          return this.#relativePosix;
        const name = this.name;
        const p = this.parent;
        if (!p) {
          return this.#relativePosix = this.fullpathPosix();
        }
        const pv = p.relativePosix();
        return pv + (!pv || !p.parent ? "" : "/") + name;
      }
      fullpath() {
        if (this.#fullpath !== void 0) {
          return this.#fullpath;
        }
        const name = this.name;
        const p = this.parent;
        if (!p) {
          return this.#fullpath = this.name;
        }
        const pv = p.fullpath();
        const fp = pv + (!p.parent ? "" : this.sep) + name;
        return this.#fullpath = fp;
      }
      fullpathPosix() {
        if (this.#fullpathPosix !== void 0)
          return this.#fullpathPosix;
        if (this.sep === "/")
          return this.#fullpathPosix = this.fullpath();
        if (!this.parent) {
          const p2 = this.fullpath().replace(/\\/g, "/");
          if (/^[a-z]:\//i.test(p2)) {
            return this.#fullpathPosix = `//?/${p2}`;
          } else {
            return this.#fullpathPosix = p2;
          }
        }
        const p = this.parent;
        const pfpp = p.fullpathPosix();
        const fpp = pfpp + (!pfpp || !p.parent ? "" : "/") + this.name;
        return this.#fullpathPosix = fpp;
      }
      isUnknown() {
        return (this.#type & IFMT) === UNKNOWN;
      }
      isType(type) {
        return this[`is${type}`]();
      }
      getType() {
        return this.isUnknown() ? "Unknown" : this.isDirectory() ? "Directory" : this.isFile() ? "File" : this.isSymbolicLink() ? "SymbolicLink" : this.isFIFO() ? "FIFO" : this.isCharacterDevice() ? "CharacterDevice" : this.isBlockDevice() ? "BlockDevice" : this.isSocket() ? "Socket" : "Unknown";
      }
      isFile() {
        return (this.#type & IFMT) === IFREG;
      }
      isDirectory() {
        return (this.#type & IFMT) === IFDIR;
      }
      isCharacterDevice() {
        return (this.#type & IFMT) === IFCHR;
      }
      isBlockDevice() {
        return (this.#type & IFMT) === IFBLK;
      }
      isFIFO() {
        return (this.#type & IFMT) === IFIFO;
      }
      isSocket() {
        return (this.#type & IFMT) === IFSOCK;
      }
      isSymbolicLink() {
        return (this.#type & IFLNK) === IFLNK;
      }
      lstatCached() {
        return this.#type & LSTAT_CALLED ? this : void 0;
      }
      readlinkCached() {
        return this.#linkTarget;
      }
      realpathCached() {
        return this.#realpath;
      }
      readdirCached() {
        const children = this.children();
        return children.slice(0, children.provisional);
      }
      canReadlink() {
        if (this.#linkTarget)
          return true;
        if (!this.parent)
          return false;
        const ifmt = this.#type & IFMT;
        return !(ifmt !== UNKNOWN && ifmt !== IFLNK || this.#type & ENOREADLINK || this.#type & ENOENT);
      }
      calledReaddir() {
        return !!(this.#type & READDIR_CALLED);
      }
      isENOENT() {
        return !!(this.#type & ENOENT);
      }
      isNamed(n) {
        return !this.nocase ? this.#matchName === normalize(n) : this.#matchName === normalizeNocase(n);
      }
      async readlink() {
        const target = this.#linkTarget;
        if (target) {
          return target;
        }
        if (!this.canReadlink()) {
          return void 0;
        }
        if (!this.parent) {
          return void 0;
        }
        try {
          const read = await this.#fs.promises.readlink(this.fullpath());
          const linkTarget = (await this.parent.realpath())?.resolve(read);
          if (linkTarget) {
            return this.#linkTarget = linkTarget;
          }
        } catch (er) {
          this.#readlinkFail(er.code);
          return void 0;
        }
      }
      readlinkSync() {
        const target = this.#linkTarget;
        if (target) {
          return target;
        }
        if (!this.canReadlink()) {
          return void 0;
        }
        if (!this.parent) {
          return void 0;
        }
        try {
          const read = this.#fs.readlinkSync(this.fullpath());
          const linkTarget = this.parent.realpathSync()?.resolve(read);
          if (linkTarget) {
            return this.#linkTarget = linkTarget;
          }
        } catch (er) {
          this.#readlinkFail(er.code);
          return void 0;
        }
      }
      #readdirSuccess(children) {
        this.#type |= READDIR_CALLED;
        for (let p = children.provisional; p < children.length; p++) {
          const c = children[p];
          if (c)
            c.#markENOENT();
        }
      }
      #markENOENT() {
        if (this.#type & ENOENT)
          return;
        this.#type = (this.#type | ENOENT) & IFMT_UNKNOWN;
        this.#markChildrenENOENT();
      }
      #markChildrenENOENT() {
        const children = this.children();
        children.provisional = 0;
        for (const p of children) {
          p.#markENOENT();
        }
      }
      #markENOREALPATH() {
        this.#type |= ENOREALPATH;
        this.#markENOTDIR();
      }
      #markENOTDIR() {
        if (this.#type & ENOTDIR)
          return;
        let t = this.#type;
        if ((t & IFMT) === IFDIR)
          t &= IFMT_UNKNOWN;
        this.#type = t | ENOTDIR;
        this.#markChildrenENOENT();
      }
      #readdirFail(code = "") {
        if (code === "ENOTDIR" || code === "EPERM") {
          this.#markENOTDIR();
        } else if (code === "ENOENT") {
          this.#markENOENT();
        } else {
          this.children().provisional = 0;
        }
      }
      #lstatFail(code = "") {
        if (code === "ENOTDIR") {
          const p = this.parent;
          p.#markENOTDIR();
        } else if (code === "ENOENT") {
          this.#markENOENT();
        }
      }
      #readlinkFail(code = "") {
        let ter = this.#type;
        ter |= ENOREADLINK;
        if (code === "ENOENT")
          ter |= ENOENT;
        if (code === "EINVAL" || code === "UNKNOWN") {
          ter &= IFMT_UNKNOWN;
        }
        this.#type = ter;
        if (code === "ENOTDIR" && this.parent) {
          this.parent.#markENOTDIR();
        }
      }
      #readdirAddChild(e, c) {
        return this.#readdirMaybePromoteChild(e, c) || this.#readdirAddNewChild(e, c);
      }
      #readdirAddNewChild(e, c) {
        const type = entToType(e);
        const child = this.newChild(e.name, type, { parent: this });
        const ifmt = child.#type & IFMT;
        if (ifmt !== IFDIR && ifmt !== IFLNK && ifmt !== UNKNOWN) {
          child.#type |= ENOTDIR;
        }
        c.unshift(child);
        c.provisional++;
        return child;
      }
      #readdirMaybePromoteChild(e, c) {
        for (let p = c.provisional; p < c.length; p++) {
          const pchild = c[p];
          const name = this.nocase ? normalizeNocase(e.name) : normalize(e.name);
          if (name !== pchild.#matchName) {
            continue;
          }
          return this.#readdirPromoteChild(e, pchild, p, c);
        }
      }
      #readdirPromoteChild(e, p, index, c) {
        const v = p.name;
        p.#type = p.#type & IFMT_UNKNOWN | entToType(e);
        if (v !== e.name)
          p.name = e.name;
        if (index !== c.provisional) {
          if (index === c.length - 1)
            c.pop();
          else
            c.splice(index, 1);
          c.unshift(p);
        }
        c.provisional++;
        return p;
      }
      async lstat() {
        if ((this.#type & ENOENT) === 0) {
          try {
            this.#applyStat(await this.#fs.promises.lstat(this.fullpath()));
            return this;
          } catch (er) {
            this.#lstatFail(er.code);
          }
        }
      }
      lstatSync() {
        if ((this.#type & ENOENT) === 0) {
          try {
            this.#applyStat(this.#fs.lstatSync(this.fullpath()));
            return this;
          } catch (er) {
            this.#lstatFail(er.code);
          }
        }
      }
      #applyStat(st) {
        const { atime, atimeMs, birthtime, birthtimeMs, blksize, blocks, ctime, ctimeMs, dev, gid, ino, mode, mtime, mtimeMs, nlink, rdev, size, uid } = st;
        this.#atime = atime;
        this.#atimeMs = atimeMs;
        this.#birthtime = birthtime;
        this.#birthtimeMs = birthtimeMs;
        this.#blksize = blksize;
        this.#blocks = blocks;
        this.#ctime = ctime;
        this.#ctimeMs = ctimeMs;
        this.#dev = dev;
        this.#gid = gid;
        this.#ino = ino;
        this.#mode = mode;
        this.#mtime = mtime;
        this.#mtimeMs = mtimeMs;
        this.#nlink = nlink;
        this.#rdev = rdev;
        this.#size = size;
        this.#uid = uid;
        const ifmt = entToType(st);
        this.#type = this.#type & IFMT_UNKNOWN | ifmt | LSTAT_CALLED;
        if (ifmt !== UNKNOWN && ifmt !== IFDIR && ifmt !== IFLNK) {
          this.#type |= ENOTDIR;
        }
      }
      #onReaddirCB = [];
      #readdirCBInFlight = false;
      #callOnReaddirCB(children) {
        this.#readdirCBInFlight = false;
        const cbs = this.#onReaddirCB.slice();
        this.#onReaddirCB.length = 0;
        cbs.forEach((cb) => cb(null, children));
      }
      readdirCB(cb, allowZalgo = false) {
        if (!this.canReaddir()) {
          if (allowZalgo)
            cb(null, []);
          else
            queueMicrotask(() => cb(null, []));
          return;
        }
        const children = this.children();
        if (this.calledReaddir()) {
          const c = children.slice(0, children.provisional);
          if (allowZalgo)
            cb(null, c);
          else
            queueMicrotask(() => cb(null, c));
          return;
        }
        this.#onReaddirCB.push(cb);
        if (this.#readdirCBInFlight) {
          return;
        }
        this.#readdirCBInFlight = true;
        const fullpath = this.fullpath();
        this.#fs.readdir(fullpath, { withFileTypes: true }, (er, entries) => {
          if (er) {
            this.#readdirFail(er.code);
            children.provisional = 0;
          } else {
            for (const e of entries) {
              this.#readdirAddChild(e, children);
            }
            this.#readdirSuccess(children);
          }
          this.#callOnReaddirCB(children.slice(0, children.provisional));
          return;
        });
      }
      #asyncReaddirInFlight;
      async readdir() {
        if (!this.canReaddir()) {
          return [];
        }
        const children = this.children();
        if (this.calledReaddir()) {
          return children.slice(0, children.provisional);
        }
        const fullpath = this.fullpath();
        if (this.#asyncReaddirInFlight) {
          await this.#asyncReaddirInFlight;
        } else {
          let resolve = () => {
          };
          this.#asyncReaddirInFlight = new Promise((res) => resolve = res);
          try {
            for (const e of await this.#fs.promises.readdir(fullpath, {
              withFileTypes: true
            })) {
              this.#readdirAddChild(e, children);
            }
            this.#readdirSuccess(children);
          } catch (er) {
            this.#readdirFail(er.code);
            children.provisional = 0;
          }
          this.#asyncReaddirInFlight = void 0;
          resolve();
        }
        return children.slice(0, children.provisional);
      }
      readdirSync() {
        if (!this.canReaddir()) {
          return [];
        }
        const children = this.children();
        if (this.calledReaddir()) {
          return children.slice(0, children.provisional);
        }
        const fullpath = this.fullpath();
        try {
          for (const e of this.#fs.readdirSync(fullpath, {
            withFileTypes: true
          })) {
            this.#readdirAddChild(e, children);
          }
          this.#readdirSuccess(children);
        } catch (er) {
          this.#readdirFail(er.code);
          children.provisional = 0;
        }
        return children.slice(0, children.provisional);
      }
      canReaddir() {
        if (this.#type & ENOCHILD)
          return false;
        const ifmt = IFMT & this.#type;
        if (!(ifmt === UNKNOWN || ifmt === IFDIR || ifmt === IFLNK)) {
          return false;
        }
        return true;
      }
      shouldWalk(dirs, walkFilter) {
        return (this.#type & IFDIR) === IFDIR && !(this.#type & ENOCHILD) && !dirs.has(this) && (!walkFilter || walkFilter(this));
      }
      async realpath() {
        if (this.#realpath)
          return this.#realpath;
        if ((ENOREALPATH | ENOREADLINK | ENOENT) & this.#type)
          return void 0;
        try {
          const rp = await this.#fs.promises.realpath(this.fullpath());
          return this.#realpath = this.resolve(rp);
        } catch (_) {
          this.#markENOREALPATH();
        }
      }
      realpathSync() {
        if (this.#realpath)
          return this.#realpath;
        if ((ENOREALPATH | ENOREADLINK | ENOENT) & this.#type)
          return void 0;
        try {
          const rp = this.#fs.realpathSync(this.fullpath());
          return this.#realpath = this.resolve(rp);
        } catch (_) {
          this.#markENOREALPATH();
        }
      }
      [setAsCwd](oldCwd) {
        if (oldCwd === this)
          return;
        const changed = /* @__PURE__ */ new Set([]);
        let rp = [];
        let p = this;
        while (p && p.parent) {
          changed.add(p);
          p.#relative = rp.join(this.sep);
          p.#relativePosix = rp.join("/");
          p = p.parent;
          rp.push("..");
        }
        p = oldCwd;
        while (p && p.parent && !changed.has(p)) {
          p.#relative = void 0;
          p.#relativePosix = void 0;
          p = p.parent;
        }
      }
    };
    exports2.PathBase = PathBase;
    var PathWin32 = class extends PathBase {
      sep = "\\";
      splitSep = eitherSep;
      constructor(name, type = UNKNOWN, root, roots, nocase, children, opts) {
        super(name, type, root, roots, nocase, children, opts);
      }
      newChild(name, type = UNKNOWN, opts = {}) {
        return new PathWin32(name, type, this.root, this.roots, this.nocase, this.childrenCache(), opts);
      }
      getRootString(path3) {
        return path_1.win32.parse(path3).root;
      }
      getRoot(rootPath) {
        rootPath = uncToDrive(rootPath.toUpperCase());
        if (rootPath === this.root.name) {
          return this.root;
        }
        for (const [compare, root] of Object.entries(this.roots)) {
          if (this.sameRoot(rootPath, compare)) {
            return this.roots[rootPath] = root;
          }
        }
        return this.roots[rootPath] = new PathScurryWin32(rootPath, this).root;
      }
      sameRoot(rootPath, compare = this.root.name) {
        rootPath = rootPath.toUpperCase().replace(/\//g, "\\").replace(uncDriveRegexp, "$1\\");
        return rootPath === compare;
      }
    };
    exports2.PathWin32 = PathWin32;
    var PathPosix = class extends PathBase {
      splitSep = "/";
      sep = "/";
      constructor(name, type = UNKNOWN, root, roots, nocase, children, opts) {
        super(name, type, root, roots, nocase, children, opts);
      }
      getRootString(path3) {
        return path3.startsWith("/") ? "/" : "";
      }
      getRoot(_rootPath) {
        return this.root;
      }
      newChild(name, type = UNKNOWN, opts = {}) {
        return new PathPosix(name, type, this.root, this.roots, this.nocase, this.childrenCache(), opts);
      }
    };
    exports2.PathPosix = PathPosix;
    var PathScurryBase = class {
      root;
      rootPath;
      roots;
      cwd;
      #resolveCache;
      #resolvePosixCache;
      #children;
      nocase;
      #fs;
      constructor(cwd = process.cwd(), pathImpl, sep, { nocase, childrenCacheSize = 16 * 1024, fs = defaultFS } = {}) {
        this.#fs = fsFromOption(fs);
        if (cwd instanceof URL || cwd.startsWith("file://")) {
          cwd = (0, url_1.fileURLToPath)(cwd);
        }
        const cwdPath = pathImpl.resolve(cwd);
        this.roots = /* @__PURE__ */ Object.create(null);
        this.rootPath = this.parseRootPath(cwdPath);
        this.#resolveCache = new ResolveCache();
        this.#resolvePosixCache = new ResolveCache();
        this.#children = new ChildrenCache(childrenCacheSize);
        const split = cwdPath.substring(this.rootPath.length).split(sep);
        if (split.length === 1 && !split[0]) {
          split.pop();
        }
        if (nocase === void 0) {
          throw new TypeError("must provide nocase setting to PathScurryBase ctor");
        }
        this.nocase = nocase;
        this.root = this.newRoot(this.#fs);
        this.roots[this.rootPath] = this.root;
        let prev = this.root;
        let len = split.length - 1;
        const joinSep = pathImpl.sep;
        let abs = this.rootPath;
        let sawFirst = false;
        for (const part of split) {
          const l = len--;
          prev = prev.child(part, {
            relative: new Array(l).fill("..").join(joinSep),
            relativePosix: new Array(l).fill("..").join("/"),
            fullpath: abs += (sawFirst ? "" : joinSep) + part
          });
          sawFirst = true;
        }
        this.cwd = prev;
      }
      depth(path3 = this.cwd) {
        if (typeof path3 === "string") {
          path3 = this.cwd.resolve(path3);
        }
        return path3.depth();
      }
      childrenCache() {
        return this.#children;
      }
      resolve(...paths) {
        let r = "";
        for (let i = paths.length - 1; i >= 0; i--) {
          const p = paths[i];
          if (!p || p === ".")
            continue;
          r = r ? `${p}/${r}` : p;
          if (this.isAbsolute(p)) {
            break;
          }
        }
        const cached = this.#resolveCache.get(r);
        if (cached !== void 0) {
          return cached;
        }
        const result = this.cwd.resolve(r).fullpath();
        this.#resolveCache.set(r, result);
        return result;
      }
      resolvePosix(...paths) {
        let r = "";
        for (let i = paths.length - 1; i >= 0; i--) {
          const p = paths[i];
          if (!p || p === ".")
            continue;
          r = r ? `${p}/${r}` : p;
          if (this.isAbsolute(p)) {
            break;
          }
        }
        const cached = this.#resolvePosixCache.get(r);
        if (cached !== void 0) {
          return cached;
        }
        const result = this.cwd.resolve(r).fullpathPosix();
        this.#resolvePosixCache.set(r, result);
        return result;
      }
      relative(entry = this.cwd) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        }
        return entry.relative();
      }
      relativePosix(entry = this.cwd) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        }
        return entry.relativePosix();
      }
      basename(entry = this.cwd) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        }
        return entry.name;
      }
      dirname(entry = this.cwd) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        }
        return (entry.parent || entry).fullpath();
      }
      async readdir(entry = this.cwd, opts = {
        withFileTypes: true
      }) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes } = opts;
        if (!entry.canReaddir()) {
          return [];
        } else {
          const p = await entry.readdir();
          return withFileTypes ? p : p.map((e) => e.name);
        }
      }
      readdirSync(entry = this.cwd, opts = {
        withFileTypes: true
      }) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes = true } = opts;
        if (!entry.canReaddir()) {
          return [];
        } else if (withFileTypes) {
          return entry.readdirSync();
        } else {
          return entry.readdirSync().map((e) => e.name);
        }
      }
      async lstat(entry = this.cwd) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        }
        return entry.lstat();
      }
      lstatSync(entry = this.cwd) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        }
        return entry.lstatSync();
      }
      async readlink(entry = this.cwd, { withFileTypes } = {
        withFileTypes: false
      }) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          withFileTypes = entry.withFileTypes;
          entry = this.cwd;
        }
        const e = await entry.readlink();
        return withFileTypes ? e : e?.fullpath();
      }
      readlinkSync(entry = this.cwd, { withFileTypes } = {
        withFileTypes: false
      }) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          withFileTypes = entry.withFileTypes;
          entry = this.cwd;
        }
        const e = entry.readlinkSync();
        return withFileTypes ? e : e?.fullpath();
      }
      async realpath(entry = this.cwd, { withFileTypes } = {
        withFileTypes: false
      }) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          withFileTypes = entry.withFileTypes;
          entry = this.cwd;
        }
        const e = await entry.realpath();
        return withFileTypes ? e : e?.fullpath();
      }
      realpathSync(entry = this.cwd, { withFileTypes } = {
        withFileTypes: false
      }) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          withFileTypes = entry.withFileTypes;
          entry = this.cwd;
        }
        const e = entry.realpathSync();
        return withFileTypes ? e : e?.fullpath();
      }
      async walk(entry = this.cwd, opts = {}) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes = true, follow = false, filter, walkFilter } = opts;
        const results = [];
        if (!filter || filter(entry)) {
          results.push(withFileTypes ? entry : entry.fullpath());
        }
        const dirs = /* @__PURE__ */ new Set();
        const walk = (dir, cb) => {
          dirs.add(dir);
          dir.readdirCB((er, entries) => {
            if (er) {
              return cb(er);
            }
            let len = entries.length;
            if (!len)
              return cb();
            const next = () => {
              if (--len === 0) {
                cb();
              }
            };
            for (const e of entries) {
              if (!filter || filter(e)) {
                results.push(withFileTypes ? e : e.fullpath());
              }
              if (follow && e.isSymbolicLink()) {
                e.realpath().then((r) => r?.isUnknown() ? r.lstat() : r).then((r) => r?.shouldWalk(dirs, walkFilter) ? walk(r, next) : next());
              } else {
                if (e.shouldWalk(dirs, walkFilter)) {
                  walk(e, next);
                } else {
                  next();
                }
              }
            }
          }, true);
        };
        const start = entry;
        return new Promise((res, rej) => {
          walk(start, (er) => {
            if (er)
              return rej(er);
            res(results);
          });
        });
      }
      walkSync(entry = this.cwd, opts = {}) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes = true, follow = false, filter, walkFilter } = opts;
        const results = [];
        if (!filter || filter(entry)) {
          results.push(withFileTypes ? entry : entry.fullpath());
        }
        const dirs = /* @__PURE__ */ new Set([entry]);
        for (const dir of dirs) {
          const entries = dir.readdirSync();
          for (const e of entries) {
            if (!filter || filter(e)) {
              results.push(withFileTypes ? e : e.fullpath());
            }
            let r = e;
            if (e.isSymbolicLink()) {
              if (!(follow && (r = e.realpathSync())))
                continue;
              if (r.isUnknown())
                r.lstatSync();
            }
            if (r.shouldWalk(dirs, walkFilter)) {
              dirs.add(r);
            }
          }
        }
        return results;
      }
      [Symbol.asyncIterator]() {
        return this.iterate();
      }
      iterate(entry = this.cwd, options = {}) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          options = entry;
          entry = this.cwd;
        }
        return this.stream(entry, options)[Symbol.asyncIterator]();
      }
      [Symbol.iterator]() {
        return this.iterateSync();
      }
      *iterateSync(entry = this.cwd, opts = {}) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes = true, follow = false, filter, walkFilter } = opts;
        if (!filter || filter(entry)) {
          yield withFileTypes ? entry : entry.fullpath();
        }
        const dirs = /* @__PURE__ */ new Set([entry]);
        for (const dir of dirs) {
          const entries = dir.readdirSync();
          for (const e of entries) {
            if (!filter || filter(e)) {
              yield withFileTypes ? e : e.fullpath();
            }
            let r = e;
            if (e.isSymbolicLink()) {
              if (!(follow && (r = e.realpathSync())))
                continue;
              if (r.isUnknown())
                r.lstatSync();
            }
            if (r.shouldWalk(dirs, walkFilter)) {
              dirs.add(r);
            }
          }
        }
      }
      stream(entry = this.cwd, opts = {}) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes = true, follow = false, filter, walkFilter } = opts;
        const results = new minipass_1.Minipass({ objectMode: true });
        if (!filter || filter(entry)) {
          results.write(withFileTypes ? entry : entry.fullpath());
        }
        const dirs = /* @__PURE__ */ new Set();
        const queue = [entry];
        let processing = 0;
        const process4 = () => {
          let paused = false;
          while (!paused) {
            const dir = queue.shift();
            if (!dir) {
              if (processing === 0)
                results.end();
              return;
            }
            processing++;
            dirs.add(dir);
            const onReaddir = (er, entries, didRealpaths = false) => {
              if (er)
                return results.emit("error", er);
              if (follow && !didRealpaths) {
                const promises = [];
                for (const e of entries) {
                  if (e.isSymbolicLink()) {
                    promises.push(e.realpath().then((r) => r?.isUnknown() ? r.lstat() : r));
                  }
                }
                if (promises.length) {
                  Promise.all(promises).then(() => onReaddir(null, entries, true));
                  return;
                }
              }
              for (const e of entries) {
                if (e && (!filter || filter(e))) {
                  if (!results.write(withFileTypes ? e : e.fullpath())) {
                    paused = true;
                  }
                }
              }
              processing--;
              for (const e of entries) {
                const r = e.realpathCached() || e;
                if (r.shouldWalk(dirs, walkFilter)) {
                  queue.push(r);
                }
              }
              if (paused && !results.flowing) {
                results.once("drain", process4);
              } else if (!sync) {
                process4();
              }
            };
            let sync = true;
            dir.readdirCB(onReaddir, true);
            sync = false;
          }
        };
        process4();
        return results;
      }
      streamSync(entry = this.cwd, opts = {}) {
        if (typeof entry === "string") {
          entry = this.cwd.resolve(entry);
        } else if (!(entry instanceof PathBase)) {
          opts = entry;
          entry = this.cwd;
        }
        const { withFileTypes = true, follow = false, filter, walkFilter } = opts;
        const results = new minipass_1.Minipass({ objectMode: true });
        const dirs = /* @__PURE__ */ new Set();
        if (!filter || filter(entry)) {
          results.write(withFileTypes ? entry : entry.fullpath());
        }
        const queue = [entry];
        let processing = 0;
        const process4 = () => {
          let paused = false;
          while (!paused) {
            const dir = queue.shift();
            if (!dir) {
              if (processing === 0)
                results.end();
              return;
            }
            processing++;
            dirs.add(dir);
            const entries = dir.readdirSync();
            for (const e of entries) {
              if (!filter || filter(e)) {
                if (!results.write(withFileTypes ? e : e.fullpath())) {
                  paused = true;
                }
              }
            }
            processing--;
            for (const e of entries) {
              let r = e;
              if (e.isSymbolicLink()) {
                if (!(follow && (r = e.realpathSync())))
                  continue;
                if (r.isUnknown())
                  r.lstatSync();
              }
              if (r.shouldWalk(dirs, walkFilter)) {
                queue.push(r);
              }
            }
          }
          if (paused && !results.flowing)
            results.once("drain", process4);
        };
        process4();
        return results;
      }
      chdir(path3 = this.cwd) {
        const oldCwd = this.cwd;
        this.cwd = typeof path3 === "string" ? this.cwd.resolve(path3) : path3;
        this.cwd[setAsCwd](oldCwd);
      }
    };
    exports2.PathScurryBase = PathScurryBase;
    var PathScurryWin32 = class extends PathScurryBase {
      sep = "\\";
      constructor(cwd = process.cwd(), opts = {}) {
        const { nocase = true } = opts;
        super(cwd, path_1.win32, "\\", { ...opts, nocase });
        this.nocase = nocase;
        for (let p = this.cwd; p; p = p.parent) {
          p.nocase = this.nocase;
        }
      }
      parseRootPath(dir) {
        return path_1.win32.parse(dir).root.toUpperCase();
      }
      newRoot(fs) {
        return new PathWin32(this.rootPath, IFDIR, void 0, this.roots, this.nocase, this.childrenCache(), { fs });
      }
      isAbsolute(p) {
        return p.startsWith("/") || p.startsWith("\\") || /^[a-z]:(\/|\\)/i.test(p);
      }
    };
    exports2.PathScurryWin32 = PathScurryWin32;
    var PathScurryPosix = class extends PathScurryBase {
      sep = "/";
      constructor(cwd = process.cwd(), opts = {}) {
        const { nocase = false } = opts;
        super(cwd, path_1.posix, "/", { ...opts, nocase });
        this.nocase = nocase;
      }
      parseRootPath(_dir) {
        return "/";
      }
      newRoot(fs) {
        return new PathPosix(this.rootPath, IFDIR, void 0, this.roots, this.nocase, this.childrenCache(), { fs });
      }
      isAbsolute(p) {
        return p.startsWith("/");
      }
    };
    exports2.PathScurryPosix = PathScurryPosix;
    var PathScurryDarwin = class extends PathScurryPosix {
      constructor(cwd = process.cwd(), opts = {}) {
        const { nocase = true } = opts;
        super(cwd, { ...opts, nocase });
      }
    };
    exports2.PathScurryDarwin = PathScurryDarwin;
    exports2.Path = process.platform === "win32" ? PathWin32 : PathPosix;
    exports2.PathScurry = process.platform === "win32" ? PathScurryWin32 : process.platform === "darwin" ? PathScurryDarwin : PathScurryPosix;
  }
});

// node_modules/glob/dist/commonjs/pattern.js
var require_pattern2 = __commonJS({
  "node_modules/glob/dist/commonjs/pattern.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Pattern = void 0;
    var minimatch_1 = require_commonjs();
    var isPatternList = (pl) => pl.length >= 1;
    var isGlobList = (gl) => gl.length >= 1;
    var Pattern = class {
      #patternList;
      #globList;
      #index;
      length;
      #platform;
      #rest;
      #globString;
      #isDrive;
      #isUNC;
      #isAbsolute;
      #followGlobstar = true;
      constructor(patternList, globList, index, platform) {
        if (!isPatternList(patternList)) {
          throw new TypeError("empty pattern list");
        }
        if (!isGlobList(globList)) {
          throw new TypeError("empty glob list");
        }
        if (globList.length !== patternList.length) {
          throw new TypeError("mismatched pattern list and glob list lengths");
        }
        this.length = patternList.length;
        if (index < 0 || index >= this.length) {
          throw new TypeError("index out of range");
        }
        this.#patternList = patternList;
        this.#globList = globList;
        this.#index = index;
        this.#platform = platform;
        if (this.#index === 0) {
          if (this.isUNC()) {
            const [p0, p1, p2, p3, ...prest] = this.#patternList;
            const [g0, g1, g2, g3, ...grest] = this.#globList;
            if (prest[0] === "") {
              prest.shift();
              grest.shift();
            }
            const p = [p0, p1, p2, p3, ""].join("/");
            const g = [g0, g1, g2, g3, ""].join("/");
            this.#patternList = [p, ...prest];
            this.#globList = [g, ...grest];
            this.length = this.#patternList.length;
          } else if (this.isDrive() || this.isAbsolute()) {
            const [p1, ...prest] = this.#patternList;
            const [g1, ...grest] = this.#globList;
            if (prest[0] === "") {
              prest.shift();
              grest.shift();
            }
            const p = p1 + "/";
            const g = g1 + "/";
            this.#patternList = [p, ...prest];
            this.#globList = [g, ...grest];
            this.length = this.#patternList.length;
          }
        }
      }
      pattern() {
        return this.#patternList[this.#index];
      }
      isString() {
        return typeof this.#patternList[this.#index] === "string";
      }
      isGlobstar() {
        return this.#patternList[this.#index] === minimatch_1.GLOBSTAR;
      }
      isRegExp() {
        return this.#patternList[this.#index] instanceof RegExp;
      }
      globString() {
        return this.#globString = this.#globString || (this.#index === 0 ? this.isAbsolute() ? this.#globList[0] + this.#globList.slice(1).join("/") : this.#globList.join("/") : this.#globList.slice(this.#index).join("/"));
      }
      hasMore() {
        return this.length > this.#index + 1;
      }
      rest() {
        if (this.#rest !== void 0)
          return this.#rest;
        if (!this.hasMore())
          return this.#rest = null;
        this.#rest = new Pattern(this.#patternList, this.#globList, this.#index + 1, this.#platform);
        this.#rest.#isAbsolute = this.#isAbsolute;
        this.#rest.#isUNC = this.#isUNC;
        this.#rest.#isDrive = this.#isDrive;
        return this.#rest;
      }
      isUNC() {
        const pl = this.#patternList;
        return this.#isUNC !== void 0 ? this.#isUNC : this.#isUNC = this.#platform === "win32" && this.#index === 0 && pl[0] === "" && pl[1] === "" && typeof pl[2] === "string" && !!pl[2] && typeof pl[3] === "string" && !!pl[3];
      }
      isDrive() {
        const pl = this.#patternList;
        return this.#isDrive !== void 0 ? this.#isDrive : this.#isDrive = this.#platform === "win32" && this.#index === 0 && this.length > 1 && typeof pl[0] === "string" && /^[a-z]:$/i.test(pl[0]);
      }
      isAbsolute() {
        const pl = this.#patternList;
        return this.#isAbsolute !== void 0 ? this.#isAbsolute : this.#isAbsolute = pl[0] === "" && pl.length > 1 || this.isDrive() || this.isUNC();
      }
      root() {
        const p = this.#patternList[0];
        return typeof p === "string" && this.isAbsolute() && this.#index === 0 ? p : "";
      }
      checkFollowGlobstar() {
        return !(this.#index === 0 || !this.isGlobstar() || !this.#followGlobstar);
      }
      markFollowGlobstar() {
        if (this.#index === 0 || !this.isGlobstar() || !this.#followGlobstar)
          return false;
        this.#followGlobstar = false;
        return true;
      }
    };
    exports2.Pattern = Pattern;
  }
});

// node_modules/glob/dist/commonjs/ignore.js
var require_ignore = __commonJS({
  "node_modules/glob/dist/commonjs/ignore.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Ignore = void 0;
    var minimatch_1 = require_commonjs();
    var pattern_js_1 = require_pattern2();
    var defaultPlatform = typeof process === "object" && process && typeof process.platform === "string" ? process.platform : "linux";
    var Ignore = class {
      relative;
      relativeChildren;
      absolute;
      absoluteChildren;
      constructor(ignored, { nobrace, nocase, noext, noglobstar, platform = defaultPlatform }) {
        this.relative = [];
        this.absolute = [];
        this.relativeChildren = [];
        this.absoluteChildren = [];
        const mmopts = {
          dot: true,
          nobrace,
          nocase,
          noext,
          noglobstar,
          optimizationLevel: 2,
          platform,
          nocomment: true,
          nonegate: true
        };
        for (const ign of ignored) {
          const mm = new minimatch_1.Minimatch(ign, mmopts);
          for (let i = 0; i < mm.set.length; i++) {
            const parsed = mm.set[i];
            const globParts = mm.globParts[i];
            if (!parsed || !globParts) {
              throw new Error("invalid pattern object");
            }
            while (parsed[0] === "." && globParts[0] === ".") {
              parsed.shift();
              globParts.shift();
            }
            const p = new pattern_js_1.Pattern(parsed, globParts, 0, platform);
            const m = new minimatch_1.Minimatch(p.globString(), mmopts);
            const children = globParts[globParts.length - 1] === "**";
            const absolute = p.isAbsolute();
            if (absolute)
              this.absolute.push(m);
            else
              this.relative.push(m);
            if (children) {
              if (absolute)
                this.absoluteChildren.push(m);
              else
                this.relativeChildren.push(m);
            }
          }
        }
      }
      ignored(p) {
        const fullpath = p.fullpath();
        const fullpaths = `${fullpath}/`;
        const relative = p.relative() || ".";
        const relatives = `${relative}/`;
        for (const m of this.relative) {
          if (m.match(relative) || m.match(relatives))
            return true;
        }
        for (const m of this.absolute) {
          if (m.match(fullpath) || m.match(fullpaths))
            return true;
        }
        return false;
      }
      childrenIgnored(p) {
        const fullpath = p.fullpath() + "/";
        const relative = (p.relative() || ".") + "/";
        for (const m of this.relativeChildren) {
          if (m.match(relative))
            return true;
        }
        for (const m of this.absoluteChildren) {
          if (m.match(fullpath))
            return true;
        }
        return false;
      }
    };
    exports2.Ignore = Ignore;
  }
});

// node_modules/glob/dist/commonjs/processor.js
var require_processor = __commonJS({
  "node_modules/glob/dist/commonjs/processor.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Processor = exports2.SubWalks = exports2.MatchRecord = exports2.HasWalkedCache = void 0;
    var minimatch_1 = require_commonjs();
    var HasWalkedCache = class {
      store;
      constructor(store = /* @__PURE__ */ new Map()) {
        this.store = store;
      }
      copy() {
        return new HasWalkedCache(new Map(this.store));
      }
      hasWalked(target, pattern) {
        return this.store.get(target.fullpath())?.has(pattern.globString());
      }
      storeWalked(target, pattern) {
        const fullpath = target.fullpath();
        const cached = this.store.get(fullpath);
        if (cached)
          cached.add(pattern.globString());
        else
          this.store.set(fullpath, /* @__PURE__ */ new Set([pattern.globString()]));
      }
    };
    exports2.HasWalkedCache = HasWalkedCache;
    var MatchRecord = class {
      store = /* @__PURE__ */ new Map();
      add(target, absolute, ifDir) {
        const n = (absolute ? 2 : 0) | (ifDir ? 1 : 0);
        const current = this.store.get(target);
        this.store.set(target, current === void 0 ? n : n & current);
      }
      entries() {
        return [...this.store.entries()].map(([path3, n]) => [
          path3,
          !!(n & 2),
          !!(n & 1)
        ]);
      }
    };
    exports2.MatchRecord = MatchRecord;
    var SubWalks = class {
      store = /* @__PURE__ */ new Map();
      add(target, pattern) {
        if (!target.canReaddir()) {
          return;
        }
        const subs = this.store.get(target);
        if (subs) {
          if (!subs.find((p) => p.globString() === pattern.globString())) {
            subs.push(pattern);
          }
        } else
          this.store.set(target, [pattern]);
      }
      get(target) {
        const subs = this.store.get(target);
        if (!subs) {
          throw new Error("attempting to walk unknown path");
        }
        return subs;
      }
      entries() {
        return this.keys().map((k) => [k, this.store.get(k)]);
      }
      keys() {
        return [...this.store.keys()].filter((t) => t.canReaddir());
      }
    };
    exports2.SubWalks = SubWalks;
    var Processor = class {
      hasWalkedCache;
      matches = new MatchRecord();
      subwalks = new SubWalks();
      patterns;
      follow;
      dot;
      opts;
      constructor(opts, hasWalkedCache) {
        this.opts = opts;
        this.follow = !!opts.follow;
        this.dot = !!opts.dot;
        this.hasWalkedCache = hasWalkedCache ? hasWalkedCache.copy() : new HasWalkedCache();
      }
      processPatterns(target, patterns) {
        this.patterns = patterns;
        const processingSet = patterns.map((p) => [target, p]);
        for (let [t, pattern] of processingSet) {
          this.hasWalkedCache.storeWalked(t, pattern);
          const root = pattern.root();
          const absolute = pattern.isAbsolute() && this.opts.absolute !== false;
          if (root) {
            t = t.resolve(root === "/" && this.opts.root !== void 0 ? this.opts.root : root);
            const rest2 = pattern.rest();
            if (!rest2) {
              this.matches.add(t, true, false);
              continue;
            } else {
              pattern = rest2;
            }
          }
          if (t.isENOENT())
            continue;
          let p;
          let rest;
          let changed = false;
          while (typeof (p = pattern.pattern()) === "string" && (rest = pattern.rest())) {
            const c = t.resolve(p);
            t = c;
            pattern = rest;
            changed = true;
          }
          p = pattern.pattern();
          rest = pattern.rest();
          if (changed) {
            if (this.hasWalkedCache.hasWalked(t, pattern))
              continue;
            this.hasWalkedCache.storeWalked(t, pattern);
          }
          if (typeof p === "string") {
            const ifDir = p === ".." || p === "" || p === ".";
            this.matches.add(t.resolve(p), absolute, ifDir);
            continue;
          } else if (p === minimatch_1.GLOBSTAR) {
            if (!t.isSymbolicLink() || this.follow || pattern.checkFollowGlobstar()) {
              this.subwalks.add(t, pattern);
            }
            const rp = rest?.pattern();
            const rrest = rest?.rest();
            if (!rest || (rp === "" || rp === ".") && !rrest) {
              this.matches.add(t, absolute, rp === "" || rp === ".");
            } else {
              if (rp === "..") {
                const tp = t.parent || t;
                if (!rrest)
                  this.matches.add(tp, absolute, true);
                else if (!this.hasWalkedCache.hasWalked(tp, rrest)) {
                  this.subwalks.add(tp, rrest);
                }
              }
            }
          } else if (p instanceof RegExp) {
            this.subwalks.add(t, pattern);
          }
        }
        return this;
      }
      subwalkTargets() {
        return this.subwalks.keys();
      }
      child() {
        return new Processor(this.opts, this.hasWalkedCache);
      }
      filterEntries(parent, entries) {
        const patterns = this.subwalks.get(parent);
        const results = this.child();
        for (const e of entries) {
          for (const pattern of patterns) {
            const absolute = pattern.isAbsolute();
            const p = pattern.pattern();
            const rest = pattern.rest();
            if (p === minimatch_1.GLOBSTAR) {
              results.testGlobstar(e, pattern, rest, absolute);
            } else if (p instanceof RegExp) {
              results.testRegExp(e, p, rest, absolute);
            } else {
              results.testString(e, p, rest, absolute);
            }
          }
        }
        return results;
      }
      testGlobstar(e, pattern, rest, absolute) {
        if (this.dot || !e.name.startsWith(".")) {
          if (!pattern.hasMore()) {
            this.matches.add(e, absolute, false);
          }
          if (e.canReaddir()) {
            if (this.follow || !e.isSymbolicLink()) {
              this.subwalks.add(e, pattern);
            } else if (e.isSymbolicLink()) {
              if (rest && pattern.checkFollowGlobstar()) {
                this.subwalks.add(e, rest);
              } else if (pattern.markFollowGlobstar()) {
                this.subwalks.add(e, pattern);
              }
            }
          }
        }
        if (rest) {
          const rp = rest.pattern();
          if (typeof rp === "string" && rp !== ".." && rp !== "" && rp !== ".") {
            this.testString(e, rp, rest.rest(), absolute);
          } else if (rp === "..") {
            const ep = e.parent || e;
            this.subwalks.add(ep, rest);
          } else if (rp instanceof RegExp) {
            this.testRegExp(e, rp, rest.rest(), absolute);
          }
        }
      }
      testRegExp(e, p, rest, absolute) {
        if (!p.test(e.name))
          return;
        if (!rest) {
          this.matches.add(e, absolute, false);
        } else {
          this.subwalks.add(e, rest);
        }
      }
      testString(e, p, rest, absolute) {
        if (!e.isNamed(p))
          return;
        if (!rest) {
          this.matches.add(e, absolute, false);
        } else {
          this.subwalks.add(e, rest);
        }
      }
    };
    exports2.Processor = Processor;
  }
});

// node_modules/glob/dist/commonjs/walker.js
var require_walker = __commonJS({
  "node_modules/glob/dist/commonjs/walker.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.GlobStream = exports2.GlobWalker = exports2.GlobUtil = void 0;
    var minipass_1 = require_commonjs3();
    var ignore_js_1 = require_ignore();
    var processor_js_1 = require_processor();
    var makeIgnore = (ignore, opts) => typeof ignore === "string" ? new ignore_js_1.Ignore([ignore], opts) : Array.isArray(ignore) ? new ignore_js_1.Ignore(ignore, opts) : ignore;
    var GlobUtil = class {
      path;
      patterns;
      opts;
      seen = /* @__PURE__ */ new Set();
      paused = false;
      aborted = false;
      #onResume = [];
      #ignore;
      #sep;
      signal;
      maxDepth;
      constructor(patterns, path3, opts) {
        this.patterns = patterns;
        this.path = path3;
        this.opts = opts;
        this.#sep = !opts.posix && opts.platform === "win32" ? "\\" : "/";
        if (opts.ignore) {
          this.#ignore = makeIgnore(opts.ignore, opts);
        }
        this.maxDepth = opts.maxDepth || Infinity;
        if (opts.signal) {
          this.signal = opts.signal;
          this.signal.addEventListener("abort", () => {
            this.#onResume.length = 0;
          });
        }
      }
      #ignored(path3) {
        return this.seen.has(path3) || !!this.#ignore?.ignored?.(path3);
      }
      #childrenIgnored(path3) {
        return !!this.#ignore?.childrenIgnored?.(path3);
      }
      pause() {
        this.paused = true;
      }
      resume() {
        if (this.signal?.aborted)
          return;
        this.paused = false;
        let fn = void 0;
        while (!this.paused && (fn = this.#onResume.shift())) {
          fn();
        }
      }
      onResume(fn) {
        if (this.signal?.aborted)
          return;
        if (!this.paused) {
          fn();
        } else {
          this.#onResume.push(fn);
        }
      }
      async matchCheck(e, ifDir) {
        if (ifDir && this.opts.nodir)
          return void 0;
        let rpc;
        if (this.opts.realpath) {
          rpc = e.realpathCached() || await e.realpath();
          if (!rpc)
            return void 0;
          e = rpc;
        }
        const needStat = e.isUnknown() || this.opts.stat;
        const s = needStat ? await e.lstat() : e;
        if (this.opts.follow && this.opts.nodir && s?.isSymbolicLink()) {
          const target = await s.realpath();
          if (target && (target.isUnknown() || this.opts.stat)) {
            await target.lstat();
          }
        }
        return this.matchCheckTest(s, ifDir);
      }
      matchCheckTest(e, ifDir) {
        return e && (this.maxDepth === Infinity || e.depth() <= this.maxDepth) && (!ifDir || e.canReaddir()) && (!this.opts.nodir || !e.isDirectory()) && (!this.opts.nodir || !this.opts.follow || !e.isSymbolicLink() || !e.realpathCached()?.isDirectory()) && !this.#ignored(e) ? e : void 0;
      }
      matchCheckSync(e, ifDir) {
        if (ifDir && this.opts.nodir)
          return void 0;
        let rpc;
        if (this.opts.realpath) {
          rpc = e.realpathCached() || e.realpathSync();
          if (!rpc)
            return void 0;
          e = rpc;
        }
        const needStat = e.isUnknown() || this.opts.stat;
        const s = needStat ? e.lstatSync() : e;
        if (this.opts.follow && this.opts.nodir && s?.isSymbolicLink()) {
          const target = s.realpathSync();
          if (target && (target?.isUnknown() || this.opts.stat)) {
            target.lstatSync();
          }
        }
        return this.matchCheckTest(s, ifDir);
      }
      matchFinish(e, absolute) {
        if (this.#ignored(e))
          return;
        const abs = this.opts.absolute === void 0 ? absolute : this.opts.absolute;
        this.seen.add(e);
        const mark = this.opts.mark && e.isDirectory() ? this.#sep : "";
        if (this.opts.withFileTypes) {
          this.matchEmit(e);
        } else if (abs) {
          const abs2 = this.opts.posix ? e.fullpathPosix() : e.fullpath();
          this.matchEmit(abs2 + mark);
        } else {
          const rel = this.opts.posix ? e.relativePosix() : e.relative();
          const pre = this.opts.dotRelative && !rel.startsWith(".." + this.#sep) ? "." + this.#sep : "";
          this.matchEmit(!rel ? "." + mark : pre + rel + mark);
        }
      }
      async match(e, absolute, ifDir) {
        const p = await this.matchCheck(e, ifDir);
        if (p)
          this.matchFinish(p, absolute);
      }
      matchSync(e, absolute, ifDir) {
        const p = this.matchCheckSync(e, ifDir);
        if (p)
          this.matchFinish(p, absolute);
      }
      walkCB(target, patterns, cb) {
        if (this.signal?.aborted)
          cb();
        this.walkCB2(target, patterns, new processor_js_1.Processor(this.opts), cb);
      }
      walkCB2(target, patterns, processor, cb) {
        if (this.#childrenIgnored(target))
          return cb();
        if (this.signal?.aborted)
          cb();
        if (this.paused) {
          this.onResume(() => this.walkCB2(target, patterns, processor, cb));
          return;
        }
        processor.processPatterns(target, patterns);
        let tasks = 1;
        const next = () => {
          if (--tasks === 0)
            cb();
        };
        for (const [m, absolute, ifDir] of processor.matches.entries()) {
          if (this.#ignored(m))
            continue;
          tasks++;
          this.match(m, absolute, ifDir).then(() => next());
        }
        for (const t of processor.subwalkTargets()) {
          if (this.maxDepth !== Infinity && t.depth() >= this.maxDepth) {
            continue;
          }
          tasks++;
          const childrenCached = t.readdirCached();
          if (t.calledReaddir())
            this.walkCB3(t, childrenCached, processor, next);
          else {
            t.readdirCB((_, entries) => this.walkCB3(t, entries, processor, next), true);
          }
        }
        next();
      }
      walkCB3(target, entries, processor, cb) {
        processor = processor.filterEntries(target, entries);
        let tasks = 1;
        const next = () => {
          if (--tasks === 0)
            cb();
        };
        for (const [m, absolute, ifDir] of processor.matches.entries()) {
          if (this.#ignored(m))
            continue;
          tasks++;
          this.match(m, absolute, ifDir).then(() => next());
        }
        for (const [target2, patterns] of processor.subwalks.entries()) {
          tasks++;
          this.walkCB2(target2, patterns, processor.child(), next);
        }
        next();
      }
      walkCBSync(target, patterns, cb) {
        if (this.signal?.aborted)
          cb();
        this.walkCB2Sync(target, patterns, new processor_js_1.Processor(this.opts), cb);
      }
      walkCB2Sync(target, patterns, processor, cb) {
        if (this.#childrenIgnored(target))
          return cb();
        if (this.signal?.aborted)
          cb();
        if (this.paused) {
          this.onResume(() => this.walkCB2Sync(target, patterns, processor, cb));
          return;
        }
        processor.processPatterns(target, patterns);
        let tasks = 1;
        const next = () => {
          if (--tasks === 0)
            cb();
        };
        for (const [m, absolute, ifDir] of processor.matches.entries()) {
          if (this.#ignored(m))
            continue;
          this.matchSync(m, absolute, ifDir);
        }
        for (const t of processor.subwalkTargets()) {
          if (this.maxDepth !== Infinity && t.depth() >= this.maxDepth) {
            continue;
          }
          tasks++;
          const children = t.readdirSync();
          this.walkCB3Sync(t, children, processor, next);
        }
        next();
      }
      walkCB3Sync(target, entries, processor, cb) {
        processor = processor.filterEntries(target, entries);
        let tasks = 1;
        const next = () => {
          if (--tasks === 0)
            cb();
        };
        for (const [m, absolute, ifDir] of processor.matches.entries()) {
          if (this.#ignored(m))
            continue;
          this.matchSync(m, absolute, ifDir);
        }
        for (const [target2, patterns] of processor.subwalks.entries()) {
          tasks++;
          this.walkCB2Sync(target2, patterns, processor.child(), next);
        }
        next();
      }
    };
    exports2.GlobUtil = GlobUtil;
    var GlobWalker = class extends GlobUtil {
      matches;
      constructor(patterns, path3, opts) {
        super(patterns, path3, opts);
        this.matches = /* @__PURE__ */ new Set();
      }
      matchEmit(e) {
        this.matches.add(e);
      }
      async walk() {
        if (this.signal?.aborted)
          throw this.signal.reason;
        if (this.path.isUnknown()) {
          await this.path.lstat();
        }
        await new Promise((res, rej) => {
          this.walkCB(this.path, this.patterns, () => {
            if (this.signal?.aborted) {
              rej(this.signal.reason);
            } else {
              res(this.matches);
            }
          });
        });
        return this.matches;
      }
      walkSync() {
        if (this.signal?.aborted)
          throw this.signal.reason;
        if (this.path.isUnknown()) {
          this.path.lstatSync();
        }
        this.walkCBSync(this.path, this.patterns, () => {
          if (this.signal?.aborted)
            throw this.signal.reason;
        });
        return this.matches;
      }
    };
    exports2.GlobWalker = GlobWalker;
    var GlobStream = class extends GlobUtil {
      results;
      constructor(patterns, path3, opts) {
        super(patterns, path3, opts);
        this.results = new minipass_1.Minipass({
          signal: this.signal,
          objectMode: true
        });
        this.results.on("drain", () => this.resume());
        this.results.on("resume", () => this.resume());
      }
      matchEmit(e) {
        this.results.write(e);
        if (!this.results.flowing)
          this.pause();
      }
      stream() {
        const target = this.path;
        if (target.isUnknown()) {
          target.lstat().then(() => {
            this.walkCB(target, this.patterns, () => this.results.end());
          });
        } else {
          this.walkCB(target, this.patterns, () => this.results.end());
        }
        return this.results;
      }
      streamSync() {
        if (this.path.isUnknown()) {
          this.path.lstatSync();
        }
        this.walkCBSync(this.path, this.patterns, () => this.results.end());
        return this.results;
      }
    };
    exports2.GlobStream = GlobStream;
  }
});

// node_modules/glob/dist/commonjs/glob.js
var require_glob = __commonJS({
  "node_modules/glob/dist/commonjs/glob.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.Glob = void 0;
    var minimatch_1 = require_commonjs();
    var path_scurry_1 = require_commonjs4();
    var url_1 = require("url");
    var pattern_js_1 = require_pattern2();
    var walker_js_1 = require_walker();
    var defaultPlatform = typeof process === "object" && process && typeof process.platform === "string" ? process.platform : "linux";
    var Glob = class {
      absolute;
      cwd;
      root;
      dot;
      dotRelative;
      follow;
      ignore;
      magicalBraces;
      mark;
      matchBase;
      maxDepth;
      nobrace;
      nocase;
      nodir;
      noext;
      noglobstar;
      pattern;
      platform;
      realpath;
      scurry;
      stat;
      signal;
      windowsPathsNoEscape;
      withFileTypes;
      opts;
      patterns;
      constructor(pattern, opts) {
        if (!opts)
          throw new TypeError("glob options required");
        this.withFileTypes = !!opts.withFileTypes;
        this.signal = opts.signal;
        this.follow = !!opts.follow;
        this.dot = !!opts.dot;
        this.dotRelative = !!opts.dotRelative;
        this.nodir = !!opts.nodir;
        this.mark = !!opts.mark;
        if (!opts.cwd) {
          this.cwd = "";
        } else if (opts.cwd instanceof URL || opts.cwd.startsWith("file://")) {
          opts.cwd = (0, url_1.fileURLToPath)(opts.cwd);
        }
        this.cwd = opts.cwd || "";
        this.root = opts.root;
        this.magicalBraces = !!opts.magicalBraces;
        this.nobrace = !!opts.nobrace;
        this.noext = !!opts.noext;
        this.realpath = !!opts.realpath;
        this.absolute = opts.absolute;
        this.noglobstar = !!opts.noglobstar;
        this.matchBase = !!opts.matchBase;
        this.maxDepth = typeof opts.maxDepth === "number" ? opts.maxDepth : Infinity;
        this.stat = !!opts.stat;
        this.ignore = opts.ignore;
        if (this.withFileTypes && this.absolute !== void 0) {
          throw new Error("cannot set absolute and withFileTypes:true");
        }
        if (typeof pattern === "string") {
          pattern = [pattern];
        }
        this.windowsPathsNoEscape = !!opts.windowsPathsNoEscape || opts.allowWindowsEscape === false;
        if (this.windowsPathsNoEscape) {
          pattern = pattern.map((p) => p.replace(/\\/g, "/"));
        }
        if (this.matchBase) {
          if (opts.noglobstar) {
            throw new TypeError("base matching requires globstar");
          }
          pattern = pattern.map((p) => p.includes("/") ? p : `./**/${p}`);
        }
        this.pattern = pattern;
        this.platform = opts.platform || defaultPlatform;
        this.opts = { ...opts, platform: this.platform };
        if (opts.scurry) {
          this.scurry = opts.scurry;
          if (opts.nocase !== void 0 && opts.nocase !== opts.scurry.nocase) {
            throw new Error("nocase option contradicts provided scurry option");
          }
        } else {
          const Scurry = opts.platform === "win32" ? path_scurry_1.PathScurryWin32 : opts.platform === "darwin" ? path_scurry_1.PathScurryDarwin : opts.platform ? path_scurry_1.PathScurryPosix : path_scurry_1.PathScurry;
          this.scurry = new Scurry(this.cwd, {
            nocase: opts.nocase,
            fs: opts.fs
          });
        }
        this.nocase = this.scurry.nocase;
        const nocaseMagicOnly = this.platform === "darwin" || this.platform === "win32";
        const mmo = {
          ...opts,
          dot: this.dot,
          matchBase: this.matchBase,
          nobrace: this.nobrace,
          nocase: this.nocase,
          nocaseMagicOnly,
          nocomment: true,
          noext: this.noext,
          nonegate: true,
          optimizationLevel: 2,
          platform: this.platform,
          windowsPathsNoEscape: this.windowsPathsNoEscape,
          debug: !!this.opts.debug
        };
        const mms = this.pattern.map((p) => new minimatch_1.Minimatch(p, mmo));
        const [matchSet, globParts] = mms.reduce((set, m) => {
          set[0].push(...m.set);
          set[1].push(...m.globParts);
          return set;
        }, [[], []]);
        this.patterns = matchSet.map((set, i) => {
          const g = globParts[i];
          if (!g)
            throw new Error("invalid pattern object");
          return new pattern_js_1.Pattern(set, g, 0, this.platform);
        });
      }
      async walk() {
        return [
          ...await new walker_js_1.GlobWalker(this.patterns, this.scurry.cwd, {
            ...this.opts,
            maxDepth: this.maxDepth !== Infinity ? this.maxDepth + this.scurry.cwd.depth() : Infinity,
            platform: this.platform,
            nocase: this.nocase
          }).walk()
        ];
      }
      walkSync() {
        return [
          ...new walker_js_1.GlobWalker(this.patterns, this.scurry.cwd, {
            ...this.opts,
            maxDepth: this.maxDepth !== Infinity ? this.maxDepth + this.scurry.cwd.depth() : Infinity,
            platform: this.platform,
            nocase: this.nocase
          }).walkSync()
        ];
      }
      stream() {
        return new walker_js_1.GlobStream(this.patterns, this.scurry.cwd, {
          ...this.opts,
          maxDepth: this.maxDepth !== Infinity ? this.maxDepth + this.scurry.cwd.depth() : Infinity,
          platform: this.platform,
          nocase: this.nocase
        }).stream();
      }
      streamSync() {
        return new walker_js_1.GlobStream(this.patterns, this.scurry.cwd, {
          ...this.opts,
          maxDepth: this.maxDepth !== Infinity ? this.maxDepth + this.scurry.cwd.depth() : Infinity,
          platform: this.platform,
          nocase: this.nocase
        }).streamSync();
      }
      iterateSync() {
        return this.streamSync()[Symbol.iterator]();
      }
      [Symbol.iterator]() {
        return this.iterateSync();
      }
      iterate() {
        return this.stream()[Symbol.asyncIterator]();
      }
      [Symbol.asyncIterator]() {
        return this.iterate();
      }
    };
    exports2.Glob = Glob;
  }
});

// node_modules/glob/dist/commonjs/has-magic.js
var require_has_magic = __commonJS({
  "node_modules/glob/dist/commonjs/has-magic.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.hasMagic = void 0;
    var minimatch_1 = require_commonjs();
    var hasMagic = (pattern, options = {}) => {
      if (!Array.isArray(pattern)) {
        pattern = [pattern];
      }
      for (const p of pattern) {
        if (new minimatch_1.Minimatch(p, options).hasMagic())
          return true;
      }
      return false;
    };
    exports2.hasMagic = hasMagic;
  }
});

// node_modules/glob/dist/commonjs/index.js
var require_commonjs5 = __commonJS({
  "node_modules/glob/dist/commonjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.glob = exports2.hasMagic = exports2.Glob = exports2.unescape = exports2.escape = exports2.sync = exports2.iterate = exports2.iterateSync = exports2.stream = exports2.streamSync = exports2.globIterate = exports2.globIterateSync = exports2.globSync = exports2.globStream = exports2.globStreamSync = void 0;
    var minimatch_1 = require_commonjs();
    var glob_js_1 = require_glob();
    var has_magic_js_1 = require_has_magic();
    function globStreamSync(pattern, options = {}) {
      return new glob_js_1.Glob(pattern, options).streamSync();
    }
    exports2.globStreamSync = globStreamSync;
    function globStream(pattern, options = {}) {
      return new glob_js_1.Glob(pattern, options).stream();
    }
    exports2.globStream = globStream;
    function globSync(pattern, options = {}) {
      return new glob_js_1.Glob(pattern, options).walkSync();
    }
    exports2.globSync = globSync;
    async function glob_(pattern, options = {}) {
      return new glob_js_1.Glob(pattern, options).walk();
    }
    function globIterateSync(pattern, options = {}) {
      return new glob_js_1.Glob(pattern, options).iterateSync();
    }
    exports2.globIterateSync = globIterateSync;
    function globIterate(pattern, options = {}) {
      return new glob_js_1.Glob(pattern, options).iterate();
    }
    exports2.globIterate = globIterate;
    exports2.streamSync = globStreamSync;
    exports2.stream = Object.assign(globStream, { sync: globStreamSync });
    exports2.iterateSync = globIterateSync;
    exports2.iterate = Object.assign(globIterate, {
      sync: globIterateSync
    });
    exports2.sync = Object.assign(globSync, {
      stream: globStreamSync,
      iterate: globIterateSync
    });
    var minimatch_2 = require_commonjs();
    Object.defineProperty(exports2, "escape", { enumerable: true, get: function() {
      return minimatch_2.escape;
    } });
    Object.defineProperty(exports2, "unescape", { enumerable: true, get: function() {
      return minimatch_2.unescape;
    } });
    var glob_js_2 = require_glob();
    Object.defineProperty(exports2, "Glob", { enumerable: true, get: function() {
      return glob_js_2.Glob;
    } });
    var has_magic_js_2 = require_has_magic();
    Object.defineProperty(exports2, "hasMagic", { enumerable: true, get: function() {
      return has_magic_js_2.hasMagic;
    } });
    exports2.glob = Object.assign(glob_, {
      glob: glob_,
      globSync,
      sync: exports2.sync,
      globStream,
      stream: exports2.stream,
      globStreamSync,
      streamSync: exports2.streamSync,
      globIterate,
      iterate: exports2.iterate,
      globIterateSync,
      iterateSync: exports2.iterateSync,
      Glob: glob_js_1.Glob,
      hasMagic: has_magic_js_1.hasMagic,
      escape: minimatch_1.escape,
      unescape: minimatch_1.unescape
    });
    exports2.glob.glob = exports2.glob;
  }
});

// node_modules/camelcase/index.js
var camelcase_exports = {};
__export(camelcase_exports, {
  default: () => camelCase
});
function camelCase(input, options) {
  if (!(typeof input === "string" || Array.isArray(input))) {
    throw new TypeError("Expected the input to be `string | string[]`");
  }
  options = {
    pascalCase: false,
    preserveConsecutiveUppercase: false,
    ...options
  };
  if (Array.isArray(input)) {
    input = input.map((x) => x.trim()).filter((x) => x.length).join("-");
  } else {
    input = input.trim();
  }
  if (input.length === 0) {
    return "";
  }
  const toLowerCase = options.locale === false ? (string) => string.toLowerCase() : (string) => string.toLocaleLowerCase(options.locale);
  const toUpperCase = options.locale === false ? (string) => string.toUpperCase() : (string) => string.toLocaleUpperCase(options.locale);
  if (input.length === 1) {
    if (SEPARATORS.test(input)) {
      return "";
    }
    return options.pascalCase ? toUpperCase(input) : toLowerCase(input);
  }
  const hasUpperCase = input !== toLowerCase(input);
  if (hasUpperCase) {
    input = preserveCamelCase(input, toLowerCase, toUpperCase, options.preserveConsecutiveUppercase);
  }
  input = input.replace(LEADING_SEPARATORS, "");
  input = options.preserveConsecutiveUppercase ? preserveConsecutiveUppercase(input, toLowerCase) : toLowerCase(input);
  if (options.pascalCase) {
    input = toUpperCase(input.charAt(0)) + input.slice(1);
  }
  return postProcess(input, toUpperCase);
}
var UPPERCASE, LOWERCASE, LEADING_CAPITAL, IDENTIFIER, SEPARATORS, LEADING_SEPARATORS, SEPARATORS_AND_IDENTIFIER, NUMBERS_AND_IDENTIFIER, preserveCamelCase, preserveConsecutiveUppercase, postProcess;
var init_camelcase = __esm({
  "node_modules/camelcase/index.js"() {
    UPPERCASE = /[\p{Lu}]/u;
    LOWERCASE = /[\p{Ll}]/u;
    LEADING_CAPITAL = /^[\p{Lu}](?![\p{Lu}])/gu;
    IDENTIFIER = /([\p{Alpha}\p{N}_]|$)/u;
    SEPARATORS = /[_.\- ]+/;
    LEADING_SEPARATORS = new RegExp("^" + SEPARATORS.source);
    SEPARATORS_AND_IDENTIFIER = new RegExp(SEPARATORS.source + IDENTIFIER.source, "gu");
    NUMBERS_AND_IDENTIFIER = new RegExp("\\d+" + IDENTIFIER.source, "gu");
    preserveCamelCase = (string, toLowerCase, toUpperCase, preserveConsecutiveUppercase2) => {
      let isLastCharLower = false;
      let isLastCharUpper = false;
      let isLastLastCharUpper = false;
      let isLastLastCharPreserved = false;
      for (let index = 0; index < string.length; index++) {
        const character = string[index];
        isLastLastCharPreserved = index > 2 ? string[index - 3] === "-" : true;
        if (isLastCharLower && UPPERCASE.test(character)) {
          string = string.slice(0, index) + "-" + string.slice(index);
          isLastCharLower = false;
          isLastLastCharUpper = isLastCharUpper;
          isLastCharUpper = true;
          index++;
        } else if (isLastCharUpper && isLastLastCharUpper && LOWERCASE.test(character) && (!isLastLastCharPreserved || preserveConsecutiveUppercase2)) {
          string = string.slice(0, index - 1) + "-" + string.slice(index - 1);
          isLastLastCharUpper = isLastCharUpper;
          isLastCharUpper = false;
          isLastCharLower = true;
        } else {
          isLastCharLower = toLowerCase(character) === character && toUpperCase(character) !== character;
          isLastLastCharUpper = isLastCharUpper;
          isLastCharUpper = toUpperCase(character) === character && toLowerCase(character) !== character;
        }
      }
      return string;
    };
    preserveConsecutiveUppercase = (input, toLowerCase) => {
      LEADING_CAPITAL.lastIndex = 0;
      return input.replace(LEADING_CAPITAL, (m1) => toLowerCase(m1));
    };
    postProcess = (input, toUpperCase) => {
      SEPARATORS_AND_IDENTIFIER.lastIndex = 0;
      NUMBERS_AND_IDENTIFIER.lastIndex = 0;
      return input.replace(SEPARATORS_AND_IDENTIFIER, (_, identifier) => toUpperCase(identifier)).replace(NUMBERS_AND_IDENTIFIER, (m) => toUpperCase(m));
    };
  }
});

// out/frameworks/element-plus.js
var require_element_plus = __commonJS({
  "out/frameworks/element-plus.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.default = {
      "template": {
        "el-button": {
          "_html": {
            "": '<el-button type="primary">$1</el-button>',
            ":plain": '<el-button type="primary" plain>$1</el-button>',
            ":round": '<el-button type="primary" round>$1</el-button>',
            ":circle": '<el-button type="primary" circle>$1</el-button>',
            ":disabled": '<el-button type="primary" disabled>$1</el-button>',
            ":link": '<el-button type="primary" link>$1</el-button>',
            ":text": '<el-button type="primary" text>$1</el-button>',
            ":icon": '<el-button type="primary" :icon="$1">$2</el-button>',
            ":loading": '<el-button type="primary" :loading="$1">$2</el-button>'
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/button.html)\n\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| size| \u5C3A\u5BF8| enum| \u2014 |\n| type| \u7C7B\u578B| enum| \u2014 |\n| plain| \u662F\u5426\u4E3A\u6734\u7D20\u6309\u94AE| boolean| false |\n| text 2.2.0| \u662F\u5426\u4E3A\u6587\u5B57\u6309\u94AE| boolean| false |\n| bg 2.2.0| \u662F\u5426\u663E\u793A\u6587\u5B57\u6309\u94AE\u80CC\u666F\u989C\u8272| boolean| false |\n| link 2.2.1| \u662F\u5426\u4E3A\u94FE\u63A5\u6309\u94AE| boolean| false |\n| round| \u662F\u5426\u4E3A\u5706\u89D2\u6309\u94AE| boolean| false |\n| circle| \u662F\u5426\u4E3A\u5706\u5F62\u6309\u94AE| boolean| false |\n| loading| \u662F\u5426\u4E3A\u52A0\u8F7D\u4E2D\u72B6\u6001| boolean| false |\n| loading-icon| \u81EA\u5B9A\u4E49\u52A0\u8F7D\u4E2D\u72B6\u6001\u56FE\u6807\u7EC4\u4EF6| string / Component| Loading |\n| disabled| \u6309\u94AE\u662F\u5426\u4E3A\u7981\u7528\u72B6\u6001| boolean| false |\n| icon| \u56FE\u6807\u7EC4\u4EF6| string / Component| \u2014 |\n| autofocus| \u539F\u751F autofocus \u5C5E\u6027| boolean| false |\n| native-type| \u539F\u751F type \u5C5E\u6027| enum| button |\n| auto-insert-space| \u81EA\u52A8\u5728\u4E24\u4E2A\u4E2D\u6587\u5B57\u7B26\u4E4B\u95F4\u63D2\u5165\u7A7A\u683C| boolean| \u2014 |\n| color| \u81EA\u5B9A\u4E49\u6309\u94AE\u989C\u8272, \u5E76\u81EA\u52A8\u8BA1\u7B97 hover \u548C active \u89E6\u53D1\u540E\u7684\u989C\u8272| string| \u2014 |\n| dark| dark \u6A21\u5F0F, \u610F\u5473\u7740\u81EA\u52A8\u8BBE\u7F6E color \u4E3A dark \u6A21\u5F0F\u7684\u989C\u8272| boolean| false |\n| tag 2.3.4| \u81EA\u5B9A\u4E49\u5143\u7D20\u6807\u7B7E| string / Component| button |\n\n#### Button \u63D2\u69FD\n\n| \u63D2\u69FD\u540D| \u8BF4\u660E |\n| :--- | :--- |\n| default| \u81EA\u5B9A\u4E49\u9ED8\u8BA4\u5185\u5BB9 |\n| loading| \u81EA\u5B9A\u4E49\u52A0\u8F7D\u4E2D\u7EC4\u4EF6 |\n| icon| \u81EA\u5B9A\u4E49\u56FE\u6807\u7EC4\u4EF6 |\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| ref| \u6309\u94AE html \u5143\u7D20| object |\n| size| \u6309\u94AE\u5C3A\u5BF8| object |\n| type| \u6309\u94AE\u7C7B\u578B| object |\n| disabled| \u6309\u94AE\u5DF2\u7981\u7528| object |\n| shouldAddSpace| \u662F\u5426\u5728\u4E24\u4E2A\u5B57\u7B26\u4E4B\u95F4\u63D2\u5165\u7A7A\u683C| object |\n",
          "size": {
            "type": "attr",
            "values": ["large", "large", "small"],
            "description": "\u5C3A\u5BF8"
          },
          "type": {
            "type": "attr",
            "values": ["primary", "success", "warning", "danger", "info"],
            "description": "\u7C7B\u578B"
          },
          "plain": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u4E3A\u6734\u7D20\u6309\u94AE"
          },
          "text": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u4E3A\u6587\u5B57\u6309\u94AE"
          },
          "bg": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u663E\u793A\u6587\u5B57\u6309\u94AE\u80CC\u666F\u989C\u8272"
          },
          "link": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u4E3A\u94FE\u63A5\u6309\u94AE"
          },
          "round": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u4E3A\u5706\u89D2\u6309\u94AE"
          },
          "circle": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u4E3A\u5706\u5F62\u6309\u94AE"
          },
          "loading": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u4E3A\u52A0\u8F7D\u4E2D\u72B6\u6001"
          },
          "loading-icon": {
            "type": "attr",
            "values": [],
            "description": "\u81EA\u5B9A\u4E49\u52A0\u8F7D\u4E2D\u72B6\u6001\u56FE\u6807\u7EC4\u4EF6"
          },
          "disabled": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u6309\u94AE\u662F\u5426\u4E3A\u7981\u7528\u72B6\u6001"
          },
          "icon": {
            "type": "attr",
            "values": [],
            "description": "\u56FE\u6807\u7EC4\u4EF6"
          },
          "autofocus": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u539F\u751F autofocus \u5C5E\u6027"
          },
          "native-type": {
            "type": "attr",
            "values": ["button", "submit", "reset"],
            "description": "\u539F\u751F type \u5C5E\u6027"
          },
          "auto-insert-space": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u81EA\u52A8\u5728\u4E24\u4E2A\u4E2D\u6587\u5B57\u7B26\u4E4B\u95F4\u63D2\u5165\u7A7A\u683C"
          },
          "color": {
            "type": "attr",
            "values": [],
            "description": "\u81EA\u5B9A\u4E49\u6309\u94AE\u989C\u8272, \u5E76\u81EA\u52A8\u8BA1\u7B97 hover \u548C active \u89E6\u53D1\u540E\u7684\u989C\u8272"
          },
          "dark": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "dark \u6A21\u5F0F, \u610F\u5473\u7740\u81EA\u52A8\u8BBE\u7F6E color \u4E3A dark \u6A21\u5F0F\u7684\u989C\u8272"
          },
          "tag": {
            "type": "attr",
            "values": [],
            "description": "\u81EA\u5B9A\u4E49\u5143\u7D20\u6807\u7B7E"
          }
        },
        "el-button-group": {
          "_html": {
            "": '<el-button-group>\n<el-button type="primary">$1</el-button>\n<el-button type="primary">$2</el-button>\n</el-button-group>'
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/button.html)\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| size| \u7528\u4E8E\u63A7\u5236\u8BE5\u6309\u94AE\u7EC4\u5185\u6309\u94AE\u7684\u5927\u5C0F| enum| \u2014 |\n| type| \u7528\u4E8E\u63A7\u5236\u8BE5\u6309\u94AE\u7EC4\u5185\u6309\u94AE\u7684\u7C7B\u578B| enum| \u2014 |\n\n#### ButtonGroup \u63D2\u69FD\n\n| \u63D2\u69FD\u540D| \u8BF4\u660E| \u5B50\u6807\u7B7E |\n| :--- | :--- | :--- |\n| default| \u81EA\u5B9A\u4E49\u6309\u94AE\u7EC4\u5185\u5BB9| Button |\n\n#### \u6E90\u4EE3\u7801\n\n#### \u8D21\u732E\u8005\n",
          "size": {
            "type": "attr",
            "values": ["large", "large", "small"],
            "description": "\u7528\u4E8E\u63A7\u5236\u8BE5\u6309\u94AE\u7EC4\u5185\u6309\u94AE\u7684\u5927\u5C0F"
          },
          "type": {
            "type": "attr",
            "values": ["primary", "success", "warning", "danger", "info"],
            "description": "\u7528\u4E8E\u63A7\u5236\u8BE5\u6309\u94AE\u7EC4\u5185\u6309\u94AE\u7684\u7C7B\u578B"
          }
        },
        "el-container": {
          "_html": {
            "": "<el-container>$1</el-container>"
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/container.html)\n\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| direction| \u5B50\u5143\u7D20\u7684\u6392\u5217\u65B9\u5411| enum| \u5B50\u5143\u7D20\u4E2D\u6709 el-header \u6216 el-footer \u65F6\u4E3A vertical\uFF0C\u5426\u5219\u4E3A horizontal |\n\n#### Container \u63D2\u69FD\n\n| \u63D2\u69FD\u540D| \u8BF4\u660E| \u5B50\u6807\u7B7E |\n| :--- | :--- | :--- |\n| default| \u81EA\u5B9A\u4E49\u9ED8\u8BA4\u5185\u5BB9| Container / Header / Aside / Main / Footer |\n",
          "direction": {
            "type": "attr",
            "values": ["horizontal", "vertical"],
            "description": "\u5B50\u5143\u7D20\u7684\u6392\u5217\u65B9\u5411"
          }
        },
        "el-header": {
          "_html": {
            "": "<el-header>$1</el-header>"
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/container.html)\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| height| \u9876\u680F\u9AD8\u5EA6| string| 60px |\n\n#### Header Slots\n\n| \u63D2\u69FD\u540D| \u8BF4\u660E |\n| :--- | :--- |\n| default| \u81EA\u5B9A\u4E49\u9ED8\u8BA4\u5185\u5BB9 |\n",
          "height": {
            "type": "attr",
            "values": [],
            "description": "\u9876\u680F\u9AD8\u5EA6"
          }
        },
        "el-main": {
          "_html": {
            "": "<el-main>$1</el-main>"
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/container.html)\n\n#### Main Slots\n\n| \u63D2\u69FD\u540D| \u8BF4\u660E |\n| :--- | :--- |\n| default| \u81EA\u5B9A\u4E49\u9ED8\u8BA4\u5185\u5BB9 |\n"
        },
        "el-footer": {
          "_html": {
            "": "<el-footer>$1</el-footer>"
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/container.html)\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| height| \u5E95\u680F\u9AD8\u5EA6| string| 60px |\n\n#### Footer Slots\n\n| \u63D2\u69FD\u540D| \u8BF4\u660E |\n| :--- | :--- |\n| default| \u81EA\u5B9A\u4E49\u9ED8\u8BA4\u5185\u5BB9 |\n\n#### \u6E90\u4EE3\u7801\n\n#### \u8D21\u732E\u8005\n",
          "height": {
            "type": "attr",
            "values": [],
            "description": "\u5E95\u680F\u9AD8\u5EA6"
          }
        },
        "el-aside": {
          "_html": {
            "": '<el-aside width="200px">$1</el-aside>'
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/container.html)\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| width| \u4FA7\u8FB9\u680F\u5BBD\u5EA6| string| 300px |\n\n#### Aside Slots\n\n| \u63D2\u69FD\u540D| \u8BF4\u660E |\n| :--- | :--- |\n| default| \u81EA\u5B9A\u4E49\u9ED8\u8BA4\u5185\u5BB9 |\n",
          "width": {
            "type": "attr",
            "values": [],
            "description": "\u4FA7\u8FB9\u680F\u5BBD\u5EA6"
          }
        },
        "el-row": {
          "_html": {
            "": '<el-row>\n<el-col :span="${1:24}">$2</el-col>\n</el-row>'
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/layout.html)\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| gutter| \u6805\u683C\u95F4\u9694| number| 0 |\n| justify| flex \u5E03\u5C40\u4E0B\u7684\u6C34\u5E73\u6392\u5217\u65B9\u5F0F| enum| start |\n| align| flex \u5E03\u5C40\u4E0B\u7684\u5782\u76F4\u6392\u5217\u65B9\u5F0F| enum| \u2014 |\n| tag| \u81EA\u5B9A\u4E49\u5143\u7D20\u6807\u7B7E| string| div |\n\n#### Row Slots\n\n| \u63D2\u69FD\u540D| \u8BF4\u660E| \u5B50\u6807\u7B7E |\n| :--- | :--- | :--- |\n| default| \u81EA\u5B9A\u4E49\u9ED8\u8BA4\u5185\u5BB9| Col |\n",
          "gutter": {
            "type": "attr",
            "values": ["number"],
            "description": "\u6805\u683C\u95F4\u9694"
          },
          "justify": {
            "type": "attr",
            "values": ["start", "end", "center", "space-around", "space-between", "space-evenly"],
            "description": "flex \u5E03\u5C40\u4E0B\u7684\u6C34\u5E73\u6392\u5217\u65B9\u5F0F"
          },
          "align": {
            "type": "attr",
            "values": ["top", "middle", "bottom"],
            "description": "flex \u5E03\u5C40\u4E0B\u7684\u5782\u76F4\u6392\u5217\u65B9\u5F0F"
          },
          "tag": {
            "type": "attr",
            "values": [],
            "description": "\u81EA\u5B9A\u4E49\u5143\u7D20\u6807\u7B7E"
          }
        },
        "el-col": {
          "_html": {
            "": '<el-col :span="${1:8}">$2</el-col>'
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/layout.html)\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| span| \u6805\u683C\u5360\u636E\u7684\u5217\u6570| number| 24 |\n| offset| \u6805\u683C\u5DE6\u4FA7\u7684\u95F4\u9694\u683C\u6570| number| 0 |\n| push| \u6805\u683C\u5411\u53F3\u79FB\u52A8\u683C\u6570| number| 0 |\n| pull| \u6805\u683C\u5411\u5DE6\u79FB\u52A8\u683C\u6570| number| 0 |\n| xs| <768px \u54CD\u5E94\u5F0F\u6805\u683C\u6570\u6216\u8005\u6805\u683C\u5C5E\u6027\u5BF9\u8C61| number / object| \u2014 |\n| sm| \u2265768px \u54CD\u5E94\u5F0F\u6805\u683C\u6570\u6216\u8005\u6805\u683C\u5C5E\u6027\u5BF9\u8C61| number / object| \u2014 |\n| md| \u2265992px \u54CD\u5E94\u5F0F\u6805\u683C\u6570\u6216\u8005\u6805\u683C\u5C5E\u6027\u5BF9\u8C61| number / object| \u2014 |\n| lg| \u22651200px \u54CD\u5E94\u5F0F\u6805\u683C\u6570\u6216\u8005\u6805\u683C\u5C5E\u6027\u5BF9\u8C61| number / object| \u2014 |\n| xl| \u22651920px \u54CD\u5E94\u5F0F\u6805\u683C\u6570\u6216\u8005\u6805\u683C\u5C5E\u6027\u5BF9\u8C61| number / object| \u2014 |\n| tag| \u81EA\u5B9A\u4E49\u5143\u7D20\u6807\u7B7E| string| div |\n\n#### Col Slots\n\n| \u63D2\u69FD\u540D| \u8BF4\u660E |\n| :--- | :--- |\n| default| \u81EA\u5B9A\u4E49\u9ED8\u8BA4\u5185\u5BB9 |\n\n#### \u6E90\u4EE3\u7801\n",
          "span": {
            "type": "attr",
            "values": ["number"],
            "description": "\u6805\u683C\u5360\u636E\u7684\u5217\u6570"
          },
          "offset": {
            "type": "attr",
            "values": ["number"],
            "description": "\u6805\u683C\u5DE6\u4FA7\u7684\u95F4\u9694\u683C\u6570"
          },
          "push": {
            "type": "attr",
            "values": ["number"],
            "description": "\u6805\u683C\u5411\u53F3\u79FB\u52A8\u683C\u6570"
          },
          "pull": {
            "type": "attr",
            "values": ["number"],
            "description": "\u6805\u683C\u5411\u5DE6\u79FB\u52A8\u683C\u6570"
          },
          "xs": {
            "type": "attr",
            "values": ["number"],
            "description": "<768px \u54CD\u5E94\u5F0F\u6805\u683C\u6570\u6216\u8005\u6805\u683C\u5C5E\u6027\u5BF9\u8C61"
          },
          "sm": {
            "type": "attr",
            "values": ["number"],
            "description": "\u2265768px \u54CD\u5E94\u5F0F\u6805\u683C\u6570\u6216\u8005\u6805\u683C\u5C5E\u6027\u5BF9\u8C61"
          },
          "md": {
            "type": "attr",
            "values": ["number"],
            "description": "\u2265992px \u54CD\u5E94\u5F0F\u6805\u683C\u6570\u6216\u8005\u6805\u683C\u5C5E\u6027\u5BF9\u8C61"
          },
          "lg": {
            "type": "attr",
            "values": ["number"],
            "description": "\u22651200px \u54CD\u5E94\u5F0F\u6805\u683C\u6570\u6216\u8005\u6805\u683C\u5C5E\u6027\u5BF9\u8C61"
          },
          "xl": {
            "type": "attr",
            "values": ["number"],
            "description": "\u22651920px \u54CD\u5E94\u5F0F\u6805\u683C\u6570\u6216\u8005\u6805\u683C\u5C5E\u6027\u5BF9\u8C61"
          },
          "tag": {
            "type": "attr",
            "values": [],
            "description": "\u81EA\u5B9A\u4E49\u5143\u7D20\u6807\u7B7E"
          }
        },
        "el-link": {
          "_html": {
            "": '<el-link type="primary">$1</el-link>'
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/link.html)\n\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| type| \u7C7B\u578B| enum| default |\n| underline| \u662F\u5426\u4E0B\u5212\u7EBF| boolean| true |\n| disabled| \u662F\u5426\u7981\u7528\u72B6\u6001| boolean| false |\n| href| \u539F\u751F href \u5C5E\u6027| string| \u2014 |\n| target| \u540C\u539F\u751F target \u5C5E\u6027| enum| _self |\n| icon| \u56FE\u6807\u7EC4\u4EF6| string / Component| \u2014 |\n\n#### Slots\n\n| \u63D2\u69FD\u540D| \u8BF4\u660E |\n| :--- | :--- |\n| default| \u81EA\u5B9A\u4E49\u9ED8\u8BA4\u5185\u5BB9 |\n| icon| \u81EA\u5B9A\u4E49\u56FE\u6807\u7EC4\u4EF6 |\n\n#### \u6E90\u4EE3\u7801\n\n#### \u8D21\u732E\u8005\n",
          "type": {
            "type": "attr",
            "values": ["primary", "success", "warning", "danger", "info", "default"],
            "description": "\u7C7B\u578B"
          },
          "underline": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u4E0B\u5212\u7EBF"
          },
          "disabled": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u7981\u7528\u72B6\u6001"
          },
          "href": {
            "type": "attr",
            "values": [],
            "description": "\u539F\u751F href \u5C5E\u6027"
          },
          "target": {
            "type": "attr",
            "values": ["_blank", "_parent", "_self", "_top"],
            "description": "\u540C\u539F\u751F target \u5C5E\u6027"
          },
          "icon": {
            "type": "attr",
            "values": [],
            "description": "\u56FE\u6807\u7EC4\u4EF6"
          }
        },
        "el-text": {
          "_html": {
            "": "<el-text>$1</el-text>",
            ":truncated": "<el-text truncated>$1</el-text>"
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/text.html)\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u63CF\u8FF0| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| type| \u7C7B\u578B| enum| \u2014 |\n| size| \u5927\u5C0F| enum| default |\n| truncated| \u663E\u793A\u7701\u7565\u53F7| boolean| false |\n| line-clamp 2.4.0| \u6700\u5927\u884C\u6570| string / number| - |\n| tag| \u81EA\u5B9A\u4E49\u5143\u7D20\u6807\u7B7E| string| span |\n\n#### Slots\n\n| \u540D\u79F0| \u8BE6\u60C5 |\n| :--- | :--- |\n| default| \u9ED8\u8BA4\u5185\u5BB9 |\n\n#### \u6E90\u4EE3\u7801\n\n#### \u8D21\u732E\u8005\n",
          "type": {
            "type": "attr",
            "values": ["primary", "success", "warning", "danger", "info"],
            "description": "\u7C7B\u578B"
          },
          "size": {
            "type": "attr",
            "values": ["large", "default", "small"],
            "description": "\u5927\u5C0F"
          },
          "truncated": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u663E\u793A\u7701\u7565\u53F7"
          },
          "line-clamp": {
            "type": "attr",
            "values": [],
            "description": "\u6700\u5927\u884C\u6570"
          },
          "tag": {
            "type": "attr",
            "values": [],
            "description": "\u81EA\u5B9A\u4E49\u5143\u7D20\u6807\u7B7E"
          }
        },
        "el-scrollbar": {
          "_html": {
            "": '<el-scrollbar height="${1:400px}" @scroll="${2:scroll}">\n$3\n</el-scrollbar>'
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/scrollbar.html)\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| height| \u6EDA\u52A8\u6761\u9AD8\u5EA6| string / number| \u2014 |\n| max-height| \u6EDA\u52A8\u6761\u6700\u5927\u9AD8\u5EA6| string / number| \u2014 |\n| native| \u662F\u5426\u4F7F\u7528\u539F\u751F\u6EDA\u52A8\u6761\u6837\u5F0F| boolean| false |\n| wrap-style| \u5305\u88F9\u5BB9\u5668\u7684\u81EA\u5B9A\u4E49\u6837\u5F0F| string / object| \u2014 |\n| wrap-class| \u5305\u88F9\u5BB9\u5668\u7684\u81EA\u5B9A\u4E49\u7C7B\u540D| string| \u2014 |\n| view-style| \u89C6\u56FE\u7684\u81EA\u5B9A\u4E49\u6837\u5F0F| string / object| \u2014 |\n| view-class| \u89C6\u56FE\u7684\u81EA\u5B9A\u4E49\u7C7B\u540D| string| \u2014 |\n| noresize| \u4E0D\u54CD\u5E94\u5BB9\u5668\u5C3A\u5BF8\u53D8\u5316\uFF0C\u5982\u679C\u5BB9\u5668\u5C3A\u5BF8\u4E0D\u4F1A\u53D1\u751F\u53D8\u5316\uFF0C\u6700\u597D\u8BBE\u7F6E\u5B83\u53EF\u4EE5\u4F18\u5316\u6027\u80FD| boolean| false |\n| tag| \u89C6\u56FE\u7684\u5143\u7D20\u6807\u7B7E| string| div |\n| always| \u6EDA\u52A8\u6761\u603B\u662F\u663E\u793A| boolean| false |\n| min-size| \u6EDA\u52A8\u6761\u6700\u5C0F\u5C3A\u5BF8| number| 20 |\n| id 2.4.0| \u89C6\u56FEID| string| \u2014 |\n| role 2.4.0 a11y| \u89C6\u56FE\u7684\u89D2\u8272| string| \u2014 |\n| aria-label 2.4.0 a11y| \u89C6\u56FE\u7684 aria-label| string| \u2014 |\n| aria-orientation 2.4.0 a11y| \u89C6\u56FE\u7684 aria-orientation| enum| \u2014 |\n#### \u4E8B\u4EF6\n\n| \u4E8B\u4EF6\u540D| \u8BF4\u660E| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| scroll| \u5F53\u89E6\u53D1\u6EDA\u52A8\u4E8B\u4EF6\u65F6\uFF0C\u8FD4\u56DE\u6EDA\u52A8\u7684\u8DDD\u79BB| Function |\n\n#### Slots\n\n| \u63D2\u69FD\u540D| \u8BF4\u660E |\n| :--- | :--- |\n| default| \u81EA\u5B9A\u4E49\u9ED8\u8BA4\u5185\u5BB9 |\n\n#### Exposes\n\n| \u540D\u79F0| \u8BF4\u660E| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| handleScroll| \u89E6\u53D1\u6EDA\u52A8\u4E8B\u4EF6| Function |\n| scrollTo| \u6EDA\u52A8\u5230\u4E00\u7EC4\u7279\u5B9A\u5750\u6807| Function |\n| setScrollTop| \u8BBE\u7F6E\u6EDA\u52A8\u6761\u5230\u9876\u90E8\u7684\u8DDD\u79BB| Function |\n| setScrollLeft| \u8BBE\u7F6E\u6EDA\u52A8\u6761\u5230\u5DE6\u8FB9\u7684\u8DDD\u79BB| Function |\n| update| \u624B\u52A8\u66F4\u65B0\u6EDA\u52A8\u6761\u72B6\u6001| Function |\n| wrapRef| \u6EDA\u52A8\u6761\u5305\u88F9\u7684 ref \u5BF9\u8C61| object |\n\n#### \u6E90\u4EE3\u7801\n\n#### \u8D21\u732E\u8005\n",
          "height": {
            "type": "attr",
            "values": [],
            "description": "\u6EDA\u52A8\u6761\u9AD8\u5EA6"
          },
          "max-height": {
            "type": "attr",
            "values": [],
            "description": "\u6EDA\u52A8\u6761\u6700\u5927\u9AD8\u5EA6"
          },
          "native": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u4F7F\u7528\u539F\u751F\u6EDA\u52A8\u6761\u6837\u5F0F"
          },
          "wrap-style": {
            "type": "attr",
            "values": [],
            "description": "\u5305\u88F9\u5BB9\u5668\u7684\u81EA\u5B9A\u4E49\u6837\u5F0F"
          },
          "wrap-class": {
            "type": "attr",
            "values": [],
            "description": "\u5305\u88F9\u5BB9\u5668\u7684\u81EA\u5B9A\u4E49\u7C7B\u540D"
          },
          "view-style": {
            "type": "attr",
            "values": [],
            "description": "\u89C6\u56FE\u7684\u81EA\u5B9A\u4E49\u6837\u5F0F"
          },
          "view-class": {
            "type": "attr",
            "values": [],
            "description": "\u89C6\u56FE\u7684\u81EA\u5B9A\u4E49\u7C7B\u540D"
          },
          "noresize": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u4E0D\u54CD\u5E94\u5BB9\u5668\u5C3A\u5BF8\u53D8\u5316\uFF0C\u5982\u679C\u5BB9\u5668\u5C3A\u5BF8\u4E0D\u4F1A\u53D1\u751F\u53D8\u5316\uFF0C\u6700\u597D\u8BBE\u7F6E\u5B83\u53EF\u4EE5\u4F18\u5316\u6027\u80FD"
          },
          "tag": {
            "type": "attr",
            "values": [],
            "description": "\u89C6\u56FE\u7684\u5143\u7D20\u6807\u7B7E"
          },
          "always": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u6EDA\u52A8\u6761\u603B\u662F\u663E\u793A"
          },
          "min-size": {
            "type": "attr",
            "values": ["number"],
            "description": "\u6EDA\u52A8\u6761\u6700\u5C0F\u5C3A\u5BF8"
          },
          "id": {
            "type": "attr",
            "values": [],
            "description": "\u89C6\u56FEID"
          },
          "roleay": {
            "type": "attr",
            "values": [],
            "description": "\u89C6\u56FE\u7684\u89D2\u8272"
          },
          "aria-labelay": {
            "type": "attr",
            "values": [],
            "description": "\u89C6\u56FE\u7684 aria-label"
          },
          "aria-orientationay": {
            "type": "attr",
            "values": ["enum"],
            "description": "\u89C6\u56FE\u7684 aria-orientation"
          },
          "scroll": {
            "type": "event",
            "values": [],
            "description": "\u5F53\u89E6\u53D1\u6EDA\u52A8\u4E8B\u4EF6\u65F6\uFF0C\u8FD4\u56DE\u6EDA\u52A8\u7684\u8DDD\u79BB"
          }
        },
        "el-space": {
          "_html": {
            "": "<el-space wrap>\n$1\n</el-space>",
            ":vertical": '<el-space direction="vertical">\n$1\n</el-space>',
            ":size": '<el-space :size="${1:size}">\n$2\n</el-space>',
            ":spacer": '<el-space spacer="${1:|}">\n$2\n</el-space>',
            ":fill": '<el-space :fill="${1:fill}" wrap>\n$2\n</el-space>'
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/space.html)\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| alignment| \u5BF9\u9F50\u7684\u65B9\u5F0F| enum align-items| center |\n| class| \u7C7B\u540D| string / object / array| \u2014 |\n| direction| \u6392\u5217\u7684\u65B9\u5411| enum| horizontal |\n| prefix-cls| \u7ED9 space-items \u7684\u7C7B\u540D\u524D\u7F00| string| \u2014 |\n| style| \u989D\u5916\u6837\u5F0F| string / object| \u2014 |\n| spacer| \u95F4\u9694\u7B26| string / number / VNode| \u2014 |\n| size| \u95F4\u9694\u5927\u5C0F| enum / number / array| small |\n| wrap| \u8BBE\u7F6E\u662F\u5426\u81EA\u52A8\u6298\u884C| boolean| false |\n| fill| \u5B50\u5143\u7D20\u662F\u5426\u586B\u5145\u7236\u5BB9\u5668| boolean| false |\n| fill-ratio| \u586B\u5145\u7236\u5BB9\u5668\u7684\u6BD4\u4F8B| number| 100 |\n\n#### Slots\n\n| \u540D\u79F0| \u8BF4\u660E |\n| :--- | :--- |\n| default| \u9700\u8981\u6DFB\u52A0\u95F4\u9694\u7684\u5143\u7D20 |\n\n#### \u6E90\u4EE3\u7801\n\n#### \u8D21\u732E\u8005\n",
          "alignment": {
            "type": "attr",
            "values": ["stretch", "center", "normal", "start", "end"],
            "description": "\u5BF9\u9F50\u7684\u65B9\u5F0F"
          },
          "class": {
            "type": "attr",
            "values": [],
            "description": "\u7C7B\u540D"
          },
          "direction": {
            "type": "attr",
            "values": ["vertical", "horizontal"],
            "description": "\u6392\u5217\u7684\u65B9\u5411"
          },
          "prefix-cls": {
            "type": "attr",
            "values": [],
            "description": "\u7ED9 space-items \u7684\u7C7B\u540D\u524D\u7F00"
          },
          "style": {
            "type": "attr",
            "values": [],
            "description": "\u989D\u5916\u6837\u5F0F"
          },
          "spacer": {
            "type": "attr",
            "values": [],
            "description": "\u95F4\u9694\u7B26"
          },
          "size": {
            "type": "attr",
            "values": ["default", "small", "large"],
            "description": "\u95F4\u9694\u5927\u5C0F"
          },
          "wrap": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u8BBE\u7F6E\u662F\u5426\u81EA\u52A8\u6298\u884C"
          },
          "fill": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u5B50\u5143\u7D20\u662F\u5426\u586B\u5145\u7236\u5BB9\u5668"
          },
          "fill-ratio": {
            "type": "attr",
            "values": ["number"],
            "description": "\u586B\u5145\u7236\u5BB9\u5668\u7684\u6BD4\u4F8B"
          }
        },
        "el-config-provider": {
          "_html": {
            "": '<el-config-provider :locale="${1:locale}">\n$2\n</el-config-provider>'
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/config-provider.html)\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| locale| \u7FFB\u8BD1\u6587\u672C\u5BF9\u8C61| object languages| en |\n| size| \u5168\u5C40\u7EC4\u4EF6\u5927\u5C0F| enum| default |\n| zIndex| \u5168\u5C40\u521D\u59CB\u5316 zIndex \u7684\u503C| number| \u2014 |\n| namespace| \u5168\u5C40\u7EC4\u4EF6\u7C7B\u540D\u79F0\u524D\u7F00 (\u9700\u8981\u914D\u5408 namespace \u4F7F\u7528)| string| el |\n| button| \u6309\u94AE\u76F8\u5173\u914D\u7F6E\uFF0C\u8BE6\u89C1\u4E0B\u8868| object| \u8BE6\u89C1\u4E0B\u8868 |\n| message| \u6D88\u606F\u76F8\u5173\u914D\u7F6E\uFF0C \u8BE6\u89C1\u4E0B\u8868| object| \u8BE6\u89C1\u4E0B\u8868 |\n| experimental-features| \u5C06\u8981\u6DFB\u52A0\u7684\u5B9E\u9A8C\u9636\u6BB5\u7684\u529F\u80FD\uFF0C\u6240\u6709\u529F\u80FD\u90FD\u662F\u9ED8\u8BA4\u8BBE\u7F6E\u4E3A false| object| \u2014 |\n\n#### Button Attribute\n\n| \u53C2\u6570| \u63CF\u8FF0| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| autoInsertSpace| \u81EA\u52A8\u5728\u4E24\u4E2A\u4E2D\u6587\u5B57\u7B26\u4E4B\u95F4\u63D2\u5165\u7A7A\u683C| boolean| false |\n\n#### Message Attribute\n\n| \u53C2\u6570| \u63CF\u8FF0| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| max| \u53EF\u540C\u65F6\u663E\u793A\u7684\u6D88\u606F\u6700\u5927\u6570\u91CF| number| \u2014 |\n\n#### Config Provider Slots\n\n| \u540D\u79F0| \u63CF\u8FF0| Scope |\n| :--- | :--- | :--- |\n| default| \u81EA\u5B9A\u4E49\u9ED8\u8BA4\u5185\u5BB9| config: \u63D0\u4F9B\u5168\u5C40\u914D\u7F6E\uFF08\u4ECE\u9876\u90E8\u7EE7\u627F\uFF09 |\n\n#### \u6E90\u4EE3\u7801\n\n#### \u8D21\u732E\u8005\n",
          "locale": {
            "type": "attr",
            "values": ["object"],
            "description": "\u7FFB\u8BD1\u6587\u672C\u5BF9\u8C61"
          },
          "size": {
            "type": "attr",
            "values": ["large", "default", "small"],
            "description": "\u5168\u5C40\u7EC4\u4EF6\u5927\u5C0F"
          },
          "zIndex": {
            "type": "attr",
            "values": ["number"],
            "description": "\u5168\u5C40\u521D\u59CB\u5316 zIndex \u7684\u503C"
          },
          "namespace": {
            "type": "attr",
            "values": [],
            "description": "\u5168\u5C40\u7EC4\u4EF6\u7C7B\u540D\u79F0\u524D\u7F00 (\u9700\u8981\u914D\u5408 $namespace \u4F7F\u7528)"
          },
          "button": {
            "type": "attr",
            "values": ["object"],
            "description": "\u6309\u94AE\u76F8\u5173\u914D\u7F6E\uFF0C\u8BE6\u89C1\u4E0B\u8868"
          },
          "message": {
            "type": "attr",
            "values": ["object"],
            "description": "\u6D88\u606F\u76F8\u5173\u914D\u7F6E\uFF0C \u8BE6\u89C1\u4E0B\u8868"
          },
          "experimental-features": {
            "type": "attr",
            "values": ["object"],
            "description": "\u5C06\u8981\u6DFB\u52A0\u7684\u5B9E\u9A8C\u9636\u6BB5\u7684\u529F\u80FD\uFF0C\u6240\u6709\u529F\u80FD\u90FD\u662F\u9ED8\u8BA4\u8BBE\u7F6E\u4E3A false"
          },
          "empty-values": {
            "type": "attr",
            "values": ["array"],
            "description": "\u8F93\u5165\u7C7B\u7EC4\u4EF6\u7A7A\u503C"
          },
          "value-on-clear": {
            "type": "attr",
            "values": [],
            "description": "\u8F93\u5165\u7C7B\u7EC4\u4EF6\u6E05\u7A7A\u503C"
          }
        },
        "el-autocomplete": {
          "_html": {
            "": '<el-autocomplete v-model="${1:value}" :fetch-suggestions="querySearch" clearable placeholder="Please Input" @select="handleSelect" />',
            ":template": '<el-autocomplete\nv-model="${1:value}"\n:fetch-suggestions="querySearch"\nplaceholder="Please Input"\n@select="handleSelect"\n>\n<template #default="{ item }">\n</template>\n</el-autocomplete>'
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/autocomplete.html)\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| model-value / v-model| \u9009\u4E2D\u9879\u7ED1\u5B9A\u503C| string| \u2014 |\n| placeholder| \u5360\u4F4D\u6587\u672C| string| \u2014 |\n| clearable| \u662F\u5426\u53EF\u6E05\u7A7A| boolean| false |\n| disabled| \u81EA\u52A8\u8865\u5168\u7EC4\u4EF6\u662F\u5426\u88AB\u7981\u7528| boolean| false |\n| value-key| \u8F93\u5165\u5EFA\u8BAE\u5BF9\u8C61\u4E2D\u7528\u4E8E\u663E\u793A\u7684\u952E\u540D| string| value |\n| debounce| \u83B7\u53D6\u8F93\u5165\u5EFA\u8BAE\u7684\u9632\u6296\u5EF6\u65F6\uFF0C\u5355\u4F4D\u4E3A\u6BEB\u79D2| number| 300 |\n| placement| \u83DC\u5355\u5F39\u51FA\u4F4D\u7F6E| enum| bottom-start |\n| fetch-suggestions| \u83B7\u53D6\u8F93\u5165\u5EFA\u8BAE\u7684\u65B9\u6CD5\uFF0C \u4EC5\u5F53\u4F60\u7684\u8F93\u5165\u5EFA\u8BAE\u6570\u636E resolve \u65F6\uFF0C\u901A\u8FC7\u8C03\u7528 callback(data:[])  \u6765\u8FD4\u56DE\u5B83| Function| \u2014 |\n| trigger-on-focus| whether show suggestions when input focus| boolean| true |\n| select-when-unmatched| \u5728\u8F93\u5165\u6CA1\u6709\u4EFB\u4F55\u5339\u914D\u5EFA\u8BAE\u7684\u60C5\u51B5\u4E0B\uFF0C\u6309\u4E0B\u56DE\u8F66\u662F\u5426\u89E6\u53D1 select \u4E8B\u4EF6| boolean| false |\n| name| \u7B49\u4EF7\u4E8E\u539F\u751F input name \u5C5E\u6027| string| \u2014 |\n| label| \u8F93\u5165\u6846\u5173\u8054\u7684 label \u6587\u5B57| string| \u2014 |\n| hide-loading| \u662F\u5426\u9690\u85CF\u8FDC\u7A0B\u52A0\u8F7D\u65F6\u7684\u52A0\u8F7D\u56FE\u6807| boolean| false |\n| popper-class| \u4E0B\u62C9\u5217\u8868\u7684\u7C7B\u540D| string| \u2014 |\n| popper-append-to-body deprecated| \u662F\u5426\u5C06\u4E0B\u62C9\u5217\u8868\u63D2\u5165\u81F3 body \u5143\u7D20\u3002 \u5728\u4E0B\u62C9\u5217\u8868\u7684\u5B9A\u4F4D\u51FA\u73B0\u95EE\u9898\u65F6\uFF0C\u53EF\u5C06\u8BE5\u5C5E\u6027\u8BBE\u7F6E\u4E3A false| boolean| false |\n| teleported| \u662F\u5426\u5C06\u4E0B\u62C9\u5217\u8868\u5143\u7D20\u63D2\u5165 append-to \u6307\u5411\u7684\u5143\u7D20\u4E0B| boolean| true |\n| highlight-first-item| \u662F\u5426\u9ED8\u8BA4\u9AD8\u4EAE\u8FDC\u7A0B\u641C\u7D22\u7ED3\u679C\u7684\u7B2C\u4E00\u9879| boolean| false |\n| fit-input-width| \u4E0B\u62C9\u6846\u7684\u5BBD\u5EA6\u662F\u5426\u4E0E\u8F93\u5165\u6846\u76F8\u540C| boolean| false |\n#### \u4E8B\u4EF6\n\n| \u4E8B\u4EF6\u540D| \u8BE6\u60C5| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| select| \u70B9\u51FB\u9009\u4E2D\u5EFA\u8BAE\u9879\u65F6\u89E6\u53D1| Function |\n| change| \u5728 Input \u503C\u6539\u53D8\u65F6\u89E6\u53D1| Function |\n\n#### Slots\n\n| \u63D2\u69FD\u540D| \u63CF\u8FF0\u8BF4\u660E| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| default| \u81EA\u5B9A\u4E49\u8F93\u5165\u5EFA\u8BAE\u7684\u5185\u5BB9\u3002| object |\n| prefix| \u8F93\u5165\u6846\u5934\u90E8\u5185\u5BB9| - |\n| suffix| \u8F93\u5165\u6846\u5C3E\u90E8\u5185\u5BB9| - |\n| prepend| \u8F93\u5165\u6846\u524D\u7F6E\u5185\u5BB9\uFF0C\u5728 prefix \u4E4B\u524D| - |\n| append| \u8F93\u5165\u6846\u540E\u7F6E\u5185\u5BB9\uFF0C\u5728 suffix \u4E4B\u540E| - |\n| loading 2.5.0| \u4FEE\u6539\u52A0\u8F7D\u533A\u57DF\u5185\u5BB9| - |\n\n#### Exposes\n\n| \u540D\u79F0| \u8BE6\u60C5| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| activated| \u81EA\u52A8\u8865\u5168\u8F93\u5165\u6846\u662F\u5426\u88AB\u6FC0\u6D3B| object |\n| blur| \u4F7F input \u5931\u53BB\u7126\u70B9| Function |\n| close| \u6298\u53E0\u5EFA\u8BAE\u5217\u8868| Function |\n| focus| \u4F7F input \u83B7\u53D6\u7126\u70B9| Function |\n| handleSelect| \u624B\u52A8\u89E6\u53D1\u9009\u4E2D\u5EFA\u8BAE\u4E8B\u4EF6| Function |\n| handleKeyEnter| \u624B\u52A8\u89E6\u53D1\u952E\u76D8\u56DE\u8F66\u4E8B\u4EF6| Function |\n| highlightedIndex| \u5F53\u524D\u9AD8\u4EAE\u663E\u793A\u9009\u9879\u7684\u7D22\u5F15| object |\n| highlight| \u5728\u5EFA\u8BAE\u4E2D\u9AD8\u4EAE\u663E\u793A\u4E00\u4E2A\u9879\u76EE| Function |\n| inputRef| el-input \u7EC4\u4EF6\u5B9E\u4F8B| object |\n| loading| \u8FDC\u7A0B\u83B7\u53D6\u63D0\u793A\u5185\u5BB9\u7684\u52A0\u8F7D\u72B6\u6001\u6307\u793A\u5668| object |\n| popperRef| el-tooltip \u7EC4\u4EF6\u5B9E\u4F8B| object |\n| suggestions| \u83B7\u53D6\u81EA\u52A8\u8865\u5168\u7ED3\u679C| object |\n\n#### \u6E90\u4EE3\u7801\n\n#### \u8D21\u732E\u8005\n",
          "v-model": {
            "type": "attr",
            "values": [],
            "description": "\u9009\u4E2D\u9879\u7ED1\u5B9A\u503C"
          },
          "placeholder": {
            "type": "attr",
            "values": [],
            "description": "\u5360\u4F4D\u6587\u672C"
          },
          "clearable": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u53EF\u6E05\u7A7A"
          },
          "disabled": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u81EA\u52A8\u8865\u5168\u7EC4\u4EF6\u662F\u5426\u88AB\u7981\u7528"
          },
          "value-key": {
            "type": "attr",
            "values": [],
            "description": "\u8F93\u5165\u5EFA\u8BAE\u5BF9\u8C61\u4E2D\u7528\u4E8E\u663E\u793A\u7684\u952E\u540D"
          },
          "debounce": {
            "type": "attr",
            "values": ["number"],
            "description": "\u83B7\u53D6\u8F93\u5165\u5EFA\u8BAE\u7684\u9632\u6296\u5EF6\u65F6\uFF0C\u5355\u4F4D\u4E3A\u6BEB\u79D2"
          },
          "placement": {
            "type": "attr",
            "values": ["top", "top- start", "top-end", "bottom", "bottom-start", "bottom-end"],
            "description": "\u83DC\u5355\u5F39\u51FA\u4F4D\u7F6E"
          },
          "fetch-suggestions": {
            "type": "attr",
            "values": ["Function"],
            "description": "\u83B7\u53D6\u8F93\u5165\u5EFA\u8BAE\u7684\u65B9\u6CD5\uFF0C \u4EC5\u5F53\u4F60\u7684\u8F93\u5165\u5EFA\u8BAE\u6570\u636E resolve \u65F6\uFF0C\u901A\u8FC7\u8C03\u7528 callback(data:[])  \u6765\u8FD4\u56DE\u5B83"
          },
          "trigger-on-focus": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "whether show suggestions when input focus"
          },
          "select-when-unmatched": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u5728\u8F93\u5165\u6CA1\u6709\u4EFB\u4F55\u5339\u914D\u5EFA\u8BAE\u7684\u60C5\u51B5\u4E0B\uFF0C\u6309\u4E0B\u56DE\u8F66\u662F\u5426\u89E6\u53D1 select \u4E8B\u4EF6"
          },
          "name": {
            "type": "attr",
            "values": [],
            "description": "\u7B49\u4EF7\u4E8E\u539F\u751F input name \u5C5E\u6027"
          },
          "aria-labelay": {
            "type": "attr",
            "values": [],
            "description": "\u539F\u751F aria-label\u5C5E\u6027"
          },
          "hide-loading": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u9690\u85CF\u8FDC\u7A0B\u52A0\u8F7D\u65F6\u7684\u52A0\u8F7D\u56FE\u6807"
          },
          "popper-class": {
            "type": "attr",
            "values": [],
            "description": "\u4E0B\u62C9\u5217\u8868\u7684\u7C7B\u540D"
          },
          "popper-append-to-bodydeprecated": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u5C06\u4E0B\u62C9\u5217\u8868\u63D2\u5165\u81F3 body \u5143\u7D20\u3002 \u5728\u4E0B\u62C9\u5217\u8868\u7684\u5B9A\u4F4D\u51FA\u73B0\u95EE\u9898\u65F6\uFF0C\u53EF\u5C06\u8BE5\u5C5E\u6027\u8BBE\u7F6E\u4E3A false"
          },
          "teleported": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u5C06\u4E0B\u62C9\u5217\u8868\u5143\u7D20\u63D2\u5165 append-to \u6307\u5411\u7684\u5143\u7D20\u4E0B"
          },
          "highlight-first-item": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u9ED8\u8BA4\u9AD8\u4EAE\u8FDC\u7A0B\u641C\u7D22\u7ED3\u679C\u7684\u7B2C\u4E00\u9879"
          },
          "fit-input-width": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u4E0B\u62C9\u6846\u7684\u5BBD\u5EA6\u662F\u5426\u4E0E\u8F93\u5165\u6846\u76F8\u540C"
          },
          "select": {
            "type": "event",
            "values": [],
            "description": "\u70B9\u51FB\u9009\u4E2D\u5EFA\u8BAE\u9879\u65F6\u89E6\u53D1"
          },
          "change": {
            "type": "event",
            "values": [],
            "description": "\u5728 Input \u503C\u6539\u53D8\u65F6\u89E6\u53D1"
          }
        },
        "el-cascader": {
          "_html": {
            "": '<el-cascader v-model="${1:value}" :options="options" @change="handleChange" clearable filterable />',
            ":last-level": '<el-cascader v-model="${1:value}" :options="options" @change="handleChange" clearable filterable :show-all-levels="false" />',
            ":multiple": '<el-cascader v-model="${1:value}" :options="options" @change="handleChange" clearable filterable :props="{ multiple: true }" />',
            ":strictly": '<el-cascader v-model="${1:value}" :options="options" @change="handleChange" clearable filterable :props="{ checkStrictly: true }" />'
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/cascader.html)\n\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| model-value / v-model| \u9009\u4E2D\u9879\u7ED1\u5B9A\u503C| string/number/object| \u2014 |\n| options| \u9009\u9879\u7684\u6570\u636E\u6E90\uFF0C value \u548C label \u53EF\u4EE5\u901A\u8FC7 CascaderProps \u81EA\u5B9A\u4E49.| object| \u2014 |\n| props| \u914D\u7F6E\u9009\u9879, \u8BF7\u53C2\u9605\u4E0B\u9762 CascaderProps \u8868\u3002| object| \u2014 |\n| size| \u5C3A\u5BF8| enum| \u2014 |\n| placeholder| \u8F93\u5165\u6846\u5360\u4F4D\u6587\u672C| string| \u2014 |\n| disabled| \u662F\u5426\u7981\u7528| boolean| \u2014 |\n| clearable| \u662F\u5426\u652F\u6301\u6E05\u7A7A\u9009\u9879| boolean| \u2014 |\n| show-all-levels| \u8F93\u5165\u6846\u4E2D\u662F\u5426\u663E\u793A\u9009\u4E2D\u503C\u7684\u5B8C\u6574\u8DEF\u5F84| boolean| true |\n| collapse-tags| \u591A\u9009\u6A21\u5F0F\u4E0B\u662F\u5426\u6298\u53E0Tag| boolean| \u2014 |\n| collapse-tags-tooltip| \u5F53\u9F20\u6807\u60AC\u505C\u4E8E\u6298\u53E0\u6807\u7B7E\u7684\u6587\u672C\u65F6\uFF0C\u662F\u5426\u663E\u793A\u6240\u6709\u9009\u4E2D\u7684\u6807\u7B7E\u3002 \u8981\u4F7F\u7528\u6B64\u5C5E\u6027\uFF0Ccollapse-tags\u5C5E\u6027\u5FC5\u987B\u8BBE\u5B9A\u4E3A true| boolean| false |\n| separator| \u7528\u4E8E\u5206\u9694\u9009\u9879\u7684\u5B57\u7B26| string| ' / ' |\n| filterable| \u8BE5\u9009\u9879\u662F\u5426\u53EF\u4EE5\u88AB\u641C\u7D22| boolean| \u2014 |\n| filter-method| \u81EA\u5B9A\u4E49\u641C\u7D22\u903B\u8F91\uFF0C\u7B2C\u4E00\u4E2A\u53C2\u6570\u662Fnode\uFF0C\u7B2C\u4E8C\u4E2A\u53C2\u6570\u662Fkeyword\uFF0C\u8FD4\u56DE\u7684\u5E03\u5C14\u503C\u8868\u793A\u662F\u5426\u4FDD\u7559\u8BE5\u9009\u9879| Function| \u2014 |\n| debounce| \u641C\u7D22\u5173\u952E\u8BCD\u6B63\u5728\u8F93\u5165\u65F6\u7684\u53BB\u6296\u5EF6\u8FDF\uFF0C\u5355\u4F4D\u4E3A\u6BEB\u79D2| number| 300 |\n| before-filter| \u8FC7\u6EE4\u51FD\u6570\u8C03\u7528\u524D\uFF0C\u6240\u8981\u8C03\u7528\u7684\u94A9\u5B50\u51FD\u6570\uFF0C\u8BE5\u51FD\u6570\u63A5\u6536\u8981\u8FC7\u6EE4\u7684\u503C\u4F5C\u4E3A\u53C2\u6570\u3002 \u5982\u679C\u8BE5\u51FD\u6570\u7684\u8FD4\u56DE\u503C\u662F false \u6216\u8005\u662F\u4E00\u4E2A\u88AB\u62D2\u7EDD\u7684 Promise\uFF0C\u90A3\u4E48\u63A5\u4E0B\u6765\u7684\u8FC7\u6EE4\u903B\u8F91\u4FBF\u4E0D\u4F1A\u6267\u884C\u3002| Function| \u2014 |\n| popper-class| \u5F39\u51FA\u5185\u5BB9\u7684\u81EA\u5B9A\u4E49\u7C7B\u540D| string| '' |\n| teleported| \u5F39\u5C42\u662F\u5426\u4F7F\u7528 teleport| boolean| true |\n| popper-append-to-body deprecated| \u662F\u5426\u5C06\u5F39\u51FA\u7684\u5185\u5BB9\u76F4\u63A5\u63D2\u5165\u5230 body \u5143\u7D20\u3002 \u5728\u5F39\u51FA\u5185\u5BB9\u7684\u8FB9\u6846\u5B9A\u4F4D\u51FA\u73B0\u95EE\u9898\u65F6\uFF0C\u53EF\u5C06\u8BE5\u5C5E\u6027\u8BBE\u7F6E\u4E3A false| boolean| true |\n| tag-type| \u6807\u7B7E\u7C7B\u578B| enum| info |\n| validate-event| \u8F93\u5165\u65F6\u662F\u5426\u89E6\u53D1\u8868\u5355\u7684\u6821\u9A8C| boolean| true |\n| max-collapse-tags 2.3.10| \u9700\u8981\u663E\u793A\u7684 Tag \u7684\u6700\u5927\u6570\u91CF \u53EA\u6709\u5F53 collapse-tags \u8BBE\u7F6E\u4E3A true \u65F6\u624D\u4F1A\u751F\u6548\u3002| number| 1 |\n#### \u4E8B\u4EF6\n\n| \u4E8B\u4EF6\u540D| \u8BF4\u660E| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| change| \u5F53\u7ED1\u5B9A\u503C\u53D8\u5316\u65F6\u89E6\u53D1\u7684\u4E8B\u4EF6| Function |\n| expand-change| \u5F53\u5C55\u5F00\u8282\u70B9\u53D1\u751F\u53D8\u5316\u65F6\u89E6\u53D1| Function |\n| blur| \u5F53\u5931\u53BB\u7126\u70B9\u65F6\u89E6\u53D1| Function |\n| focus| \u5F53\u83B7\u5F97\u7126\u70B9\u65F6\u89E6\u53D1| Function |\n| visible-change| \u4E0B\u62C9\u6846\u51FA\u73B0/\u9690\u85CF\u65F6\u89E6\u53D1| Function |\n| remove-tag| \u5728\u591A\u9009\u6A21\u5F0F\u4E0B\uFF0C\u79FB\u9664Tag\u65F6\u89E6\u53D1| Function |\n\n#### Cascader Slots\n\n| \u63D2\u69FD\u540D| \u8BF4\u660E| \u4F5C\u7528\u57DF |\n| :--- | :--- | :--- |\n| default| \u81EA\u5B9A\u4E49\u5907\u9009\u9879\u7684\u8282\u70B9\u5185\u5BB9\uFF0C\u5206\u522B\u4E3A\u5F53\u524D\u8282\u70B9\u7684 Node \u5BF9\u8C61\u548C\u6570\u636E| object |\n| empty| \u65E0\u5339\u914D\u9009\u9879\u65F6\u7684\u5185\u5BB9| \u2014 |\n\n#### Cascader Exposes\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| getCheckedNodes| \u83B7\u53D6\u4E00\u4E2A\u5F53\u524D\u9009\u4E2D\u8282\u70B9\u7684\u6570\u7EC4\u3002(\u4EC5\u4EC5\u662F\u4F20\u5355) \u662F\u5426\u53EA\u8FD4\u56DE\u53F6\u9009\u4E2D\u7684\u8282\u70B9\uFF0C\u9ED8\u8BA4\u662F false| Function |\n| cascaderPanelRef| cascader \u9762\u677F\u7684 ref| object |\n| togglePopperVisible 2.2.31| \u5207\u6362 popper \u53EF\u89C1\u72B6\u6001| Function |\n| contentRef| cascader \u5185\u5BB9\u7684 ref| object |\n",
          "v-model": {
            "type": "attr",
            "values": [],
            "description": "\u9009\u4E2D\u9879\u7ED1\u5B9A\u503C"
          },
          "options": {
            "type": "attr",
            "values": ["object"],
            "description": "\u9009\u9879\u7684\u6570\u636E\u6E90\uFF0C value \u548C label \u53EF\u4EE5\u901A\u8FC7 CascaderProps \u81EA\u5B9A\u4E49."
          },
          "props": {
            "type": "attr",
            "values": ["object"],
            "description": "\u914D\u7F6E\u9009\u9879, \u8BF7\u53C2\u9605\u4E0B\u9762 CascaderProps \u8868\u3002"
          },
          "size": {
            "type": "attr",
            "values": ["large", "default", "small"],
            "description": "\u5C3A\u5BF8"
          },
          "placeholder": {
            "type": "attr",
            "values": [],
            "description": "\u8F93\u5165\u6846\u5360\u4F4D\u6587\u672C"
          },
          "disabled": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u7981\u7528"
          },
          "clearable": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u652F\u6301\u6E05\u7A7A\u9009\u9879"
          },
          "show-all-levels": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u8F93\u5165\u6846\u4E2D\u662F\u5426\u663E\u793A\u9009\u4E2D\u503C\u7684\u5B8C\u6574\u8DEF\u5F84"
          },
          "collapse-tags": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u591A\u9009\u6A21\u5F0F\u4E0B\u662F\u5426\u6298\u53E0Tag"
          },
          "collapse-tags-tooltip": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u5F53\u9F20\u6807\u60AC\u505C\u4E8E\u6298\u53E0\u6807\u7B7E\u7684\u6587\u672C\u65F6\uFF0C\u662F\u5426\u663E\u793A\u6240\u6709\u9009\u4E2D\u7684\u6807\u7B7E\u3002 \u8981\u4F7F\u7528\u6B64\u5C5E\u6027\uFF0Ccollapse-tags\u5C5E\u6027\u5FC5\u987B\u8BBE\u5B9A\u4E3A true"
          },
          "separator": {
            "type": "attr",
            "values": [],
            "description": "\u7528\u4E8E\u5206\u9694\u9009\u9879\u7684\u5B57\u7B26"
          },
          "filterable": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u8BE5\u9009\u9879\u662F\u5426\u53EF\u4EE5\u88AB\u641C\u7D22"
          },
          "filter-method": {
            "type": "attr",
            "values": ["Function"],
            "description": "\u81EA\u5B9A\u4E49\u641C\u7D22\u903B\u8F91\uFF0C\u7B2C\u4E00\u4E2A\u53C2\u6570\u662Fnode\uFF0C\u7B2C\u4E8C\u4E2A\u53C2\u6570\u662Fkeyword\uFF0C\u8FD4\u56DE\u7684\u5E03\u5C14\u503C\u8868\u793A\u662F\u5426\u4FDD\u7559\u8BE5\u9009\u9879"
          },
          "debounce": {
            "type": "attr",
            "values": ["number"],
            "description": "\u641C\u7D22\u5173\u952E\u8BCD\u6B63\u5728\u8F93\u5165\u65F6\u7684\u53BB\u6296\u5EF6\u8FDF\uFF0C\u5355\u4F4D\u4E3A\u6BEB\u79D2"
          },
          "before-filter": {
            "type": "attr",
            "values": ["Function"],
            "description": "\u8FC7\u6EE4\u51FD\u6570\u8C03\u7528\u524D\uFF0C\u6240\u8981\u8C03\u7528\u7684\u94A9\u5B50\u51FD\u6570\uFF0C\u8BE5\u51FD\u6570\u63A5\u6536\u8981\u8FC7\u6EE4\u7684\u503C\u4F5C\u4E3A\u53C2\u6570\u3002 \u5982\u679C\u8BE5\u51FD\u6570\u7684\u8FD4\u56DE\u503C\u662F false \u6216\u8005\u662F\u4E00\u4E2A\u88AB\u62D2\u7EDD\u7684 Promise\uFF0C\u90A3\u4E48\u63A5\u4E0B\u6765\u7684\u8FC7\u6EE4\u903B\u8F91\u4FBF\u4E0D\u4F1A\u6267\u884C\u3002"
          },
          "popper-class": {
            "type": "attr",
            "values": [],
            "description": "\u5F39\u51FA\u5185\u5BB9\u7684\u81EA\u5B9A\u4E49\u7C7B\u540D"
          },
          "teleported": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u5F39\u5C42\u662F\u5426\u4F7F\u7528 teleport"
          },
          "popper-append-to-bodydeprecated": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u5C06\u5F39\u51FA\u7684\u5185\u5BB9\u76F4\u63A5\u63D2\u5165\u5230 body \u5143\u7D20\u3002 \u5728\u5F39\u51FA\u5185\u5BB9\u7684\u8FB9\u6846\u5B9A\u4F4D\u51FA\u73B0\u95EE\u9898\u65F6\uFF0C\u53EF\u5C06\u8BE5\u5C5E\u6027\u8BBE\u7F6E\u4E3A false"
          },
          "tag-type": {
            "type": "attr",
            "values": ["success", "info", "warning", "danger"],
            "description": "\u6807\u7B7E\u7C7B\u578B"
          },
          "validate-event": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u8F93\u5165\u65F6\u662F\u5426\u89E6\u53D1\u8868\u5355\u7684\u6821\u9A8C"
          },
          "max-collapse-tags": {
            "type": "attr",
            "values": ["number"],
            "description": "\u9700\u8981\u663E\u793A\u7684 Tag \u7684\u6700\u5927\u6570\u91CF \u53EA\u6709\u5F53 collapse-tags \u8BBE\u7F6E\u4E3A true \u65F6\u624D\u4F1A\u751F\u6548\u3002"
          },
          "empty-values": {
            "type": "attr",
            "values": ["array"],
            "description": "\u7EC4\u4EF6\u7684\u7A7A\u503C\u914D\u7F6E \u53C2\u8003config-provider"
          },
          "value-on-clear": {
            "type": "attr",
            "values": [],
            "description": "\u6E05\u7A7A\u9009\u9879\u7684\u503C \u53C2\u8003 config-provider"
          },
          "change": {
            "type": "event",
            "values": [],
            "description": "\u5F53\u7ED1\u5B9A\u503C\u53D8\u5316\u65F6\u89E6\u53D1\u7684\u4E8B\u4EF6"
          },
          "expand-change": {
            "type": "event",
            "values": [],
            "description": "\u5F53\u5C55\u5F00\u8282\u70B9\u53D1\u751F\u53D8\u5316\u65F6\u89E6\u53D1"
          },
          "blur": {
            "type": "event",
            "values": [],
            "description": "\u5F53\u5931\u53BB\u7126\u70B9\u65F6\u89E6\u53D1"
          },
          "focus": {
            "type": "event",
            "values": [],
            "description": "\u5F53\u83B7\u5F97\u7126\u70B9\u65F6\u89E6\u53D1"
          },
          "visible-change": {
            "type": "event",
            "values": [],
            "description": "\u4E0B\u62C9\u6846\u51FA\u73B0/\u9690\u85CF\u65F6\u89E6\u53D1"
          },
          "remove-tag": {
            "type": "event",
            "values": [],
            "description": "\u5728\u591A\u9009\u6A21\u5F0F\u4E0B\uFF0C\u79FB\u9664Tag\u65F6\u89E6\u53D1"
          }
        },
        "el-checkbox": {
          "_html": {
            "": '<el-checkbox v-model="${1:checked}">$2</el-checkbox>',
            ":disabled": '<el-checkbox v-model="${1:checked}" disabled>$2</el-checkbox>'
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/checkbox.html)\n\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| model-value / v-model| \u9009\u4E2D\u9879\u7ED1\u5B9A\u503C| string / number / boolean| \u2014 |\n| value 2.6.0| \u9009\u4E2D\u72B6\u6001\u7684\u503C\uFF08\u53EA\u6709\u5728checkbox-group\u6216\u8005\u7ED1\u5B9A\u5BF9\u8C61\u7C7B\u578B\u4E3Aarray\u65F6\u6709\u6548\uFF09| string / number / boolean / object| \u2014 |\n| label| \u9009\u4E2D\u72B6\u6001\u7684\u503C\uFF0C\u53EA\u6709\u5728\u7ED1\u5B9A\u5BF9\u8C61\u7C7B\u578B\u4E3A array \u65F6\u6709\u6548\u3002 \u5982\u679C\u6CA1\u6709 value\uFF0C label\u5219\u4F5C\u4E3Avalue\u4F7F\u7528| string / number / boolean / object| \u2014 |\n| true-value 2.6.0| \u9009\u4E2D\u65F6\u7684\u503C| string / number| \u2014 |\n| false-value 2.6.0| \u6CA1\u6709\u9009\u4E2D\u65F6\u7684\u503C| string / number| \u2014 |\n| true-label deprecated| \u9009\u4E2D\u65F6\u7684\u503C| string / number| \u2014 |\n| false-label deprecated| \u6CA1\u6709\u9009\u4E2D\u65F6\u7684\u503C| string / number| \u2014 |\n| disabled| \u662F\u5426\u7981\u7528| boolean| false |\n| border| \u662F\u5426\u663E\u793A\u8FB9\u6846| boolean| false |\n| size| Checkbox \u7684\u5C3A\u5BF8| enum| \u2014 |\n| name| \u539F\u751F name \u5C5E\u6027| string| \u2014 |\n| checked| \u5F53\u524D\u662F\u5426\u52FE\u9009| boolean| false |\n| indeterminate| \u8BBE\u7F6E\u4E0D\u786E\u5B9A\u72B6\u6001\uFF0C\u4EC5\u8D1F\u8D23\u6837\u5F0F\u63A7\u5236| boolean| false |\n| validate-event| \u8F93\u5165\u65F6\u662F\u5426\u89E6\u53D1\u8868\u5355\u7684\u6821\u9A8C| boolean| true |\n| tabindex| \u8F93\u5165\u6846\u7684 tabindex| string / number| \u2014 |\n| id| input id| string| \u2014 |\n| controls a11y| \u4E0E aria-control\u4E00\u81F4, \u5F53 indeterminate\u4E3A true\u65F6\u751F\u6548| boolean| \u2014 |\n#### \u4E8B\u4EF6\n\n| \u4E8B\u4EF6\u540D| \u8BF4\u660E| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| change| \u5F53\u7ED1\u5B9A\u503C\u53D8\u5316\u65F6\u89E6\u53D1\u7684\u4E8B\u4EF6| Function |\n\n#### Checkbox Slots\n\n| \u63D2\u69FD\u540D| \u8BF4\u660E |\n| :--- | :--- |\n| default| \u81EA\u5B9A\u4E49\u9ED8\u8BA4\u5185\u5BB9 |\n",
          "v-model": {
            "type": "attr",
            "values": [],
            "description": "\u9009\u4E2D\u9879\u7ED1\u5B9A\u503C"
          },
          "value": {
            "type": "attr",
            "values": [],
            "description": "\u9009\u4E2D\u72B6\u6001\u7684\u503C\uFF08\u53EA\u6709\u5728checkbox-group\u6216\u8005\u7ED1\u5B9A\u5BF9\u8C61\u7C7B\u578B\u4E3Aarray\u65F6\u6709\u6548\uFF09"
          },
          "label": {
            "type": "attr",
            "values": [],
            "description": "\u9009\u4E2D\u72B6\u6001\u7684\u503C\uFF0C\u53EA\u6709\u5728\u7ED1\u5B9A\u5BF9\u8C61\u7C7B\u578B\u4E3A array \u65F6\u6709\u6548\u3002 \u5982\u679C\u6CA1\u6709 value\uFF0C label\u5219\u4F5C\u4E3Avalue\u4F7F\u7528"
          },
          "true-value": {
            "type": "attr",
            "values": [],
            "description": "\u9009\u4E2D\u65F6\u7684\u503C"
          },
          "false-value": {
            "type": "attr",
            "values": [],
            "description": "\u6CA1\u6709\u9009\u4E2D\u65F6\u7684\u503C"
          },
          "true-labeldeprecated": {
            "type": "attr",
            "values": [],
            "description": "\u9009\u4E2D\u65F6\u7684\u503C"
          },
          "false-labeldeprecated": {
            "type": "attr",
            "values": [],
            "description": "\u6CA1\u6709\u9009\u4E2D\u65F6\u7684\u503C"
          },
          "disabled": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u7981\u7528"
          },
          "border": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u663E\u793A\u8FB9\u6846"
          },
          "size": {
            "type": "attr",
            "values": ["large", "default", "small"],
            "description": "Checkbox \u7684\u5C3A\u5BF8"
          },
          "name": {
            "type": "attr",
            "values": [],
            "description": "\u539F\u751F name \u5C5E\u6027"
          },
          "checked": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u5F53\u524D\u662F\u5426\u52FE\u9009"
          },
          "indeterminate": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u8BBE\u7F6E\u4E0D\u786E\u5B9A\u72B6\u6001\uFF0C\u4EC5\u8D1F\u8D23\u6837\u5F0F\u63A7\u5236"
          },
          "validate-event": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u8F93\u5165\u65F6\u662F\u5426\u89E6\u53D1\u8868\u5355\u7684\u6821\u9A8C"
          },
          "tabindex": {
            "type": "attr",
            "values": [],
            "description": "\u8F93\u5165\u6846\u7684 tabindex"
          },
          "id": {
            "type": "attr",
            "values": [],
            "description": "input id"
          },
          "controlsaydeprecated": {
            "type": "attr",
            "values": [],
            "description": "\u4E0E aria-control\u4E00\u81F4, \u5F53 indeterminate\u4E3A true\u65F6\u751F\u6548"
          },
          "aria-controlsay": {
            "type": "attr",
            "values": [],
            "description": "\u548C aria-control\u4E00\u81F4\u3002\u5F53 indeterminate \u4E3A true \u65F6\u751F\u6548"
          },
          "change": {
            "type": "event",
            "values": [],
            "description": "\u5F53\u7ED1\u5B9A\u503C\u53D8\u5316\u65F6\u89E6\u53D1\u7684\u4E8B\u4EF6"
          }
        },
        "el-checkbox-group": {
          "_html": {
            "": '<el-checkbox-group v-model="${1:checkList}">\n<el-checkbox label="${2:label}" value="${3:value}"></el-checkbox>\n</el-checkbox-group>',
            ":for": '<el-checkbox-group v-model="${1:checkList}">\n<el-checkbox v-for="item in ${2:options}" :label="item.label" :value="item.value"></el-checkbox>\n</el-checkbox-group>'
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/checkbox.html)\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| model-value / v-model| \u7ED1\u5B9A\u503C| object| [] |\n| size| \u591A\u9009\u6846\u7EC4\u5C3A\u5BF8| enum| \u2014 |\n| disabled| \u662F\u5426\u7981\u7528| boolean| false |\n| min| \u53EF\u88AB\u52FE\u9009\u7684 checkbox \u7684\u6700\u5C0F\u6570\u91CF| number| \u2014 |\n| max| \u53EF\u88AB\u52FE\u9009\u7684 checkbox \u7684\u6700\u5927\u6570\u91CF| number| \u2014 |\n| label| \u4E3A\u5C4F\u5E55\u9605\u8BFB\u5668\u51C6\u5907\u7684\u6807\u7B7E| string| \u2014 |\n| text-color| \u5F53\u6309\u94AE\u4E3A\u6D3B\u8DC3\u72B6\u6001\u65F6\u7684\u5B57\u4F53\u989C\u8272| string| #ffffff |\n| fill| \u5F53\u6309\u94AE\u4E3A\u6D3B\u8DC3\u72B6\u6001\u65F6\u7684\u8FB9\u6846\u548C\u80CC\u666F\u989C\u8272| string| #409EFF |\n| tag| \u590D\u9009\u6846\u7EC4\u5143\u7D20\u6807\u7B7E| string| div |\n| validate-event| \u662F\u5426\u89E6\u53D1\u8868\u5355\u9A8C\u8BC1| boolean| true |\n#### \u4E8B\u4EF6\n\n| \u4E8B\u4EF6\u540D| \u8BF4\u660E| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| change| \u5F53\u7ED1\u5B9A\u503C\u53D8\u5316\u65F6\u89E6\u53D1\u7684\u4E8B\u4EF6| Function |\n\n#### CheckboxGroup Slots\n\n| \u63D2\u69FD\u540D| \u8BF4\u660E| \u5B50\u6807\u7B7E |\n| :--- | :--- | :--- |\n| default| \u81EA\u5B9A\u4E49\u9ED8\u8BA4\u5185\u5BB9| Checkbox / Checkbox-button |\n",
          "v-model": {
            "type": "attr",
            "values": ["object"],
            "description": "\u7ED1\u5B9A\u503C"
          },
          "size": {
            "type": "attr",
            "values": ["large", "default", "small"],
            "description": "\u591A\u9009\u6846\u7EC4\u5C3A\u5BF8"
          },
          "disabled": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u7981\u7528"
          },
          "min": {
            "type": "attr",
            "values": ["number"],
            "description": "\u53EF\u88AB\u52FE\u9009\u7684 checkbox \u7684\u6700\u5C0F\u6570\u91CF"
          },
          "max": {
            "type": "attr",
            "values": ["number"],
            "description": "\u53EF\u88AB\u52FE\u9009\u7684 checkbox \u7684\u6700\u5927\u6570\u91CF"
          },
          "labelaydeprecated": {
            "type": "attr",
            "values": [],
            "description": "\u539F\u751F aria-label\u5C5E\u6027"
          },
          "aria-labelay": {
            "type": "attr",
            "values": [],
            "description": "\u539F\u751F aria-label\u5C5E\u6027"
          },
          "text-color": {
            "type": "attr",
            "values": [],
            "description": "\u5F53\u6309\u94AE\u4E3A\u6D3B\u8DC3\u72B6\u6001\u65F6\u7684\u5B57\u4F53\u989C\u8272"
          },
          "fill": {
            "type": "attr",
            "values": [],
            "description": "\u5F53\u6309\u94AE\u4E3A\u6D3B\u8DC3\u72B6\u6001\u65F6\u7684\u8FB9\u6846\u548C\u80CC\u666F\u989C\u8272"
          },
          "tag": {
            "type": "attr",
            "values": [],
            "description": "\u590D\u9009\u6846\u7EC4\u5143\u7D20\u6807\u7B7E"
          },
          "validate-event": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u89E6\u53D1\u8868\u5355\u9A8C\u8BC1"
          },
          "change": {
            "type": "event",
            "values": [],
            "description": "\u5F53\u7ED1\u5B9A\u503C\u53D8\u5316\u65F6\u89E6\u53D1\u7684\u4E8B\u4EF6"
          }
        },
        "el-color-picker": {
          "_html": {
            "": '<el-color-picker v-model="${1:color}" />',
            ":alpha": '<el-color-picker v-model="${1:color}" show-alpha />',
            ":predefine": '<el-color-picker v-model="${1:color}" show-alpha :predefine="${2:predefineColors}" />'
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/color-picker.html)\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| model-value / v-model| \u9009\u4E2D\u9879\u7ED1\u5B9A\u503C| string| \u2014 |\n| disabled| \u662F\u5426\u7981\u7528| boolean| false |\n| size| \u5C3A\u5BF8| enum| \u2014 |\n| show-alpha| \u662F\u5426\u652F\u6301\u900F\u660E\u5EA6\u9009\u62E9| boolean| false |\n| color-format| \u5199\u5165 v-model \u7684\u989C\u8272\u7684\u683C\u5F0F| enum| \u2014 |\n| popper-class| ColorPicker \u4E0B\u62C9\u6846\u7684\u7C7B\u540D| string| \u2014 |\n| predefine| \u9884\u5B9A\u4E49\u989C\u8272| object| \u2014 |\n| validate-event| \u8F93\u5165\u65F6\u662F\u5426\u89E6\u53D1\u8868\u5355\u7684\u6821\u9A8C| boolean| true |\n| tabindex| ColorPicker \u7684 tabindex| string / number| 0 |\n| label a11y| ColorPicker \u7684 aria-label| string| \u2014 |\n| id| ColorPicker \u7684 id| string| \u2014 |\n#### \u4E8B\u4EF6\n\n| \u4E8B\u4EF6\u540D| \u8BF4\u660E| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| change| \u5F53\u7ED1\u5B9A\u503C\u53D8\u5316\u65F6\u89E6\u53D1| Function |\n| active-change| \u9762\u677F\u4E2D\u5F53\u524D\u663E\u793A\u7684\u989C\u8272\u53D1\u751F\u6539\u53D8\u65F6\u89E6\u53D1| Function |\n| focus 2.4.0| \u5F53\u83B7\u5F97\u7126\u70B9\u65F6\u89E6\u53D1| Function |\n| blur 2.4.0| \u5F53\u5931\u53BB\u7126\u70B9\u65F6\u89E6\u53D1| Function |\n\n#### Exposes\n\n| \u540D\u79F0| \u8BF4\u660E| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| color| \u5F53\u524D\u8272\u5F69\u5BF9\u8C61| object |\n| show 2.3.3| \u624B\u52A8\u663E\u793A\u989C\u8272\u9009\u62E9\u5668| Function |\n| hide 2.3.3| \u624B\u52A8\u9690\u85CF\u989C\u8272\u9009\u62E9\u5668| Function |\n| focus 2.3.13| \u4F7F picker \u83B7\u5F97\u7126\u70B9| Function |\n| blur 2.3.13| \u4F7F picker \u5931\u53BB\u7126\u70B9| Function |\n\n#### \u6E90\u4EE3\u7801\n\n#### \u8D21\u732E\u8005\n",
          "v-model": {
            "type": "attr",
            "values": [],
            "description": "\u9009\u4E2D\u9879\u7ED1\u5B9A\u503C"
          },
          "disabled": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u7981\u7528"
          },
          "size": {
            "type": "attr",
            "values": ["large", "default", "small"],
            "description": "\u5C3A\u5BF8"
          },
          "show-alpha": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u652F\u6301\u900F\u660E\u5EA6\u9009\u62E9"
          },
          "color-format": {
            "type": "attr",
            "values": ["enum"],
            "description": "\u5199\u5165 v-model \u7684\u989C\u8272\u7684\u683C\u5F0F"
          },
          "popper-class": {
            "type": "attr",
            "values": [],
            "description": "ColorPicker \u4E0B\u62C9\u6846\u7684\u7C7B\u540D"
          },
          "predefine": {
            "type": "attr",
            "values": ["object"],
            "description": "\u9884\u5B9A\u4E49\u989C\u8272"
          },
          "validate-event": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u8F93\u5165\u65F6\u662F\u5426\u89E6\u53D1\u8868\u5355\u7684\u6821\u9A8C"
          },
          "tabindex": {
            "type": "attr",
            "values": [],
            "description": "ColorPicker \u7684 tabindex"
          },
          "labelaydeprecated": {
            "type": "attr",
            "values": [],
            "description": "ColorPicker \u7684 aria-label"
          },
          "aria-labelay": {
            "type": "attr",
            "values": [],
            "description": "ColorPicker \u7684 aria-label"
          },
          "id": {
            "type": "attr",
            "values": [],
            "description": "ColorPicker \u7684 id"
          },
          "teleported": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u5C06 popover \u7684\u4E0B\u62C9\u5217\u8868\u6E32\u67D3\u81F3 body \u4E0B"
          },
          "change": {
            "type": "event",
            "values": [],
            "description": "\u5F53\u7ED1\u5B9A\u503C\u53D8\u5316\u65F6\u89E6\u53D1"
          },
          "active-change": {
            "type": "event",
            "values": [],
            "description": "\u9762\u677F\u4E2D\u5F53\u524D\u663E\u793A\u7684\u989C\u8272\u53D1\u751F\u6539\u53D8\u65F6\u89E6\u53D1"
          },
          "focus": {
            "type": "event",
            "values": [],
            "description": "\u5F53\u83B7\u5F97\u7126\u70B9\u65F6\u89E6\u53D1"
          },
          "blur": {
            "type": "event",
            "values": [],
            "description": "\u5F53\u5931\u53BB\u7126\u70B9\u65F6\u89E6\u53D1"
          }
        },
        "el-date-picker": {
          "_html": {
            "": '<el-date-picker v-model="${1:value}" type="${2:date}" placeholder="Pick a day" />',
            ":shortcuts": '<el-date-picker v-model="${1:value}" type="${2:date}" placeholder="Pick a day" :shortcuts="${3:shortcuts}" />',
            ":range": '<el-date-picker v-model="${1:value}" type="${2:daterange}" range-separator="${3:To}" start-placeholder="Start date" end-placeholder="End date" />'
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/date-picker.html)\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4 |\n| :--- | :--- | :--- | :--- |\n| model-value / v-model| \u7ED1\u5B9A\u503C\uFF0C\u5982\u679C\u5B83\u662F\u6570\u7EC4\uFF0C\u957F\u5EA6\u5E94\u8BE5\u662F 2| number / string / object| '' |\n| readonly| \u53EA\u8BFB| boolean| false |\n| disabled| \u7981\u7528| boolean| false |\n| size| \u8F93\u5165\u6846\u5C3A\u5BF8| enum| \u2014 |\n| editable| \u6587\u672C\u6846\u53EF\u8F93\u5165| boolean| true |\n| clearable| \u662F\u5426\u663E\u793A\u6E05\u9664\u6309\u94AE| boolean| true |\n| placeholder| \u975E\u8303\u56F4\u9009\u62E9\u65F6\u7684\u5360\u4F4D\u5185\u5BB9| string| '' |\n| start-placeholder| \u8303\u56F4\u9009\u62E9\u65F6\u5F00\u59CB\u65E5\u671F\u7684\u5360\u4F4D\u5185\u5BB9| string| \u2014 |\n| end-placeholder| \u8303\u56F4\u9009\u62E9\u65F6\u7ED3\u675F\u65E5\u671F\u7684\u5360\u4F4D\u5185\u5BB9| string| \u2014 |\n| type| \u663E\u793A\u7C7B\u578B| enum| date |\n| format| \u663E\u793A\u5728\u8F93\u5165\u6846\u4E2D\u7684\u683C\u5F0F| \u53C2\u89C1 date formats| YYYY-MM-DD |\n| popper-class| DatePicker \u4E0B\u62C9\u6846\u7684\u7C7B\u540D| string| \u2014 |\n| popper-options| \u81EA\u5B9A\u4E49 popper \u9009\u9879\uFF0C\u66F4\u591A\u8BF7\u53C2\u8003 popper.js| object| {} |\n| range-separator| \u9009\u62E9\u8303\u56F4\u65F6\u7684\u5206\u9694\u7B26| string| '-' |\n| default-value| \u53EF\u9009\uFF0C\u9009\u62E9\u5668\u6253\u5F00\u65F6\u9ED8\u8BA4\u663E\u793A\u7684\u65F6\u95F4| object| \u2014 |\n| default-time| \u8303\u56F4\u9009\u62E9\u65F6\u9009\u4E2D\u65E5\u671F\u6240\u4F7F\u7528\u7684\u5F53\u65E5\u5185\u5177\u4F53\u65F6\u523B| object| \u2014 |\n| value-format| \u53EF\u9009\uFF0C\u7ED1\u5B9A\u503C\u7684\u683C\u5F0F\u3002 \u4E0D\u6307\u5B9A\u5219\u7ED1\u5B9A\u503C\u4E3A Date \u5BF9\u8C61| \u53C2\u89C1 date formats| \u2014 |\n| id| \u7B49\u4EF7\u4E8E\u539F\u751F input id \u5C5E\u6027| string / object| \u2014 |\n| name| \u7B49\u4EF7\u4E8E\u539F\u751F input name \u5C5E\u6027| string / object| '' |\n| unlink-panels| \u5728\u8303\u56F4\u9009\u62E9\u5668\u91CC\u53D6\u6D88\u4E24\u4E2A\u65E5\u671F\u9762\u677F\u4E4B\u95F4\u7684\u8054\u52A8| boolean| false |\n| prefix-icon| \u81EA\u5B9A\u4E49\u524D\u7F00\u56FE\u6807 \u5982\u679C type\u7684\u503C\u662FTimeLikeType\uFF0C\u90A3\u4E48\u5C31\u662F Clock\uFF0C\u4E0D\u7136\u5C31\u662F Calendar| string / object| '' |\n| clear-icon| \u81EA\u5B9A\u4E49\u6E05\u9664\u56FE\u6807| string / object| CircleClose |\n| validate-event| \u662F\u5426\u89E6\u53D1\u8868\u5355\u9A8C\u8BC1| boolean| true |\n| disabled-date| \u4E00\u4E2A\u7528\u6765\u5224\u65AD\u8BE5\u65E5\u671F\u662F\u5426\u88AB\u7981\u7528\u7684\u51FD\u6570\uFF0C\u63A5\u53D7\u4E00\u4E2A Date \u5BF9\u8C61\u4F5C\u4E3A\u53C2\u6570\u3002 \u5E94\u8BE5\u8FD4\u56DE\u4E00\u4E2A Boolean \u503C\u3002| Function| \u2014 |\n| shortcuts| \u8BBE\u7F6E\u5FEB\u6377\u9009\u9879\uFF0C\u9700\u8981\u4F20\u5165\u6570\u7EC4\u5BF9\u8C61| object| [] |\n| cell-class-name| \u8BBE\u7F6E\u81EA\u5B9A\u4E49\u7C7B\u540D| Function| \u2014 |\n| teleported| \u662F\u5426\u5C06 date-picker \u7684\u4E0B\u62C9\u5217\u8868\u63D2\u5165\u81F3 body \u5143\u7D20| boolean| true |\n#### \u4E8B\u4EF6\n\n| \u4E8B\u4EF6\u540D| \u8BF4\u660E| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| change| \u7528\u6237\u786E\u8BA4\u9009\u5B9A\u7684\u503C\u65F6\u89E6\u53D1| Function |\n| blur| \u5728\u7EC4\u4EF6 Input \u5931\u53BB\u7126\u70B9\u65F6\u89E6\u53D1| Function |\n| focus| \u5728\u7EC4\u4EF6 Input \u83B7\u5F97\u7126\u70B9\u65F6\u89E6\u53D1| Function |\n| calendar-change| \u5728\u65E5\u5386\u6240\u9009\u65E5\u671F\u66F4\u6539\u65F6\u89E6\u53D1| Function |\n| panel-change| \u5F53\u65E5\u671F\u9762\u677F\u6539\u53D8\u65F6\u89E6\u53D1\u3002| Function |\n| visible-change| \u5F53 DatePicker \u7684\u4E0B\u62C9\u5217\u8868\u51FA\u73B0/\u6D88\u5931\u65F6\u89E6\u53D1| Function |\n\n#### \u63D2\u69FD\n\n| \u540D\u79F0| \u8BF4\u660E |\n| :--- | :--- |\n| default| \u81EA\u5B9A\u4E49\u5355\u5143\u683C\u5185\u5BB9 |\n| range-separator| \u81EA\u5B9A\u4E49\u8303\u56F4\u5206\u5272\u7B26\u5185\u5BB9 |\n\n#### \u66B4\u9732\n\n| \u63D2\u69FD\u540D| \u8BF4\u660E| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| focus| \u4F7F\u9009\u62E9\u5668\u7684\u8F93\u5165\u6846\u83B7\u53D6\u7126\u70B9| Function |\n| handleOpen 2.2.16| \u6253\u5F00\u65E5\u671F\u9009\u62E9\u5668\u5F39\u7A97| Function |\n| handleClose 2.2.16| \u5173\u95ED\u65E5\u671F\u9009\u62E9\u5668\u5F39\u7A97| Function |\n\n#### \u7C7B\u578B\u58F0\u660E\n\n#### \u6E90\u4EE3\u7801\n\n#### \u8D21\u732E\u8005\n",
          "v-model": {
            "type": "attr",
            "values": ["number"],
            "description": "\u7ED1\u5B9A\u503C\uFF0C\u5982\u679C\u5B83\u662F\u6570\u7EC4\uFF0C\u957F\u5EA6\u5E94\u8BE5\u662F 2"
          },
          "readonly": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u53EA\u8BFB"
          },
          "disabled": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u7981\u7528"
          },
          "size": {
            "type": "attr",
            "values": ["large", "default", "small"],
            "description": "\u8F93\u5165\u6846\u5C3A\u5BF8"
          },
          "editable": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u6587\u672C\u6846\u53EF\u8F93\u5165"
          },
          "clearable": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u663E\u793A\u6E05\u9664\u6309\u94AE"
          },
          "placeholder": {
            "type": "attr",
            "values": [],
            "description": "\u975E\u8303\u56F4\u9009\u62E9\u65F6\u7684\u5360\u4F4D\u5185\u5BB9"
          },
          "start-placeholder": {
            "type": "attr",
            "values": [],
            "description": "\u8303\u56F4\u9009\u62E9\u65F6\u5F00\u59CB\u65E5\u671F\u7684\u5360\u4F4D\u5185\u5BB9"
          },
          "end-placeholder": {
            "type": "attr",
            "values": [],
            "description": "\u8303\u56F4\u9009\u62E9\u65F6\u7ED3\u675F\u65E5\u671F\u7684\u5360\u4F4D\u5185\u5BB9"
          },
          "type": {
            "type": "attr",
            "values": ["primary", "success", "warning", "danger", "info"],
            "description": "\u663E\u793A\u7C7B\u578B"
          },
          "format": {
            "type": "attr",
            "values": ["\u53C2\u89C1"],
            "description": "\u663E\u793A\u5728\u8F93\u5165\u6846\u4E2D\u7684\u683C\u5F0F"
          },
          "popper-class": {
            "type": "attr",
            "values": [],
            "description": "DatePicker \u4E0B\u62C9\u6846\u7684\u7C7B\u540D"
          },
          "popper-options": {
            "type": "attr",
            "values": ["object"],
            "description": "\u81EA\u5B9A\u4E49 popper \u9009\u9879\uFF0C\u66F4\u591A\u8BF7\u53C2\u8003 popper.js"
          },
          "range-separator": {
            "type": "attr",
            "values": [],
            "description": "\u9009\u62E9\u8303\u56F4\u65F6\u7684\u5206\u9694\u7B26"
          },
          "default-value": {
            "type": "attr",
            "values": ["object"],
            "description": "\u53EF\u9009\uFF0C\u9009\u62E9\u5668\u6253\u5F00\u65F6\u9ED8\u8BA4\u663E\u793A\u7684\u65F6\u95F4"
          },
          "default-time": {
            "type": "attr",
            "values": ["object"],
            "description": "\u8303\u56F4\u9009\u62E9\u65F6\u9009\u4E2D\u65E5\u671F\u6240\u4F7F\u7528\u7684\u5F53\u65E5\u5185\u5177\u4F53\u65F6\u523B"
          },
          "value-format": {
            "type": "attr",
            "values": ["\u53C2\u89C1"],
            "description": "\u53EF\u9009\uFF0C\u7ED1\u5B9A\u503C\u7684\u683C\u5F0F\u3002 \u4E0D\u6307\u5B9A\u5219\u7ED1\u5B9A\u503C\u4E3A Date \u5BF9\u8C61"
          },
          "id": {
            "type": "attr",
            "values": [],
            "description": "\u7B49\u4EF7\u4E8E\u539F\u751F input id \u5C5E\u6027"
          },
          "name": {
            "type": "attr",
            "values": [],
            "description": "\u7B49\u4EF7\u4E8E\u539F\u751F input name \u5C5E\u6027"
          },
          "unlink-panels": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u5728\u8303\u56F4\u9009\u62E9\u5668\u91CC\u53D6\u6D88\u4E24\u4E2A\u65E5\u671F\u9762\u677F\u4E4B\u95F4\u7684\u8054\u52A8"
          },
          "prefix-icon": {
            "type": "attr",
            "values": [],
            "description": "\u81EA\u5B9A\u4E49\u524D\u7F00\u56FE\u6807 \u5982\u679C type\u7684\u503C\u662FTimeLikeType\uFF0C\u90A3\u4E48\u5C31\u662F Clock\uFF0C\u4E0D\u7136\u5C31\u662F Calendar"
          },
          "clear-icon": {
            "type": "attr",
            "values": [],
            "description": "\u81EA\u5B9A\u4E49\u6E05\u9664\u56FE\u6807"
          },
          "validate-event": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u89E6\u53D1\u8868\u5355\u9A8C\u8BC1"
          },
          "disabled-date": {
            "type": "attr",
            "values": ["Function"],
            "description": "\u4E00\u4E2A\u7528\u6765\u5224\u65AD\u8BE5\u65E5\u671F\u662F\u5426\u88AB\u7981\u7528\u7684\u51FD\u6570\uFF0C\u63A5\u53D7\u4E00\u4E2A Date \u5BF9\u8C61\u4F5C\u4E3A\u53C2\u6570\u3002 \u5E94\u8BE5\u8FD4\u56DE\u4E00\u4E2A Boolean \u503C\u3002"
          },
          "shortcuts": {
            "type": "attr",
            "values": ["object"],
            "description": "\u8BBE\u7F6E\u5FEB\u6377\u9009\u9879\uFF0C\u9700\u8981\u4F20\u5165\u6570\u7EC4\u5BF9\u8C61"
          },
          "cell-class-name": {
            "type": "attr",
            "values": ["Function"],
            "description": "\u8BBE\u7F6E\u81EA\u5B9A\u4E49\u7C7B\u540D"
          },
          "teleported": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u5C06 date-picker \u7684\u4E0B\u62C9\u5217\u8868\u63D2\u5165\u81F3 body \u5143\u7D20"
          },
          "empty-values": {
            "type": "attr",
            "values": ["array"],
            "description": "\u7EC4\u4EF6\u7684\u7A7A\u503C\u914D\u7F6E \u53C2\u8003config-provider"
          },
          "value-on-clear": {
            "type": "attr",
            "values": [],
            "description": "\u6E05\u7A7A\u9009\u9879\u7684\u503C \u53C2\u8003 config-provider"
          },
          "change": {
            "type": "event",
            "values": [],
            "description": "\u7528\u6237\u786E\u8BA4\u9009\u5B9A\u7684\u503C\u65F6\u89E6\u53D1"
          },
          "blur": {
            "type": "event",
            "values": [],
            "description": "\u5728\u7EC4\u4EF6 Input \u5931\u53BB\u7126\u70B9\u65F6\u89E6\u53D1"
          },
          "focus": {
            "type": "event",
            "values": [],
            "description": "\u5728\u7EC4\u4EF6 Input \u83B7\u5F97\u7126\u70B9\u65F6\u89E6\u53D1"
          },
          "calendar-change": {
            "type": "event",
            "values": [],
            "description": "\u5728\u65E5\u5386\u6240\u9009\u65E5\u671F\u66F4\u6539\u65F6\u89E6\u53D1"
          },
          "panel-change": {
            "type": "event",
            "values": [],
            "description": "\u5F53\u65E5\u671F\u9762\u677F\u6539\u53D8\u65F6\u89E6\u53D1\u3002"
          },
          "visible-change": {
            "type": "event",
            "values": [],
            "description": "\u5F53 DatePicker \u7684\u4E0B\u62C9\u5217\u8868\u51FA\u73B0/\u6D88\u5931\u65F6\u89E6\u53D1"
          }
        },
        "el-datetime-picker": {
          "_html": {
            "": '<el-date-picker v-model="${1:value}" type="${2:datetime}" placeholder="Pick a day" />',
            ":shortcuts": '<el-date-picker v-model="${1:value}" type="${2:datetime}" placeholder="Pick a day" :shortcuts="${3:shortcuts}" />',
            ":range": '<el-date-picker v-model="${1:value}" type="${2:datetimerange}" range-separator="${3:To}" start-placeholder="Start date" end-placeholder="End date" />'
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/datetime-picker.html)\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u53EF\u9009\u503C| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- | :--- |\n| model-value / v-model| \u7ED1\u5B9A\u503C\uFF0C\u5982\u679C\u5B83\u662F\u6570\u7EC4\uFF0C\u957F\u5EA6\u5E94\u8BE5\u662F 2| Date / number / string / Array| \u2014| \u2014 |\n| readonly| \u53EA\u8BFB| boolean| \u2014| false |\n| disabled| \u7981\u7528| boolean| \u2014| false |\n| editable| \u6587\u672C\u6846\u53EF\u8F93\u5165| boolean| \u2014| true |\n| clearable| \u662F\u5426\u663E\u793A\u6E05\u9664\u6309\u94AE| boolean| \u2014| true |\n| size| \u8F93\u5165\u6846\u5C3A\u5BF8| string| large/default/small| default |\n| placeholder| \u975E\u8303\u56F4\u9009\u62E9\u65F6\u7684\u5360\u4F4D\u5185\u5BB9| string| \u2014| \u2014 |\n| start-placeholder| \u8303\u56F4\u9009\u62E9\u65F6\u5F00\u59CB\u65E5\u671F\u7684\u5360\u4F4D\u5185\u5BB9| string| \u2014| \u2014 |\n| end-placeholder| \u8303\u56F4\u9009\u62E9\u65F6\u7ED3\u675F\u65E5\u671F\u7684\u5360\u4F4D\u5185\u5BB9| string| \u2014| \u2014 |\n| arrow-control| \u662F\u5426\u4F7F\u7528\u7BAD\u5934\u8FDB\u884C\u65F6\u95F4\u9009\u62E9| boolean| \u2014| false |\n| type| \u663E\u793A\u7C7B\u578B| string| year/month/date/datetime/ week/datetimerange/daterange| date |\n| format| \u663E\u793A\u5728\u8F93\u5165\u6846\u4E2D\u7684\u683C\u5F0F| string| \u53C2\u89C1 date formats| YYYY-MM-DD HH:mm:ss |\n| popper-class| DateTimePicker \u4E0B\u62C9\u6846\u7684\u7C7B\u540D| string| \u2014| \u2014 |\n| range-separator| \u9009\u62E9\u8303\u56F4\u65F6\u7684\u5206\u9694\u7B26| string| \u2014| '-' |\n| default-value| \u53EF\u9009\uFF0C\u9009\u62E9\u5668\u6253\u5F00\u65F6\u9ED8\u8BA4\u663E\u793A\u7684\u65F6\u95F4| Date / [Date, Date]| | \u2014 |\n| default-time| \u9009\u62E9\u65E5\u671F\u540E\u7684\u9ED8\u8BA4\u65F6\u95F4\u503C\u3002 \u5982\u672A\u6307\u5B9A\u5219\u9ED8\u8BA4\u65F6\u95F4\u503C\u4E3A 00:00:00| Date / [Date, Date]| \u2014| \u2014 |\n| value-format| \u53EF\u9009\uFF0C\u7ED1\u5B9A\u503C\u7684\u683C\u5F0F\u3002 \u4E0D\u6307\u5B9A\u5219\u7ED1\u5B9A\u503C\u4E3A Date \u5BF9\u8C61| string| \u67E5\u770B \u65E5\u671F\u683C\u5F0F| \u2014 |\n| date-format 2.4.0| \u53EF\u9009\uFF0C\u65F6\u95F4\u9009\u62E9\u5668\u4E0B\u62C9\u5217\u8868\u4E2D\u663E\u793A\u7684\u65E5\u671F\u683C\u5F0F| string| \u53C2\u89C1 date formats| \u2014 |\n| time-format 2.4.0| \u53EF\u9009\uFF0C\u65F6\u95F4\u9009\u62E9\u5668\u4E0B\u62C9\u5217\u8868\u4E2D\u663E\u793A\u7684\u65F6\u95F4\u683C\u5F0F| string| \u53C2\u89C1 date formats| \u2014 |\n| id| \u7B49\u4EF7\u4E8E\u539F\u751F input id \u5C5E\u6027| string / [string, string]| \u2014| \u2014 |\n| name| \u7B49\u4EF7\u4E8E\u539F\u751F input name \u5C5E\u6027| string| \u2014| \u2014 |\n| unlink-panels| \u5728\u8303\u56F4\u9009\u62E9\u5668\u91CC\u53D6\u6D88\u4E24\u4E2A\u65E5\u671F\u9762\u677F\u4E4B\u95F4\u7684\u8054\u52A8| boolean| \u2014| false |\n| prefix-icon| \u81EA\u5B9A\u4E49\u524D\u7F00\u56FE\u6807\u7EC4\u4EF6| string | Component| \u2014| Date |\n| clear-icon| \u81EA\u5B9A\u4E49\u6E05\u9664\u56FE\u6807| string | Component| \u2014| CircleClose |\n| shortcuts| \u8BBE\u7F6E\u5FEB\u6377\u9009\u9879\uFF0C\u9700\u8981\u4F20\u5165\u6570\u7EC4\u5BF9\u8C61| object[{ text: string, value: date / function }]| \u2014| \u2014 |\n| disabled-date| \u4E00\u4E2A\u7528\u6765\u5224\u65AD\u8BE5\u65E5\u671F\u662F\u5426\u88AB\u7981\u7528\u7684\u51FD\u6570\uFF0C\u63A5\u53D7\u4E00\u4E2A Date \u5BF9\u8C61\u4F5C\u4E3A\u53C2\u6570\u3002 \u5E94\u8BE5\u8FD4\u56DE\u4E00\u4E2A Boolean \u503C\u3002| function(Date)| \u2014| \u2014 |\n| cell-class-name| \u8BBE\u7F6E\u81EA\u5B9A\u4E49\u7C7B\u540D| Function(Date)| \u2014| \u2014 |\n| teleported| \u662F\u5426\u5C06 datetime-picker \u7684\u4E0B\u62C9\u5217\u8868\u63D2\u5165\u81F3 body \u5143\u7D20| boolean| true / false| true |\n#### \u4E8B\u4EF6\n\n| \u4E8B\u4EF6\u540D| \u8BF4\u660E| \u56DE\u8C03\u53C2\u6570 |\n| :--- | :--- | :--- |\n| change| \u7528\u6237\u786E\u8BA4\u9009\u5B9A\u7684\u503C\u65F6\u89E6\u53D1| value |\n| blur| \u5728\u7EC4\u4EF6 Input \u5931\u53BB\u7126\u70B9\u65F6\u89E6\u53D1| (e: FocusEvent) |\n| focus| \u5728\u7EC4\u4EF6 Input \u83B7\u5F97\u7126\u70B9\u65F6\u89E6\u53D1| (e: FocusEvent) |\n| calendar-change| \u5982\u679C\u7528\u6237\u6CA1\u6709\u9009\u62E9\u65E5\u671F\uFF0C\u90A3\u9ED8\u8BA4\u5C55\u793A\u5F53\u524D\u65E5\u7684\u6708\u4EFD\u3002 \u9009\u4E2D\u65E5\u5386\u65E5\u671F\u540E\u4F1A\u6267\u884C\u7684\u56DE\u8C03\uFF0C\u53EA\u6709\u5F53 datetimerange \u624D\u751F\u6548| [Date, Date] |\n| visible-change| \u5F53 DateTimePicker \u7684\u4E0B\u62C9\u5217\u8868\u51FA\u73B0/\u6D88\u5931\u65F6\u89E6\u53D1| \u51FA\u73B0\u65F6\u4E3Atrue\uFF0C\u9690\u85CF\u65F6\u4E3Afalse |\n\n| \u65B9\u6CD5\u540D| \u8BF4\u660E| \u53C2\u6570 |\n| :--- | :--- | :--- |\n| focus| \u4F7F input \u83B7\u53D6\u7126\u70B9| \u2014 |\n\n#### Slots\n\n| \u63D2\u69FD\u540D| \u8BF4\u660E |\n| :--- | :--- |\n| default| \u81EA\u5B9A\u4E49\u5355\u5143\u683C\u5185\u5BB9 |\n| range-separator| \u81EA\u5B9A\u4E49\u8303\u56F4\u5206\u5272\u7B26\u5185\u5BB9 |\n\n#### \u6E90\u4EE3\u7801\n",
          "v-model": {
            "type": "attr",
            "values": ["Date"],
            "description": "\u7ED1\u5B9A\u503C\uFF0C\u5982\u679C\u5B83\u662F\u6570\u7EC4\uFF0C\u957F\u5EA6\u5E94\u8BE5\u662F 2"
          },
          "readonly": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u53EA\u8BFB"
          },
          "disabled": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u7981\u7528"
          },
          "editable": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u6587\u672C\u6846\u53EF\u8F93\u5165"
          },
          "clearable": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u663E\u793A\u6E05\u9664\u6309\u94AE"
          },
          "size": {
            "type": "attr",
            "values": [],
            "description": "\u8F93\u5165\u6846\u5C3A\u5BF8"
          },
          "placeholder": {
            "type": "attr",
            "values": [],
            "description": "\u975E\u8303\u56F4\u9009\u62E9\u65F6\u7684\u5360\u4F4D\u5185\u5BB9"
          },
          "start-placeholder": {
            "type": "attr",
            "values": [],
            "description": "\u8303\u56F4\u9009\u62E9\u65F6\u5F00\u59CB\u65E5\u671F\u7684\u5360\u4F4D\u5185\u5BB9"
          },
          "end-placeholder": {
            "type": "attr",
            "values": [],
            "description": "\u8303\u56F4\u9009\u62E9\u65F6\u7ED3\u675F\u65E5\u671F\u7684\u5360\u4F4D\u5185\u5BB9"
          },
          "arrow-control": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u4F7F\u7528\u7BAD\u5934\u8FDB\u884C\u65F6\u95F4\u9009\u62E9"
          },
          "type": {
            "type": "attr",
            "values": [],
            "description": "\u663E\u793A\u7C7B\u578B"
          },
          "format": {
            "type": "attr",
            "values": [],
            "description": "\u663E\u793A\u5728\u8F93\u5165\u6846\u4E2D\u7684\u683C\u5F0F"
          },
          "popper-class": {
            "type": "attr",
            "values": [],
            "description": "DateTimePicker \u4E0B\u62C9\u6846\u7684\u7C7B\u540D"
          },
          "range-separator": {
            "type": "attr",
            "values": [],
            "description": "\u9009\u62E9\u8303\u56F4\u65F6\u7684\u5206\u9694\u7B26"
          },
          "default-value": {
            "type": "attr",
            "values": ["Date"],
            "description": "\u53EF\u9009\uFF0C\u9009\u62E9\u5668\u6253\u5F00\u65F6\u9ED8\u8BA4\u663E\u793A\u7684\u65F6\u95F4"
          },
          "default-time": {
            "type": "attr",
            "values": ["Date"],
            "description": "\u9009\u62E9\u65E5\u671F\u540E\u7684\u9ED8\u8BA4\u65F6\u95F4\u503C\u3002 \u5982\u672A\u6307\u5B9A\u5219\u9ED8\u8BA4\u65F6\u95F4\u503C\u4E3A 00:00:00"
          },
          "value-format": {
            "type": "attr",
            "values": [],
            "description": "\u53EF\u9009\uFF0C\u7ED1\u5B9A\u503C\u7684\u683C\u5F0F\u3002 \u4E0D\u6307\u5B9A\u5219\u7ED1\u5B9A\u503C\u4E3A Date \u5BF9\u8C61"
          },
          "date-format": {
            "type": "attr",
            "values": [],
            "description": "\u53EF\u9009\uFF0C\u65F6\u95F4\u9009\u62E9\u5668\u4E0B\u62C9\u5217\u8868\u4E2D\u663E\u793A\u7684\u65E5\u671F\u683C\u5F0F"
          },
          "time-format": {
            "type": "attr",
            "values": [],
            "description": "\u53EF\u9009\uFF0C\u65F6\u95F4\u9009\u62E9\u5668\u4E0B\u62C9\u5217\u8868\u4E2D\u663E\u793A\u7684\u65F6\u95F4\u683C\u5F0F"
          },
          "id": {
            "type": "attr",
            "values": [],
            "description": "\u7B49\u4EF7\u4E8E\u539F\u751F input id \u5C5E\u6027"
          },
          "name": {
            "type": "attr",
            "values": [],
            "description": "\u7B49\u4EF7\u4E8E\u539F\u751F input name \u5C5E\u6027"
          },
          "unlink-panels": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u5728\u8303\u56F4\u9009\u62E9\u5668\u91CC\u53D6\u6D88\u4E24\u4E2A\u65E5\u671F\u9762\u677F\u4E4B\u95F4\u7684\u8054\u52A8"
          },
          "prefix-icon": {
            "type": "attr",
            "values": ["string", "Component"],
            "description": "\u81EA\u5B9A\u4E49\u524D\u7F00\u56FE\u6807\u7EC4\u4EF6"
          },
          "clear-icon": {
            "type": "attr",
            "values": ["string", "Component"],
            "description": "\u81EA\u5B9A\u4E49\u6E05\u9664\u56FE\u6807"
          },
          "shortcuts": {
            "type": "attr",
            "values": ["object[{"],
            "description": "\u8BBE\u7F6E\u5FEB\u6377\u9009\u9879\uFF0C\u9700\u8981\u4F20\u5165\u6570\u7EC4\u5BF9\u8C61"
          },
          "disabled-date": {
            "type": "attr",
            "values": ["function(Date)"],
            "description": "\u4E00\u4E2A\u7528\u6765\u5224\u65AD\u8BE5\u65E5\u671F\u662F\u5426\u88AB\u7981\u7528\u7684\u51FD\u6570\uFF0C\u63A5\u53D7\u4E00\u4E2A Date \u5BF9\u8C61\u4F5C\u4E3A\u53C2\u6570\u3002 \u5E94\u8BE5\u8FD4\u56DE\u4E00\u4E2A Boolean \u503C\u3002"
          },
          "cell-class-name": {
            "type": "attr",
            "values": ["Function(Date)"],
            "description": "\u8BBE\u7F6E\u81EA\u5B9A\u4E49\u7C7B\u540D"
          },
          "teleported": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u5C06 datetime-picker \u7684\u4E0B\u62C9\u5217\u8868\u63D2\u5165\u81F3 body \u5143\u7D20"
          },
          "empty-values": {
            "type": "attr",
            "values": ["array"],
            "description": "\u7EC4\u4EF6\u7684\u7A7A\u503C\u914D\u7F6E \u53C2\u8003config-provider"
          },
          "value-on-clear": {
            "type": "attr",
            "values": [],
            "description": "\u6E05\u7A7A\u9009\u9879\u7684\u503C \u53C2\u8003 config-provider"
          },
          "change": {
            "type": "event",
            "values": [],
            "description": "\u7528\u6237\u786E\u8BA4\u9009\u5B9A\u7684\u503C\u65F6\u89E6\u53D1"
          },
          "blur": {
            "type": "event",
            "values": [],
            "description": "\u5728\u7EC4\u4EF6 Input \u5931\u53BB\u7126\u70B9\u65F6\u89E6\u53D1"
          },
          "focus": {
            "type": "event",
            "values": [],
            "description": "\u5728\u7EC4\u4EF6 Input \u83B7\u5F97\u7126\u70B9\u65F6\u89E6\u53D1"
          },
          "calendar-change": {
            "type": "event",
            "values": [],
            "description": "\u5982\u679C\u7528\u6237\u6CA1\u6709\u9009\u62E9\u65E5\u671F\uFF0C\u90A3\u9ED8\u8BA4\u5C55\u793A\u5F53\u524D\u65E5\u7684\u6708\u4EFD\u3002 \u9009\u4E2D\u65E5\u5386\u65E5\u671F\u540E\u4F1A\u6267\u884C\u7684\u56DE\u8C03\uFF0C\u53EA\u6709\u5F53 datetimerange \u624D\u751F\u6548"
          },
          "visible-change": {
            "type": "event",
            "values": [],
            "description": "\u5F53 DateTimePicker \u7684\u4E0B\u62C9\u5217\u8868\u51FA\u73B0/\u6D88\u5931\u65F6\u89E6\u53D1"
          }
        },
        "el-form": {
          "_html": {
            "": '<el-form :model="${1:form}" :rules="${2:rules}" label-width="auto">\n$3\n</el-form>',
            ":inline": '<el-form :inline="true" :model="${1:form}" :rules="${2:rules}" label-width="auto">\n$3\n</el-form>'
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/form.html)\n\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| model| \u8868\u5355\u6570\u636E\u5BF9\u8C61| object| \u2014 |\n| rules| \u8868\u5355\u9A8C\u8BC1\u89C4\u5219| object| \u2014 |\n| inline| \u884C\u5185\u8868\u5355\u6A21\u5F0F| boolean| false |\n| label-position| \u8868\u5355\u57DF\u6807\u7B7E\u7684\u4F4D\u7F6E\uFF0C \u5F53\u8BBE\u7F6E\u4E3A left \u6216 right \u65F6\uFF0C\u5219\u4E5F\u9700\u8981\u8BBE\u7F6E label-width \u5C5E\u6027| enum| right |\n| label-width| \u6807\u7B7E\u7684\u957F\u5EA6\uFF0C\u4F8B\u5982 '50px'\u3002 \u4F5C\u4E3A Form \u76F4\u63A5\u5B50\u5143\u7D20\u7684 form-item \u4F1A\u7EE7\u627F\u8BE5\u503C\u3002 \u53EF\u4EE5\u4F7F\u7528 auto\u3002| string / number| '' |\n| label-suffix| \u8868\u5355\u57DF\u6807\u7B7E\u7684\u540E\u7F00| string| '' |\n| hide-required-asterisk| \u662F\u5426\u9690\u85CF\u5FC5\u586B\u5B57\u6BB5\u6807\u7B7E\u65C1\u8FB9\u7684\u7EA2\u8272\u661F\u53F7\u3002| boolean| false |\n| require-asterisk-position| \u661F\u53F7\u7684\u4F4D\u7F6E\u3002| enum| left |\n| show-message| \u662F\u5426\u663E\u793A\u6821\u9A8C\u9519\u8BEF\u4FE1\u606F| boolean| true |\n| inline-message| \u662F\u5426\u4EE5\u884C\u5185\u5F62\u5F0F\u5C55\u793A\u6821\u9A8C\u4FE1\u606F| boolean| false |\n| status-icon| \u662F\u5426\u5728\u8F93\u5165\u6846\u4E2D\u663E\u793A\u6821\u9A8C\u7ED3\u679C\u53CD\u9988\u56FE\u6807| boolean| false |\n| validate-on-rule-change| \u662F\u5426\u5728 rules \u5C5E\u6027\u6539\u53D8\u540E\u7ACB\u5373\u89E6\u53D1\u4E00\u6B21\u9A8C\u8BC1| boolean| true |\n| size| \u7528\u4E8E\u63A7\u5236\u8BE5\u8868\u5355\u5185\u7EC4\u4EF6\u7684\u5C3A\u5BF8| enum| \u2014 |\n| disabled| \u662F\u5426\u7981\u7528\u8BE5\u8868\u5355\u5185\u7684\u6240\u6709\u7EC4\u4EF6\u3002 \u5982\u679C\u8BBE\u7F6E\u4E3A true, \u5B83\u5C06\u8986\u76D6\u5185\u90E8\u7EC4\u4EF6\u7684 disabled \u5C5E\u6027| boolean| false |\n| scroll-to-error| \u5F53\u6821\u9A8C\u5931\u8D25\u65F6\uFF0C\u6EDA\u52A8\u5230\u7B2C\u4E00\u4E2A\u9519\u8BEF\u8868\u5355\u9879| boolean| false |\n| scroll-into-view-options 2.3.2| \u5F53\u6821\u9A8C\u6709\u5931\u8D25\u7ED3\u679C\u65F6\uFF0C\u6EDA\u52A8\u5230\u7B2C\u4E00\u4E2A\u5931\u8D25\u7684\u8868\u5355\u9879\u76EE \u53EF\u901A\u8FC7 scrollIntoView \u914D\u7F6E| object / boolean| \u2014 |\n#### \u4E8B\u4EF6\n\n| \u540D\u79F0| \u8BF4\u660E| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| validate| \u4EFB\u4E00\u8868\u5355\u9879\u88AB\u6821\u9A8C\u540E\u89E6\u53D1| Function |\n\n#### Form Slots\n\n| \u4E8B\u4EF6\u540D| \u8BF4\u660E| \u5B50\u6807\u7B7E |\n| :--- | :--- | :--- |\n| default| \u81EA\u5B9A\u4E49\u9ED8\u8BA4\u5185\u5BB9| FormItem |\n\n#### Form Exposes\n\n| \u540D\u79F0| \u8BF4\u660E| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| validate| \u5BF9\u6574\u4E2A\u8868\u5355\u7684\u5185\u5BB9\u8FDB\u884C\u9A8C\u8BC1\u3002 \u63A5\u6536\u4E00\u4E2A\u56DE\u8C03\u51FD\u6570\uFF0C\u6216\u8FD4\u56DE Promise\u3002| Function |\n| validateField| \u9A8C\u8BC1\u5177\u4F53\u7684\u67D0\u4E2A\u5B57\u6BB5\u3002| Function |\n| resetFields| \u91CD\u7F6E\u8BE5\u8868\u5355\u9879\uFF0C\u5C06\u5176\u503C\u91CD\u7F6E\u4E3A\u521D\u59CB\u503C\uFF0C\u5E76\u79FB\u9664\u6821\u9A8C\u7ED3\u679C| Function |\n| scrollToField| \u6EDA\u52A8\u5230\u6307\u5B9A\u7684\u5B57\u6BB5| Function |\n| clearValidate| \u6E05\u7406\u67D0\u4E2A\u5B57\u6BB5\u7684\u8868\u5355\u9A8C\u8BC1\u4FE1\u606F\u3002| Function |\n",
          "model": {
            "type": "attr",
            "values": ["object"],
            "description": "\u8868\u5355\u6570\u636E\u5BF9\u8C61"
          },
          "rules": {
            "type": "attr",
            "values": ["object"],
            "description": "\u8868\u5355\u9A8C\u8BC1\u89C4\u5219"
          },
          "inline": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u884C\u5185\u8868\u5355\u6A21\u5F0F"
          },
          "label-position": {
            "type": "attr",
            "values": ["enum"],
            "description": "\u8868\u5355\u57DF\u6807\u7B7E\u7684\u4F4D\u7F6E\uFF0C \u5F53\u8BBE\u7F6E\u4E3A left \u6216 right \u65F6\uFF0C\u5219\u4E5F\u9700\u8981\u8BBE\u7F6E label-width \u5C5E\u6027"
          },
          "label-width": {
            "type": "attr",
            "values": [],
            "description": "\u6807\u7B7E\u7684\u957F\u5EA6\uFF0C\u4F8B\u5982 '50px'\u3002 \u4F5C\u4E3A Form \u76F4\u63A5\u5B50\u5143\u7D20\u7684 form-item \u4F1A\u7EE7\u627F\u8BE5\u503C\u3002 \u53EF\u4EE5\u4F7F\u7528 auto\u3002"
          },
          "label-suffix": {
            "type": "attr",
            "values": [],
            "description": "\u8868\u5355\u57DF\u6807\u7B7E\u7684\u540E\u7F00"
          },
          "hide-required-asterisk": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u9690\u85CF\u5FC5\u586B\u5B57\u6BB5\u6807\u7B7E\u65C1\u8FB9\u7684\u7EA2\u8272\u661F\u53F7\u3002"
          },
          "require-asterisk-position": {
            "type": "attr",
            "values": ["left", "right"],
            "description": "\u661F\u53F7\u7684\u4F4D\u7F6E\u3002"
          },
          "show-message": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u663E\u793A\u6821\u9A8C\u9519\u8BEF\u4FE1\u606F"
          },
          "inline-message": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u4EE5\u884C\u5185\u5F62\u5F0F\u5C55\u793A\u6821\u9A8C\u4FE1\u606F"
          },
          "status-icon": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u5728\u8F93\u5165\u6846\u4E2D\u663E\u793A\u6821\u9A8C\u7ED3\u679C\u53CD\u9988\u56FE\u6807"
          },
          "validate-on-rule-change": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u5728 rules \u5C5E\u6027\u6539\u53D8\u540E\u7ACB\u5373\u89E6\u53D1\u4E00\u6B21\u9A8C\u8BC1"
          },
          "size": {
            "type": "attr",
            "values": ["large", "default", "small"],
            "description": "\u7528\u4E8E\u63A7\u5236\u8BE5\u8868\u5355\u5185\u7EC4\u4EF6\u7684\u5C3A\u5BF8"
          },
          "disabled": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u7981\u7528\u8BE5\u8868\u5355\u5185\u7684\u6240\u6709\u7EC4\u4EF6\u3002 \u5982\u679C\u8BBE\u7F6E\u4E3A true, \u5B83\u5C06\u8986\u76D6\u5185\u90E8\u7EC4\u4EF6\u7684 disabled \u5C5E\u6027"
          },
          "scroll-to-error": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u5F53\u6821\u9A8C\u5931\u8D25\u65F6\uFF0C\u6EDA\u52A8\u5230\u7B2C\u4E00\u4E2A\u9519\u8BEF\u8868\u5355\u9879"
          },
          "scroll-into-view-options": {
            "type": "attr",
            "values": ["object"],
            "description": "\u5F53\u6821\u9A8C\u6709\u5931\u8D25\u7ED3\u679C\u65F6\uFF0C\u6EDA\u52A8\u5230\u7B2C\u4E00\u4E2A\u5931\u8D25\u7684\u8868\u5355\u9879\u76EE \u53EF\u901A\u8FC7 scrollIntoView \u914D\u7F6E"
          },
          "validate": {
            "type": "event",
            "values": [],
            "description": "\u4EFB\u4E00\u8868\u5355\u9879\u88AB\u6821\u9A8C\u540E\u89E6\u53D1"
          }
        },
        "el-form-item": {
          "_html": {
            "": '<el-form-item label="${1:name}">\n$2\n</el-form-item>',
            ":required": '<el-form-item label="${1:name}" required>\n$2\n</el-form-item>'
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/form.html)\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| Default |\n| :--- | :--- | :--- | :--- |\n| prop| model \u7684\u952E\u540D\u3002 \u5B83\u53EF\u4EE5\u662F\u4E00\u4E2A\u5C5E\u6027\u7684\u503C(\u5982 a.b.0 \u6216 [a', 'b', '0'])\u3002 \u5728\u4F7F\u7528\u4E86 validate\u3001resetFields \u7684\u65B9\u6CD5\u65F6\uFF0C\u8BE5\u5C5E\u6027\u662F\u5FC5\u586B\u7684\u3002| string / string[]| \u2014 |\n| label| \u6807\u7B7E\u6587\u672C| string| \u2014 |\n| label-width| \u6807\u7B7E\u5BBD\u5EA6\uFF0C\u4F8B\u5982 '50px'\u3002 \u53EF\u4EE5\u4F7F\u7528 auto\u3002| string / number| '' |\n| required| \u662F\u5426\u4E3A\u5FC5\u586B\u9879\uFF0C\u5982\u4E0D\u8BBE\u7F6E\uFF0C\u5219\u4F1A\u6839\u636E\u6821\u9A8C\u89C4\u5219\u786E\u8BA4| boolean| \u2014 |\n| rules| \u8868\u5355\u9A8C\u8BC1\u89C4\u5219, \u5177\u4F53\u914D\u7F6E\u89C1\u4E0B\u8868, \u66F4\u591A\u5185\u5BB9\u53EF\u4EE5\u53C2\u8003async-validator| object| \u2014 |\n| error| \u8868\u5355\u57DF\u9A8C\u8BC1\u9519\u8BEF\u65F6\u7684\u63D0\u793A\u4FE1\u606F\u3002\u8BBE\u7F6E\u8BE5\u503C\u4F1A\u5BFC\u81F4\u8868\u5355\u9A8C\u8BC1\u72B6\u6001\u53D8\u4E3A error\uFF0C\u5E76\u663E\u793A\u8BE5\u9519\u8BEF\u4FE1\u606F\u3002| string| \u2014 |\n| show-message| \u662F\u5426\u663E\u793A\u6821\u9A8C\u9519\u8BEF\u4FE1\u606F| boolean| true |\n| inline-message| \u662F\u5426\u5728\u884C\u5185\u663E\u793A\u6821\u9A8C\u4FE1\u606F| string / boolean| '' |\n| size| \u7528\u4E8E\u63A7\u5236\u8BE5\u8868\u5355\u57DF\u4E0B\u7EC4\u4EF6\u7684\u9ED8\u8BA4\u5C3A\u5BF8| enum| \u2014 |\n| for| \u548C\u539F\u751F\u6807\u7B7E\u76F8\u540C\u80FD\u529B| string| \u2014 |\n| validate-status| formitem \u6821\u9A8C\u7684\u72B6\u6001| enum| \u2014 |\n\n| \u540D\u79F0| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| trigger| \u9A8C\u8BC1\u903B\u8F91\u7684\u89E6\u53D1\u65B9\u5F0F| enum| \u2014 |\n\n#### FormItem Slots\n\n| \u63D2\u69FD\u540D| \u8BF4\u660E| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| default| \u8868\u5355\u7684\u5185\u5BB9\u3002| \u2014 |\n| label| \u6807\u7B7E\u4F4D\u7F6E\u663E\u793A\u7684\u5185\u5BB9| object |\n| error| \u9A8C\u8BC1\u9519\u8BEF\u4FE1\u606F\u7684\u663E\u793A\u5185\u5BB9| object |\n\n#### FormItem Exposes\n\n| \u540D\u79F0| \u8BF4\u660E| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| size| \u8868\u5355\u9879\u5927\u5C0F| object |\n| validateMessage| \u6821\u9A8C\u6D88\u606F| object |\n| validateState| \u6821\u9A8C\u72B6\u6001| object |\n| validate| \u9A8C\u8BC1\u8868\u5355\u9879| Function |\n| resetField| \u5BF9\u8BE5\u8868\u5355\u9879\u8FDB\u884C\u91CD\u7F6E\uFF0C\u5C06\u5176\u503C\u91CD\u7F6E\u4E3A\u521D\u59CB\u503C\u5E76\u79FB\u9664\u6821\u9A8C\u7ED3\u679C| Function |\n| clearValidate| \u79FB\u9664\u8BE5\u8868\u5355\u9879\u7684\u6821\u9A8C\u7ED3\u679C| Function |\n\n#### \u7C7B\u578B\u58F0\u660E\n\n#### \u6E90\u4EE3\u7801\n\n#### \u8D21\u732E\u8005\n",
          "prop": {
            "type": "attr",
            "values": [],
            "description": "model \u7684\u952E\u540D\u3002 \u5B83\u53EF\u4EE5\u662F\u4E00\u4E2A\u5C5E\u6027\u7684\u503C(\u5982 a.b.0 \u6216 ['a', 'b', '0'])\u3002 \u5728\u4F7F\u7528\u4E86 validate\u3001resetFields \u7684\u65B9\u6CD5\u65F6\uFF0C\u8BE5\u5C5E\u6027\u662F\u5FC5\u586B\u7684\u3002"
          },
          "label": {
            "type": "attr",
            "values": [],
            "description": "\u6807\u7B7E\u6587\u672C"
          },
          "label-width": {
            "type": "attr",
            "values": [],
            "description": "\u6807\u7B7E\u5BBD\u5EA6\uFF0C\u4F8B\u5982 '50px'\u3002 \u53EF\u4EE5\u4F7F\u7528 auto\u3002"
          },
          "required": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u4E3A\u5FC5\u586B\u9879\uFF0C\u5982\u4E0D\u8BBE\u7F6E\uFF0C\u5219\u4F1A\u6839\u636E\u6821\u9A8C\u89C4\u5219\u786E\u8BA4"
          },
          "rules": {
            "type": "attr",
            "values": ["object"],
            "description": "\u8868\u5355\u9A8C\u8BC1\u89C4\u5219, \u5177\u4F53\u914D\u7F6E\u89C1\u4E0B\u8868, \u66F4\u591A\u5185\u5BB9\u53EF\u4EE5\u53C2\u8003async-validator"
          },
          "error": {
            "type": "attr",
            "values": [],
            "description": "\u8868\u5355\u57DF\u9A8C\u8BC1\u9519\u8BEF\u65F6\u7684\u63D0\u793A\u4FE1\u606F\u3002\u8BBE\u7F6E\u8BE5\u503C\u4F1A\u5BFC\u81F4\u8868\u5355\u9A8C\u8BC1\u72B6\u6001\u53D8\u4E3A error\uFF0C\u5E76\u663E\u793A\u8BE5\u9519\u8BEF\u4FE1\u606F\u3002"
          },
          "show-message": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u663E\u793A\u6821\u9A8C\u9519\u8BEF\u4FE1\u606F"
          },
          "inline-message": {
            "type": "attr",
            "values": [],
            "description": "\u662F\u5426\u5728\u884C\u5185\u663E\u793A\u6821\u9A8C\u4FE1\u606F"
          },
          "size": {
            "type": "attr",
            "values": ["large", "default", "small"],
            "description": "\u7528\u4E8E\u63A7\u5236\u8BE5\u8868\u5355\u57DF\u4E0B\u7EC4\u4EF6\u7684\u9ED8\u8BA4\u5C3A\u5BF8"
          },
          "for": {
            "type": "attr",
            "values": [],
            "description": "\u548C\u539F\u751F\u6807\u7B7E\u76F8\u540C\u80FD\u529B"
          },
          "validate-status": {
            "type": "attr",
            "values": ["error", "validating", "success"],
            "description": "formitem \u6821\u9A8C\u7684\u72B6\u6001"
          }
        },
        "el-input": {
          "_html": {
            "": '<el-input v-model="${1:value}" placeholder="Please Input" clearable>$2</el-input>',
            ":textarea": '<el-input v-model="${1:textarea}" type="textarea" :rows="2" placeholder="Please Input" clearable />',
            ":textarea.limit": '<el-input v-model="${1:textarea}" type="textarea" :rows="2" placeholder="Please Input" clearable maxlength="$2" show-word-limit />',
            ":prepend[slot]": "<template #prepend>$1</template>",
            ":append[slot]": "<template #append>$1</template>"
          },
          "_doc": `#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/input.html)
#### \u5C5E\u6027

| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4\u503C |
| :--- | :--- | :--- | :--- |
| type| \u7C7B\u578B| string \u7B49\u539F\u751F input \u7C7B\u578B| text |
| model-value / v-model| \u7ED1\u5B9A\u503C| string / number| \u2014 |
| maxlength| \u540C\u539F\u751F maxlength \u5C5E\u6027| string / number| \u2014 |
| minlength| \u539F\u751F\u5C5E\u6027\uFF0C\u6700\u5C0F\u8F93\u5165\u957F\u5EA6| string / number| \u2014 |
| show-word-limit| \u662F\u5426\u663E\u793A\u7EDF\u8BA1\u5B57\u6570, \u53EA\u5728 type \u4E3A 'text' \u6216 'textarea' \u7684\u65F6\u5019\u751F\u6548| boolean| boolean |
| placeholder| \u8F93\u5165\u6846\u5360\u4F4D\u6587\u672C| string| \u2014 |
| clearable| \u662F\u5426\u663E\u793A\u6E05\u9664\u6309\u94AE\uFF0C\u53EA\u6709\u5F53 type \u4E0D\u662F textarea\u65F6\u751F\u6548| boolean| false |
| formatter| \u6307\u5B9A\u8F93\u5165\u503C\u7684\u683C\u5F0F\u3002(\u53EA\u6709\u5F53 type \u662F"text"\u65F6\u624D\u80FD\u5DE5\u4F5C)| Function| \u2014 |
| parser| \u6307\u5B9A\u4ECE\u683C\u5F0F\u5316\u5668\u8F93\u5165\u4E2D\u63D0\u53D6\u7684\u503C\u3002(\u4EC5\u5F53 type \u662F"text"\u65F6\u624D\u8D77\u4F5C\u7528)| Function| \u2014 |
| show-password| \u662F\u5426\u663E\u793A\u5207\u6362\u5BC6\u7801\u56FE\u6807| boolean| false |
| disabled| \u662F\u5426\u7981\u7528| boolean| false |
| size| \u8F93\u5165\u6846\u5C3A\u5BF8\uFF0C\u53EA\u5728 type \u4E0D\u4E3A 'textarea' \u65F6\u6709\u6548| enum| \u2014 |
| prefix-icon| \u81EA\u5B9A\u4E49\u524D\u7F00\u56FE\u6807| string / Component| \u2014 |
| suffix-icon| \u81EA\u5B9A\u4E49\u540E\u7F00\u56FE\u6807| string / Component| \u2014 |
| rows| \u8F93\u5165\u6846\u884C\u6570\uFF0C\u4EC5 type \u4E3A 'textarea' \u65F6\u6709\u6548| number| number |
| autosize| textarea \u9AD8\u5EA6\u662F\u5426\u81EA\u9002\u5E94\uFF0C\u4EC5 type \u4E3A 'textarea' \u65F6\u751F\u6548\u3002 \u53EF\u4EE5\u63A5\u53D7\u4E00\u4E2A\u5BF9\u8C61\uFF0C\u6BD4\u5982: { minRows: 2, maxRows: 6 }| boolean / object| false |
| autocomplete| \u539F\u751F autocomplete \u5C5E\u6027| string| off |
| name| \u7B49\u4EF7\u4E8E\u539F\u751F input name \u5C5E\u6027| string| \u2014 |
| readonly| \u539F\u751F readonly \u5C5E\u6027\uFF0C\u662F\u5426\u53EA\u8BFB| boolean| false |
| max| \u539F\u751F max \u5C5E\u6027\uFF0C\u8BBE\u7F6E\u6700\u5927\u503C| \u2014| \u2014 |
| min| \u539F\u751F\u5C5E\u6027\uFF0C\u8BBE\u7F6E\u6700\u5C0F\u503C| \u2014| \u2014 |
| step| \u539F\u751F\u5C5E\u6027\uFF0C\u8BBE\u7F6E\u8F93\u5165\u5B57\u6BB5\u7684\u5408\u6CD5\u6570\u5B57\u95F4\u9694| \u2014| \u2014 |
| resize| \u63A7\u5236\u662F\u5426\u80FD\u88AB\u7528\u6237\u7F29\u653E| enum| \u2014 |
| autofocus| \u539F\u751F\u5C5E\u6027\uFF0C\u81EA\u52A8\u83B7\u53D6\u7126\u70B9| boolean| false |
| form| \u539F\u751F\u5C5E\u6027| string| \u2014 |
| label a11y| \u7B49\u4EF7\u4E8E\u539F\u751F input aria-label \u5C5E\u6027| string| \u2014 |
| tabindex| \u8F93\u5165\u6846\u7684 tabindex| string / number| \u2014 |
| validate-event| \u8F93\u5165\u65F6\u662F\u5426\u89E6\u53D1\u8868\u5355\u7684\u6821\u9A8C| boolean| true |
| input-style| input \u5143\u7D20\u6216 textarea \u5143\u7D20\u7684 style| string / object| {} |
#### \u4E8B\u4EF6

| \u4E8B\u4EF6\u540D| \u8BF4\u660E| \u7C7B\u578B |
| :--- | :--- | :--- |
| blur| \u5F53\u9009\u62E9\u5668\u7684\u8F93\u5165\u6846\u5931\u53BB\u7126\u70B9\u65F6\u89E6\u53D1| Function |
| focus| \u5F53\u9009\u62E9\u5668\u7684\u8F93\u5165\u6846\u83B7\u5F97\u7126\u70B9\u65F6\u89E6\u53D1| Function |
| change| \u4EC5\u5F53 modelValue \u6539\u53D8\u65F6\uFF0C\u5F53\u8F93\u5165\u6846\u5931\u53BB\u7126\u70B9\u6216\u7528\u6237\u6309Enter\u65F6\u89E6\u53D1| Function |
| input| \u5728 Input \u503C\u6539\u53D8\u65F6\u89E6\u53D1| Function |
| clear| \u5728\u70B9\u51FB\u7531 clearable \u5C5E\u6027\u751F\u6210\u7684\u6E05\u7A7A\u6309\u94AE\u65F6\u89E6\u53D1| Function |

#### Slots

| \u63D2\u69FD\u540D| \u8BF4\u660E |
| :--- | :--- |
| prefix| \u8F93\u5165\u6846\u5934\u90E8\u5185\u5BB9\uFF0C\u53EA\u5BF9\u975E type="textarea" \u6709\u6548 |
| suffix| \u8F93\u5165\u6846\u5C3E\u90E8\u5185\u5BB9\uFF0C\u53EA\u5BF9\u975E type="textarea" \u6709\u6548 |
| prepend| \u8F93\u5165\u6846\u524D\u7F6E\u5185\u5BB9\uFF0C\u53EA\u5BF9\u975E type="textarea" \u6709\u6548 |
| append| \u8F93\u5165\u6846\u540E\u7F6E\u5185\u5BB9\uFF0C\u53EA\u5BF9\u975E type="textarea" \u6709\u6548 |

#### Exposes

| \u540D\u79F0| \u8BF4\u660E| \u7C7B\u578B |
| :--- | :--- | :--- |
| blur| \u4F7F input \u5931\u53BB\u7126\u70B9| Function |
| clear| \u6E05\u9664 input \u503C| Function |
| focus| \u4F7F input \u83B7\u53D6\u7126\u70B9| Function |
| input| Input HTML \u5143\u7D20| object |
| ref| HTML\u5143\u7D20 input \u6216 textarea| object |
| resizeTextarea| \u6539\u53D8 textarea \u5927\u5C0F| Function |
| select| \u9009\u4E2D input \u4E2D\u7684\u6587\u5B57| Function |
| textarea| HTML textarea \u5143\u7D20| object |
| textareaStyle| textarea \u7684\u6837\u5F0F| object |

#### \u5E38\u89C1\u95EE\u9898

#### \u6E90\u4EE3\u7801

#### \u8D21\u732E\u8005
`,
          "type": {
            "type": "attr",
            "values": [],
            "description": "\u7C7B\u578B"
          },
          "v-model": {
            "type": "attr",
            "values": [],
            "description": "\u7ED1\u5B9A\u503C"
          },
          "maxlength": {
            "type": "attr",
            "values": [],
            "description": "\u540C\u539F\u751F maxlength \u5C5E\u6027"
          },
          "minlength": {
            "type": "attr",
            "values": [],
            "description": "\u539F\u751F\u5C5E\u6027\uFF0C\u6700\u5C0F\u8F93\u5165\u957F\u5EA6"
          },
          "show-word-limit": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u663E\u793A\u7EDF\u8BA1\u5B57\u6570, \u53EA\u5728 type \u4E3A 'text' \u6216 'textarea' \u7684\u65F6\u5019\u751F\u6548"
          },
          "placeholder": {
            "type": "attr",
            "values": [],
            "description": "\u8F93\u5165\u6846\u5360\u4F4D\u6587\u672C"
          },
          "clearable": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u663E\u793A\u6E05\u9664\u6309\u94AE\uFF0C\u53EA\u6709\u5F53 type \u4E0D\u662F textarea\u65F6\u751F\u6548"
          },
          "formatter": {
            "type": "attr",
            "values": ["Function"],
            "description": '\u6307\u5B9A\u8F93\u5165\u503C\u7684\u683C\u5F0F\u3002(\u53EA\u6709\u5F53 type \u662F"text"\u65F6\u624D\u80FD\u5DE5\u4F5C)'
          },
          "parser": {
            "type": "attr",
            "values": ["Function"],
            "description": '\u6307\u5B9A\u4ECE\u683C\u5F0F\u5316\u5668\u8F93\u5165\u4E2D\u63D0\u53D6\u7684\u503C\u3002(\u4EC5\u5F53 type \u662F"text"\u65F6\u624D\u8D77\u4F5C\u7528)'
          },
          "show-password": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u663E\u793A\u5207\u6362\u5BC6\u7801\u56FE\u6807"
          },
          "disabled": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u7981\u7528"
          },
          "size": {
            "type": "attr",
            "values": ["large", "default", "small"],
            "description": "\u8F93\u5165\u6846\u5C3A\u5BF8\uFF0C\u53EA\u5728 type \u4E0D\u4E3A 'textarea' \u65F6\u6709\u6548"
          },
          "prefix-icon": {
            "type": "attr",
            "values": [],
            "description": "\u81EA\u5B9A\u4E49\u524D\u7F00\u56FE\u6807"
          },
          "suffix-icon": {
            "type": "attr",
            "values": [],
            "description": "\u81EA\u5B9A\u4E49\u540E\u7F00\u56FE\u6807"
          },
          "rows": {
            "type": "attr",
            "values": ["number"],
            "description": "\u8F93\u5165\u6846\u884C\u6570\uFF0C\u4EC5 type \u4E3A 'textarea' \u65F6\u6709\u6548"
          },
          "autosize": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "textarea \u9AD8\u5EA6\u662F\u5426\u81EA\u9002\u5E94\uFF0C\u4EC5 type \u4E3A 'textarea' \u65F6\u751F\u6548\u3002 \u53EF\u4EE5\u63A5\u53D7\u4E00\u4E2A\u5BF9\u8C61\uFF0C\u6BD4\u5982: { minRows: 2, maxRows: 6 }"
          },
          "autocomplete": {
            "type": "attr",
            "values": [],
            "description": "\u539F\u751F autocomplete \u5C5E\u6027"
          },
          "name": {
            "type": "attr",
            "values": [],
            "description": "\u7B49\u4EF7\u4E8E\u539F\u751F input name \u5C5E\u6027"
          },
          "readonly": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u539F\u751F readonly \u5C5E\u6027\uFF0C\u662F\u5426\u53EA\u8BFB"
          },
          "max": {
            "type": "attr",
            "values": [],
            "description": "\u539F\u751F max \u5C5E\u6027\uFF0C\u8BBE\u7F6E\u6700\u5927\u503C"
          },
          "min": {
            "type": "attr",
            "values": [],
            "description": "\u539F\u751F\u5C5E\u6027\uFF0C\u8BBE\u7F6E\u6700\u5C0F\u503C"
          },
          "step": {
            "type": "attr",
            "values": [],
            "description": "\u539F\u751F\u5C5E\u6027\uFF0C\u8BBE\u7F6E\u8F93\u5165\u5B57\u6BB5\u7684\u5408\u6CD5\u6570\u5B57\u95F4\u9694"
          },
          "resize": {
            "type": "attr",
            "values": ["none", "both", "horizontal", "vertical"],
            "description": "\u63A7\u5236\u662F\u5426\u80FD\u88AB\u7528\u6237\u7F29\u653E"
          },
          "autofocus": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u539F\u751F\u5C5E\u6027\uFF0C\u81EA\u52A8\u83B7\u53D6\u7126\u70B9"
          },
          "form": {
            "type": "attr",
            "values": [],
            "description": "\u539F\u751F\u5C5E\u6027"
          },
          "labelaydeprecated": {
            "type": "attr",
            "values": [],
            "description": "\u7B49\u4EF7\u4E8E\u539F\u751F input aria-label \u5C5E\u6027"
          },
          "aria-labelay": {
            "type": "attr",
            "values": [],
            "description": "\u7B49\u4EF7\u4E8E\u539F\u751F input aria-label \u5C5E\u6027"
          },
          "tabindex": {
            "type": "attr",
            "values": [],
            "description": "\u8F93\u5165\u6846\u7684 tabindex"
          },
          "validate-event": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u8F93\u5165\u65F6\u662F\u5426\u89E6\u53D1\u8868\u5355\u7684\u6821\u9A8C"
          },
          "input-style": {
            "type": "attr",
            "values": [],
            "description": "input \u5143\u7D20\u6216 textarea \u5143\u7D20\u7684 style"
          },
          "blur": {
            "type": "event",
            "values": [],
            "description": "\u5F53\u9009\u62E9\u5668\u7684\u8F93\u5165\u6846\u5931\u53BB\u7126\u70B9\u65F6\u89E6\u53D1"
          },
          "focus": {
            "type": "event",
            "values": [],
            "description": "\u5F53\u9009\u62E9\u5668\u7684\u8F93\u5165\u6846\u83B7\u5F97\u7126\u70B9\u65F6\u89E6\u53D1"
          },
          "change": {
            "type": "event",
            "values": [],
            "description": "\u4EC5\u5F53 modelValue \u6539\u53D8\u65F6\uFF0C\u5F53\u8F93\u5165\u6846\u5931\u53BB\u7126\u70B9\u6216\u7528\u6237\u6309Enter\u65F6\u89E6\u53D1"
          },
          "input": {
            "type": "event",
            "values": [],
            "description": "\u5728 Input \u503C\u6539\u53D8\u65F6\u89E6\u53D1"
          },
          "clear": {
            "type": "event",
            "values": [],
            "description": "\u5728\u70B9\u51FB\u7531 clearable \u5C5E\u6027\u751F\u6210\u7684\u6E05\u7A7A\u6309\u94AE\u65F6\u89E6\u53D1"
          }
        },
        "el-input-number": {
          "_html": {
            "": '<el-input-number v-model="${1:num}" :min="${2:1}" :max="${3:10}" />',
            ":step": '<el-input-number v-model="${1:num}" :min="${2:1}" :max="${3:10}" :step="${4:2}" />'
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/input-number.html)\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| model-value / v-model| \u9009\u4E2D\u9879\u7ED1\u5B9A\u503C| number| \u2014 |\n| min| \u8BBE\u7F6E\u8BA1\u6570\u5668\u5141\u8BB8\u7684\u6700\u5C0F\u503C| number| -Infinity |\n| max| \u8BBE\u7F6E\u8BA1\u6570\u5668\u5141\u8BB8\u7684\u6700\u5927\u503C| number| Infinity |\n| step| \u8BA1\u6570\u5668\u6B65\u957F| number| 1 |\n| step-strictly| \u662F\u5426\u53EA\u80FD\u8F93\u5165 step \u7684\u500D\u6570| boolean| false |\n| precision| \u6570\u503C\u7CBE\u5EA6| number| \u2014 |\n| size| \u8BA1\u6570\u5668\u5C3A\u5BF8| enum| default |\n| readonly 2.2.16| \u539F\u751F readonly \u5C5E\u6027\uFF0C\u662F\u5426\u53EA\u8BFB| boolean| false |\n| disabled| \u662F\u5426\u7981\u7528\u72B6\u6001| boolean| false |\n| controls| \u662F\u5426\u4F7F\u7528\u63A7\u5236\u6309\u94AE| boolean| true |\n| controls-position| \u63A7\u5236\u6309\u94AE\u4F4D\u7F6E| enum| \u2014 |\n| name| \u7B49\u4EF7\u4E8E\u539F\u751F input name \u5C5E\u6027| string| \u2014 |\n| label| \u7B49\u4EF7\u4E8E\u539F\u751F input label \u5C5E\u6027| string| \u2014 |\n| placeholder| \u7B49\u4EF7\u4E8E\u539F\u751F input placeholder \u5C5E\u6027| string| \u2014 |\n| id| \u7B49\u4EF7\u4E8E\u539F\u751F input id \u5C5E\u6027| string| \u2014 |\n| value-on-clear 2.2.0| \u5F53\u8F93\u5165\u6846\u88AB\u6E05\u7A7A\u65F6\u663E\u793A\u7684\u503C| number / null / enum| \u2014 |\n| validate-event| \u662F\u5426\u89E6\u53D1\u8868\u5355\u9A8C\u8BC1| boolean| true |\n#### \u4E8B\u4EF6\n\n| \u4E8B\u4EF6\u540D| \u8BF4\u660E| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| change| \u7ED1\u5B9A\u503C\u88AB\u6539\u53D8\u65F6\u89E6\u53D1| Function |\n| blur| \u5728\u7EC4\u4EF6 Input \u5931\u53BB\u7126\u70B9\u65F6\u89E6\u53D1| Function |\n| focus| \u5728\u7EC4\u4EF6 Input \u83B7\u5F97\u7126\u70B9\u65F6\u89E6\u53D1| Function |\n\n#### Exposes\n\n| \u540D\u79F0| \u8BF4\u660E| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| focus| \u4F7F input \u7EC4\u4EF6\u83B7\u5F97\u7126\u70B9| Function |\n| blur| \u4F7F input \u7EC4\u4EF6\u5931\u53BB\u7126\u70B9| Function |\n\n#### \u6E90\u4EE3\u7801\n\n#### \u8D21\u732E\u8005\n",
          "v-model": {
            "type": "attr",
            "values": ["number"],
            "description": "\u9009\u4E2D\u9879\u7ED1\u5B9A\u503C"
          },
          "min": {
            "type": "attr",
            "values": ["number"],
            "description": "\u8BBE\u7F6E\u8BA1\u6570\u5668\u5141\u8BB8\u7684\u6700\u5C0F\u503C"
          },
          "max": {
            "type": "attr",
            "values": ["number"],
            "description": "\u8BBE\u7F6E\u8BA1\u6570\u5668\u5141\u8BB8\u7684\u6700\u5927\u503C"
          },
          "step": {
            "type": "attr",
            "values": ["number"],
            "description": "\u8BA1\u6570\u5668\u6B65\u957F"
          },
          "step-strictly": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u53EA\u80FD\u8F93\u5165 step \u7684\u500D\u6570"
          },
          "precision": {
            "type": "attr",
            "values": ["number"],
            "description": "\u6570\u503C\u7CBE\u5EA6"
          },
          "size": {
            "type": "attr",
            "values": ["large", "default", "small"],
            "description": "\u8BA1\u6570\u5668\u5C3A\u5BF8"
          },
          "readonly": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u539F\u751F readonly \u5C5E\u6027\uFF0C\u662F\u5426\u53EA\u8BFB"
          },
          "disabled": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u7981\u7528\u72B6\u6001"
          },
          "controls": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u4F7F\u7528\u63A7\u5236\u6309\u94AE"
          },
          "controls-position": {
            "type": "attr",
            "values": ["right"],
            "description": "\u63A7\u5236\u6309\u94AE\u4F4D\u7F6E"
          },
          "name": {
            "type": "attr",
            "values": [],
            "description": "\u7B49\u4EF7\u4E8E\u539F\u751F input name \u5C5E\u6027"
          },
          "labelaydeprecated": {
            "type": "attr",
            "values": [],
            "description": "\u7B49\u4EF7\u4E8E\u539F\u751F input aria-label \u5C5E\u6027"
          },
          "aria-labelay": {
            "type": "attr",
            "values": [],
            "description": "\u7B49\u4EF7\u4E8E\u539F\u751F input aria-label \u5C5E\u6027"
          },
          "placeholder": {
            "type": "attr",
            "values": [],
            "description": "\u7B49\u4EF7\u4E8E\u539F\u751F input placeholder \u5C5E\u6027"
          },
          "id": {
            "type": "attr",
            "values": [],
            "description": "\u7B49\u4EF7\u4E8E\u539F\u751F input id \u5C5E\u6027"
          },
          "value-on-clear": {
            "type": "attr",
            "values": ["number"],
            "description": "\u5F53\u8F93\u5165\u6846\u88AB\u6E05\u7A7A\u65F6\u663E\u793A\u7684\u503C"
          },
          "validate-event": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u89E6\u53D1\u8868\u5355\u9A8C\u8BC1"
          },
          "change": {
            "type": "event",
            "values": [],
            "description": "\u7ED1\u5B9A\u503C\u88AB\u6539\u53D8\u65F6\u89E6\u53D1"
          },
          "blur": {
            "type": "event",
            "values": [],
            "description": "\u5728\u7EC4\u4EF6 Input \u5931\u53BB\u7126\u70B9\u65F6\u89E6\u53D1"
          },
          "focus": {
            "type": "event",
            "values": [],
            "description": "\u5728\u7EC4\u4EF6 Input \u83B7\u5F97\u7126\u70B9\u65F6\u89E6\u53D1"
          }
        },
        "el-radio-group": {
          "_html": {
            "": '<el-radio-group v-model="${1:radio}">\n<el-radio value="$2">$3</el-radio>\n</el-radio-group>',
            ":for": '<el-radio-group v-model="${1:radio}">\n<el-radio v-for="item in ${2:radios}" :value="item.value">{{ item.label }}</el-radio>\n</el-radio-group>'
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/radio.html)\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| model-value / v-model| \u7ED1\u5B9A\u503C| string / number / boolean| \u2014 |\n| size| \u5355\u9009\u6846\u6309\u94AE\u6216\u8FB9\u6846\u6309\u94AE\u7684\u5927\u5C0F| string| default |\n| disabled| \u662F\u5426\u7981\u7528| boolean| false |\n| text-color| \u6309\u94AE\u5F62\u5F0F\u7684 Radio \u6FC0\u6D3B\u65F6\u7684\u6587\u672C\u989C\u8272| string| #ffffff |\n| fill| \u6309\u94AE\u5F62\u5F0F\u7684 Radio \u6FC0\u6D3B\u65F6\u7684\u586B\u5145\u8272\u548C\u8FB9\u6846\u8272| string| #409EFF |\n| validate-event| \u8F93\u5165\u65F6\u662F\u5426\u89E6\u53D1\u8868\u5355\u7684\u6821\u9A8C| boolean| true |\n| label a11y| \u4E0E RadioGroup \u4E2D\u7684 aria-label \u5C5E\u6027\u76F8\u540C| string| \u2014 |\n| name| \u539F\u751F name \u5C5E\u6027| string| \u2014 |\n| id| \u539F\u751F id \u5C5E\u6027| string| \u2014 |\n#### \u4E8B\u4EF6\n\n| \u4E8B\u4EF6\u540D| \u8BF4\u660E| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| change| \u7ED1\u5B9A\u503C\u53D8\u5316\u65F6\u89E6\u53D1\u7684\u4E8B\u4EF6| Function |\n\n#### RadioGroup Slots\n\n| \u63D2\u69FD\u540D| \u8BF4\u660E| \u5B50\u6807\u7B7E |\n| :--- | :--- | :--- |\n| default| \u81EA\u5B9A\u4E49\u9ED8\u8BA4\u5185\u5BB9| Radio / RadioButton |\n",
          "v-model": {
            "type": "attr",
            "values": [],
            "description": "\u7ED1\u5B9A\u503C"
          },
          "size": {
            "type": "attr",
            "values": [],
            "description": "\u5355\u9009\u6846\u6309\u94AE\u6216\u8FB9\u6846\u6309\u94AE\u7684\u5927\u5C0F"
          },
          "disabled": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u7981\u7528"
          },
          "text-color": {
            "type": "attr",
            "values": [],
            "description": "\u6309\u94AE\u5F62\u5F0F\u7684 Radio \u6FC0\u6D3B\u65F6\u7684\u6587\u672C\u989C\u8272"
          },
          "fill": {
            "type": "attr",
            "values": [],
            "description": "\u6309\u94AE\u5F62\u5F0F\u7684 Radio \u6FC0\u6D3B\u65F6\u7684\u586B\u5145\u8272\u548C\u8FB9\u6846\u8272"
          },
          "validate-event": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u8F93\u5165\u65F6\u662F\u5426\u89E6\u53D1\u8868\u5355\u7684\u6821\u9A8C"
          },
          "labelaydeprecated": {
            "type": "attr",
            "values": [],
            "description": "\u4E0E RadioGroup \u4E2D\u7684 aria-label \u5C5E\u6027\u76F8\u540C"
          },
          "aria-labelay": {
            "type": "attr",
            "values": [],
            "description": "\u4E0E RadioGroup \u4E2D\u7684 aria-label \u5C5E\u6027\u76F8\u540C"
          },
          "name": {
            "type": "attr",
            "values": [],
            "description": "\u539F\u751F name \u5C5E\u6027"
          },
          "id": {
            "type": "attr",
            "values": [],
            "description": "\u539F\u751F id \u5C5E\u6027"
          },
          "change": {
            "type": "event",
            "values": [],
            "description": "\u7ED1\u5B9A\u503C\u53D8\u5316\u65F6\u89E6\u53D1\u7684\u4E8B\u4EF6"
          }
        },
        "el-radio": {
          "_html": {
            "": '<el-radio :value="$1">$2</el-radio>'
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/radio.html)\n\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| model-value / v-model| \u9009\u4E2D\u9879\u7ED1\u5B9A\u503C| string / number / boolean| \u2014 |\n| value 2.6.0| \u5355\u9009\u6846\u7684\u503C| string / number / boolean| \u2014 |\n| label| \u5355\u9009\u6846\u7684 label \u5982\u679C\u6CA1\u6709 value\uFF0C label\u5219\u4F5C\u4E3Avalue\u4F7F\u7528| string / number / boolean| \u2014 |\n| disabled| \u662F\u5426\u7981\u7528\u5355\u9009\u6846| boolean| false |\n| border| \u662F\u5426\u663E\u793A\u8FB9\u6846| boolean| false |\n| size| \u5355\u9009\u6846\u7684\u5C3A\u5BF8| enum| \u2014 |\n| name| \u539F\u59CB name \u5C5E\u6027| string| \u2014 |\n#### \u4E8B\u4EF6\n\n| \u4E8B\u4EF6\u540D| \u8BF4\u660E| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| change| \u7ED1\u5B9A\u503C\u53D8\u5316\u65F6\u89E6\u53D1\u7684\u4E8B\u4EF6| Function |\n\n#### Radio Slots\n\n| \u63D2\u69FD\u540D| \u8BF4\u660E |\n| :--- | :--- |\n| default| \u81EA\u5B9A\u4E49\u9ED8\u8BA4\u5185\u5BB9 |\n",
          "v-model": {
            "type": "attr",
            "values": [],
            "description": "\u9009\u4E2D\u9879\u7ED1\u5B9A\u503C"
          },
          "value": {
            "type": "attr",
            "values": [],
            "description": "\u5355\u9009\u6846\u7684\u503C"
          },
          "label": {
            "type": "attr",
            "values": [],
            "description": "\u5355\u9009\u6846\u7684 label \u5982\u679Cvalue\u6CA1\u6709\u503C\uFF0C label\u5219\u4F5C\u4E3Avalue\u4F7F\u7528"
          },
          "disabled": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u7981\u7528\u5355\u9009\u6846"
          },
          "border": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u663E\u793A\u8FB9\u6846"
          },
          "size": {
            "type": "attr",
            "values": ["large", "large", "small"],
            "description": "\u5355\u9009\u6846\u7684\u5C3A\u5BF8"
          },
          "name": {
            "type": "attr",
            "values": [],
            "description": "\u539F\u59CB name \u5C5E\u6027"
          },
          "change": {
            "type": "event",
            "values": [],
            "description": "\u7ED1\u5B9A\u503C\u53D8\u5316\u65F6\u89E6\u53D1\u7684\u4E8B\u4EF6"
          }
        },
        "el-radio-button": {
          "_html": {
            "": '<el-radio-button label="$1" value="$2"></el-radio-button>'
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/radio.html)\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4 |\n| :--- | :--- | :--- | :--- |\n| value 2.6.0| \u5355\u9009\u6846\u7684\u503C| string / number / boolean| \u2014 |\n| label| \u5355\u9009\u6846\u7684 label \u5982\u679C\u6CA1\u6709 value\uFF0C label\u5219\u4F5C\u4E3Avalue\u4F7F\u7528| string / number / boolean| \u2014 |\n| disabled| \u662F\u5426\u7981\u7528\u5355\u9009\u6846| boolean| false |\n| name| \u539F\u751F name \u5C5E\u6027| string| \u2014 |\n\n#### RadioButton Slots\n\n| \u63D2\u69FD\u540D| \u8BF4\u660E |\n| :--- | :--- |\n| default| \u9ED8\u8BA4\u63D2\u69FD\u5185\u5BB9 |\n\n#### \u6E90\u4EE3\u7801\n\n#### \u8D21\u732E\u8005\n",
          "value": {
            "type": "attr",
            "values": [],
            "description": "\u5355\u9009\u6846\u7684\u503C"
          },
          "label": {
            "type": "attr",
            "values": [],
            "description": "\u5355\u9009\u6846\u7684 label \u5982\u679C\u6CA1\u6709 value\uFF0C label\u5219\u4F5C\u4E3Avalue\u4F7F\u7528"
          },
          "disabled": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u7981\u7528\u5355\u9009\u6846"
          },
          "name": {
            "type": "attr",
            "values": [],
            "description": "\u539F\u751F name \u5C5E\u6027"
          }
        },
        "el-rate": {
          "_html": {
            "": '<el-rate v-model="${1:value}" />',
            ":show-text": `<el-rate v-model="\${1:value}" texts="['oops', 'disappointed', 'normal', 'good', 'great']" show-text />`,
            ":allow-half": '<el-rate v-model="${1:value}" allow-half />'
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/rate.html)\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| model-value / v-model| \u9009\u4E2D\u9879\u7ED1\u5B9A\u503C| number| 0 |\n| max| \u6700\u5927\u5206\u503C| number| 5 |\n| size| \u5C3A\u5BF8| enum| \u2014 |\n| disabled| \u662F\u5426\u4E3A\u53EA\u8BFB| boolean| false |\n| allow-half| \u662F\u5426\u5141\u8BB8\u534A\u9009| boolean| false |\n| low-threshold| \u4F4E\u5206\u548C\u4E2D\u7B49\u5206\u6570\u7684\u754C\u9650\u503C\uFF0C \u503C\u672C\u8EAB\u88AB\u5212\u5206\u5728\u4F4E\u5206\u4E2D| number| 2 |\n| high-threshold| \u9AD8\u5206\u548C\u4E2D\u7B49\u5206\u6570\u7684\u754C\u9650\u503C\uFF0C \u503C\u672C\u8EAB\u88AB\u5212\u5206\u5728\u9AD8\u5206\u4E2D| number| 4 |\n| colors| icon \u7684\u989C\u8272\u3002 \u82E5\u4F20\u5165\u6570\u7EC4\uFF0C\u5171\u6709 3 \u4E2A\u5143\u7D20\uFF0C\u4E3A 3 \u4E2A\u5206\u6BB5\u6240\u5BF9\u5E94\u7684\u989C\u8272\uFF1B\u82E5\u4F20\u5165\u5BF9\u8C61\uFF0C\u53EF\u81EA\u5B9A\u4E49\u5206\u6BB5\uFF0C\u952E\u540D\u4E3A\u5206\u6BB5\u7684\u754C\u9650\u503C\uFF0C\u952E\u503C\u4E3A\u5BF9\u5E94\u7684\u989C\u8272| object| ['#F7BA2A', '#F7BA2A', '#F7BA2A'] |\n| void-color| \u672A\u9009\u4E2D icon \u7684\u989C\u8272| string| #C6D1DE |\n| disabled-void-color| \u53EA\u8BFB\u65F6\u672A\u9009\u4E2D icon \u7684\u989C\u8272| string| #EFF2F7 |\n| icons| \u56FE\u6807\u7EC4\u4EF6 \u82E5\u4F20\u5165\u6570\u7EC4\uFF0C\u5219\u9700\u8981\u4F20\u5165 3 \u4E2A\u5143\u7D20\uFF0C\u5206\u522B\u4E3A 3 \u4E2A\u90E8\u5206\u6240\u5BF9\u5E94\u7684\u7C7B\u540D\uFF1B\u82E5\u4F20\u5165\u5BF9\u8C61\uFF0C\u5219\u53EF\u81EA\u5B9A\u4E49\u5206\u6BB5\uFF0C\u952E\u540D\u4E3A\u5206\u6BB5\u7684\u754C\u9650\u503C\uFF0C\u952E\u503C\u4E3A\u5BF9\u5E94\u7684\u7C7B\u540D| object| [StarFilled, StarFilled, StarFilled] |\n| void-icon| \u672A\u88AB\u9009\u4E2D\u7684\u56FE\u6807\u7EC4\u4EF6| string / Component| Star |\n| disabled-void-icon| \u7981\u7528\u72B6\u6001\u7684\u672A\u9009\u62E9\u56FE\u6807| string / Component| StarFilled |\n| show-text| \u662F\u5426\u663E\u793A\u8F85\u52A9\u6587\u5B57\uFF0C\u82E5\u4E3A\u771F\uFF0C\u5219\u4F1A\u4ECE texts \u6570\u7EC4\u4E2D\u9009\u53D6\u5F53\u524D\u5206\u6570\u5BF9\u5E94\u7684\u6587\u5B57\u5185\u5BB9| boolean| false |\n| show-score| \u662F\u5426\u663E\u793A\u5F53\u524D\u5206\u6570\uFF0C show-score \u548C show-text \u4E0D\u80FD\u540C\u65F6\u4E3A\u771F| boolean| false |\n| text-color| \u8F85\u52A9\u6587\u5B57\u7684\u989C\u8272| string| '' |\n| texts| \u8F85\u52A9\u6587\u5B57\u6570\u7EC4| array| ['Extremely bad', 'Disappointed', 'Fair', 'Satisfied', 'Surprise'] |\n| score-template| \u5206\u6570\u663E\u793A\u6A21\u677F| string|  |\n| clearable 2.2.18| \u662F\u5426\u53EF\u4EE5\u91CD\u7F6E\u503C\u4E3A 0| boolean| false |\n| id| \u539F\u751F id \u5C5E\u6027| string| \u2014 |\n| label a11y| \u548C Rate \u7684 aria-label \u5C5E\u6027\u4FDD\u6301\u4E00\u81F4| string| \u2014 |\n#### \u4E8B\u4EF6\n\n| \u4E8B\u4EF6\u540D| \u63CF\u8FF0\u8BF4\u660E| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| change| \u5206\u503C\u6539\u53D8\u65F6\u89E6\u53D1| Function |\n\n#### Exposes\n\n| \u540D\u79F0| \u63CF\u8FF0| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| setCurrentValue| \u8BBE\u7F6E\u5F53\u524D\u503C| Function |\n| resetCurrentValue| \u91CD\u7F6E\u5F53\u524D\u503C| Function |\n\n#### \u6E90\u4EE3\u7801\n\n#### \u8D21\u732E\u8005\n",
          "v-model": {
            "type": "attr",
            "values": ["number"],
            "description": "\u9009\u4E2D\u9879\u7ED1\u5B9A\u503C"
          },
          "max": {
            "type": "attr",
            "values": ["number"],
            "description": "\u6700\u5927\u5206\u503C"
          },
          "size": {
            "type": "attr",
            "values": ["large", "large", "small"],
            "description": "\u5C3A\u5BF8"
          },
          "disabled": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u4E3A\u53EA\u8BFB"
          },
          "allow-half": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u5141\u8BB8\u534A\u9009"
          },
          "low-threshold": {
            "type": "attr",
            "values": ["number"],
            "description": "\u4F4E\u5206\u548C\u4E2D\u7B49\u5206\u6570\u7684\u754C\u9650\u503C\uFF0C \u503C\u672C\u8EAB\u88AB\u5212\u5206\u5728\u4F4E\u5206\u4E2D"
          },
          "high-threshold": {
            "type": "attr",
            "values": ["number"],
            "description": "\u9AD8\u5206\u548C\u4E2D\u7B49\u5206\u6570\u7684\u754C\u9650\u503C\uFF0C \u503C\u672C\u8EAB\u88AB\u5212\u5206\u5728\u9AD8\u5206\u4E2D"
          },
          "colors": {
            "type": "attr",
            "values": ["object"],
            "description": "icon \u7684\u989C\u8272\u3002 \u82E5\u4F20\u5165\u6570\u7EC4\uFF0C\u5171\u6709 3 \u4E2A\u5143\u7D20\uFF0C\u4E3A 3 \u4E2A\u5206\u6BB5\u6240\u5BF9\u5E94\u7684\u989C\u8272\uFF1B\u82E5\u4F20\u5165\u5BF9\u8C61\uFF0C\u53EF\u81EA\u5B9A\u4E49\u5206\u6BB5\uFF0C\u952E\u540D\u4E3A\u5206\u6BB5\u7684\u754C\u9650\u503C\uFF0C\u952E\u503C\u4E3A\u5BF9\u5E94\u7684\u989C\u8272"
          },
          "void-color": {
            "type": "attr",
            "values": [],
            "description": "\u672A\u9009\u4E2D icon \u7684\u989C\u8272"
          },
          "disabled-void-color": {
            "type": "attr",
            "values": [],
            "description": "\u53EA\u8BFB\u65F6\u672A\u9009\u4E2D icon \u7684\u989C\u8272"
          },
          "icons": {
            "type": "attr",
            "values": ["object"],
            "description": "\u56FE\u6807\u7EC4\u4EF6 \u82E5\u4F20\u5165\u6570\u7EC4\uFF0C\u5219\u9700\u8981\u4F20\u5165 3 \u4E2A\u5143\u7D20\uFF0C\u5206\u522B\u4E3A 3 \u4E2A\u90E8\u5206\u6240\u5BF9\u5E94\u7684\u7C7B\u540D\uFF1B\u82E5\u4F20\u5165\u5BF9\u8C61\uFF0C\u5219\u53EF\u81EA\u5B9A\u4E49\u5206\u6BB5\uFF0C\u952E\u540D\u4E3A\u5206\u6BB5\u7684\u754C\u9650\u503C\uFF0C\u952E\u503C\u4E3A\u5BF9\u5E94\u7684\u7C7B\u540D"
          },
          "void-icon": {
            "type": "attr",
            "values": [],
            "description": "\u672A\u88AB\u9009\u4E2D\u7684\u56FE\u6807\u7EC4\u4EF6"
          },
          "disabled-void-icon": {
            "type": "attr",
            "values": [],
            "description": "\u7981\u7528\u72B6\u6001\u7684\u672A\u9009\u62E9\u56FE\u6807"
          },
          "show-text": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u663E\u793A\u8F85\u52A9\u6587\u5B57\uFF0C\u82E5\u4E3A\u771F\uFF0C\u5219\u4F1A\u4ECE texts \u6570\u7EC4\u4E2D\u9009\u53D6\u5F53\u524D\u5206\u6570\u5BF9\u5E94\u7684\u6587\u5B57\u5185\u5BB9"
          },
          "show-score": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u663E\u793A\u5F53\u524D\u5206\u6570\uFF0C show-score \u548C show-text \u4E0D\u80FD\u540C\u65F6\u4E3A\u771F"
          },
          "text-color": {
            "type": "attr",
            "values": [],
            "description": "\u8F85\u52A9\u6587\u5B57\u7684\u989C\u8272"
          },
          "texts": {
            "type": "attr",
            "values": ["array"],
            "description": "\u8F85\u52A9\u6587\u5B57\u6570\u7EC4"
          },
          "score-template": {
            "type": "attr",
            "values": [],
            "description": "\u5206\u6570\u663E\u793A\u6A21\u677F"
          },
          "clearable": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u53EF\u4EE5\u91CD\u7F6E\u503C\u4E3A 0"
          },
          "id": {
            "type": "attr",
            "values": [],
            "description": "\u539F\u751F id \u5C5E\u6027"
          },
          "labelaydeprecated": {
            "type": "attr",
            "values": [],
            "description": "\u548C Rate \u7684 aria-label \u5C5E\u6027\u4FDD\u6301\u4E00\u81F4"
          },
          "aria-labelay": {
            "type": "attr",
            "values": [],
            "description": "\u548C Rate \u7684 aria-label \u5C5E\u6027\u4FDD\u6301\u4E00\u81F4"
          },
          "change": {
            "type": "event",
            "values": [],
            "description": "\u5206\u503C\u6539\u53D8\u65F6\u89E6\u53D1"
          }
        },
        "el-select": {
          "_html": {
            "": '<el-select v-model="${1:value}" placeholder="Please select" filterable clearable>\n<el-option label="$2" value="$3" />$4\n</el-select>',
            ":for": '<el-select v-model="${1:value}" placeholder="Please select" filterable clearable>\n<el-option v-for="item in ${2:options}" :key="item.value" :label="item.label" :value="item.value" />\n</el-select>',
            ":header[slot]": "<template #header>\n$1\n</template>",
            ":footer[slot]": "<template #footer>\n$1\n</template>"
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/select.html)\n\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| Default |\n| :--- | :--- | :--- | :--- |\n| model-value / v-model| \u9009\u4E2D\u9879\u7ED1\u5B9A\u503C| string / number / boolean / object / array| \u2014 |\n| multiple| \u662F\u5426\u591A\u9009| boolean| false |\n| disabled| \u662F\u5426\u7981\u7528| boolean| false |\n| value-key| \u4F5C\u4E3A value \u552F\u4E00\u6807\u8BC6\u7684\u952E\u540D\uFF0C\u7ED1\u5B9A\u503C\u4E3A\u5BF9\u8C61\u7C7B\u578B\u65F6\u5FC5\u586B| string| value |\n| size| \u8F93\u5165\u6846\u5C3A\u5BF8| enum| \u2014 |\n| clearable| \u662F\u5426\u53EF\u4EE5\u6E05\u7A7A\u9009\u9879| boolean| false |\n| collapse-tags| \u591A\u9009\u65F6\u662F\u5426\u5C06\u9009\u4E2D\u503C\u6309\u6587\u5B57\u7684\u5F62\u5F0F\u5C55\u793A| boolean| false |\n| collapse-tags-tooltip 2.3.0| \u5F53\u9F20\u6807\u60AC\u505C\u4E8E\u6298\u53E0\u6807\u7B7E\u7684\u6587\u672C\u65F6\uFF0C\u662F\u5426\u663E\u793A\u6240\u6709\u9009\u4E2D\u7684\u6807\u7B7E\u3002 \u8981\u4F7F\u7528\u6B64\u5C5E\u6027\uFF0Ccollapse-tags\u5C5E\u6027\u5FC5\u987B\u8BBE\u5B9A\u4E3A true| boolean| false |\n| multiple-limit| multiple \u5C5E\u6027\u8BBE\u7F6E\u4E3A true \u65F6\uFF0C\u4EE3\u8868\u591A\u9009\u573A\u666F\u4E0B\u7528\u6237\u6700\u591A\u53EF\u4EE5\u9009\u62E9\u7684\u9879\u76EE\u6570\uFF0C \u4E3A 0 \u5219\u4E0D\u9650\u5236| number| 0 |\n| name| Select \u8F93\u5165\u6846\u7684\u539F\u751F name \u5C5E\u6027| string| \u2014 |\n| effect| tooltip \u4E3B\u9898\uFF0C\u5185\u7F6E\u4E86 dark / light \u4E24\u79CD| enum / string| light |\n| autocomplete| Select \u8F93\u5165\u6846\u7684\u539F\u751F autocomplete \u5C5E\u6027| string| off |\n| placeholder| \u5360\u4F4D\u7B26\uFF0C\u9ED8\u8BA4\u4E3A\u201CSelect\u201D| string| \u2014 |\n| filterable| Select \u7EC4\u4EF6\u662F\u5426\u53EF\u7B5B\u9009| boolean| false |\n| allow-create| \u662F\u5426\u5141\u8BB8\u7528\u6237\u521B\u5EFA\u65B0\u6761\u76EE\uFF0C \u53EA\u6709\u5F53 filterable \u8BBE\u7F6E\u4E3A true \u65F6\u624D\u4F1A\u751F\u6548\u3002| boolean| false |\n| filter-method| \u81EA\u5B9A\u4E49\u7B5B\u9009\u65B9\u6CD5| Function| \u2014 |\n| remote| \u5176\u4E2D\u7684\u9009\u9879\u662F\u5426\u4ECE\u670D\u52A1\u5668\u8FDC\u7A0B\u52A0\u8F7D| boolean| false |\n| remote-method| \u81EA\u5B9A\u4E49\u8FDC\u7A0B\u641C\u7D22\u65B9\u6CD5| Function| \u2014 |\n| remote-show-suffix| \u8FDC\u7A0B\u641C\u7D22\u65B9\u6CD5\u663E\u793A\u540E\u7F00\u56FE\u6807| boolean| false |\n| loading| \u662F\u5426\u6B63\u5728\u4ECE\u8FDC\u7A0B\u83B7\u53D6\u6570\u636E| boolean| false |\n| loading-text| \u4ECE\u670D\u52A1\u5668\u52A0\u8F7D\u6570\u636E\u65F6\u663E\u793A\u7684\u6587\u672C\uFF0C\u9ED8\u8BA4\u4E3A\u201CLoading\u201D| string| \u2014 |\n| no-match-text| \u641C\u7D22\u6761\u4EF6\u65E0\u5339\u914D\u65F6\u663E\u793A\u7684\u6587\u5B57\uFF0C\u4E5F\u53EF\u4EE5\u4F7F\u7528 empty \u63D2\u69FD\u8BBE\u7F6E\uFF0C\u9ED8\u8BA4\u662F \u201CNo matching data'\u201D| string| \u2014 |\n| no-data-text| \u65E0\u9009\u9879\u65F6\u663E\u793A\u7684\u6587\u5B57\uFF0C\u4E5F\u53EF\u4EE5\u4F7F\u7528 empty \u63D2\u69FD\u8BBE\u7F6E\u81EA\u5B9A\u4E49\u5185\u5BB9\uFF0C\u9ED8\u8BA4\u662F \u201CNo data\u201D| string| \u2014 |\n| popper-class| \u9009\u62E9\u5668\u4E0B\u62C9\u83DC\u5355\u7684\u81EA\u5B9A\u4E49\u7C7B\u540D| string| '' |\n| reserve-keyword| \u5F53 multiple \u548C filterable\u88AB\u8BBE\u7F6E\u4E3A true \u65F6\uFF0C\u662F\u5426\u5728\u9009\u4E2D\u4E00\u4E2A\u9009\u9879\u540E\u4FDD\u7559\u5F53\u524D\u7684\u641C\u7D22\u5173\u952E\u8BCD| boolean| true |\n| default-first-option| \u662F\u5426\u5728\u8F93\u5165\u6846\u6309\u4E0B\u56DE\u8F66\u65F6\uFF0C\u9009\u62E9\u7B2C\u4E00\u4E2A\u5339\u914D\u9879\u3002 \u9700\u914D\u5408 filterable \u6216 remote \u4F7F\u7528| boolean| false |\n| teleported| \u662F\u5426\u5C06\u4E0B\u62C9\u5217\u8868\u63D2\u5165\u81F3 body \u5143\u7D20| boolean| true |\n| persistent| \u5F53\u4E0B\u62C9\u9009\u62E9\u5668\u672A\u88AB\u6FC0\u6D3B\u5E76\u4E14persistent\u8BBE\u7F6E\u4E3Afalse\uFF0C\u9009\u62E9\u5668\u4F1A\u88AB\u5220\u9664\u3002| boolean| true |\n| automatic-dropdown| \u5BF9\u4E8E\u4E0D\u53EF\u641C\u7D22\u7684 Select\uFF0C\u662F\u5426\u5728\u8F93\u5165\u6846\u83B7\u5F97\u7126\u70B9\u540E\u81EA\u52A8\u5F39\u51FA\u9009\u9879\u83DC\u5355| boolean| false |\n| clear-icon| \u81EA\u5B9A\u4E49\u6E05\u9664\u56FE\u6807| string / object| CircleClose |\n| fit-input-width| \u4E0B\u62C9\u6846\u7684\u5BBD\u5EA6\u662F\u5426\u4E0E\u8F93\u5165\u6846\u76F8\u540C| boolean| false |\n| suffix-icon| \u81EA\u5B9A\u4E49\u540E\u7F00\u56FE\u6807\u7EC4\u4EF6| string / object| ArrowDown |\n| suffix-transition deprecated| \u4E0B\u62C9\u83DC\u5355\u663E\u793A/\u6D88\u5931\u65F6\u540E\u7F00\u56FE\u6807\u7684\u52A8\u753B| boolean| true |\n| tag-type| \u6807\u7B7E\u7C7B\u578B| enum| info |\n| validate-event| \u662F\u5426\u89E6\u53D1\u8868\u5355\u9A8C\u8BC1| boolean| true |\n| placement 2.2.17| \u4E0B\u62C9\u6846\u51FA\u73B0\u7684\u4F4D\u7F6E| enum| bottom-start |\n| fallback-placements 2.5.6| dropdown \u53EF\u7528\u7684 positions \u8BF7\u67E5\u770Bpopper.js \u6587\u6863| arrary| ['bottom-start', 'top-start', 'right', 'left'] |\n| max-collapse-tags 2.3.0| \u9700\u8981\u663E\u793A\u7684 Tag \u7684\u6700\u5927\u6570\u91CF \u53EA\u6709\u5F53 collapse-tags \u8BBE\u7F6E\u4E3A true \u65F6\u624D\u4F1A\u751F\u6548\u3002| number| 1 |\n| popper-options| popper.js \u53C2\u6570| objectrefer to popper.js doc| {} |\n| aria-label a11y| \u7B49\u4EF7\u4E8E\u539F\u751F input aria-label \u5C5E\u6027| string| \u2014 |\n#### \u4E8B\u4EF6\n\n| \u4E8B\u4EF6\u540D| \u8BF4\u660E| Type |\n| :--- | :--- | :--- |\n| change| \u9009\u4E2D\u503C\u53D1\u751F\u53D8\u5316\u65F6\u89E6\u53D1| Function |\n| visible-change| \u4E0B\u62C9\u6846\u51FA\u73B0/\u9690\u85CF\u65F6\u89E6\u53D1| Function |\n| remove-tag| \u591A\u9009\u6A21\u5F0F\u4E0B\u79FB\u9664tag\u65F6\u89E6\u53D1| Function |\n| clear| \u53EF\u6E05\u7A7A\u7684\u5355\u9009\u6A21\u5F0F\u4E0B\u7528\u6237\u70B9\u51FB\u6E05\u7A7A\u6309\u94AE\u65F6\u89E6\u53D1| Function |\n| blur| \u5F53 input \u5931\u53BB\u7126\u70B9\u65F6\u89E6\u53D1| Function |\n| focus| \u5F53 input \u83B7\u5F97\u7126\u70B9\u65F6\u89E6\u53D1| Function |\n\n#### Select Slots\n\n| \u63D2\u69FD\u540D| \u8BF4\u660E| \u5B50\u6807\u7B7E |\n| :--- | :--- | :--- |\n| default| option \u7EC4\u4EF6\u5217\u8868| Option Group / Option |\n| header 2.4.3| \u4E0B\u62C9\u5217\u8868\u9876\u90E8\u7684\u5185\u5BB9| \u2014 |\n| footer 2.4.3| \u4E0B\u62C9\u5217\u8868\u5E95\u90E8\u7684\u5185\u5BB9| \u2014 |\n| prefix| Select \u7EC4\u4EF6\u5934\u90E8\u5185\u5BB9| \u2014 |\n| empty| \u65E0\u9009\u9879\u65F6\u7684\u5217\u8868| \u2014 |\n| tag 2.5.0| select \u7EC4\u4EF6\u81EA\u5B9A\u4E49\u6807\u7B7E\u5185\u5BB9| \u2014 |\n| loading 2.5.2| select \u7EC4\u4EF6\u81EA\u5B9A\u4E49 loading\u5185\u5BB9| \u2014 |\n\n#### Select Exposes\n\n| Method| \u8BF4\u660E| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| focus| \u4F7F\u9009\u62E9\u5668\u7684\u8F93\u5165\u6846\u83B7\u53D6\u7126\u70B9| Function |\n| blur| \u4F7F\u9009\u62E9\u5668\u7684\u8F93\u5165\u6846\u5931\u53BB\u7126\u70B9\uFF0C\u5E76\u9690\u85CF\u4E0B\u62C9\u6846| Function |\n",
          "v-model": {
            "type": "attr",
            "values": [],
            "description": "\u9009\u4E2D\u9879\u7ED1\u5B9A\u503C"
          },
          "multiple": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u591A\u9009"
          },
          "disabled": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u7981\u7528"
          },
          "value-key": {
            "type": "attr",
            "values": [],
            "description": "\u4F5C\u4E3A value \u552F\u4E00\u6807\u8BC6\u7684\u952E\u540D\uFF0C\u7ED1\u5B9A\u503C\u4E3A\u5BF9\u8C61\u7C7B\u578B\u65F6\u5FC5\u586B"
          },
          "size": {
            "type": "attr",
            "values": ["large", "large", "small"],
            "description": "\u8F93\u5165\u6846\u5C3A\u5BF8"
          },
          "clearable": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u53EF\u4EE5\u6E05\u7A7A\u9009\u9879"
          },
          "collapse-tags": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u591A\u9009\u65F6\u662F\u5426\u5C06\u9009\u4E2D\u503C\u6309\u6587\u5B57\u7684\u5F62\u5F0F\u5C55\u793A"
          },
          "collapse-tags-tooltip": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u5F53\u9F20\u6807\u60AC\u505C\u4E8E\u6298\u53E0\u6807\u7B7E\u7684\u6587\u672C\u65F6\uFF0C\u662F\u5426\u663E\u793A\u6240\u6709\u9009\u4E2D\u7684\u6807\u7B7E\u3002 \u8981\u4F7F\u7528\u6B64\u5C5E\u6027\uFF0Ccollapse-tags\u5C5E\u6027\u5FC5\u987B\u8BBE\u5B9A\u4E3A true"
          },
          "multiple-limit": {
            "type": "attr",
            "values": ["number"],
            "description": "multiple \u5C5E\u6027\u8BBE\u7F6E\u4E3A true \u65F6\uFF0C\u4EE3\u8868\u591A\u9009\u573A\u666F\u4E0B\u7528\u6237\u6700\u591A\u53EF\u4EE5\u9009\u62E9\u7684\u9879\u76EE\u6570\uFF0C \u4E3A 0 \u5219\u4E0D\u9650\u5236"
          },
          "name": {
            "type": "attr",
            "values": [],
            "description": "Select \u8F93\u5165\u6846\u7684\u539F\u751F name \u5C5E\u6027"
          },
          "effect": {
            "type": "attr",
            "values": ["dark", "light"],
            "description": "tooltip \u4E3B\u9898\uFF0C\u5185\u7F6E\u4E86 dark / light \u4E24\u79CD"
          },
          "autocomplete": {
            "type": "attr",
            "values": [],
            "description": "Select \u8F93\u5165\u6846\u7684\u539F\u751F autocomplete \u5C5E\u6027"
          },
          "placeholder": {
            "type": "attr",
            "values": [],
            "description": "\u5360\u4F4D\u7B26\uFF0C\u9ED8\u8BA4\u4E3A\u201CSelect\u201D"
          },
          "filterable": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "Select \u7EC4\u4EF6\u662F\u5426\u53EF\u7B5B\u9009"
          },
          "allow-create": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u5141\u8BB8\u7528\u6237\u521B\u5EFA\u65B0\u6761\u76EE\uFF0C \u53EA\u6709\u5F53 filterable \u8BBE\u7F6E\u4E3A true \u65F6\u624D\u4F1A\u751F\u6548\u3002"
          },
          "filter-method": {
            "type": "attr",
            "values": ["Function"],
            "description": "\u81EA\u5B9A\u4E49\u7B5B\u9009\u65B9\u6CD5"
          },
          "remote": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u5176\u4E2D\u7684\u9009\u9879\u662F\u5426\u4ECE\u670D\u52A1\u5668\u8FDC\u7A0B\u52A0\u8F7D"
          },
          "remote-method": {
            "type": "attr",
            "values": ["Function"],
            "description": "\u81EA\u5B9A\u4E49\u8FDC\u7A0B\u641C\u7D22\u65B9\u6CD5"
          },
          "remote-show-suffix": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u8FDC\u7A0B\u641C\u7D22\u65B9\u6CD5\u663E\u793A\u540E\u7F00\u56FE\u6807"
          },
          "loading": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u6B63\u5728\u4ECE\u8FDC\u7A0B\u83B7\u53D6\u6570\u636E"
          },
          "loading-text": {
            "type": "attr",
            "values": [],
            "description": "\u4ECE\u670D\u52A1\u5668\u52A0\u8F7D\u6570\u636E\u65F6\u663E\u793A\u7684\u6587\u672C\uFF0C\u9ED8\u8BA4\u4E3A\u201CLoading\u201D"
          },
          "no-match-text": {
            "type": "attr",
            "values": [],
            "description": "\u641C\u7D22\u6761\u4EF6\u65E0\u5339\u914D\u65F6\u663E\u793A\u7684\u6587\u5B57\uFF0C\u4E5F\u53EF\u4EE5\u4F7F\u7528 empty \u63D2\u69FD\u8BBE\u7F6E\uFF0C\u9ED8\u8BA4\u662F \u201CNo matching data'\u201D"
          },
          "no-data-text": {
            "type": "attr",
            "values": [],
            "description": "\u65E0\u9009\u9879\u65F6\u663E\u793A\u7684\u6587\u5B57\uFF0C\u4E5F\u53EF\u4EE5\u4F7F\u7528 empty \u63D2\u69FD\u8BBE\u7F6E\u81EA\u5B9A\u4E49\u5185\u5BB9\uFF0C\u9ED8\u8BA4\u662F \u201CNo data\u201D"
          },
          "popper-class": {
            "type": "attr",
            "values": [],
            "description": "\u9009\u62E9\u5668\u4E0B\u62C9\u83DC\u5355\u7684\u81EA\u5B9A\u4E49\u7C7B\u540D"
          },
          "reserve-keyword": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u5F53 multiple \u548C filterable\u88AB\u8BBE\u7F6E\u4E3A true \u65F6\uFF0C\u662F\u5426\u5728\u9009\u4E2D\u4E00\u4E2A\u9009\u9879\u540E\u4FDD\u7559\u5F53\u524D\u7684\u641C\u7D22\u5173\u952E\u8BCD"
          },
          "default-first-option": {
            "type": "attr",
            "values": ["false"],
            "description": "\u662F\u5426\u5728\u8F93\u5165\u6846\u6309\u4E0B\u56DE\u8F66\u65F6\uFF0C\u9009\u62E9\u7B2C\u4E00\u4E2A\u5339\u914D\u9879\u3002 \u9700\u914D\u5408 filterable \u6216 remote \u4F7F\u7528"
          },
          "teleported": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u5C06\u4E0B\u62C9\u5217\u8868\u63D2\u5165\u81F3 body \u5143\u7D20"
          },
          "persistent": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u5F53\u4E0B\u62C9\u9009\u62E9\u5668\u672A\u88AB\u6FC0\u6D3B\u5E76\u4E14persistent\u8BBE\u7F6E\u4E3Afalse\uFF0C\u9009\u62E9\u5668\u4F1A\u88AB\u5220\u9664\u3002"
          },
          "automatic-dropdown": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u5BF9\u4E8E\u4E0D\u53EF\u641C\u7D22\u7684 Select\uFF0C\u662F\u5426\u5728\u8F93\u5165\u6846\u83B7\u5F97\u7126\u70B9\u540E\u81EA\u52A8\u5F39\u51FA\u9009\u9879\u83DC\u5355"
          },
          "clear-icon": {
            "type": "attr",
            "values": [],
            "description": "\u81EA\u5B9A\u4E49\u6E05\u9664\u56FE\u6807"
          },
          "fit-input-width": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u4E0B\u62C9\u6846\u7684\u5BBD\u5EA6\u662F\u5426\u4E0E\u8F93\u5165\u6846\u76F8\u540C"
          },
          "suffix-icon": {
            "type": "attr",
            "values": [],
            "description": "\u81EA\u5B9A\u4E49\u540E\u7F00\u56FE\u6807\u7EC4\u4EF6"
          },
          "suffix-transitiondeprecated": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u4E0B\u62C9\u83DC\u5355\u663E\u793A/\u6D88\u5931\u65F6\u540E\u7F00\u56FE\u6807\u7684\u52A8\u753B"
          },
          "tag-type": {
            "type": "attr",
            "values": ["success", "info", "warning", "danger"],
            "description": "\u6807\u7B7E\u7C7B\u578B"
          },
          "validate-event": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u89E6\u53D1\u8868\u5355\u9A8C\u8BC1"
          },
          "placement": {
            "type": "attr",
            "values": ["top", "top-start", "top-end", "bottom", "bottom-start", "bottom-end", "left", "left-start", "left-end", "right", "right-start", "right-end"],
            "description": "\u4E0B\u62C9\u6846\u51FA\u73B0\u7684\u4F4D\u7F6E"
          },
          "fallback-placements": {
            "type": "attr",
            "values": ["array"],
            "description": "dropdown \u53EF\u7528\u7684 positions \u8BF7\u67E5\u770Bpopper.js \u6587\u6863"
          },
          "max-collapse-tags": {
            "type": "attr",
            "values": ["number"],
            "description": "\u9700\u8981\u663E\u793A\u7684 Tag \u7684\u6700\u5927\u6570\u91CF \u53EA\u6709\u5F53 collapse-tags \u8BBE\u7F6E\u4E3A true \u65F6\u624D\u4F1A\u751F\u6548\u3002"
          },
          "popper-options": {
            "type": "attr",
            "values": ["objectrefer"],
            "description": "popper.js \u53C2\u6570"
          },
          "aria-labelay": {
            "type": "attr",
            "values": [],
            "description": "\u7B49\u4EF7\u4E8E\u539F\u751F input aria-label \u5C5E\u6027"
          },
          "empty-values": {
            "type": "attr",
            "values": ["array"],
            "description": "\u7EC4\u4EF6\u7684\u7A7A\u503C\u914D\u7F6E \u53C2\u8003config-provider"
          },
          "value-on-clear": {
            "type": "attr",
            "values": [],
            "description": "\u6E05\u7A7A\u9009\u9879\u7684\u503C \u53C2\u8003 config-provider"
          },
          "change": {
            "type": "event",
            "values": [],
            "description": "\u9009\u4E2D\u503C\u53D1\u751F\u53D8\u5316\u65F6\u89E6\u53D1"
          },
          "visible-change": {
            "type": "event",
            "values": [],
            "description": "\u4E0B\u62C9\u6846\u51FA\u73B0/\u9690\u85CF\u65F6\u89E6\u53D1"
          },
          "remove-tag": {
            "type": "event",
            "values": [],
            "description": "\u591A\u9009\u6A21\u5F0F\u4E0B\u79FB\u9664tag\u65F6\u89E6\u53D1"
          },
          "clear": {
            "type": "event",
            "values": [],
            "description": "\u53EF\u6E05\u7A7A\u7684\u5355\u9009\u6A21\u5F0F\u4E0B\u7528\u6237\u70B9\u51FB\u6E05\u7A7A\u6309\u94AE\u65F6\u89E6\u53D1"
          },
          "blur": {
            "type": "event",
            "values": [],
            "description": "\u5F53 input \u5931\u53BB\u7126\u70B9\u65F6\u89E6\u53D1"
          },
          "focus": {
            "type": "event",
            "values": [],
            "description": "\u5F53 input \u83B7\u5F97\u7126\u70B9\u65F6\u89E6\u53D1"
          }
        },
        "el-option": {
          "_html": {
            "": '<el-option label="$1" value="$2" />'
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/select.html)\n#### \u5C5E\u6027\n\n| \u63D2\u69FD\u540D| \u8BF4\u660E| Type| Default |\n| :--- | :--- | :--- | :--- |\n| label| \u5206\u7EC4\u7684\u540D\u79F0| string| \u2014 |\n| disabled| \u662F\u5426\u5C06\u8BE5\u5206\u7EC4\u4E0B\u6240\u6709\u9009\u9879\u7F6E\u4E3A\u7981\u7528| boolean| false |\n\n#### Option Group Slots\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| Subtags |\n| :--- | :--- | :--- |\n| default| \u81EA\u5B9A\u4E49\u9ED8\u8BA4\u5185\u5BB9| Option |\n\n#### \u5C5E\u6027\n\n| \u540D\u79F0| \u8BE6\u60C5| Type| Default |\n| :--- | :--- | :--- | :--- |\n| value| \u9009\u9879\u7684\u503C| string / number / boolean / object| \u2014 |\n| label| \u9009\u9879\u7684\u6807\u7B7E\uFF0C\u82E5\u4E0D\u8BBE\u7F6E\u5219\u9ED8\u8BA4\u4E0Evalue\u76F8\u540C| string / number| \u2014 |\n| disabled| \u662F\u5426\u7981\u7528\u8BE5\u9009\u9879| boolean| false |\n\n#### Option Slots\n\n| Name| \u8BF4\u660E |\n| :--- | :--- |\n| default| \u9ED8\u8BA4\u63D2\u69FD\u5185\u5BB9 |\n\n#### \u6E90\u4EE3\u7801\n\n#### \u8D21\u732E\u8005\n",
          "value": {
            "type": "attr",
            "values": [],
            "description": "\u9009\u9879\u7684\u503C"
          },
          "label": {
            "type": "attr",
            "values": [],
            "description": "\u9009\u9879\u7684\u6807\u7B7E\uFF0C\u82E5\u4E0D\u8BBE\u7F6E\u5219\u9ED8\u8BA4\u4E0Evalue\u76F8\u540C"
          },
          "disabled": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u7981\u7528\u8BE5\u9009\u9879"
          }
        },
        "el-option-group": {
          "_html": {
            "": '<el-option-group v-for="group in ${1:options}" :key="group.label" :label="group.label">\n<el-option v-for="item in group.options" :key="item.value" :label="item.label" :value="item.value" />\n</el-option-group>'
          }
        },
        "el-select-v2": {
          "_html": {
            "": '<el-select-v2 v-model="${1:value}" :options="${2:options}" placeholder="Please select" filterable clearable >$3</el-select-v2>',
            ":multiple": '<el-select-v2 v-model="${1:value}" :options="${2:options}" placeholder="Please select" filterable clearable multiple >$3</el-select-v2>',
            ":header[slot]": "<template #header>\n$1\n</template>",
            ":footer[slot]": "<template #footer>\n$1\n</template>"
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/select-v2.html)\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u8BF4\u660E| \u7C7B\u578B| \u9ED8\u8BA4\u503C |\n| :--- | :--- | :--- | :--- |\n| model-value / v-model| \u9009\u4E2D\u9879\u7ED1\u5B9A\u503C| string / number / boolean / object / array| \u2014 |\n| options| \u9009\u9879\u7684\u6570\u636E\u6E90\uFF0C value \u7684 key \u548C label \u53EF\u4EE5\u901A\u8FC7 props\u81EA\u5B9A\u4E49.| array| \u2014 |\n| props 2.4.2| \u914D\u7F6E\u9009\u9879\uFF0C\u5177\u4F53\u770B\u4E0B\u8868| object| \u2014 |\n| multiple| \u662F\u5426\u591A\u9009| boolean| false |\n| disabled| \u662F\u5426\u7981\u7528| boolean| false |\n| value-key| \u4F5C\u4E3A value \u552F\u4E00\u6807\u8BC6\u7684\u952E\u540D\uFF0C\u7ED1\u5B9A\u503C\u4E3A\u5BF9\u8C61\u7C7B\u578B\u65F6\u5FC5\u586B| string| value |\n| size| \u7EC4\u4EF6\u5927\u5C0F| enum| '' |\n| clearable| \u662F\u5426\u53EF\u4EE5\u6E05\u7A7A\u9009\u9879| boolean| false |\n| clear-icon| \u81EA\u5B9A\u4E49\u6E05\u9664\u56FE\u6807| string / object| CircleClose |\n| collapse-tags| \u591A\u9009\u65F6\u662F\u5426\u5C06\u9009\u4E2D\u503C\u6309\u6587\u5B57\u7684\u5F62\u5F0F\u5C55\u793A| boolean| false |\n| multiple-limit| \u591A\u9009\u65F6\u53EF\u88AB\u9009\u62E9\u7684\u6700\u5927\u6570\u76EE\u3002 \u5F53\u88AB\u8BBE\u7F6E\u4E3A0\u65F6\uFF0C\u53EF\u88AB\u9009\u62E9\u7684\u6570\u76EE\u4E0D\u8BBE\u9650\u3002| number| 0 |\n| name| \u9009\u62E9\u5668\u7684\u539F\u751Fname\u5C5E\u6027| string| \u2014 |\n| effect| tooltip \u4E3B\u9898\uFF0C\u5185\u7F6E\u4E86 dark / light \u4E24\u79CD| enum / string| light |\n| autocomplete| \u81EA\u52A8\u5B8C\u6210\u9009\u62E9\u8F93\u5165| string| off |\n| placeholder| \u5360\u4F4D\u6587\u5B57| string| Please select |\n| filterable| \u662F\u5426\u53EF\u7B5B\u9009| boolean| false |\n| allow-create| \u662F\u5426\u5141\u8BB8\u521B\u5EFA\u65B0\u6761\u76EE\uFF0C \u5F53\u4F7F\u7528\u8BE5\u5C5E\u6027\u65F6\uFF0Cfilterable\u5FC5\u987B\u8BBE\u7F6E\u4E3Atrue| boolean| false |\n| filter-method| \u81EA\u5B9A\u4E49\u7B5B\u9009\u65B9\u6CD5| Function| \u2014 |\n| loading| \u662F\u5426\u4ECE\u8FDC\u7A0B\u52A0\u8F7D\u6570\u636E| boolean| false |\n| loading-text| \u4ECE\u670D\u52A1\u5668\u52A0\u8F7D\u6570\u636E\u65F6\u663E\u793A\u7684\u6587\u672C\uFF0C\u9ED8\u8BA4\u4E3A\u201CLoading\u201D| string| \u2014 |\n| reserve-keyword| \u7B5B\u9009\u65F6\uFF0C\u662F\u5426\u5728\u9009\u62E9\u9009\u9879\u540E\u4FDD\u7559\u5173\u952E\u5B57| boolean| true |\n| no-match-text| \u641C\u7D22\u6761\u4EF6\u65E0\u5339\u914D\u65F6\u663E\u793A\u7684\u6587\u5B57\uFF0C\u4E5F\u53EF\u4EE5\u4F7F\u7528 empty \u63D2\u69FD\u8BBE\u7F6E\uFF0C\u9ED8\u8BA4\u662F \u201CNo matching data'\u201D| string| \u2014 |\n| no-data-text| \u5F53\u5728\u6CA1\u6709\u6570\u636E\u65F6\u663E\u793A\u7684\u6587\u5B57\uFF0C\u4F60\u540C\u65F6\u53EF\u4EE5\u4F7F\u7528empty\u63D2\u69FD\u8FDB\u884C\u8BBE\u7F6E\u3002| string| No Data |\n| popper-class| \u9009\u62E9\u5668\u4E0B\u62C9\u83DC\u5355\u7684\u81EA\u5B9A\u4E49\u7C7B\u540D| string| '' |\n| popper-append-to-body deprecated| \u662F\u5426\u5C06\u5F39\u51FA\u6846\u63D2\u5165\u81F3 body \u5143\u7D20 \u5F53\u5F39\u51FA\u6846\u7684\u4F4D\u7F6E\u51FA\u73B0\u95EE\u9898\u65F6\uFF0C\u4F60\u53EF\u4EE5\u5C1D\u8BD5\u5C06\u8BE5\u5C5E\u6027\u8BBE\u7F6E\u4E3Afalse\u3002| boolean| false |\n| teleported| \u662F\u5426\u5C06\u4E0B\u62C9\u5217\u8868\u5143\u7D20\u63D2\u5165 append-to \u6307\u5411\u7684\u5143\u7D20\u4E0B| boolean| true |\n| persistent| \u5F53\u4E0B\u62C9\u9009\u62E9\u5668\u672A\u88AB\u6FC0\u6D3B\u5E76\u4E14persistent\u8BBE\u7F6E\u4E3Afalse\uFF0C\u9009\u62E9\u5668\u4F1A\u88AB\u5220\u9664\u3002| boolean| true |\n| popper-options| popper.js parameters| objectrefer to popper.js doc| {} |\n| automatic-dropdown| \u5BF9\u4E8E\u4E0D\u53EF\u641C\u7D22\u7684 Select\uFF0C\u662F\u5426\u5728\u8F93\u5165\u6846\u83B7\u5F97\u7126\u70B9\u540E\u81EA\u52A8\u5F39\u51FA\u9009\u9879\u83DC\u5355| boolean| false |\n| height| \u4E0B\u62C9\u83DC\u5355\u7684\u9AD8\u5EA6\uFF0C\u6BCF\u4E00\u4E2A\u9009\u9879\u4E3A34px| number| 274 |\n| item-height| \u4E0B\u62C9\u9879\u7684\u9AD8\u5EA6| number| 34 |\n| scrollbar-always-on| \u662F\u5426\u603B\u662F\u5C55\u793A\u6EDA\u52A8\u6761| boolean| false |\n| remote| \u662F\u5426\u4ECE\u670D\u52A1\u5668\u83B7\u53D6\u6570\u636E| boolean| false |\n| remote-method| \u5F53\u8F93\u5165\u503C\u53D1\u751F\u53D8\u5316\u65F6\u89E6\u53D1\u7684\u51FD\u6570\u3002 \u5B83\u7684\u53C2\u6570\u5C31\u662F\u5F53\u524D\u7684\u8F93\u5165\u503C\u3002 \u5F53filterable\u8BBE\u7F6E\u4E3A true \u65F6\u624D\u4F1A\u751F\u6548| Function| \u2014 |\n| validate-event| \u662F\u5426\u89E6\u53D1\u8868\u5355\u9A8C\u8BC1| boolean| true |\n| placement| \u4E0B\u62C9\u6846\u51FA\u73B0\u7684\u4F4D\u7F6E| enum| bottom-start |\n| fallback-placements 2.5.6| dropdown \u53EF\u7528\u7684 positions \u8BF7\u67E5\u770Bpopper.js \u6587\u6863| arrary| ['bottom-start', 'top-start', 'right', 'left'] |\n| collapse-tags-tooltip 2.3.0| \u5F53\u9F20\u6807\u60AC\u505C\u4E8E\u6298\u53E0\u6807\u7B7E\u7684\u6587\u672C\u65F6\uFF0C\u662F\u5426\u663E\u793A\u6240\u6709\u9009\u4E2D\u7684\u6807\u7B7E\u3002 \u53EA\u6709\u5F53 collapse-tags \u8BBE\u7F6E\u4E3A true \u65F6\u624D\u4F1A\u751F\u6548\u3002| boolean| false |\n| max-collapse-tags 2.3.0| \u9700\u8981\u663E\u793A\u7684 Tag \u7684\u6700\u5927\u6570\u91CF \u53EA\u6709\u5F53 collapse-tags \u8BBE\u7F6E\u4E3A true \u65F6\u624D\u4F1A\u751F\u6548\u3002| number| 1 |\n| tag-type 2.5.0| \u6807\u7B7E\u7C7B\u578B| enum| info |\n| aria-label a11y 2.5.0| \u7B49\u4EF7\u4E8E\u539F\u751F input aria-label \u5C5E\u6027| string| \u2014 |\n\n#### props\n\n| Attribute| \u8BF4\u660E| Type| Default |\n| :--- | :--- | :--- | :--- |\n| value| \u6307\u5B9A\u9009\u9879\u7684\u503C\u4E3A\u9009\u9879\u5BF9\u8C61\u7684\u67D0\u4E2A\u5C5E\u6027\u503C| string| value |\n| label| \u6307\u5B9A\u8282\u70B9\u6807\u7B7E\u4E3A\u8282\u70B9\u5BF9\u8C61\u7684\u67D0\u4E2A\u5C5E\u6027\u503C| string| label |\n| options| \u6307\u5B9A\u9009\u9879\u7684\u5B50\u9009\u9879\u4E3A\u9009\u9879\u5BF9\u8C61\u7684\u67D0\u4E2A\u5C5E\u6027\u503C| string| options |\n| disabled| \u6307\u5B9A\u9009\u9879\u7684\u7981\u7528\u4E3A\u9009\u9879\u5BF9\u8C61\u7684\u67D0\u4E2A\u5C5E\u6027\u503C| string| disabled |\n#### \u4E8B\u4EF6\n\n| \u63D2\u69FD\u540D| \u8BF4\u660E| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| change| \u5F53\u6240\u9009\u503C\u66F4\u6539\u65F6\u89E6\u53D1\uFF0C\u53C2\u6570\u662F\u5F53\u524D\u9009\u4E2D\u7684\u503C| Function |\n| visible-change| \u5F53\u4E0B\u62C9\u83DC\u5355\u51FA\u73B0/\u6D88\u5931\u65F6\u89E6\u53D1\u5668, \u5F53\u5B83\u51FA\u73B0\u65F6, \u53C2\u6570\u5C06\u662F\u771F\u7684, \u5426\u5219\u5C06\u662F\u5047\u7684| Function |\n| remove-tag| \u5F53\u4E00\u4E2A\u6807\u7B7E\u5728\u591A\u4E2A\u6A21\u5F0F\u4E0B\u88AB\u79FB\u9664\u65F6\u89E6\u53D1\uFF0C\u53C2\u6570\u5C06\u88AB\u79FB\u9664\u6807\u7B7E\u503C| Function |\n| clear| \u53EF\u6E05\u7A7A\u7684\u5355\u9009\u6A21\u5F0F\u4E0B\u7528\u6237\u70B9\u51FB\u6E05\u7A7A\u6309\u94AE\u65F6\u89E6\u53D1| Function |\n| blur| \u5F53\u9009\u62E9\u5668\u7684\u8F93\u5165\u6846\u5931\u53BB\u7126\u70B9\u65F6\u89E6\u53D1| Function |\n| focus| \u5F53\u9009\u62E9\u5668\u7684\u8F93\u5165\u6846\u83B7\u5F97\u7126\u70B9\u65F6\u89E6\u53D1| Function |\n\n#### Slots\n\n| \u540D\u79F0| \u8BE6\u60C5 |\n| :--- | :--- |\n| default| \u81EA\u5B9A\u4E49 Option \u6A21\u677F |\n| header 2.5.2| \u4E0B\u62C9\u5217\u8868\u9876\u90E8\u7684\u5185\u5BB9 |\n| footer 2.5.2| \u4E0B\u62C9\u5217\u8868\u5E95\u90E8\u7684\u5185\u5BB9 |\n| empty| \u81EA\u5B9A\u4E49\u5F53\u9009\u9879\u4E3A\u7A7A\u65F6\u7684\u5185\u5BB9 |\n| prefix| \u8F93\u5165\u6846\u7684\u524D\u7F00 |\n| tag 2.5.0| select \u7EC4\u4EF6\u81EA\u5B9A\u4E49\u6807\u7B7E\u5185\u5BB9 |\n| loading 2.5.2| select \u7EC4\u4EF6\u81EA\u5B9A\u4E49 loading\u5185\u5BB9 |\n\n#### Exposes\n\n| \u65B9\u6CD5| \u63CF\u8FF0| \u7C7B\u578B |\n| :--- | :--- | :--- |\n| focus| \u4F7F\u9009\u62E9\u5668\u7684\u8F93\u5165\u6846\u83B7\u53D6\u7126\u70B9| Function |\n| blur| \u4F7F\u9009\u62E9\u5668\u7684\u8F93\u5165\u6846\u5931\u53BB\u7126\u70B9\uFF0C\u5E76\u9690\u85CF\u4E0B\u62C9\u6846| Function |\n\n#### \u6E90\u4EE3\u7801\n\n#### \u8D21\u732E\u8005\n",
          "v-model": {
            "type": "attr",
            "values": [],
            "description": "\u9009\u4E2D\u9879\u7ED1\u5B9A\u503C"
          },
          "multiple": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u591A\u9009"
          },
          "disabled": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u7981\u7528"
          },
          "value-key": {
            "type": "attr",
            "values": [],
            "description": "\u4F5C\u4E3A value \u552F\u4E00\u6807\u8BC6\u7684\u952E\u540D\uFF0C\u7ED1\u5B9A\u503C\u4E3A\u5BF9\u8C61\u7C7B\u578B\u65F6\u5FC5\u586B"
          },
          "size": {
            "type": "attr",
            "values": ["large", "large", "small"],
            "description": "\u8F93\u5165\u6846\u5C3A\u5BF8"
          },
          "clearable": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u53EF\u4EE5\u6E05\u7A7A\u9009\u9879"
          },
          "collapse-tags": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u591A\u9009\u65F6\u662F\u5426\u5C06\u9009\u4E2D\u503C\u6309\u6587\u5B57\u7684\u5F62\u5F0F\u5C55\u793A"
          },
          "collapse-tags-tooltip": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u5F53\u9F20\u6807\u60AC\u505C\u4E8E\u6298\u53E0\u6807\u7B7E\u7684\u6587\u672C\u65F6\uFF0C\u662F\u5426\u663E\u793A\u6240\u6709\u9009\u4E2D\u7684\u6807\u7B7E\u3002 \u8981\u4F7F\u7528\u6B64\u5C5E\u6027\uFF0Ccollapse-tags\u5C5E\u6027\u5FC5\u987B\u8BBE\u5B9A\u4E3A true"
          },
          "multiple-limit": {
            "type": "attr",
            "values": ["number"],
            "description": "multiple \u5C5E\u6027\u8BBE\u7F6E\u4E3A true \u65F6\uFF0C\u4EE3\u8868\u591A\u9009\u573A\u666F\u4E0B\u7528\u6237\u6700\u591A\u53EF\u4EE5\u9009\u62E9\u7684\u9879\u76EE\u6570\uFF0C \u4E3A 0 \u5219\u4E0D\u9650\u5236"
          },
          "name": {
            "type": "attr",
            "values": [],
            "description": "Select \u8F93\u5165\u6846\u7684\u539F\u751F name \u5C5E\u6027"
          },
          "effect": {
            "type": "attr",
            "values": ["dark", "light"],
            "description": "tooltip \u4E3B\u9898\uFF0C\u5185\u7F6E\u4E86 dark / light \u4E24\u79CD"
          },
          "autocomplete": {
            "type": "attr",
            "values": [],
            "description": "Select \u8F93\u5165\u6846\u7684\u539F\u751F autocomplete \u5C5E\u6027"
          },
          "placeholder": {
            "type": "attr",
            "values": [],
            "description": "\u5360\u4F4D\u7B26\uFF0C\u9ED8\u8BA4\u4E3A\u201CSelect\u201D"
          },
          "filterable": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "Select \u7EC4\u4EF6\u662F\u5426\u53EF\u7B5B\u9009"
          },
          "allow-create": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u5141\u8BB8\u7528\u6237\u521B\u5EFA\u65B0\u6761\u76EE\uFF0C \u53EA\u6709\u5F53 filterable \u8BBE\u7F6E\u4E3A true \u65F6\u624D\u4F1A\u751F\u6548\u3002"
          },
          "filter-method": {
            "type": "attr",
            "values": ["Function"],
            "description": "\u81EA\u5B9A\u4E49\u7B5B\u9009\u65B9\u6CD5"
          },
          "remote": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u5176\u4E2D\u7684\u9009\u9879\u662F\u5426\u4ECE\u670D\u52A1\u5668\u8FDC\u7A0B\u52A0\u8F7D"
          },
          "remote-method": {
            "type": "attr",
            "values": ["Function"],
            "description": "\u81EA\u5B9A\u4E49\u8FDC\u7A0B\u641C\u7D22\u65B9\u6CD5"
          },
          "remote-show-suffix": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u8FDC\u7A0B\u641C\u7D22\u65B9\u6CD5\u663E\u793A\u540E\u7F00\u56FE\u6807"
          },
          "loading": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u6B63\u5728\u4ECE\u8FDC\u7A0B\u83B7\u53D6\u6570\u636E"
          },
          "loading-text": {
            "type": "attr",
            "values": [],
            "description": "\u4ECE\u670D\u52A1\u5668\u52A0\u8F7D\u6570\u636E\u65F6\u663E\u793A\u7684\u6587\u672C\uFF0C\u9ED8\u8BA4\u4E3A\u201CLoading\u201D"
          },
          "no-match-text": {
            "type": "attr",
            "values": [],
            "description": "\u641C\u7D22\u6761\u4EF6\u65E0\u5339\u914D\u65F6\u663E\u793A\u7684\u6587\u5B57\uFF0C\u4E5F\u53EF\u4EE5\u4F7F\u7528 empty \u63D2\u69FD\u8BBE\u7F6E\uFF0C\u9ED8\u8BA4\u662F \u201CNo matching data'\u201D"
          },
          "no-data-text": {
            "type": "attr",
            "values": [],
            "description": "\u65E0\u9009\u9879\u65F6\u663E\u793A\u7684\u6587\u5B57\uFF0C\u4E5F\u53EF\u4EE5\u4F7F\u7528 empty \u63D2\u69FD\u8BBE\u7F6E\u81EA\u5B9A\u4E49\u5185\u5BB9\uFF0C\u9ED8\u8BA4\u662F \u201CNo data\u201D"
          },
          "popper-class": {
            "type": "attr",
            "values": [],
            "description": "\u9009\u62E9\u5668\u4E0B\u62C9\u83DC\u5355\u7684\u81EA\u5B9A\u4E49\u7C7B\u540D"
          },
          "reserve-keyword": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u5F53 multiple \u548C filterable\u88AB\u8BBE\u7F6E\u4E3A true \u65F6\uFF0C\u662F\u5426\u5728\u9009\u4E2D\u4E00\u4E2A\u9009\u9879\u540E\u4FDD\u7559\u5F53\u524D\u7684\u641C\u7D22\u5173\u952E\u8BCD"
          },
          "default-first-option": {
            "type": "attr",
            "values": ["false"],
            "description": "\u662F\u5426\u5728\u8F93\u5165\u6846\u6309\u4E0B\u56DE\u8F66\u65F6\uFF0C\u9009\u62E9\u7B2C\u4E00\u4E2A\u5339\u914D\u9879\u3002 \u9700\u914D\u5408 filterable \u6216 remote \u4F7F\u7528"
          },
          "teleported": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u5C06\u4E0B\u62C9\u5217\u8868\u63D2\u5165\u81F3 body \u5143\u7D20"
          },
          "persistent": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u5F53\u4E0B\u62C9\u9009\u62E9\u5668\u672A\u88AB\u6FC0\u6D3B\u5E76\u4E14persistent\u8BBE\u7F6E\u4E3Afalse\uFF0C\u9009\u62E9\u5668\u4F1A\u88AB\u5220\u9664\u3002"
          },
          "automatic-dropdown": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u5BF9\u4E8E\u4E0D\u53EF\u641C\u7D22\u7684 Select\uFF0C\u662F\u5426\u5728\u8F93\u5165\u6846\u83B7\u5F97\u7126\u70B9\u540E\u81EA\u52A8\u5F39\u51FA\u9009\u9879\u83DC\u5355"
          },
          "clear-icon": {
            "type": "attr",
            "values": [],
            "description": "\u81EA\u5B9A\u4E49\u6E05\u9664\u56FE\u6807"
          },
          "fit-input-width": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u4E0B\u62C9\u6846\u7684\u5BBD\u5EA6\u662F\u5426\u4E0E\u8F93\u5165\u6846\u76F8\u540C"
          },
          "suffix-icon": {
            "type": "attr",
            "values": [],
            "description": "\u81EA\u5B9A\u4E49\u540E\u7F00\u56FE\u6807\u7EC4\u4EF6"
          },
          "suffix-transitiondeprecated": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u4E0B\u62C9\u83DC\u5355\u663E\u793A/\u6D88\u5931\u65F6\u540E\u7F00\u56FE\u6807\u7684\u52A8\u753B"
          },
          "tag-type": {
            "type": "attr",
            "values": ["success", "info", "warning", "danger"],
            "description": "\u6807\u7B7E\u7C7B\u578B"
          },
          "validate-event": {
            "type": "attr",
            "values": ["true", "false"],
            "description": "\u662F\u5426\u89E6\u53D1\u8868\u5355\u9A8C\u8BC1"
          },
          "placement": {
            "type": "attr",
            "values": ["top", "top-start", "top-end", "bottom", "bottom-start", "bottom-end", "left", "left-start", "left-end", "right", "right-start", "right-end"],
            "description": "\u4E0B\u62C9\u6846\u51FA\u73B0\u7684\u4F4D\u7F6E"
          },
          "fallback-placements": {
            "type": "attr",
            "values": ["array"],
            "description": "dropdown \u53EF\u7528\u7684 positions \u8BF7\u67E5\u770Bpopper.js \u6587\u6863"
          },
          "max-collapse-tags": {
            "type": "attr",
            "values": ["number"],
            "description": "\u9700\u8981\u663E\u793A\u7684 Tag \u7684\u6700\u5927\u6570\u91CF \u53EA\u6709\u5F53 collapse-tags \u8BBE\u7F6E\u4E3A true \u65F6\u624D\u4F1A\u751F\u6548\u3002"
          },
          "popper-options": {
            "type": "attr",
            "values": ["objectrefer"],
            "description": "popper.js \u53C2\u6570"
          },
          "aria-labelay": {
            "type": "attr",
            "values": [],
            "description": "\u7B49\u4EF7\u4E8E\u539F\u751F input aria-label \u5C5E\u6027"
          },
          "empty-values": {
            "type": "attr",
            "values": ["array"],
            "description": "\u7EC4\u4EF6\u7684\u7A7A\u503C\u914D\u7F6E \u53C2\u8003config-provider"
          },
          "value-on-clear": {
            "type": "attr",
            "values": [],
            "description": "\u6E05\u7A7A\u9009\u9879\u7684\u503C \u53C2\u8003 config-provider"
          },
          "change": {
            "type": "event",
            "values": [],
            "description": "\u9009\u4E2D\u503C\u53D1\u751F\u53D8\u5316\u65F6\u89E6\u53D1"
          },
          "visible-change": {
            "type": "event",
            "values": [],
            "description": "\u4E0B\u62C9\u6846\u51FA\u73B0/\u9690\u85CF\u65F6\u89E6\u53D1"
          },
          "remove-tag": {
            "type": "event",
            "values": [],
            "description": "\u591A\u9009\u6A21\u5F0F\u4E0B\u79FB\u9664tag\u65F6\u89E6\u53D1"
          },
          "clear": {
            "type": "event",
            "values": [],
            "description": "\u53EF\u6E05\u7A7A\u7684\u5355\u9009\u6A21\u5F0F\u4E0B\u7528\u6237\u70B9\u51FB\u6E05\u7A7A\u6309\u94AE\u65F6\u89E6\u53D1"
          },
          "blur": {
            "type": "event",
            "values": [],
            "description": "\u5F53 input \u5931\u53BB\u7126\u70B9\u65F6\u89E6\u53D1"
          },
          "focus": {
            "type": "event",
            "values": [],
            "description": "\u5F53 input \u83B7\u5F97\u7126\u70B9\u65F6\u89E6\u53D1"
          }
        },
        "el-slider": {
          "_html": {
            "": '<el-slider v-model="${1:value}" />',
            ":show-input": '<el-slider v-model="${1:value}" show-input />',
            ":step": '<el-slider v-model="${1:value}" :step="${2:10}" />',
            ":range": '<el-slider v-model="${1:value}" range show-stops :max="${2:10}" />',
            ":marks": '<el-slider v-model="${1:value}" range :marks="${2:marks}" />'
          },
          "_doc": "#### [\u8BBF\u95EE](https://element-plus.org/zh-CN/component/slider.html)\n#### \u5C5E\u6027\n\n| \u5C5E\u6027\u540D| \u63CF\u8FF0| \u7C7B\u578B| \u9ED8\u8BA4 |\n| :--- | :--- | :--- | :--- |\n| model-value / v-model| 