﻿;(function(factory) {
    if (typeof define === "function" && (define.amd || define.cmd) && !jQuery) {
        define(["jquery"], factory);
    } else if (typeof module === 'object' && module.exports) {
        module.exports = function(root, jQuery) {
            if (jQuery === undefined) {
                if (typeof window !== 'undefined') {
                    jQuery = require('jquery');
                } else {
                    jQuery = require('jquery')(root);
                }
            }
            factory(jQuery);
            return jQuery;
        };
    } else {
        factory(jQuery);
    }
}(function($) {
    $.emoticons = function(parameter, getApi) {
        if (typeof parameter == 'function') {
            getApi = parameter;
            parameter = {};
        } else {
            parameter = parameter || {};
            getApi = getApi || function() {};
        }
        var defaults = {
            'prefix': 'widget',
            'publisherCls': 'f_content',
            'triggerCls': 'trigger',
            'activeCls': 'active',
            'path': '/ui/images/face/',
            'list': [{
                'title': '微笑',
                'url': 'weixiao.gif'
            }, {
                'title': '嘻嘻',
                'url': 'xixi.gif'
            }, {
                'title': '哈哈',
                'url': 'haha.gif'
            }, {
                'title': '可爱',
                'url': 'keai.gif'
            }, {
                'title': '可怜',
                'url': 'kelian.gif'
            }, {
                'title': '挖鼻',
                'url': 'wabi.gif'
            }, {
                'title': '吃惊',
                'url': 'chijing.gif'
            }, {
                'title': '害羞',
                'url': 'haixiu.gif'
            }, {
                'title': '挤眼',
                'url': 'jiyan.gif'
            }, {
                'title': '闭嘴',
                'url': 'bizui.gif'
            }, {
                'title': '鄙视',
                'url': 'bishi.gif'
            }, {
                'title': '爱你',
                'url': 'aini.gif'
            }, {
                'title': '泪',
                'url': 'lei.gif'
            }, {
                'title': '偷笑',
                'url': 'touxiao.gif'
            }, {
                'title': '亲亲',
                'url': 'qinqin.gif'
            }, {
                'title': '生病',
                'url': 'shengbing.gif'
            }, {
                'title': '太开心',
                'url': 'taikaixin.gif'
            }, {
                'title': '白眼',
                'url': 'baiyan.gif'
            }, {
                'title': '右哼哼',
                'url': 'youhengheng.gif'
            }, {
                'title': '左哼哼',
                'url': 'zuohengheng.gif'
            }, {
                'title': '嘘',
                'url': 'xu.gif'
            }, {
                'title': '衰',
                'url': 'shuai.gif'
            }, {
                'title': '吐',
                'url': 'tu.gif'
            }, {
                'title': '哈欠',
                'url': 'haqian.gif'
            }, {
                'title': '抱抱',
                'url': 'baobao.gif'
            }, {
                'title': '怒',
                'url': 'nu.gif'
            }, {
                'title': '疑问',
                'url': 'yiwen.gif'
            }, {
                'title': '馋嘴',
                'url': 'chanzui.gif'
            }, {
                'title': '拜拜',
                'url': 'baibai.gif'
            }, {
                'title': '思考',
                'url': 'sikao.gif'
            }, {
                'title': '汗',
                'url': 'han.gif'
            }, {
                'title': '困',
                'url': 'kun.gif'
            }, {
                'title': '睡',
                'url': 'shui.gif'
            }, {
                'title': '钱',
                'url': 'qian.gif'
            }, {
                'title': '失望',
                'url': 'shiwang.gif'
            }, {
                'title': '酷',
                'url': 'ku.gif'
            }, {
                'title': '色',
                'url': 'se.gif'
            }, {
                'title': '哼',
                'url': 'heng.gif'
            }, {
                'title': '鼓掌',
                'url': 'guzhang.gif'
            }, {
                'title': '晕',
                'url': 'yun.gif'
            }, {
                'title': '悲伤',
                'url': 'beishang.gif'
            }, {
                'title': '抓狂',
                'url': 'zhuakuang.gif'
            }, {
                'title': '黑线',
                'url': 'heixian.gif'
            }, {
                'title': '阴险',
                'url': 'yinxian.gif'
            }, {
                'title': '怒骂',
                'url': 'numa.gif'
            }, {
                'title': '互粉',
                'url': 'hufen.gif'
            }, {
                'title': '书呆子',
                'url': 'shudaizi.gif'
            }, {
                'title': '愤怒',
                'url': 'fennu.gif'
            }, {
                'title': '感冒',
                'url': 'ganmao.gif'
            }, {
                'title': '心',
                'url': 'xin.gif'
            }, {
                'title': '伤心',
                'url': 'shangxin.gif'
            }, {
                'title': '猪',
                'url': 'zhu.gif'
            }, {
                'title': '熊猫',
                'url': 'xiongmao.gif'
            }, {
                'title': '兔子',
                'url': 'tuzi.gif'
            }, {
                'title': 'OK',
                'url': 'ok.gif'
            }, {
                'title': '耶',
                'url': 'ye.gif'
            }, {
                'title': 'GOOD',
                'url': 'good.gif'
            }, {
                'title': 'NO',
                'url': 'no.gif'
            }, {
                'title': '赞',
                'url': 'zan.gif'
            }, {
                'title': '来',
                'url': 'lai.gif'
            }, {
                'title': '弱',
                'url': 'ruo.gif'
            }, {
                'title': '草泥马',
                'url': 'caonima.gif'
            }, {
                'title': '神马',
                'url': 'shenma.gif'
            }, {
                'title': '囧',
                'url': 'jiong.gif'
            }, {
                'title': '浮云',
                'url': 'fuyun.gif'
            }, {
                'title': '给力',
                'url': 'geili.gif'
            }, {
                'title': '围观',
                'url': 'weiguan.gif'
            }, {
                'title': '威武',
                'url': 'weiwu.gif'
            }, {
                'title': '话筒',
                'url': 'huatong.gif'
            }, {
                'title': '蜡烛',
                'url': 'lazhu.gif'
            }, {
                'title': '蛋糕',
                'url': 'dangao.gif'
            }, {
                'title': '发红包',
                'url': 'fahongbao.gif'
            }],
            'top': 0,
            'left': 0,
            'onShow': function() {},
            'onHide': function() {},
            'onSelect': function() {}
        };
        var options = $.extend({}, defaults, parameter);
        var _api = {};
        var $document = $(document);
        var $body = $('body');
        var $layer = $('<div class="' + options.prefix + '-layer">').appendTo($body);
        var $close = $('<a class="' + options.prefix + '-close" href="javascript:;" title="关闭">×</a>').appendTo($layer);
        var $panel = $('<div class="' + options.prefix + '-panel"></div>').appendTo($layer);
        var $list = $('<ul></ul>').appendTo($panel);
        var $trigger = null;
        var $textarea = null;
        var _hash = {};
        $layer.css({
            'position': 'absolute',
            'display': 'none'
        });
        $.each(options.list, function(index, item) {
            _hash[item.title] = options.path + item.url;
            $list.append('<li title="' + item.title + '"><img data-src="' + _hash[item.title] + '"/></li>');
        });
        _api.getTextarea = function() {
            return $textarea;
        }, _api.format = function(str) {
            var list = str.match(/\[[\u4e00-\u9fa5]*\w*\]/g);
            var filter = /[\[\]]/g;
            var title;
            if (list) {
                for (var i = 0; i < list.length; i++) {
                    title = list[i].replace(filter, '');
                    if (_hash[title]) {
                        str = str.replace(list[i], ' <img src="' + _hash[title] + '"/> ');
                    }
                }
            }
            return str;
        };
        var closeLayer = function() {
            if ($trigger) {
                $trigger.removeClass(options.activeCls);
            }
            $layer.hide();
            $trigger = null;
            $textarea = null;
            options.onHide();
        };
        $document.on('click', '.' + options.triggerCls, function() {
            $trigger = $(this);
            var $publisher = $trigger.parents('.' + options.publisherCls);
            $textarea = $publisher.find('textarea');
            var offset = $trigger.offset();
            var height = $trigger.outerHeight();
            $trigger.addClass(options.activeCls);
            $layer.find('img').each(function() {
                var $this = $(this);
                $this.attr('src', $this.data('src'));
            });
            $layer.css({
                left: offset.left + options.left,
                top: offset.top + height + options.top
            }).show();
            options.onShow();
        });
        $document.on('click', function(e) {
            var $target = $(e.target);
            if (!$target.is('.' + options.triggerCls) && !$target.closest('.' + options.prefix + '-layer').length) {
                closeLayer();
            }
        });
        $layer.on('click', '.' + options.prefix + '-close', closeLayer);
        $layer.on('click', 'li', function() {
            var $this = $(this);
            var title = $this.attr('title');
            if ($textarea) {
                insertText($textarea[0], '[' + title + ']');
            }
            options.onSelect(_api);
        });
        $document.on('select click keyup', '.' + options.publisherCls + ' textarea', function() {
            if (this.createTextRange) {
                this.caretPos = document.selection.createRange().duplicate();
            }
        });
        getApi(_api);
        return this;
    };

    function insertText(obj, str) {
        if (document.all && obj.createTextRange && obj.caretPos) {
            var caretPos = obj.caretPos;
            caretPos.text = caretPos.text.charAt(caretPos.text.length - 1) == '' ? str + '' : str;
        } else if (typeof obj.selectionStart === 'number' && typeof obj.selectionEnd === 'number') {
            var startPos = obj.selectionStart,
                endPos = obj.selectionEnd,
                cursorPos = startPos,
                tmpStr = obj.value;
            obj.value = tmpStr.substring(0, startPos) + str + tmpStr.substring(endPos, tmpStr.length);
            cursorPos += str.length;
            obj.selectionStart = obj.selectionEnd = cursorPos;
        } else {
            obj.value += str;
        }
    }
}));
(function() {
    var readmore = 'readmore',
        defaults = {
            speed: 100,
            maxHeight: 200,
            heightMargin: 16,
            moreLink: '<a href="#">more <i class="layui-icon layui-icon-down"></i></a>',
            lessLink: '<a href="#">close <i class="layui-icon layui-icon-up"></i></a>',
            embedCSS: true,
            sectionCSS: '',
            startOpen: false,
            expandedClass: 'readmore-js-expanded',
            collapsedClass: 'readmore-js-collapsed',
            beforeToggle: function() {},
            afterToggle: function() {}
        }, cssEmbedded = false;

    function Readmore(element, options) {
        this.element = element;
        this.options = $.extend({}, defaults, options);
        $(this.element).data('max-height', this.options.maxHeight);
        $(this.element).data('height-margin', this.options.heightMargin);
        delete(this.options.maxHeight);
        if (this.options.embedCSS && !cssEmbedded) {
            var styles = '.readmore-js-toggle, .readmore-js-section { ' + this.options.sectionCSS + ' } .readmore-js-section { overflow: hidden; }';
            (function(d, u) {
                var css = d.createElement('style');
                css.type = 'text/css';
                if (css.styleSheet) {
                    css.styleSheet.cssText = u;
                } else {
                    css.appendChild(d.createTextNode(u));
                }
                d.getElementsByTagName('head')[0].appendChild(css);
            }(document, styles));
            cssEmbedded = true;
        }
        this._defaults = defaults;
        this._name = readmore;
        this.init();
    }
    Readmore.prototype = {
        init: function() {
            var $this = this;
            $(this.element).each(function() {
                var current = $(this),
                    maxHeight = (current.css('max-height').replace(/[^-\d\.]/g, '') > current.data('max-height')) ? current.css('max-height').replace(/[^-\d\.]/g, '') : current.data('max-height'),
                    heightMargin = current.data('height-margin');
                if (current.css('max-height') != 'none') {
                    current.css('max-height', 'none');
                }
                $this.setBoxHeight(current);
                if (current.outerHeight(true) <= maxHeight + heightMargin) {
                    return true;
                } else {
                    current.addClass('readmore-js-section ' + $this.options.collapsedClass).data('collapsedHeight', maxHeight);
                    var useLink = $this.options.startOpen ? $this.options.lessLink : $this.options.moreLink;
                    current.after($(useLink).on('click', function(event) {
                        $this.toggleSlider(this, current, event)
                    }).addClass('readmore-js-toggle'));
                    if (!$this.options.startOpen) {
                        current.css({
                            height: maxHeight
                        });
                    }
                }
            });
            $(window).on('resize', function(event) {
                $this.resizeBoxes();
            });
        },
        toggleSlider: function(trigger, element, event) {
            event.preventDefault();
            var $this = this,
                newHeight = newLink = sectionClass = '',
                expanded = false,
                collapsedHeight = $(element).data('collapsedHeight');
            if ($(element).height() <= collapsedHeight) {
                newHeight = $(element).data('expandedHeight') + 'px';
                newLink = 'lessLink';
                expanded = true;
                sectionClass = $this.options.expandedClass;
            } else {
                newHeight = collapsedHeight;
                newLink = 'moreLink';
                sectionClass = $this.options.collapsedClass;
            }
            $this.options.beforeToggle(trigger, element, expanded);
            $(element).animate({
                'height': newHeight
            }, {
                duration: $this.options.speed,
                complete: function() {
                    $this.options.afterToggle(trigger, element, expanded);
                    $(trigger).replaceWith($($this.options[newLink]).on('click', function(event) {
                        $this.toggleSlider(this, element, event)
                    }).addClass('readmore-js-toggle'));
                    $(this).removeClass($this.options.collapsedClass + ' ' + $this.options.expandedClass).addClass(sectionClass);
                }
            });
        },
        setBoxHeight: function(element) {
            var el = element.clone().css({
                'height': 'auto',
                'width': element.width(),
                'overflow': 'hidden'
            }).insertAfter(element),
                height = el.outerHeight(true);
            el.remove();
            element.data('expandedHeight', height);
        },
        resizeBoxes: function() {
            var $this = this;
            $('.readmore-js-section').each(function() {
                var current = $(this);
                $this.setBoxHeight(current);
                if (current.height() > current.data('expandedHeight') || (current.hasClass($this.options.expandedClass) && current.height() < current.data('expandedHeight'))) {
                    current.css('height', current.data('expandedHeight'));
                }
            });
        },
        destroy: function() {
            var $this = this;
            $(this.element).each(function() {
                var current = $(this);
                current.removeClass('readmore-js-section ' + $this.options.collapsedClass + ' ' + $this.options.expandedClass).css({
                    'max-height': '',
                    'height': 'auto'
                }).next('.readmore-js-toggle').remove();
                current.removeData();
            });
        }
    };
    $.fn[readmore] = function(options) {
        var args = arguments;
        if (options === undefined || typeof options === 'object') {
            return this.each(function() {
                if ($.data(this, 'plugin_' + readmore)) {
                    var instance = $.data(this, 'plugin_' + readmore);
                    instance['destroy'].apply(instance);
                }
                $.data(this, 'plugin_' + readmore, new Readmore(this, options));
            });
        } else if (typeof options === 'string' && options[0] !== '_' && options !== 'init') {
            return this.each(function() {
                var instance = $.data(this, 'plugin_' + readmore);
                if (instance instanceof Readmore && typeof instance[options] === 'function') {
                    instance[options].apply(instance, Array.prototype.slice.call(args, 1));
                }
            });
        }
    }
})(jQuery);
(function() {
    $.fn.touchTouch = function() {
        var overlay = $('<div class="galleryOverlay">'),
            slider = $('<div class="gallerySlider">'),
            prevArrow = $('<a class="prevArrow"></a>'),
            nextArrow = $('<a class="nextArrow"></a>'),
            pageSpan = $('<div class="pagelimit"></div'),
            close = $('<div class="closed"></div'),
            overlayVisible = false;
        var placeholders = $([]),
            pl1 = [],
            index = 0,
            items = this;
        overlay.hide().appendTo('body');
        slider.appendTo(overlay);
        pageSpan.appendTo(overlay);
        items.each(function() {
            placeholders = placeholders.add($('<div class="placeholder">'));
        });
        slider.append(placeholders).on('click', function(e) {
            hideOverlay();
        });
        $('body').on('touchstart', '.gallerySlider img', function(e) {
            var touch = e.originalEvent,
                startX = touch.changedTouches[0].pageX;
            slider.on('touchmove', function(e) {
                e.preventDefault();
                touch = e.originalEvent.touches[0] || e.originalEvent.changedTouches[0];
                if (touch.pageX - startX > 10) {
                    slider.off('touchmove');
                    showPrevious();
                } else if (touch.pageX - startX < -10) {
                    slider.off('touchmove');
                    showNext();
                }
            });
            return false;
        }).on('touchend', function() {
            slider.off('touchmove');
        });
        items.on('click', function(e) {
            e.preventDefault();
            index = items.index(this);
            showOverlay(index);
            showImage(index);
            calcPages(items, index);
            preload(index + 1);
            preload(index - 1);
            offsetSlider1(index);
            $(document).data("overlayVisible", true);
            e.cancelBubble = true;
        });

        function calcPages(items, index) {
            pageSpan.text((index + 1) + "/" + items.length);
        }
        if (!("ontouchstart" in window)) {
            overlay.append(prevArrow).append(nextArrow);
            prevArrow.click(function(e) {
                e.preventDefault();
                showPrevious();
            });
            nextArrow.click(function(e) {
                e.preventDefault();
                showNext();
            });
        }
        $(window).bind('keydown', function(e) {
            if (e.keyCode == 37) {
                showPrevious();
            } else if (e.keyCode == 39) {
                showNext();
            }
        });

        function showOverlay(index) {
            if (overlayVisible) {
                return false;
            }
            overlay.show();
            setTimeout(function() {
                overlay.addClass('visible');
            }, 100);
            offsetSlider1(index);
            overlayVisible = true;
        }

        function hideOverlay() {
            if (!overlayVisible) {
                return false;
            }
            overlay.hide().removeClass('visible');
            overlayVisible = false;
            $(document).data("overlayVisible", overlayVisible);
        }

        function offsetSlider(index) {
            slider.stop(true).animate({
                left: (-index * 100) + '%'
            }, 500);
        }

        function offsetSlider1(index) {
            slider.css('left', (-index * 100) + '%');
        }

        function preload(index) {
            setTimeout(function() {
                showImage(index);
            }, 1000);
        }

        function showImage(index) {
            if (index < 0 || index >= items.length) {
                return false;
            }
            loadImage(items.eq(index).attr('href'), function() {
                placeholders.eq(index).html(this);
            });
        }

        function loadImage(src, callback) {
            var img = $('<img>').on('load', function() {
                callback.call(img);
            });
            img.attr('src', src);
        }

        function showNext() {
            if (index + 1 < items.length) {
                index++;
                offsetSlider(index);
                preload(index + 1);
                calcPages(items, index);
            }
        }

        function showPrevious() {
            if (index > 0) {
                index--;
                offsetSlider(index);
                preload(index - 1);
                calcPages(items, index);
            }
        }
    };
})(jQuery);

function photoCompress(file, w, objDiv) {
    var ready = new FileReader();
    ready.readAsDataURL(file);
    ready.onload = function() {
        var re = this.result;
        canvasDataURL(re, w, objDiv);
    }
};

function canvasDataURL(path, obj, callback) {
    var img = new Image();
    img.src = path;
    img.onload = function() {
        var that = this;
        var w = that.width,
            h = that.height,
            scale = w / h;
        w = obj.width || w;
        h = obj.height || (w / scale);
        var quality = 0.2;
        var canvas = document.createElement('canvas');
        var ctx = canvas.getContext('2d');
        var anw = document.createAttribute("width");
        anw.nodeValue = w;
        var anh = document.createAttribute("height");
        anh.nodeValue = h;
        canvas.setAttributeNode(anw);
        canvas.setAttributeNode(anh);
        ctx.drawImage(that, 0, 0, w, h);
        if (obj.quality && obj.quality <= 1 && obj.quality > 0) {
            quality = obj.quality;
        }
        var base64 = canvas.toDataURL('image/jpeg', quality);
        callback(base64);
    }
}

function convertBase64UrlToBlob(urlData) {
    var arr = urlData.split(','),
        mime = arr[0].match(/:(.*?);/)[1],
        bstr = atob(arr[1]),
        n = bstr.length,
        u8arr = new Uint8Array(n);
    while (n--) {
        u8arr[n] = bstr.charCodeAt(n);
    }
    return new Blob([u8arr], {
        type: mime
    });
}

function emo() {
	
	$(".widget-layer").remove()
	var path=$("input[name=path]").val()
    $.emoticons({
		'activeCls': 'trigger-active',
		'path': path+'ui/images/face/'
    }, function(api) {
        var $content = $('textarea[name="content"]');
        var $result = $('article');
        $("article").each(function() {
            $(this).html(api.format($(this).html()));
        });
    });
};





function homeauzs() {
 
	var title = $("title").html()
    $.ajax({
        type: "post",
        dataType: "json",
        cache: true,
        url: "inc/ajax.asp",
        data: {
            "act":"auzinfo",
            "title":title
        },
        success: function(data) {
            var isauz = data.vip
            if (data.ad == 1) {
                $(".main").prepend("<div id=notice><a href=" + data.url + " target='_bank'>" + data.title + "</a></div>");
            }
			
	
 

          
        },
    });
	
}

function formauzs() {
 if ($(".jianbook_cor").html()){
	var title = $(".jianbook_cor").html() 
	 }
	 else
	 {var title = ""
		 }
	
    $.ajax({
        type: "post",
        dataType: "json",
        cache: true,
        url: "../inc/ajax.asp",
        data: {
            "act":"auzinfo",
            "title":title
        },
        success: function(data) {
            var isauz = data.vip
            if (data.ad == 1) {
                $(".main").prepend("<div id=notice><a href=" + data.url + " target='_bank'>" + data.title + "</a></div>");
            }
		 var strs1 = cn("&#57;&#52;&#49;&#54;&#46;&#99;&#110;")
  if (isauz == 0) {
       if (title.indexOf(strs1) == -1) {alert(cn('&#19981;&#35201;&#21024;&#38500;&#29256;&#26435;&#65292;&#25480;&#26435;&#35831;&#32852;&#31995;&#23448;&#32593;'))}
  }
          
        },
    });
	
}





$(function() {
$(document).on("click", ".m-video", function(e){

			var video=$(this).attr("data-src")
		$('.mask_bg').css("display","flex");
	
		$('.video_box ').html('<video id="demo" src="'+video+'" width="100%" controls ></video>')
		
		
		var Media = document.getElementById("demo");
            //2、调用视频播放API
            Media.play();
			
	});

	$('#close-video, .mask_bg').on('click', function(){
		$('.mask_bg').hide();
		var Media = document.getElementById("demo");
            //2、调用视频播放API
            Media.pause();
		
}); 


	
    emo()
 pic()

});