import re
import json

re_zh_include = re.compile("([\u4E00-\u9FA5]+)", re.U)
re_zh_exclude = re.compile("[\u4E00-\u9FA5]+", re.U)

re_puncs_include = re.compile(r'([。？！，、：；])')
re_puncs_exclude = re.compile(r'[。？！，、：；]')

re_invalid_chars = re.compile(r'[^\u4E00-\u9FA5。？！，、：；]+', re.U)

stopchars = {'之', '兹', '此', '彼',
             '谁', '孰', '何', '奚', '曷', '焉',
             '或', '有', '某',
             '莫', '弗', '毋', '勿', '不', '得',
             '亦', '乃',
             '於', '于', '乎', '在', '而', '以', '为',
             '其', '唯', '惟', '焉', '者', '所',
             '也', '矣', '已',
             '欤', '耶', '哉', '兮',
             '必', '又', '每', '皆', '仅', '只',
             '甚', '颇', '岂',
             '曰'}


def get_char_pos_dict():
    with open('data/char_pos_dict.json', 'r') as f:
        char_pos_dict = json.load(f)
    return char_pos_dict


re_num = re.compile(r'[第一二三四五六七八九十百千万]{2,}')
re_calender = re.compile(r'[甲乙丙丁戊己庚辛壬癸子丑寅卯辰巳午未申酉戌亥]{2,}')


"""
http://www.ziyexing.com/files-5/guhanyu/guhanyu_index.html
"""
pron_single = {'我', '吾', '你', '而', '乃', '若', '其', '之', '他'}
pron_plural = {'吾侪', '吾曹', '吾属', '我属', '我辈', '若曹', '而属', '尔辈', '公等', '卿等'}
pron_demonstrate = {'之', '斯', '兹', '此', '是', '彼', '夫', '伊'}
pron_interrogative = {'谁', '孰', '何', '奚', '胡', '曷', '恶', '焉', '安', '几'}
pron_indefinite = {'或', '有', '某'}
pron_negative = {'莫', '罔', '无', '靡', '蔑', '末'}
auxiliary_verb = {'克', '能', '堪', '可', '可以', '可得', '得', '足', '足以',
                  '欲', '肯', '将', '宁', '敢', '忍', '愿',
                  '当', '如', '宜', '任', '合', '应',
                  '见', '被', '为'}
preposition = {'於', '于', '乎', '以', '在', '即', '及', '自', '从', '由',
               '当', '到', '迨', '逮', '至', '比', '竟', '向', '临', '先'
               '因', '用', '缘', '为', '乎', '从', '与'}
conjunction = {'夫', '若', '如', '且', '至', '若夫', '且夫', '至于', '至如',
               '既', '终', '已',
               '如', '苟', '使', '令', '即', '抑', '向', '诚', '果', '设', '假',
               '若苟', '向使', '若使', '如若', '如使', '如令', '如果', '苟使', '假设',
               '假使', '假如', '假若', '假令', '设使', '设若', '设令', '倘若', '倘使', '诚使', '诚令'
               '虽', '则', '且', '而', '尚', '犹', '且犹', '尚犹', '纵', '虽则', '虽使', '与其', '与', '以', '为', '由',
               '与', '及', '暨', '之以', '而', '且又', '亦', '而且', '而又',
               '况', '而况', '况于', '何况',
               '故', '乃', '是以', '是用', '是故', '以故', '因是',
               '然则', '然而', '但'}
particle = {'其', '之', '斯', '思',                        # rhyme
            '唯', '惟',                                    # syntax
            '有', '畴', '丕', '薄', '言',                   # word prefix
            '然', '焉', '尔', '而', '斯', '若', '如', '乎',  # word suffix
            '者', '攸', '所',                               # phrase prefix & suffix
            '载', '有', '式', '于',
            }
modal_particle = {'也', '矣', '已', '而已', '耳', '尔', '而', '焉', '然', '夫', '者', '云',  # affirmative
                  '与', '欤', '邪', '耶', '乎', '为', '则',  # question
                  '哉', '乎', '夫', '为', '兮', '邪',        # exclamation
                  }
