## Programación de comunicaciones en red:
 -	Comunicación entre aplicaciones.
 -	Roles cliente y servidor.
 -	Elementos de programación de aplicaciones en red. Librerías.
 -	Sockets.
 -	Creación de sockets.
 -	Enlazado y establecimiento de conexiones.
 -	Utilización de sockets para la transmisión y recepción de información.
 -	Programación de aplicaciones cliente y servidor.
 -	Utilización de hilos en la programación de aplicaciones en red.

### Teoría de redes
* https://www.jesusninoc.com/12/16/programacion-de-comunicaciones-en-red-programacion-de-servicios-y-procesos/
* https://www.jesusninoc.com/07/31/programacion-de-servicios-y-procesos-en-python/#3_Comunicacion_en_Red_en_Python

### Conceptos
- Peticiones a servidores (GET, POST, fuerza bruta)
- URL
- URL (GET y POST)
- Servicios (bombillas)
- Scraping
- Fuerza bruta https://github.com/jesusninoc/Seguridad/tree/master/GetPost
- Conexión TCP/IP entre distintos sistemas
- Proyecto de conexión remota
- Sockets TCP y UDP
- Serializar https://www.jesusninoc.com/07/05/serializar-y-deserializar-un-objeto-almacenado-en-un-fichero-en-kotlin/
- Serializar JSON https://www.jesusninoc.com/07/05/serializar-y-deserializar-ficheros-json-con-gson-en-kotlin/

### Ejercicios
#### Programación de red en Python
* https://www.jesusninoc.com/07/09/programacion-de-comunicaciones-en-red-con-python/
#### Conectar con una URL en Kotlin
* https://www.jesusninoc.com/07/03/conectar-con-una-url-en-kotlin/
#### Cómo conectar con una URL y cambiar el User-Agent
* https://www.jesusninoc.com/07/03/como-conectar-con-una-url-y-cambiar-el-user-agent/
#### Realizar una petición HTTP POST en Kotlin
* https://www.jesusninoc.com/07/03/realizar-una-peticion-http-post-en-kotlin/
#### Comprobar si un puerto TCP está abierto en Kotlin
* https://www.jesusninoc.com/07/04/comprobar-si-un-puerto-tcp-esta-abierto-en-kotlin/
#### Servidor y cliente TCP básicos en Kotlin
* https://www.jesusninoc.com/07/04/crear-un-servidor-y-un-cliente-en-kotlin/
#### Servidor y Cliente TCP en Kotlin utilizando clases distintas
* https://www.jesusninoc.com/07/04/servidor-y-cliente-tcp-en-kotlin-utilizando-clases-distintas/
#### Servidor y cliente UDP básicos en Kotlin
* https://www.jesusninoc.com/07/04/crear-un-servidor-y-un-cliente-udp-en-kotlin/
#### Enviar un mensaje UDP a un ordenador desde Python
* https://www.jesusninoc.com/08/26/enviar-un-mensaje-udp-a-un-ordenador-desde-python/
#### Cliente y servidor para enviar objeto serializado por TCP en Kotlin (utilizando hilos)
* https://www.jesusninoc.com/07/05/cliente-y-servidor-para-enviar-objeto-serializado-por-tcp-en-kotlin-utilizando-hilos/
#### Enviar una imagen entre un cliente y un servidor utilizando sockets TCP en Kotlin 
* https://www.jesusninoc.com/07/06/enviar-una-imagen-entre-un-cliente-y-un-servidor-utilizando-sockets-tcp-en-kotlin/
#### MulticastSocket en Kotlin
* https://www.jesusninoc.com/07/07/multicastsocket-en-kotlin/
#### Realizar una comunicación multicast entre un código en Android Studio y otro en IntelliJ IDEA
* https://www.jesusninoc.com/12/12/realizar-una-comunicacion-multicast-entre-un-codigo-en-android-studio-y-otro-en-intellij-idea/
#### Enviar un mensaje TCP con Kotlin desde una aplicación en Android Studio a un servidor en IntelliJ IDEA
* https://www.jesusninoc.com/11/27/enviar-un-mensaje-tcp-con-kotlin-desde-una-aplicacion-en-android-studio-a-un-servidor-en-intellij-idea/
#### Enviar la posición del cursor mediante TCP con Kotlin desde una aplicación en Android Studio a un servidor en IntelliJ IDEA
* https://www.jesusninoc.com/11/27/enviar-la-posicion-del-raton-mediante-tcp-con-kotlin-desde-una-aplicacion-en-android-studio-a-un-servidor-en-intellij-idea/
#### Mover el ratón remotamente mediante TCP con Kotlin desde una aplicación en Android Studio a un servidor en IntelliJ IDEA
* https://www.jesusninoc.com/11/28/mover-el-raton-remotamente-mediante-tcp-con-kotlin-desde-una-aplicacion-en-android-studio-a-un-servidor-en-intellij-idea/
#### Crear un API muy simple con Kotlin
* https://www.jesusninoc.com/12/11/crear-un-api-muy-simple-con-kotlin/
#### Crear un API muy simple con Kotlin que devuelve un contenido en formato JSON
* https://www.jesusninoc.com/12/11/crear-un-api-muy-simple-con-kotlin-que-devuelve-un-contenido-en-formato-json/
#### Crear API en Python
* https://www.jesusninoc.com/07/30/crear-un-api-en-python-con-flask-desde-project-idx-que-inserte-y-lea-valores-en-firebase/
* https://www.jesusninoc.com/07/30/crear-un-api-en-python-con-flask-desde-project-idx-que-inserte-y-lea-valores-en-firebase-despues-crear-un-repositorio-con-la-aplicacion-y-desplegarla-en-vercel/
* https://www.jesusninoc.com/07/30/crear-un-api-en-python-con-flask-que-inserte-y-lea-valores-en-firebase-y-desplegarlo-en-vercel/
* https://www.jesusninoc.com/07/30/crear-una-aplicacion-en-swift-para-iphone-que-inserte-un-valor-en-firebase-mediante-una-peticion-post-a-un-api/
#### Proyecto de conexión remota
* https://www.jesusninoc.com/12/26/convertir-la-entrada-de-microfono-a-texto/
* https://www.jesusninoc.com/10/30/transmitir-una-captura-de-pantalla-entre-un-servidor-y-un-cliente-desde-powershell-sockets-tcp/
* https://www.jesusninoc.com/10/30/transmitir-una-captura-de-pantalla-entre-un-servidor-y-un-cliente-y-mostrarla-en-un-formulario-desde-powershell-sockets-tcp/
* https://www.jesusninoc.com/10/30/transmitir-una-captura-de-pantalla-entre-un-servidor-y-un-cliente-y-mostrarla-cada-dos-segundos-en-un-formulario-desde-powershell-sockets-tcp/
* https://www.jesusninoc.com/10/30/realizar-una-comunicacion-bidireccional-entre-un-cliente-y-un-servidor-mediante-tcp-desde-powershell-en-windows/
* https://www.jesusninoc.com/02/01/automatizar-tareas/
* https://www.jesusninoc.com/03/01/mover-el-raton-a-las-posiciones-que-estan-guardadas-en-un-fichero/
* https://www.jesusninoc.com/11/19/hacer-clic-en-una-posicion-de-la-pantalla-con-powershell/
* https://www.jesusninoc.com/02/02/realizar-captura-de-pantalla-y-dividir-en-partes-la-captura/
* https://www.jesusninoc.com/07/06/send-the-cursors-position-between-client-and-server-sockets-udp/
* https://www.jesusninoc.com/07/10/transfer-image-between-server-and-client-sockets-tcp/
* https://www.jesusninoc.com/11/07/transfer-images-between-server-and-client-sockets-tcp/
