## Programación multihilo:
 -	Recursos compartidos por los hilos.
 -	Estados de un hilo. Cambios de estado.
 -	Elementos relacionados con la programación de hilos. Librerías y clases.
 -	Gestión de hilos.
 -	Sincronización de hilos.
 -	Compartición de información entre hilos.
 -	Programación de aplicaciones multihilo.

### Teoría de hilos y concurrencia
* https://www.jesusninoc.com/12/15/programacion-multihilo-programacion-de-servicios-y-procesos/
* https://www.jesusninoc.com/07/31/programacion-de-servicios-y-procesos-en-python/#2_Programacion_de_hilos_en_Python
* https://www.jesusninoc.com/11/11/tabla-de-clases-sobre-concurrencia-en-kotlin/

### Conceptos
- Hilos
- Estado
- Interrupción
- Coroutines
- Sincronización

### Ejercicios
#### Ejecución de tareas con y sin hilos en Python
* https://www.jesusninoc.com/08/25/ejecucion-de-tareas-con-y-sin-hilos-en-python/
#### Sincronización
* https://www.jesusninoc.com/07/03/ejemplo-de-acceso-sincronizado-a-un-contador-en-kotlin-utilizando-corutinas/
#### Tablas de multiplicar con hilos
* https://www.jesusninoc.com/07/03/tablas-de-multiplicar-con-hilos-en-kotlin/
#### Tablas de multiplicar utilizando coroutines en Kotlin
* https://www.jesusninoc.com/07/04/tablas-de-multiplicar-utilizando-coroutines-en-kotlin/
#### Hilos en Python (con y sin sincronización)
* https://www.jesusninoc.com/09/07/hilos-de-python/
#### Aplicación de recordatorio en Kotlin con Timer
* https://www.jesusninoc.com/08/03/aplicacion-de-recordatorio-en-kotlin-con-timer/
#### Crear y administrar tareas concurrentes utilizando hilos en Kotlin
* https://www.jesusninoc.com/08/04/crear-y-administrar-tareas-concurrentes-utilizando-hilos-en-kotlin/
#### Productor-consumidor: Sincronización con colas en Kotlin
* https://www.jesusninoc.com/08/04/productor-consumidor-sincronizacion-con-colas-en-kotlin/
#### Productor-consumidor: Sincronización con colas en Python
* https://www.jesusninoc.com/08/04/productor-consumidor-sincronizacion-con-colas-en-python/
#### Productor-Consumidor en Kotlin utilizando java.util.concurrent
* https://www.jesusninoc.com/08/04/productor-consumidor-en-kotlin-utilizando-java-util-concurrent/
#### Simulación de acceso concurrente seguro a un archivo de registro
* https://www.jesusninoc.com/07/10/simulacion-de-acceso-concurrente-seguro-a-un-archivo-de-registro/

-----------------

# Ejemplo de práctica
* https://www.jesusninoc.com/11/06/ejecutar-hackrf_transfer-desde-kotlin/
* https://www.jesusninoc.com/11/06/ejecutar-hackrf_transfer-desde-un-interfaz-grafico-creado-en-kotlin/
* https://www.jesusninoc.com/11/08/ejecutar-hackrf_transfer-desde-un-interfaz-grafico-creado-en-kotlin-y-utilizando-corrutina/
