## Programación multihilo:
 -	Recursos compartidos por los hilos.
 -	Estados de un hilo. Cambios de estado.
 -	Elementos relacionados con la programación de hilos. Librerías y clases.
 -	Gestión de hilos.
 -	Sincronización de hilos.
 -	Compartición de información entre hilos.
 -	Programación de aplicaciones multihilo.

### Teoría de hilos
* https://www.jesusninoc.com/12/15/programacion-multihilo-programacion-de-servicios-y-procesos/
* https://www.jesusninoc.com/07/31/programacion-de-servicios-y-procesos-en-python/#2_Programacion_de_hilos_en_Python

### Conceptos
- Hilos
- Estado
- Interrupción
- Coroutines
- Sincronización

### Ejercicios
#### Crear un hilo en Python con Flask
* https://www.jesusninoc.com/05/20/crear-un-hilo-en-python-con-flask/
#### Predicción concurrente de objetos en imágenes usando YOLO y hilos en Python
* https://www.jesusninoc.com/08/05/prediccion-concurrente-de-objetos-en-imagenes-usando-yolo-y-hilos-en-python/
#### Formas de crear hilos en Kotlin
* https://www.jesusninoc.com/07/02/formas-de-crear-hilos-en-kotlin/
#### Crear un hilo y esperar a que se ejecute completamente el hilo
* https://www.jesusninoc.com/07/02/crear-un-hilo-en-kotlin-y-esperar-a-que-finalice-la-ejecucion-del-hilo/
#### Carrera de tortuga y liebre
* https://www.jesusninoc.com/07/02/ejemplo-de-creacion-de-threads-en-kotlin-carrera-de-tortuga-y-liebre/
#### Carrera de tortuga y liebre (creando clases)
* https://www.jesusninoc.com/07/02/ejemplo-de-creacion-de-threads-en-kotlin-creando-clases-carrera-de-tortuga-y-liebre/
#### Crear un reloj sencillo en Kotlin mediante hilos
* https://www.jesusninoc.com/07/05/crear-un-reloj-sencillo-en-kotlin-mediante-hilos/
#### Ejecución concurrente
* https://www.jesusninoc.com/06/06/ejecucion-concurrente-de-hilos-en-kotlin/
#### Estados y prioridades de los hilos en Kotlin
* https://www.jesusninoc.com/07/05/estados-y-prioridades-de-los-hilos-en-kotlin/
#### Interrumpir un hilo en Kotlin
* https://www.jesusninoc.com/07/05/interrumpir-un-hilo-en-kotlin/
#### Uso de coroutines
* https://www.jesusninoc.com/07/02/ejecucion-de-coroutines-en-kotlin-usando-runblocking/
#### Ejecución de tareas con y sin hilos en Python
* https://www.jesusninoc.com/08/25/ejecucion-de-tareas-con-y-sin-hilos-en-python/
#### Sincronización
* https://www.jesusninoc.com/07/03/ejemplo-de-acceso-sincronizado-a-un-contador-en-kotlin-utilizando-corutinas/
#### Tablas de multiplicar con hilos
* https://www.jesusninoc.com/07/03/tablas-de-multiplicar-con-hilos-en-kotlin/
#### Tablas de multiplicar utilizando coroutines en Kotlin
* https://www.jesusninoc.com/07/04/tablas-de-multiplicar-utilizando-coroutines-en-kotlin/
