## Programación multiproceso:
 -	Ejecutables. Procesos. Servicios.
 -	Estados de un proceso.
 -	Hilos.
 -	Programación concurrente.
 -	Programación paralela y distribuida.
 -	Comunicación entre procesos.
 -	Gestión de procesos.
 -	Sincronización entre procesos.a
 -	Programación de aplicaciones multiproceso.

### Teoría de procesos
* https://www.jesusninoc.com/12/14/programacion-multiproceso-programacion-de-servicios-y-procesos/
* https://www.jesusninoc.com/07/31/programacion-de-servicios-y-procesos-en-python/#1_Programas_y_procesos

### Conceptos
- Repaso de conceptos para manejar las shells (instalar Ubuntu Server)
- SSH, conexión de red que permita acceder
- Rutas
- Path y Classpath https://docs.oracle.com/javase/tutorial/essential/environment/paths.html
- Pasar parámetros en scripts (PowerShell) https://www.jesusninoc.com/02/17/pasar-parametros-en-scripts-de-powershell/
- Pasar parámetros en scripts (Bash) https://www.jesusninoc.com/02/17/pasar-parametros-en-scripts-de-bash/
- Compilar y ejecutar
- Procesos en Linux https://github.com/jesusninoc/ClasesPSP/blob/master/2022-10-03.md#procesos-en-linux-1
- Ejecutar dos comandos
- Almacenar la ejecución de un comando
- Multiproceso
- BCP
- Process status
- Estados de un proceso
- System
- Funciones
- Creación y ejecución de procesos
- Padre crear hijo
- Comunicación entre procesos: para capturar y leer la salida generada por el comando ping, debemos acceder al flujo de entrada (inputStream) del proceso. Esto puede parecer confuso, pero en este caso, el flujo de entrada (inputStream) del proceso se utiliza para leer los datos que provienen de la salida generada por el comando.
- Descriptores https://www.jesusninoc.com/02/27/crear-y-utilizar-una-tuberia-sin-nombre-en-linux/
- Pipes sin nombre https://www.jesusninoc.com/03/02/comunicar-dos-procesos-usando-pipes-sin-nombre-en-python/
- Pipes con nombre https://www.jesusninoc.com/03/03/comunicar-dos-procesos-usando-pipes-con-nombre-en-python/
- Sincronizar procesos
- Señales
- Creación procesos 
- Programación concurrente
- Programación paralela
- Memorias compartidas
  - https://www.jesusninoc.com/06/14/conocer-el-tamano-expresado-en-bytes-de-un-tipo-no-administrado-mediante-la-clase-marshal-en-powershell/
  - https://www.jesusninoc.com/06/29/obtener-el-valor-de-una-variable-utilizando-otra-variable-mediante-la-direccion-del-primer-caracter-de-la-cadena-no-administrada-en-powershell-utilizando-la-clase-marshal/
  - https://www.jesusninoc.com/06/29/obtener-valores-de-la-memoria-en-powershell-utilizando-la-clase-marshal/
  - https://www.jesusninoc.com/06/30/copia-datos-de-una-matriz-de-caracteres-administrada-a-un-puntero-de-memoria-no-administrada-desde-powershell-utilizando-la-clase-marshal-funcionamiento-inseguro/
  - https://www.jesusninoc.com/06/14/ver-credenciales-almacenados-mediante-la-clase-marshal-en-una-variable-con-get-credential-desde-powershell/
- Memorias compartidas en Linux https://github.com/jesusninoc/ClasesPSP/blob/master/2022-10-17.md#memorias-compartidas
- Memorias compartidas en Python https://www.jesusninoc.com/05/27/memoria-compartida-en-python-programa-que-crea-la-memoria-compartida-y-escribe-en-ella-y-otro-programa-para-leer-de-esa-memoria/
- Señales https://github.com/jesusninoc/ClasesPSP/blob/master/2022-10-17.md#se%C3%B1ales
- Semáforos
- Programación distribuida

### Ejercicios
#### Comunicar dos procesos
* https://www.jesusninoc.com/06/16/comunicar-dos-procesos-mediante-pipes-en-kotlin-comunicacion-interprocesos-ipc/
#### Comunicar dos procesos en Python
* https://www.jesusninoc.com/05/29/comunicar-dos-procesos-en-python-2/
#### Realizar una comunicación entre dos procesos
* https://www.jesusninoc.com/09/29/realizar-una-comunicacion-entre-dos-procesos-en-kotil-un-proceso-envia-informacion-a-otro-proceso-y-el-otro-proceso-responde/
#### Realizar una comunicación bidireccional entre el proceso padre y el hijo en Kotlin
* https://www.jesusninoc.com/10/13/realizar-una-comunicacion-bidireccional-entre-el-proceso-padre-y-el-hijo-en-kotlin/
#### Enviar un array desde el proceso padre al proceso hijo en Kotlin
* https://www.jesusninoc.com/10/13/enviar-un-array-desde-el-proceso-padre-al-proceso-hijo-en-kotlin/
#### Enviar un array desde el proceso hijo al proceso padre en Kotlin
* https://www.jesusninoc.com/10/13/enviar-un-array-desde-el-proceso-hijo-al-proceso-padre-en-kotlin/
#### Realizar una comunicación entre dos procesos en Python
* https://www.jesusninoc.com/05/29/realizar-una-comunicacion-entre-dos-procesos-en-python-un-proceso-envia-informacion-a-otro-proceso-y-el-otro-proceso-responde/
#### Simulación de un ataque Man-in-the-Middle (MitM) en Python
* https://www.jesusninoc.com/07/10/simulacion-de-un-ataque-man-in-the-middle-mitm/
#### Generador y ejecutor de código Python creado con la inteligencia artificial Gemini
* https://www.jesusninoc.com/08/19/generador-y-ejecutor-de-codigo-python-creado-con-la-inteligencia-artificial-gemini/
