## Programación multiproceso:
 -	Ejecutables. Procesos. Servicios.
 -	Estados de un proceso.
 -	Hilos.
 -	Programación concurrente.
 -	Programación paralela y distribuida.
 -	Comunicación entre procesos.
 -	Gestión de procesos.
 -	Sincronización entre procesos.
 -	Programación de aplicaciones multiproceso.

### Teoría de procesos
* https://www.jesusninoc.com/12/14/programacion-multiproceso-programacion-de-servicios-y-procesos/
* https://www.jesusninoc.com/07/31/programacion-de-servicios-y-procesos-en-python/#1_Programas_y_procesos

### Conceptos
- Repaso de conceptos para manejar las shells (instalar Ubuntu Server)
- SSH, conexión de red que permita acceder
- Rutas
- Path y Classpath https://docs.oracle.com/javase/tutorial/essential/environment/paths.html
- Pasar parámetros en scripts (PowerShell) https://www.jesusninoc.com/02/17/pasar-parametros-en-scripts-de-powershell/
- Pasar parámetros en scripts (Bash) https://www.jesusninoc.com/02/17/pasar-parametros-en-scripts-de-bash/
- Compilar y ejecutar
- Procesos en Linux https://github.com/jesusninoc/ClasesPSP/blob/master/2022-10-03.md#procesos-en-linux-1
- Ejecutar dos comandos
- Almacenar la ejecución de un comando
- Multiproceso
- BCP
- Process status
- Estados de un proceso
- System
- Funciones
- Creación y ejecución de procesos
- Padre crear hijo
- Comunicación entre procesos: para capturar y leer la salida generada por el comando ping, debemos acceder al flujo de entrada (inputStream) del proceso. Esto puede parecer confuso, pero en este caso, el flujo de entrada (inputStream) del proceso se utiliza para leer los datos que provienen de la salida generada por el comando.
- Descriptores https://www.jesusninoc.com/02/27/crear-y-utilizar-una-tuberia-sin-nombre-en-linux/
- Pipes sin nombre https://www.jesusninoc.com/03/02/comunicar-dos-procesos-usando-pipes-sin-nombre-en-python/
- Pipes con nombre https://www.jesusninoc.com/03/03/comunicar-dos-procesos-usando-pipes-con-nombre-en-python/
- Sincronizar procesos
- Señales
- Creación procesos 
- Programación concurrente
- Programación paralela
- Memorias compartidas
  - https://www.jesusninoc.com/06/14/conocer-el-tamano-expresado-en-bytes-de-un-tipo-no-administrado-mediante-la-clase-marshal-en-powershell/
  - https://www.jesusninoc.com/06/29/obtener-el-valor-de-una-variable-utilizando-otra-variable-mediante-la-direccion-del-primer-caracter-de-la-cadena-no-administrada-en-powershell-utilizando-la-clase-marshal/
  - https://www.jesusninoc.com/06/29/obtener-valores-de-la-memoria-en-powershell-utilizando-la-clase-marshal/
  - https://www.jesusninoc.com/06/30/copia-datos-de-una-matriz-de-caracteres-administrada-a-un-puntero-de-memoria-no-administrada-desde-powershell-utilizando-la-clase-marshal-funcionamiento-inseguro/
  - https://www.jesusninoc.com/06/14/ver-credenciales-almacenados-mediante-la-clase-marshal-en-una-variable-con-get-credential-desde-powershell/
- Memorias compartidas en Linux https://github.com/jesusninoc/ClasesPSP/blob/master/2022-10-17.md#memorias-compartidas
- Memorias compartidas en Python https://www.jesusninoc.com/05/27/memoria-compartida-en-python-programa-que-crea-la-memoria-compartida-y-escribe-en-ella-y-otro-programa-para-leer-de-esa-memoria/
- Señales https://github.com/jesusninoc/ClasesPSP/blob/master/2022-10-17.md#se%C3%B1ales
- Semáforos
- Programación distribuida

### Ejercicios
#### Comunicar dos procesos
* https://www.jesusninoc.com/06/16/comunicar-dos-procesos-mediante-pipes-en-kotlin-comunicacion-interprocesos-ipc/
#### Comunicar dos procesos en Python
* https://www.jesusninoc.com/05/29/comunicar-dos-procesos-en-python-2/
#### Realizar una comunicación entre dos procesos
* https://www.jesusninoc.com/09/29/realizar-una-comunicacion-entre-dos-procesos-en-kotil-un-proceso-envia-informacion-a-otro-proceso-y-el-otro-proceso-responde/
#### Realizar una comunicación bidireccional entre el proceso padre y el hijo en Kotlin
* https://www.jesusninoc.com/10/13/realizar-una-comunicacion-bidireccional-entre-el-proceso-padre-y-el-hijo-en-kotlin/
#### Enviar un array desde el proceso padre al proceso hijo en Kotlin
* https://www.jesusninoc.com/10/13/enviar-un-array-desde-el-proceso-padre-al-proceso-hijo-en-kotlin/
#### Enviar un array desde el proceso hijo al proceso padre en Kotlin
* https://www.jesusninoc.com/10/13/enviar-un-array-desde-el-proceso-hijo-al-proceso-padre-en-kotlin/
#### Realizar una comunicación entre dos procesos en Python
* https://www.jesusninoc.com/05/29/realizar-una-comunicacion-entre-dos-procesos-en-python-un-proceso-envia-informacion-a-otro-proceso-y-el-otro-proceso-responde/
#### Simulación de un ataque Man-in-the-Middle (MitM) en Python
* https://www.jesusninoc.com/07/10/simulacion-de-un-ataque-man-in-the-middle-mitm/
#### Generador y ejecutor de código Python creado con la inteligencia artificial Gemini
* https://www.jesusninoc.com/08/19/generador-y-ejecutor-de-codigo-python-creado-con-la-inteligencia-artificial-gemini/


--------------------------
--------------------------

## Programación multihilo:
 -	Recursos compartidos por los hilos.
 -	Estados de un hilo. Cambios de estado.
 -	Elementos relacionados con la programación de hilos. Librerías y clases.
 -	Gestión de hilos.
 -	Sincronización de hilos.
 -	Compartición de información entre hilos.
 -	Programación de aplicaciones multihilo.

### Teoría de hilos
* https://www.jesusninoc.com/12/15/programacion-multihilo-programacion-de-servicios-y-procesos/
* https://www.jesusninoc.com/07/31/programacion-de-servicios-y-procesos-en-python/#2_Programacion_de_hilos_en_Python

### Conceptos
- Hilos
- Estado
- Interrupción
- Coroutines
- Sincronización

### Ejercicios
#### Crear un hilo en Python con Flask
* https://www.jesusninoc.com/05/20/crear-un-hilo-en-python-con-flask/
#### Predicción concurrente de objetos en imágenes usando YOLO y hilos en Python
* https://www.jesusninoc.com/08/05/prediccion-concurrente-de-objetos-en-imagenes-usando-yolo-y-hilos-en-python/
#### Formas de crear hilos en Kotlin
* https://www.jesusninoc.com/07/02/formas-de-crear-hilos-en-kotlin/
#### Crear un hilo y esperar a que se ejecute completamente el hilo
* https://www.jesusninoc.com/07/02/crear-un-hilo-en-kotlin-y-esperar-a-que-finalice-la-ejecucion-del-hilo/
#### Carrera de tortuga y liebre
* https://www.jesusninoc.com/07/02/ejemplo-de-creacion-de-threads-en-kotlin-carrera-de-tortuga-y-liebre/
#### Carrera de tortuga y liebre (creando clases)
* https://www.jesusninoc.com/07/02/ejemplo-de-creacion-de-threads-en-kotlin-creando-clases-carrera-de-tortuga-y-liebre/
#### Crear un reloj sencillo en Kotlin mediante hilos
* https://www.jesusninoc.com/07/05/crear-un-reloj-sencillo-en-kotlin-mediante-hilos/
#### Ejecución concurrente
* https://www.jesusninoc.com/06/06/ejecucion-concurrente-de-hilos-en-kotlin/
#### Estados y prioridades de los hilos en Kotlin
* https://www.jesusninoc.com/07/05/estados-y-prioridades-de-los-hilos-en-kotlin/
#### Interrumpir un hilo en Kotlin
* https://www.jesusninoc.com/07/05/interrumpir-un-hilo-en-kotlin/
#### Uso de coroutines
* https://www.jesusninoc.com/07/02/ejecucion-de-coroutines-en-kotlin-usando-runblocking/
#### Ejecución de tareas con y sin hilos en Python
* https://www.jesusninoc.com/08/25/ejecucion-de-tareas-con-y-sin-hilos-en-python/
#### Sincronización
* https://www.jesusninoc.com/07/03/ejemplo-de-acceso-sincronizado-a-un-contador-en-kotlin-utilizando-corutinas/
#### Tablas de multiplicar con hilos
* https://www.jesusninoc.com/07/03/tablas-de-multiplicar-con-hilos-en-kotlin/
#### Tablas de multiplicar utilizando coroutines en Kotlin
* https://www.jesusninoc.com/07/04/tablas-de-multiplicar-utilizando-coroutines-en-kotlin/
#### Hilos en Python (con y sin sincronización)
* https://www.jesusninoc.com/09/07/hilos-de-python/
#### Aplicación de recordatorio en Kotlin con Timer
* https://www.jesusninoc.com/08/03/aplicacion-de-recordatorio-en-kotlin-con-timer/
#### Crear y administrar tareas concurrentes utilizando hilos en Kotlin
* https://www.jesusninoc.com/08/04/crear-y-administrar-tareas-concurrentes-utilizando-hilos-en-kotlin/
#### Productor-consumidor: Sincronización con colas en Kotlin
* https://www.jesusninoc.com/08/04/productor-consumidor-sincronizacion-con-colas-en-kotlin/
#### Productor-consumidor: Sincronización con colas en Python
* https://www.jesusninoc.com/08/04/productor-consumidor-sincronizacion-con-colas-en-python/
#### Productor-Consumidor en Kotlin utilizando java.util.concurrent
* https://www.jesusninoc.com/08/04/productor-consumidor-en-kotlin-utilizando-java-util-concurrent/
#### Simulación de acceso concurrente seguro a un archivo de registro
* https://www.jesusninoc.com/07/10/simulacion-de-acceso-concurrente-seguro-a-un-archivo-de-registro/
