## Programación multiproceso:
 -	Ejecutables. Procesos. Servicios.
 -	Estados de un proceso.
 -	Hilos.
 -	Programación concurrente.
 -	Programación paralela y distribuida.
 -	Comunicación entre procesos.
 -	Gestión de procesos.
 -	Sincronización entre procesos.
 -	Programación de aplicaciones multiproceso.

### Teoría de procesos
* https://www.jesusninoc.com/12/14/programacion-multiproceso-programacion-de-servicios-y-procesos/
* https://www.jesusninoc.com/07/31/programacion-de-servicios-y-procesos-en-python/#1_Programas_y_procesos

### Conceptos
- Función básica https://www.jesusninoc.com/07/05/crear-una-funcion-de-saludo-en-kotlin/
- Función main() en Kotlin https://www.jesusninoc.com/07/05/pasar-parametros-a-la-funcion-main-en-kotlin/
- Función main() en Python https://www.jesusninoc.com/09/10/pasar-parametros-en-python/
- Módulos en Python https://www.jesusninoc.com/09/02/modulos-en-python/
- Conceptos generales en Kotlin https://www.jesusninoc.com/07/02/conceptos-importantes-en-kotlin-relacionados-con-procesos-hilos-red-y-seguridad-son/
- Conceptos generales en Python https://www.jesusninoc.com/05/27/conceptos-importantes-en-python-relacionados-con-procesos-hilos-red-y-seguridad/
- Repaso de conceptos para manejar las shells (instalar Ubuntu Server)
- SSH, conexión de red que permita acceder
- Rutas
- Path y Classpath https://docs.oracle.com/javase/tutorial/essential/environment/paths.html
- Pasar parámetros en scripts (PowerShell) https://www.jesusninoc.com/02/17/pasar-parametros-en-scripts-de-powershell/
- Pasar parámetros en scripts (Bash) https://www.jesusninoc.com/02/17/pasar-parametros-en-scripts-de-bash/
- Compilar y ejecutar
- Procesos en Linux https://github.com/jesusninoc/ClasesPSP/blob/master/2022-10-03.md#procesos-en-linux-1
- Ejecutar dos comandos
- Almacenar la ejecución de un comando
- Multiproceso
- BCP
- Process status
- Estados de un proceso
- System
- Funciones
- Creación y ejecución de procesos
- Padre crear hijo
- Comunicación entre procesos: para capturar y leer la salida generada por el comando ping, debemos acceder al flujo de entrada (inputStream) del proceso. Esto puede parecer confuso, pero en este caso, el flujo de entrada (inputStream) del proceso se utiliza para leer los datos que provienen de la salida generada por el comando.
- Descriptores https://www.jesusninoc.com/02/27/crear-y-utilizar-una-tuberia-sin-nombre-en-linux/
- Pipes sin nombre https://www.jesusninoc.com/03/02/comunicar-dos-procesos-usando-pipes-sin-nombre-en-python/
- Pipes con nombre https://www.jesusninoc.com/03/03/comunicar-dos-procesos-usando-pipes-con-nombre-en-python/
- Sincronizar procesos
- Señales
- Creación procesos 
- Programación concurrente
- Programación paralela
- Memorias compartidas
  - https://www.jesusninoc.com/06/14/conocer-el-tamano-expresado-en-bytes-de-un-tipo-no-administrado-mediante-la-clase-marshal-en-powershell/
  - https://www.jesusninoc.com/06/29/obtener-el-valor-de-una-variable-utilizando-otra-variable-mediante-la-direccion-del-primer-caracter-de-la-cadena-no-administrada-en-powershell-utilizando-la-clase-marshal/
  - https://www.jesusninoc.com/06/29/obtener-valores-de-la-memoria-en-powershell-utilizando-la-clase-marshal/
  - https://www.jesusninoc.com/06/30/copia-datos-de-una-matriz-de-caracteres-administrada-a-un-puntero-de-memoria-no-administrada-desde-powershell-utilizando-la-clase-marshal-funcionamiento-inseguro/
  - https://www.jesusninoc.com/06/14/ver-credenciales-almacenados-mediante-la-clase-marshal-en-una-variable-con-get-credential-desde-powershell/
- Memorias compartidas en Linux https://github.com/jesusninoc/ClasesPSP/blob/master/2022-10-17.md#memorias-compartidas
- Memorias compartidas en Python https://www.jesusninoc.com/05/27/memoria-compartida-en-python-programa-que-crea-la-memoria-compartida-y-escribe-en-ella-y-otro-programa-para-leer-de-esa-memoria/
- Señales https://github.com/jesusninoc/ClasesPSP/blob/master/2022-10-17.md#se%C3%B1ales
- Semáforos
- Programación distribuida

### Ejercicios
#### Programación multiproceso en Python
* https://www.jesusninoc.com/07/09/programacion-multiproceso-en-python/
#### Lanzar un programa en Kotlin
* https://www.jesusninoc.com/03/02/lanzar-un-programa-en-kotlin/
#### Lanzar un comando en Python con Flask
* https://www.jesusninoc.com/05/20/lanzar-un-comando-en-python-con-flask/
#### Enviar paquetes de desasociación con Aireplay-ng a un cliente que actualmente está asociado con un punto de acceso en Linux desde Python
* https://www.jesusninoc.com/09/30/enviar-paquetes-de-desasociacion-con-aireplay-ng-a-un-cliente-que-actualmente-esta-asociado-con-un-punto-de-acceso-en-linux-desde-python/
#### Ejecutar un comando de Windows y almacenar la salida en un archivo en Kotlin
* https://www.jesusninoc.com/06/19/ejecutar-un-comando-de-windows-y-almacenar-la-salida-en-un-archivo-en-kotlin/
#### Ejercicio: llamar desde Kotlin a un proceso en Linux con un script en Bash
* https://www.jesusninoc.com/06/19/ejercicio-llamar-desde-kotlin-a-un-proceso-en-linux-con-un-script-en-bash/
#### Ejecutar un script desde PowerShell
* https://www.jesusninoc.com/02/17/pasar-parametros-en-scripts-de-powershell/
#### Lanzar programa que ejecute el comando ping en Python con Flask
* https://www.jesusninoc.com/05/20/lanzar-programa-que-ejecute-el-comando-ping-en-python-con-flask/
#### Lanzar programa que ejecute un ping dos veces en Kotlin
* https://www.jesusninoc.com/06/19/lanzar-programa-que-ejecute-un-ping-dos-veces-en-kotlin/
#### Obtener información del proceso padre e hijo en Python con Flask
* https://www.jesusninoc.com/05/20/obtener-informacion-del-proceso-padre-e-hijo-en-python-con-flask/
