## Programación de comunicaciones en red:
 -	Comunicación entre aplicaciones.
 -	Roles cliente y servidor.
 -	Elementos de programación de aplicaciones en red. Librerías.
 -	Sockets.
 -	Creación de sockets.
 -	Enlazado y establecimiento de conexiones.
 -	Utilización de sockets para la transmisión y recepción de información.
 -	Programación de aplicaciones cliente y servidor.
 -	Utilización de hilos en la programación de aplicaciones en red.

### Teoría de redes
* https://www.jesusninoc.com/12/16/programacion-de-comunicaciones-en-red-programacion-de-servicios-y-procesos/
* https://www.jesusninoc.com/11/13/cmdlets-for-tcpip-model-layers/

### Conceptos
- Peticiones a servidores (GET, POST, fuerza bruta)
- URL
- URL (GET y POST)
- Servicios (bombillas)
- Scraping
- Fuerza bruta https://github.com/jesusninoc/Seguridad/tree/master/GetPost
- Conexión TCP/IP entre distintos sistemas
- Proyecto de conexión remota
- Sockets TCP y UDP
- Serializar https://www.jesusninoc.com/07/05/serializar-y-deserializar-un-objeto-almacenado-en-un-fichero-en-kotlin/
- Serializar JSON https://www.jesusninoc.com/07/05/serializar-y-deserializar-ficheros-json-con-gson-en-kotlin/

### Ejercicios
#### MulticastSocket en Kotlin
* https://www.jesusninoc.com/07/07/multicastsocket-en-kotlin/
#### Realizar una comunicación multicast entre un código en Android Studio y otro en IntelliJ IDEA
* https://www.jesusninoc.com/12/12/realizar-una-comunicacion-multicast-entre-un-codigo-en-android-studio-y-otro-en-intellij-idea/
#### Enviar un mensaje TCP con Kotlin desde una aplicación en Android Studio a un servidor en IntelliJ IDEA
* https://www.jesusninoc.com/11/27/enviar-un-mensaje-tcp-con-kotlin-desde-una-aplicacion-en-android-studio-a-un-servidor-en-intellij-idea/
#### Enviar la posición del cursor mediante TCP con Kotlin desde una aplicación en Android Studio a un servidor en IntelliJ IDEA
* https://www.jesusninoc.com/11/27/enviar-la-posicion-del-raton-mediante-tcp-con-kotlin-desde-una-aplicacion-en-android-studio-a-un-servidor-en-intellij-idea/
#### Mover el ratón remotamente mediante TCP con Kotlin desde una aplicación en Android Studio a un servidor en IntelliJ IDEA
* https://www.jesusninoc.com/11/28/mover-el-raton-remotamente-mediante-tcp-con-kotlin-desde-una-aplicacion-en-android-studio-a-un-servidor-en-intellij-idea/
#### Crear un API muy simple con Kotlin
* https://www.jesusninoc.com/12/11/crear-un-api-muy-simple-con-kotlin/
#### Crear un API muy simple con Kotlin que devuelve un contenido en formato JSON
* https://www.jesusninoc.com/12/11/crear-un-api-muy-simple-con-kotlin-que-devuelve-un-contenido-en-formato-json/

### Proyecto conexión remota
* https://www.jesusninoc.com/12/26/convertir-la-entrada-de-microfono-a-texto/
* https://www.jesusninoc.com/10/30/transmitir-una-captura-de-pantalla-entre-un-servidor-y-un-cliente-desde-powershell-sockets-tcp/
* https://www.jesusninoc.com/10/30/transmitir-una-captura-de-pantalla-entre-un-servidor-y-un-cliente-y-mostrarla-en-un-formulario-desde-powershell-sockets-tcp/
* https://www.jesusninoc.com/10/30/transmitir-una-captura-de-pantalla-entre-un-servidor-y-un-cliente-y-mostrarla-cada-dos-segundos-en-un-formulario-desde-powershell-sockets-tcp/
* https://www.jesusninoc.com/10/30/realizar-una-comunicacion-bidireccional-entre-un-cliente-y-un-servidor-mediante-tcp-desde-powershell-en-windows/
* https://www.jesusninoc.com/02/01/automatizar-tareas/
* https://www.jesusninoc.com/03/01/mover-el-raton-a-las-posiciones-que-estan-guardadas-en-un-fichero/
* https://www.jesusninoc.com/11/19/hacer-clic-en-una-posicion-de-la-pantalla-con-powershell/
* https://www.jesusninoc.com/02/02/realizar-captura-de-pantalla-y-dividir-en-partes-la-captura/
* https://www.jesusninoc.com/07/06/send-the-cursors-position-between-client-and-server-sockets-udp/
* https://www.jesusninoc.com/07/10/transfer-image-between-server-and-client-sockets-tcp/
* https://www.jesusninoc.com/11/07/transfer-images-between-server-and-client-sockets-tcp/

--------------
--------------

# Proyecto

## Temas a evaluar
- Programación concurrente
- Programación paralela
- Programación distribuida
- Procesos
- Hilos:
	- Crear, iniciar y finalizar hilos
	- Sincronizar
	- Varios hilos
	- Prioridad
- Red:
	- Utilización de servidores web (GET y POST)
	- Roles de cliente y de servidor
	- Librerías
	- Socket
		- Hilos
- Servicios en red:
	- Varios clientes concurrentes
	- Disponibilidad del servicio
	- Servicios de red capa Aplicación
- Seguridad:
	- Programación segura
	- Criptográfia
	- Políticas de seguridad para limitar y controlar el acceso de los usuarios
	- Roles
	- Asegurar información transmitida
	- Sockets seguros
