## Programación multihilo:
 -	Recursos compartidos por los hilos.
 -	Estados de un hilo. Cambios de estado.
 -	Elementos relacionados con la programación de hilos. Librerías y clases.
 -	Gestión de hilos.
 -	Sincronización de hilos.
 -	Compartición de información entre hilos.
 -	Programación de aplicaciones multihilo.

### Teoría de hilos
* https://www.jesusninoc.com/12/15/programacion-multihilo-programacion-de-servicios-y-procesos/

### Conceptos
- Hilos
- Estado
- Interrupción
- Coroutines
- Sincronización

### Ejercicios
#### Productor-consumidor: Sincronización con colas en Kotlin
* https://www.jesusninoc.com/08/04/productor-consumidor-sincronizacion-con-colas-en-kotlin/
#### Productor-Consumidor en Kotlin utilizando java.util.concurrent
* https://www.jesusninoc.com/08/04/productor-consumidor-en-kotlin-utilizando-java-util-concurrent/
#### Recursos compartidos por los hilos en Kotlin (gestión de transacciones bancarias concurrentes)
* https://www.jesusninoc.com/10/05/recursos-compartidos-por-los-hilos-en-kotlin-gestion-de-transacciones-bancarias-concurrentes/

-----------------

### Avanzado
- Abrir Google Chrome en Android https://www.jesusninoc.com/11/20/abrir-google-chrome-en-android/
- Ver las coordenadas GPS en un dispositivo Android utilizando composable https://www.jesusninoc.com/11/20/ver-las-coordenadas-gps-en-un-dispositivo-android-utilizando-composable/
- Crear un fichero en Android con Kotlin https://www.jesusninoc.com/11/20/crear-un-fichero-en-android-con-kotlin/
- Crear PDF con Kotlin https://www.jesusninoc.com/07/12/crear-un-pdf-con-kotlin/
- Crear un PDF con Kotlin en Android https://www.jesusninoc.com/11/20/crear-un-pdf-con-kotlin-en-android/
- Dibujar una casa dentro de un PDF con Kotlin https://www.jesusninoc.com/07/12/dibujar-una-casa-en-un-archivo-pdf-con-kotlin/
- Captura de posición táctil en Android con Jetpack Compose https://www.jesusninoc.com/11/22/captura-de-posicion-tactil-en-android-con-jetpack-compose/
- JavaFX https://www.jesusninoc.com/11/01/interfaces-de-usuario-graficas-javafx-en-kotlin/

-----------------
-----------------

# Programación de comunicaciones en red:
 -	Comunicación entre aplicaciones.
 -	Roles cliente y servidor.
 -	Elementos de programación de aplicaciones en red. Librerías.
 -	Sockets.
 -	Creación de sockets.
 -	Enlazado y establecimiento de conexiones.
 -	Utilización de sockets para la transmisión y recepción de información.
 -	Programación de aplicaciones cliente y servidor.
 -	Utilización de hilos en la programación de aplicaciones en red.

### Teoría de redes
* https://www.jesusninoc.com/12/16/programacion-de-comunicaciones-en-red-programacion-de-servicios-y-procesos/
* https://www.jesusninoc.com/11/13/cmdlets-for-tcpip-model-layers/

### Conceptos
- Peticiones a servidores (GET, POST, fuerza bruta)
- URL
- URL (GET y POST)
- Servicios (bombillas)
- Scraping
- Fuerza bruta https://github.com/jesusninoc/Seguridad/tree/master/GetPost
- Conexión TCP/IP entre distintos sistemas
- Proyecto de conexión remota
- Sockets TCP y UDP
- Serializar https://www.jesusninoc.com/07/05/serializar-y-deserializar-un-objeto-almacenado-en-un-fichero-en-kotlin/
- Serializar JSON https://www.jesusninoc.com/07/05/serializar-y-deserializar-ficheros-json-con-gson-en-kotlin/

### Ejercicios
#### Conectar con una URL en Kotlin
* https://www.jesusninoc.com/07/03/conectar-con-una-url-en-kotlin/
* https://www.jesusninoc.com/10/16/conectar-con-una-url-en-kotlin-explicacion-paso-a-paso/
#### Cómo conectar con una URL y cambiar el User-Agent
* https://www.jesusninoc.com/07/03/como-conectar-con-una-url-y-cambiar-el-user-agent/
#### Realizar una petición HTTP GET en Kotlin
* https://www.jesusninoc.com/10/27/realizar-una-peticion-get-en-kotlin/
#### Realizar una petición HTTP GET en Kotlin con OkHttp
* https://www.jesusninoc.com/10/27/realizar-una-solicitud-get-en-kotlin-utilizando-la-biblioteca-okhttp/
#### Realizar peticiones GET desde Kotlin de forma masiva
* https://www.jesusninoc.com/10/27/realizar-peticiones-get-desde-kotlin-de-forma-masiva/
#### Realizar peticiones GET en Kotlin de forma masiva utilizando coroutines
* https://www.jesusninoc.com/10/27/realizar-peticiones-get-en-kotlin-de-forma-masiva-utilizando-coroutines/
#### Realizar una petición HTTP POST en Kotlin
* https://www.jesusninoc.com/07/03/realizar-una-peticion-http-post-en-kotlin/
#### Comprobar si un puerto TCP está abierto en Kotlin
* https://www.jesusninoc.com/07/04/comprobar-si-un-puerto-tcp-esta-abierto-en-kotlin/
#### Servidor y cliente TCP básicos en Kotlin
* https://www.jesusninoc.com/07/04/crear-un-servidor-y-un-cliente-en-kotlin/
#### Servidor y Cliente TCP en Kotlin utilizando clases distintas
* https://www.jesusninoc.com/07/04/servidor-y-cliente-tcp-en-kotlin-utilizando-clases-distintas/
#### Servidor y cliente UDP básicos en Kotlin
* https://www.jesusninoc.com/07/04/crear-un-servidor-y-un-cliente-udp-en-kotlin/
#### Enviar un mensaje UDP con una dirección IP falsa entre Kotlin y Python
* https://www.jesusninoc.com/10/27/enviar-un-mensaje-udp-con-una-direccion-ip-falsa-entre-kotlin-y-python/
#### Cliente y servidor para enviar objeto serializado por TCP en Kotlin (utilizando hilos)
* https://www.jesusninoc.com/07/05/cliente-y-servidor-para-enviar-objeto-serializado-por-tcp-en-kotlin-utilizando-hilos/
#### Enviar una imagen entre un cliente y un servidor utilizando sockets TCP en Kotlin 
* https://www.jesusninoc.com/07/06/enviar-una-imagen-entre-un-cliente-y-un-servidor-utilizando-sockets-tcp-en-kotlin/
#### MulticastSocket en Kotlin
* https://www.jesusninoc.com/07/07/multicastsocket-en-kotlin/
#### Enviar un mensaje TCP con Kotlin desde una aplicación en Android Studio a un servidor en IntelliJ IDEA
* https://www.jesusninoc.com/11/27/enviar-un-mensaje-tcp-con-kotlin-desde-una-aplicacion-en-android-studio-a-un-servidor-en-intellij-idea/
#### Enviar la posición del cursor mediante TCP con Kotlin desde una aplicación en Android Studio a un servidor en IntelliJ IDEA
* https://www.jesusninoc.com/11/27/enviar-la-posicion-del-raton-mediante-tcp-con-kotlin-desde-una-aplicacion-en-android-studio-a-un-servidor-en-intellij-idea/
#### Mover el ratón remotamente mediante TCP con Kotlin desde una aplicación en Android Studio a un servidor en IntelliJ IDEA
* https://www.jesusninoc.com/11/28/mover-el-raton-remotamente-mediante-tcp-con-kotlin-desde-una-aplicacion-en-android-studio-a-un-servidor-en-intellij-idea/

### Proyecto conexión remota
* https://www.jesusninoc.com/12/26/convertir-la-entrada-de-microfono-a-texto/
* https://www.jesusninoc.com/10/30/transmitir-una-captura-de-pantalla-entre-un-servidor-y-un-cliente-desde-powershell-sockets-tcp/
* https://www.jesusninoc.com/10/30/transmitir-una-captura-de-pantalla-entre-un-servidor-y-un-cliente-y-mostrarla-en-un-formulario-desde-powershell-sockets-tcp/
* https://www.jesusninoc.com/10/30/transmitir-una-captura-de-pantalla-entre-un-servidor-y-un-cliente-y-mostrarla-cada-dos-segundos-en-un-formulario-desde-powershell-sockets-tcp/
* https://www.jesusninoc.com/10/30/realizar-una-comunicacion-bidireccional-entre-un-cliente-y-un-servidor-mediante-tcp-desde-powershell-en-windows/
* https://www.jesusninoc.com/02/01/automatizar-tareas/
* https://www.jesusninoc.com/03/01/mover-el-raton-a-las-posiciones-que-estan-guardadas-en-un-fichero/
* https://www.jesusninoc.com/11/19/hacer-clic-en-una-posicion-de-la-pantalla-con-powershell/
* https://www.jesusninoc.com/02/02/realizar-captura-de-pantalla-y-dividir-en-partes-la-captura/
* https://www.jesusninoc.com/07/06/send-the-cursors-position-between-client-and-server-sockets-udp/
* https://www.jesusninoc.com/07/10/transfer-image-between-server-and-client-sockets-tcp/
* https://www.jesusninoc.com/11/07/transfer-images-between-server-and-client-sockets-tcp/

--------------
--------------

# Repaso
* https://www.jesusninoc.com/10/29/comunicacion-de-procesos-en-kotlin-el-padre-envia-al-hijo-una-palabra-y-el-hijo-le-indica-el-numero-de-letras-que-tiene-la-palabra/
* https://www.jesusninoc.com/10/29/comunicacion-de-hilos-en-kotlin-contar-el-numero-de-letras-de-varias-palabras/
* https://www.jesusninoc.com/10/30/contador-de-letras-en-palabras-utilizando-coroutines-en-kotlin/
* https://www.jesusninoc.com/10/29/comunicacion-utilizando-sockets-tcp-en-kotlin-contar-el-numero-de-letras-de-varias-palabras-que-manda-el-servidor-y-el-cliente-hace-la-operacion-de-contar/
* https://www.jesusninoc.com/10/29/comunicacion-utilizando-sockets-tcp-e-hilos-en-kotlin-contar-el-numero-de-letras-de-varias-palabras-que-manda-el-servidor-y-el-cliente-hace-la-operacion-de-contar/

---------------
---------------

# Proyecto primera evaluación

## Temas a evaluar
- Programación concurrente
- Programación paralela
- Programación distribuida
- Procesos
- Hilos:
	- Crear, iniciar y finalizar hilos
	- Sincronizar
	- Varios hilos
	- Prioridad
- Red:
	- Utilización de servidores web (GET y POST)
	- Roles de cliente y de servidor
	- Librerías
	- Socket
		- Hilos
- Servicios en red:
	- Varios clientes concurrentes
	- Disponibilidad del servicio
	- Servicios de red capa Aplicación
- Seguridad:
	- Programación segura
	- Criptográfia
	- Políticas de seguridad para limitar y controlar el acceso de los usuarios
	- Roles
	- Asegurar información transmitida
	- Sockets seguros
