## Programación multiproceso:
 -	Ejecutables. Procesos. Servicios.
 -	Estados de un proceso.
 -	Hilos.
 -	Programación concurrente.
 -	Programación paralela y distribuida.
 -	Comunicación entre procesos.
 -	Gestión de procesos.
 -	Sincronización entre procesos.
 -	Programación de aplicaciones multiproceso.

### Teoría de procesos
* https://www.jesusninoc.com/12/14/programacion-multiproceso-programacion-de-servicios-y-procesos/

### Conceptos
- Creación y ejecución de procesos
- Padre crear hijo
- Lllamadas al sistema https://github.com/jesusninoc/ClasesPSP/blob/master/2017-10-25.md
- Descriptores https://www.jesusninoc.com/02/27/crear-y-utilizar-una-tuberia-sin-nombre-en-linux/
- Pipes sin nombre
  - https://www.jesusninoc.com/03/02/comunicar-dos-procesos-usando-pipes-sin-nombre-en-python/
  - https://www.jesusninoc.com/02/27/crear-y-utilizar-una-tuberia-sin-nombre-en-linux/
- Pipes con nombre
  - https://www.jesusninoc.com/03/03/comunicar-dos-procesos-usando-pipes-con-nombre-en-python/
  - https://www.jesusninoc.com/02/27/crear-y-utilizar-una-tuberia-con-nombre-en-linux-fifo/
- Sincronizar procesos
- Señales (Linux)
  - http://www.yolinux.com/TUTORIALS/C++Signals.html
  - https://github.com/mememiguelo/PSP/blob/master/C/Otros/sincronizar-1.c
  - https://github.com/mememiguelo/PSP/blob/master/C/Otros/sincronizar.c
  - https://github.com/jesusninoc/ClasesPSP/blob/master/2022-10-17.md#se%C3%B1ales
- Creación procesos 
- Programación concurrente
- Comunicación entre procesos: para capturar y leer la salida generada por el comando ping, debemos acceder al flujo de entrada (inputStream) del proceso. Esto puede parecer confuso, pero en este caso, el flujo de entrada (inputStream) del proceso se utiliza para leer los datos que provienen de la salida generada por el comando.
  - https://www.jesusninoc.com/06/16/comunicar-dos-procesos-mediante-pipes-en-kotlin-comunicacion-interprocesos-ipc/
  - https://www.jesusninoc.com/09/25/comunicar-dos-procesos-en-kotlin-el-hijo-responde-al-padre/
- Programación paralela
- Memorias compartidas https://github.com/jesusninoc/ClasesPSP/blob/master/2022-10-17.md#memorias-compartidas
- Semáforos
- Programación distribuida

-----------------

### Repaso
- Función básica https://www.jesusninoc.com/07/05/crear-una-funcion-de-saludo-en-kotlin/
- Función main() https://www.jesusninoc.com/07/05/pasar-parametros-a-la-funcion-main-en-kotlin/
- Conceptos generales https://www.jesusninoc.com/07/02/conceptos-importantes-en-kotlin-relacionados-con-procesos-hilos-red-y-seguridad-son/
- Path y Classpath https://docs.oracle.com/javase/tutorial/essential/environment/paths.html
- Compilar y ejecutar
- Lanzar un programa en Kotlin
   - https://www.jesusninoc.com/03/02/lanzar-un-programa-en-kotlin/
   - https://www.jesusninoc.com/06/06/lanzar-un-programa-en-kotlin-2/
- Ejecutar un comando de Windows y almacenar la salida en un archivo en Kotlin
   - https://www.jesusninoc.com/06/19/ejecutar-un-comando-de-windows-y-almacenar-la-salida-en-un-archivo-en-kotlin/
-  Ejercicio: llamar desde Kotlin a un proceso en Linux con un script en Bash
   - https://www.jesusninoc.com/06/19/ejercicio-llamar-desde-kotlin-a-un-proceso-en-linux-con-un-script-en-bash/
-  Ejecutar un script desde PowerShell
   - https://www.jesusninoc.com/02/17/pasar-parametros-en-scripts-de-powershell/
-  Lanzar programa que ejecute ping en Kotlin
   - https://www.jesusninoc.com/06/19/lanzar-programa-que-ejecute-ping-en-kotlin/
-  Lanzar programa que ejecute un ping dos veces en Kotlin
   - https://www.jesusninoc.com/06/19/lanzar-programa-que-ejecute-un-ping-dos-veces-en-kotlin/
-  Obtener información del proceso padre e hijo
   - https://www.jesusninoc.com/06/19/obtener-informacion-del-proceso-padre-e-hijo-en-kotlin/
-  Crear un proceso en Kotlin con la clase ProcessBuilder
   - https://www.jesusninoc.com/06/19/crear-un-proceso-en-kotlin-con-la-clase-processbuilder/
-  Uso de waitFor() en procesos en Kotlin: espera a que un proceso finalice
   - https://www.jesusninoc.com/07/13/uso-de-waitfor-en-procesos-en-kotlin-espera-a-que-un-proceso-finalice/
- Crear un proceso en Kotlin con la clase Runtime
   - https://www.jesusninoc.com/06/19/crear-un-proceso-en-kotlin-con-la-clase-runtime/
- Comunicar dos procesos
   - https://www.jesusninoc.com/06/16/comunicar-dos-procesos-mediante-pipes-en-kotlin-comunicacion-interprocesos-ipc/
- Lanzar programa que ejecute ping en Kotlin
   - https://www.jesusninoc.com/06/19/lanzar-programa-que-ejecute-ping-en-kotlin/
- Crear un proceso en Kotlin con la clase Runtime
   - https://www.jesusninoc.com/06/19/crear-un-proceso-en-kotlin-con-la-clase-runtime/
- Comunicar dos procesos
   - https://www.jesusninoc.com/06/16/comunicar-dos-procesos-mediante-pipes-en-kotlin-comunicacion-interprocesos-ipc/
- Comunicación mediante un hilo con tuberías en Kotlin
   - https://www.jesusninoc.com/09/22/comunicacion-mediante-un-hilo-con-tuberias-en-kotlin/
