## Programación multiproceso:
 -	Ejecutables. Procesos. Servicios.
 -	Estados de un proceso.
 -	Hilos.
 -	Programación concurrente.
 -	Programación paralela y distribuida.
 -	Comunicación entre procesos.
 -	Gestión de procesos.
 -	Sincronización entre procesos.
 -	Programación de aplicaciones multiproceso.

### Teoría de procesos
* https://www.jesusninoc.com/12/14/programacion-multiproceso-programacion-de-servicios-y-procesos/

### Conceptos
- Ejecutar dos comandos y guardar la información
- Compilar
- Conceptos generales https://www.jesusninoc.com/07/02/conceptos-importantes-en-kotlin-relacionados-con-procesos-hilos-red-y-seguridad-son/
- Pasar parámetros en scripts (PowerShell) https://www.jesusninoc.com/02/17/pasar-parametros-en-scripts-de-powershell/
- Pasar parámetros en scripts (Bash) https://www.jesusninoc.com/02/17/pasar-parametros-en-scripts-de-bash/
- Repaso de conceptos para manejar las shells (instalar Ubuntu Server)
- SSH, conexión de red que permita acceder
- Rutas
- Procesos en Linux https://github.com/jesusninoc/ClasesPSP/blob/master/2022-10-03.md#procesos-en-linux-1
- Ejecutar dos comandos
- Almacenar la ejecución de un comando
- Multiproceso
- BCP
- Process status
- Estados de un proceso
- System
- Funciones
- Creación y ejecución de procesos
- Padre crear hijo
- Comunicación entre procesos: para capturar y leer la salida generada por el comando ping, debemos acceder al flujo de entrada (inputStream) del proceso. Esto puede parecer confuso, pero en este caso, el flujo de entrada (inputStream) del proceso se utiliza para leer los datos que provienen de la salida generada por el comando.
- Descriptores https://www.jesusninoc.com/02/27/crear-y-utilizar-una-tuberia-sin-nombre-en-linux/
- Pipes sin nombre https://www.jesusninoc.com/03/02/comunicar-dos-procesos-usando-pipes-sin-nombre-en-python/
- Pipes con nombre https://www.jesusninoc.com/03/03/comunicar-dos-procesos-usando-pipes-con-nombre-en-python/
- Sincronizar procesos
- Señales (Linux)
- Creación procesos 
- Programación concurrente
- Programación paralela
- Memorias compartidas https://github.com/jesusninoc/ClasesPSP/blob/master/2022-10-17.md#memorias-compartidas
- Señales https://github.com/jesusninoc/ClasesPSP/blob/master/2022-10-17.md#se%C3%B1ales
- Semáforos
- Programación distribuida

### Ejercicios
#### Lanzar un programa en Kotlin
* https://www.jesusninoc.com/03/02/lanzar-un-programa-en-kotlin/
* https://www.jesusninoc.com/06/06/lanzar-un-programa-en-kotlin-2/
#### Ejecutar un comando de Windows y almacenar la salida en un archivo en Kotlin
* https://www.jesusninoc.com/06/19/ejecutar-un-comando-de-windows-y-almacenar-la-salida-en-un-archivo-en-kotlin/
#### Ejercicio: llamar desde Kotlin a un proceso en Linux con un script en Bash
* https://www.jesusninoc.com/06/19/ejercicio-llamar-desde-kotlin-a-un-proceso-en-linux-con-un-script-en-bash/
#### Ejecutar un script desde PowerShell
* https://www.jesusninoc.com/02/17/pasar-parametros-en-scripts-de-powershell/
#### Lanzar programa que ejecute ping en Kotlin
* https://www.jesusninoc.com/06/19/lanzar-programa-que-ejecute-ping-en-kotlin/
#### Lanzar programa que ejecute un ping dos veces en Kotlin
* https://www.jesusninoc.com/06/19/lanzar-programa-que-ejecute-un-ping-dos-veces-en-kotlin/
#### Obtener información del proceso padre e hijo
* https://www.jesusninoc.com/06/19/obtener-informacion-del-proceso-padre-e-hijo-en-kotlin/
#### Crear un proceso en Kotlin con la clase ProcessBuilder
* https://www.jesusninoc.com/06/19/crear-un-proceso-en-kotlin-con-la-clase-processbuilder/
#### Uso de waitFor() en procesos en Kotlin: espera a que un proceso finalice
* https://www.jesusninoc.com/07/13/uso-de-waitfor-en-procesos-en-kotlin-espera-a-que-un-proceso-finalice/
#### Crear un proceso en Kotlin con la clase Runtime
* https://www.jesusninoc.com/06/19/crear-un-proceso-en-kotlin-con-la-clase-runtime/
#### Comunicar dos procesos
* https://www.jesusninoc.com/06/16/comunicar-dos-procesos-mediante-pipes-en-kotlin-comunicacion-interprocesos-ipc/
