## Programación multiproceso:
 -	Ejecutables. Procesos. Servicios.
 -	Estados de un proceso.
 -	Hilos.
 -	Programación concurrente.
 -	Programación paralela y distribuida.
 -	Comunicación entre procesos.
 -	Gestión de procesos.
 -	Sincronización entre procesos.
 -	Programación de aplicaciones multiproceso.

### Teoría de procesos
* https://www.jesusninoc.com/12/14/programacion-multiproceso-programacion-de-servicios-y-procesos/

### Conceptos
- Función básica https://www.jesusninoc.com/07/05/crear-una-funcion-de-saludo-en-kotlin/
- Función main() https://www.jesusninoc.com/07/05/pasar-parametros-a-la-funcion-main-en-kotlin/
- Conceptos generales https://www.jesusninoc.com/07/02/conceptos-importantes-en-kotlin-relacionados-con-procesos-hilos-red-y-seguridad-son/
- Repaso de conceptos para manejar las shells (instalar Ubuntu Server)
- SSH, conexión de red que permita acceder
- Rutas
- Path y Classpath https://docs.oracle.com/javase/tutorial/essential/environment/paths.html
- Pasar parámetros en scripts (PowerShell) https://www.jesusninoc.com/02/17/pasar-parametros-en-scripts-de-powershell/
- Pasar parámetros en scripts (Bash) https://www.jesusninoc.com/02/17/pasar-parametros-en-scripts-de-bash/
- Procesos en Linux https://github.com/jesusninoc/ClasesPSP/blob/master/2022-10-03.md#procesos-en-linux-1
- Ejecutar dos comandos
- Almacenar la ejecución de un comando
- Multiproceso
- BCP
- Process status
- Estados de un proceso
- System
- Funciones
- Creación y ejecución de procesos
- Padre crear hijo
- Comunicación entre procesos: para capturar y leer la salida generada por el comando ping, debemos acceder al flujo de entrada (inputStream) del proceso. Esto puede parecer confuso, pero en este caso, el flujo de entrada (inputStream) del proceso se utiliza para leer los datos que provienen de la salida generada por el comando.
- Descriptores https://www.jesusninoc.com/02/27/crear-y-utilizar-una-tuberia-sin-nombre-en-linux/
- Pipes sin nombre https://www.jesusninoc.com/03/02/comunicar-dos-procesos-usando-pipes-sin-nombre-en-python/
- Pipes con nombre https://www.jesusninoc.com/03/03/comunicar-dos-procesos-usando-pipes-con-nombre-en-python/
- Sincronizar procesos
- Señales
- Creación procesos 
- Programación concurrente
- Programación paralela
- Memorias compartidas https://github.com/jesusninoc/ClasesPSP/blob/master/2022-10-17.md#memorias-compartidas
- Señales https://github.com/jesusninoc/ClasesPSP/blob/master/2022-10-17.md#se%C3%B1ales
- Semáforos
- Programación distribuida

### Ejercicios
#### Lanzar un programa en Kotlin
* https://www.jesusninoc.com/03/02/lanzar-un-programa-en-kotlin/
* https://www.jesusninoc.com/06/06/lanzar-un-programa-en-kotlin-2/
#### Ejecutar un comando de Windows y almacenar la salida en un archivo en Kotlin
* https://www.jesusninoc.com/06/19/ejecutar-un-comando-de-windows-y-almacenar-la-salida-en-un-archivo-en-kotlin/
#### Ejercicio: llamar desde Kotlin a un proceso en Linux con un script en Bash
* https://www.jesusninoc.com/06/19/ejercicio-llamar-desde-kotlin-a-un-proceso-en-linux-con-un-script-en-bash/
#### Ejecutar un script desde PowerShell
* https://www.jesusninoc.com/02/17/pasar-parametros-en-scripts-de-powershell/
#### Lanzar programa que ejecute ping en Kotlin
* https://www.jesusninoc.com/06/19/lanzar-programa-que-ejecute-ping-en-kotlin/
#### Lanzar programa que ejecute un ping dos veces en Kotlin
* https://www.jesusninoc.com/06/19/lanzar-programa-que-ejecute-un-ping-dos-veces-en-kotlin/
#### Obtener información del proceso padre e hijo
* https://www.jesusninoc.com/06/19/obtener-informacion-del-proceso-padre-e-hijo-en-kotlin/
#### Crear un proceso en Kotlin con la clase ProcessBuilder
* https://www.jesusninoc.com/06/19/crear-un-proceso-en-kotlin-con-la-clase-processbuilder/
#### Uso de waitFor() en procesos en Kotlin: espera a que un proceso finalice
* https://www.jesusninoc.com/07/13/uso-de-waitfor-en-procesos-en-kotlin-espera-a-que-un-proceso-finalice/
#### Crear un proceso en Kotlin con la clase Runtime
* https://www.jesusninoc.com/06/19/crear-un-proceso-en-kotlin-con-la-clase-runtime/
#### Comunicar dos procesos
* https://www.jesusninoc.com/06/16/comunicar-dos-procesos-mediante-pipes-en-kotlin-comunicacion-interprocesos-ipc/
#### Realizar una comunicación entre dos procesos
* https://www.jesusninoc.com/09/29/realizar-una-comunicacion-entre-dos-procesos-en-kotil-un-proceso-envia-informacion-a-otro-proceso-y-el-otro-proceso-responde/

-----------------------

## Programación multihilo:
 -	Recursos compartidos por los hilos.
 -	Estados de un hilo. Cambios de estado.
 -	Elementos relacionados con la programación de hilos. Librerías y clases.
 -	Gestión de hilos.
 -	Sincronización de hilos.
 -	Compartición de información entre hilos.
 -	Programación de aplicaciones multihilo.

### Teoría de hilos
* https://www.jesusninoc.com/12/15/programacion-multihilo-programacion-de-servicios-y-procesos/

### Conceptos
- Hilos
- Estado
- Interrupción
- Coroutines
- Sincronización

### Ejercicios
#### Crear un hilo
* https://www.jesusninoc.com/06/06/crear-un-hilo-en-kotlin/
#### Formas de crear hilos en Kotlin
* https://www.jesusninoc.com/07/02/formas-de-crear-hilos-en-kotlin/
#### Crear un hilo y esperar a que se ejecute completamente el hilo
* https://www.jesusninoc.com/07/02/crear-un-hilo-en-kotlin-y-esperar-a-que-finalice-la-ejecucion-del-hilo/
#### Carrera de tortuga y liebre
* https://www.jesusninoc.com/07/02/ejemplo-de-creacion-de-threads-en-kotlin-carrera-de-tortuga-y-liebre/
#### Carrera de tortuga y liebre (creando clases)
* https://www.jesusninoc.com/07/02/ejemplo-de-creacion-de-threads-en-kotlin-creando-clases-carrera-de-tortuga-y-liebre/
#### Crear un reloj sencillo en Kotlin mediante hilos
* https://www.jesusninoc.com/07/05/crear-un-reloj-sencillo-en-kotlin-mediante-hilos/
#### Ejecución concurrente
* https://www.jesusninoc.com/06/06/ejecucion-concurrente-de-hilos-en-kotlin/
#### Estados y prioridades de los hilos en Kotlin
* https://www.jesusninoc.com/07/05/estados-y-prioridades-de-los-hilos-en-kotlin/
#### Interrumpir un hilo en Kotlin
* https://www.jesusninoc.com/07/05/interrumpir-un-hilo-en-kotlin/
#### Uso de coroutines
* https://www.jesusninoc.com/07/02/ejecucion-de-coroutines-en-kotlin-usando-runblocking/
#### Sincronización
* https://www.jesusninoc.com/07/03/ejemplo-de-acceso-sincronizado-a-un-contador-en-kotlin-utilizando-corutinas/
#### Tablas de multiplicar con hilos
* https://www.jesusninoc.com/07/03/tablas-de-multiplicar-con-hilos-en-kotlin/
#### Tablas de multiplicar utilizando coroutines en Kotlin
* https://www.jesusninoc.com/07/04/tablas-de-multiplicar-utilizando-coroutines-en-kotlin/
#### Aplicación de recordatorio en Kotlin con Timer
* https://www.jesusninoc.com/08/03/aplicacion-de-recordatorio-en-kotlin-con-timer/
#### Crear y administrar tareas concurrentes utilizando hilos en Kotlin
* https://www.jesusninoc.com/08/04/crear-y-administrar-tareas-concurrentes-utilizando-hilos-en-kotlin/
#### Productor-consumidor: Sincronización con colas en Kotlin
* https://www.jesusninoc.com/08/04/productor-consumidor-sincronizacion-con-colas-en-kotlin/
#### Productor-Consumidor en Kotlin utilizando java.util.concurrent
* https://www.jesusninoc.com/08/04/productor-consumidor-en-kotlin-utilizando-java-util-concurrent/

-----------------------

## Programación de comunicaciones en red:
 -	Comunicación entre aplicaciones.
 -	Roles cliente y servidor.
 -	Elementos de programación de aplicaciones en red. Librerías.
 -	Sockets.
 -	Creación de sockets.
 -	Enlazado y establecimiento de conexiones.
 -	Utilización de sockets para la transmisión y recepción de información.
 -	Programación de aplicaciones cliente y servidor.
 -	Utilización de hilos en la programación de aplicaciones en red.

### Teoría de redes
* https://www.jesusninoc.com/12/16/programacion-de-comunicaciones-en-red-programacion-de-servicios-y-procesos/

### Conceptos
- Peticiones a servidores (GET, POST, fuerza bruta)
- URL
- URL (GET y POST)
- Scraping
- Conexión TCP/IP entre distintos sistemas
- Proyecto de conexión remota
- Sockets TCP y UDP
- Serializar https://www.jesusninoc.com/07/05/serializar-y-deserializar-un-objeto-almacenado-en-un-fichero-en-kotlin/
- Serializar JSON https://www.jesusninoc.com/07/05/serializar-y-deserializar-ficheros-json-con-gson-en-kotlin/

### Ejercicios
#### Conectar con una URL en Kotlin
* https://www.jesusninoc.com/07/03/conectar-con-una-url-en-kotlin/
#### Cómo conectar con una URL y cambiar el User-Agent
* https://www.jesusninoc.com/07/03/como-conectar-con-una-url-y-cambiar-el-user-agent/
#### Realizar una petición HTTP POST en Kotlin
* https://www.jesusninoc.com/07/03/realizar-una-peticion-http-post-en-kotlin/
#### Comprobar si un puerto TCP está abierto en Kotlin
* https://www.jesusninoc.com/07/04/comprobar-si-un-puerto-tcp-esta-abierto-en-kotlin/
#### Servidor y cliente TCP básicos en Kotlin
* https://www.jesusninoc.com/07/04/crear-un-servidor-y-un-cliente-en-kotlin/
#### Servidor y Cliente TCP en Kotlin utilizando clases distintas
* https://www.jesusninoc.com/07/04/servidor-y-cliente-tcp-en-kotlin-utilizando-clases-distintas/
#### Servidor y cliente UDP básicos en Kotlin
* https://www.jesusninoc.com/07/04/crear-un-servidor-y-un-cliente-udp-en-kotlin/
#### Cliente y servidor para enviar objeto serializado por TCP en Kotlin (utilizando hilos)
* https://www.jesusninoc.com/07/05/cliente-y-servidor-para-enviar-objeto-serializado-por-tcp-en-kotlin-utilizando-hilos/
### Enviar una imagen entre un cliente y un servidor utilizando sockets TCP en Kotlin 
* https://www.jesusninoc.com/07/06/enviar-una-imagen-entre-un-cliente-y-un-servidor-utilizando-sockets-tcp-en-kotlin/
### MulticastSocket en Kotlin
* https://www.jesusninoc.com/07/07/multicastsocket-en-kotlin/

-----------------------

## Generación de servicios en red:
 -	Protocolos estándar de comunicación en red a nivel de aplicación (telnet, ftp, http, pop3, smtp, entre otros).
 -	Librerías de clases y componentes.
 -	Utilización de objetos predefinidos.
 -	Establecimiento y finalización de conexiones.
 -	Transmisión de información.
 -	Programación de aplicaciones cliente.
 - Programación de servidores.
 -	Implementación de comunicaciones simultáneas.

### Teoría de servicios en red
* https://www.jesusninoc.com/12/17/generacion-de-servicios-en-red-programacion-de-servicios-y-procesos/

### Conceptos

### Ejercicios

#### Conexión a un servidor FTP con Kotlin
* https://www.jesusninoc.com/07/30/conexion-a-un-servidor-ftp-con-kotlin/
#### Descargar archivos FTP desde Kotlin
* https://www.jesusninoc.com/07/30/descargar-archivos-ftp-desde-kotlin/
#### Subir un archivo a un FTP desde Kotlin
* https://www.jesusninoc.com/07/30/subir-archivo-a-ftp-desde-kotlin/
#### Realizar un resumen en SHA512 de un documento descargado por FTP en Kotlin
* https://www.jesusninoc.com/07/30/realizar-un-resumen-en-sha512-de-un-documento-descargado-por-ftp-en-kotlin/
#### Enviar correos electrónicos utilizando la biblioteca JavaMail desde Kotlin
* https://www.jesusninoc.com/07/31/enviar-correos-electronicos-utilizando-la-biblioteca-javamail-desde-kotlin/
#### Conectarse a un servidor SSH en Kotlin
* https://www.jesusninoc.com/11/01/conectarse-a-un-servidor-ssh-en-kotlin/
#### Realizar en Kotlin una suma mediante una interfaz que contiene los métodos que se ejecutarán de forma remota (RMI)
* https://www.jesusninoc.com/07/13/realizar-en-kotlin-una-suma-mediante-una-interfaz-que-contiene-los-metodos-que-se-ejecutaran-de-forma-remota-rmi/
#### Envío de formulario entre un cliente y un servidor mediante RMI en Kotlin
* https://www.jesusninoc.com/07/13/https-www-jesusninoc-com-07-13-envio-de-formulario-mediante-rmi-en-kotlin/
#### Envío de datos de un formulario entre cliente y servidor mediante RMI en JavaFX con Kotlin
* https://www.jesusninoc.com/07/13/envio-de-datos-de-un-formulario-entre-cliente-y-servidor-mediante-rmi-en-javafx-con-kotlin/
#### Leyendo y analizando un Archivo JSON en línea desde Kotlin
* https://www.jesusninoc.com/07/31/leyendo-y-analizando-un-archivo-json-en-linea-desde-kotlin/

-----------------------

## Utilización de técnicas de programación segura:
 -	Prácticas de programación segura.
 -	Criptografía de clave pública y clave privada.
 -	Principales aplicaciones de la criptografía.
 -	Protocolos criptográficos.
 -	Política de seguridad.
 -	Programación de mecanismos de control de acceso.
 -	Encriptación de información.
 -	Protocolos seguros de comunicaciones.
 -	Programación de aplicaciones con comunicaciones seguras.

### Teoría de programación segura
* https://www.jesusninoc.com/12/18/utilizacion-de-tecnicas-de-programacion-segura-programacion-de-servicios-y-procesos/

### Conceptos

### Ejercicios

#### Combinaciones de la primera fila del teclado en Kotlin
* https://www.jesusninoc.com/07/30/combinaciones-de-la-primera-fila-del-teclado-en-kotlin/
#### Mostrar propiedades (java.class.path", "java.home", "java.vendor", "java.version", "os.name", "os.version", "user.dir", "user.home", "user.name") utilizando y sin utilizar el gestor de seguridad en Kotlin
* https://www.jesusninoc.com/07/13/mostrar-propiedades-java-class-path-java-home-java-vendor-java-version-os-name-os-version-user-dir-user-home-user-name-utilizando-y-sin-utilizar-el-gestor-d/
#### Codificación y Decodificación en Base 64 en Java
* https://www.jesusninoc.com/07/12/codificacion-y-decodificacion-en-base-64-en-kotlin/
#### Obtención de listado de algoritmos hash disponibles en Kotlin
* https://www.jesusninoc.com/08/03/obtencion-de-listado-de-algoritmos-hash-disponibles-en-kotlin/
#### Hash SHA-512 en Kotlin
* https://www.jesusninoc.com/07/04/hash-sha-512-en-kotlin-utilizando-java-security/
* https://www.jesusninoc.com/07/07/generacion-de-resumenes-sha-512-en-kotlin/
#### Generar un resumen HMAC-MD5 utilizando Kotlin
* https://www.jesusninoc.com/07/11/generar-un-resumen-hmac-md5-utilizando-kotlin/
#### Cálculo de Hash SHA-512 en Kotlin con una semilla
* https://www.jesusninoc.com/07/12/calculo-de-hash-sha-512-en-kotlin-con-una-semilla/
#### Cifrado y descifrado simple de palabras en Kotlin
* https://www.jesusninoc.com/07/31/cifrado-y-descifrado-simple-de-palabras-en-kotlin/
#### Cifrado simétrico TDEA (Triple Data Encryption Algorithm) en Kotlin utilizando la biblioteca Java de javax.crypto
* https://www.jesusninoc.com/08/02/cifrado-simetrico-tdea-triple-data-encryption-algorithm-en-kotlin-utilizando-la-biblioteca-java-de-javax-crypto/
#### Cifrado simétrico AES (Advanced Encryption Standard) en Kotlin, utilizaremos la clase Cipher proporcionada por el paquete javax.crypto
* https://www.jesusninoc.com/08/02/cifrado-simetrico-aes-advanced-encryption-standard-en-kotlin-utilizaremos-la-clase-cipher-proporcionada-por-el-paquete-javax-crypto/
#### Almacenar claves privadas y públicas
* https://www.jesusninoc.com/06/16/almacenar-las-claves-privadas-y-publicas-en-un-archivo-en-kotlin/
#### Cifrar y descifrar utilizando clave pública
* https://www.jesusninoc.com/06/16/cifrar-y-descifrar-utilizando-clave-publica-en-kotlin/
#### Cifrar y descifrar con clave secreta que se ha transmitido mediante cifrado asimétrico
* https://www.jesusninoc.com/06/16/cifrar-y-descifrar-con-clave-clave-secreta-aes-que-se-ha-transmitido-mediante-cifrado-asimetrico-rsa-en-kotlin/
#### Socket SSL en Kotlin 
* https://www.jesusninoc.com/07/13/socket-ssl-en-kotlin/
