# Práctica final: enunciado del proyecto de la asignatura

- Realizar un proyecto sobre la temática que más interese al alumno teniendo en cuenta:
  - Procesos
  - Programación concurrente, multihilo en conexiones simultáneas
  - Login (hash)
  - Sockets seguros (certificado)
  - Seguridad

-------------------
-------------------

# Utilización de técnicas de programación segura:
 -	Prácticas de programación segura.
 -	Criptografía de clave pública y clave privada.
 -	Principales aplicaciones de la criptografía.
 -	Protocolos criptográficos.
 -	Política de seguridad.
 -	Programación de mecanismos de control de acceso.
 -	Encriptación de información.
 -	Protocolos seguros de comunicaciones.
 -	Programación de aplicaciones con comunicaciones seguras.

# Cifrar y descifrar con clave pública
* https://www.jesusninoc.com/02/05/cifrar-y-descifrar-con-rsa-desde-java-generando-clave-privada-y-clave-publica/

## Cifrar y descifrar con clave clave secreta AES que se ha transmitido mediante cifrado asimetrico RSA 
* https://www.jesusninoc.com/02/10/cifrar-y-descifrar-con-clave-clave-secreta-aes-que-se-ha-transmitido-mediante-cifrado-asimetrico-rsa-en-java/

## Almacenar la clave secreta en un fichero
* https://www.jesusninoc.com/02/05/almacenar-la-clave-secreta-generada-con-el-algoritmo-aes-en-un-fichero-en-java/

## Utilizar la clave secreta almacenada en un fichero para cifrar un documento PDF de nombre FICHERO.pdf

```Java
import java.io.*;
import java.security.*;
import javax.crypto.*;

public class Ejemplo13Cifra {
	public static void main(String[] args) {
		try {	
			//RECUPERAMOS CLAVE SECRETA DEL FICHERO
			ObjectInputStream oin = new ObjectInputStream(
					 new FileInputStream("Clave.secreta"));
	        Key clavesecreta = (Key) oin.readObject();
	        oin.close();	        
			//SE DEFINE EL OBJETO Cipher
			Cipher c = Cipher.getInstance("AES/ECB/PKCS5Padding");
			c.init(Cipher.ENCRYPT_MODE, clavesecreta);
			//FICHERO A CIFRAR
			FileInputStream filein = new FileInputStream("FICHERO.pdf");
			
			//OBJETO CipherOutputStream
			CipherOutputStream out = new CipherOutputStream(
					new FileOutputStream("FicheroPDF.Cifrado"), c);
			int tambloque = c.getBlockSize();
			byte[] bytes = new byte[tambloque];
			
			//LEEMOS BLOQUES DE BYTES DEL FICHERO PDF 
			//Y LO VAMOS ESCRIBIENDO AL CipherOutputStream
			int i = filein.read(bytes);		
			while (i != -1) {				
				out.write(bytes, 0, i);
				i = filein.read(bytes);
			}
			out.flush();
			out.close();
			filein.close(); 
			System.out.println("Fichero cifrado con clave secreta.");		
						
		} catch (Exception e) {
			e.printStackTrace();
		}
	}//main
}//.. Ejemplo13Cifra
```

## Leer y descifrar datos de un fichero cifrado leyendo la clave secreta de un fichero
```Java
import java.io.*;
import java.security.*;
import javax.crypto.*;
public class Ejemplo13Descifra {
	public static void main(String[] args) {
		try {
			//RECUPERAMOS CLAVE SECRETA DEL FICHERO
			ObjectInputStream oin = new ObjectInputStream(
					 new FileInputStream("Clave.secreta"));
	        Key clavesecreta = (Key) oin.readObject();
	        oin.close();	
	        //			
			Cipher c = Cipher.getInstance("AES/ECB/PKCS5Padding");
			c.init(Cipher.DECRYPT_MODE, clavesecreta);
			
			CipherInputStream in = new CipherInputStream(
			      new FileInputStream("FicheroPDF.Cifrado"), c);
			
			int tambloque = c.getBlockSize();
			byte[] bytes = new byte[tambloque];
			
			int i = in.read(bytes);		
			FileOutputStream fileout = new FileOutputStream("FICHEROdescifrado.pdf");
		
			while (i != -1)	{
			  fileout.write(bytes, 0, i);
			  i = in.read(bytes);	
			}		
			fileout.close();
			in.close(); 
			System.out.println("Fichero descifrado con clave secreta.");		
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}//main
}//.. Ejemplo13Descifra
```

----------------------

# Pasos para firmar un JAR y verificar que el fichero está firmado (utilizar un certificado creado anteriormente)

```
# Crear fichero JAR que contiene el documento a firmar utilizando la herramienta jar
jar cvf datos.jar datos.dat

# Generar las claves pública y privada (si no existen), utilizando el comando keytool -genkey
keytool -genkey -alias firmacontrato -keystore AlmacenClaves -keyalg rsa -storepass 1234567
keytool -list -keystore AlmacenClaves

# Firmar el fichero JAR, usando la herramienta jarsigner y la clave privada generada en el paso anterior
jarsigner.exe -keystore AlmacenClaves -signedjar datosfirmados.jar datos.jar firmaContrato

# Exportar el certificado de clave pública para que el receptor del documento autentique la firma del emisor, utilizando el comando keytool -export
keytool.exe -export -keystore AlmacenClaves -alias firmacontrato -file reta.cer

# Importar el certificado del clave
keytool.exe -import -alias reta -file reta.cer -keystore AlmacenReceptor

# Por último suministrar el fichero JAR firmado y el certificado al receptor
jarsigner.exe -verify -verbose -certs -keystore AlmacenReceptor datosfirmados.jar
```

----------------------

# Firma

## Firmar un mensaje con clave privada DSA (Digital Signature Algorithm)
* https://github.com/jesusninoc/PSP-2/blob/master/Ejemplos/src/seguridad/Ejemplo7.java
## Almacenar la clave pública y privada en disco en los ficheros Clave.publica y Clave.privada
* https://github.com/jesusninoc/PSP-2/blob/master/Ejemplos/src/seguridad/Ejemplo7Almacenar.java
## Generar una firma en un fichero a partir de la clave privada almacenada en un fichero. La firma se almacena en el fichero fichero.firma
* https://github.com/jesusninoc/PSP-2/blob/master/Ejemplos/src/seguridad/Ejemplo8.java
## Verificar la firma de un fichero con la clave pública
* https://github.com/jesusninoc/PSP-2/blob/master/Ejemplos/src/seguridad/Ejemplo9.java
## keytool - Key and Certificate Management Tool
https://docs.oracle.com/javase/7/docs/technotes/tools/solaris/keytool.html

----------------
----------------

# Utilización de técnicas de programación segura:
 -	Prácticas de programación segura.
 -	Criptografía de clave pública y clave privada.
 -	Principales aplicaciones de la criptografía.
 -	Protocolos criptográficos.
 -	Política de seguridad.
 -	Programación de mecanismos de control de acceso.
 -	Encriptación de información.
 -	Protocolos seguros de comunicaciones.
 -	Programación de aplicaciones con comunicaciones seguras.

# Analizar class
- JD-GUI
https://www.jesusninoc.com/02/10/jd-gui/
# Analizar apk y buscar datos en los ficheros
- Infected Android Games Spread Adware to More Than 4.5 Million Users
https://www.bleepingcomputer.com/news/security/infected-android-games-spread-adware-to-more-than-4-5-million-users/
- Descargar apk
https://apkpure.com/es/search?q=com.example
- Cómo utilizar Apktool
https://www.jesusninoc.com/2016/02/25/como-utilizar-apktool/
- Analizar permisos de un .apk
https://www.jesusninoc.com/2015/12/08/analizar-permisos-de-un-apk/
- ReverseAPK - Quickly Analyze And Reverse Engineer Android Packages
https://www.kitploit.com/2018/05/reverseapk-quickly-analyze-and-reverse.html

## Buscar información en los ficheros generados al utilizar Apktool
### Buscar la cadena "php"
```PowerShell
Get-ChildItem *.* -Recurse | % {gc $_ | Select-String "php"}
```
### Buscar direcciones IP
```PowerShell
Get-ChildItem *.* -Recurse | % {gc $_ | Select-String "\b\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}\b"}
```
### Buscar rutas HTTP, FTP
```PowerShell
Get-ChildItem *.* -Recurse | % {gc $_ | Select-String "\b(ht|f)tp(s?)[^ ]*\.[^ ]*(\/[^ ]*)*\b"}
```

-----------
-----------

# Utilización de técnicas de programación segura:
 -	Prácticas de programación segura.
 -	Criptografía de clave pública y clave privada.
 -	Principales aplicaciones de la criptografía.
 -	Protocolos criptográficos.
 -	Política de seguridad.
 -	Programación de mecanismos de control de acceso.
 -	Encriptación de información.
 -	Protocolos seguros de comunicaciones.
 -	Programación de aplicaciones con comunicaciones seguras.
 
 # PowerShell
* https://www.jesusninoc.com/02/17/ejercicios-de-seguridad-login-con-usuario-y-contrasena-que-introduce-el-usuario/
* https://www.jesusninoc.com/02/17/ejercicios-de-seguridad-hacer-un-login-en-el-que-el-password-esta-almacenado-en-sha512-en-un-fichero-y-el-nombre-del-usuario-tambien-esta-almacenado/
* https://www.jesusninoc.com/02/11/ejercicios-de-seguridad-realizar-una-comunicacion-udp-segura-utilizando-cryptographic-message-syntax/
* https://www.jesusninoc.com/02/11/ejercicios-de-seguridad-realizar-una-comunicacion-tcp-segura-utilizando-cryptographic-message-syntax/
* https://www.jesusninoc.com/01/15/ejercicios-de-seguridad-simular-el-funcionamiento-de-un-proxy-cache-mediante-una-conexion-udp-entre-un-cliente-y-un-servidor-que-solicitan-una-imagen-y-si-la-imagen-ya-se-ha-descargado-se-indica-en-un/
* https://www.jesusninoc.com/01/24/ejercicios-de-seguridad-simular-el-funcionamiento-de-una-vpn-desde-powershell/
* https://www.jesusninoc.com/02/17/ejercicios-de-seguridad-detectar-mediante-firmas-que-un-fichero-se-ha-infectado/
* https://www.jesusninoc.com/01/10/ejercicios-de-seguridad-practica-sobre-virus/
