# Utilización de técnicas de programación segura:
 -	Prácticas de programación segura.
 -	Criptografía de clave pública y clave privada.
 -	Principales aplicaciones de la criptografía.
 -	Protocolos criptográficos.
 -	Política de seguridad.
 -	Programación de mecanismos de control de acceso.
 -	Encriptación de información.
 -	Protocolos seguros de comunicaciones.
 -	Programación de aplicaciones con comunicaciones seguras.

--------------------

# Resumen

## Guardar un String junto con el resumen
* https://www.jesusninoc.com/02/06/guardar-un-texto-junto-con-el-resumen-hash-sha-en-java/

## Comprobar que el String no se ha dañado o manipulado
* https://www.jesusninoc.com/02/06/comprobar-que-un-texto-no-se-ha-danado-o-manipulado-en-java-verificando-el-hash/

## ¿Es seguro el resumen?

--------------------

# CCN-STIC-807 – Criptografía de empleo en el ENS
|Tipo de Algoritmo| Acreditados por el CCN|
|--|--
|Cifrado Simétrico|TDEA (Triple Data Encryption Algorithm)
||AES (Advanced Encryption Standard)
|Algoritmos Asimétricos|DSA (Digital Signature Algorithm)
||ECDSA (Elliptic Curve Digital Signature Algorithm)
||RSA (Criptosistema RSA)
||ECIES (Elliptic Curve Integrated Encryption Scheme)
|Intercambio de Clave|DH o DHKA (Diffie-Hellman Key Agreement)
||MQV (Menezes-Qu-Vanstone Key Agreement)
||ECDH (Elliptic Curve Diffie-Hellman)
||ECMQV (Elliptic Curve Menezes-Qu-Vanstone)
|Funciones resumen (Hash)|SHA-2 (Secure Hash Algorithm)
||HMAC (Hash Message Authentication Code )

----------------

# Cifrado
## Píldora formativa 27: ¿Qué es mejor, la criptografía simétrica o la asimétrica?
* https://www.youtube.com/watch?v=0qfOVm-dtcQ

## Cifrado simétrico
- TDEA (Triple Data Encryption Algorithm)
- AES (Advanced Encryption Standard)
	- https://www.jesusninoc.com/02/08/cifrar-y-descifrar-con-aes-desde-powershell/
	- https://www.jesusninoc.com/02/05/cifrar-y-descifrar-con-aes-desde-java-con-clave-aleatoria/
	- https://www.jesusninoc.com/02/05/cifrar-y-descifrar-con-aes-desde-java-con-clave-anadida/

### Cifrar y descifrar entre lenguajes
* https://www.jesusninoc.com/02/04/cifrar-desde-powershell-y-descifrar-desde-php/

## Algoritmos asimétricos
- DSA (Digital Signature Algorithm)
- ECDSA (Elliptic Curve Digital Signature Algorithm)
- RSA (Criptosistema RSA)
	- https://www.jesusninoc.com/02/05/cifrar-y-descifrar-con-rsa-desde-java-generando-clave-privada-y-clave-publica/
- ECIES (Elliptic Curve Integrated Encryption Scheme)

--------------------

# Ejemplos
## Cifrar y descrifrar con clave secreta

```Java
import java.security.Key;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;


public class Ejemplo10 {
	public static void main(String args[]) {
		try {
			//ALGORITMO DES
			KeyGenerator kg = KeyGenerator.getInstance("DES");
			Cipher c = Cipher.getInstance("DES/CBC/PKCS5Padding");
			Key key = kg.generateKey();
			
			c.init(Cipher.ENCRYPT_MODE, key);
			byte input[] = "Stand and unfold yourself".getBytes();
			byte encrypted[] = c.doFinal(input);
			byte iv[] = c.getIV();

			IvParameterSpec dps = new IvParameterSpec(iv);
			c.init(Cipher.DECRYPT_MODE, key, dps);
			byte output[] = c.doFinal(encrypted);
			System.out.println("The string was ");
			System.out.println(new String(output));
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		//ALGORITMO AES
		try {
			KeyGenerator kg = KeyGenerator.getInstance("AES");
			kg.init (128);
			SecretKey clave = kg.generateKey();
			
			Cipher c = Cipher.getInstance("AES/ECB/PKCS5Padding");
			c.init(Cipher.ENCRYPT_MODE, clave);
				
			//CIFRAMOS TEXTO
			byte textoPlano[] = "Esto es un Texto Plano".getBytes();
			byte textoCifrado[] = c.doFinal(textoPlano);
			System.out.println("Encriptado: "+ new String(textoCifrado));
			
		    //DESCIFRAMOS TEXTO					
			c.init(Cipher.DECRYPT_MODE, clave);		
			byte desencriptado[] = c.doFinal(textoCifrado);
			System.out.println("Desencriptado: "+ new String(desencriptado));
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}
}
```

---------------------
---------------------

# Utilización de técnicas de programación segura:
 -	Prácticas de programación segura.
 -	Criptografía de clave pública y clave privada.
 -	Principales aplicaciones de la criptografía.
 -	Protocolos criptográficos.
 -	Política de seguridad.
 -	Programación de mecanismos de control de acceso.
 -	Encriptación de información.
 -	Protocolos seguros de comunicaciones.
 -	Programación de aplicaciones con comunicaciones seguras.


# Comandos para Keytool
```
===================
EN EL SERVIDOR:
keytool -genkey -alias servidor  -keyalg RSA -keystore AlmacenSrv -storepass 1234567
keytool -exportcert -alias servidor  -keystore AlmacenSrv -storepass 1234567 -file CertificadoServ.cer
keytool -importcert -trustcacerts -alias servidor -file CertificadoServ.cer -keystore CliCertConfianza -storepass 1234567
===================
EJECUCIÓN EN EL SERVIDOR
java -Djavax.net.ssl.keyStore=AlmacenSrv -Djavax.net.ssl.keyStorePassword=1234567 ServidorSSL
===================
===================
EN EL CLIENTE:
keytool -genkey -alias cliente -keyalg RSA -keystore AlmacenCli -storepass clavecli
keytool -exportcert -alias cliente -keystore AlmacenCli -storepass clavecli -file CertificadoCli.cer
keytool -importcert -trustcacerts -alias cliente -file CertificadoCli.cer -keystore SrvCertConfianza -storepass cercli
===================
EJECUCIÓN CLIENTE:
java -Djavax.net.ssl.trustStore=CliCertConfianza -Djavax.net.ssl.trustStorePassword=cercli ClienteSSL
=====================
```

# Certificados SSL (sin propiedades JSSE)

## Ejemplo de conexión entre cliente-servidor SSL (sin propiedades JSSE)
### Servidor SSL
* https://www.jesusninoc.com/02/11/socket-ssl-en-java/
### Cliente SSL
* https://www.jesusninoc.com/02/11/socket-ssl-en-java/

-----------

# Certificados SSL (con propiedades JSSE)

## Propiedades JSSE
### Servidor
```
System.setProperty("javax.net.ssl.keyStore","AlmacenSrv2")
System.setProperty("javax.net.ssl.keyStorePassword","1234567")
```
### Cliente
```
System.setProperty("javax.net.ssl.trustStore","AlmacenSrv2")
System.setProperty("javax.net.ssl.trustStorePassword","1234567")
```

## Ejemplo de conexión entre cliente-servidor SSL (con propiedades JSSE)
### Servidor
```Java
import java.io.*;
import javax.net.ssl.*;
 
public class Server {
    public static void main(String[] arg) throws IOException {
        int puerto = 5556;
               
                System.setProperty("javax.net.ssl.keyStore","src/AlmacenSrv");
                System.setProperty("javax.net.ssl.keyStorePassword","1234567");
       
        SSLServerSocketFactory sfact = (SSLServerSocketFactory) SSLServerSocketFactory
                .getDefault();
        SSLServerSocket servidorSSL = (SSLServerSocket) sfact
                .createServerSocket(puerto);
        SSLSocket clienteConectado = null;
        DataInputStream flujoEntrada = null;//FLUJO DE ENTRADA DE CLIENTE
        DataOutputStream flujoSalida = null;//FLUJO DE SALIDA AL CLIENTE
       
        for (int i = 1; i < 5; i++) {
            System.out.println("Esperando al cliente " + i);
            clienteConectado = (SSLSocket) servidorSSL.accept();       
            flujoEntrada = new DataInputStream(clienteConectado.getInputStream());
 
            // EL CLIENTE ME ENVIA UN MENSAJE
            System.out.println("Recibiendo del CLIENTE: " + i + " \n\t"
                    + flujoEntrada.readUTF());
   
            flujoSalida = new DataOutputStream(clienteConectado.getOutputStream());
 
            // ENVIO UN SALUDO AL CLIENTE
            flujoSalida.writeUTF("Saludos al cliente del servidor");
        }
        // CERRAR STREAMS Y SOCKETS
        flujoEntrada.close();
        flujoSalida.close();
        clienteConectado.close();
        servidorSSL.close();
 
    }// main
}
```

### Cliente
```Java
import java.io.*;
import javax.net.ssl.*;
 
public class Cliente  {
    public static void main(String[] args) throws Exception {
        String Host = "localhost";
        int puerto = 5556;//puerto remoto
 
        // Propiedades JSSE)
        System.setProperty("javax.net.ssl.trustStore","src/AlmacenSrv");
        System.setProperty("javax.net.ssl.trustStorePassword","1234567");
 
        System.out.println("PROGRAMA CLIENTE INICIADO....");
 
        SSLSocketFactory sfact = (SSLSocketFactory) SSLSocketFactory.getDefault();
        SSLSocket Cliente  = (SSLSocket) sfact.createSocket(Host, puerto);
 
        // CREO FLUJO DE SALIDA AL SERVIDOR
        DataOutputStream flujoSalida = new DataOutputStream(Cliente.getOutputStream());
 
        // ENVIO UN SALUDO AL SERVIDOR
        flujoSalida.writeUTF("Saludos al SERVIDOR DESDE EL CLIENTE");
 
        // CREO FLUJO DE ENTRADA AL SERVIDOR
        DataInputStream flujoEntrada = new DataInputStream(Cliente.getInputStream());
 
        // EL servidor ME ENVIA UN MENSAJE
        System.out.println("Recibiendo del SERVIDOR: \n\t" + flujoEntrada.readUTF());
 
        // CERRAR STREAMS Y SOCKETS
        flujoEntrada.close();
        flujoSalida.close();
        Cliente.close();
    }// main
}//..ClienteSSLv
```

----------------------

# Socket SSL
## To Use keytool to Create a Server Certificate
https://docs.oracle.com/cd/E19798-01/821-1841/gjrgy/index.html
## Socket SSL con Java 
http://chuwiki.chuidiang.org/index.php?title=Socket_SSL_con_Java
## SSL/TLS for dummies part 3 – Understanding Certificate Authority
https://www.wst.space/ssl-part-3-certificate-authority/
