# Utilización de técnicas de programación segura:
 -	Prácticas de programación segura.
 -	Criptografía de clave pública y clave privada.
 -	Principales aplicaciones de la criptografía.
 -	Protocolos criptográficos.
 -	Política de seguridad.
 -	Programación de mecanismos de control de acceso.
 -	Encriptación de información.
 -	Protocolos seguros de comunicaciones.
 -	Programación de aplicaciones con comunicaciones seguras.

# Cifrar RSA
* https://www.jesusninoc.com/11/06/creates-a-new-self-signed-certificate/
* https://www.jesusninoc.com/11/10/encrypts-content-by-using-the-cryptographic-message-syntax-format/
* https://www.jesusninoc.com/11/12/decrypts-content-that-has-been-encrypted-by-using-the-cryptographic-message-syntax-format/
* https://www.jesusninoc.com/11/18/exports-a-certificate-to-a-personal-information-exchange-pfx-file/

# The Security Manager
https://docs.oracle.com/javase/tutorial/essential/environment/security.html

## Mostrar propiedades (java.class.path", "java.home", "java.vendor", "java.version", "os.name", "os.version", "user.dir", "user.home", "user.name") sin utilizar el gestor de seguridad
* https://www.jesusninoc.com/02/26/mostrar-propiedades-java-class-path-java-home-java-vendor-java-version-os-name-os-version-user-dir-user-home-user-name-utilizando-y-sin-utilizar-el-gestor-de-seguridad-en-java/
## Ejecutar desde JVM "The Security Manager"
* https://www.jesusninoc.com/02/26/mostrar-propiedades-java-class-path-java-home-java-vendor-java-version-os-name-os-version-user-dir-user-home-user-name-utilizando-y-sin-utilizar-el-gestor-de-seguridad-en-java/#Compilar_utilizando_el_gestor_de_seguridad
## Mostrar propiedades teniendo en cuenta "The Security Manager"
* https://www.jesusninoc.com/02/26/mostrar-propiedades-java-class-path-java-home-java-vendor-java-version-os-name-os-version-user-dir-user-home-user-name-utilizando-y-sin-utilizar-el-gestor-de-seguridad-en-java/#Anadir_la_propiedad_SecurityManager_al_codigo_y_compilarlo

## Ejemplo de conexión Servidor con "The Security Manager"
```Java
import java.io.*;
import java.net.*;

public class ejemplo1Servidor {
	public static void main(String[] arg) throws IOException {
		int numeroPuerto = 6000;// Puerto
		ServerSocket servidor = null;
        System.setSecurityManager(new SecurityManager());
		try {
		servidor = new ServerSocket(numeroPuerto);

		
		Socket clienteConectado = null;
		System.out.println("Esperando al cliente....."+servidor.getLocalPort());
		System.out.println("Esperando al cliente....."+servidor.getLocalSocketAddress());
		clienteConectado = servidor.accept();
	    System.out.println("Adios al cliente....."+clienteConectado.getPort());
	    System.out.println("Adios al cliente2....."+clienteConectado.getLocalPort());
		
		clienteConectado.close();
		servidor.close();
		} catch (Exception e) {
				System.err.println("ERROR=> " + e.toString());
			}

	}// main
}// fin
```

# Ficheros de políticas en Java
## Ejemplo crear un fichero
* https://www.jesusninoc.com/02/26/crear-y-compilar-un-codigo-que-escribe-en-un-fichero-con-la-propiedad-securitymanager-sin-un-fichero-policy-y-utilizando-un-fichero-policy-en-java/
### Fichero Politica2.policy
* https://www.jesusninoc.com/02/26/crear-y-compilar-un-codigo-que-escribe-en-un-fichero-con-la-propiedad-securitymanager-sin-un-fichero-policy-y-utilizando-un-fichero-policy-en-java/#Fichero_politicapolicy

## Ejemplo para aplicar permisos a sockets
```Java
import java.net.*;
public class Ejemplo3Servidor {
	public static void main(String[] arg) {
		int numeroPuerto = 6000;// Puerto
		ServerSocket servidor = null;
		
		//System.setProperty ("java.security.policy", 	"D:\\CAPIT5\\Politica4.policy");
        System.setSecurityManager(new SecurityManager());
		
		try {
		  servidor = new ServerSocket(numeroPuerto);		
		  System.out.println("Esperando al cliente.....");
		  Socket clienteConectado = servidor.accept();	    
	      System.out.println("Cliente conectado.");		
		  clienteConectado.close();
		  System.out.println("Cliente desconectado.");
		  servidor.close();
		} catch (Exception e) {
				System.err.println("ERROR=> " + e.toString());
		}
	}// main
}//..Ejemplo3Servidor
```
### Fichero Politica2.policy
```Java
grant {
  permission java.net.SocketPermission "localhost", "accept";
};
```

-------------
-------------

# Resumen

## Guardar un String junto con el resumen
* https://www.jesusninoc.com/02/06/guardar-un-texto-junto-con-el-resumen-hash-sha-en-java/

## Comprobar que el String no se ha dañado o manipulado
* https://www.jesusninoc.com/02/06/comprobar-que-un-texto-no-se-ha-danado-o-manipulado-en-java-verificando-el-hash/

## ¿Es seguro el resumen?

## Cifrar y descifrar entre lenguajes
* https://www.jesusninoc.com/02/04/cifrar-desde-powershell-y-descifrar-desde-php/

------------

# CCN-STIC-807 – Criptografía de empleo en el ENS
|Tipo de Algoritmo| Acreditados por el CCN|
|--|--
|Cifrado Simétrico|TDEA (Triple Data Encryption Algorithm)
||AES (Advanced Encryption Standard)
|Algoritmos Asimétricos|DSA (Digital Signature Algorithm)
||ECDSA (Elliptic Curve Digital Signature Algorithm)
||RSA (Criptosistema RSA)
||ECIES (Elliptic Curve Integrated Encryption Scheme)
|Intercambio de Clave|DH o DHKA (Diffie-Hellman Key Agreement)
||MQV (Menezes-Qu-Vanstone Key Agreement)
||ECDH (Elliptic Curve Diffie-Hellman)
||ECMQV (Elliptic Curve Menezes-Qu-Vanstone)
|Funciones resumen (Hash)|SHA-2 (Secure Hash Algorithm)
||HMAC (Hash Message Authentication Code )

------------

# Cifrado
## Píldora formativa 27: ¿Qué es mejor, la criptografía simétrica o la asimétrica?
* https://www.youtube.com/watch?v=0qfOVm-dtcQ

## Cifrado simétrico
- TDEA (Triple Data Encryption Algorithm)
- AES (Advanced Encryption Standard)
	- https://www.jesusninoc.com/02/08/cifrar-y-descifrar-con-aes-desde-powershell/
	- https://www.jesusninoc.com/02/05/cifrar-y-descifrar-con-aes-desde-java-con-clave-aleatoria/
	- https://www.jesusninoc.com/02/05/cifrar-y-descifrar-con-aes-desde-java-con-clave-anadida/

## Algoritmos asimétricos
- DSA (Digital Signature Algorithm)
- ECDSA (Elliptic Curve Digital Signature Algorithm)
- RSA (Criptosistema RSA)
	- https://www.jesusninoc.com/02/05/cifrar-y-descifrar-con-rsa-desde-java-generando-clave-privada-y-clave-publica/
- ECIES (Elliptic Curve Integrated Encryption Scheme)
