# Generación de servicios en red:
 -	Protocolos estándar de comunicación en red a nivel de aplicación (telnet, ftp, http, pop3, smtp, entre otros).
 -	Librerías de clases y componentes.
 -	Utilización de objetos predefinidos.
 -	Establecimiento y finalización de conexiones.
 -	Transmisión de información.
 -	Programación de aplicaciones cliente.
 - Programación de servidores.
 -	Implementación de comunicaciones simultáneas.

# Download Apache Commons Net
* https://commons.apache.org/proper/commons-net/download_net.cgi

# FTP

## Conexión a un servidor FTP
* https://github.com/javierinformatica/dam1/blob/master/Ejemplos/src/servicios/ClienteFTP2.java

## Descargar archivos FTP desde Java
* https://github.com/reikimitsu/dam2/blob/master/SeviciosProcesos/Tema%204/FTPserver/src/ftpclient/FTP_Descargafichero.java

## Listar archivos FTP desde Java
* https://github.com/reikimitsu/dam2/blob/master/SeviciosProcesos/Tema%204/FTPserver/src/ftpclient/FTP_listaarchivos.java

## Subir archivo a FTP desde Java
* https://github.com/reikimitsu/dam2/blob/master/SeviciosProcesos/Tema%204/FTPserver/src/ftpclient/FTP_subirarchivo.java

--------------------
--------------------

# Utilización de técnicas de programación segura:
 -	Prácticas de programación segura.
 -	Criptografía de clave pública y clave privada.
 -	Principales aplicaciones de la criptografía.
 -	Protocolos criptográficos.
 -	Política de seguridad.
 -	Programación de mecanismos de control de acceso.
 -	Encriptación de información.
 -	Protocolos seguros de comunicaciones.
 -	Programación de aplicaciones con comunicaciones seguras.

# Introducción a la criptografía
https://www.jesusninoc.com/2017/02/01/criptografia-en-powershell/

## Píldora formativa 2: ¿Qué es la criptografía?
https://www.youtube.com/watch?v=PDpMgx7avzA

## Píldora formativa 5: ¿Qué es la tríada CIA?
https://www.youtube.com/watch?v=KWAfVhy_GQ8

## Píldora formativa 6: ¿Ciframos, codificamos o encriptamos?
https://www.youtube.com/watch?v=77BrG2vRKss

# Codificar

## Base64
### Codificar y decodificar en Java
https://www.jesusninoc.com/12/16/codificar-y-decodificar-en-base64-en-java/
### Codificar en Base64 paso a paso con PowerShell
https://www.jesusninoc.com/2017/01/13/codificar-en-base64-paso-a-paso-con-powershell/
### Codificar un string en Base64
https://www.jesusninoc.com/2016/09/22/codificar-un-string-en-base64/
### Ejecutar en Java un cmdlet de PowerShell en Base64
https://www.jesusninoc.com/2018/02/10/ejecutar-en-java-un-cmdlet-de-powershell-en-base64/
### Datos URIs
https://developer.mozilla.org/es/docs/Web/HTTP/Basics_of_HTTP/Datos_URIs
### Bash Bunny Phishing Attack With Hamsters - Hak5 2306
https://www.youtube.com/watch?v=TYR2a2XoK3A
### Realizar una redirección con JavaScript utilizando Start-Process y Google Chrome
https://www.jesusninoc.com/2017/02/06/realizar-una-redireccion-con-javascript-utilizando-start-process-y-google-chrome-2/

----------

# Introducción a hash

## Realizar hashes parciales sobre un fichero
* https://www.jesusninoc.com/02/03/dividir-un-fichero-en-varios-ficheros-cada-linea-en-un-fichero-distinto/

## Realizar una función de hash sobre varios ficheros
* https://www.jesusninoc.com/2018/02/04/realizar-una-funcion-de-hash-sobre-varios-ficheros/

## Generar un resumen de un texto plano MD5
```Java
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.*;

public class Ejemplo04
{

    public static void main(String[] args)
    {
        MessageDigest md;
        try
        {
            md = MessageDigest.getInstance("MD5", Security.getProvider("SUN"));      //funcionaria si  lo quitamos
            //md = MessageDigest.getInstance("MD5");   
            String texto = "Esto es un texto plano.";   //string a capturar
            byte dataBytes[] = texto.getBytes();        //obtenemos los bytes
            md.update(dataBytes);                       //actualizamos el mesagediges
            byte resume[] = md.digest();                //Calcula el resumen
            // Información
            System.out.println("Original: " + texto);
            System.out.println("Número de Bytes: " + md.getDigestLength());
            System.out.println("Algoritmo: " + md.getAlgorithm());
            System.out.println("Mensaje resumen: " + new String(resume));
            System.out.println("Hexadecimal: " + Hexadecimal(resume));
            System.out.println(MessageDigest.isEqual(dataBytes, ("esto es un texto plano.").getBytes()));

            // Proveedor
            Provider proveedor = md.getProvider();
            System.out.println("Proveedor: " + proveedor.toString());
        } catch (NoSuchAlgorithmException e)
        {
            e.printStackTrace();
        }
    }

    static String Hexadecimal(byte[] resumen)
    {
        String hex = "";
        for (int i = 0; i < resumen.length; i++)
        {
            String h = Integer.toHexString(resumen[i] & 0xFF);
            if (h.length() == 1)
            {
                hex += "0";
            }
            hex += h;
        }
        return hex.toUpperCase();
    }
}
```

## Hash a password with SHA-512 in Java
* https://www.jesusninoc.com/02/02/hash-a-password-with-sha-512/

---------

# HMAC
En la criptografía, un código de autentificación de mensajes en clave-hash (HMAC) es una construcción específica para calcular un código de autentificación de mensaje (MAC) que implica una función hash criptográfica en combinación con una llave criptográfica secreta. Como cualquier MAC, puede ser utilizado para verificar simultáneamente la integridad de los datos y la autentificación de un mensaje. Cualquier función hash criptográfica, tales como MD5 o SHA-1, puede ser utilizada para el cálculo de un HMAC; el algoritmo MAC resultante se denomina HMAC-MD5 o HMAC-SHA1 en consecuencia. La fuerza criptográfica del HMAC depende de la potencia criptográfica de la función de hash subyacente, el tamaño de su salida de hash y el tamaño y calidad de la llave.

## Generar HMAC-SHA256 con PowerShell
https://www.jesusninoc.com/2018/02/18/generar-hmac-sha256-con-powershell/

## CCN-STIC-807 – Criptografía de empleo en el ENS
|Tipo de Algoritmo| Acreditados por el CCN|
|--|--
|Cifrado Simétrico|TDEA (Triple Data Encryption Algorithm)
||AES (Advanced Encryption Standard)
|Algoritmos Asimétricos|DSA (Digital Signature Algorithm)
||ECDSA (Elliptic Curve Digital Signature Algorithm)
||RSA (Criptosistema RSA)
||ECIES (Elliptic Curve Integrated Encryption Scheme)
|Intercambio de Clave|DH o DHKA (Diffie-Hellman Key Agreement)
||MQV (Menezes-Qu-Vanstone Key Agreement)
||ECDH (Elliptic Curve Diffie-Hellman)
||ECMQV (Elliptic Curve Menezes-Qu-Vanstone)
|Funciones resumen (Hash)|SHA-2 (Secure Hash Algorithm)
||HMAC (Hash Message Authentication Code )

## HASHES GENERATOR
https://www.onlinehashcrack.com/hash-generator.php

## Crack hashes in seconds
https://github.com/s0md3v/Hash-Buster

## Reverse hash (MD5/SHA1)
https://www.jesusninoc.com/2016/02/02/reverse-hash-md5-sha1/

## PoC para detectar colisión en SHA1 con PowerShell
http://www.jesusninoc.com/2017/02/24/poc-para-detectar-colision-en-sha1-con-powershell/

## Practical collision attack against SHA-1
https://isc.sans.edu/forums/diary/Practical+collision+attack+against+SHA1/22109/

## Cracking de contraseñas con hashcat
https://www.securityartwork.es/2017/02/15/cracking-contrasenas-hashcat/

------------------
------------------

# Práctica final: enunciado del proyecto de la asignatura

- Realizar un proyecto sobre la temática que más interese al alumno teniendo en cuenta:
  - Procesos
  - Programación concurrente, multihilo en conexiones simultáneas
  - Login (hash)
  - Sockets seguros (certificado)
  - Seguridad
  
------------

## Práctica sobre seguridad
* https://www.jesusninoc.com/01/22/capturar-las-teclas-que-se-pulsan-y-mostrarlas-en-powershell/
* https://www.jesusninoc.com/01/22/capturar-las-teclas-que-se-pulsan-desde-la-shell-de-powershell/
* https://www.jesusninoc.com/01/22/capturar-las-teclas-que-se-pulsan-desde-powershell-y-calcular-el-tiempo-que-se-tarda-en-pulsar-una-tecla-y-otra-despues/
* https://www.jesusninoc.com/01/22/capturar-las-teclas-que-se-pulsan-desde-powershell-y-calcular-el-tiempo-total-que-transcurre-desde-el-inicio-hasta-que-se-empezo-a-pulsar-la-primera-letra-y-se-siguen-pulsando-hasta-finalizar/
* https://www.jesusninoc.com/01/22/capturar-las-teclas-que-se-pulsan-desde-powershell-y-calcular-el-tiempo-total-en-segundos-que-transcurre-desde-el-inicio-hasta-que-se-empezo-a-pulsar-la-primera-letra-y-se-siguen-pulsando-hasta-finali/

## Recorrer FTP
#telegram #osint #recon #pentest #IoT #indexer #crawler #web #ftp 
* https://t.me/ohl7AeGah5uo8cho4nae9Eemaeyae3 … 
* https://t.me/xai7poozengee2Aen3poMookohthaZ … Common
* https://t.me/gohquooFee3duaNaeNuthushoh8di2 … HTTP
* https://t.me/aiWeipeighah7vufoHa0ieToipooYe … FTP
* https://t.me/ohl7AeGah5uo8cho4nae9Eemaeyae3 … Gopher

## TheDorks I : FTP PASSWORD
* https://r3dbird.blogspot.com/2019/01/thedorks-i-ftp-hacking-infoleak-y.html

-------------
-------------
