# Repaso String -> char
```Java
public class MyClass {
    public static void main(String args[]) {
      String a="1,2";
      char valor1 = a.split(",")[0].charAt(0);
      int resultado = valor1+2;

      System.out.println(valor1);
    }
}
```

-------------------

# Programación de comunicaciones en red:
 -	Comunicación entre aplicaciones.
 -	Roles cliente y servidor.
 -	Elementos de programación de aplicaciones en red. Librerías.
 -	Sockets.
 -	Creación de sockets.
 -	Enlazado y establecimiento de conexiones.
 -	Utilización de sockets para la transmisión y recepción de información.
 -	Programación de aplicaciones cliente y servidor.
 -	Utilización de hilos en la programación de aplicaciones en red.

# Sockets

## Servidor y cliente TCP básicos
https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejemplo6.java
https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejemplo6Cliente.java

## Server and client (Socket TCP)
* https://www.jesusninoc.com/10/11/server-and-client-sockets-tcp-2/
https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Servidor.java
https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Cliente.java

## Comprobar si un puerto TCP está abierto
https://www.jesusninoc.com/2012/10/10/comprobar-si-un-puerto-tcp-esta-abierto/

## Analizar direcciones IP para detectar puertos abiertos (versión 1)
https://www.jesusninoc.com/2015/07/02/analizar-direcciones-ip-para-detectar-puertos-abiertos-version-1/

## Analizar direcciones IP para detectar puertos abiertos (versión 2)
https://www.jesusninoc.com/2015/07/02/analizar-direcciones-ip-para-detectar-puertos-abiertos-version-2/

## Server and client (Datagram socket UDP)
https://www.jesusninoc.com/2012/10/13/server-and-client-datagram-socket-udp/
https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/ServidorUDP.java
https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/ClienteUDP.java

-------------------

# Conexión TCP/IP
## Crear una comunicación entre un cliente en PowerShell de Windows y un servidor en Bash de Linux utilizando TCP/IP
https://www.jesusninoc.com/2017/10/26/crear-una-comunicacion-entre-un-cliente-en-powershell-de-windows-y-un-servidor-en-bash-de-linux-utilizando-tcpip/

## Establecer una dirección IPv6 para el interfaz Wi-Fi con PowerShell
https://www.jesusninoc.com/11/03/establecer-una-direccion-ipv6-para-el-interfaz-wi-fi-con-powershell/

## Proyecto de conexión remota
* https://www.jesusninoc.com/12/26/convertir-la-entrada-de-microfono-a-texto/
* https://www.jesusninoc.com/10/30/transmitir-una-captura-de-pantalla-entre-un-servidor-y-un-cliente-desde-powershell-sockets-tcp/
* https://www.jesusninoc.com/10/30/transmitir-una-captura-de-pantalla-entre-un-servidor-y-un-cliente-y-mostrarla-en-un-formulario-desde-powershell-sockets-tcp/
* https://www.jesusninoc.com/10/30/transmitir-una-captura-de-pantalla-entre-un-servidor-y-un-cliente-y-mostrarla-cada-dos-segundos-en-un-formulario-desde-powershell-sockets-tcp/
* https://www.jesusninoc.com/10/30/realizar-una-comunicacion-bidireccional-entre-un-cliente-y-un-servidor-mediante-tcp-desde-powershell-en-windows/
* https://www.jesusninoc.com/02/01/automatizar-tareas/
* https://www.jesusninoc.com/03/01/mover-el-raton-a-las-posiciones-que-estan-guardadas-en-un-fichero/
* https://www.jesusninoc.com/11/19/hacer-clic-en-una-posicion-de-la-pantalla-con-powershell/
* https://www.jesusninoc.com/02/02/realizar-captura-de-pantalla-y-dividir-en-partes-la-captura/
* https://www.jesusninoc.com/07/06/send-the-cursors-position-between-client-and-server-sockets-udp/
* https://www.jesusninoc.com/07/10/transfer-image-between-server-and-client-sockets-tcp/
* https://www.jesusninoc.com/11/07/transfer-images-between-server-and-client-sockets-tcp/

-------------------

# Serializar y deserializar

## Serializar y deserializar un objeto almacenado en un fichero en Java
https://www.jesusninoc.com/2018/01/07/serializar-y-deserializar-un-objeto-almacenado-en-un-fichero-en-java/

## Serializar y deserializar contenido en un fichero en Java
https://www.jesusninoc.com/2018/01/05/serializar-y-deserializar-contenido-en-un-fichero-en-java/

## Enviar objeto serializado TCP
* https://github.com/reikimitsu/dam2/tree/master/SeviciosProcesos/Tema%204/AplicacionClienteServidor/src/aplicacionclienteservidor
* https://github.com/reikimitsu/dam2/blob/master/SeviciosProcesos/Tema%204/AplicacionClienteServidor/src/aplicacionclienteservidor/Persona.java
* https://github.com/reikimitsu/dam2/blob/master/SeviciosProcesos/Tema%204/AplicacionClienteServidor/src/aplicacionclienteservidor/ServidorObjeto.java
* https://github.com/reikimitsu/dam2/blob/master/SeviciosProcesos/Tema%204/AplicacionClienteServidor/src/aplicacionclienteservidor/ClienteObjeto.java

## Enviar objeto serializado UDP
```Java
Persona per = new Persona("Juan", 20);

// Convertir objeto a bytes
ByteArrayOutputStream bs= new ByteArrayOutputStream();
ObjectOutPutStream out= new ObjectOutPutStream(bs);
out.writeObject(persona);
out.close();
byte[] bytes= bs.toByteArray()

// Para convertitr los bytes recibidos por el datagrama en un objeto Persona
byte recibidos= new byte[1024];
DatagramPacket paqRecibido= new DatagramPacket(recibidos,recibidos.lenth);
socket.receive(paqRecibido)

// Bytes al objeto
ByteArrayInputStream bais= new ByteArrayInputStream (recibidos)
ObjectInputStream in= new ObjectInputStream(bais);
Persona persona= (Persona)in.readObject();
in.close();
```

## Enviar una imagen entre un cliente y un servidor con Java (Sockets TCP)
https://www.jesusninoc.com/2018/01/29/enviar-una-imagen-entre-un-cliente-y-un-servidor-con-java-sockets-tcp/

## Understanding Java deserialization
https://nytrosecurity.com/2018/05/30/understanding-java-deserialization/

## HPE iMC 7.3 - RMI Java Deserialization
https://www.exploit-db.com/exploits/43927/

## A Java serializer in JavaScript
https://github.com/mbechler/serjs

## Extraer datos de una imagen que está subida a un servidor mediante el reconocimiento óptico de caracteres y el análisis de imágenes con Java utilizando Computer Vision API de Microsoft Azure
https://www.jesusninoc.com/01/09/extraer-datos-de-imagenes-que-estan-subidas-a-un-servidor-mediante-el-reconocimiento-optico-de-caracteres-y-el-analisis-de-imagenes-con-java-utilizando-computer-vision-api-de-microsoft-azure/

-------------------

# Automatizar

## Automatizar la programación en Java

### Utilización de dll
https://www.jesusninoc.com/11/28/crear-compilar-y-ejecutar-una-dll-con-microsoft-visual-c-que-abre-notepad-desde-powershell/
### Crear, compilar y ejecutar una clase de Java que ejecuta un cmdlet de PowerShell utilizando Runtime
https://www.jesusninoc.com/2018/02/08/crear-compilar-y-ejecutar-una-clase-de-java-que-ejecuta-un-cmdlet-de-powershell-utilizando-runtime/
### Aplicaciones basadas en métodos remotos (RMI)
https://github.com/jesusninoc/ClasesPSP/blob/master/2019-02-11.md#aplicaciones-basadas-en-m%C3%A9todos-remotos-rmi

## JavaScript automatización
https://www.jesusninoc.com/javascript/

### Ejercicio: abrir WhatsApp y escribir un texto (JavaScript)
* https://www.jesusninoc.com/06/14/automatizar-whatsapp-web-hacer-click-en-un-chat-y-ver-el-contenido/

## Automatizar con Robot (java.awt.Robot)
https://www.jesusninoc.com/2017/12/01/curso-de-java-con-ejemplos/
- Obtener la posición del ratón en la pantalla con Java
- Ver la resolución de pantalla con Java
- Mover el ratón a una posición con Java
- Mover el ratón con duración a varias posiciones de la pantalla con Java
- Hacer clic en una posición de la pantalla con Java
- Pulsar la tecla de Windows de forma automática con Java
- Abrir Notepad de forma automática con Java mediante la pulsación de teclas
- Abrir Notepad y escribir un texto de forma automática con Java mediante la pulsación de teclas
- Realizar una captura de pantalla de toda la pantalla con Java
- Realizar una captura de pantalla de una parte de la pantalla con Java
- Detectar el color de un píxel de la pantalla con Java

------------
------------

# Programación de comunicaciones en red:
 -	Comunicación entre aplicaciones.
 -	Roles cliente y servidor.
 -	Elementos de programación de aplicaciones en red. Librerías.
 -	Sockets.
 -	Creación de sockets.
 -	Enlazado y establecimiento de conexiones.
 -	Utilización de sockets para la transmisión y recepción de información.
 -	Programación de aplicaciones cliente y servidor.
 -	Utilización de hilos en la programación de aplicaciones en red.

## Multiserver and clients (Sockets TCP and threads)
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/EchoMultiserver.java
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/echoThread.java
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/EchoClient.java
* https://www.jesusninoc.com/2012/10/12/multiserver-and-clients-sockets-tcp-and-threads/
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejercicio4Cliente.java
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejercicio4Contador.java
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejercicio4Hilo.java
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejercicio4Servidor.java

## MulticastSocket (Datagram socket UDP)
* https://www.jesusninoc.com/2012/10/14/multicastsocket-datagram-socket-udp/

A veces nos interesa que un ordenador pueda enviar un mensaje por red y que este sea recibido por otros ordenadores simultáneamente. Para ello están las direcciones multicast. Son direcciones en el rango 224.0.0.0 a 239.255.255.255. La 224.0.0.0 está reservada y no puede usarse. Enviando mensajes por estas direcciones, cualquier otro ordenador en la red que las escuche podría leer dicho mensaje, independientemente de cual sea la IP real de ese ordenador. Es decir, si un ordenador quiere enviar un mensaje simultáneamente a varios, puede hacerlo enviando el mensaje a una de estas IPs, los demás ordenadores deben estar a la escucha de dichas IPs para recibir el mensaje.

La operación de multicast consiste en enviar un único mensaje desde un proceso a cada uno de los miembros de un grupo de procesos, de modo que la pertenencia a un grupo sea transparente al emisor, es decir, el emisor no conoce el número de miembros del grupo ni sus direcciones IP. 

Un grupo multicast está especificado por una dirección IP clase D y un puerto. Las direcciones IP clase D están en el rango 224.0.0.0 a 239.255.255.255, dentro de este rango existen direcciones reservadas, en concreto, la 224.0.0.1 y la 224.0.0.255. El resto de direcciones del rango pueden ser utilizadas por grupos temporales, los cuales deben ser creados antes de su uso y dejar de existir cuando todos los miembros lo hayan dejado. 

Java proporciona una interfaz de datagramas para multicast IP a través de la clase MulticastSocket, que es una subclase de DatagramSocket, con la capacidad adicional de ser capaz de pertenecer a grupos multicast. 

La clase MulticastSocket proporciona dos constructores alternativos:
MulticastSocket(): que crea el socket en cualquiera de los puertos locales libres.
MulticastSocket(int port): que crea el socket en el puerto local indicado.

Un proceso puede pertenecer a un grupo multicast invocando el método joinGroup(InetAddress mcastaddr) de su socket multicast. Así, el socket pertenecerá a un grupo de multidifusión en un puerto dado y recibirá los datagramas enviados por los procesos en otros computadores a ese grupo en ese puerto. Un proceso puede dejar un grupo dado invocando el método leaveGroup(InetAddress mcastaddr) de su socket multicast. 

Para enviar datos a un grupo multicast se utiliza el método send(DatagramPacket p, byte ttl), este método es muy similar al de la clase DatagramSocket, la diferencia es que este datagrama será enviado a todos los miembros del grupo multicast. El parámetro TTL, Time-To-Live, lo pondremos siempre a 1, valor por defecto, para que sólo se difunda en la red local. 

Para recibir datos de un grupo multicast se utiliza el método receive(DatagramPacket p) de la clase DatagramSocket superclase de MulticastSocket. 

Es necesario pertenecer a un grupo para recibir mensajes multicast enviados a ese grupo, pero no es necesario para enviar mensajes.

---------
---------

# Programación de comunicaciones en red:
 -	Comunicación entre aplicaciones.
 -	Roles cliente y servidor.
 -	Elementos de programación de aplicaciones en red. Librerías.
 -	Sockets.
 -	Creación de sockets.
 -	Enlazado y establecimiento de conexiones.
 -	Utilización de sockets para la transmisión y recepción de información.
 -	Programación de aplicaciones cliente y servidor.
 -	Utilización de hilos en la programación de aplicaciones en red.

------------------------

# Modificar datagramas UDP

## Ejecutar un cmdlet remotamente en un equipo utilizando sockets UDP
https://www.jesusninoc.com/2017/01/27/ejecutar-un-cmdlet-remotamente-en-un-equipo-utilizando-sockets-udp/

## Enviar la hora mediante socket
https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejercicio3Servidor.java

## Modificar datagramas UDP con SoftPerfect Network Protocol Analyzer
* https://www.jesusninoc.com/2016/03/19/modificar-datagramas-udp-con-softperfect-network-protocol-analyzer/

## Modificar la dirección IP de origen en mensajes UDP con SoftPerfect Network Protocol Analyzer
* https://www.jesusninoc.com/2016/04/02/modificar-la-direccion-ip-de-origen-en-mensajes-udp-con-softperfect-network-protocol-analyzer/

## Tcpreplay - Pcap Editing And Replay Tools For NIX And Windows
* https://www.kitploit.com/2018/12/tcpreplay-pcap-editing-and-replay-tools.html

## Más sobre generadores de paquetes
* https://github.com/jesusninoc/ClasesISO/blob/master/2018-05-07.md#packet-generator
* https://github.com/jesusninoc/ClasesISO/blob/master/2018-04-28.md

---------------
---------------

# Sockets

## Servidor y cliente TCP básicos
https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejemplo6.java
https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejemplo6Cliente.java

## Server and client (Socket TCP)
* https://www.jesusninoc.com/10/11/server-and-client-sockets-tcp-2/
https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Servidor.java
https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Cliente.java

## Comprobar si un puerto TCP está abierto
https://www.jesusninoc.com/2012/10/10/comprobar-si-un-puerto-tcp-esta-abierto/

## Analizar direcciones IP para detectar puertos abiertos (versión 1)
https://www.jesusninoc.com/2015/07/02/analizar-direcciones-ip-para-detectar-puertos-abiertos-version-1/

## Analizar direcciones IP para detectar puertos abiertos (versión 2)
https://www.jesusninoc.com/2015/07/02/analizar-direcciones-ip-para-detectar-puertos-abiertos-version-2/

## Server and client (Datagram socket UDP)
https://www.jesusninoc.com/2012/10/13/server-and-client-datagram-socket-udp/
https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/ServidorUDP.java
https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/ClienteUDP.java
