# Programación de comunicaciones en red:
 -	Comunicación entre aplicaciones.
 -	Roles cliente y servidor.
 -	Elementos de programación de aplicaciones en red. Librerías.
 -	Sockets.
 -	Creación de sockets.
 -	Enlazado y establecimiento de conexiones.
 -	Utilización de sockets para la transmisión y recepción de información.
 -	Programación de aplicaciones cliente y servidor.
 -	Utilización de hilos en la programación de aplicaciones en red.

## Peticiones a servidores (GET, POST, fuerza bruta)

### Introducción
```
GetPost/postindex.php
GetPost/getindex.php
GetPost/examplepost.php
GetPost/exampleget.php
JavaScript/jh.html
JavaScript/sjh.html
JavaScript/ssjh.html
UserAgent/useragentindex.php
FuerzaBruta/index.php
FuerzaBruta/postraw.php
```

### Códigos sobre fuerza bruta
* https://github.com/jesusninoc/Seguridad/tree/master/GetPost
* https://github.com/jesusninoc/Seguridad/tree/master/FuerzaBruta
* https://github.com/jesusninoc/ClasesSeguridad/blob/master/2019-02-21.md
* https://github.com/jesusninoc/ClasesSeguridad/blob/master/2019-02-25.md
* https://github.com/jesusninoc/ClasesSeguridad/blob/master/2018-01-11.md

### Realizar fuerza bruta (método POST) desde PowerShell
```PowerShell
foreach($usuario in gc .\users.txt)
{
    foreach($password in gc .\passwords.txt)
    {
        $postParams = @{'username'=$usuario;'password'=$password}
        (Invoke-WebRequest -Uri "http://localhost/seguridad/FuerzaBruta/postraw.php" -Method POST -Body $postParams).content + " " + $usuario + " " + $password
    }
}
```

## Entender variables en GET y POST

### APAGAR Y ENCENDER EL ENCHUFE INTELIGENTE TP-LINK WI-FI HS100 DESDE POWERSHELL
* https://www.jesusninoc.com/11/25/apagar-y-encender-el-enchufe-inteligente-tp-link-wi-fi-hs100-desde-powershell/

### Enviar un formulario de contacto de WordPress desde PowerShell
* https://www.jesusninoc.com/10/10/enviar-un-formulario-de-contacto-de-wordpress-desde-powershell/

### Realizar petición HTTP desde PowerShell utilizando el método GET
* https://www.jesusninoc.com/03/31/realizar-peticion-http-desde-powershell-utilizando-el-metodo-get/

### Método GET en PHP desde PowerShell
* https://www.jesusninoc.com/03/04/metodo-get-en-php-desde-powershell/

### Realizar petición HTTP utilizando el método POST
* https://www.jesusninoc.com/12/09/realizar-peticion-http-utilizando-el-metodo-post/

### Realizar petición HTTP utilizando el método POST con Burp
* https://www.jesusninoc.com/12/12/realizar-peticion-http-utilizando-el-metodo-post-con-burp-suite/

### Enviar datos a un formulario de Google Docs desde PowerShell
* https://www.jesusninoc.com/04/30/enviar-datos-a-un-formulario-de-google-docs-desde-powershell-deducir-los-parametros-que-se-envian-por-post/

### Acceder a los datos publicados en un formulario de Google desde PowerShell
* https://www.jesusninoc.com/05/01/acceder-a-los-datos-publicados-en-un-formulario-de-google-desde-powershell/


-------------------------

## URL
### Conectar con una URL en Java
https://www.jesusninoc.com/2012/09/21/conectar-con-una-url-en-java/
### Conectar con una URL en Java cambiando el User-Agent
https://www.jesusninoc.com/2012/10/01/conectar-con-una-url-en-java-cambiando-el-user-agent/
### Realizar petición HTTP mediante el método POST utilizando librerías de Apache
https://www.jesusninoc.com/2016/01/26/realizar-peticion-http-utilizando-el-metodo-post-utilizando-librerias-de-apache/
### Petición a una página web con URL
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejemplo3.java
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejemplo3b.java
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejemplo5.java

## URL (GET y POST)

### Petición GET en Java
* https://www.jesusninoc.com/11/21/realizar-peticion-http-mediante-el-metodo-get/

### Petición POST en Java
* https://www.jesusninoc.com/11/21/realizar-peticion-http-mediante-el-metodo-post/

--------------
--------------

# Programación de comunicaciones en red:
 -	Comunicación entre aplicaciones.
 -	Roles cliente y servidor.
 -	Elementos de programación de aplicaciones en red. Librerías.
 -	Sockets.
 -	Creación de sockets.
 -	Enlazado y establecimiento de conexiones.
 -	Utilización de sockets para la transmisión y recepción de información.
 -	Programación de aplicaciones cliente y servidor.
 -	Utilización de hilos en la programación de aplicaciones en red.

## Enviar datos desde Java

### - Realizar petición HTTP mediante el método POST utilizando librerías de Apache
https://www.jesusninoc.com/2016/01/26/realizar-peticion-http-utilizando-el-metodo-post-utilizando-librerias-de-apache/

## Enviar datos desde PowerShell

### - Enviar datos a un formulario de Google Docs desde PowerShell (deducir los parámetros que se envían por POST)
https://www.jesusninoc.com/2017/04/30/enviar-datos-a-un-formulario-de-google-docs-desde-powershell-deducir-los-parametros-que-se-envian-por-post/

## Enviar datos desde Android

### - Enviar una peticion http POST desde Android a aplicación web (php)
http://codigoprogramacion.com/cursos/android/enviar-una-peticion-http-post-desde-android-a-aplicacion-web-php.html

## Scraping

### - Ejemplo básico
https://www.jesusninoc.com/08/28/html-parsing-get-information-from-a-website-bbc-news-version-28-08-2016/

### - Tweep - An Advanced Twitter Scraping Tool
https://www.kitploit.com/2017/10/tweep-advanced-twitter-scraping-tool.html

### - Scraping en Java (JSoup), con ejemplos
https://jarroba.com/scraping-java-jsoup-ejemplos/

### - Programación Movistar+ con PowerShell
https://www.jesusninoc.com/2017/10/12/programacion-movistar-con-powershell/

### Generación de diccionario de usuarios tipo jmolina@ gracias a linkedin scraping.
http://kinomakino.blogspot.com/2018/06/generacion-de-diccionario-de-usuarios.html

### Ejemplo scraping BBC con JSoup
```Java
package scratp;


import java.io.IOException;

import org.jsoup.Connection.Response;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ScrapingAllPost {
	
    public static final String url = "http://localhost:89/bbc/";
    public static final int maxPages = 20;
	
	
    public static void main (String args[]) {
		
        for (int i=1; i<maxPages; i++){
			
            String urlPage = String.format(url, i);
            System.out.println("Comprobando entradas de: "+urlPage);
			
            // Compruebo si me da un 200 al hacer la petición
            if (getStatusConnectionCode(urlPage) == 200) {
				
                // Obtengo el HTML de la web en un objeto Document2
                Document document = getHtmlDocument(urlPage);
				
                // Busco todas las historias de meneame que estan dentro de: 
                Elements entradas = document.select("div.media__content");
				
                // Paseo cada una de las entradas
                for (Element elem : entradas) {
                    String titulo = elem.getElementsByClass("media__link").text();
                    String autor = elem.getElementsByClass("media__summary").text();
                    //String fecha = elem.getElementsByClass("fecha").text();
                	System.out.println(titulo);
                  	System.out.println(autor);
                    //System.out.println(titulo+"\n"+autor+"\n"+fecha+"\n");
					
                }
		
            }else{
                System.out.println("El Status Code no es OK es: "+getStatusConnectionCode(urlPage));
                break;
            }
        }
    }
	
	
    /**
     * Con esta método compruebo el Status code de la respuesta que recibo al hacer la petición
     * EJM:
     * 		200 OK			300 Multiple Choices
     * 		301 Moved Permanently	305 Use Proxy
     * 		400 Bad Request		403 Forbidden
     * 		404 Not Found		500 Internal Server Error
     * 		502 Bad Gateway		503 Service Unavailable
     * @param url
     * @return Status Code
     */
    public static int getStatusConnectionCode(String url) {
		
        Response response = null;
		
        try {
            response = Jsoup.connect(url).userAgent("Mozilla/5.0").timeout(100000).ignoreHttpErrors(true).execute();
        } catch (IOException ex) {
            System.out.println("Excepción al obtener el Status Code: " + ex.getMessage());
        }
        return response.statusCode();
    }
	
	
    /**
     * Con este método devuelvo un objeto de la clase Document con el contenido del
     * HTML de la web que me permitirá parsearlo con los métodos de la librelia JSoup
     * @param url
     * @return Documento con el HTML
     */
    public static Document getHtmlDocument(String url) {

        Document doc = null;

        try {
            doc = Jsoup.connect(url).userAgent("Mozilla/5.0").timeout(100000).get();
        } catch (IOException ex) {
            System.out.println("Excepción al obtener el HTML de la página" + ex.getMessage());
        }

        return doc;

    }
}	
```

---------
---------

# Programación de comunicaciones en red:
 -	Comunicación entre aplicaciones.
 -	Roles cliente y servidor.
 -	Elementos de programación de aplicaciones en red. Librerías.
 -	Sockets.
 -	Creación de sockets.
 -	Enlazado y establecimiento de conexiones.
 -	Utilización de sockets para la transmisión y recepción de información.
 -	Programación de aplicaciones cliente y servidor.
 -	Utilización de hilos en la programación de aplicaciones en red.

------------------------

# Conexión TCP/IP
## Crear una comunicación entre un cliente en PowerShell de Windows y un servidor en Bash de Linux utilizando TCP/IP
https://www.jesusninoc.com/2017/10/26/crear-una-comunicacion-entre-un-cliente-en-powershell-de-windows-y-un-servidor-en-bash-de-linux-utilizando-tcpip/

## Establecer una dirección IPv6 para el interfaz Wi-Fi con PowerShell
https://www.jesusninoc.com/11/03/establecer-una-direccion-ipv6-para-el-interfaz-wi-fi-con-powershell/

## Proyecto de conexión remota
* https://www.jesusninoc.com/12/26/convertir-la-entrada-de-microfono-a-texto/
* https://www.jesusninoc.com/10/30/transmitir-una-captura-de-pantalla-entre-un-servidor-y-un-cliente-desde-powershell-sockets-tcp/
* https://www.jesusninoc.com/10/30/transmitir-una-captura-de-pantalla-entre-un-servidor-y-un-cliente-y-mostrarla-en-un-formulario-desde-powershell-sockets-tcp/
* https://www.jesusninoc.com/10/30/transmitir-una-captura-de-pantalla-entre-un-servidor-y-un-cliente-y-mostrarla-cada-dos-segundos-en-un-formulario-desde-powershell-sockets-tcp/
* https://www.jesusninoc.com/10/30/realizar-una-comunicacion-bidireccional-entre-un-cliente-y-un-servidor-mediante-tcp-desde-powershell-en-windows/
* https://www.jesusninoc.com/02/01/automatizar-tareas/
* https://www.jesusninoc.com/03/01/mover-el-raton-a-las-posiciones-que-estan-guardadas-en-un-fichero/
* https://www.jesusninoc.com/11/19/hacer-clic-en-una-posicion-de-la-pantalla-con-powershell/
* https://www.jesusninoc.com/02/02/realizar-captura-de-pantalla-y-dividir-en-partes-la-captura/
* https://www.jesusninoc.com/07/06/send-the-cursors-position-between-client-and-server-sockets-udp/
* https://www.jesusninoc.com/07/10/transfer-image-between-server-and-client-sockets-tcp/
* https://www.jesusninoc.com/11/07/transfer-images-between-server-and-client-sockets-tcp/

# Sockets

## Servidor y cliente TCP básicos
https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejemplo6.java
https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejemplo6Cliente.java

## Server and client (Socket TCP)
* https://www.jesusninoc.com/10/11/server-and-client-sockets-tcp-2/
https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Servidor.java
https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Cliente.java

## Comprobar si un puerto TCP está abierto
https://www.jesusninoc.com/2012/10/10/comprobar-si-un-puerto-tcp-esta-abierto/

## Analizar direcciones IP para detectar puertos abiertos (versión 1)
https://www.jesusninoc.com/2015/07/02/analizar-direcciones-ip-para-detectar-puertos-abiertos-version-1/

## Analizar direcciones IP para detectar puertos abiertos (versión 2)
https://www.jesusninoc.com/2015/07/02/analizar-direcciones-ip-para-detectar-puertos-abiertos-version-2/

## Server and client (Datagram socket UDP)
https://www.jesusninoc.com/2012/10/13/server-and-client-datagram-socket-udp/
https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/ServidorUDP.java
https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/ClienteUDP.java
