# Solución ejercicio: realizar un resumen (hash) de un documento descargado por FTP
* https://www.jesusninoc.com/01/15/ejecutar-una-funcion-resumen-hash-por-cada-linea-de-un-fichero-desde-java/

--------------------
--------------------

# Generación de servicios en red:
 -	Protocolos estándar de comunicación en red a nivel de aplicación (telnet, ftp, http, pop3, smtp, entre otros).
 -	Librerías de clases y componentes.
 -	Utilización de objetos predefinidos.
 -	Establecimiento y finalización de conexiones.
 -	Transmisión de información.
 -	Programación de aplicaciones cliente.
 - Programación de servidores.
 -	Implementación de comunicaciones simultáneas.

# Download Apache Commons Net
* https://commons.apache.org/proper/commons-net/download_net.cgi

# FTP

## Instalar un servidor FTP en Ubuntu
* https://blog.baehost.com/tutorialcomo-instalar-un-servidor-ftp-en-ubuntu-server/
* https://vivaubuntu.com/instalar-servidor-ftp-en-ubuntu-paso-a-paso/

## Subir un documento desde PowerShell
* https://www.jesusninoc.com/01/14/subir-ficheros-por-ftp-desde-powershell/

## Conexión a un servidor FTP
* https://github.com/javierinformatica/dam1/blob/master/Ejemplos/src/servicios/ClienteFTP2.java

## Descargar archivos FTP desde Java
* https://github.com/reikimitsu/dam2/blob/master/SeviciosProcesos/Tema%204/FTPserver/src/ftpclient/FTP_Descargafichero.java

## Listar archivos FTP desde Java
* https://github.com/reikimitsu/dam2/blob/master/SeviciosProcesos/Tema%204/FTPserver/src/ftpclient/FTP_listaarchivos.java

## Subir archivo a FTP desde Java
* https://github.com/reikimitsu/dam2/blob/master/SeviciosProcesos/Tema%204/FTPserver/src/ftpclient/FTP_subirarchivo.java

--------------------
--------------------

# Utilización de técnicas de programación segura:
 -	Prácticas de programación segura.
 -	Criptografía de clave pública y clave privada.
 -	Principales aplicaciones de la criptografía.
 -	Protocolos criptográficos.
 -	Política de seguridad.
 -	Programación de mecanismos de control de acceso.
 -	Encriptación de información.
 -	Protocolos seguros de comunicaciones.
 -	Programación de aplicaciones con comunicaciones seguras.

# Introducción a la criptografía
https://www.jesusninoc.com/2017/02/01/criptografia-en-powershell/

## Píldora formativa 2: ¿Qué es la criptografía?
https://www.youtube.com/watch?v=PDpMgx7avzA

## Píldora formativa 5: ¿Qué es la tríada CIA?
https://www.youtube.com/watch?v=KWAfVhy_GQ8

## Píldora formativa 6: ¿Ciframos, codificamos o encriptamos?
https://www.youtube.com/watch?v=77BrG2vRKss

# Codificar

## Base64
### Codificar en Base64 paso a paso con PowerShell
https://www.jesusninoc.com/2017/01/13/codificar-en-base64-paso-a-paso-con-powershell/
### Codificar un string en Base64
https://www.jesusninoc.com/2016/09/22/codificar-un-string-en-base64/
### Ejecutar en Java un cmdlet de PowerShell en Base64
https://www.jesusninoc.com/2018/02/10/ejecutar-en-java-un-cmdlet-de-powershell-en-base64/
### Datos URIs
https://developer.mozilla.org/es/docs/Web/HTTP/Basics_of_HTTP/Datos_URIs
### Bash Bunny Phishing Attack With Hamsters - Hak5 2306
https://www.youtube.com/watch?v=TYR2a2XoK3A
### Realizar una redirección con JavaScript utilizando Start-Process y Google Chrome
https://www.jesusninoc.com/2017/02/06/realizar-una-redireccion-con-javascript-utilizando-start-process-y-google-chrome-2/

----------

# Introducción a hash

## Realizar hashes parciales sobre un fichero
* https://www.jesusninoc.com/02/03/dividir-un-fichero-en-varios-ficheros-cada-linea-en-un-fichero-distinto/

## Realizar una función de hash sobre varios ficheros
* https://www.jesusninoc.com/2018/02/04/realizar-una-funcion-de-hash-sobre-varios-ficheros/

## Generar un resumen de un texto plano MD5
```Java
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.*;

public class Ejemplo04
{

    public static void main(String[] args)
    {
        MessageDigest md;
        try
        {
            md = MessageDigest.getInstance("MD5", Security.getProvider("SUN"));      //funcionaria si  lo quitamos
            //md = MessageDigest.getInstance("MD5");   
            String texto = "Esto es un texto plano.";   //string a capturar
            byte dataBytes[] = texto.getBytes();        //obtenemos los bytes
            md.update(dataBytes);                       //actualizamos el mesagediges
            byte resume[] = md.digest();                //Calcula el resumen
            // Información
            System.out.println("Original: " + texto);
            System.out.println("Número de Bytes: " + md.getDigestLength());
            System.out.println("Algoritmo: " + md.getAlgorithm());
            System.out.println("Mensaje resumen: " + new String(resume));
            System.out.println("Hexadecimal: " + Hexadecimal(resume));
            System.out.println(MessageDigest.isEqual(dataBytes, ("esto es un texto plano.").getBytes()));

            // Proveedor
            Provider proveedor = md.getProvider();
            System.out.println("Proveedor: " + proveedor.toString());
        } catch (NoSuchAlgorithmException e)
        {
            e.printStackTrace();
        }
    }

    static String Hexadecimal(byte[] resumen)
    {
        String hex = "";
        for (int i = 0; i < resumen.length; i++)
        {
            String h = Integer.toHexString(resumen[i] & 0xFF);
            if (h.length() == 1)
            {
                hex += "0";
            }
            hex += h;
        }
        return hex.toUpperCase();
    }
}
```

## Hash a password with SHA-512 in Java
* https://www.jesusninoc.com/02/02/hash-a-password-with-sha-512/
