# Programación multihilo:
 -	Recursos compartidos por los hilos.
 -	Estados de un hilo. Cambios de estado.
 -	Elementos relacionados con la programación de hilos. Librerías y clases.
 -	Gestión de hilos.
 -	Sincronización de hilos.
 -	Compartición de información entre hilos.
 -	Programación de aplicaciones multihilo.

# Estado de hilo
* https://github.com/mememiguelo/PSP/blob/master/JAVA/MultiHilos/HiloEjemplo1_V2.java
* https://github.com/mememiguelo/PSP/blob/master/JAVA/MultiHilos/UsaHiloEjemplo1_V2.java

# Pausar hilo
* https://github.com/mememiguelo/PSP/blob/master/JAVA/MultiHilos/UsaHilo_Sleep.java

# Join
* https://github.com/mememiguelo/PSP/blob/master/JAVA/MultiHilos/HiloEjemplo_Alive.java
* https://github.com/mememiguelo/PSP/blob/master/JAVA/MultiHilos/UsaHilo_Alive.java
* https://www.journaldev.com/1024/java-thread-join-example

# Prioridad con hilos
* https://github.com/mememiguelo/PSP/blob/master/EjemploHiloPrioridad1.java
```Java
/*
Prioridad entero entre 1 y 10
1 mínima -->MIN_PRIORITY
5 medio --> NORM_PRIORITY
10 máxima --> MAX_PRIORITY
2 hilos igual prioridad round-robbin
*/

class HiloPrioridad1 extends Thread {
	//propiedades	
	private int c=0; //vble contador
	private boolean stopHilo=false; //boolean parar contador hilo

public int getContador(){
	return c;
	}

public void pararHilo(){
	stopHilo=true;
	}
public void run(){
	while (!stopHilo) c++;
	}

}
```

# Interrupting a Thread
* http://www.javatpoint.com/interrupting-a-thread
* https://compiler.javatpoint.com/opr/test.jsp?filename=TestInterruptingThread1

## Interrupción de un hilo
```Java
public class HiloEjemploInterrup extends Thread {

  public void run() {
    try {
      while (!isInterrupted()) {
        System.out.println("En el hilo");
        Thread.sleep(100);
      }
    } catch (InterruptedException e) {
      System.out.println("Ha ocurrido una excepción");
    }
    System.out.println("Fin de hilo");
  }

  public void interrumpir() {
    interrupt();
  }

  public static void main(String[] args) {
    	HiloEjemploInterrup h = new HiloEjemploInterrup();
    	h.start();
    	for(int i=0;i<1000000;i++){}
    	h.interrumpir();
  }
}
```

# Java Thread: notify() and wait() examples
* https://www.programcreek.com/2009/02/notify-and-wait-example/
* https://www.tutorialspoint.com/java/java_thread_synchronization.htm

# Ejemplo synchronized
## Con y sin synchronized
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Hilos/Contador.java
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Hilos/HiloA.java
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Hilos/HiloB.java
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Hilos/CompartirInf1.java

# ¿Cómo funciona synchronized en Java?
https://epere4.blogspot.com.es/2008/04/cmo-funciona-synchronized-en-java.html

El bloque synchronized lleva entre paréntesis la referencia a un objeto. Cada vez que un thread intenta acceder a un bloque sincronizado le pregunta a ese objeto si no hay algún otro thread que ya tenga el lock para ese objecto. En otras palabras, le pregunta si no hay otro thread ejecutando algun bloque sincronizado con ese objeto (y recalco que es ese objeto porque en eso radica la clave para entender el funcionamiento)
Si el lock está tomado por otro thread, entonces el thread actual es suspendido y puesto en espera hasta que el lock se libere. Si el lock está libre, entonces el thread actual toma el lock del objeto y entra a ejecutar el bloque. Al tomar el lock, cuando venga el proximo thread a intentar ejecutar un bloque sincronizado con ese objeto, será puesto en espera.

# Barra de progreso
La barra de progreso es un componente especial ya que su ejecución se enmarca en paralelo a la del resto de elementos. De no ser así y ejecutarse todo en el hilo principal la interfaz se congela debido a la imposibilidad del sistema de otorgar recursos a los componentes
* http://www.developandsys.es/barra-de-progreso/

------------------------

# Programación de comunicaciones en red:
 -	Comunicación entre aplicaciones.
 -	Roles cliente y servidor.
 -	Elementos de programación de aplicaciones en red. Librerías.
 -	Sockets.
 -	Creación de sockets.
 -	Enlazado y establecimiento de conexiones.
 -	Utilización de sockets para la transmisión y recepción de información.
 -	Programación de aplicaciones cliente y servidor.
 -	Utilización de hilos en la programación de aplicaciones en red.

## Cmdlets for TCP/IP Model Layers
https://www.jesusninoc.com/11/13/cmdlets-for-tcpip-model-layers/
