# Programación multiproceso:
 -	Ejecutables. Procesos. Servicios.
 -	Estados de un proceso.
 -	Hilos.
 -	Programación concurrente.
 -	Programación paralela y distribuida.
 -	Comunicación entre procesos.
 -	Gestión de procesos.
 -	Sincronización entre procesos.
 -	Programación de aplicaciones multiproceso.

# Conceptos:
 - Pipes
   - Sin nombre
     - https://www.jesusninoc.com/2018/08/03/c-programming-in-linux-tutorial-037-pipe-function/
   - Con nombre
     - https://github.com/mememiguelo/PSP/blob/master/C/Otros/Fifo.c
     - https://github.com/mememiguelo/PSP/blob/master/C/Otros/fifocrea.c
     - https://github.com/mememiguelo/PSP/blob/master/C/Otros/fifoescribe.c
 - Sincronizar procesos
 - Señales
 - Creación procesos Java
 - Programación concurrente
 - Condiciones de Bernstein
 - Programación paralela
 - Memorias compartidas
 - Semáforos
 - Programación distribuida
 
--------------------

# Pipes
## Sin nombre
* https://www.jesusninoc.com/02/27/crear-y-utilizar-una-tuberia-sin-nombre-en-linux/
## Con nombre
* https://www.jesusninoc.com/02/27/crear-y-utilizar-una-tuberia-con-nombre-en-linux-fifo/
### mknod
http://man7.org/linux/man-pages/man2/mknod.2.html
### mknod (Bash)
```Bash
mknod FIFO p
l -l FIFO
cat FIFO
l > FIFO
```
### mknod (C)
```C
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>

mknod("FIFO1",S_IFIFO|0660,0);
```
* https://github.com/mememiguelo/PSP/blob/master/C/Otros/fifocrea.c
* https://github.com/mememiguelo/PSP/blob/master/C/Otros/fifoescribe.c

--------------------

# Ver presentación de repaso

--------------------

# Memorias compartidas
## Introducción a memoria
* https://www.jesusninoc.com/06/14/conocer-el-tamano-expresado-en-bytes-de-un-tipo-no-administrado-mediante-la-clase-marshal-en-powershell/
* https://www.jesusninoc.com/06/29/obtener-el-valor-de-una-variable-utilizando-otra-variable-mediante-la-direccion-del-primer-caracter-de-la-cadena-no-administrada-en-powershell-utilizando-la-clase-marshal/
* https://www.jesusninoc.com/06/29/obtener-valores-de-la-memoria-en-powershell-utilizando-la-clase-marshal/
* https://www.jesusninoc.com/06/30/copia-datos-de-una-matriz-de-caracteres-administrada-a-un-puntero-de-memoria-no-administrada-desde-powershell-utilizando-la-clase-marshal-funcionamiento-inseguro/
* https://www.jesusninoc.com/06/14/ver-credenciales-almacenados-mediante-la-clase-marshal-en-una-variable-con-get-credential-desde-powershell/

## Uso de las funciones ftok(), shmget(), shmat() y shmctl()
https://github.com/jesusninoc/ClasesPSP/blob/master/2017-10-24.md

## Programación de memorias compartidas en Linux
https://www.jesusninoc.com/2015/07/10/programacion-de-memorias-compartidas-en-linux/

## Utilizar zonas de memoria compartida en Linux mediante WSL desde PowerShell
https://www.jesusninoc.com/2018/06/25/utilizar-zonas-de-memoria-compartida-en-linux-mediante-wsl-desde-powershell/

## Relación con memoria
https://github.com/jesusninoc/ClasesPSP/blob/master/2017-10-12.md

## Volcado de memoria
https://github.com/jesusninoc/ClasesPSP/blob/master/2017-10-19.md

---------------------

# Ensamblador
## SPIM: A MIPS32 Simulator
https://github.com/jesusninoc/ClasesPSP/blob/master/2017-10-26.md

## Suma de números en ensamblador
https://github.com/jesusninoc/ClasesPSP/blob/master/2017-10-05.md

## Analizar con Cheat Engine un payload de ejecución de comandos arbitrarios para ejecutar PowerShell
https://www.jesusninoc.com/2017/03/20/analizar-con-cheat-engine-un-payload-de-ejecucion-de-comandos-arbitrarios-para-ejecutar-powershell/

---------------------

# Ktmutil
## Starts the Kernel Transaction Manager utility. If used without parameters, ktmutil displays available subcommands
```PowerShell
Ktmutil tm list
Ktmutil tm info
Ktmutil tx list
Ktmutil tx info
ktmutil tm info {f5a10f48-72be-11e5-8250-40167e1612ab}
Ktmutil list tms
```
