# ¿Cómo va la comunicación padre con hijo en Java?
* https://www.jesusninoc.com/02/07/ejecutar-una-clase-de-java-que-ejecuta-un-cmdlet-de-powershell-utilizando-runtime/
* https://www.jesusninoc.com/02/09/crear-compilar-generar-y-ejecutar-un-jar-de-java-que-ejecuta-un-cmdlet-de-powershell-utilizando-runtime/
## Padre (ayuda)
```Java
Process hijo = new ProcessBuilder("java","Hijo").start();
BufferedReader br = new BufferedReader(new InputStreamReader(hijo.getInputStream()));
PrintStream ps = new PrintStream(hijo.getOutputStream(), true);
BufferedReader in = new BufferedReader(new InputStreamReader (System.in));
linea = in.readLine();
ps.println(linea);
linea = br.readLine();
System.out.println(linea);
```
## Hijo (ayuda)
```Java
BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
enviar = new String();
enviar=br.readLine();
System.out.println(enviar);
```

-----------------
-----------------

# Repaso Linux
* https://github.com/jesusninoc/Bash/tree/master/Permisos
* https://github.com/jesusninoc/Bash/tree/master/Ficheros
* https://github.com/jesusninoc/Bash/tree/master/Repaso
* https://github.com/jesusninoc/Bash/tree/master/Monitorizacion
* https://github.com/jesusninoc/Bash

-----------------
-----------------

# Programación multiproceso:
 -	Ejecutables. Procesos. Servicios.
 -	Estados de un proceso.
 -	Hilos.
 -	Programación concurrente.
 -	Programación paralela y distribuida.
 -	Comunicación entre procesos.
 -	Gestión de procesos.
 -	Sincronización entre procesos.
 -	Programación de aplicaciones multiproceso.

# Conceptos:
 - Pipes
   - Sin nombre
     - https://www.jesusninoc.com/2018/08/03/c-programming-in-linux-tutorial-037-pipe-function/
   - Con nombre
     - https://github.com/mememiguelo/PSP/blob/master/C/Otros/Fifo.c
     - https://github.com/mememiguelo/PSP/blob/master/C/Otros/fifocrea.c
     - https://github.com/mememiguelo/PSP/blob/master/C/Otros/fifoescribe.c
 - Sincronizar procesos
 - Señales
 - Creación procesos Java
 - Programación concurrente
 - Condiciones de Bernstein
 - Programación paralela
 - Memorias compartidas
 - Semáforos
 - Programación distribuida
 
---------------------

# Descriptores
|Valor|entero|Nombre
|---|---|---
|0|Entrada estándar|stdin
|1|Salida estándar|stdout
|2|Error estándar|stderr

# Pipes
## Sin nombre
* https://www.jesusninoc.com/02/27/crear-y-utilizar-una-tuberia-sin-nombre-en-linux/
## Con nombre
* https://www.jesusninoc.com/02/27/crear-y-utilizar-una-tuberia-con-nombre-en-linux-fifo/
### mknod
http://man7.org/linux/man-pages/man2/mknod.2.html
### mknod (Bash)
```Bash
mknod FIFO p
l -l FIFO
cat FIFO
l > FIFO
```
### mknod (C)
```C
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>

mknod("FIFO1",S_IFIFO|0660,0);
```
* https://github.com/mememiguelo/PSP/blob/master/C/Otros/fifocrea.c
* https://github.com/mememiguelo/PSP/blob/master/C/Otros/fifoescribe.c
