# Módulo profesional 11: Programación de servicios y procesos (código: 0490)
## Contenidos (duración 80 horas)

- Programación multiproceso
- Programación multihilo
- Programación de comunicaciones en red
- Generación de servicios en red
- Utilización de técnicas de programación segura

# Introducción a PSP

- Trabajos posibles para proyecto fin de ciclo
- ¿De qué va la asignatura?
- ¿Cómo voy a evaluar la asignatura?
- Se puede utilizar cualquier lenguaje
- Mezcla de tecnologías
- WSL (Windows Subsystem for Linux)
  - https://github.com/jesusninoc/ClasesISO/blob/cdf3c6ea4c197a5517b0fac5cdf70f381f140842/2018-06-01.md
- Utilizar Github
- Introduccion a OWASP Top Ten 2017
  - https://www.owasp.org/index.php/Top_10-2017_Top_10
  - https://www.jesusninoc.com/2017/12/29/introduccion-a-owasp-top-ten-2017/
- Empezamos: programa, proceso, sistema operativo (presentación)

# Ejemplos
## Lanzar un programa en Java
```Java
import java.io.IOException;

public class P2
{
	public static void main(String[] args) throws IOException
	{
		ProcessBuilder pb = new ProcessBuilder(args);
		pb.start();
	}
}
```
### Compilar y ejecutar
```CMD
javac P2.java
java -cp . P2 notepad
```

## Lanzar un programa creado en Java desde Java
```Java
import java.io.IOException;

public class proceso{
	public static void main(String[] args)
	{
		ProcessBuilder pb = new ProcessBuilder("cmd", "/C", "java -cp . ThreadA > hola.txt");
		try
		{
			pb.start();
			}
		catch (IOException e)
		{
			System.out.println(e.getMessage());
			}
		}
	}
```

## Lanzar un programa desde PowerShell utilizando C#
```PowerShell
$CodigoC = @”
 
public class Proceso
{
public static void Main()
{
System.Diagnostics.Process.Start( @"C:\Windows\System32\Notepad.exe" );
}
}
 
“@
 
Add-Type -TypeDefinition $CodigoC -ErrorAction SilentlyContinue
 
[Proceso]::Main()
```
