# Utilización de técnicas de programación segura:
 -	Prácticas de programación segura.
 -	Criptografía de clave pública y clave privada.
 -	Principales aplicaciones de la criptografía.
 -	Protocolos criptográficos.
 -	Política de seguridad.
 -	Programación de mecanismos de control de acceso.
 -	Encriptación de información.
 -	Protocolos seguros de comunicaciones.
 -	Programación de aplicaciones con comunicaciones seguras.


# Comandos para Keytool
```
===================
EN EL SERVIDOR:
keytool -genkey -alias servidor  -keyalg RSA -keystore AlmacenSrv -storepass 1234567
keytool -exportcert -alias servidor  -keystore AlmacenSrv -storepass 1234567 -file CertificadoServ.cer
keytool -importcert -trustcacerts -alias servidor -file CertificadoServ.cer -keystore CliCertConfianza -storepass 1234567
===================
EJECUCIÓN EN EL SERVIDOR
java -Djavax.net.ssl.keyStore=AlmacenSrv -Djavax.net.ssl.keyStorePassword=1234567 ServidorSSL
===================
===================
EN EL CLIENTE:
keytool -genkey -alias cliente -keyalg RSA -keystore AlmacenCli -storepass clavecli
keytool -exportcert -alias cliente -keystore AlmacenCli -storepass clavecli -file CertificadoCli.cer
keytool -importcert -trustcacerts -alias cliente -file CertificadoCli.cer -keystore SrvCertConfianza -storepass cercli
===================
EJECUCIÓN CLIENTE:
java -Djavax.net.ssl.trustStore=CliCertConfianza -Djavax.net.ssl.trustStorePassword=cercli ClienteSSL
=====================
```

# Certificados SSL (sin propiedades JSSE)

## Ejemplo de conexión entre cliente-servidor SSL (sin propiedades JSSE)
### Servidor SSL
* https://www.jesusninoc.com/02/11/socket-ssl-en-java/
### Cliente SSL
* https://www.jesusninoc.com/02/11/socket-ssl-en-java/

-----------

# Certificados SSL (con propiedades JSSE)

## Propiedades JSSE
### Servidor
```
System.setProperty("javax.net.ssl.keyStore","AlmacenSrv2")
System.setProperty("javax.net.ssl.keyStorePassword","1234567")
```
### Cliente
```
System.setProperty("javax.net.ssl.trustStore","AlmacenSrv2")
System.setProperty("javax.net.ssl.trustStorePassword","1234567")
```

## Ejemplo de conexión entre cliente-servidor SSL (con propiedades JSSE)
### Servidor
```Java
import java.io.*;
import javax.net.ssl.*;
 
public class Server {
    public static void main(String[] arg) throws IOException {
        int puerto = 5556;
               
                System.setProperty("javax.net.ssl.keyStore","src/AlmacenSrv");
                System.setProperty("javax.net.ssl.keyStorePassword","1234567");
       
        SSLServerSocketFactory sfact = (SSLServerSocketFactory) SSLServerSocketFactory
                .getDefault();
        SSLServerSocket servidorSSL = (SSLServerSocket) sfact
                .createServerSocket(puerto);
        SSLSocket clienteConectado = null;
        DataInputStream flujoEntrada = null;//FLUJO DE ENTRADA DE CLIENTE
        DataOutputStream flujoSalida = null;//FLUJO DE SALIDA AL CLIENTE
       
        for (int i = 1; i < 5; i++) {
            System.out.println("Esperando al cliente " + i);
            clienteConectado = (SSLSocket) servidorSSL.accept();       
            flujoEntrada = new DataInputStream(clienteConectado.getInputStream());
 
            // EL CLIENTE ME ENVIA UN MENSAJE
            System.out.println("Recibiendo del CLIENTE: " + i + " \n\t"
                    + flujoEntrada.readUTF());
   
            flujoSalida = new DataOutputStream(clienteConectado.getOutputStream());
 
            // ENVIO UN SALUDO AL CLIENTE
            flujoSalida.writeUTF("Saludos al cliente del servidor");
        }
        // CERRAR STREAMS Y SOCKETS
        flujoEntrada.close();
        flujoSalida.close();
        clienteConectado.close();
        servidorSSL.close();
 
    }// main
}
```

### Cliente
```Java
import java.io.*;
import javax.net.ssl.*;
 
public class Cliente  {
    public static void main(String[] args) throws Exception {
        String Host = "localhost";
        int puerto = 5556;//puerto remoto
 
        // Propiedades JSSE)
        System.setProperty("javax.net.ssl.trustStore","src/AlmacenSrv");
        System.setProperty("javax.net.ssl.trustStorePassword","1234567");
 
        System.out.println("PROGRAMA CLIENTE INICIADO....");
 
        SSLSocketFactory sfact = (SSLSocketFactory) SSLSocketFactory.getDefault();
        SSLSocket Cliente  = (SSLSocket) sfact.createSocket(Host, puerto);
 
        // CREO FLUJO DE SALIDA AL SERVIDOR
        DataOutputStream flujoSalida = new DataOutputStream(Cliente.getOutputStream());
 
        // ENVIO UN SALUDO AL SERVIDOR
        flujoSalida.writeUTF("Saludos al SERVIDOR DESDE EL CLIENTE");
 
        // CREO FLUJO DE ENTRADA AL SERVIDOR
        DataInputStream flujoEntrada = new DataInputStream(Cliente.getInputStream());
 
        // EL servidor ME ENVIA UN MENSAJE
        System.out.println("Recibiendo del SERVIDOR: \n\t" + flujoEntrada.readUTF());
 
        // CERRAR STREAMS Y SOCKETS
        flujoEntrada.close();
        flujoSalida.close();
        Cliente.close();
    }// main
}//..ClienteSSLv
```


----------------------

# Socket SSL
## To Use keytool to Create a Server Certificate
https://docs.oracle.com/cd/E19798-01/821-1841/gjrgy/index.html
## Socket SSL con Java 
http://chuwiki.chuidiang.org/index.php?title=Socket_SSL_con_Java
## SSL/TLS for dummies part 3 – Understanding Certificate Authority
https://www.wst.space/ssl-part-3-certificate-authority/

----------------------
----------------------

# Utilización de técnicas de programación segura:
 -	Prácticas de programación segura.
 -	Criptografía de clave pública y clave privada.
 -	Principales aplicaciones de la criptografía.
 -	Protocolos criptográficos.
 -	Política de seguridad.
 -	Programación de mecanismos de control de acceso.
 -	Encriptación de información.
 -	Protocolos seguros de comunicaciones.
 -	Programación de aplicaciones con comunicaciones seguras.

----------------------

# Pasos para firmar un JAR y verificar que el fichero está firmado

```
# Crear fichero JAR que contiene el documento a firmar utilizando la herramienta jar
jar cvf DATOS.jar DATOS.DAT
# Generar las claves pública y privada (si no existen), utilizando el comando keytool -genkey
keytool -genkey -alias FirmaContrato -keystore AlmacenClaves -keyalg rsa -storepass 1234567
keytool -list -keystore AlmacenClaves
# Firmar el fichero JAR, usando la herramienta jarsigner y la clave privada generada en el paso anterior
jarsigner.exe -keystore AlmacenClaves -signedjar DATOSfirmados.jar DATOS.jar firmaContrato
# Exportar el certificado de clave pública para que el receptor del documento autentique la firma del emisor, utilizando el comando keytool -export
keytool.exe -export -keystore AlmacenClaves -alias firmacontrato -file reta.cer
# Importar el certificado del clave
keytool.exe -import -alias reta -file reta.cer -keystore AlmacenReceptor
# Por último suministrar el fichero JAR firmado y el certificado al receptor
jarsigner.exe -verify -verbose -certs -keystore AlmacenReceptor DATOSfirmados.jar
# Ver el fichero que hay en el .JAR
jar xvf DATOSfirmados.jar DATOS.DAT
```

----------------------

# Firma

## Firmar un mensaje con clave privada DSA (Digital Signature Algorithm)
* https://github.com/jesusninoc/PSP-2/blob/master/Ejemplos/src/seguridad/Ejemplo7.java
## Almacenar la clave pública y privada en disco en los ficheros Clave.publica y Clave.privada
* https://github.com/jesusninoc/PSP-2/blob/master/Ejemplos/src/seguridad/Ejemplo7Almacenar.java
## Generar una firma en un fichero a partir de la clave privada almacenada en un fichero. La firma se almacena en el fichero fichero.firma
* https://github.com/jesusninoc/PSP-2/blob/master/Ejemplos/src/seguridad/Ejemplo8.java
## Verificar la firma de un fichero con la clave pública
* https://github.com/jesusninoc/PSP-2/blob/master/Ejemplos/src/seguridad/Ejemplo9.java
## keytool - Key and Certificate Management Tool
https://docs.oracle.com/javase/7/docs/technotes/tools/solaris/keytool.html
