# Utilización de técnicas de programación segura:
 -	Prácticas de programación segura.
 -	Criptografía de clave pública y clave privada.
 -	Principales aplicaciones de la criptografía.
 -	Protocolos criptográficos.
 -	Política de seguridad.
 -	Programación de mecanismos de control de acceso.
 -	Encriptación de información.
 -	Protocolos seguros de comunicaciones.
 -	Programación de aplicaciones con comunicaciones seguras.

# Ejemplos
## Cifrar y descrifrar con clave secreta

```Java
import java.security.Key;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;


public class Ejemplo10 {
	public static void main(String args[]) {
		try {
			//ALGORITMO DES
			KeyGenerator kg = KeyGenerator.getInstance("DES");
			Cipher c = Cipher.getInstance("DES/CBC/PKCS5Padding");
			Key key = kg.generateKey();
			
			c.init(Cipher.ENCRYPT_MODE, key);
			byte input[] = "Stand and unfold yourself".getBytes();
			byte encrypted[] = c.doFinal(input);
			byte iv[] = c.getIV();

			IvParameterSpec dps = new IvParameterSpec(iv);
			c.init(Cipher.DECRYPT_MODE, key, dps);
			byte output[] = c.doFinal(encrypted);
			System.out.println("The string was ");
			System.out.println(new String(output));
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		//ALGORITMO AES
		try {
			KeyGenerator kg = KeyGenerator.getInstance("AES");
			kg.init (128);
			SecretKey clave = kg.generateKey();
			
			Cipher c = Cipher.getInstance("AES/ECB/PKCS5Padding");
			c.init(Cipher.ENCRYPT_MODE, clave);
				
			//CIFRAMOS TEXTO
			byte textoPlano[] = "Esto es un Texto Plano".getBytes();
			byte textoCifrado[] = c.doFinal(textoPlano);
			System.out.println("Encriptado: "+ new String(textoCifrado));
			
		    //DESCIFRAMOS TEXTO					
			c.init(Cipher.DECRYPT_MODE, clave);		
			byte desencriptado[] = c.doFinal(textoCifrado);
			System.out.println("Desencriptado: "+ new String(desencriptado));
		} catch (Exception e) {
			e.printStackTrace();
		}
		
	}
}
```

## Cifrar y descifrar con clave pública
* https://www.jesusninoc.com/02/05/cifrar-y-descifrar-con-rsa-desde-java-generando-clave-privada-y-clave-publica/

## Cifrar y descifrar con clave clave secreta AES que se ha transmitido mediante cifrado asimetrico RSA 
* https://www.jesusninoc.com/02/10/cifrar-y-descifrar-con-clave-clave-secreta-aes-que-se-ha-transmitido-mediante-cifrado-asimetrico-rsa-en-java/

## Almacenar la clave secreta en un fichero
* https://www.jesusninoc.com/02/05/almacenar-la-clave-secreta-generada-con-el-algoritmo-aes-en-un-fichero-en-java/

## Utilizar la clave secreta almacenada en un fichero para cifrar un documento PDF de nombre FICHERO.pdf

```Java
import java.io.*;
import java.security.*;
import javax.crypto.*;

public class Ejemplo13Cifra {
	public static void main(String[] args) {
		try {	
			//RECUPERAMOS CLAVE SECRETA DEL FICHERO
			ObjectInputStream oin = new ObjectInputStream(
					 new FileInputStream("Clave.secreta"));
	        Key clavesecreta = (Key) oin.readObject();
	        oin.close();	        
			//SE DEFINE EL OBJETO Cipher
			Cipher c = Cipher.getInstance("AES/ECB/PKCS5Padding");
			c.init(Cipher.ENCRYPT_MODE, clavesecreta);
			//FICHERO A CIFRAR
			FileInputStream filein = new FileInputStream("FICHERO.pdf");
			
			//OBJETO CipherOutputStream
			CipherOutputStream out = new CipherOutputStream(
					new FileOutputStream("FicheroPDF.Cifrado"), c);
			int tambloque = c.getBlockSize();
			byte[] bytes = new byte[tambloque];
			
			//LEEMOS BLOQUES DE BYTES DEL FICHERO PDF 
			//Y LO VAMOS ESCRIBIENDO AL CipherOutputStream
			int i = filein.read(bytes);		
			while (i != -1) {				
				out.write(bytes, 0, i);
				i = filein.read(bytes);
			}
			out.flush();
			out.close();
			filein.close(); 
			System.out.println("Fichero cifrado con clave secreta.");		
						
		} catch (Exception e) {
			e.printStackTrace();
		}
	}//main
}//.. Ejemplo13Cifra
```

## Leer y descifrar datos de un fichero cifrado leyendo la clave secreta de un fichero
```Java
import java.io.*;
import java.security.*;
import javax.crypto.*;
public class Ejemplo13Descifra {
	public static void main(String[] args) {
		try {
			//RECUPERAMOS CLAVE SECRETA DEL FICHERO
			ObjectInputStream oin = new ObjectInputStream(
					 new FileInputStream("Clave.secreta"));
	        Key clavesecreta = (Key) oin.readObject();
	        oin.close();	
	        //			
			Cipher c = Cipher.getInstance("AES/ECB/PKCS5Padding");
			c.init(Cipher.DECRYPT_MODE, clavesecreta);
			
			CipherInputStream in = new CipherInputStream(
			      new FileInputStream("FicheroPDF.Cifrado"), c);
			
			int tambloque = c.getBlockSize();
			byte[] bytes = new byte[tambloque];
			
			int i = in.read(bytes);		
			FileOutputStream fileout = new FileOutputStream("FICHEROdescifrado.pdf");
		
			while (i != -1)	{
			  fileout.write(bytes, 0, i);
			  i = in.read(bytes);	
			}		
			fileout.close();
			in.close(); 
			System.out.println("Fichero descifrado con clave secreta.");		
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}//main
}//.. Ejemplo13Descifra
```

----------------------

# Pasos para firmar un JAR y verificar que el fichero está firmado (utilizar un certificado creado anteriormente)

```
# Crear fichero JAR que contiene el documento a firmar utilizando la herramienta jar
jar cvf datos.jar datos.dat

# Generar las claves pública y privada (si no existen), utilizando el comando keytool -genkey
keytool -genkey -alias firmacontrato -keystore AlmacenClaves -keyalg rsa -storepass 1234567
keytool -list -keystore AlmacenClaves

# Firmar el fichero JAR, usando la herramienta jarsigner y la clave privada generada en el paso anterior
jarsigner.exe -keystore AlmacenClaves -signedjar datosfirmados.jar datos.jar firmaContrato

# Exportar el certificado de clave pública para que el receptor del documento autentique la firma del emisor, utilizando el comando keytool -export
keytool.exe -export -keystore AlmacenClaves -alias firmacontrato -file reta.cer

# Importar el certificado del clave
keytool.exe -import -alias reta -file reta.cer -keystore AlmacenReceptor

# Por último suministrar el fichero JAR firmado y el certificado al receptor
jarsigner.exe -verify -verbose -certs -keystore AlmacenReceptor datosfirmados.jar
```

----------------------

# Comandos para Keytool
```
===================
EN EL SERVIDOR:
keytool -genkey -alias servidor  -keyalg RSA -keystore AlmacenSrv -storepass 1234567
keytool -exportcert -alias servidor  -keystore AlmacenSrv -storepass 1234567 -file CertificadoServ.cer
keytool -importcert -trustcacerts -alias servidor -file CertificadoServ.cer -keystore CliCertConfianza -storepass 1234567
===================
EJECUCIÓN EN EL SERVIDOR
java -Djavax.net.ssl.keyStore=AlmacenSrv -Djavax.net.ssl.keyStorePassword=1234567 ServidorSSL
===================
===================
EN EL CLIENTE:
keytool -genkey -alias cliente -keyalg RSA -keystore AlmacenCli -storepass clavecli
keytool -exportcert -alias cliente -keystore AlmacenCli -storepass clavecli -file CertificadoCli.cer
keytool -importcert -trustcacerts -alias cliente -file CertificadoCli.cer -keystore SrvCertConfianza -storepass cercli
===================
EJECUCIÓN CLIENTE:
java -Djavax.net.ssl.trustStore=CliCertConfianza -Djavax.net.ssl.trustStorePassword=cercli ClienteSSL
=====================
```
