# Utilización de técnicas de programación segura:
 -	Prácticas de programación segura.
 -	Criptografía de clave pública y clave privada.
 -	Principales aplicaciones de la criptografía.
 -	Protocolos criptográficos.
 -	Política de seguridad.
 -	Programación de mecanismos de control de acceso.
 -	Encriptación de información.
 -	Protocolos seguros de comunicaciones.
 -	Programación de aplicaciones con comunicaciones seguras.

# Introducción a hash

## Realizar hashes parciales sobre un fichero
* https://www.jesusninoc.com/02/03/dividir-un-fichero-en-varios-ficheros-cada-linea-en-un-fichero-distinto/

## Realizar una función de hash sobre varios ficheros
* https://www.jesusninoc.com/2018/02/04/realizar-una-funcion-de-hash-sobre-varios-ficheros/

## Generar un resumen de un texto plano MD5
```Java
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.*;

public class Ejemplo04
{

    public static void main(String[] args)
    {
        MessageDigest md;
        try
        {
            md = MessageDigest.getInstance("MD5", Security.getProvider("SUN"));      //funcionaria si  lo quitamos
            //md = MessageDigest.getInstance("MD5");   
            String texto = "Esto es un texto plano.";   //string a capturar
            byte dataBytes[] = texto.getBytes();        //obtenemos los bytes
            md.update(dataBytes);                       //actualizamos el mesagediges
            byte resume[] = md.digest();                //Calcula el resumen
            // Información
            System.out.println("Original: " + texto);
            System.out.println("Número de Bytes: " + md.getDigestLength());
            System.out.println("Algoritmo: " + md.getAlgorithm());
            System.out.println("Mensaje resumen: " + new String(resume));
            System.out.println("Hexadecimal: " + Hexadecimal(resume));
            System.out.println(MessageDigest.isEqual(dataBytes, ("esto es un texto plano.").getBytes()));

            // Proveedor
            Provider proveedor = md.getProvider();
            System.out.println("Proveedor: " + proveedor.toString());
        } catch (NoSuchAlgorithmException e)
        {
            e.printStackTrace();
        }
    }

    static String Hexadecimal(byte[] resumen)
    {
        String hex = "";
        for (int i = 0; i < resumen.length; i++)
        {
            String h = Integer.toHexString(resumen[i] & 0xFF);
            if (h.length() == 1)
            {
                hex += "0";
            }
            hex += h;
        }
        return hex.toUpperCase();
    }
}
```

## Hash a password with SHA-512 in Java
* https://www.jesusninoc.com/02/02/hash-a-password-with-sha-512/

----------
----------

# Generación de servicios en red:
 -	Protocolos estándar de comunicación en red a nivel de aplicación (telnet, ftp, http, pop3, smtp, entre otros).
 -	Librerías de clases y componentes.
 -	Utilización de objetos predefinidos.
 -	Establecimiento y finalización de conexiones.
 -	Transmisión de información.
 -	Programación de aplicaciones cliente.
 - Programación de servidores.
 -	Implementación de comunicaciones simultáneas.

--------------------

# Aplicaciones basadas en métodos remotos (RMI)
## Invocación de métodos remotos (RMI)
https://es.slideshare.net/matiasyimak/invocacin-de-mtodos-remotos-rmi
## Realizar una suma mediante una interfaz que contiene los métodos que se ejecutarán de forma remota (RMI)
https://www.jesusninoc.com/2018/01/24/realizar-una-suma-mediante-una-interfaz-que-contiene-los-metodos-que-se-ejecutaran-de-forma-remota/

# Servicios Web SOAP
Estructura de un mensaje SOAP (originalmente las siglas de Simple Object Access Protocol) es un protocolo estándar que define cómo dos objetos en diferentes procesos pueden comunicarse por medio de intercambio de datos XML.
## Como ejemplo se muestra la forma en que un cliente solicitaría información de un producto a un proveedor de servicios Web
https://es.wikipedia.org/w/index.php?title=Simple_Object_Access_Protocol&action=edit&section=6
# Servicios REST
REST es cualquier interfaz entre sistemas que use HTTP para obtener datos o generar operaciones sobre esos datos en todos los formatos posibles, como XML y JSON. Es una alternativa en auge a otros protocolos estándar de intercambio de datos como SOAP (Simple Object Access Protocol), que disponen de una gran capacidad pero también mucha complejidad. A veces es preferible una solución más sencilla de manipulación de datos como REST.
## REST API 
https://www.jesusninoc.com/rest-api/
### Falcon Heavy (SpaceX Data REST API)
https://www.jesusninoc.com/02/07/falcon-heavy-spacex-data-rest-api/

--------------------

# Scraping
## Puppeteer is a Node library which provides a high-level API to control Chrome or Chromium over the DevTools Protocol
https://pptr.dev/

## Ejemplo básico
https://www.jesusninoc.com/08/28/html-parsing-get-information-from-a-website-bbc-news-version-28-08-2016/

## Tweep - An Advanced Twitter Scraping Tool
https://www.kitploit.com/2017/10/tweep-advanced-twitter-scraping-tool.html

## Generación de diccionario de usuarios tipo jmolina@ gracias a linkedin scraping.
http://kinomakino.blogspot.com/2018/06/generacion-de-diccionario-de-usuarios.html

## Scraping en Java (JSoup), con ejemplos
https://jarroba.com/scraping-java-jsoup-ejemplos/

## Ejemplo scraping BBC con JSoup
```Java
package scratp;


import java.io.IOException;

import org.jsoup.Connection.Response;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ScrapingAllPost {
	
    public static final String url = "http://localhost:89/bbc/";
    public static final int maxPages = 20;
	
	
    public static void main (String args[]) {
		
        for (int i=1; i<maxPages; i++){
			
            String urlPage = String.format(url, i);
            System.out.println("Comprobando entradas de: "+urlPage);
			
            // Compruebo si me da un 200 al hacer la petición
            if (getStatusConnectionCode(urlPage) == 200) {
				
                // Obtengo el HTML de la web en un objeto Document2
                Document document = getHtmlDocument(urlPage);
				
                // Busco todas las historias de meneame que estan dentro de: 
                Elements entradas = document.select("div.media__content");
				
                // Paseo cada una de las entradas
                for (Element elem : entradas) {
                    String titulo = elem.getElementsByClass("media__link").text();
                    String autor = elem.getElementsByClass("media__summary").text();
                    //String fecha = elem.getElementsByClass("fecha").text();
                	System.out.println(titulo);
                  	System.out.println(autor);
                    //System.out.println(titulo+"\n"+autor+"\n"+fecha+"\n");
					
                }
		
            }else{
                System.out.println("El Status Code no es OK es: "+getStatusConnectionCode(urlPage));
                break;
            }
        }
    }
	
	
    /**
     * Con esta método compruebo el Status code de la respuesta que recibo al hacer la petición
     * EJM:
     * 		200 OK			300 Multiple Choices
     * 		301 Moved Permanently	305 Use Proxy
     * 		400 Bad Request		403 Forbidden
     * 		404 Not Found		500 Internal Server Error
     * 		502 Bad Gateway		503 Service Unavailable
     * @param url
     * @return Status Code
     */
    public static int getStatusConnectionCode(String url) {
		
        Response response = null;
		
        try {
            response = Jsoup.connect(url).userAgent("Mozilla/5.0").timeout(100000).ignoreHttpErrors(true).execute();
        } catch (IOException ex) {
            System.out.println("Excepción al obtener el Status Code: " + ex.getMessage());
        }
        return response.statusCode();
    }
	
	
    /**
     * Con este método devuelvo un objeto de la clase Document con el contenido del
     * HTML de la web que me permitirá parsearlo con los métodos de la librelia JSoup
     * @param url
     * @return Documento con el HTML
     */
    public static Document getHtmlDocument(String url) {

        Document doc = null;

        try {
            doc = Jsoup.connect(url).userAgent("Mozilla/5.0").timeout(100000).get();
        } catch (IOException ex) {
            System.out.println("Excepción al obtener el HTML de la página" + ex.getMessage());
        }

        return doc;

    }
}	
```

## Programación Movistar+ con PowerShell
https://www.jesusninoc.com/2017/10/12/programacion-movistar-con-powershell/

## Node.JS para parsear un fichero JSON
```JavaScript
var http = require('https');

var url = 'https://www.jesusninoc.com/s/movistar.php';
 
 http.get(url, function(res) {
      var body = '';
 
      res.on('data', function(chunk) {
         body += chunk;
      });
 
      res.on('end', function() {
        var jsonData = JSON.parse(body)
        for (var i = 0; i < jsonData.length; ++i) {
          console.log(jsonData[i].Nombre);
          console.log(jsonData[i].Pases[0].Titulo);
          console.log("----------------------------------");
        }
      });
    }).on('error', function(e) {
      console.log("Error: " + e.message);
 });
```

## JavaScript + jQuery 1.11.0 (parsear un fichero JSON)
http://jsfiddle.net/vLft56mg/355/

## JavaScript + jQuery 2.1.3 (parsear un fichero JSON)
https://jsfiddle.net/96psd4xw/17/

## Parsear contenido de API
* https://www.nutritionix.com/
* https://www.themealdb.com/api/json/v1/1/search.php?s=Arrabiata
* https://www.themealdb.com/api.php
* https://igdb.github.io/api/
* https://freemusicarchive.org/api

--------------------

# Utilización de técnicas de programación segura:
 -	Prácticas de programación segura.
 -	Criptografía de clave pública y clave privada.
 -	Principales aplicaciones de la criptografía.
 -	Protocolos criptográficos.
 -	Política de seguridad.
 -	Programación de mecanismos de control de acceso.
 -	Encriptación de información.
 -	Protocolos seguros de comunicaciones.
 -	Programación de aplicaciones con comunicaciones seguras.

--------------------

## HMAC
En la criptografía, un código de autentificación de mensajes en clave-hash (HMAC) es una construcción específica para calcular un código de autentificación de mensaje (MAC) que implica una función hash criptográfica en combinación con una llave criptográfica secreta. Como cualquier MAC, puede ser utilizado para verificar simultáneamente la integridad de los datos y la autentificación de un mensaje. Cualquier función hash criptográfica, tales como MD5 o SHA-1, puede ser utilizada para el cálculo de un HMAC; el algoritmo MAC resultante se denomina HMAC-MD5 o HMAC-SHA1 en consecuencia. La fuerza criptográfica del HMAC depende de la potencia criptográfica de la función de hash subyacente, el tamaño de su salida de hash y el tamaño y calidad de la llave.

## Generar HMAC-SHA256 con PowerShell
https://www.jesusninoc.com/2018/02/18/generar-hmac-sha256-con-powershell/

## CCN-STIC-807 – Criptografía de empleo en el ENS
|Tipo de Algoritmo| Acreditados por el CCN|
|--|--
|Cifrado Simétrico|TDEA (Triple Data Encryption Algorithm)
||AES (Advanced Encryption Standard)
|Algoritmos Asimétricos|DSA (Digital Signature Algorithm)
||ECDSA (Elliptic Curve Digital Signature Algorithm)
||RSA (Criptosistema RSA)
||ECIES (Elliptic Curve Integrated Encryption Scheme)
|Intercambio de Clave|DH o DHKA (Diffie-Hellman Key Agreement)
||MQV (Menezes-Qu-Vanstone Key Agreement)
||ECDH (Elliptic Curve Diffie-Hellman)
||ECMQV (Elliptic Curve Menezes-Qu-Vanstone)
|Funciones resumen (Hash)|SHA-2 (Secure Hash Algorithm)
||HMAC (Hash Message Authentication Code )

## HASHES GENERATOR
https://www.onlinehashcrack.com/hash-generator.php

## Crack hashes in seconds
https://github.com/s0md3v/Hash-Buster

## Reverse hash (MD5/SHA1)
https://www.jesusninoc.com/2016/02/02/reverse-hash-md5-sha1/

## PoC para detectar colisión en SHA1 con PowerShell
http://www.jesusninoc.com/2017/02/24/poc-para-detectar-colision-en-sha1-con-powershell/

## Practical collision attack against SHA-1
https://isc.sans.edu/forums/diary/Practical+collision+attack+against+SHA1/22109/

## Cracking de contraseñas con hashcat
https://www.securityartwork.es/2017/02/15/cracking-contrasenas-hashcat/

--------------------

# Java
## Guardar un String junto con el resumen
* https://www.jesusninoc.com/02/06/guardar-un-texto-junto-con-el-resumen-hash-sha-en-java/
## Comprobar que el String no se ha dañado o manipulado
* https://www.jesusninoc.com/02/06/comprobar-que-un-texto-no-se-ha-danado-o-manipulado-en-java-verificando-el-hash/
