# Repaso
* https://www.tiobe.com/tiobe-index/

------------------

# Programación de comunicaciones en red:
 -	Comunicación entre aplicaciones.
 -	Roles cliente y servidor.
 -	Elementos de programación de aplicaciones en red. Librerías.
 -	Sockets.
 -	Creación de sockets.
 -	Enlazado y establecimiento de conexiones.
 -	Utilización de sockets para la transmisión y recepción de información.
 -	Programación de aplicaciones cliente y servidor.
 -	Utilización de hilos en la programación de aplicaciones en red.

## Multiserver and clients (Sockets TCP and threads)
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/EchoMultiserver.java
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/echoThread.java
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/EchoClient.java
* https://www.jesusninoc.com/2012/10/12/multiserver-and-clients-sockets-tcp-and-threads/
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejercicio4Cliente.java
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejercicio4Contador.java
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejercicio4Hilo.java
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejercicio4Servidor.java

## MulticastSocket (Datagram socket UDP)
* https://www.jesusninoc.com/2012/10/14/multicastsocket-datagram-socket-udp/

A veces nos interesa que un ordenador pueda enviar un mensaje por red y que este sea recibido por otros ordenadores simultáneamente. Para ello están las direcciones multicast. Son direcciones en el rango 224.0.0.0 a 239.255.255.255. La 224.0.0.0 está reservada y no puede usarse. Enviando mensajes por estas direcciones, cualquier otro ordenador en la red que las escuche podría leer dicho mensaje, independientemente de cual sea la IP real de ese ordenador. Es decir, si un ordenador quiere enviar un mensaje simultáneamente a varios, puede hacerlo enviando el mensaje a una de estas IPs, los demás ordenadores deben estar a la escucha de dichas IPs para recibir el mensaje.

La operación de multicast consiste en enviar un único mensaje desde un proceso a cada uno de los miembros de un grupo de procesos, de modo que la pertenencia a un grupo sea transparente al emisor, es decir, el emisor no conoce el número de miembros del grupo ni sus direcciones IP. 

Un grupo multicast está especificado por una dirección IP clase D y un puerto. Las direcciones IP clase D están en el rango 224.0.0.0 a 239.255.255.255, dentro de este rango existen direcciones reservadas, en concreto, la 224.0.0.1 y la 224.0.0.255. El resto de direcciones del rango pueden ser utilizadas por grupos temporales, los cuales deben ser creados antes de su uso y dejar de existir cuando todos los miembros lo hayan dejado. 

Java proporciona una interfaz de datagramas para multicast IP a través de la clase MulticastSocket, que es una subclase de DatagramSocket, con la capacidad adicional de ser capaz de pertenecer a grupos multicast. 

La clase MulticastSocket proporciona dos constructores alternativos:
MulticastSocket(): que crea el socket en cualquiera de los puertos locales libres.
MulticastSocket(int port): que crea el socket en el puerto local indicado.

Un proceso puede pertenecer a un grupo multicast invocando el método joinGroup(InetAddress mcastaddr) de su socket multicast. Así, el socket pertenecerá a un grupo de multidifusión en un puerto dado y recibirá los datagramas enviados por los procesos en otros computadores a ese grupo en ese puerto. Un proceso puede dejar un grupo dado invocando el método leaveGroup(InetAddress mcastaddr) de su socket multicast. 

Para enviar datos a un grupo multicast se utiliza el método send(DatagramPacket p, byte ttl), este método es muy similar al de la clase DatagramSocket, la diferencia es que este datagrama será enviado a todos los miembros del grupo multicast. El parámetro TTL, Time-To-Live, lo pondremos siempre a 1, valor por defecto, para que sólo se difunda en la red local. 

Para recibir datos de un grupo multicast se utiliza el método receive(DatagramPacket p) de la clase DatagramSocket superclase de MulticastSocket. 

Es necesario pertenecer a un grupo para recibir mensajes multicast enviados a ese grupo, pero no es necesario para enviar mensajes.

--------------------

# Generación de servicios en red:
 -	Protocolos estándar de comunicación en red a nivel de aplicación (telnet, ftp, http, pop3, smtp, entre otros).
 -	Librerías de clases y componentes.
 -	Utilización de objetos predefinidos.
 -	Establecimiento y finalización de conexiones.
 -	Transmisión de información.
 -	Programación de aplicaciones cliente.
 - Programación de servidores.
 -	Implementación de comunicaciones simultáneas.

# Ejemplos libro capítulo 5
https://drive.google.com/file/d/1bniOY-APLVMTajioRAgVikbf1B3AjkTL/view

# Download Apache Commons Net
https://commons.apache.org/proper/commons-net/download_net.cgi

# Instalar FileZilla
http://www.ite.educacion.es/formacion/materiales/62/cd/modulo_8_publicacion_de_proyectos/instalar_filezilla.html

--------------------

# Utilización de técnicas de programación segura:
 -	Prácticas de programación segura.
 -	Criptografía de clave pública y clave privada.
 -	Principales aplicaciones de la criptografía.
 -	Protocolos criptográficos.
 -	Política de seguridad.
 -	Programación de mecanismos de control de acceso.
 -	Encriptación de información.
 -	Protocolos seguros de comunicaciones.
 -	Programación de aplicaciones con comunicaciones seguras.

# Ejemplos libro capítulo 6
https://drive.google.com/file/d/11ID2FiuFgByP_xFEBnDnD6v6XZtwag1Q/view

# Introducción a hash

## Realizar hashes parciales sobre un fichero
https://github.com/jesusninoc/PowerShell/blob/master/Seguridad/Realizar%20hashes%20parciales%20sobre%20un%20fichero.ps1

## Realizar una función de hash sobre varios ficheros
https://www.jesusninoc.com/2018/02/04/realizar-una-funcion-de-hash-sobre-varios-ficheros/

## Fuzzy hashing API and fuzzy hashing tool 
https://github.com/ssdeep-project/ssdeep

## Generar un resumen de un texto plano MD5
```Java
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.*;

public class Ejemplo04
{

    public static void main(String[] args)
    {
        MessageDigest md;
        try
        {
            md = MessageDigest.getInstance("MD5", Security.getProvider("SUN"));      //funcionaria si  lo quitamos
            //md = MessageDigest.getInstance("MD5");   
            String texto = "Esto es un texto plano.";   //string a capturar
            byte dataBytes[] = texto.getBytes();        //obtenemos los bytes
            md.update(dataBytes);                       //actualizamos el mesagediges
            byte resume[] = md.digest();                //Calcula el resumen
            // Información
            System.out.println("Original: " + texto);
            System.out.println("Número de Bytes: " + md.getDigestLength());
            System.out.println("Algoritmo: " + md.getAlgorithm());
            System.out.println("Mensaje resumen: " + new String(resume));
            System.out.println("Hexadecimal: " + Hexadecimal(resume));
            System.out.println(MessageDigest.isEqual(dataBytes, ("esto es un texto plano.").getBytes()));

            // Proveedor
            Provider proveedor = md.getProvider();
            System.out.println("Proveedor: " + proveedor.toString());
        } catch (NoSuchAlgorithmException e)
        {
            e.printStackTrace();
        }
    }

    static String Hexadecimal(byte[] resumen)
    {
        String hex = "";
        for (int i = 0; i < resumen.length; i++)
        {
            String h = Integer.toHexString(resumen[i] & 0xFF);
            if (h.length() == 1)
            {
                hex += "0";
            }
            hex += h;
        }
        return hex.toUpperCase();
    }
}
```

## Hash a password with SHA-512 in Java
```Java
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public String get_SHA_512_SecurePassword(String passwordToHash, String   salt){
String generatedPassword = null;
    try {
         MessageDigest md = MessageDigest.getInstance("SHA-512");
         md.update(salt.getBytes(StandardCharsets.UTF_8));
         byte[] bytes = md.digest(passwordToHash.getBytes(StandardCharsets.UTF_8));
         StringBuilder sb = new StringBuilder();
         for(int i=0; i< bytes.length ;i++){
            sb.append(Integer.toString((bytes[i] & 0xff) + 0x100, 16).substring(1));
         }
         generatedPassword = sb.toString();
        } 
       catch (NoSuchAlgorithmException e){
        e.printStackTrace();
       }
    return generatedPassword;
}
```

## HMAC
En la criptografía, un código de autentificación de mensajes en clave-hash (HMAC) es una construcción específica para calcular un código de autentificación de mensaje (MAC) que implica una función hash criptográfica en combinación con una llave criptográfica secreta. Como cualquier MAC, puede ser utilizado para verificar simultáneamente la integridad de los datos y la autentificación de un mensaje. Cualquier función hash criptográfica, tales como MD5 o SHA-1, puede ser utilizada para el cálculo de un HMAC; el algoritmo MAC resultante se denomina HMAC-MD5 o HMAC-SHA1 en consecuencia. La fuerza criptográfica del HMAC depende de la potencia criptográfica de la función de hash subyacente, el tamaño de su salida de hash y el tamaño y calidad de la llave.

## Generar HMAC-SHA256 con PowerShell
https://www.jesusninoc.com/2018/02/18/generar-hmac-sha256-con-powershell/

## CCN-STIC-807 – Criptografía de empleo en el ENS
|Tipo de Algoritmo| Acreditados por el CCN|
|--|--
|Cifrado Simétrico|TDEA (Triple Data Encryption Algorithm)
||AES (Advanced Encryption Standard)
|Algoritmos Asimétricos|DSA (Digital Signature Algorithm)
||ECDSA (Elliptic Curve Digital Signature Algorithm)
||RSA (Criptosistema RSA)
||ECIES (Elliptic Curve Integrated Encryption Scheme)
|Intercambio de Clave|DH o DHKA (Diffie-Hellman Key Agreement)
||MQV (Menezes-Qu-Vanstone Key Agreement)
||ECDH (Elliptic Curve Diffie-Hellman)
||ECMQV (Elliptic Curve Menezes-Qu-Vanstone)
|Funciones resumen (Hash)|SHA-2 (Secure Hash Algorithm)
||HMAC (Hash Message Authentication Code )

## HASHES GENERATOR
https://www.onlinehashcrack.com/hash-generator.php

## Crack hashes in seconds
https://github.com/s0md3v/Hash-Buster

## Reverse hash (MD5/SHA1)
https://www.jesusninoc.com/2016/02/02/reverse-hash-md5-sha1/

## PoC para detectar colisión en SHA1 con PowerShell
http://www.jesusninoc.com/2017/02/24/poc-para-detectar-colision-en-sha1-con-powershell/

## Practical collision attack against SHA-1
https://isc.sans.edu/forums/diary/Practical+collision+attack+against+SHA1/22109/

## Cracking de contraseñas con hashcat
https://www.securityartwork.es/2017/02/15/cracking-contrasenas-hashcat/

