# Generación de servicios en red:
 -	Protocolos estándar de comunicación en red a nivel de aplicación (telnet, ftp, http, pop3, smtp, entre otros).
 -	Librerías de clases y componentes.
 -	Utilización de objetos predefinidos.
 -	Establecimiento y finalización de conexiones.
 -	Transmisión de información.
 -	Programación de aplicaciones cliente.
 - Programación de servidores.
 -	Implementación de comunicaciones simultáneas.
 
 ----------------------

# Ejemplos libro capítulo 5
https://drive.google.com/file/d/1bniOY-APLVMTajioRAgVikbf1B3AjkTL/view

----------------------

# Download Apache Commons Net
https://commons.apache.org/proper/commons-net/download_net.cgi

----------------------

# FTP
## Instalar FileZilla
http://www.ite.educacion.es/formacion/materiales/62/cd/modulo_8_publicacion_de_proyectos/instalar_filezilla.html
## Conexión a un servidor FTP
* https://github.com/javierinformatica/dam1/blob/master/Ejemplos/src/servicios/ClienteFTP1.java
* https://github.com/javierinformatica/dam1/blob/master/Ejemplos/src/servicios/ClienteFTP2.java
## Listar archivos
https://github.com/reikimitsu/dam2/blob/master/SeviciosProcesos/Tema%204/FTPserver/src/ftpclient/FTP_listaarchivos.java
## Subir archivo
https://github.com/reikimitsu/dam2/blob/master/SeviciosProcesos/Tema%204/FTPserver/src/ftpclient/FTP_subirarchivo.java
## Bajar archivo
https://github.com/reikimitsu/dam2/blob/master/SeviciosProcesos/Tema%204/FTPserver/src/ftpclient/FTP_Descargafichero.java
## Cliente FTP básico
https://drive.google.com/file/d/1bniOY-APLVMTajioRAgVikbf1B3AjkTL/view

----------------------

# SMTP
## Cliente SMTP
* https://github.com/mcast386/DAM2M09/blob/master/PSP12-serveis-SMTPClient-apachelib/src/ClienteSMTP1.java
* https://github.com/mcast386/DAM2M09/blob/master/PSP12-serveis-SMTPClient-apachelib/src/ClienteSMTP2.java
## NOTLS
https://drive.google.com/file/d/1bniOY-APLVMTajioRAgVikbf1B3AjkTL/view

----------------------

# SSH
## Conectar vía SSH con Java
http://programacion.net/articulo/conectar_via_ssh_con_java_1163

----------------------

# Aplicaciones basadas en métodos remotos (RMI)
## Invocación de métodos remotos (RMI)
https://es.slideshare.net/matiasyimak/invocacin-de-mtodos-remotos-rmi
## Realizar una suma mediante una interfaz que contiene los métodos que se ejecutarán de forma remota (RMI)
https://www.jesusninoc.com/2018/01/24/realizar-una-suma-mediante-una-interfaz-que-contiene-los-metodos-que-se-ejecutaran-de-forma-remota/

----------------------

# JMS
## Introducción a JMS (Java Message Service)
http://programacion.net/articulo/introduccion_a_jms_java_message_service_142
##  JMS application with multiple, concurrent, consumers and producers
http://activemq.apache.org/hello-world.html
## Servicios de Mensajes con JMS
http://www.jtech.ua.es/j2ee/publico/mens-2010-11/wholesite.pdf

----------------------

# Conexion_BD con Java
http://programacion.net/codigo/conexion_bd_74

----------------------

# Scraping
## Puppeteer is a Node library which provides a high-level API to control Chrome or Chromium over the DevTools Protocol
https://pptr.dev/

## Ejemplo básico
https://www.jesusninoc.com/08/28/html-parsing-get-information-from-a-website-bbc-news-version-28-08-2016/

## Tweep - An Advanced Twitter Scraping Tool
https://www.kitploit.com/2017/10/tweep-advanced-twitter-scraping-tool.html

## Generación de diccionario de usuarios tipo jmolina@ gracias a linkedin scraping.
http://kinomakino.blogspot.com/2018/06/generacion-de-diccionario-de-usuarios.html

## Scraping en Java (JSoup), con ejemplos
https://jarroba.com/scraping-java-jsoup-ejemplos/

## Ejemplo scraping BBC con JSoup
```Java
package scratp;


import java.io.IOException;

import org.jsoup.Connection.Response;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ScrapingAllPost {
	
    public static final String url = "http://localhost:89/bbc/";
    public static final int maxPages = 20;
	
	
    public static void main (String args[]) {
		
        for (int i=1; i<maxPages; i++){
			
            String urlPage = String.format(url, i);
            System.out.println("Comprobando entradas de: "+urlPage);
			
            // Compruebo si me da un 200 al hacer la petición
            if (getStatusConnectionCode(urlPage) == 200) {
				
                // Obtengo el HTML de la web en un objeto Document2
                Document document = getHtmlDocument(urlPage);
				
                // Busco todas las historias de meneame que estan dentro de: 
                Elements entradas = document.select("div.media__content");
				
                // Paseo cada una de las entradas
                for (Element elem : entradas) {
                    String titulo = elem.getElementsByClass("media__link").text();
                    String autor = elem.getElementsByClass("media__summary").text();
                    //String fecha = elem.getElementsByClass("fecha").text();
                	System.out.println(titulo);
                  	System.out.println(autor);
                    //System.out.println(titulo+"\n"+autor+"\n"+fecha+"\n");
					
                }
		
            }else{
                System.out.println("El Status Code no es OK es: "+getStatusConnectionCode(urlPage));
                break;
            }
        }
    }
	
	
    /**
     * Con esta método compruebo el Status code de la respuesta que recibo al hacer la petición
     * EJM:
     * 		200 OK			300 Multiple Choices
     * 		301 Moved Permanently	305 Use Proxy
     * 		400 Bad Request		403 Forbidden
     * 		404 Not Found		500 Internal Server Error
     * 		502 Bad Gateway		503 Service Unavailable
     * @param url
     * @return Status Code
     */
    public static int getStatusConnectionCode(String url) {
		
        Response response = null;
		
        try {
            response = Jsoup.connect(url).userAgent("Mozilla/5.0").timeout(100000).ignoreHttpErrors(true).execute();
        } catch (IOException ex) {
            System.out.println("Excepción al obtener el Status Code: " + ex.getMessage());
        }
        return response.statusCode();
    }
	
	
    /**
     * Con este método devuelvo un objeto de la clase Document con el contenido del
     * HTML de la web que me permitirá parsearlo con los métodos de la librelia JSoup
     * @param url
     * @return Documento con el HTML
     */
    public static Document getHtmlDocument(String url) {

        Document doc = null;

        try {
            doc = Jsoup.connect(url).userAgent("Mozilla/5.0").timeout(100000).get();
        } catch (IOException ex) {
            System.out.println("Excepción al obtener el HTML de la página" + ex.getMessage());
        }

        return doc;

    }
}	
```

## Programación Movistar+ con PowerShell
https://www.jesusninoc.com/2017/10/12/programacion-movistar-con-powershell/

## Node.JS para parsear un fichero JSON
```JavaScript
var http = require('https');

var url = 'https://www.jesusninoc.com/s/movistar.php';
 
 http.get(url, function(res) {
      var body = '';
 
      res.on('data', function(chunk) {
         body += chunk;
      });
 
      res.on('end', function() {
        var jsonData = JSON.parse(body)
        for (var i = 0; i < jsonData.length; ++i) {
          console.log(jsonData[i].Nombre);
          console.log(jsonData[i].Pases[0].Titulo);
          console.log("----------------------------------");
        }
      });
    }).on('error', function(e) {
      console.log("Error: " + e.message);
 });
```

## JavaScript + jQuery 1.11.0 (parsear un fichero JSON)
http://jsfiddle.net/vLft56mg/355/

## JavaScript + jQuery 2.1.3 (parsear un fichero JSON)
https://jsfiddle.net/96psd4xw/17/

## Parsear contenido de API
* https://www.nutritionix.com/
* https://www.themealdb.com/api/json/v1/1/search.php?s=Arrabiata
* https://www.themealdb.com/api.php
* https://igdb.github.io/api/
* https://freemusicarchive.org/api
