# Programación de comunicaciones en red:
 -	Comunicación entre aplicaciones.
 -	Roles cliente y servidor.
 -	Elementos de programación de aplicaciones en red. Librerías.
 -	Sockets.
 -	Creación de sockets.
 -	Enlazado y establecimiento de conexiones.
 -	Utilización de sockets para la transmisión y recepción de información.
 -	Programación de aplicaciones cliente y servidor.
 -	Utilización de hilos en la programación de aplicaciones en red.

## Multiserver and clients (Sockets TCP and threads)
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/EchoMultiserver.java
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/echoThread.java
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/EchoClient.java
* https://www.jesusninoc.com/2012/10/12/multiserver-and-clients-sockets-tcp-and-threads/
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejercicio4Cliente.java
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejercicio4Contador.java
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejercicio4Hilo.java
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejercicio4Servidor.java

## MulticastSocket (Datagram socket UDP)
* https://www.jesusninoc.com/2012/10/14/multicastsocket-datagram-socket-udp/

A veces nos interesa que un ordenador pueda enviar un mensaje por red y que este sea recibido por otros ordenadores simultáneamente. Para ello están las direcciones multicast. Son direcciones en el rango 224.0.0.0 a 239.255.255.255. La 224.0.0.0 está reservada y no puede usarse. Enviando mensajes por estas direcciones, cualquier otro ordenador en la red que las escuche podría leer dicho mensaje, independientemente de cual sea la IP real de ese ordenador. Es decir, si un ordenador quiere enviar un mensaje simultáneamente a varios, puede hacerlo enviando el mensaje a una de estas IPs, los demás ordenadores deben estar a la escucha de dichas IPs para recibir el mensaje.

La operación de multicast consiste en enviar un único mensaje desde un proceso a cada uno de los miembros de un grupo de procesos, de modo que la pertenencia a un grupo sea transparente al emisor, es decir, el emisor no conoce el número de miembros del grupo ni sus direcciones IP. 

Un grupo multicast está especificado por una dirección IP clase D y un puerto. Las direcciones IP clase D están en el rango 224.0.0.0 a 239.255.255.255, dentro de este rango existen direcciones reservadas, en concreto, la 224.0.0.1 y la 224.0.0.255. El resto de direcciones del rango pueden ser utilizadas por grupos temporales, los cuales deben ser creados antes de su uso y dejar de existir cuando todos los miembros lo hayan dejado. 

Java proporciona una interfaz de datagramas para multicast IP a través de la clase MulticastSocket, que es una subclase de DatagramSocket, con la capacidad adicional de ser capaz de pertenecer a grupos multicast. 

La clase MulticastSocket proporciona dos constructores alternativos:
MulticastSocket(): que crea el socket en cualquiera de los puertos locales libres.
MulticastSocket(int port): que crea el socket en el puerto local indicado.

Un proceso puede pertenecer a un grupo multicast invocando el método joinGroup(InetAddress mcastaddr) de su socket multicast. Así, el socket pertenecerá a un grupo de multidifusión en un puerto dado y recibirá los datagramas enviados por los procesos en otros computadores a ese grupo en ese puerto. Un proceso puede dejar un grupo dado invocando el método leaveGroup(InetAddress mcastaddr) de su socket multicast. 

Para enviar datos a un grupo multicast se utiliza el método send(DatagramPacket p, byte ttl), este método es muy similar al de la clase DatagramSocket, la diferencia es que este datagrama será enviado a todos los miembros del grupo multicast. El parámetro TTL, Time-To-Live, lo pondremos siempre a 1, valor por defecto, para que sólo se difunda en la red local. 

Para recibir datos de un grupo multicast se utiliza el método receive(DatagramPacket p) de la clase DatagramSocket superclase de MulticastSocket. 

Es necesario pertenecer a un grupo para recibir mensajes multicast enviados a ese grupo, pero no es necesario para enviar mensajes.
