# Programación de comunicaciones en red:
 -	Comunicación entre aplicaciones.
 -	Roles cliente y servidor.
 -	Elementos de programación de aplicaciones en red. Librerías.
 -	Sockets.
 -	Creación de sockets.
 -	Enlazado y establecimiento de conexiones.
 -	Utilización de sockets para la transmisión y recepción de información.
 -	Programación de aplicaciones cliente y servidor.
 -	Utilización de hilos en la programación de aplicaciones en red.

-------------------------

# Entrega de hilos semana que viene

-------------------------

# Ejercicios:
- Simular una fuerza bruta con método POST
- Crear un servidor web que reciba peticiones GET

------------------------

## Enviar datos desde Java

### - Realizar petición HTTP mediante el método POST utilizando librerías de Apache
https://www.jesusninoc.com/2016/01/26/realizar-peticion-http-utilizando-el-metodo-post-utilizando-librerias-de-apache/

## Enviar datos desde PowerShell

### - Enviar datos a un formulario de Google Docs desde PowerShell (deducir los parámetros que se envían por POST)
https://www.jesusninoc.com/2017/04/30/enviar-datos-a-un-formulario-de-google-docs-desde-powershell-deducir-los-parametros-que-se-envian-por-post/

## Enviar datos desde Android

### - Enviar una peticion http POST desde Android a aplicación web (php)
http://codigoprogramacion.com/cursos/android/enviar-una-peticion-http-post-desde-android-a-aplicacion-web-php.html

## Scraping

### - Ejemplo básico
https://www.jesusninoc.com/08/28/html-parsing-get-information-from-a-website-bbc-news-version-28-08-2016/

### - Tweep - An Advanced Twitter Scraping Tool
https://www.kitploit.com/2017/10/tweep-advanced-twitter-scraping-tool.html

### - Scraping en Java (JSoup), con ejemplos
https://jarroba.com/scraping-java-jsoup-ejemplos/

### - Programación Movistar+ con PowerShell
https://www.jesusninoc.com/2017/10/12/programacion-movistar-con-powershell/

### Generación de diccionario de usuarios tipo jmolina@ gracias a linkedin scraping.
http://kinomakino.blogspot.com/2018/06/generacion-de-diccionario-de-usuarios.html

### Ejemplo scraping BBC con JSoup
```Java
package scratp;


import java.io.IOException;

import org.jsoup.Connection.Response;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class ScrapingAllPost {
	
    public static final String url = "http://localhost:89/bbc/";
    public static final int maxPages = 20;
	
	
    public static void main (String args[]) {
		
        for (int i=1; i<maxPages; i++){
			
            String urlPage = String.format(url, i);
            System.out.println("Comprobando entradas de: "+urlPage);
			
            // Compruebo si me da un 200 al hacer la petición
            if (getStatusConnectionCode(urlPage) == 200) {
				
                // Obtengo el HTML de la web en un objeto Document2
                Document document = getHtmlDocument(urlPage);
				
                // Busco todas las historias de meneame que estan dentro de: 
                Elements entradas = document.select("div.media__content");
				
                // Paseo cada una de las entradas
                for (Element elem : entradas) {
                    String titulo = elem.getElementsByClass("media__link").text();
                    String autor = elem.getElementsByClass("media__summary").text();
                    //String fecha = elem.getElementsByClass("fecha").text();
                	System.out.println(titulo);
                  	System.out.println(autor);
                    //System.out.println(titulo+"\n"+autor+"\n"+fecha+"\n");
					
                }
		
            }else{
                System.out.println("El Status Code no es OK es: "+getStatusConnectionCode(urlPage));
                break;
            }
        }
    }
	
	
    /**
     * Con esta método compruebo el Status code de la respuesta que recibo al hacer la petición
     * EJM:
     * 		200 OK			300 Multiple Choices
     * 		301 Moved Permanently	305 Use Proxy
     * 		400 Bad Request		403 Forbidden
     * 		404 Not Found		500 Internal Server Error
     * 		502 Bad Gateway		503 Service Unavailable
     * @param url
     * @return Status Code
     */
    public static int getStatusConnectionCode(String url) {
		
        Response response = null;
		
        try {
            response = Jsoup.connect(url).userAgent("Mozilla/5.0").timeout(100000).ignoreHttpErrors(true).execute();
        } catch (IOException ex) {
            System.out.println("Excepción al obtener el Status Code: " + ex.getMessage());
        }
        return response.statusCode();
    }
	
	
    /**
     * Con este método devuelvo un objeto de la clase Document con el contenido del
     * HTML de la web que me permitirá parsearlo con los métodos de la librelia JSoup
     * @param url
     * @return Documento con el HTML
     */
    public static Document getHtmlDocument(String url) {

        Document doc = null;

        try {
            doc = Jsoup.connect(url).userAgent("Mozilla/5.0").timeout(100000).get();
        } catch (IOException ex) {
            System.out.println("Excepción al obtener el HTML de la página" + ex.getMessage());
        }

        return doc;

    }
}	
```

-----------------
-----------------

# Programación de comunicaciones en red:
 -	Comunicación entre aplicaciones.
 -	Roles cliente y servidor.
 -	Elementos de programación de aplicaciones en red. Librerías.
 -	Sockets.
 -	Creación de sockets.
 -	Enlazado y establecimiento de conexiones.
 -	Utilización de sockets para la transmisión y recepción de información.
 -	Programación de aplicaciones cliente y servidor.
 -	Utilización de hilos en la programación de aplicaciones en red.

------------------------

# Conexión TCP/IP
## Crear una comunicación entre un cliente en PowerShell de Windows y un servidor en Bash de Linux utilizando TCP/IP
https://www.jesusninoc.com/2017/10/26/crear-una-comunicacion-entre-un-cliente-en-powershell-de-windows-y-un-servidor-en-bash-de-linux-utilizando-tcpip/

## Establecer una dirección IPv6 para el interfaz Wi-Fi con PowerShell
https://www.jesusninoc.com/11/03/establecer-una-direccion-ipv6-para-el-interfaz-wi-fi-con-powershell/
