# Comentarios sobre la entrega
- Prácticas copiadas
- No se hace lo que hemos dicho
- Ideas posibles:
	- Guardar la información que da un proceso desde Java
	- Comunicar un proceso padre con hijo
	- Llamar a un programa creado en Linux
	- Crear una clase y llamarla desde Java
	- Realizar alguna automatización

-----------
-----------

# Programación de comunicaciones en red:
 -	Comunicación entre aplicaciones.
 -	Roles cliente y servidor.
 -	Elementos de programación de aplicaciones en red. Librerías.
 -	Sockets.
 -	Creación de sockets.
 -	Enlazado y establecimiento de conexiones.
 -	Utilización de sockets para la transmisión y recepción de información.
 -	Programación de aplicaciones cliente y servidor.
 -	Utilización de hilos en la programación de aplicaciones en red.

## URL
### Conectar con una URL en Java
https://www.jesusninoc.com/2012/09/21/conectar-con-una-url-en-java/
### Conectar con una URL en Java cambiando el User-Agent
https://www.jesusninoc.com/2012/10/01/conectar-con-una-url-en-java-cambiando-el-user-agent/
### Realizar petición HTTP mediante el método POST utilizando librerías de Apache
https://www.jesusninoc.com/2016/01/26/realizar-peticion-http-utilizando-el-metodo-post-utilizando-librerias-de-apache/
### Petición a una página web con URL
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejemplo3.java
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejemplo3b.java
* https://github.com/javierinformatica/PSP/blob/master/Ejemplos/src/Red/Ejemplo5.java

---------

## Peticiones a servidores (GET, POST, fuerza bruta)

### Introducción
```
GetPost/postindex.php
GetPost/getindex.php
GetPost/examplepost.php
GetPost/exampleget.php
JavaScript/jh.html
JavaScript/sjh.html
JavaScript/ssjh.html
UserAgent/useragentindex.php
FuerzaBruta/index.php
FuerzaBruta/postraw.php
```

### Códigos sobre fuerza bruta
* https://github.com/jesusninoc/Seguridad/tree/master/GetPost
* https://github.com/jesusninoc/Seguridad/tree/master/FuerzaBruta
* https://github.com/jesusninoc/ClasesSeguridad/blob/master/2019-02-21.md
* https://github.com/jesusninoc/ClasesSeguridad/blob/master/2019-02-25.md
* https://github.com/jesusninoc/ClasesSeguridad/blob/master/2018-01-11.md

-------------------------

## Entender variables en GET y POST

### APAGAR Y ENCENDER EL ENCHUFE INTELIGENTE TP-LINK WI-FI HS100 DESDE POWERSHELL
* https://www.jesusninoc.com/11/25/apagar-y-encender-el-enchufe-inteligente-tp-link-wi-fi-hs100-desde-powershell/

### Enviar un formulario de contacto de WordPress desde PowerShell
* https://www.jesusninoc.com/10/10/enviar-un-formulario-de-contacto-de-wordpress-desde-powershell/

### Realizar petición HTTP desde PowerShell utilizando el método GET
* https://www.jesusninoc.com/03/31/realizar-peticion-http-desde-powershell-utilizando-el-metodo-get/

### Método GET en PHP desde PowerShell
* https://www.jesusninoc.com/03/04/metodo-get-en-php-desde-powershell/

### Realizar petición HTTP utilizando el método POST
* https://www.jesusninoc.com/12/09/realizar-peticion-http-utilizando-el-metodo-post/

### Realizar petición HTTP utilizando el método POST con Burp
* https://www.jesusninoc.com/12/12/realizar-peticion-http-utilizando-el-metodo-post-con-burp-suite/

### Enviar datos a un formulario de Google Docs desde PowerShell
* https://www.jesusninoc.com/04/30/enviar-datos-a-un-formulario-de-google-docs-desde-powershell-deducir-los-parametros-que-se-envian-por-post/

### Acceder a los datos publicados en un formulario de Google desde PowerShell
* https://www.jesusninoc.com/05/01/acceder-a-los-datos-publicados-en-un-formulario-de-google-desde-powershell/


-------------------------

## URL (GET y POST)

### Petición GET en Java
```Java
import java.io.*;
import java.net.*;

public class Ejemplo4 {
	public static void main(String[] args) {
		try {
			URL url = new URL("http://localhost:89/getypost/exampleget.php?nombre=Hello+World!&edad=23");
			URLConnection conexion = url.openConnection();
			// LEER DE LA URL
			BufferedReader reader = new BufferedReader(new InputStreamReader(conexion.getInputStream()));
			String linea;
			while ((linea = reader.readLine()) != null) {
				System.out.println(linea);
			}
			reader.close();// cerrar flujo
		} catch (MalformedURLException me) {
			System.err.println("MalformedURLException: " + me);
		} catch (IOException ioe) {
			System.err.println("IOException:  " + ioe);
		}
	}// main
}
```

### Petición POST en Java
```Java
import java.net.*;
import java.io.*;
import java.util.*;

public class ejemplo5 {
	public static void main(String[] args){
	try
	{
		String data = "nombre=Hello+World!&edad=23";
		URL url = new URL("http://localhost:89/getypost/examplepost.php");
		HttpURLConnection con = (HttpURLConnection) url.openConnection();
		con.setRequestMethod("POST");
		con.setDoOutput(true);
		con.getOutputStream().write(data.getBytes("UTF-8"));
		
		BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
		String linea;
		while ((linea = reader.readLine()) != null) {
			System.out.println(linea);
		}
		reader.close();// cerrar flujo

		} catch (MalformedURLException me) {
			System.err.println("MalformedURLException: " + me);
		} catch (IOException ioe) {
			System.err.println("IOException:  " + ioe);
		}
	}
}
```
