# Ejemplo introducción
- Carrera de tortuga y liebre

--------------
--------------

# Programación multihilo:
 -	Recursos compartidos por los hilos.
 -	Estados de un hilo. Cambios de estado.
 -	Elementos relacionados con la programación de hilos. Librerías y clases.
 -	Gestión de hilos.
 -	Sincronización de hilos.
 -	Compartición de información entre hilos.
 -	Programación de aplicaciones multihilo.

--------------

# Java

## Java Thread: notify() and wait() examples
https://www.programcreek.com/2009/02/notify-and-wait-example/
https://www.tutorialspoint.com/java/java_thread_synchronization.htm

--------------

# C
## Uso de threads en C
https://www.driverlandia.com/programacion-c-avanzada-t3-uso-de-threads-en-c/

## How to include the command “wget” on my C source code?
https://stackoverflow.com/questions/15337932/how-to-include-the-command-wget-on-my-c-source-code
```C
#include <stdio.h>
#define BUFFLEN 2500

int main()
{
 char web_address[BUFFLEN] = "www.google.com"; 
 system("wget 'web_address' "); 
 return 0;
}
```

--------------

# Windows
## Win32_Thread class
https://msdn.microsoft.com/en-us/library/aa394494(v=vs.85).aspx

--------------

# WordPress
## Conocer la versión de un WordPress remotamente
https://www.jesusninoc.com/2016/01/23/conocer-la-version-de-un-wordpress-remotamente/

## WordPress to Android App using WP REST API Tutorial
https://www.simplifiedcoding.net/wordpress-to-android-app-tutorial/

--------------

# Google Dorks
## Obtener nuevos Google Dorks
http://www.jesusninoc.com/2015/12/01/obtener-nuevos-google-dorks/

```Google Dorks 
intext:"index of" .rar
intext:"index of" ".ZIP"
intext:"index of" "WHATSAPP"
intext:"index of" "backup"
intext:"index of" "Iphone"
intext:"index of" "WhatsApp"
```

----------------
----------------

# Programación multihilo:
 -	Recursos compartidos por los hilos.
 -	Estados de un hilo. Cambios de estado.
 -	Elementos relacionados con la programación de hilos. Librerías y clases.
 -	Gestión de hilos.
 -	Sincronización de hilos.
 -	Compartición de información entre hilos.
 -	Programación de aplicaciones multihilo.

# Existen dos técnicas para crear un thread:
- Heredar de la clase java.lang.Thread y sobrescribir el método run().
- Implementar el interfaz java.lang.Runnable (por tanto tenemos que implementar el método run() ) y crear una instancia de la clase java.lang.Thread pasándole el objeto que implementa java.lang.Runnable como parámetro.

# Ejemplo de creación de threads
```Java
public class TortugaThread extends Thread 
{
	public void run()
	{
		int i=0;
		System.out.println("Comienza la Tortuga.");
		while(i<5)
		{
			try
			{
				Thread.sleep(5000);
				System.out.println("Tortuga.");
			}
			catch(InterruptedException ex) 
			{
			}
			i++;
		}
		System.out.println("Termina la Tortuga.");
	}
}
```

```Java
public class LiebreThread implements Runnable
{
	public void run()
	{
		int i=0;
		System.out.println("Comienza la Liebre.");
		while(i<5)
		{
			try
			{
				Thread.sleep(2000);
				System.out.println("Liebre.");
			}
			catch(InterruptedException ex)
			{
			}
			i++;
		}
		System.out.println("Termina la Liebre.");
	}
}
```
```Java
public class Carrera
{
	public static void main(String[] args)
	{
		TortugaThread tortuga = new TortugaThread();
		Thread liebre = new Thread(new LiebreThread());
		tortuga.start();
		liebre.start();
	}
}
```

# Crear hilos extendiendo de la clase Thread
* https://github.com/mememiguelo/PSP/blob/master/JAVA/MultiHilos/PrimerHilo.java
* https://github.com/mememiguelo/PSP/blob/master/JAVA/MultiHilos/HiloEjemplo1.java
* https://github.com/mememiguelo/PSP/blob/master/JAVA/MultiHilos/HiloEjemplo1_V2.java
* https://github.com/mememiguelo/PSP/tree/master/JAVA/MultiHilos/TicTac

# Crear un reloj sencillo mediante la interfaz Runnable
https://github.com/mememiguelo/PSP/blob/master/JAVA/Interfaz%20Runnable/Reloj.java

# Ejemplo tablas multiplicar
## Hilo tabla multiplicar
```Java
public class Operaciones extends Thread {
	
	private Integer num;
	private int resultado;
	
	
	public Operaciones(Integer num) {
		this.num = num;
			}
	public void run() {
		System.out.println("Tabla de multiplicar del " +  num);
		System.out.println("===============================");
		try {
			for(int i=1;i<=10;i++) {
				resultado = num*i;
				System.out.println(num + " x " + i+"= "+ resultado);
			}
			System.out.println("Fin tabla del " + num);
		
	}catch(Exception ex) {}
}
}                                
```

## Programa principal
```Java

import java.util.Scanner;

public class Principal {

	public static void main(String[] args) {

		Scanner lector = new Scanner(System.in);

		System.out.println("Tablas de Multiplicar : ");
		int num1, num2, num3;

		System.out.print("Introduce el primer numero : ");
		num1 = lector.nextInt();
		System.out.print("Introduce el segundo numero : ");
		num2 = lector.nextInt();

		Operaciones op1 = new Operaciones(num1);
		Operaciones op2 = new Operaciones(num2);
		
		try {
			op1.start();
			op1.join();
			
			op2.start();
			op2.join();			
			
		} catch (InterruptedException e) {
			e.printStackTrace();
		}

	}

}
```
